//Copyright (c) 2023 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

RXgŏ̍sIs߂̍svvO悤ɂB
 ~ 


TODO: 
E AzL͖̎ߋ̃R[hėpĂB蒼ׂB
E Gs\[hL̑zN͍łV̂I邪A_ɂׂB
E 錾ILEGs\[hL̃p^[}b`ASY̏ڍ׎dlׂ͌B

*/



package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import javax.swing.text.StyledEditorKit.BoldAction;

import static tmm1.TMM3v9.PrimitiveAction.*;
import static tmm1.TMM3v9.Item.*;
import static tmm1.TMM3v9.Conj.*;
import static tmm1.TMM3v9.Time.*;
import static tmm1.TMM3v9.Area.*;
import static tmm1.TMM3v9.Verb.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v9 {
public static void main(String[] args) {
  Lab.addSelectableClass(TMM3v9.class);
  System.out.println(Lab.selectableClasses + "");

  LabCode labCode = new LabCode();
  labCode.main(AbstractMainCode.class);
}

//For debug.
public static void printArray(String s, Object[] a) {
  System.out.print(s+ ": ");
  for (int i = 0; i < a.length; i++) {
      System.out.print(a[i]+ ",");
  }
  System.out.println();
}

/**
* Primitive actions 
*/
public static enum PrimitiveAction {
  EatO1,
  MoveO1toO2,
  GoDir,
  GoToWithO1,
  GoToArea,
  GoToAreaWithO1,
  //
  ObsArea,
  ObsObj,
  Call,
  Return,
  Set,
  CallM,
  SetM,
  Recall,
  SayIt,
  Listen,
  Fail,
}
/**
*  Working memory layout definition
* 
*     |     A     |     B     |     E     |     V     |
*                 ^ WmIndex.B.head   
*      <---------> WmIndex.A.size
*      <-----------------------------------------------> WmIndex.size
*/
public static class WmIndex {
  public static final RegisterIndex A;
  //public static final RegisterIndex B;
  public static final RegisterIndex E;
  public static final VisualRegisterIndex V;
  public static final int size;
  static {
      int i = 0;
      A = new RegisterIndex(i); i += A.size;
      //B = new RegisterIndex(i); i += B.size;
      E = new RegisterIndex(i); i += E.size;
      V = new VisualRegisterIndex(i); i += V.size;
      size = i;
  }
  public static boolean printRawFlag = false;
  public static final String valuesToString(Object[] values) {
      if (values.length == WmIndex.size) {
          Object e = filledObject(values, 0, values.length);
          if (e != null) {
              return "w("+ e+ ")";
          } else {
              return "w("+ WmIndex.A.valuesToString(values, "a")+ " "+
                      WmIndex.E.valuesToString(values, "e")+ " "+
                      WmIndex.V.valuesToString(values)+
                      ")";
          }
      } else if (values.length == WmIndex.A.size) {
          return WmIndex.A.valuesToString(values, "r");
      } else if (values.length == WmIndex.size * 2) {
          Object[] s = new Object[WmIndex.size];
          Object[] g = new Object[WmIndex.size];
          for (int i = 0; i < s.length; i++) {
            s[i] = values[i];
            g[i] = values[i + WmIndex.size];
        }
          return "s("+ WmIndex.valuesToString(s)+ ") g("+ WmIndex.valuesToString(g)+ ")"; 
      } else {
          throw new Error("valuesToString: "+ values);
      }
  }
  public static final Object filledObject(Object[] values, int start, int end) {
      Object e = values[start];
      for (int i = start+1; i < end; i++) {
        if (values[i] != e) return null;
      }
      return e;
  }
  public static final String valuesToString(Object[] values, int start, int end) {
      Object e = WmIndex.filledObject(values, start, end);
      if (e != null) {
          return e.toString();
      } else {
          StringBuffer buf = new StringBuffer();
          buf.append(values[start]);
          for (int i = start+1; i < end; i++) {
              buf.append(' ');
              buf.append(values[i]);
          }
          return buf.toString();
      }
  }
}
public static class RegisterIndex {
  public final int head;
  public final int headerSize;
  public final int size;
  public final int Conj;
  public ClauseIndex C1; 
  public ClauseIndex C2; 
  public ClauseIndex C3; 
  public RegisterIndex(int offset) {
      head = offset;
      int i = 0;
      Conj = i;  i++;
      headerSize = i;
      C1 = new ClauseIndex(offset + i); i += C1.size;
      C2 = new ClauseIndex(offset + i); i += C2.size;
      C3 = new ClauseIndex(offset + i); i += C3.size;
      size = i;
  }
  public String valuesToString(Object[] values, String regName) {
      Object e = WmIndex.filledObject(values, head, head+size);
      if (e != null) {
          return regName+ "("+ e+ ")";
      } else {
          return regName+ "("+
                  values[Conj]+ " "+
                  this.C1.valuesToString(values, "c1")+ " "+
                  this.C2.valuesToString(values, "c2")+ " "+
                  this.C3.valuesToString(values, "c3")+
                  ")";
      }
  }
}
public static class ClauseIndex {
  public final int When, Where, Who, DoWhat, O1, O2;
  public final int head;
  public final int size;
  public ClauseIndex(int offset) {
      head = offset;
      int i = 0;
      When    = offset + i++; 
      Where   = offset + i++;
      Who     = offset + i++;
      DoWhat  = offset + i++;
      O1      = offset + i++;
      O2      = offset + i++;
      size = i;
  }
  public String valuesToString(Object[] values, String name) {
      return name+ "("+ WmIndex.valuesToString(values, head, head+size)+ ")";
  }
}
public static class VisualRegisterIndex {
  public final int head;
  public final int size;
  public final int When, Where, AgentWhat, AgentWhere, DoingWhat, O1What, O1Where, O2What, O2Where;  
  public VisualRegisterIndex(int offset) {
      head = offset;
      int i = 0;
      When = offset + i++;
      Where = offset + i++;
      AgentWhat = offset + i++;
      AgentWhere = offset + i++;
      DoingWhat = offset + i++;
      O1What = offset + i++;
      O1Where = offset + i++;
      O2What = offset + i++;
      O2Where = offset + i++;
      size = i;
  }
  public String valuesToString(Object[] values) {
      return "v("+ WmIndex.valuesToString(values, head, head+size)+ ")";
  }
}

//TODO: ΎɂׂB
public static enum Time {
  Today,
  Yesterday,
  Anytime,
  Now,
}
public static enum Item {
  Wall("\u58c1"),  // 
  //Stone(""), // 
  //Shell("<>"), // k
  //Nut("o "), // 
  //Grass("h"), // 
  Alice("`"),  // Fist generic agent.
  Bob("a"),  //  Second generic agent.
  Carol("b"),  //  Third generic agent.
  Stone(""), // 
  Shell("k"), // k
  Nut(""), // 
  Grass(""), // 
  Scissors(""), // 
  //Meat(""), // 
  Nothing(""), // 
  Wh("Wh"), // wh-word for questions
  Space("E"); // E

  public final String code;
  private Item(String code){
      this.code = code;
  }
}
public static enum Conj {
  Simple,
  SaysThat,
  And,
  While,
  If,
  ThatO1,
  ThatO2,
  Achieves,
  Causes,  
}
public static enum Verb {
  Is,
  Has,
  Eats,
  IsLookingAt,
  Thanks,
  Knows,
  Exists,
  WantsToSayTo,
  SaidTo,
  BroughO1FromO2,
  TaskCompleted,
}
public static class Area {
  public String name;
  public Area(String name) {
      this.name = name;
  }
  public static String North = "North".intern();
  public static String East = "East".intern();
  public static String West = "West".intern();
  public static String South = "South".intern();
  public static String[] directions = new String[]{North, East, West, South}; 
  //
  public static Area Room1 = new Area("Room1");
  public static Area Room2 = new Area("Room2");
  public static Area Room3 = new Area("Room3");
  public static Area Room4 = new Area("Room4");
  public static Area Room5 = new Area("Room5");
  
  public static Area Bathroom = new Area("Bathroom");
  public static Area Kitchen = new Area("Kitchen");
  public static Area Bedroom = new Area("Bedroom");
  public static Area Closet = new Area("Closet");
  public static Area LivingRoom = new Area("LivingRoom");
  public static Area GuestRoom = new Area("GuestRoom");
  public static Area Garage = new Area("Garage");
  public static Area Entrance = new Area("Entrance");
  public static Area Garden = new Area("Garden");
  
  public static Area Here = new Area("Here");
  public static Area Anywhere = new Area("Anywhere");
  public String toString() {
      return name;
  }
}

//Abstract syntax nodes for DSL
public static class ClauseN {
  public Object when, where, who, doWhat, o0, o1;
  public ClauseN(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      this.when = when;
      this.where = where;
      this.who = who;
      this.doWhat = doWhat;
      this.o0 = o0;
      this.o1 = o1;
  }
  public Object[] transN() {
      return new Object[] { when, where, who, doWhat, o0, o1 };
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("c(");
      buf.append(""+ when); buf.append(", ");
      buf.append(""+ where); buf.append(", ");
      buf.append(""+ doWhat); buf.append(", ");
      buf.append(""+ o0); buf.append(", ");
      buf.append(""+ o1);
      buf.append(")");
      return buf.toString();
  }
}
public static class RegisterN {
  public String regName;
  public Object conj;
  public ClauseN c1, c2, c3; 
  public RegisterN(String regName, Object conj, ClauseN c0, ClauseN c1) {
      this.regName = regName; this.conj = conj; this.c1 = c0; this.c2 = c1; this.c3 = null;
  }
  public RegisterN(String regName, Object conj, ClauseN c0, ClauseN c1, ClauseN c2) {
      this.regName = regName; this.conj = conj; this.c1 = c0; this.c2 = c1; this.c3 = c2;
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { 
              conj == null ? 0 : conj, 
                      c1 == null ? zeroV() : c1.transN(), 
                              c2 == null ? zeroV() : c2.transN(), 
                                      c3 == null ? zeroV() : c3.transN() 
      };
  }
  public Object[] zeroV() {
      Object[] ret = new Object[WmIndex.A.C1.size]; // Assumes all clauses have the same length.
      for (int i = 0; i < ret.length; i++) {
          ret[i] = 0;
      }
      return ret;
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append(regName+ "(");
      buf.append(""+ conj); buf.append(", ");
      buf.append(""+ c1); buf.append(", ");
      buf.append(""+ c2);
      buf.append(")");
      return buf.toString();
  }
}
public static class VisualRegisterN {
  public Object when, where, aWhat,aWhere,doingWhat,o1What,o1Where,o2What,o2Where;
  public VisualRegisterN( 
          Object when, Object where,
          Object aWhat, Object aWhere, Object doingWhat,
          Object o1What, Object o1Where, Object o2What, Object o2Where) {
      this.when = when; this.where = where;
      this.aWhat = aWhat; this.aWhere = aWhere; this.doingWhat = doingWhat;
      this.o1What = o1What; this.o1Where = o1Where;this.o2What = o2What; this.o2Where = o2Where; 
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { when,where,aWhat,aWhere,doingWhat,o1What,o1Where,o2What,o2Where };
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("v(");
      buf.append(""+ when); buf.append(", ");
      buf.append(""+ where); buf.append(", ");
      buf.append(""+ aWhat); buf.append(", ");
      buf.append(""+ aWhere); buf.append(", ");
      buf.append(""+ doingWhat); buf.append(", ");
      buf.append(""+ o1What); buf.append(", ");
      buf.append(""+ o1Where); buf.append(", ");
      buf.append(""+ o2What); buf.append(", ");
      buf.append(""+ o2Where);
      buf.append(")");
      return buf.toString();
  }
}
public static class StateN {
  public RegisterN a, b, e;
  public VisualRegisterN v;
  //  public SentenceN s;
  public StateN(RegisterN a, RegisterN b, RegisterN e, VisualRegisterN v) { 
      this.a = a; this.b = b; this.e = e; this.v = v; 
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { 
              a == null ? defaultV(defaultValue) : a.transN(defaultValue),
                      //b == null ? defaultV(defaultValue) : b.transN(defaultValue),
                              e == null ? defaultV(defaultValue) : e.transN(defaultValue),
                                      v == null ? defaultVv(defaultValue) : v.transN(defaultValue)
      };    
  }
  public Object[] defaultV(Object defaultValue) {
      Object[] ret = new Object[WmIndex.A.size]; // Normal register.
      for (int i = 0; i < ret.length; i++) {
          ret[i] = defaultValue;
      }
      return ret;
  }
  public Object[] defaultVv(Object defaultValue) {
      Object[] ret = new Object[WmIndex.V.size]; // v resister.
      for (int i = 0; i < ret.length; i++) {
          ret[i] = defaultValue;
      }
      return ret;
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("s(");
      buf.append(""+ a); buf.append(", ");
      buf.append(""+ b); buf.append(", ");
      buf.append(""+ e); buf.append(", ");
      buf.append(""+ v);
      buf.append(")");
      return buf.toString();
  }
}
public static class RuleN {
  public String name;
  public StateN s, g;
  public ActionN a;
  public RuleN(String name, StateN s, StateN g, ActionN a){ 
      this.name = name; this.s = s; this.g = g; this.a = a;
  }
  public String toString(){
      return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
  }
}
public static class ActionN {
  public PrimitiveAction a;
  public StateN m; // Arguments of the primitive action.
  public ActionN(PrimitiveAction a, StateN m){ 
      this.a = a; this.m = m;
  }
  public String toString(){
      if (m == null){
          return a.toString();
      } else {
          return a.toString()+ "("+ m+ ")";
      }
  }
}
/**
* pattern variable 
*/
public static class VariableN {
  public String name;
  public VariableN(String name){ this.name = name; }
}
//public static class UnionN {
//public StateN[] args;
//public UnionN(StateN... args){ this.args = args; }
//}

//--------------------------------------------------
/**
* Q(s,g,a) 𒊏ۉ[B
* lxNgƃp^[}b`đIB 
* Usage:
*   r = new Rule(ruleN);
*   boolean matched = r.match(vals);
*   if (matched){
*      // Access to the last matching results.
*      Action a = r.getAction();
*      State s = new State(r.getActionParam());
*   }
*/
public static class Rule {
  /**
   * Q value of this rule.
   */
  public float q;
  /**
   *  Rule name. Used for debug.
   */
  public String name;
  /**
   * Counter for demo.
   */
  public int useCounter = 0;
  /**
   * Number of variables appeared in this Rule.
   */
  public int numVars;
  // \ȃIuWFNgB
  public static final String UNBOUND = "__UNBOUND__";
  // p^[}b`IɖϐɑftHglB
  // O̒lɂ̂݃}b`B
  public static final String PLS = "PLS".intern();
  // [LO̒l̕ێB
  public static final String KEEP = "=".intern();
  // ChJ[hBCӂ̒lƃ}b`B
  public static final String WILDCARD = "__".intern(); // Two underscores.
  // 萔 0
  public static final Integer ZERO = 0; 
  public Object[] env;
  public Object[] patternVec; // Concatenated pattern of s and g.
  public PrimitiveAction action;
  public Object[] actionPatternVec;  // Pattern of m of action C_m.
  public int idCounter = 0;
  public Map<VariableN,PatternVariable> vmap = new HashMap<>();
  public RuleN ruleN; // for debug
  public Rule(RuleN ruleN){
      // ruleN ƂɃp^[\zB
      this.name = ruleN.name;
      this.ruleN = ruleN;
      List<Object> elems = transStateN(ruleN.s, WILDCARD);
      elems.addAll(transStateN(ruleN.g, WILDCARD));
      numVars = vmap.size() + 
              (int)elems.stream()
      .filter(e -> e == WILDCARD || e == PLS)
      .count();
      patternVec = elems.toArray();
      action = ruleN.a.a;
      if (ruleN.a.m == null) {
          // It is primitive action.
          actionPatternVec = null;
      } else if (action == PrimitiveAction.Set || action == PrimitiveAction.SetM){
          actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.SetA){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.SetB){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.Add){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
      } else {
          actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
      }
      env = new Object[vmap.size()];
      vmap = null;
  }
  public Rule(){
      // Implicitly called from ReturnRule().
  }
  // q̗Œ蒷̃[LO̗vfɕϊB
  // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
  public List<Object> transStateN(StateN state, Object defaultValue){
      Object[] sa = flatten(state.transN(defaultValue));

//      System.out.println("transStateN:");
//      System.out.println("state="+ state);
//      printArray("state.transN", state.transN(defaultValue));
//      printArray("state.transN 0", (Object[])(state.transN(defaultValue))[0]);
//      printArray("sa", sa);
//      System.out.println("sa.length:"+ sa.length);
//      System.out.println("wm size: "+ WmIndex.size);
      Lab.assertTrue(sa.length == WmIndex.size);

      Object[] arr = new Object[WmIndex.size];
      for (int i = 0; i < sa.length; i++) {
          Lab.assertTrue(sa[i] != null);
          arr[i] = transArg(sa[i]);
      }
      List<Object> ret = new ArrayList<>();
      ret.addAll(Arrays.asList(arr));
      if (false) {
          System.out.println("transStateN: default="+ defaultValue+ " : "+ state);
          System.out.println(" "+ ret);
      }
      return ret;
  }
  private static void flattenTest() {
      Object[] a = {1,2,3};
      Object[] b = {4,a,5,6};
      Object[][] c = {a,{7,8},{},{9},b};
      Object[] d = {};
      Object[] nested = {c,d,a,b,d};
      System.out.println("flatten test:");
      Object[] flat = flatten(nested);
      for (int i = 0; i < flat.length; i++) {
          //System.out.println(i+ ":"+ flat[i]);
          System.out.print(flat[i]+ " ");
      }
      System.out.println();
  }
  public static Object[] flatten(Object[] nested) {
      Vector<Object> v = new Vector<>();
      for (int i = 0; i < nested.length; i++) {
          if (nested[i] instanceof Object[]) {
              Object[] a = flatten((Object[])nested[i]);
              for (int j = 0; j < a.length; j++) {
                  v.add(a[j]);
              }
          } else {
              v.add(nested[i]);
          }
      }
      return v.toArray(); 
  }
  // q̈Bϐɓ id  PatternVariable 蓖ĂB
  public Object transArg(Object e) {
      Object re;
      if (e instanceof String) {
          e = ((String)e).intern();
      }
      if (e == WILDCARD){
          re = e;
      } else if (e instanceof VariableN){
          if (vmap.containsKey(e)){
              re = vmap.get(e);
          } else {
              re = new PatternVariable(((VariableN)e).name,
                      idCounter++);
              vmap.put((VariableN)e, (PatternVariable)re);
          }
      } else if (e instanceof Integer){
          int i = (Integer)e;
          // Accepts only small integers that can be compared with == operator.
          Lab.assertTrue( -128 <= i && i <= 127); 
          re = e;
      } else {
          re = e;
      }
      return re;
  }
  // TODO: t@N^O\Bϐ蓖ĂŏɂB
  public boolean ruleMatch(Object[] vals){
      Lab.assertTrue(vals.length == patternVec.length);
      for (int i = 0; i < env.length; i++) {
          env[i] = UNBOUND;
      }
      for (int i = 0; i < vals.length; i++) {
          //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
          Lab.assertTrue(vals[i] != KEEP);
          Lab.assertTrue(patternVec[i] != KEEP);
          if (patternVec[i] == WILDCARD){
              // Do nothing.
          } else if (patternVec[i] == PLS){
              if (vals[i] == ZERO) return false;
              //if (vals[i] == WILDCARD) return false;
          } else {
              Object pval;
              if (patternVec[i] instanceof PatternVariable){
                  int id = ((PatternVariable)patternVec[i]).id;
                  if (env[id] == UNBOUND && vals[i] != WILDCARD){
                      pval = env[id] = vals[i];
                  } else {
                      pval = env[id];
                  }
                  //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                  //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                  //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
              } else {
                  pval = patternVec[i];
              }
              // pval ͕ϐ蓖čς݂̃p^[̒lB
              // pval ̕ vals[i] LȂ return false B
              if (pval == WILDCARD){
                  System.out.println("this="+ this);
                  Lab.assertTrue(false);
              } else if (pval == UNBOUND){
                  // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                  Lab.assertTrue(vals[i] == WILDCARD);
                  // XXX: ̂悤ȏł悢̂낤H
              } else if (pval == PLS){
                  if (vals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else {
                  if (vals[i] != pval) return false;
              }
          }
          //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
          //for (int j = 0; j < env.length; j++) {
          //    System.out.println("env["+ j+ "]="+ env[j]);
          //}
      }
      //System.out.println("*** match ****");
      return true;
  }
  // ӖLp̃p^[}b`\bhB
  // ܂ŎbŎBdl͍B
  // TODO: p^[ 0 ̂ƂɔCӂ̃L[̒lƃ}b`悤ɂׂB ͂߁B
  public boolean knowledgeMatch(Object[] qvals){
      Lab.assertTrue(qvals.length == patternVec.length);
      for (int i = 0; i < env.length; i++) {
          env[i] = UNBOUND;
      }
      for (int i = 0; i < qvals.length; i++) {
          //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
          Lab.assertTrue(qvals[i] != KEEP);
          Lab.assertTrue(patternVec[i] != KEEP);
          if (patternVec[i] == WILDCARD){
              //Lab.assertTrue(false); // not implemented
              // Not implemented and do nothing so far.
          } else if (patternVec[i] == PLS){
              Lab.assertTrue(false); // not implemented
              if (qvals[i] == ZERO) return false;
              //if (vals[i] == WILDCARD) return false;
          } else if (patternVec[i] == ZERO){
              //Lab.assertTrue(false); // not implemented
              // Not implemented and do nothing so far.
          } else {
              Object pval;
              if (patternVec[i] instanceof PatternVariable){
                  int id = ((PatternVariable)patternVec[i]).id;
                  if (env[id] == UNBOUND && qvals[i] != WILDCARD){
                      pval = env[id] = qvals[i];
                  } else {
                      pval = env[id];
                  }
                  //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                  //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                  //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
              } else {
                  pval = patternVec[i];
              }
              // pval ͕ϐ蓖čς݂̃p^[̒lB
              // pval ̕ vals[i] LȂ return false B
              if (pval == WILDCARD){
                  System.out.println("this="+ this);
                  Lab.assertTrue(false);
              } else if (pval == UNBOUND){
                  // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                  Lab.assertTrue(qvals[i] == WILDCARD);
                  // XXX: ̂悤ȏł悢̂낤H
              } else if (pval == PLS){
                  if (qvals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else {
                  // p^[ʂ̒lAL[ 0, WILDCARD, PLS ̏ꍇ̓}b`B
                  if (qvals[i] == ZERO || qvals[i] == WILDCARD || qvals[i] == PLS) {
                      // Do nothing.
                  } else {
                      if (qvals[i] != pval) return false; 
                  }
              }
          }
          //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
          //for (int j = 0; j < env.length; j++) {
          //    System.out.println("env["+ j+ "]="+ env[j]);
          //}
      }
      //System.out.println("*** match ****");
      return true;
  }
  public PrimitiveAction getAction(){
      return action;
  }
  // p^[}b`́ul̃xNgvoBO match ɂϐ蓖ĂpB
  public Object[] getActionParam(){
      Object[] ret = actionPatternVec.clone();
      for (int i = 0; i < ret.length; i++) {
          if (ret[i] == WILDCARD){
              // ret[i] = WILDCARD;
          } else if (ret[i] instanceof PatternVariable){
              int id = ((PatternVariable)actionPatternVec[i]).id;
              if (env[id] == UNBOUND){
                  //System.out.println("???:"+ this);
                  //System.out.println("???: var="+ ret[i]+ ",id="+ id);
                  throw new Error("UNBOUND in action param : "+ this);
              } else {
                  ret[i] = env[id];
              }
          }
      }
      return ret;
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      {
          Lab.assertTrue(patternVec.length == WmIndex.size * 2);
          buf.append(name);
          buf.append(":");
          buf.append("rule(");
          buf.append(WmIndex.valuesToString(patternVec));
          buf.append(" ");
          if (actionPatternVec != null){
              Lab.assertTrue(actionPatternVec.length == WmIndex.size);
              buf.append(action+ " ");
              buf.append(WmIndex.valuesToString(actionPatternVec));
          } else {
              buf.append(action+ "");
          }
          buf.append("):"+ q);
      }
      if (WmIndex.printRawFlag) {
          Lab.assertTrue(patternVec.length % 2 == 0);
          int stateLength = patternVec.length / 2;
          buf.append(name);
          buf.append(":");
          buf.append("rule((");
          for (int i = 0; i < stateLength; i++) {
              buf.append(patternVec[i]+ ",");
          }
          buf.append("), (");
          for (int i = 0; i < stateLength; i++) {
              buf.append(patternVec[stateLength + i]+ ",");
          }
          buf.append("), ");
          if (actionPatternVec != null){
              buf.append(action+ "(");
              for (int i = 0; i < actionPatternVec.length; i++) {
                  buf.append(actionPatternVec[i]+ ",");
              }
              buf.append(")");
          } else {
              buf.append(action+ "");
          }
          buf.append("):"+ q);
      }
      return buf.toString();
  }
  public static class PatternVariable {
      String name;
      int id;
      public PatternVariable(String name, int id){ 
          this.name = name; this.id = id; 
      }
      //public String toString() { return ""+ id+ ":"+ name; }
      public String toString() { return ""+ name; }
  }
  // Special instance used for Action.Return
  public static final Rule returnRule = new ReturnRule();
  // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
  //   ReturnRule ̃CX^X𖳗gĂB
  public static State makeState(StateN stateN, Object defaultValue) {
      return new State(returnRule.transStateN(stateN, defaultValue).toArray());
  }
}
public static class ReturnRule extends Rule {
  public ReturnRule(){
      action = PrimitiveAction.Return;
      q = 0; // Q(g,g,RET) == 0
  }
  public String toString(){
      return "rule(Return).q = "+ q;
  }
}
/**
* Q(s,g,call(m))  s, g, m \邽߂̃f[^\B
*/
public static class State {
  public Object[] values;
  public State(Object[] values) { this.values = values; }
  //public Object[] getVec(){
  //    return values;
  //}
  /**
   * Compares two states in order to check if the agent reaches 
   * the subgoal state g. 
   * State g may contain the special values: PLS and/or WILDCARD. 
   */
  public boolean satisfies(State g){
      Object[] gv = g.values;
      Lab.assertTrue(values.length == gv.length);
      for (int i = 0; i < gv.length; i++) {
          if (gv[i] == Rule.PLS){
              if (values[i] == Rule.ZERO) return false;
              if (values[i] == Rule.WILDCARD) return false;
          } else if (gv[i] == Rule.WILDCARD){
              // Do nothing.
          } else {
              if (values[i] != gv[i]) return false;
          }
      }
      return true;
  }
  /**
   * Gs\[hL̂߂̃}b`OB
   * query Ɋ܂܂ĂqꂪׂĊ܂܂ĂȂ true ԂB
   * TODO: L[Ώۂ State ł͂ȂCxgɕύXB
   */
  public boolean episodeMatch(State query) {
      Object[] qv = query.values;
      //printArray("episodeMatch: query", kv);
      //printArray("episodeMatch: state", values);
      Lab.assertTrue(values.length == qv.length);
      for (int i = 0; i < qv.length; i++) {
          if (qv[i] == Rule.PLS){
              if (values[i] == Rule.ZERO) return false;
              if (values[i] == Rule.WILDCARD) return false;
          } else if (qv[i] == Rule.WILDCARD){
              // Do nothing.
          } else {
              if (values[i] != qv[i]) return false;
          }
      }
      return true;

  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      {      
          buf.append(WmIndex.valuesToString(values));
      }
      if (WmIndex.printRawFlag) {
          buf.append("State(");
          for (int i = 0; i < values.length; i++) {
              buf.append(values[i].toString());
              buf.append(",");
          }
          buf.append(")");
      }
      return buf.toString();
  }


  public Object get(int index) { 
      return values[index]; 
  }
  // State  n Ԗڂ̗vf𐮐ɂĕԂB̏ꍇ -1 ԂB
  public int getInt(int n) {
      Object x = values[n];
      if (x instanceof Integer) {
          return ((Integer)x).intValue();
      } else {
          return -1;
      }
  }
  public void set(int index, Object x) { 
      values[index] = x;
  }
  public void clear(RegisterIndex r) {
      for (int i = 0; i < r.size; i++) {
          values[r.head + i] = 0;
      }
  }
  /** v WX^ When, Where ȊÕXbg 0 ɂB */
  public void clearVregister() {
      this.set(WmIndex.V.AgentWhat, 0);
      this.set(WmIndex.V.AgentWhere, 0);
      this.set(WmIndex.V.O1What, 0);
      this.set(WmIndex.V.O1Where, 0);
      this.set(WmIndex.V.O2What, 0);
      this.set(WmIndex.V.O2Where, 0);
  }
}
/**
* Agent  takeAction ̏ĂrŃANV fail Ƃ throw B  
*
*/
public static class Fail extends Exception {}


//--------------------------------------------------
public static abstract class AbstractMainCode extends Lab.MainCode {
  //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
  public int maxSteps = panel.getInt("max steps", 1000, 1, 10000);
  public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
  public float rewardC = panel.getFloat("R^C", -1, -10, 0);
  //public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
  //public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
  public int mapSizeX;
  public int mapSizeY;
  public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
  public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
  public float vScale; 
  public lab.Lab.WTextArea qView = null;
  public AbstractMainCode mainCode = this; // Main ZN^őIB
  public World world;

  public void main() {
      world = new World();
      world.init();
      world.main();
  }

  public class Agent {
      public State newS; // state
      public State newG; // subgoal
      public Rule newR; // rule 
      public State oldS;
      public State oldG;
      public Rule oldR;
      public State actionParamState; 
      public float reward;
      public Stack<State> stack;
      public State start, goal;
      public boolean failedFlag;
      public float stackValue;
      public State failedState;
      //
      public World world;
      public Area currentArea;
      public int energy;
      //public int currentPos;
      public Item agentItem; // Item that represents the agent itself.
      public List<Rule> rules;
      public List<Rule> knowledgeBase;
      public State sentenceBuf;
      //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
      public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
      //
      public Agent(Item selfItem, World world){
          this.agentItem = selfItem;
          this.world = world;
          this.currentArea = Here; // Dummy
      }
      public void setDefaultStartAndGoal(){
          State s = Rule.makeState(w(), Rule.ZERO);
          State g = Rule.makeState(w(a(Verb.TaskCompleted)), Rule.WILDCARD);
          knowledgeBase = List.copyOf(knowledgeList);
          setStartAndGoal(s, g);
      }
      public void setStartAndGoal(State s, State g){
          oldS = newS = start = s;
          oldG = newG = goal = g;
          failedState = s;

          //System.out.println("setStartAndGoal: s="+ s);
          //System.out.println("setStartAndGoal: g="+ g);
          //System.out.println("s.satisfies(g)="+ s.satisfies(g));
      }
      public void chooseFirstAction(){
          stack = new Stack<State>();
          episodeMem = new ArrayList<State>();
          episodeMemLog("episodeList cleared.");
          sentenceBuf = null;
          chooseAction();
          oldR = newR;
      }
      // 
      public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
      public void takeAction(){
          PrimitiveAction action = oldR.getAction();
          failedFlag = false;
          episodeMemLog(oldR.toString());

          if (panel.flag("Action log", true)) {
              StringBuffer buf = new StringBuffer();
              // indent
              for (int i = 0; i < stack.size(); i++) {
                  buf.append("  ");
              }
              buf.append("c="+ world.counter+ ": rule "+ oldR.name+ ": ");
              buf.append(action.toString());
              if (action == PrimitiveAction.Return) {
                  buf.append(' ');
                  buf.append(oldS.toString());
              } else if (actionParamState != null) {
                  buf.append(" ");
                  buf.append(actionParamState);
                  if (WmIndex.printRawFlag) {
                      buf.append('(');
                      Object[] values = actionParamState.values;
                      if (values.length > 0) {
                          buf.append(values[0].toString());
                          for (int i = 1; i < values.length; i++) {
                              buf.append(',');
                              buf.append(values[i].toString());
                          }
                      }
                      buf.append(')');
                  }
              }
              env.viewPanel.println("Action log of "+ agentItem, buf.toString());
              if (panel.flag("Show sentenceBuf in action log", false)) {
                  env.viewPanel.println("Action log of "+ agentItem, 
                          "sentenceBuf="+ sentenceBuf);
              }
          }

          try { // catch (Fail)
              if (action == PrimitiveAction.Return){
                  newS = oldS;
                  newG = stack.pop();
                  reward = 0;

              } else if (action == PrimitiveAction.Call){
                  newS = oldS;
                  //newS.clear(WmIndex.A);
                  //newS.clear(WmIndex.E);
                  stack.push(oldG);
                  newG = actionParamState;
                  reward = rewardC;

              } else if (action == PrimitiveAction.CallM){
                // w肵mŐ錾Im̑zN݂B
                State pp = null;
//                if (Lab.irand(2) == 0) {
                if (panel.getFloat("recall when callM", 1f, 0f, 1f) > Lab.rand()) {
                    State query = getReg(WmIndex.A, actionParamState);
                    pp = doRecall(query);
                }
                if (pp == null) {
                    // Do call.
                    // 錾ILɌȂΕʂɃTu[`ĂяoB
                    newS = oldS;
                    //newS.clear(WmIndex.A);
                    //newS.clear(WmIndex.E);
                    stack.push(oldG);
                    newG = actionParamState;
                    reward = rewardC;
                } else {
                    episodeMemLog(" Cache hit: "+ pp);
                    newS = setReg(WmIndex.A, pp, oldS);
                    episodeMemLog(" newS="+ newS);
                    newG = oldG;
                    reward = rewardC;
                }          

              } else if (action == PrimitiveAction.Set){
                  // NOTE: Ώۂ a WX^̏ꍇ Set ł͂Ȃ SetM Ă΂B
                  newS = wmSet(actionParamState, oldS);
                  newG = oldG;
                  reward = rewardC;

              } else if (action == PrimitiveAction.SetM){
                  newS = wmSet(actionParamState, oldS);
                  rememberAreg(newS);
//                  State aReg = getReg(WmIndex.A, newS);
//                  episodeMem.add(0, aReg); // Insert to the top of the list.
//                  episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);
                  newG = oldG;
                  reward = rewardC;
                  
              } else if (action == PrimitiveAction.Recall){
                  State query = getReg(WmIndex.E, actionParamState);
                  State pp = doRecall(query);
                  if (pp == null) {
                      episodeMemLog(" Recall failed.");
                      throw new Fail();
                  } else {
                      newS = setReg(WmIndex.E, pp, oldS);
                      episodeMemLog(" newS="+ newS);
                      newG = oldG;
                      reward = rewardC;
                  }              

              } else if (action == PrimitiveAction.Fail){
                  throw new Fail();

              } else {
                  reward = rewardC;
                  newS = new State(oldS.values.clone());
                  takePrimitiveActionAndObserve();
                  newG = oldG;
              }

          } catch (Fail f) {
              if (panel.flag("Action log", true)) {
                  env.viewPanel.println("Action log of "+ agentItem, "Failed.");
              }                
              failedFlag = true;
              stackValue = evalStack(oldG, stack);
              //newS = failedState;
              newS.clear(WmIndex.A);
              newS.clear(WmIndex.E);
              newG = goal;
              stack.clear();
              //episodeMem.clear();  // ??
              reward = rewardC + failPenalty;
          }
          // KŌɌ݂̎Eꏊ̐lWX^ɐݒ
          newS.set(WmIndex.V.When, world.currentTime);
          newS.set(WmIndex.V.Where, currentArea);
      }
      public void chooseAction(){
          if (newS.satisfies(newG)){
              newR = Rule.returnRule;
              actionParamState = null;
          } else {
              List<Rule> matched = selectMatchedRules(newS, newG);

              //            matched.forEach(r -> {
              //                System.out.println("matched: "+ r);
              //                if (r.action == Action.Call || r.action == Action.Set) {
              //                    System.out.println("  a="+ r.action);
              //                    System.out.println("  m="+ new State(r.getActionParam()));
              //                }
              //            });

              float[] q = calcRulePriorities(matched);
              if (q.length == 0){
                  throw new Error("No action selected: (news,newG)="+ 
                          newS+ ", "+ newG);
              }
              // softmax  Rule PIB
              int index = softmax(q);
              if (panel.flag("Show matched rules", false)){
                  for (int i = 0; i < matched.size(); i++) {
                      env.viewPanel.println("matched "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ matched.get(i));
                  }
                  for (int i = 0; i < q.length; i++) {
                      env.viewPanel.println("priority "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ q[i]);
                  }
                  for (int i = 0; i < probTable.length; i++) {
                      env.viewPanel.println("probTable "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ probTable[i]);
                  }
              }
              newR = matched.get(index);
              if (newR.actionPatternVec == null) {
                  actionParamState = null;
              } else {
                  actionParamState = new State(newR.getActionParam());
              }
          }
      }
      public List<Rule> selectMatchedRules(State s, State g){
          // s,g ̒lzB
          Object[] vals = new Object[s.values.length + g.values.length];
          for (int i = 0; i < s.values.length; i++) {
              vals[i] = s.values[i];
          }
          for (int i = 0; i < g.values.length; i++) {
              vals[i + s.values.length] = g.values[i];
          }
          // (s,g) Ƀ}b`郋[IB
          // [̐ parallelStream gĂ݂B
          List<Rule> matched = rules.stream().filter(
                  r -> r.ruleMatch(vals)
                  ).collect(Collectors.toList());
          return matched;
      }
      public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
      public float[] calcRulePriorities(List<Rule> matched){
          float[] q = new float[matched.size()];
          for (int i = 0; i < q.length; i++) {
              Rule r = matched.get(i);
              // numVars ɉyieB^Bϐ̐Ȃ[DB
              float val = r.q - genericityPenalty * r.numVars;
              q[i] = val;
          }
          return q;
      }
      public void update() {
          if (oldR == Rule.returnRule){
              // Do nothing.
          } else if (failedFlag){
              float delta = reward + newR.q - oldR.q - stackValue;
              oldR.q += alpha * delta;
          } else {
              //q[oldS][oldA] += alpha * (reward + q[newS][newA] - q[oldS][oldA]);
              float vg; // V_g(g')
              if (oldG == newG){
                  vg = 0;
              } else {
                  vg = evalValue(oldG, newG);
              }
              //System.out.println(oldR+ ":vg="+vg);
              float delta;
              delta = reward + newR.q - oldR.q + vg;
              //System.out.println(delta);
              oldR.q += alpha * delta;
          }

          oldS = newS;
          oldG = newG;
          oldR = newR;
      }
      // Not tested enough.
      // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
      public float evalStack(State g, Stack<State> stack) {
          State ss = g;
          float ret = 0;
          for (int i = stack.size() - 1; i >= 0; i--) {
              //System.out.println("Stack!:"+ stack.get(i));
              State gg = stack.get(i);
              //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
              ret += evalValue(gg, ss);
              ss = gg;
          }
          //System.out.println("evalStack = "+ ret);
          return ret;
      }
      public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
      /** Returns V_g(s) */
      public float evalValue(State g, State s){
          List<Rule> matched = selectMatchedRules(s, g);
          float[] q = calcRulePriorities(matched);
          if (approxValueEvalFlag){
              // V_g(s) \approx max_a Q(s,g,a)
              int i = Lab.argmax(q); 
              return matched.get(i).q;
          } else {
              // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
              calcProbTable(q, 0, q.length);
              float val = 0;
              for (int i = 0; i < probTable.length; i++) {
                  // To avoid 0 * -Infinity = NaN
                  float value = matched.get(i).q;
                  if (value != Float.NEGATIVE_INFINITY){
                      val += probTable[i] * value;
                  }
              }
              return val; 
          }
      }


      // Softmax
      public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
      public int softmax(float[] q){ return softmax(q, 0, q.length); }
      public int softmax(float[] q, int from, int to){
          calcProbTable(q, from, to);
          //        System.out.println("probTable=");
          //        for (int i = 0; i < probTable.length; i++) {
          //            System.out.print(probTable[i]+ ", ");
          //        }
          //        System.out.println();
          float r = Lab.rand();
          double sum = 0;
          for (int i = from; i < to; i++){
              sum += probTable[i]; 
              if (sum > r) {
                  Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                  return i;
              }
          }
          Lab.assertTrue(sum - 0.001f < 1);
          Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
          return to - 1;
      }
      // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
      public void calcProbTable(float[] q, int from, int to){
          if (q.length != probTable.length){
              probTable = new double[q.length];
          }
          float max = Lab.max(q);
          double total = 0;
          for (int i = from; i < to; i++){
              // To avoid overflow, subtract max.
              // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
              double val = Math.exp(beta * (q[i] - max));
              probTable[i] = val;
              total += val;
              //             System.out.println("q["+ i+ "]="+ q[i]);
              //             System.out.println("val="+ val);
          }
          //        System.out.println("total="+ total);
          Lab.assertTrue(total > 0);
          for (int i = from; i < to; i++){
              probTable[i] /= total;
          }
      }

      public boolean achieved() {
          return stack.size() == 0 && newR.getAction() == PrimitiveAction.Return; 
      }
      /**
       * [LO̒lXVBvf̒l KEEP ̏ꍇ͂̑O̒lێB
       */
      public State wmSet(State setArg, State oldS) {
          Object[] oldv = oldS.values;
          Object[] newv = oldv.clone(); // Copy the other registers.
          Object[] argv = setArg.values;
          for (int i = 0; i < newv.length; i++) {
              if (argv[i] == Rule.KEEP) {
                  newv[i] = oldv[i];
              } else {
                  newv[i] = argv[i];
              }
          }
          return new State(newv);
      }
      /**
       * WX^̒loB
       */
      public State getReg(RegisterIndex reg, State oldS) {
          int regOffset = reg.head;
          int regSize = WmIndex.A.size; // Assumes all registers have the same size.
          Object[] oldv = oldS.values;
          Object[] propv = new Object[regSize];
          for (int i = 0; i < regSize; i++) {
              propv[i] = oldv[regOffset + i];
          }
          return new State(propv);
      }
      /**
       * WX^ɒlZbgBw肵WX^ȊO̒l͕ێB
       */
      public State setReg(RegisterIndex reg, State pprop, State oldS) {
          int regOffset = reg.head;
          Object[] oldv = oldS.values;
          Object[] newv = oldv.clone(); // Copy the other registers.
          Object[] propv = pprop.values;
          int regSize = WmIndex.A.size; // Assumes all registers have the same size.
          Lab.assertTrue(regSize == propv.length);
          for (int i = 0; i < regSize; i++) {
              newv[regOffset + i] = propv[i];
          }
          return new State(newv);
      }
//      /**
//       * [LOɏǉBĂꍇ fail B
//       */
//      public State wmAdd(State setArg, State oldS) {
//          final boolean alog = true;
//          System.err.println("wmAdd: not debugged yet!");
//          if (alog) {
//              System.out.println("wmAdd: s: "+ setArg);
//              System.out.println("wmAdd: o: "+ oldS);
//          }
//          Object[] prior = new Object[WmIndex.size];
//          for (int i = 0; i < prior.length; i++) {
//              if (setArg.values[i] == Rule.KEEP) {
//                  prior[i] = oldS.values[i];
//              } else {
//                  prior[i] = setArg.values[i];
//              }
//          }
//          if (alog) printArray("wmAdd: prior", prior);
//          Object[] likelihood = new Object[WmIndex.size];
//          if (alog) printArray("wmAdd: likelihood", likelihood);
//
//          // ̏q͖IɊϑȂĂIɒl set B
//          //Lab.assertTrue(setArg.get(Energy) == Rule.KEEP);
//          //Lab.assertTrue(setArg.get(Where) == Rule.KEEP);
//          //Lab.assertTrue(setArg.get(WmIndex.A.C0.Where) == Rule.KEEP); //??
//
//          Object[] belief = new Object[WmIndex.size];
//          // \ prior Ɗϑ likelihood ̖oꂽ fail B
//          for (int i = 0; i < belief.length; i++) {
//              if (prior[i] == Rule.WILDCARD) {
//                  belief[i] = likelihood[i];
//              } else if (prior[i] == Rule.PLS) {
//                  if (likelihood[i] == Rule.ZERO) {
//                      return null; // fail
//                  } else {
//                      belief[i] = likelihood[i];
//                  }
//              } else {
//                  if (likelihood[i] == null) {
//                      belief[i] = prior[i];
//                  } else if (likelihood[i] == prior[i]) {
//                      belief[i] = prior[i];
//                  } else {
//                      // likelihood[i] != prior[i]
//                      return null; // fail
//                  }
//              }
//          }
//          belief[WmIndex.A.C0.When] = Time.Now;
//          //belief[State.wmIndex(Reg.A, 0, Energy)] = energy;
//          belief[WmIndex.A.C0.Where] = currentArea;
//          if (alog) printArray("wmAdd: belief", belief);
//          for (int i = 0; i < belief.length; i++) {
//              if (belief[i] == null) {
//                  System.out.println("wmAdd: b["+ i+ "]="+ belief[i]); 
//                  Lab.assertTrue(false);
//              }
//          }
//
//          return new State(belief);
//      }

      public int getCurrentRoomID() {
          return roomNameToRoomId(currentArea);
      }
      public int roomNameToRoomId(Area roomName) {
          for (int i = 0; i < world.areas.length; i++) {
              //System.out.println("n="+ roomName+ ", a[i]="+ world.areas[i]);
              if (roomName == world.areas[i]) return i;
          }
          throw new Error("roomNameToRoomId : "+ roomName);
      }

      /**
       * }bv̒烉_ɂP̂IňʒuԂB 
       */
      public int findObjectFromMap() {
          // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
          // }bv̂̐̕𐔂B
          int c = 0;
          int roomID = getCurrentRoomID();
          for (int x = 1; x < roomSizeX; x++) {
              for (int y = 1; y < roomSizeY; y++) {
                  if (world.map[roomID][y * roomSizeX + x] != Space) {
                      c++;
                  }
              }
          }
          // _ r Ԗڂ̂̕IԁB
          int r = Lab.irand(c);
          c = 0;
          for (int x = 1; x < roomSizeX; x++) {
              for (int y = 1; y < roomSizeY; y++) {
                  if (world.map[roomID][y * roomSizeX + x] != Space) {
                      if (c++ == r) return y * roomSizeX + x;
                  }
              }
          }
          return -1; // Not found.
      }
      /**
       * }bv̒w肳ꂽ̂PTďꏊԂB
       * TB 
       */
      public int findItemFromTheRoom(Item item) {
          int roomID = getCurrentRoomID();
          for (int i = 0; i < world.map[roomID].length; i++) {
              if (world.map[roomID][i] == item) return i;
          }
          throw new Error("findItemFromMap: not found "+ item);
      }
      
      /**
       * ߂ꂽԂ̊ԃTuS[JԂؖAłl̍iRXgႢj a WX^ɃZbgB
       */
      public void argmax() {
          // ***  ***
          // XXX: C[vƂ͓Ɨ[vH
          // try KvH
      }

      /** ANV a.oldR sA a.newS ϑB
       * Vꍇ a.reward ̒lɉZB
       */
      public void takePrimitiveActionAndObserve() throws Fail {
          PrimitiveAction action = oldR.getAction();
          int roomID = getCurrentRoomID();
          //newS.set(WmIndex.A.C0.When, Time.Now);
          switch (action) {
          case EatO1: {
              // O1 HׂȂ炻 Leftovers ɕϊB
              // W̉ĂȂƂ́HƂ肠G[B
              // HׂȂƂ́HƂ肠G[B
              int x = newS.getInt(WmIndex.V.O1Where);
              if (x == -1) {
                  Lab.assertTrue(false);
              } else {
                  Object target = world.map[roomID][x];
                  if (target == Nut) {
                      world.map[roomID][x] = Space;
                      energy++;
                  } else {
                      Lab.assertTrue(false);
                  }
              }
              updateVreg();

              newS.clear(WmIndex.A);
//              for (int i = 0; i < WmIndex.A.size; i++) {
//                  newS.set(WmIndex.A.head + i, 0);
//              }
              newS.set(WmIndex.A.Conj, Conj.Simple);
              newS.set(WmIndex.A.C1.When, Now);
              newS.set(WmIndex.A.C1.Where, currentArea);
              newS.set(WmIndex.A.C1.Who, this.agentItem);
              newS.set(WmIndex.A.C1.DoWhat, Eats);
              newS.set(WmIndex.A.C1.O1, Nut);

              rememberAreg(newS);
          } break;
  
          case MoveO1toO2: {
              // O1  O2 ̏ꏊɈړAO1, O2 ͌`EʒuωB
              int x1 = newS.getInt(WmIndex.V.O1Where);
              int x2 = newS.getInt(WmIndex.V.O2Where);
              if (x1 == -1 || x2 == -1) {
                  Lab.assertTrue(false);
              } else if (x1 == 0 || x2 == 0) {
                  // Fail ׂH
                  Lab.assertTrue(false);
              } else {
                  Object item = world.map[roomID][x1];
                  Object target = world.map[roomID][x2];
                  if (target == Shell && item == Stone) {
                      world.map[roomID][x1] = Space;
                      world.map[roomID][x2] = Nut;
                  } else {
                      // Fail ׂH
                      Lab.assertTrue(false);
                  }
                  updateVreg();
                  world.vCommands.add(new VCommand(MoveO1toO2, item, roomID, roomID, x1, x2));
              }
          } break;
          
          case GoDir: {
              int argc = actionParamState.getInt(WmIndex.A.C1.head);
              Lab.assertTrue(argc == 1);
              String dir = (String)actionParamState.get(WmIndex.A.C1.head + 1);
              // ړvZB˂ꍇ݂͌̃GÂ܂܁B
              int newRoomID = neighborRoomID(roomID, dir);
              Area newAreaName = world.areas[newRoomID];
              // map ̍XVB
              int pos = findItemFromTheRoom(agentItem);
              int newPos = pos;
              if (roomID != newRoomID) {
                  world.map[roomID][pos] = Space;
                  currentArea = newAreaName;
                  newPos = putItemAtRandomPosInRoom(world.map[newRoomID], agentItem);
              }
              //
              observeArea();
//              newS.clear(WmIndex.A);
//              newS.set(WmIndex.A.Conj, Conj.Simple);
//              newS.set(WmIndex.A.C1.When, Now);
//              newS.set(WmIndex.A.C1.Where, currentArea);
//              newS.set(WmIndex.A.C1.Who, this.agentItem);
//              newS.set(WmIndex.A.C1.DoWhat, Exists);
//              newS.set(WmIndex.A.C1.O1, 0);
//              newS.set(WmIndex.A.C1.O2, 0);
//
//              newS.clearVregister();
              world.vCommands.add(new VCommand(GoDir, agentItem, roomID, newRoomID, pos, newPos));
          } break;

          case GoToArea: {
              int argc = actionParamState.getInt(WmIndex.A.C1.head);
              Lab.assertTrue(argc == 1);
              Area areaName = (Area)actionParamState.get(WmIndex.A.C1.head + 1);
              int newRoomID = roomNameToRoomId(areaName);
              // map ̍XVB
              int pos = findItemFromTheRoom(agentItem);
              world.map[roomID][pos] = Space;
              currentArea = areaName;
              int newPos = putItemAtRandomPosInRoom(world.map[newRoomID], agentItem);
              //
              observeArea();
//              newS.clear(WmIndex.A);
//              newS.set(WmIndex.A.Conj, Conj.Simple);
//              newS.set(WmIndex.A.C1.When, Now);
//              newS.set(WmIndex.A.C1.Where, currentArea);
//              newS.set(WmIndex.A.C1.Who, this.agentItem);
//              newS.set(WmIndex.A.C1.DoWhat, Exists);
//              newS.set(WmIndex.A.C1.O1, 0);
//              newS.set(WmIndex.A.C1.O2, 0);
//
//              newS.clearVregister();
              world.vCommands.add(new VCommand(GoDir, agentItem, roomID, newRoomID, pos, newPos));
          } break;

          case GoToAreaWithO1: {
              int argc = actionParamState.getInt(WmIndex.A.C1.head);
              Lab.assertTrue(argc == 1);
              Area oldAreaName = currentArea;
              Area areaName = (Area)actionParamState.get(WmIndex.A.C1.head + 1);
              int newRoomID = roomNameToRoomId(areaName);
              // map ̍XVB
              int pos = findItemFromTheRoom(agentItem);
              world.map[roomID][pos] = Space;
              currentArea = areaName;
              putItemAtRandomPosInRoom(world.map[newRoomID], agentItem);
              int newPos = findItemFromTheRoom(agentItem);
              // ̂P̈ړB
              int x1 = newS.getInt(WmIndex.V.O1Where);
              Item o1 = world.map[roomID][x1];
              world.map[roomID][x1] = Space;
              putItemAtRandomPosInRoom(world.map[newRoomID], o1);
              int newX1 = findItemFromTheRoom(o1);

              //
              newS.clear(WmIndex.A);
              newS.set(WmIndex.A.Conj, Conj.Simple);
              newS.set(WmIndex.A.C1.When, Now);
              newS.set(WmIndex.A.C1.Where, currentArea);
              newS.set(WmIndex.A.C1.Who, this.agentItem);
              newS.set(WmIndex.A.C1.DoWhat, BroughO1FromO2);
              newS.set(WmIndex.A.C1.O1, o1);
              newS.set(WmIndex.A.C1.O2, oldAreaName);

              rememberAreg(newS);

              newS.clearVregister();
              //newS.set(WmIndex.V.O1What, 0);
              //newS.set(WmIndex.V.O1Where, 0);
              world.vCommands.add(new VCommand(GoDir, agentItem, roomID, newRoomID, pos, newPos));
              world.vCommands.add(new VCommand(MoveO1toO2, o1, roomID, newRoomID, x1, newX1));
          } break;
          
          case ObsArea : {
              observeArea();
          } break;
          
          case ObsObj : {
              observeObj(actionParamState);
          } break;

          case Listen : {
              if (sentenceBuf != null) {
                  // obt@̒g a WX^ɏށB
                  for (int i = 0; i < WmIndex.A.size; i++) {
                      newS.set(WmIndex.A.head + i, 
                              sentenceBuf.get(WmIndex.A.head + i));
                  }
                  // TODO: a WX^̒gGs\[hLɓB 
                  if (panel.flag("Show sentenceBuf in action log")) {
                      env.viewPanel.println("Action log of "+ agentItem, 
                              "Listen: sentenceBuf="+ sentenceBuf);
                  }           
                  // obt@͋ɂB
                  sentenceBuf = null;
              } else {
                  // Do nothing. Just listen to new utterance.
              }
          } break;
          
          case SayIt : {
              // a WX^̏ԃ`FbNBԈĂ΃G[bZ[Wo Fail B
              // TODOF ƂƎB
              Lab.assertTrue(oldS.get(WmIndex.A.C1.DoWhat) == WantsToSayTo);

              // B
              Object targetName = oldS.get(WmIndex.A.C1.O1);
              Agent a = world.findAgent(targetName);
              if (a == null) {
                  throw new Error("SayIt: targetName "+ targetName+ " does not exist.");
              }
              if (a.sentenceBuf == null) {
                  // be𑊎̕obt@ɏށB
                  State buf = new State(new Object[WmIndex.A.size]);
                  for (int i = 0; i < WmIndex.A.size; i++) {
                      buf.set(WmIndex.A.head + i, 
                              oldS.get(WmIndex.A.head + i));
                  }
                  buf.set(WmIndex.A.C1.Who, this.agentItem); // ID
                  buf.set(WmIndex.A.C1.O1, a.agentItem); // ID
                  buf.set(WmIndex.A.C1.DoWhat, SaidTo);
                  a.sentenceBuf = buf;

                  //  a WX^̒l WantsToSayTo  SaidTo ɕύXB
                  newS.set(WmIndex.A.C1.DoWhat, SaidTo);

                  // V a WX^̓eGs\[hLɂĂB
                  rememberAreg(newS);
//                  State aReg = getReg(WmIndex.A, newS);
//                  episodeMem.add(0, aReg); // Insert to the top of the list.
//                  episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);

              } else {
                  // Do nothing. The utterance is just ignored.
              }
          } break;


          default: {
              System.out.println("action: "+ action);
              Lab.assertTrue(false);
          } break;
          }
      }
      /** ׂ̃GAԂB˂ꍇ݂͌̃GAB */
      public int neighborRoomID(int roomID, String dir) {
          int rx = roomID % mapSizeX;
          int ry = roomID / mapSizeX;
          if (dir == West && rx > 0) {
              rx--;
          } else if (dir == North && ry < mapSizeY - 1) {
              ry++;
          } else if (dir == South && ry > 0) {
              ry--;
          } else if (dir == East && rx < mapSizeX - 1) {
              rx++;
          } else {
              // Do nothing.
              //throw new Error("dir="+ dir);
          }
          return ry * mapSizeX + rx;
      }
      public void observeArea() {
          newS.clear(WmIndex.A);
          newS.set(WmIndex.A.Conj, Conj.Simple);
          newS.set(WmIndex.A.C1.When, Now);
          newS.set(WmIndex.A.C1.Where, currentArea);
          newS.set(WmIndex.A.C1.Who, this.agentItem);
          newS.set(WmIndex.A.C1.DoWhat, Exists);
          newS.set(WmIndex.A.C1.O1, 0);
          newS.set(WmIndex.A.C1.O2, 0);
          
          rememberAreg(newS);

          newS.clearVregister();
      }
      public void rememberAreg(State newS) {
          State aReg = getReg(WmIndex.A, newS);
          episodeMem.add(0, aReg); // Insert to the top of the list.
          episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);          
      }
      
      // BUG: ܂̂Ƃ obs1(PLS,PLS), obs2(PLS,PLS) ̂݉H
      public void observeObj(State actionParamState) throws Fail {
          Boolean logFlag = panel.flag("observeObj: logFlag", false); 
          if (logFlag) System.out.println("ObserveObj: actionParamState="+ actionParamState);
          int objID = actionParamState.getInt(WmIndex.A.C1.Who);
          Object whatP = actionParamState.get(WmIndex.A.C1.O1);
          Object whereP = actionParamState.get(WmIndex.A.C1.O2);
          Lab.assertTrue(objID == 0 || objID == 1 || objID == 2);
          if (logFlag) {
              System.out.println("observeObj: world.counter="+ world.counter);
              System.out.println("objID="+ objID);
              System.out.println("whatP="+ whatP);
              System.out.println("whereP="+ whereP);
          }
          
          // SWX^̒l oldS  newS ɃRs[B
          newS = new State(oldS.values.clone());

          // Area 烉_ɕ̂PIB
          int x = findObjectFromMap();
          if (x == -1) throw new Fail(); // ̂PȂ fail B
          // Likelihood
          Object whatL = world.map[getCurrentRoomID()][x];
          Object whereL = x;
          if (logFlag) {
              System.out.println("whatL="+ whatL);
              System.out.println("whereL="+ whereL);
          }

          // Belief = Likelihood * Prior
          // w肵where, what ƖĂ fail,
          Object whatB = calcBelief(whatP, whatL);
          Object whereB = calcBelief(whereP, whereL);
          if (logFlag) {
              System.out.println("whatB="+ whatB);
              System.out.println("whereB="+ whereB);
          }
          
          // Ȃ΂̒l v WX^ɃZbgB
          if (objID == 0) {
              newS.set(WmIndex.V.AgentWhat, whatB);
              newS.set(WmIndex.V.AgentWhere, whereB);
          } else if (objID == 1) {
              newS.set(WmIndex.V.O1What, whatB);
              newS.set(WmIndex.V.O1Where, whereB);
          } else if (objID == 2) {
              newS.set(WmIndex.V.O2What, whatB);
              newS.set(WmIndex.V.O2Where, whereB);
          } else {
              Lab.assertTrue(false);
          }

          // a WX^XVB
          newS.clear(WmIndex.A);
          newS.set(WmIndex.A.Conj, Conj.Simple);
          newS.set(WmIndex.A.C1.When, Now);
          newS.set(WmIndex.A.C1.Where, currentArea);
          newS.set(WmIndex.A.C1.Who, this.agentItem);
          newS.set(WmIndex.A.C1.DoWhat, IsLookingAt);
          newS.set(WmIndex.A.C1.O1, whatB);
          newS.set(WmIndex.A.C1.O2, 0);

          if (logFlag) {
              System.out.println("newS="+ newS);
          }
      }
      Object calcBelief(Object p, Object l) throws Fail {
          Object b;
          if (p == Rule.WILDCARD) {
              b = l;
          } else if (p == Rule.PLS) {
              if (l == Rule.ZERO) {
                   throw new Fail();
              } else {
                  b = l;
              }
          } else {
              if (l == null) {
                  b = p;
              } else if (l == p) {
                  b = p;
              } else {
                  // l != p
                  throw new Fail();
              }
          }            
          return b;
      }
      
      /**
       * [LO newS  v WX^̒lɍ킹čXVB
       * TODO: ̂̈ړgbLO@\Ă悢B
       * TODO: a WX^XVBGs\[hLɂB
       */
      public void updateVreg() {            
          int x;
          x = newS.getInt(WmIndex.V.AgentWhere);
          if (x != 0) newS.set(WmIndex.V.AgentWhat, world.map[getCurrentRoomID()][x]);
          x = newS.getInt(WmIndex.V.O1Where);
          if (x != 0) newS.set(WmIndex.V.O1What, world.map[getCurrentRoomID()][x]);
          x = newS.getInt(WmIndex.V.O2Where);
          if (x != 0) newS.set(WmIndex.V.O2What, world.map[getCurrentRoomID()][x]);

          //        int x = newS.getInt(O1_where);
          //        if (x == 0) return;
          //        Object obj = world.map[getCurrentRoomID()][x];
          //        //newS.set(RegNo, 1);
          //        newS.set(O1_what, obj);
          //        newS.set(O1_where, x);
          //        newS.set(O2_what, 0);
          //        newS.set(O2_where, 0);
      }

      // Proven-proposition list
      public List<State> episodeMem = null;
      /**
       * episodeList  query Ƀ}b`Gs\[hPIB
       * PȂꍇ null ԂB
       */
      public State findEpisode(State query) {
          // ܂͊ȒPȎBŏɌ̂PԂB
          return episodeMem.stream().filter(s -> s.episodeMatch(query))
                  .findFirst().orElse(null);
      }
      /**
       * knowledgeBase  query ̒lƃ}b`mPIB 
       * PȂꍇ null ԂB
       * class Rule 𗬗pȎB
       */
      public State findKnowledge(State query) {
          episodeMemLog("findKnowledge: query="+ query);
          Object[] vals = new Object[WmIndex.size * 2];
          for (int i = 0; i < WmIndex.size; i++) {
              vals[i] = Rule.ZERO;
          }
          for (int i = 0; i < WmIndex.E.size; i++) {
              vals[WmIndex.E.head + i] = query.values[i];
          }
          // Dummy value for g.
          for (int i = 0; i < WmIndex.size; i++) {
              vals[WmIndex.size + i] = Rule.WILDCARD;
          }
          episodeMemLog("findKnowledge: (s,g)="+ new State(vals));
          //episodeLog("findKnowledge: kb size="+ knowledgeBase.size());
          // (s,g) Ƀ}b`郋[IB
          // [̐ parallelStream gĂ݂B
          List<Rule> matched = knowledgeBase.stream().filter(
                  r -> r.knowledgeMatch(vals)
                  ).collect(Collectors.toList());
          if (matched.size() == 0) return null;

          float[] q = calcRulePriorities(matched);
          Lab.assertTrue(q.length != 0);
          // softmax  Rule PIB * 錾Im̉lׂ͂ēB
          int index = softmax(q);
          if (panel.flag("findKnowledge: Show matched rules", false)){
              env.viewPanel.println("matched"+ agentItem, "counter="+ world.counter);
              for (int i = 0; i < matched.size(); i++) {
                  env.viewPanel.println("matched"+ agentItem, i+ ":"+ matched.get(i));
              }
              env.viewPanel.println("matched"+ agentItem, "selected: "+ index);
              env.viewPanel.println("priority"+ agentItem, "counter="+ world.counter);
              for (int i = 0; i < q.length; i++) {
                  env.viewPanel.println("priority"+ agentItem, i+ ":"+ q[i]);
              }
              env.viewPanel.println("probTable"+ agentItem, "counter="+ world.counter);
              for (int i = 0; i < probTable.length; i++) {
                  env.viewPanel.println("probTable"+ agentItem, i+ ":"+ probTable[i]);
              }
          }
          Rule selected = matched.get(index);
          episodeMemLog("findKnowledge: selected="+ selected);
          State param = new State(selected.getActionParam());
          episodeMemLog("findKnowledge: param="+ param);
          State ret = getReg(WmIndex.E, param);
          episodeMemLog("findKnowledge: ret="+ ret);
          return ret;
      }
      public void episodeMemLog(String s) {
          if (episodeMemLogFlag) {
              env.viewPanel.println(episodeMemLogLabel+ agentItem, "c="+ world.counter+ ": "+ s);
          }
      }
      /**
       * Returns null if no episode found.
       */
      public State doRecall(State query) {
          episodeMemLog("doRecall");
          //episodeMemLog(" param="+ actionParamState);
          episodeMemLog(" query="+ query);
          State pp;
          // w肵mŃGs\[hLƐ錾Îǂ炩DIɑzNB
          // TODO: ɍŐṼGs\[hzN̂ł͂ȂA_ɑIB
//          if (Lab.irand(2) == 0) {
          if (panel.getFloat("episode:knowledge", 0.5f, 0f, 1f) > Lab.rand()) {
              pp = findEpisode(query);
              if (pp == null) {
                  pp = findKnowledge(query);
              }
          } else {
              pp = findKnowledge(query);
              if (pp == null) {
                  pp = findEpisode(query);
              }
          }
          if (pp == null) {
              episodeMemLog(" Not found.");
          } else {
              episodeMemLog(" Found: "+ pp);
          }
          return pp;
      }
  }
  //--------------------------------------------------
  public boolean visualizeFlag;
  public boolean mapVisualizeFlag;
  public boolean episodeMemLogFlag;
  public String episodeMemLogLabel = "Episode mem log of ";
  public class World {
      public Area[] areas;
      public Item[][] map;
      public Agent[] agents;
      public List<VCommand> vCommands = new ArrayList<>();
      
      public Agent findAgent(Object name) {
          for (int i = 0; i < agents.length; i++) {
              if (agents[i].agentItem == name) return agents[i];
          }
          return null;
      }
      //
      public World(){
      }
      public void init() {
          agents = mainCode.makeAgents(this);
          mainCode.setMap(this);
          mainCode.initAgentsTable(this);
          printWorldInfo();
      }
      public int counter = 0;
      public Integer currentTime = 0; 
      public void main(){
          int episodes = 0;
          for (;;){
              int steps = main1();
              env.viewPanel.scatterPlot("Step/Episode", episodes, steps);
              env.viewPanel.print1("episodes=", ""+ episodes++);
          }
      }
      public int main1() {
          visualizeFlag = panel.flag("visualizeFlag", true);
          mapVisualizeFlag = panel.flag("mapVisualizeFlag", true);
          episodeMemLogFlag = panel.flag("episodeMemLogFlag", true);
          panel.speedControl("Episode loop", 0);
          //mainCode.setMap(this);
          initRooms();
          for (int i = 0; i < agents.length; i++) {
              Agent a = agents[i];
              a.setDefaultStartAndGoal();
          }
          mainCode.initEpisode(this);
          for (int i = 0; i < agents.length; i++) {
              Agent agent = agents[i];
              //a.observe(Rule.makeState(w(), Rule.KEEP), a.oldS);
              agent.chooseFirstAction();
              if (visualizeFlag){
                  if (mapVisualizeFlag) visualizeMap();
                  visualizeAgentState(agent);
              }
              if (panel.flag("Action log", true)) {
                  env.viewPanel.println("Action log of "+ agent.agentItem, "");   
                  env.viewPanel.println("Action log of "+ agent.agentItem, "First action choosed.");   
              }
          }
          int steps = 0;
          // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
          while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
              currentTime++;
              for (int i = 0; i < agents.length; i++) {
                  Agent agent = agents[i];
                  env.viewPanel.print1("counter=", ""+ counter++);
                  if (visualizeFlag){
                      panel.speedControl("Step loop", 1);
//                      if (mapVisualizeFlag) visualizeMap();
//                      visualizeAgentState(agent);
                  }

                  agent.takeAction();
                  agent.chooseAction();
                  agent.update();

                  if (visualizeFlag){
                      if (mapVisualizeFlag) visualizeMap();
                      visualizeAgentState(agent);
                  }
              }
          }
          return steps;
      }
      public void visualizeAgentState(Agent agent){
          {
              String goalsLabel = "Goals of "+ agent.agentItem;
              env.viewPanel.setText(goalsLabel, ""); // Clear text.
              for (int i = 0; i < agent.stack.size(); i++) {
                  // Print elements from bottom to top.
                  env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
              }
              env.viewPanel.println(goalsLabel, ""+ agent.oldG);
          }
          {
              String logLabel = "Log of "+ agent.agentItem;
              env.viewPanel.println(logLabel, "---");
              env.viewPanel.println(logLabel, "world.counter = "+ world.counter);
              if (agent.failedFlag) env.viewPanel.println(logLabel, "Last action failed.");
              String s = "stack size="+ agent.stack.size()+ ":";
              for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                  // Add elements from top to bottom.
                  s += agent.stack.get(i)+ ", ";
              }
              env.viewPanel.println(logLabel, s);
              env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                      ", "+ agent.oldG);
              env.viewPanel.println(logLabel, ""+ agent.oldR);
          }
          String ruleLabel = "rule.q of "+ agent.agentItem;
          env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
          env.viewPanel.resetGraphData(ruleLabel);
          agent.rules.forEach(r -> {
              env.viewPanel.plot(ruleLabel, r.q);
          });
      }


      public void initRooms(){
          //map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
          for (int r = 0; r < map.length; r++) {
              for (int p = 0; p < map[r].length; p++) {
                  map[r][p] = Space;
              }
              // 
              // x=0 or y=0 ̍WɕuȂ悤ɂ邽߂ɕǂĂB
              for (int x = 0; x < roomSizeX; x++) {
                  map[r][x] = Wall; 
              }
              for (int y = 0; y < roomSizeY; y++) {
                  map[r][y * roomSizeX] = Wall;
              }
          }
          //mainCode.initMap(map);
          //        if (visualizeFlag){
          //            env.viewPanel.paint("Map", mapPainter);
          //        }
      }
      public void visualizeMap(){
          env.viewPanel.paint("Map", mapPainter);
          vCommands.clear();
      }
      public MapPainter mapPainter = new MapPainter();
      public int charSize = panel.getInt("charSize", 24, 1, 40);
      public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
      //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
      public class MapPainter extends Lab.Code implements Lab.Painter {
          public Dimension getSize(){
              int totalSizeX = mapSizeX * roomSizeX;
              int totalSizeY = mapSizeY * roomSizeY;
              return new Dimension(charSize * (totalSizeX + 1),
                      charSize * (totalSizeY + 1));
          }
          int counter = 0;
          public void paintComponent(Graphics g, MouseEvent lastEvent) {
              if (map.length == 0) return;
              // W (0,0) ƂB
              // x=0 or y=0 ͕ǁBǂł͂Ȃ x, y >= 1 Ŵݕ`悷B 
              g.setFont(f);
              for (int ry = 0; ry < mapSizeY; ry++) {
                  for (int rx = 0; rx < mapSizeX; rx++) {
                      g.setColor(Color.BLACK);
                      g.drawString(areas[ry * mapSizeX + rx].name,
                              posX(rx, ry, 1, roomSizeY-1), 
                              posY(rx, ry, 1, roomSizeY-1));

                      for (int y = 1; y < roomSizeY; y++) {
                          for (int x = 1; x < roomSizeX; x++) {
                              int r = ry * mapSizeX + rx;
                              int p = y * roomSizeX + x; 
                              String str = map[r][p].code;
                              g.setColor(Color.BLACK);
                              g.drawString(str,
                                      posX(rx, ry, x, y-1), 
                                      posY(rx, ry, x, y-1));
                          }
                      }
                  }
              }
              for (int i = 0; i < agents.length; i++) {
                  paintAgent(agents[i], g);
              }
          }
          public void paintAgent(Agent a, Graphics g) {
              for (int i = 0; i < vCommands.size(); i++) {
                  paintVCommand(g, vCommands.get(i));
              }

              int roomID = a.getCurrentRoomID();
//              int selfRX = roomID % mapSizeX;
//              int selfRY = roomID / mapSizeX;
//              int selfX = 0, selfY = 0;
              int selfPos = -1;
              // Find self
//              for (int y = 1; y < roomSizeY; y++) {
//                  for (int x = 1; x < roomSizeX; x++) {
//                      if (map[roomID][y * roomSizeX + x] == a.agentName) {
//                          selfX = x; selfY = y;
//                          selfPos = y * roomSizeX + x;
//                      }
//                  }
//              }
//              Lab.assertTrue(selfX != 0 && selfY != 0);
              for (int i = 0; i < map[roomID].length; i++) {
                  if (map[roomID][i] == a.agentItem) {
                      selfPos = i;
                  }
              }
              Lab.assertTrue(selfPos != -1);

//              int rx = roomID % mapSizeX;
//              int ry = roomID / mapSizeX;
              int where1 = a.newS.getInt(WmIndex.V.O1Where);
              Lab.assertTrue(where1 != -1);
//              int x1 =  where1 % roomSizeX;
//              int y1 =  where1 / roomSizeX;
              int where2 = a.newS.getInt(WmIndex.V.O2Where);
              Lab.assertTrue(where2 != -1);
//              int x2 =  where2 % roomSizeX;
//              int y2 =  where2 / roomSizeX;
              
              if (where1 != 0) {
                  g.setColor(Color.GREEN);
//                  g.drawRect(posX(rx, ry, x1, y1), posY(rx, ry, x1, y1),
//                          charSize - 2, charSize - 2);
//                  g.drawString("1", 
//                          posX(rx, ry, x1, y1), posY(rx, ry, x1, y1));
//                  
//                  g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
//                          posY(selfRX, selfRY, selfX, selfY) + charSize/2,
//                          posX(rx, ry, x1, y1) + charSize/2,
//                          posY(rx, ry, x1, y1) + charSize/2);
                  g.drawRect(posX(roomID, where1), posY(roomID, where1),
                          charSize - 2, charSize - 2);
                  g.drawString("1", 
                          posX(roomID, where1), posY(roomID, where1));
                  
                  g.drawLine(posX(roomID, selfPos) + charSize/2,
                          posY(roomID, selfPos) + charSize/2,
                          posX(roomID, where1) + charSize/2,
                          posY(roomID, where1) + charSize/2);
              }
              if (where2 != 0) {
                  g.setColor(Color.RED);
                  // `̘g2sNZ炵ĕ\B
//                  g.drawRect(posX(rx, ry, x2, y2) + 2, posY(rx, ry, x2, y2) + 2,
//                          charSize - 2, charSize - 2);
//                  g.drawString("2", 
//                          posX(rx, ry, x2, y2), posY(rx, ry, x2, y2));
//                  
//                  g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
//                          posY(selfRX, selfRY, selfX, selfY) + charSize/2,
//                          posX(rx, ry, x2, y2) + charSize/2,
//                          posY(rx, ry, x2, y2) + charSize/2);
                  g.drawRect(posX(roomID, where2) + 2, posY(roomID, where2) + 2,
                          charSize - 2, charSize - 2);
                  g.drawString("2", 
                          posX(roomID, where2), posY(roomID, where2));
                  
                  g.drawLine(posX(roomID, selfPos) + charSize/2,
                          posY(roomID, selfPos) + charSize/2,
                          posX(roomID, where2) + charSize/2,
                          posY(roomID, where2) + charSize/2);
              }
              if (false) {
                  // A WX^̈ꕔ\Ă݂B
                  g.setColor(Color.GRAY);
                  Font font = g.getFont();
                  g.setFont(font.deriveFont(font.getSize2D() / 3));
                  g.drawString(""+ a.newG.get(WmIndex.A.C1.Where)+ 
                          ","+ a.newG.get(WmIndex.A.C1.Who)+ 
                          ","+ a.newG.get(WmIndex.A.C1.DoWhat), 
                          posX(roomID, selfPos), posY(roomID, selfPos));
                  g.setFont(font);
              }
          }
      }
      public int posX(int rx, int ry, int x, int y) {
          return (rx * roomSizeX + x) * charSize;
      }
      public int posY(int rx, int ry, int x, int y) {
          return  (mapSizeY * roomSizeY 
                  - (ry * roomSizeY + y) 
                  )
                  * charSize;
      }
      public int posX(int roomID, int pos) {
          int rx = roomID % mapSizeX;
          int ry = roomID / mapSizeX;
          int x = pos % roomSizeX;
          int y = pos / roomSizeX;
          return (rx * roomSizeX + x) * charSize;
      }
      public int posY(int roomID, int pos) {
          int rx = roomID % mapSizeX;
          int ry = roomID / mapSizeX;
          int x = pos % roomSizeX;
          int y = pos / roomSizeX;
          return  (mapSizeY * roomSizeY 
                  - (ry * roomSizeY + y) 
                  )
                  * charSize;
      }
      public Integer stateElemToInteger(Object elem) {
          if (elem instanceof Integer) {
              return (Integer)elem;
          } else {
              return null;
          }
      }
      public void paintVCommand(Graphics g, VCommand com) {
          if (com.action == GoDir) {
              Lab.assertTrue(com.args.length == 5);
              Item item = (Item)com.args[0];
              int oldRoomID = (Integer)com.args[1];
              int newRoomID = (Integer)com.args[2];
              int oldPos = (Integer)com.args[3];
              int newPos = (Integer)com.args[4];
              java.awt.Stroke oldStroke = ((java.awt.Graphics2D)g).getStroke();
              ((java.awt.Graphics2D)g).setStroke(new java.awt.BasicStroke(14));
              g.setColor(new Color(230,230,230)); // very light gray
              g.drawLine(posX(oldRoomID, oldPos) + charSize/2,
                      posY(oldRoomID, oldPos) + charSize/2,
                      posX(newRoomID, newPos) + charSize/2,
                      posY(newRoomID, newPos) + charSize/2);
              ((java.awt.Graphics2D)g).setStroke(oldStroke);
              
          } else if (com.action == MoveO1toO2) {
              Lab.assertTrue(com.args.length == 5);
              Item item = (Item)com.args[0];
              int oldRoomID = (Integer)com.args[1];
              int newRoomID = (Integer)com.args[2];
              int oldPos = (Integer)com.args[3];
              int newPos = (Integer)com.args[4];
              java.awt.Stroke oldStroke = ((java.awt.Graphics2D)g).getStroke();
              ((java.awt.Graphics2D)g).setStroke(new java.awt.BasicStroke(14));
              g.setColor(new Color(230,255,230)); // very light green
              g.drawLine(posX(oldRoomID, oldPos) + charSize/2,
                      posY(oldRoomID, oldPos) + charSize/2,
                      posX(newRoomID, newPos) + charSize/2,
                      posY(newRoomID, newPos) + charSize/2);
              ((java.awt.Graphics2D)g).setStroke(oldStroke);

          } else {
              throw new Error();
          }
      }

      /**
       * fobOpɏóB
       */
      public void printWorldInfo() {
          System.out.println();
          System.out.println("mainCode = "+  AbstractMainCode.this.getClass().getName());
          System.out.println();

          for (int i = 0; i < agents.length; i++) {
              Agent a = agents[i];
              System.out.println("Rules for agent "+ a.agentItem);
              for (int j = 0; j < a.rules.size(); j++) {
                  System.out.println(""+ a.rules.get(j));
              }
              System.out.println();
          }
          System.out.println();
      }
  }
  
  /** R}h */
  public static class VCommand {
      PrimitiveAction action;
      Object args[];
      public VCommand(PrimitiveAction action, Object... args) {
          this.action = action; this.args = args;
      }
  }

  //--------------------------------------------------
  // DSL for rule definition. 
  VariableN o1 = new VariableN("o1");
  VariableN x1 = new VariableN("x1");
  VariableN o2 = new VariableN("o2");
  VariableN x2 = new VariableN("x2");
  VariableN x = new VariableN("x");
  VariableN y = new VariableN("y");
  VariableN z = new VariableN("z");
  VariableN room = new VariableN("room");
  public static final String __ = Rule.WILDCARD; // Two underscores.
  public static final String PLS = Rule.PLS;
  public static final String NA = "NA".intern();
  public RegisterN a(Object conj, ClauseN c0, ClauseN c1) { return new RegisterN("a", conj, c0, c1); }
  public RegisterN a(Object conj, ClauseN c0, ClauseN c1, ClauseN c2) { return new RegisterN("a", conj, c0, c1, c2); }
  public RegisterN b(Object conj, ClauseN c0, ClauseN c1) {
      throw new Error("Not used yet.");
      //return new RegisterN("b", conj, c0, c1); 
  }
  public VisualRegisterN v(Object when, Object where,
          Object aWhat, Object aWhere, Object doingWhat,
          Object o1What, Object o1Where, Object o2What, Object o2Where) { 
      return new VisualRegisterN(when,where,aWhat,aWhere,doingWhat,o1What,o1Where,o2What,o2Where); 
  }
  public RegisterN e(Object conj, ClauseN c0, ClauseN c1) { return new RegisterN("e", conj, c0, c1); }
  public RegisterN e(Object conj, ClauseN c0, ClauseN c1, ClauseN c2) { return new RegisterN("e", conj, c0, c1, c2); }
  public RegisterN a(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      return new RegisterN("a", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
  }
  public RegisterN b(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      return new RegisterN("b", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
  }
  public RegisterN e(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      return new RegisterN("e", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
  }

  public RegisterN a(Object who, Object doWhat) {
      return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
  }
  public RegisterN b(Object who, Object doWhat) {
      return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
  }
  public RegisterN e(Object who, Object doWhat) {
      return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
  }

  public RegisterN a(Object doWhat) {
      return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
  }
  public RegisterN b(Object doWhat) {
      return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
  }
  public RegisterN e(Object doWhat) {
      return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
  }

  public RegisterN a(ClauseN c) {
      return new RegisterN("a", Conj.Simple, c, null); 
  }
  public RegisterN b(ClauseN c) {
      return new RegisterN("b", Conj.Simple, c, null); 
  }
  public RegisterN e(ClauseN c) {
      return new RegisterN("e", Conj.Simple, c, null); 
  }
  public static class RegisterNArgs {
      public Object conj;
      public ClauseN c0, c1, c2;
      public RegisterNArgs(Object conj, ClauseN c0, ClauseN c1, ClauseN c2) { 
          this.conj = conj; this.c0 = c0; this.c1 = c1; this.c2 = c2;
      }
  }
  public RegisterN a(RegisterNArgs a) {
      return new RegisterN("a", a.conj, a.c0, a.c1, a.c2); 
  }
  public RegisterN b(RegisterNArgs a) {
      return new RegisterN("b", a.conj, a.c0, a.c1, a.c2); 
  }
  public RegisterN e(RegisterNArgs a) {
      return new RegisterN("e", a.conj, a.c0, a.c1, a.c2); 
  }

  public ClauseN c(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      return new ClauseN(when, where, who, doWhat, o0, o1); 
  }
  public ClauseN c(Object who, Object doWhat) {
      return new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0); 
  }
  //public ClauseN c(Object... args) { return parseClause(args); }
  //public PropositionN a(Object... args) { return parseSimpleSentence("a", args); }
  //public PropositionN b(Object... args) { return parseSimpleSentence("b", args); }
  //public PropositionN s(Object... args) { return parseSimpleSentence("s", args); }
  //public PropositionN e(Object... args) { return parseSimpleSentence("e", args); }
  //public PropositionN parseSimpleSentence(String regName, Object[] args) {
  //    return new PropositionN(regName, Conj.Simple, parseClause(args), null);
  //}
  //public ClauseN parseClause(Object[] args) {
  //    if (args.length != 6) throw new Error("parseClauseArgs: args' length is not 6: "+ args);
  //    return new ClauseN(args[0], args[1], args[2], args[3], args[4], args[5]);
  //}
  public StateN w(RegisterN a, RegisterN b, RegisterN e, VisualRegisterN v){
      if (! (a.regName.equals("a")
              && b.regName.equals("b")
              && e.regName.equals("e")
              //&& v.regName.equals("v")
              )){
          throw new Error("Syntax error in w("+ a+ ", "+ b+ ", "+ e+ ", "+ v+ ")");
      }
      return new StateN(a, b, e, v);
  }
  // w(a(...),e(...),v(...))
  public StateN w(RegisterN a, RegisterN e, VisualRegisterN v){
      if (! (a.regName.equals("a")
              && e.regName.equals("e")
              //&& v.regName.equals("v")
              )){
          throw new Error("Syntax error in w("+ a+ ", "+ e+ ", "+ v+ ")");
      }
      return new StateN(a, null, e, v);
  }
  // w(a(...), b(...)) or w(a(...), e(...))
  public StateN w(RegisterN a, RegisterN x){ 
      if (! a.regName.equals("a")){
          throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");
      } else if (x.regName.equals("b")) {
          return new StateN(a, x, null, null);
      } else if (x.regName.equals("e")) {
          return new StateN(a, null, x, null);
//      } else if (x.regName.equals("v")) {
//          return new StateN(a, null, null, x);
      } else {
          throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");          
      }
  }
  // w(a(...), v(...)) or w(b(...), v(...)) or w(e(...), v(...))
  public StateN w(RegisterN x, VisualRegisterN v){ 
      if (x.regName.equals("a")){
          return new StateN(x, null, null, v);
      } else if (x.regName.equals("b")) {
          return new StateN(null, x, null, v);
      } else if (x.regName.equals("e")) {
          return new StateN(null, null, x, v);
      } else {
          throw new Error("Syntax error in w("+ x+ ", "+ v+ ")");
      }
  }
  // w(a(...)) or w(b(...)) or w(e(...))
  public StateN w(RegisterN x){ 
      if (x.regName.equals("a")){
          return new StateN(x, null, null, null);
      } else if (x.regName.equals("b")) {
          return new StateN(null, x, null, null);
      } else if (x.regName.equals("e")) {
          return new StateN(null, null, x, null);
//      } else if (x.regName.equals("v")) {
//          return new StateN(null, null, null, x);
      } else {
          throw new Error("Syntax error in w("+ x+ ")");          
      }
  }
  // w(v(...))
  public StateN w(VisualRegisterN x){ 
      return new StateN(null, null, null, x);
  }
  public StateN w() {
      return new StateN(null, null, null, null);
  }
  public ActionN call(StateN s){ return new ActionN(Call, s); }
  public ActionN call(RegisterN s){
//      if (s.regName.equals("a")) {
//          return new ActionN(CallM, w(s));
//      } else {
//          return new ActionN(Call, w(s));
//      }
      return new ActionN(Call, w(s));
  }
  public ActionN callm(RegisterN s){
      if (! s.regName.equals("a")) throw new Error("Argument of callm should be a(...)");
      return new ActionN(CallM, w(s));
}
  //public ActionN call(VisualRegisterN v){ return new ActionN(VisualCall, w(v)); }
  public ActionN set(RegisterN s) { 
      if (s.regName.equals("a")) {
          return new ActionN(SetM, w(s));
          //return new ActionN(Set, w(s));
      } else {
          return new ActionN(Set, w(s));
      }
  }
  public ActionN set(VisualRegisterN v) { return new ActionN(Set, w(v)); }
  public ActionN set(StateN s) { return new ActionN(Set, s); }
  //public ActionN setA(Object conj, ClauseN c0, ClauseN c1) { return new ActionN(SetA, w(new RegisterN("a", conj, c0, c1))); }
  //public ActionN setB(Object conj, ClauseN c0, ClauseN c1) { return new ActionN(SetB, w(new RegisterN("b", conj, c0, c1))); }
  //public ActionN setA(ClauseN c0) { return new ActionN(SetA, w(new RegisterN("a", Object.Simple, c0, null))); }
  //public ActionN setB(ClauseN c0) { return new ActionN(SetB, w(new RegisterN("b", Object.Simple, c0, null))); }

  public ActionN recall(RegisterN s){
      if (! s.regName.equals("e")) throw new Error("Argument of recall should be e(...)");
      return new ActionN(Recall, w(s)); 
  }
  public ActionN recall(ClauseN c){ return new ActionN(Recall, w(e(Conj.Simple, c, null))); }
  public ActionN primitive(PrimitiveAction prim, Object... args) {
      Object[] argv = new Object[WmIndex.A.C1.size - 1];
      Lab.assertTrue(args.length <= argv.length);
      for (int i = 0; i < argv.length; i++) argv[i] = 0; // default value
      for (int i = 0; i < args.length; i++) argv[i] = args[i];
      Integer argc = args.length;
      return new ActionN(prim, w(a(argc,argv[0],argv[1],argv[2],argv[3],argv[4])));
  }

  public ActionN obsAgent(Object what, Object where) { return obsAction(0, what, where); }
  public ActionN obsO1(Object what, Object where) { return obsAction(1, what, where); }
  public ActionN obsO2(Object what, Object where) { return obsAction(2, what, where); }
  public ActionN obsAction(int objID, Object what, Object where) {
      return new ActionN(ObsObj, w(a(0,0,objID,0,what,where)));
  }
  
  public ClauseN varClause(String name) {
      VariableN[] a = new VariableN[WmIndex.A.C1.size];
      for (int i = 0; i < a.length; i++) {
        a[i] = new VariableN(name+ i);
      }
      return new ClauseN(a[0],a[1],a[2],a[3],a[4],a[5]); 
  }
  public RegisterNArgs varRegisterNArgs(String name) {
      return new RegisterNArgs(new VariableN(name+ "_conj"),
              varClause(name+ "_c0_"),
              varClause(name+ "_c1_"),
              varClause(name+ "_c2_"));
  }
  
  // To define task goal. Usage: taskGoal(a(...));
  public void taskGoal(StateN x) {
      StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
      rule(w(), tg, call(x));
      rule(x, tg, set(a(Verb.TaskCompleted)));
  }

  /**
   * Agent ƂɎs[WA̍ۂɈꎞIɓϐB
   */
  public List<RuleN> ruleList;
  public String rulesName = "";
  public int rulesI = 0;
  /**
   * fobOpɁA`s[ɂ킩₷OtB
   *  "t" ȂAȌ`s[ t1, t2, ... ƂOIɕtB
   */
  public void setRulesName(String s) {
      rulesName = s;
      rulesI = 0;
  }
  private void addRule1(StateN s, StateN g, ActionN a) {
      rulesI++;
      ruleList.add(new RuleN(rulesName+ rulesI, s, g, a));
  }
  // rule(s, g, call/set(...))
  public void rule(StateN s, StateN g, ActionN a){ addRule1(s, g, a); }
  public void rule(RegisterN s, StateN g, ActionN a){ addRule1(w(s), g, a); }
  // rule(s, g, Primitive)
  public void rule(StateN s, StateN g, PrimitiveAction a){ addRule1(s, g, new ActionN(a, null)); }
  public void rule(RegisterN s, StateN g, PrimitiveAction a){ addRule1(w(s), g, new ActionN(a, null)); }
  // rule(s, g, Primitive, s(...))
  public void rule(StateN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(s, g, new ActionN(a, arg)); }
  public void rule(RegisterN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(w(s), g, new ActionN(a, arg)); }

  /**
   * Agent ƂɎ錾ImA̍ۂɈꎞIɓϐB
   */
  public List<Rule> knowledgeList = new ArrayList<>();
  /**
   * Knowledge declaration.
   */
  public void k(RegisterN e) {
      // ̓sɂAm e  class Rule ̃CX^XɃGR[hĕێB
      if (! e.regName.equals("e")) throw new Error("Knowledge declaration: Usege: k(e(...));");
      rulesI++;
      RuleN ruleN = new RuleN("k-"+ rulesName+ rulesI,
              new StateN(null, null, e, null), 
              new StateN(null, null, null, null), 
              new ActionN(Set, w(e)));
      Rule r = new Rule(ruleN);
      knowledgeList.add(r);
      System.out.println("k: sharedKnowledgeBase.add: "+ r );
  }



  // End of DSL functions.

  // Methods for Task initialization.
  //
  public abstract Agent[] makeAgents(World world);
  /**
   * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
   * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
   * ݒ肷邱Ƃ\B
   */
  public void initAgentsTable(World world) {
      for (int i = 0; i < world.agents.length; i++) {
          Agent a = world.agents[i];
          ruleList = new ArrayList<>();
          addRules(world, i);
          a.rules = ruleList.stream().map(
                  ruleN ->  new Rule(ruleN)
                  ).collect(Collectors.toList());
//          for (int j = 0; j < a.rules.size(); j++) {
//              a.rules.get(j).name = j; // Use for debug.
//          }

          // KvȂ q lBƂ肠Ô܂܂ƂB

          if (panel.flag("Add incorrect rules", false)) {
              addIncorrectRules(a);
          }
      }
  }
  public abstract void addRules(World world, int agentID);
  /*
   * KȂs[ǉBs[̉l̊wK@\̃eXgEfړIB
   */
  public void addIncorrectRules(Agent a) {
      // ruleList ݂̌̒lgāAȂs[쐬B
      List<RuleN> extraRuleList = new ArrayList<>();
      // es[ƂɁAANV Fail ɕςuԈs[vǉB
      int n = ruleList.size();
      ruleList.forEach(rule -> {
          extraRuleList.add(new RuleN("*"+ rule.name,
                  rule.s,
                  rule.g, 
                  new ActionN(Fail, null))
                  );
      });
      a.rules.addAll(extraRuleList.stream().map(
              ruleN ->  new Rule(ruleN)
              ).collect(Collectors.toList())
              );
  }

  /**
   * }bṽCAEg̐ݒB
   * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
   */
  public void setMap(World world) {
      mapSizeX = 1;
      mapSizeY = 1;
      world.areas = new Area[]{ Area.Room1 };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  // ̃}bv̐ݒB setMap ̒ĂԁB
  public void setEmptyMap(World world) {
      mapSizeX = 0;
      mapSizeY = 0;
      world.areas = new Area[]{};
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  /**
   * wK̃Gs\[hsƂ̏̃\bhōsB 
   */
  public abstract void initEpisode(World world); 

  public static int putItemAtRandomPosInRoom(Item[] room, Item item){
      for (int i = 0; i < 10000; i++) {
          int x = Lab.irand(room.length);
          if (room[x] == Space){
              room[x] = item;
              return x;
          }
      }
      throw new Error("putItemAtRandomPosInRoom0: no space found.");
  }
}


public static class Test0Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) { return new Agent[] { new Agent(Alice, world)}; }
  public void addRules(World world, int agentID){
      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, set(tg));
  }
  public void setMap(World world) {
      mapSizeX = 2;
      mapSizeY = 1;
      world.areas = new Area[]{ Area.Room1,  Area.Room2 };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  public void initEpisode(World world){ 
  }
}

//eXgvÕev[gB
public static class Test1Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {return new Agent[] { new Agent(Alice, world) }; }
  public void addRules(World world, int agentID) {
      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, set(tg));
      //rule(w(), tg, set(a(5)));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

public static class Test2Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object P = "P";
      Object Q = "Q";
      Object R = "R";

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, call(a(R)));
      rule(w(a(R)), tg, set(tg));

      // P,Q  R
      // ̏Ƃ܂ a(Q) 藧Ă邾 set(a(R)) Ă܂B
      // Ă͑f܂ɊԈႤuvASYB
      // ͂AׂĂ̑O񂪐藧Ă邱Ƃ`FbNĂ set(a(R)) ȂƂ߁B
      rule(w(), w(a(R)), call(a(P)));
      rule(w(a(P)), w(a(R)), call(a(Q)));
      rule(w(a(Q)), w(a(R)), set(a(R)));

      //  P
      rule(w(), w(a(P)), set(a(P)));

      //  Q
      rule(w(), w(a(Q)), set(a(Q)));

  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

//_̗B
public static class Test3Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object P = "P";
      Object Q = "Q";
      Object R = "R";

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, call(a(R)));
      rule(w(a(R)), tg, set(tg));

      // P,Q  R
      rule(w(), w(a(R)), call(a(P)));
      rule(w(a(P)), w(a(R)), call(a(Q)));
      rule(w(a(Q)), w(a(R)), recall(e(P)));
      rule(w(a(Q),e(P)), w(a(R)), set(a(R)));

      //  P
      rule(w(), w(a(P)), set(a(P)));

      //  Q
      rule(w(), w(a(Q)), set(a(Q)));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

//recall ߂̃eXgB
public static class Test4Episode_endless extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object P = "P";
      Object Q = "Q";

      k(e(1,P));
      k(e(2,P));
      k(e(3,Q));
      k(e(4,Q));

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      // mx[X烉_ɑzNB
      //rule(w(), tg, recall(e(1,P)));
      rule(w(), tg, recall(e(0,P)));
      rule(w(), tg, recall(e(0,Q)));
      rule(w(), tg, recall(e(PLS,P)));
      rule(w(), tg, recall(e(PLS,Q)));
      rule(w(), tg, recall(e(__,P)));
      rule(w(), tg, recall(e(__,Q)));
      rule(w(), tg, recall(e(1,__)));
      //      rule(w(), tg, set(a(10,P)));
      //      rule(w(), tg, set(a(11,P)));

  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

//recall ߂̃eXgB
public static class Test5Episode_endless extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object P = "P";
      Object Q = "Q";

      k(e(1, x, x, 2, y, y));
      k(e(x, x, x, y, y, y));
      k(e(x, y, z, x, y, z));

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      // mx[X烉_ɑzNB
      rule(w(), tg, recall(e(1, 2, 3, 4, 5, 6)));
      rule(w(), tg, recall(e(1, 1, 1, 2, 2, 2)));
      rule(w(), tg, recall(e(1, 2, 3, 1, 2, 3)));
      rule(w(), tg, recall(e(1, 0, 0, 0, 0, 0)));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

//ȂBӖL̃NG̃ChJ[h 0 ɕςA}b`ȂȂB 
public static class Test6Episode2_endless extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      VariableN x1 = new VariableN("x1");
      VariableN x2 = new VariableN("x2");
      VariableN x3 = new VariableN("x3");
      VariableN x4 = new VariableN("x4");
      VariableN x5 = new VariableN("x5");
      VariableN x6 = new VariableN("x6");
      VariableN y1 = new VariableN("y1");
      VariableN y2 = new VariableN("y2");
      VariableN y3 = new VariableN("y3");
      VariableN y4 = new VariableN("y4");
      VariableN y5 = new VariableN("y5");
      VariableN y6 = new VariableN("y6");
      Object Socrates = "Socrates";
      Object Is = "Is";
      Object AMan = "AMan";
      Object Mortal = "Mortal";
      Object If = Conj.If;

      k(e(0, 0, Socrates, Is, AMan, 0));
      k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
      rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));

      // Modus Ponens
      RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
      RegisterN eif0y = e(If, c(0,0,0,0,0,0), c(y1,y2,y3,y4,y5,y6));
      RegisterN ax = a(x1,x2,x3,x4,x5,x6);
      RegisterN ay = a(y1,y2,y3,y4,y5,y6);
      rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
      rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
      rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
      rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

      RegisterN ex = e(x1,x2,x3,x4,x5,x6);
      rule(w(),   w(ax), recall(ex));
      rule(w(ex), w(ax), set(ax));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}
//ӖLgBiNGChJ[h܂łBA 0 ɕςƓȂBj
public static class Test6Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      VariableN x1 = new VariableN("x1");
      VariableN x2 = new VariableN("x2");
      VariableN x3 = new VariableN("x3");
      VariableN x4 = new VariableN("x4");
      VariableN x5 = new VariableN("x5");
      VariableN x6 = new VariableN("x6");
      VariableN y1 = new VariableN("y1");
      VariableN y2 = new VariableN("y2");
      VariableN y3 = new VariableN("y3");
      VariableN y4 = new VariableN("y4");
      VariableN y5 = new VariableN("y5");
      VariableN y6 = new VariableN("y6");
      Object Socrates = "Socrates";
      Object Is = "Is";
      Object AMan = "AMan";
      Object Mortal = "Mortal";
      Conj If = Conj.If;

      // XXX: when, where  0 ?
      k(e(0, 0, Socrates, Is, AMan, 0));
      k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

      //      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      //      rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
      //      rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));
      taskGoal(w(a(0, 0, Socrates, Is, Mortal, 0)));      

      // Modus Ponens
      RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
      RegisterN eif0y = e(If, c(__,__,__,__,__,__), c(y1,y2,y3,y4,y5,y6));
      RegisterN ax = a(x1,x2,x3,x4,x5,x6);
      RegisterN ay = a(y1,y2,y3,y4,y5,y6);
      rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
      rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
      rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
      rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

      RegisterN ex = e(x1,x2,x3,x4,x5,x6);
      rule(w(),   w(ax), recall(ex));
      rule(w(ex), w(ax), set(ax));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

public static class Test7Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object Yesterday = "Yesterday";
      Object Today = "Today";
      Object Home = "Home";
      Object Chocolate = "Chocolate";
      Object Snack = "Snack";
      Object Exists = "Exists";
      Object Brother = "Brother";
      Object NotEat = "NotEat";

      k(e(Yesterday, Home, Chocolate, Exists, 0,  0));
      k(e(Yesterday, Home, Snack, Exists, 0,  0));
      k(e(Today, Home, Brother, NotEat, Chocolate, 0));

      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      StateN g = w(a(Today, Home, PLS, Exists, 0, 0));     // ƂɉiĤׂj邩m肽B
      rule(w(), tg, call(g));
      rule(g, tg, set(a(Verb.TaskCompleted)));

      rule(w(), g, recall(e(Yesterday, Home, PLS, Exists, 0,  0)));
      rule(w(e(Yesterday, Home, x, Exists, 0,  0)), g, set(a(Yesterday, Home, x, Exists, 0,  0)));
      // ͂Ȃ recall ł͂ȂA call ďׂ݂ؖB
      rule(w(a(Yesterday, Home, x, Exists, 0,  0)), g, recall(e(Today, Home, Brother, NotEat, x, 0)));
      rule(w(a(Yesterday, Home, x, Exists, 0,  0), e(Today, Home, Brother, NotEat, x, 0)), 
              g, set(a(Today, Home, x, Exists, 0, 0)));
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}


//Ԉ錾Im̉leXgBfB
public static class Test0008Episode extends AbstractMainCode {
  public Agent[] makeAgents(World world) {
      return new Agent[] { new Agent(Alice, world) };
  }
  public void addRules(World world, int agentID) {
      Object P = "P";
      Object Q = "Q";
      Conj If = Conj.If;

      k(e(If, c(P,1), c(Q,1)));
      k(e(If, c(P,2), c(Q,2)));
      k(e(If, c(P,1), c(Q,2)));
      k(e(If, c(P,2), c(Q,1)));
      // ̂Q̂ǂꂩ_ɑzNB
      // XXX:  If zNȂ悤ɂȂƁB
      k(e(1, P));
      k(e(2, P));

      /*
       * P ̒l Q 𐄘_AԈlȂ fail BlȂ^XNIB
       */
      StateN tg = w(a(Verb.TaskCompleted)); // task goal
      rule(w(), tg, call(w(a(Q, PLS))));
      rule(w(e(P,1),a(Q,1)), tg, set(a(Verb.TaskCompleted)));
      rule(w(e(P,2),a(Q,2)), tg, set(a(Verb.TaskCompleted)));
      rule(w(e(P,1),a(Q,2)), tg, Fail);
      rule(w(e(P,2),a(Q,1)), tg, Fail);

      // _
      //??????
  }
  public void setMap(World world) {
      setEmptyMap(world);
  }
  public void initEpisode(World world) {
  }
}

//------------------------------------------------------------------

//}`[P̋ʐeNXB
//Not used.
public abstract static class TMultiRoom extends AbstractMainCode {
  public Agent[] makeAgents(World world) {return new Agent[] { 
          new Agent(Alice, world), 
          new Agent(Bob, world),
          new Agent(Carol, world), 
      };
  }
  /** eViIŋʂɎm`B */ 
  public void addCommonRules(int agentID) {
      if (agentID == 0) {
          Lab.assertTrue(world.agents[agentID].agentItem == Alice);
      } else if (agentID == 1) {
          Lab.assertTrue(world.agents[agentID].agentItem == Bob);
      } else if (agentID == 2) {
          Lab.assertTrue(world.agents[agentID].agentItem == Carol);
      } else {
          Lab.assertTrue(false);
      }
  }
  /** eViIŗL̒m`B */ 
  public void addScenarioRules(int agentID) {
      //    if (agentID == 0) {
      //    } else if (agentID == 1) {
      //    } else if (agentID == 2) {
      //    } else {
      //        Lab.assertTrue(false);
      //    }
  }
  public void addRules(World world, int agentID) {
      addCommonRules(agentID);
      addScenarioRules(agentID);
  }
  public void setMap(World world) {
      mapSizeX = 2;
      mapSizeY = 1;
      world.areas = new Area[]{ Area.Room1,  Area.Room2 };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  public void initEpisode(World world) {
  }
}

//΂kɂԂďoĂHׂ^XNB
public static class TestEnv1 extends AbstractMainCode {
  public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
  public void addRules(World world, int agentID) {
      StateN g1 = w(a(Now, __, Alice, Eats, Nut, 0));
      StateN g2 = w(v(__,__,__,__,__,Nut,PLS,__,__));
      StateN g3 = w(v(__,__,__,__,__,Stone,PLS,Shell,PLS));
      taskGoal(g1);

      // Nut HׂTu[`B
      rule(w(), g1, call(g2));
      rule(g2, g1, EatO1);

      // Nut ɓTu[`B
      rule(w(), g2, call(g3));
      rule(g3, g2, MoveO1toO2);
      rule(w(v(__,__,__,__,__,__,__,Nut,x)), g2, set(v(0,0,0,0,0,Nut,x,0,0)));

      // Shell  Stone IuWFNgWX^ɓTu[`B
      rule(w(), g3, obsO1(PLS,PLS));
      rule(w(v(__,__,__,__,__,Stone,PLS,__,__)), g3, obsO2(PLS,PLS));
  }
  public void initEpisode(World world){
      world.agents[0].energy = 1;
      world.agents[0].currentArea = Area.Room1;
      putItemAtRandomPosInRoom(world.map[0], Alice);
      putItemAtRandomPosInRoom(world.map[0], Grass);
      putItemAtRandomPosInRoom(world.map[0], Grass);
      putItemAtRandomPosInRoom(world.map[0], Stone);
      putItemAtRandomPosInRoom(world.map[0], Shell);
  }
}

//̃̕eXgvOB镔_ɒTāAHׂB
public static class TestEnv2Rooms1 extends AbstractMainCode {
  public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
  public void addRules(World world, int agentID) {
      StateN g1 = w(a(Now, __, Alice, Eats, Nut, 0));
      StateN g2 = w(v(__,__,__,__,__,Nut,PLS,__,__));
      taskGoal(g1);
      
      // Nut HׂTu[`B
      rule(w(), g1, call(g2));
      rule(g2, g1, EatO1);

      // Nut ɓTu[`B
      rule(w(), g2, primitive(GoToArea, Room1));
      rule(w(), g2, primitive(GoToArea, Room2));
      rule(w(), g2, obsO1(PLS,PLS));
  }
  public void setMap(World world) {
      mapSizeX = 2;
      mapSizeY = 1;
      world.areas = new Area[]{ Area.Room1,  Area.Room2 };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  public void initEpisode(World world){ 
      world.agents[0].energy = 1;
      world.agents[0].currentArea = Area.Room1;
      putItemAtRandomPosInRoom(world.map[0], Alice);
      putItemAtRandomPosInRoom(world.map[0], Grass);
      putItemAtRandomPosInRoom(world.map[0], Grass);
      putItemAtRandomPosInRoom(world.map[1], Grass);
      putItemAtRandomPosInRoom(world.map[1], Grass);
      putItemAtRandomPosInRoom(world.map[Lab.irand(1)], Nut); // ǂ炩̕Ƀ_ɔzu
  }
}

//̃̕eXgvOB܂kTBɐ΂TB΂ĂĊkB
//BUG:  Now ͕̈sSB
public static class TestEnv2Rooms2 extends AbstractMainCode {
public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
public void addRules(World world, int agentID) {
   StateN g1 = w(a(Now, __, Alice, Eats, Nut, 0));
   RegisterN g2a = a(Now,PLS,Nut,Exists,__,__);
   StateN g2 = w(g2a);
   RegisterN g3a = a(And, c(Now,__,Stone,Exists,__,__), c(Now,__,Shell,Exists,__,__));
   StateN g3 = w(g3a);
   StateN g4 = w(a(Now,PLS,Shell,Exists,__,__));
   StateN g5 = w(a(Now,PLS,Stone,Exists,__,__));
   StateN gx = w(a(Now,PLS,x,Exists,__,__));
   taskGoal(g1);
   
   // Nut HׂTu[`B
   rule(w(), g1, call(g2));
   rule(w(g2a), g1, obsO1(PLS,PLS));
   rule(w(g2a, v(__,__,__,__,__,Nut,PLS,__,__)), g1, EatO1);

   // Nut ɓTu[`B
   rule(w(), g2, call(g3));
   rule(w(g3a), g2, obsO1(PLS,PLS));
   rule(w(g3a, v(__,__,__,__,__,Stone,PLS,__,__)), g2, obsO2(PLS,PLS));
   rule(w(g3a, v(__,__,__,__,__,Stone,PLS,Shell,PLS)), g2, MoveO1toO2);
   rule(w(g3a, v(__,__,__,__,__,__,__,Nut,PLS)), g2, set(g2));

   // Stone  Shell TTu[`B
   rule(w(), g3, call(g4)); // Shell
   rule(g4, g3, call(g5)); // Stone
   rule(g5, g3, recall(e(__, PLS, Shell, Exists, 0, 0)));
   // Stone  Shell ɂꍇB
   rule(w(a(__, x, Stone, Exists, 0, 0), e(__, x, Shell, Exists, 0, 0)),
           g3, set(g3));
   // Stone  Shell ʂ̕ɂꍇB
   rule(w(a(__, y, Stone, Exists, 0, 0), e(__, x, Shell, Exists, 0, 0)),  
           g3, primitive(GoToAreaWithO1, x));
   rule(w(a(__,__,__,BroughO1FromO2,Stone,x)), g3, 
           set(a(And, c(Now,x,Stone,Exists,__,__), c(Now,x,Shell,Exists,__,__))));

   // x TTu[`B
   rule(w(), gx, obsO1(PLS,PLS));
   rule(w(), gx, primitive(GoToArea, Room1));
   rule(w(), gx, primitive(GoToArea, Room2));
   rule(w(v(__,y,__,__,__,x,PLS,__,__)), gx, set(a(Now,y,x,Exists,0,0)));
}
public void setMap(World world) {
   mapSizeX = 2;
   mapSizeY = 1;
   world.areas = new Area[]{ Area.Room1,  Area.Room2 };
   world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
   Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
}
public void initEpisode(World world){ 
   world.agents[0].energy = 1;
   world.agents[0].currentArea = Area.Room1;
   putItemAtRandomPosInRoom(world.map[0], Alice);
   putItemAtRandomPosInRoom(world.map[0], Grass);
   putItemAtRandomPosInRoom(world.map[0], Grass);
   putItemAtRandomPosInRoom(world.map[1], Grass);
   putItemAtRandomPosInRoom(world.map[1], Grass);
   putItemAtRandomPosInRoom(world.map[Lab.irand(2)], Stone); // ǂ炩̕Ƀ_ɔzu
   putItemAtRandomPosInRoom(world.map[Lab.irand(2)], Shell); // ǂ炩̕Ƀ_ɔzu
}
}

//Obh̃̕̕eXgvOB
//̈ړ𔺂s[͊wKł͂Ȃŏ荞ށB
public static class TestEnv2Rooms3 extends AbstractMainCode {
  public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
  public void addRules(World world, int agentID) {
      StateN g1 = w(a(Now, __, Alice, Eats, Nut, 0));
      StateN g2 = w(v(__,__,__,__,__,Nut,PLS,__,__));
      taskGoal(g1);
      
      // Nut HׂTu[`B
      rule(w(), g1, call(g2));
      rule(g2, g1, EatO1);

      // Nut TTu[`B
      for (int i = 0; i < world.areas.length; i++) {
          Area area = world.areas[i];
          for (int j = 0; j < Area.directions.length; j++) {
              String dir = Area.directions[j];
              rule(w(v(__,area,__,__,__,__,__,__,__)), g2, primitive(GoDir, dir));
              rule(w(v(__,area,__,__,__,__,__,__,__)), g2, obsO1(PLS,PLS));
          }
      }
  }
  public void setMap(World world) {
      mapSizeX = 3;
      mapSizeY = 2;
      world.areas = new Area[]{ 
              new Area("1-1"),  new Area("1-2"),  new Area("1-3"),
              new Area("2-1"),  new Area("2-2"),  new Area("2-3"),  };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  public void initEpisode(World world){ 
      world.agents[0].energy = 1;
      world.agents[0].currentArea = world.areas[0];
      putItemAtRandomPosInRoom(world.map[0], Alice);
      for (int i = 0; i < world.areas.length; i++) {
          //putItemAtRandomPosInRoom(world.map[i], Grass);
          putItemAtRandomPosInRoom(world.map[i], Grass);
      }
      putItemAtRandomPosInRoom(world.map[Lab.irand(world.map.length)], Nut); // ǂ̕Ƀ_ɔzu
  }
}


//------------------------------------------------------------------
//ΘbeXgP̋ʐeNXB
public abstract static class TScissors extends AbstractMainCode {
public Agent[] makeAgents(World world) {return new Agent[] { 
       new Agent(Alice, world), 
       new Agent(Bob, world),
       new Agent(Carol, world), 
   };
}
/** eViIŋʂɎm`B */ 
public void addCommonRules(int agentID) {
   if (agentID == 0) {
       Lab.assertTrue(world.agents[agentID].agentItem == Alice);
   } else if (agentID == 1) {
       Lab.assertTrue(world.agents[agentID].agentItem == Bob);
   } else if (agentID == 2) {
       Lab.assertTrue(world.agents[agentID].agentItem == Carol);
   } else {
       Lab.assertTrue(false);
   }
}
/** eViIŗL̒m`B */ 
public void addScenarioRules(int agentID) {
   //    if (agentID == 0) {
   //    } else if (agentID == 1) {
   //    } else if (agentID == 2) {
   //    } else {
   //        Lab.assertTrue(false);
   //    }
}
public void addRules(World world, int agentID) {
   addCommonRules(agentID);
   addScenarioRules(agentID);
}
//public void setMap(World world) {
//   world.map = new Item[0][0];
//}
public void initEpisode(World world) {
   //world.agents[0].energy = 1;
   world.agents[0].currentArea = world.areas[0];
   world.agents[1].currentArea = world.areas[0];
   world.agents[2].currentArea = world.areas[0];
   putItemAtRandomPosInRoom(world.map[0], Alice);
   putItemAtRandomPosInRoom(world.map[0], Bob);
   putItemAtRandomPosInRoom(world.map[0], Carol);
}
}


//ΘbeXgP̂P
//Bob  Alice ɔbă^XNIB
//Alice inT~̏ꏊm肽Bj
//Bob unT~ Room1 ɂBv
public static class TestS1 extends TScissors {
public void addScenarioRules(int agentID) {
   if (agentID == 0) {
       Lab.assertTrue(world.agents[agentID].agentItem == Alice);
       taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
       StateN g = w(a(Now, PLS, Scissors, Exists, 0, 0));
       rule(w(), g, Listen);
       rule(w(a(ThatO2, c(Now, Here, Bob, SaidTo, Alice, 0),
               c(Now, x, Scissors, Exists, 0, 0))),
               g,
               set(a(Now, x, Scissors, Exists, 0, 0)));

   } else if (agentID == 1) {
       Lab.assertTrue(world.agents[agentID].agentItem == Bob);
       rule(w(), w(), set(a(ThatO2,
               c(Now, Here, Bob, WantsToSayTo, Alice, 0),
               c(Now, Room1, Scissors, Exists, 0, 0))));
       rule(w(a(ThatO2, 
               c(Now, Here, Bob, WantsToSayTo, __, __), 
               c(__, __, __, __, __, __))), w(), SayIt);

   } else if (agentID == 2) {
       Lab.assertTrue(world.agents[agentID].agentItem == Carol);
       rule(w(), w(), Fail);

   } else {
       Lab.assertTrue(false);
   }
}
//public void initEpisode(World world) {
//}
}
//ΘbeXgP̂Q
//Alice
//inT~̏ꏊm肽Bj
//inT~̏ꏊmĂ邩Ȃl͒Nm肽Bj
//iBob mĂBj
//uBob, nT~͂ǂɂHvƕB
//ԓ҂
//BobunT~ x ɂBvƌȂ΃nT~ x ɂB
//Bob:
//AliceɁunT~͂ǂɂHvƕꂽuAlice, nT~ Room1 ɂBvƕԎB
public static class TestS2 extends TScissors {
public void addScenarioRules(int agentID) {
   if (agentID == 0) {
       Lab.assertTrue(world.agents[agentID].agentItem == Alice);
       taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
       
       // nT~ǂɂ邩mĂԁB
       StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
       // unT~ǂɂ邩NmĂ邩vmĂԁB
       StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0)));

       // Rule 2-7
       rule(w(), g1, call(g2));
       rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))),
               g1,
               set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                       c(Now, Wh, Scissors, Exists, 0, 0))));
       rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
       rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
       rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
               c(Now, x, Scissors, Exists, 0, 0))),
               g1,
               set(a(Now, x, Scissors, Exists, 0, 0)));

       // Bob mĂƌߑłB
       rule(w(), g2, set(a(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))));

   } else if (agentID == 1) {
       Lab.assertTrue(world.agents[agentID].agentItem == Bob);
       rule(w(), w(), Listen);
       // ꂽƂɑɕԓB
       // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
       rule(w(a(ThatO2, 
               c(Now, Here, Alice, SaidTo, Bob, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))),
               w(), 
               set(a(ThatO2,
               c(Now, Here, Bob, WantsToSayTo, Alice, 0),
               c(Now, Room1, Scissors, Exists, 0, 0))));
       rule(w(a(ThatO2,
               c(Now, Here, Bob, WantsToSayTo, __, __), 
               c(__, __, __, __, __, __))), w(), SayIt);

   } else if (agentID == 2) {
       Lab.assertTrue(world.agents[agentID].agentItem == Carol);
       rule(w(), w(), Fail);

   } else {
       Lab.assertTrue(false);
   }
}
//public void initEpisode(World world) {
//}
}

//ΘbeXgP̂R
//Q̔C
//RgCĔ\XChɂ̂B
public static class TestS3 extends TScissors {
public void addScenarioRules(int agentID) {
   if (agentID == 0) {
       Lab.assertTrue(world.agents[agentID].agentItem == Alice);
       taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
       
       k(e(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0)));
       
       // nT~ǂɂ邩mĂԁB
       StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
       // unT~ǂɂ邩NmĂ邩vmĂԁB
       StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0)));

       // Rule 2-7
       rule(w(), g1, call(g2));
       rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))),
               g1,
               set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                       c(Now, Wh, Scissors, Exists, 0, 0))));
       rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
       rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
       rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
               c(Now, x, Scissors, Exists, 0, 0))),
               g1,
               set(a(Now, x, Scissors, Exists, 0, 0)));

       // NmĂ邩voĂ݂B
       rule(w(), g2, recall(e(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))));
       rule(w(e(ThatO1, c(Now, Here, z, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))), 
               g2, 
               set(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))));

   } else if (agentID == 1) {
       Lab.assertTrue(world.agents[agentID].agentItem == Bob);
       rule(w(), w(), Listen);
       // ꂽƂɑɕԓB
       // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
       rule(w(a(ThatO2, 
               c(Now, Here, Alice, SaidTo, Bob, 0),
               c(Now, Wh, Scissors, Exists, 0, 0))),
               w(), 
               set(a(ThatO2,
               c(Now, Here, Bob, WantsToSayTo, Alice, 0),
               c(Now, Room1, Scissors, Exists, 0, 0))));
       rule(w(a(ThatO2,
               c(Now, Here, Bob, WantsToSayTo, __, __), 
               c(__, __, __, __, __, __))), w(), SayIt);

   } else if (agentID == 2) {
       Lab.assertTrue(world.agents[agentID].agentItem == Carol);
       rule(w(), w(), Fail);

   } else {
       Lab.assertTrue(false);
   }
}  
//public void initEpisode(World world) {
//}
}

//------------------------------------------------------------------
//sveXgP̋ʐeNXB
public abstract static class TThought1 extends AbstractMainCode {
  public Agent[] makeAgents(World world) {return new Agent[] { 
          new Agent(Alice, world), 
          //new Agent(Bob, world),
  };
  }
  public void setMap(World world) {
      roomSizeX = 4;
      roomSizeY = 5;
      mapSizeX = 5;
      mapSizeY = 1;
      world.areas = new Area[]{ 
              Room1,Room2,Room3,Room4,Room5, 
              };
      world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
      Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
  }
  
  public void initEpisode(World world) {
      //world.agents[0].energy = 1;
      world.agents[0].currentArea = world.areas[0];
      //world.agents[1].currentArea = world.areas[0];
      putItemAtRandomPosInRoom(world.map[0], Alice);
      //putItemAtRandomPosInRoom(world.map[0], Bob);
  }
}
//sveXgP̂P
public static class TestT1 extends TThought1 {
  public void addRules(World world, int agentID) {
      {
//          VariableN s1 = new VariableN("s1");
//          VariableN s2 = new VariableN("s2");
//          VariableN s3 = new VariableN("s3");
//          VariableN s4 = new VariableN("s4");
//          VariableN s5 = new VariableN("s5");
//          VariableN s6 = new VariableN("s6");
//          ClauseN s = c(s1,s2,s3,s4,s5,s6);
//          VariableN a1 = new VariableN("a1");
//          VariableN a2 = new VariableN("a2");
//          VariableN a3 = new VariableN("a3");
//          VariableN a4 = new VariableN("a4");
//          VariableN a5 = new VariableN("a5");
//          VariableN a6 = new VariableN("a6");
//          ClauseN a = c(a1,a2,a3,a4,a5,a6);
//          VariableN g1 = new VariableN("g1");
//          VariableN g2 = new VariableN("g2");
//          VariableN g3 = new VariableN("g3");
//          VariableN g4 = new VariableN("g4");
//          VariableN g5 = new VariableN("g5");
//          VariableN g6 = new VariableN("g6");
//          ClauseN g = c(g1,g2,g3,g4,g5,g6);
//          VariableN x1 = new VariableN("x1");
//          VariableN x2 = new VariableN("x2");
//          VariableN x3 = new VariableN("x3");
//          VariableN x4 = new VariableN("x4");
//          VariableN x5 = new VariableN("x5");
//          VariableN x6 = new VariableN("x6");
//          ClauseN x = c(x1,x2,x3,x4,x5,x6);
//          VariableN y1 = new VariableN("y1");
//          VariableN y2 = new VariableN("y2");
//          VariableN y3 = new VariableN("y3");
//          VariableN y4 = new VariableN("y4");
//          VariableN y5 = new VariableN("y5");
//          VariableN y6 = new VariableN("y6");
//          ClauseN y = c(y1,y2,y3,y4,y5,y6);
//          VariableN sg1 = new VariableN("sg1");
//          VariableN sg2 = new VariableN("sg2");
//          VariableN sg3 = new VariableN("sg3");
//          VariableN sg4 = new VariableN("sg4");
//          VariableN sg5 = new VariableN("sg5");
//          VariableN sg6 = new VariableN("sg6");
//          ClauseN sg = c(sg1,sg2,sg3,sg4,sg5,sg6);
//          VariableN ssg1 = new VariableN("ssg1");
//          VariableN ssg2 = new VariableN("ssg2");
//          VariableN ssg3 = new VariableN("ssg3");
//          VariableN ssg4 = new VariableN("ssg4");
//          VariableN ssg5 = new VariableN("ssg5");
//          VariableN ssg6 = new VariableN("ssg6");
//          ClauseN ssg = c(ssg1,ssg2,ssg3,ssg4,ssg5,ssg6);
          ClauseN s = varClause("s");
          ClauseN a = varClause("a");
          ClauseN g = varClause("g");
          ClauseN x = varClause("x");
          ClauseN y = varClause("y");
          ClauseN sg = varClause("sg");
          ClauseN ssg = varClause("ssg");
          ClauseN cPLS = c(__,__,PLS,PLS,__,__);
          
          rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
          rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));

          StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
          rule(w(), gp, recall(e(Achieves,cPLS,cPLS,g)));
          rule(w(e(Achieves,sg,x,g)), gp, set(a(Achieves,sg,x,g)));
          
          rule(w(a(Achieves,sg,x,g)), gp, recall(e(Achieves,cPLS,cPLS,sg)));
          rule(w(a(Achieves,sg,cPLS,g), e(Achieves,ssg,y,sg)), gp,
                  set(a(Achieves,ssg,sg,g)));
      }

      StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
      taskGoal(tg);
      //rule(w(), tg, primitive(GoToArea, Room2)); // test
      
      // ǂɈړɂ́A܂̏ꏊFB
      rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(ObsArea));
      
      // ɂPړTu[`^ĂB
      rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
      rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
      rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
      rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));
      
      // ꂼ̃GA瓌ɂPړłƂ錾ImB
      k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
              c(Now, Room2, Alice, Exists, 0, 0), 
              c(Now, Room2, Alice, Exists, 0, 0)));
      k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
              c(Now, Room3, Alice, Exists, 0, 0), 
              c(Now, Room3, Alice, Exists, 0, 0)));
      k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
              c(Now, Room4, Alice, Exists, 0, 0), 
              c(Now, Room4, Alice, Exists, 0, 0)));
      k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
              c(Now, Room5, Alice, Exists, 0, 0), 
              c(Now, Room5, Alice, Exists, 0, 0)));
  }
}
//sveXgP2
public static class TestT1_2 extends TThought1 {
public void addRules(World world, int agentID) {
    {
        ClauseN s = varClause("s");
        ClauseN a = varClause("a");
        ClauseN g = varClause("g");
        ClauseN x = varClause("x");
        ClauseN y = varClause("y");
        ClauseN sg = varClause("sg");
        ClauseN ssg = varClause("ssg");
        ClauseN cPLS = c(__,__,PLS,PLS,__,__);
        
        rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
        rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));

        StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
        rule(w(), gp, recall(e(Achieves,cPLS,cPLS,g)));
        rule(w(e(Achieves,sg,x,g)), gp, set(a(Achieves,sg,x,g)));
        
        rule(w(a(Achieves,sg,x,g)), gp, recall(e(Achieves,cPLS,cPLS,sg)));
        rule(w(a(Achieves,sg,cPLS,g), e(Achieves,ssg,y,sg)), gp,
                set(a(Achieves,ssg,sg,g)));
    }

    StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
    taskGoal(tg);
    //rule(w(), tg, primitive(GoToArea, Room2)); // test
    
    // ǂɈړɂ́A܂̏ꏊFB
    rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(ObsArea));
    
    // ɂPړTu[`^ĂB
    rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
    rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
    rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
    rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));
    
    // ꂼ̃GA瓌ɂPړłƂ錾ImB
    k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
            c(Now, Room2, Alice, Exists, 0, 0), 
            c(Now, Room2, Alice, Exists, 0, 0)));
    k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
            c(Now, Room3, Alice, Exists, 0, 0), 
            c(Now, Room3, Alice, Exists, 0, 0)));
    k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
            c(Now, Room4, Alice, Exists, 0, 0), 
            c(Now, Room4, Alice, Exists, 0, 0)));
    k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
            c(Now, Room5, Alice, Exists, 0, 0), 
            c(Now, Room5, Alice, Exists, 0, 0)));
}
}



//callm ̃eXgBIȂvOB
public static class TestT0_callm_endless extends AbstractMainCode {
 public Agent[] makeAgents(World world) {
     return new Agent[] { new Agent(Alice, world) };
 }
 public void addRules(World world, int agentID) {
     Object P = "P";
     Object Q = "Q";
     Object R = "R";

     taskGoal(w(a(R)));

     setRulesName("R");
     rule(w(), w(a(R)), set(a(P)));
     rule(w(a(P)), w(a(R)), set(a(Q)));
     rule(w(a(Q)), w(a(R)), callm(a(P)));
     
     rule(w(), w(a(P)), Fail);
 }
 public void setMap(World world) {
     setEmptyMap(world);
 }
 public void initEpisode(World world) {
 }
}


// A̍sveXg callm go[WB
public static class TestT1_3 extends TThought1 {
public void addRules(World world, int agentID) {
  {
      ClauseN s = varClause("s");
      ClauseN a = varClause("a");
      ClauseN g = varClause("g");
      ClauseN x = varClause("x");
      ClauseN y = varClause("y");
      ClauseN sg = varClause("sg");
      ClauseN ssg = varClause("ssg");
      ClauseN cPLS = c(__,__,PLS,PLS,__,__);
      
      rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
//      rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));
      rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
      rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

      StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
      rule(w(), gp, callm(a(Achieves,cPLS,cPLS,g)));
      rule(w(a(Achieves,sg,x,g)), gp, callm(a(Achieves,cPLS,cPLS,sg)));
      rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,sg,cPLS,g)));
      rule(w(a(Achieves,ssg,y,sg), e(Achieves,sg,x,g)), gp,
              set(a(Achieves,ssg,sg,g)));
  }

  StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
  taskGoal(tg);
  //rule(w(), tg, primitive(GoToArea, Room2)); // test
  
  // ǂɈړɂ́A܂̏ꏊFB
  rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(ObsArea));
  
  // ɂPړTu[`^ĂB
  rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
  rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
  rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
  rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));
  
  // ꂼ̃GA瓌ɂPړłƂ錾ImB
  k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
          c(Now, Room2, Alice, Exists, 0, 0), 
          c(Now, Room2, Alice, Exists, 0, 0)));
  k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
          c(Now, Room3, Alice, Exists, 0, 0), 
          c(Now, Room3, Alice, Exists, 0, 0)));
  k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
          c(Now, Room4, Alice, Exists, 0, 0), 
          c(Now, Room4, Alice, Exists, 0, 0)));
  k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
          c(Now, Room5, Alice, Exists, 0, 0), 
          c(Now, Room5, Alice, Exists, 0, 0)));
}
}



// OAōsvB
public static class TestT1_4 extends TThought1 {
    public void addRules(World world, int agentID) {
        {
            ClauseN s = varClause("s");
            ClauseN a = varClause("a");
            ClauseN g = varClause("g");
            ClauseN x = varClause("x");
            ClauseN y = varClause("y");
            ClauseN sg = varClause("sg");
            ClauseN ssg = varClause("ssg");
            ClauseN cPLS = c(__,__,PLS,PLS,__,__);

            rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
            rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
            rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

            StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
            rule(w(), gp, callm(a(Achieves,s,cPLS,cPLS)));
            rule(w(a(Achieves,s,x,ssg)), gp, callm(a(Achieves,ssg,cPLS,cPLS)));
            rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,s,cPLS,ssg)));
            rule(w(a(Achieves,ssg,y,sg), e(Achieves,s,x,ssg)), gp,
                    set(a(Achieves,s,ssg,sg)));

        }

        StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
        taskGoal(tg);

        // ǂɈړɂ́A܂̏ꏊFB
        rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(ObsArea));

        // ɂPړTu[`^ĂB
        rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

        // ꂼ̃GA瓌ɂPړłƂ錾ImB
        k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                c(Now, Room2, Alice, Exists, 0, 0), 
                c(Now, Room2, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                c(Now, Room3, Alice, Exists, 0, 0), 
                c(Now, Room3, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                c(Now, Room4, Alice, Exists, 0, 0), 
                c(Now, Room4, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                c(Now, Room5, Alice, Exists, 0, 0), 
                c(Now, Room5, Alice, Exists, 0, 0)));
    }
}


// AƑOAōsvBقڏIȂB
public static class TestT1_3_4_endless extends TThought1 {
    public void addRules(World world, int agentID) {
        {
            ClauseN s = varClause("s");
            ClauseN a = varClause("a");
            ClauseN g = varClause("g");
            ClauseN x = varClause("x");
            ClauseN y = varClause("y");
            ClauseN sg = varClause("sg");
            ClauseN ssg = varClause("ssg");
            ClauseN cPLS = c(__,__,PLS,PLS,__,__);

            setRulesName("P");
            rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
            rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
            rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

            StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
            
            // A
            setRulesName("B");
            rule(w(), gp, callm(a(Achieves,cPLS,cPLS,g)));
            rule(w(a(Achieves,sg,x,g)), gp, callm(a(Achieves,cPLS,cPLS,sg)));
            rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,sg,cPLS,g)));
            rule(w(a(Achieves,ssg,y,sg), e(Achieves,sg,x,g)), gp,
                    set(a(Achieves,ssg,sg,g)));
            // OA
            setRulesName("F");
            rule(w(), gp, callm(a(Achieves,s,cPLS,cPLS)));
            rule(w(a(Achieves,s,x,ssg)), gp, callm(a(Achieves,ssg,cPLS,cPLS)));
            rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,s,cPLS,ssg)));
            rule(w(a(Achieves,ssg,y,sg), e(Achieves,s,x,ssg)), gp,
                    set(a(Achieves,s,ssg,sg)));
        }

        setRulesName("K");
        StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
        taskGoal(tg);
        //rule(w(), tg, primitive(GoToArea, Room2)); // test

        //ǂɈړɂ́A܂̏ꏊFB
        rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(ObsArea));

        //ɂPړTu[`^ĂB
        rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
        rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

        //ꂼ̃GA瓌ɂPړłƂ錾ImB
        k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                c(Now, Room2, Alice, Exists, 0, 0), 
                c(Now, Room2, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                c(Now, Room3, Alice, Exists, 0, 0), 
                c(Now, Room3, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                c(Now, Room4, Alice, Exists, 0, 0), 
                c(Now, Room4, Alice, Exists, 0, 0)));
        k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                c(Now, Room5, Alice, Exists, 0, 0), 
                c(Now, Room5, Alice, Exists, 0, 0)));
    }
}

//Aɂsvf̍ŏ̈B
//̃̕eXgvOBTB ***  ***
public static class TestT2_1_error extends TThought1 {
    public void addRules(World world, int agentID) {
        ClauseN s = varClause("s");
        ClauseN a = varClause("a");
        ClauseN g = varClause("g");
        ClauseN x = varClause("x");
        ClauseN y = varClause("y");
        ClauseN sg = varClause("sg");
        ClauseN ssg = varClause("ssg");
        ClauseN cPLS = c(__,__,PLS,PLS,__,__);
        ClauseN any = varClause("any");
        VariableN area = new VariableN("area");

        // svvO
        {

            rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
            rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
            rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

            StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
            rule(w(), gp, callm(a(Achieves,s,cPLS,cPLS)));
            rule(w(a(Achieves,s,x,ssg)), gp, callm(a(Achieves,ssg,cPLS,cPLS)));
            rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,s,cPLS,ssg)));
            rule(w(a(Achieves,ssg,y,sg), e(Achieves,s,x,ssg)), gp,
                    set(a(Achieves,s,ssg,sg)));

        }
        
        StateN goal = w(a(Now, __, Alice, Eats, Nut, 0));
        StateN haveAnNut = w(v(__,__,__,__,__,Nut,PLS,__,__));
        RegisterN g2a = a(Now,PLS,Nut,Exists,__,__);
        StateN gx = w(a(Now,PLS,x,Exists,__,__));
        taskGoal(goal);
        
        // Achieves(PLS, ɎAɎ) ؖTu[`B
        // T_邩sv𗧂Ă邩B
        {
            setRulesName("gn");
            StateN gn = w(a(cPLS, 
                    cPLS,
                    c(Now, area, Nut,Exists, 0, 0)));
            // TB

            // _Ă݂B

            // ċAIɍsvB
            
        }
        
        //葱Im
        {
            // Nut HׂTu[`B
            rule(w(), goal, call(haveAnNut));
            rule(haveAnNut, goal, EatO1);
            
            // Nut TTu[`B
            for (int i = 0; i < world.areas.length; i++) {
                Area aa = world.areas[i];
                for (int j = 0; j < Area.directions.length; j++) {
                    String dir = Area.directions[j];
                    setRulesName("Find"+ i+ "-"+ j);
                    rule(w(v(__,aa,__,__,__,__,__,__,__)), haveAnNut, primitive(GoDir, dir));
                    // TODO: OړȂ炩Ȃ炸ϑ悤ɂB
                    setRulesName("ObsO1"+ i+ "-"+ j);
                    rule(w(v(__,aa,__,__,__,__,__,__,__)), haveAnNut, obsO1(PLS,PLS));
                }
            }
        }
        //錾Im
        {
            k(e(Achieves, c(Now, area, Alice, IsLookingAt, Nut, 0), 
                    c(Now, area, Alice, Eats, Nut, 0),
                    c(Now, area, Alice, Eats, Nut, 0)));
            k(e(Achieves, c(Now, area, Nut,Exists, 0, 0), 
                    c(Now, area, Alice, IsLookingAt, Nut, 0),
                    c(Now, area, Alice, IsLookingAt, Nut, 0)));
            
            // Cӂ̕Ɉړ\
            k(e(Achieves, any,
                    c(Now, area, Alice,Exists, 0, 0),
                    c(Now, area, Alice,Exists, 0, 0)));
        }
        // ߋ̋LB
        {
            // ̂ Kitchen  Nut B
            k(e(Achieves, c(Yesterday, Kitchen, Alice, IsLookingAt, Nut, 0)));
        }
    }
    public void setMap(World world) {
        mapSizeX = 3;
        mapSizeY = 3;
        roomSizeX = 6;
        roomSizeY = 4;
        world.areas = new Area[]{ 
                Bathroom,    Kitchen,     Bedroom,
                Closet,      LivingRoom,  GuestRoom,
                Garage,      Entrance,    Garden,
                };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.areas.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].energy = 1;
        world.agents[0].currentArea = world.areas[0];
        putItemAtRandomPosInRoom(world.map[0], Alice);
        putItemAtRandomPosInRoom(world.map[Lab.irand(world.map.length)], Nut); // ǂ̕Ƀ_ɔzu
    }
}

//Default dummy task.
public static class Demo0_Dummy extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
    public void addRules(World world, int agentID){
        throw new StopPressed();
    }
    public void initEpisode(World world){ throw new Error(); }
}
}
