//Copyright (c) 2022 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

ӎvaʋ@\̃eXgvOB

ꐙTu,cG,l,|,쐒
Vő剻`fĥ߂̈ӎvaʋ@\̐݌vƃvg^Cv,
21 lHm\w ėplHm\(SIG-AGI), 2022.

*/

package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v7.PrimitiveAction.*;
import static tmm1.TMM3v7.Item.*;
import static tmm1.TMM3v7.Conj.*;
import static tmm1.TMM3v7.Time.*;
import static tmm1.TMM3v7.Area.*;
import static tmm1.TMM3v7.Verb.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v7 {
public static void main(String[] args) {
    Lab.addSelectableClass(TMM3v7.class);
    System.out.println(Lab.selectableClasses + "");

    LabCode labCode = new LabCode();
    labCode.main(AbstractMainCode.class);
}
//For debug.
public static void printArray(String s, Object[] a) {
    System.out.print(s+ ": ");
    for (int i = 0; i < a.length; i++) {
        System.out.print(a[i]+ ",");
    }
    System.out.println();
}

/**
* Primitive actions 
*/
public static enum PrimitiveAction {
    EatO1,
    MoveO2toO1,
    MoveSelfAndEatO1,
    MoveToRoom,
    MoveToRoomWithO1,
    Call,
    Return,
    Set,
    Recall,
    SayIt,
    Listen,
    Fail,
}
/**
*  Working memory layout definition
* 
*     |     A     |     B     |     S     |     E     |
*                 ^ WmIndex.B.head   
*      <---------> WmIndex.A.size
*      <-----------------------------------------------> WmIndex.size
*/
public static class WmIndex {
  public static final RegisterIndex A;
  public static final RegisterIndex B;
  public static final RegisterIndex S;
  public static final RegisterIndex E;
  public static final int size;
  static {
      int i = 0;
      A = new RegisterIndex(i); i += A.size;
      B = new RegisterIndex(i); i += B.size;
      S = new RegisterIndex(i); i += S.size;
      E = new RegisterIndex(i); i += E.size;
      size = i;
  }
}
public static class RegisterIndex {
  public final int head;
  public final int headerSize;
  public final int size;
  public final int Conj;
  public ClauseIndex C0; 
  public ClauseIndex C1; 
  public RegisterIndex(int offset) {
      head = offset;
      int i = 0;
      Conj = i;  i++;
      headerSize = i;
      C0 = new ClauseIndex(offset + i); i += C0.size;
      C1 = new ClauseIndex(offset + i); i += C1.size;
      size = i;
  }
}
public static class ClauseIndex {
  public final int When, Where, Who, DoWhat, O0, O1;
  public final int head;
  public final int size;
  public ClauseIndex(int offset) {
      head = offset;
      int i = 0;
      When    = offset + i++; 
      Where   = offset + i++;
      Who     = offset + i++;
      DoWhat  = offset + i++;
      O0      = offset + i++;
      O1      = offset + i++;
      size = i;
  }
}

//TODO: ΎɂׂB
public static enum Time {
  Today,
  Yesterday,
  Anytime,
  Now,
}
public static enum Item {
    Wall("\u58c1"),  // 
    //Self(""),  // q
    //Mother(""),  // 
    //Brother("Z"),  // Z
    //Stone(""), // 
    //Shell("<>"), // k
    //Nut("o "), // 
    //Grass("h"), // 
    Alice("A"),  // Fist generic agent.
    Bob("B"),  //  Second generic agent.
    Carol("C"),  //  Third generic agent.
    Stone(""), // 
    Shell("k"), // k
    Nut(""), // 
    Grass(""), // 
    Scissors(""), // 
    //Meat(""), // 
    Nothing(""), // 
    Wh("W"), // wh-word for questions
    Space("E"); // E

    public final String code;
    private Item(String code){
        this.code = code;
    }
}
public static enum Conj {
    Simple,
    SaysThat,
    While,
    If,
    ThatO1,
    ThatO2,
}
public static enum Verb {
    Is,
    Has,
    Eats,
    LooksAt,
    LooksAt2,
    Thanks,
    Knows,
    Exists,
    WantsToSayTo,
    SaidTo,
    TaskCompleted,
}
public static enum Area {
    Room1,
    Room2,
    Room3,
    Storage,
    Garden,
    Shop,
    Park,
    Here,
    Anywhere,
}
//Abstract syntax nodes for DSL
public static class ClauseN {
  public Object when, where, who, doWhat, o0, o1;
  public ClauseN(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
      this.when = when;
      this.where = where;
      this.who = who;
      this.doWhat = doWhat;
      this.o0 = o0;
      this.o1 = o1;
  }
  public Object[] transN() {
      return new Object[] { when, where, who, doWhat, o0, o1 };
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("c(");
      buf.append(""+ when); buf.append(", ");
      buf.append(""+ where); buf.append(", ");
      buf.append(""+ doWhat); buf.append(", ");
      buf.append(""+ o0); buf.append(", ");
      buf.append(""+ o1);
      buf.append(")");
      return buf.toString();
  }
}
public static class RegisterN {
  public String regName;
  public Conj conj;
  public ClauseN c0, c1; 
  public RegisterN(String regName, Conj conj, ClauseN c0, ClauseN c1) {
      this.regName = regName; this.conj = conj; this.c0 = c0; this.c1 = c1;
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { 
          conj == null ? 0 : conj, 
          c0 == null ? zeroV() : c0.transN(), 
          c1 == null ? zeroV() : c1.transN() 
      };
//      return new Object[] { 
//              conj == null ? defaultValue : conj, 
//                      c0 == null ? defaultV(defaultValue) : c0.transN(), 
//                              c1 == null ? defaultV(defaultValue) : c1.transN() 
//      };
  }
  public Object[] zeroV() {
      Object[] ret = new Object[WmIndex.A.C0.size]; // Assumes all clauses have the same length.
      for (int i = 0; i < ret.length; i++) {
        ret[i] = 0;
      }
      return ret;
  }
//  public Object[] defaultV(Object defaultValue) {
//      Object[] ret = new Object[WmIndex.A.C0.size]; // Assumes all clauses have the same length.
//      for (int i = 0; i < ret.length; i++) {
//        ret[i] = defaultValue;
//      }
//      return ret;
//  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append(regName+ "(");
      buf.append(""+ conj); buf.append(", ");
      buf.append(""+ c0); buf.append(", ");
      buf.append(""+ c1);
      buf.append(")");
      return buf.toString();
  }
}
public static class StateN {
    public RegisterN a, b, s, e;
    //  public SentenceN s;
    public StateN(RegisterN a, RegisterN b, RegisterN s, RegisterN e) { 
        this.a = a; this.b = b; this.s = s; this.e = e; 
    }
    public Object[] transN(Object defaultValue) {
        return new Object[] { 
                a == null ? defaultV(defaultValue) : a.transN(defaultValue),
                        b == null ? defaultV(defaultValue) : b.transN(defaultValue),
                                s == null ? defaultV(defaultValue) : s.transN(defaultValue),
                                        e == null ? defaultV(defaultValue) : e.transN(defaultValue)
        };    
    }
    public Object[] defaultV(Object defaultValue) {
        Object[] ret = new Object[WmIndex.A.size]; // Assumes all registers have the same length.
        for (int i = 0; i < ret.length; i++) {
            ret[i] = defaultValue;
        }
        return ret;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("s(");
        buf.append(""+ a); buf.append(", ");
        buf.append(""+ b); buf.append(", ");
        buf.append(""+ s); buf.append(", ");
        buf.append(""+ e);
        buf.append(")");
        return buf.toString();
    }
}
public static class RuleN {
    public StateN s, g;
    public ActionN a;
    public RuleN(StateN s, StateN g, ActionN a){ 
        this.s = s; this.g = g; this.a = a;
    }
    public String toString(){
        return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
    }
}
public static class ActionN {
    public PrimitiveAction a;
    public StateN m;
    public ActionN(PrimitiveAction a, StateN m){ 
        this.a = a; this.m = m;
    }
    public String toString(){
        if (m == null){
            return a.toString();
        } else {
            return a.toString()+ "("+ m+ ")";
        }
    }
}
/**
 * pattern variable 
 */
public static class VariableN {
    public String name;
    public VariableN(String name){ this.name = name; }
}
//public static class UnionN {
//public StateN[] args;
//public UnionN(StateN... args){ this.args = args; }
//}

//--------------------------------------------------
/**
 * Q(s,g,a) 𒊏ۉ[B
 * lxNgƃp^[}b`đIB 
 * Usage:
 *   r = new Rule(ruleN);
 *   boolean matched = r.match(vals);
 *   if (matched){
 *      // Access to the last matching results.
 *      Action a = r.getAction();
 *      State s = new State(r.getActionParam());
 *   }
 */
public static class Rule {
    /**
     * Q value of this rule.
     */
    public float q;
    /**
     *  Rule ID. Used for debug.
     */
    public int ruleID;
    /**
     * Counter for demo.
     */
    public int useCounter = 0;
    /**
     * Number of variables appeared in this Rule.
     */
    public int numVars;
    // \ȃIuWFNgB
    public static final String UNBOUND = "__UNBOUND__";
    // p^[}b`IɖϐɑftHglB
    // O̒lɂ̂݃}b`B
    public static final String PLS = "+".intern();
    // [LO̒l̕ێB
    public static final String KEEP = "=".intern();
    // ChJ[hBCӂ̒lƃ}b`B
    public static final String WILDCARD = "__".intern(); // Two underscores.
    // 萔 0
    public static final Integer ZERO = 0; 
    public Object[] env;
    public Object[] patternVec; // Concatenated pattern of s and g.
    public PrimitiveAction action;
    public Object[] actionPatternVec;  // Pattern of m of action C_m.
    public int idCounter = 0;
    public Map<VariableN,PatternVariable> vmap = new HashMap<>();
    public RuleN ruleN; // for debug
    public Rule(RuleN ruleN){
        // ruleN ƂɃp^[\zB
        this.ruleN = ruleN;
        List<Object> elems = transStateN(ruleN.s, WILDCARD);
        elems.addAll(transStateN(ruleN.g, WILDCARD));
        numVars = vmap.size() + 
                (int)elems.stream()
        .filter(e -> e == WILDCARD || e == PLS)
        .count();
        patternVec = elems.toArray();
        action = ruleN.a.a;
        if (ruleN.a.m == null) {
            // It is primitive action.
            actionPatternVec = null;
        } else if (action == PrimitiveAction.Set){
            actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
            //    } else if (action == PrimitiveAction.SetA){
            //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
            //    } else if (action == PrimitiveAction.SetB){
            //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
            //    } else if (action == PrimitiveAction.Add){
            //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
        } else {
            actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
        }
        env = new Object[vmap.size()];
        vmap = null;
    }
    public Rule(){
        // Implicitly called from ReturnRule().
    }
    // q̗Œ蒷̃[LO̗vfɕϊB
    // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
    public List<Object> transStateN(StateN state, Object defaultValue){
        Object[] sa = flatten(state.transN(defaultValue));
        //System.out.println("state="+ state);
        //printArray("state.transN", state.transN(defaultValue));
        //printArray("state.transN 0", (Object[])(state.transN(defaultValue))[0]);
        //printArray("sa", sa);
        //System.out.println("sa.length:"+ sa.length);
        //System.out.println("wm size: "+ WmIndex.size);
        Lab.assertTrue(sa.length == WmIndex.size);
        Object[] arr = new Object[WmIndex.size];
        for (int i = 0; i < sa.length; i++) {
            Lab.assertTrue(sa[i] != null);
            arr[i] = transArg(sa[i]);
        }
        List<Object> ret = new ArrayList<>();
        ret.addAll(Arrays.asList(arr));
        if (false) {
            System.out.println("transStateN: default="+ defaultValue+ " : "+ state);
            System.out.println(" "+ ret);
        }
        return ret;
    }
    private static void flattenTest() {
        Object[] a = {1,2,3};
        Object[] b = {4,a,5,6};
        Object[][] c = {a,{7,8},{},{9},b};
        Object[] d = {};
        Object[] nested = {c,d,a,b,d};
        System.out.println("flatten test:");
        Object[] flat = flatten(nested);
        for (int i = 0; i < flat.length; i++) {
            //System.out.println(i+ ":"+ flat[i]);
            System.out.print(flat[i]+ " ");
        }
        System.out.println();
    }
    public static Object[] flatten(Object[] nested) {
        Vector<Object> v = new Vector<>();
        for (int i = 0; i < nested.length; i++) {
            if (nested[i] instanceof Object[]) {
                Object[] a = flatten((Object[])nested[i]);
                for (int j = 0; j < a.length; j++) {
                    v.add(a[j]);
                }
            } else {
                v.add(nested[i]);
            }
        }
        return v.toArray(); 
    }
    // q̈Bϐɓ id  PatternVariable 蓖ĂB
    public Object transArg(Object e) {
        Object re;
        if (e instanceof String) {
            e = ((String)e).intern();
        }
        if (e == WILDCARD){
            re = e;
        } else if (e instanceof VariableN){
            if (vmap.containsKey(e)){
                re = vmap.get(e);
            } else {
                re = new PatternVariable(((VariableN)e).name,
                        idCounter++);
                vmap.put((VariableN)e, (PatternVariable)re);
            }
        } else if (e instanceof Integer){
            int i = (Integer)e;
            // Accepts only small integers that can be compared with == operator.
            Lab.assertTrue( -128 <= i && i <= 127); 
            re = e;
        } else {
            re = e;
        }
        return re;
    }
    // TODO: t@N^O\Bϐ蓖ĂŏɂB
    public boolean ruleMatch(Object[] vals){
        Lab.assertTrue(vals.length == patternVec.length);
        for (int i = 0; i < env.length; i++) {
            env[i] = UNBOUND;
        }
        for (int i = 0; i < vals.length; i++) {
            //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
            Lab.assertTrue(vals[i] != KEEP);
            Lab.assertTrue(patternVec[i] != KEEP);
            if (patternVec[i] == WILDCARD){
                // Do nothing.
            } else if (patternVec[i] == PLS){
                if (vals[i] == ZERO) return false;
                //if (vals[i] == WILDCARD) return false;
            } else {
                Object pval;
                if (patternVec[i] instanceof PatternVariable){
                    int id = ((PatternVariable)patternVec[i]).id;
                    if (env[id] == UNBOUND && vals[i] != WILDCARD){
                        pval = env[id] = vals[i];
                    } else {
                        pval = env[id];
                    }
                    //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                    //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                    //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                } else {
                    pval = patternVec[i];
                }
                // pval ͕ϐ蓖čς݂̃p^[̒lB
                // pval ̕ vals[i] LȂ return false B
                if (pval == WILDCARD){
                    System.out.println("this="+ this);
                    Lab.assertTrue(false);
                } else if (pval == UNBOUND){
                    // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                    Lab.assertTrue(vals[i] == WILDCARD);
                    // XXX: ̂悤ȏł悢̂낤H
                } else if (pval == PLS){
                    if (vals[i] == ZERO) return false;
                    //if (vals[i] == WILDCARD) return false;
                } else {
                    if (vals[i] != pval) return false;
                }
            }
            //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
            //for (int j = 0; j < env.length; j++) {
            //    System.out.println("env["+ j+ "]="+ env[j]);
            //}
        }
        //System.out.println("*** match ****");
        return true;
    }
    // ӖLp̃p^[}b`\bhB
    // ܂ŎbŎBdl͍B
    // TODO: p^[ 0 ̂ƂɔCӂ̃L[̒lƃ}b`悤ɂׂB ͂߁B
    public boolean knowledgeMatch(Object[] qvals){
        Lab.assertTrue(qvals.length == patternVec.length);
        for (int i = 0; i < env.length; i++) {
            env[i] = UNBOUND;
        }
        for (int i = 0; i < qvals.length; i++) {
            //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
            Lab.assertTrue(qvals[i] != KEEP);
            Lab.assertTrue(patternVec[i] != KEEP);
            if (patternVec[i] == WILDCARD){
                //Lab.assertTrue(false); // not implemented
                // Not implemented and do nothing so far.
            } else if (patternVec[i] == PLS){
                Lab.assertTrue(false); // not implemented
                if (qvals[i] == ZERO) return false;
                //if (vals[i] == WILDCARD) return false;
            } else if (patternVec[i] == ZERO){
                //Lab.assertTrue(false); // not implemented
                // Not implemented and do nothing so far.
            } else {
                Object pval;
                if (patternVec[i] instanceof PatternVariable){
                    int id = ((PatternVariable)patternVec[i]).id;
                    if (env[id] == UNBOUND && qvals[i] != WILDCARD){
                        pval = env[id] = qvals[i];
                    } else {
                        pval = env[id];
                    }
                    //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                    //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                    //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                } else {
                    pval = patternVec[i];
                }
                // pval ͕ϐ蓖čς݂̃p^[̒lB
                // pval ̕ vals[i] LȂ return false B
                if (pval == WILDCARD){
                    System.out.println("this="+ this);
                    Lab.assertTrue(false);
                } else if (pval == UNBOUND){
                    // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                    Lab.assertTrue(qvals[i] == WILDCARD);
                    // XXX: ̂悤ȏł悢̂낤H
                } else if (pval == PLS){
                    if (qvals[i] == ZERO) return false;
                    //if (vals[i] == WILDCARD) return false;
                } else {
                    // p^[ʂ̒lAL[ 0, WILDCARD, PLS ̏ꍇ̓}b`B
                    if (qvals[i] == ZERO || qvals[i] == WILDCARD || qvals[i] == PLS) {
                        // Do nothing.
                    } else {
                        if (qvals[i] != pval) return false; 
                    }
                }
            }
            //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
            //for (int j = 0; j < env.length; j++) {
            //    System.out.println("env["+ j+ "]="+ env[j]);
            //}
        }
        //System.out.println("*** match ****");
        return true;
    }
    public PrimitiveAction getAction(){
        return action;
    }
    // p^[}b`́ul̃xNgvoBO match ɂϐ蓖ĂpB
    public Object[] getActionParam(){
        Object[] ret = actionPatternVec.clone();
        for (int i = 0; i < ret.length; i++) {
            if (ret[i] == WILDCARD){
                // ret[i] = WILDCARD;
            } else if (ret[i] instanceof PatternVariable){
                int id = ((PatternVariable)actionPatternVec[i]).id;
                if (env[id] == UNBOUND){
                    //System.out.println("???:"+ this);
                    //System.out.println("???: var="+ ret[i]+ ",id="+ id);
                    throw new Error("UNBOUND in action param : "+ this);
                } else {
                    ret[i] = env[id];
                }
            }
        }
        return ret;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        Lab.assertTrue(patternVec.length % 2 == 0);
        int stateLength = patternVec.length / 2;
        buf.append(ruleID);
        buf.append(":");
        buf.append("rule((");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[i]+ ",");
        }
        buf.append("), (");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[stateLength + i]+ ",");
        }
        buf.append("), ");
        if (actionPatternVec != null){
            buf.append(action+ "(");
            for (int i = 0; i < actionPatternVec.length; i++) {
                buf.append(actionPatternVec[i]+ ",");
            }
            buf.append(")");
        } else {
            buf.append(action+ "");
        }
        buf.append(").q = "+ q);
        return buf.toString();
    }
    public static class PatternVariable {
        String name;
        int id;
        public PatternVariable(String name, int id){ 
            this.name = name; this.id = id; 
        }
        //public String toString() { return ""+ id+ ":"+ name; }
        public String toString() { return ""+ name; }
    }
    // Special instance used for Action.Return
    public static final Rule returnRule = new ReturnRule();
    // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
    //   ReturnRule ̃CX^X𖳗gĂB
    public static State makeState(StateN stateN, Object defaultValue) {
        return new State(returnRule.transStateN(stateN, defaultValue).toArray());
    }
}
public static class ReturnRule extends Rule {
    public ReturnRule(){
        action = PrimitiveAction.Return;
        q = 0; // Q(g,g,RET) == 0
    }
    public String toString(){
        return "rule(Return).q = "+ q;
    }
}
/**
 * Q(s,g,call(m))  s, g, m \邽߂̃f[^\B
 */
public static class State {
    public Object[] values;
    public State(Object[] values) { this.values = values; }
    //public Object[] getVec(){
    //    return values;
    //}
    /**
     * Compares two states in order to check if the agent reaches 
     * the subgoal state g. 
     * State g may contain the special values: PLS and/or WILDCARD. 
     */
    public boolean satisfies(State g){
        Object[] gv = g.values;
        Lab.assertTrue(values.length == gv.length);
        for (int i = 0; i < gv.length; i++) {
            if (gv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (gv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != gv[i]) return false;
            }
        }
        return true;
    }
    /**
     * Gs\[hL̂߂̃}b`OB
     * query Ɋ܂܂ĂqꂪׂĊ܂܂ĂȂ true ԂB
     * TODO: L[Ώۂ State ł͂ȂCxgɕύXB
     */
    public boolean episodeMatch(State query) {
        Object[] qv = query.values;
        //printArray("episodeMatch: query", kv);
        //printArray("episodeMatch: state", values);
        Lab.assertTrue(values.length == qv.length);
        for (int i = 0; i < qv.length; i++) {
            if (qv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (qv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != qv[i]) return false;
            }
        }
        return true;

    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("State(");
        for (int i = 0; i < values.length; i++) {
            buf.append(values[i].toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    //// Working Memory management
    //public static final int wmHeaderSize = 0;
    ////public static final int numEventRegisters = 2;
    //public static final int getWMsize() {
    //    return WmIndex.size;
    ////    return wmHeaderSize 
    ////            + Reg.numRegisters * ClauseIndexOld.length;
    //}

    public Object get(int index) { return values[index]; }
    // State  n Ԗڂ̗vf𐮐ɂĕԂB̏ꍇ -1 ԂB
    public int getInt(int n) {
        Object x = values[n];
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        } else {
            return -1;
        }
    }
    public void set(int index, Object x) { values[index] = x; }
    //// old  
    //public Object get(ClauseIndexOld index) { return get(Reg.A, 0, index); }
    //public int getInt(ClauseIndexOld index) {return getInt(Reg.A, 0, index); }
    //public void set(ClauseIndexOld index, Object x) { set(Reg.A, 0, index, x); }
    //public Object get(int register, int clause, ClauseIndexOld index) { 
    //    return values[wmIndex(register, clause, index)]; 
    //}
    //public int getInt(int register, int clause, ClauseIndexOld index) { 
    //    return getIntArg(wmIndex(register, clause, index)); 
    //}
    //public void set(int register, int clause, ClauseIndexOld index, Object x) {
    //    values[wmIndex(register, clause, index)] = x; 
    //    }
    //public static final int wmIndex(ClauseIndexOld index) {
    //    // Default register 0, clause 0.
    //    return wmIndex(0, 0, index);
    //}
    //// register Ԗڂ̃WX^ clause Ԗڂ̐߂ index Ԗڂ̗vf̂vl̃AhXԂB
    //public static final int wmIndex(int register, int clause, ClauseIndexOld index) {
    //    // TODO: clause header
    //    return wmHeaderSize
    //            + register * (Clause.numClauses * (Clause.clauseHeaderSize + ClauseIndexOld.length))
    //            + Clause.clauseHeaderSize + clause * ClauseIndexOld.length
    //            + index.ordinal();
    //}
    // ׂĔp~
    //public Object get(SR_Index index) { return values[getIndexSR(index)]; }
    //public int getInt(SR_Index index) { return getIntArg(getIndexSR(index)); }
    //public void set(SR_Index index, Object x) { values[getIndexSR(index)] = x; }
    //public static final int getIndexSR(SR_Index index) {
    //    return headerSize
    //            + Reg.numRegisters * Cindex.length
    //            + index.ordinal();
    //}
}


//--------------------------------------------------
public static abstract class AbstractMainCode extends Lab.MainCode {
    //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
    public int maxSteps = panel.getInt("max steps", 100, 1, 10000);
    public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
    public float rewardC = panel.getFloat("R^C", -1, -10, 0);
    //public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
    //public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
    public int mapSizeX;
    public int mapSizeY;
    public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
    public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
    public float vScale; 
    public lab.Lab.WTextArea qView = null;
    public AbstractMainCode mainCode = this; // Main ZN^őIB
    public World world;

    public void main() {
        world = new World();
        world.agents = mainCode.makeAgents(world);
        mainCode.initAgentsTable(world);
        world.printWorldInfo();
        world.main();
    }

    public class Agent {
        public State newS; // state
        public State newG; // subgoal
        public Rule newR; // rule 
        public State oldS;
        public State oldG;
        public Rule oldR;
        public State actionParamState; 
        public float reward;
        public Stack<State> stack;
        public State start, goal;
        public boolean failedFlag;
        public float stackValue;
        public State failedState;
        //
        public World world;
        public Area currentRoom;
        public int energy;
        //public int currentPos;
        public Item agentName; // Item that represents the agent itself.
        public List<Rule> rules;
        public List<Rule> knowledgeBase;
        public State sentenceBuf;
        //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
        public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
        //
        public Agent(Item selfItem, World world){
            this.agentName = selfItem;
            this.world = world;
        }
        public void setDefaultStartAndGoal(){
            State s = Rule.makeState(w(), Rule.ZERO);
            State g = Rule.makeState(w(a(Verb.TaskCompleted)), Rule.WILDCARD);
            knowledgeBase = List.copyOf(knowledgeList);
            setStartAndGoal(s, g);
        }
        public void setStartAndGoal(State s, State g){
            oldS = newS = start = s;
            oldG = newG = goal = g;
            failedState = s;

            //System.out.println("setStartAndGoal: s="+ s);
            //System.out.println("setStartAndGoal: g="+ g);
            //System.out.println("s.satisfies(g)="+ s.satisfies(g));
        }
        public void chooseFirstAction(){
            stack = new Stack<State>();
            episodeMem = new ArrayList<State>();
            episodeMemLog("episodeList cleared.");
            sentenceBuf = null;
            chooseAction();
            oldR = newR;
        }
        // 
        public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
        public void takeAction(){
            PrimitiveAction action = oldR.getAction();
            failedFlag = false;

            if (panel.flag("Action log", true)) {
                StringBuffer buf = new StringBuffer();
                // indent
                for (int i = 0; i < stack.size(); i++) {
                    buf.append("  ");
                }
                buf.append(action.toString());
                if (action == PrimitiveAction.Return) {
                    buf.append(' ');
                    buf.append(oldS.toString());
                } else if (actionParamState != null) {
                    buf.append('(');
                    Object[] values = actionParamState.values;
                    if (values.length > 0) {
                        buf.append(values[0].toString());
                        for (int i = 1; i < values.length; i++) {
                            buf.append(',');
                            buf.append(values[i].toString());
                        }
                    }
                    buf.append(')');
                }
                env.viewPanel.println("Action log of "+ agentName, buf.toString());
                if (panel.flag("Show sentenceBuf in action log", true)) {
                    env.viewPanel.println("Action log of "+ agentName, 
                            "sentenceBuf="+ sentenceBuf);
                }
            }

            if (action == PrimitiveAction.Return){
                newS = oldS;
                newG = stack.pop();
                reward = 0;
            } else if (action == PrimitiveAction.Call){
                newS = oldS;
                stack.push(oldG);
                newG = actionParamState;
                reward = rewardC;
            } else if (action == PrimitiveAction.Set){
                newS = wmSet(actionParamState, oldS);
                State aReg = getReg(WmIndex.A, newS);
                episodeMem.add(0, aReg); // Insert to the top of the list.
                episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);

            } else if (action == PrimitiveAction.Recall){
                State query = getReg(WmIndex.E, actionParamState);
                episodeMemLog("Recall");
                episodeMemLog(" param="+ actionParamState);
                episodeMemLog(" query="+ query);
                State pp = findEpisode(query);
                if (pp == null) {
                    pp = findKnowledge(query);
                }
                if (pp == null) {
                    episodeMemLog(" Recall failed.");
                    // Fail B
                    failedFlag = true;
                    stackValue = evalStack(oldG, stack);
                    newS = failedState;
                    newG = goal;
                    stack.clear();
                    episodeMem.clear();
                    reward = rewardC + failPenalty;
                } else {
                    episodeMemLog(" found: "+ pp);
                    newS = setReg(WmIndex.E, pp, oldS);
                    episodeMemLog(" newS="+ newS);
                }              
            } else if (action == PrimitiveAction.Fail){
                failedFlag = true;
                stackValue = evalStack(oldG, stack);
                newS = failedState;
                newG = goal;
                stack.clear();
                episodeMem.clear();
                reward = rewardC + failPenalty;
            } else {
                reward = rewardC;
                newS = new State(oldS.values.clone());
                takePrimitiveActionAndObserve();
                newG = oldG;
            }
        }
        public void chooseAction(){
            if (newS.satisfies(newG)){
                newR = Rule.returnRule;
                actionParamState = null;
            } else {
                List<Rule> matched = selectMatchedRules(newS, newG);

                //            matched.forEach(r -> {
                //                System.out.println("matched: "+ r);
                //                if (r.action == Action.Call || r.action == Action.Set) {
                //                    System.out.println("  a="+ r.action);
                //                    System.out.println("  m="+ new State(r.getActionParam()));
                //                }
                //            });

                float[] q = calcRulePriorities(matched);
                if (q.length == 0){
                    throw new Error("No action selected: (news,newG)="+ 
                            newS+ ", "+ newG);
                }
                // softmax  Rule PIB
                int index = softmax(q);
                if (panel.flag("Show matched rules", false)){
                    for (int i = 0; i < matched.size(); i++) {
                        env.viewPanel.println("matched"+ agentName, i+ ":"+ matched.get(i));
                    }
                    for (int i = 0; i < q.length; i++) {
                        env.viewPanel.println("priority"+ agentName, i+ ":"+ q[i]);
                    }
                    for (int i = 0; i < probTable.length; i++) {
                        env.viewPanel.println("probTable"+ agentName, i+ ":"+ probTable[i]);
                    }
                }
                newR = matched.get(index);
                if (newR.actionPatternVec == null) {
                    actionParamState = null;
                } else {
                    actionParamState = new State(newR.getActionParam());
                }
            }
        }
        public List<Rule> selectMatchedRules(State s, State g){
            // s,g ̒lzB
            Object[] vals = new Object[s.values.length + g.values.length];
            for (int i = 0; i < s.values.length; i++) {
                vals[i] = s.values[i];
            }
            for (int i = 0; i < g.values.length; i++) {
                vals[i + s.values.length] = g.values[i];
            }
            // (s,g) Ƀ}b`郋[IB
            // [̐ parallelStream gĂ݂B
            List<Rule> matched = rules.stream().filter(
                    r -> r.ruleMatch(vals)
                    ).collect(Collectors.toList());
            return matched;
        }
        public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
        public float[] calcRulePriorities(List<Rule> matched){
            float[] q = new float[matched.size()];
            for (int i = 0; i < q.length; i++) {
                Rule r = matched.get(i);
                // numVars ɉyieB^Bϐ̐Ȃ[DB
                float val = r.q - genericityPenalty * r.numVars;
                q[i] = val;
            }
            return q;
        }
        public void update() {
            if (oldR == Rule.returnRule){
                // Do nothing.
            } else if (failedFlag){
                float delta = reward + newR.q - oldR.q - stackValue;
                oldR.q += alpha * delta;
            } else {
                //q[oldS][oldA] += alpha * (reward + q[newS][newA] - q[oldS][oldA]);
                float vg; // V_g(g')
                if (oldG == newG){
                    vg = 0;
                } else {
                    vg = evalValue(oldG, newG);
                }
                //System.out.println(oldR+ ":vg="+vg);
                float delta;
                delta = reward + newR.q - oldR.q + vg;
                //System.out.println(delta);
                oldR.q += alpha * delta;
            }

            oldS = newS;
            oldG = newG;
            oldR = newR;
        }
        // Not tested enough.
        // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
        public float evalStack(State g, Stack<State> stack) {
            State ss = g;
            float ret = 0;
            for (int i = stack.size() - 1; i >= 0; i--) {
                //System.out.println("Stack!:"+ stack.get(i));
                State gg = stack.get(i);
                //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
                ret += evalValue(gg, ss);
                ss = gg;
            }
            //System.out.println("evalStack = "+ ret);
            return ret;
        }
        public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
        /** Returns V_g(s) */
        public float evalValue(State g, State s){
            List<Rule> matched = selectMatchedRules(s, g);
            float[] q = calcRulePriorities(matched);
            if (approxValueEvalFlag){
                // V_g(s) \approx max_a Q(s,g,a)
                int i = Lab.argmax(q); 
                return matched.get(i).q;
            } else {
                // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
                calcProbTable(q, 0, q.length);
                float val = 0;
                for (int i = 0; i < probTable.length; i++) {
                    // To avoid 0 * -Infinity = NaN
                    float value = matched.get(i).q;
                    if (value != Float.NEGATIVE_INFINITY){
                        val += probTable[i] * value;
                    }
                }
                return val; 
            }
        }


        // Softmax
        public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
        public int softmax(float[] q){ return softmax(q, 0, q.length); }
        public int softmax(float[] q, int from, int to){
            calcProbTable(q, from, to);
            //        System.out.println("probTable=");
            //        for (int i = 0; i < probTable.length; i++) {
            //            System.out.print(probTable[i]+ ", ");
            //        }
            //        System.out.println();
            float r = Lab.rand();
            double sum = 0;
            for (int i = from; i < to; i++){
                sum += probTable[i]; 
                if (sum > r) {
                    Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                    return i;
                }
            }
            Lab.assertTrue(sum - 0.001f < 1);
            Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
            return to - 1;
        }
        // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
        public void calcProbTable(float[] q, int from, int to){
            if (q.length != probTable.length){
                probTable = new double[q.length];
            }
            float max = Lab.max(q);
            double total = 0;
            for (int i = from; i < to; i++){
                // To avoid overflow, subtract max.
                // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
                double val = Math.exp(beta * (q[i] - max));
                probTable[i] = val;
                total += val;
                //             System.out.println("q["+ i+ "]="+ q[i]);
                //             System.out.println("val="+ val);
            }
            //        System.out.println("total="+ total);
            Lab.assertTrue(total > 0);
            for (int i = from; i < to; i++){
                probTable[i] /= total;
            }
        }

        public boolean achieved() {
            return stack.size() == 0 && newR.getAction() == PrimitiveAction.Return; 
        }
        /**
         * [LO̒lXVBvf̒l KEEP ̏ꍇ͂̑O̒lێB
         */
        public State wmSet(State setArg, State oldS) {
            Object[] oldv = oldS.values;
            Object[] newv = oldv.clone(); // Copy the other registers.
            Object[] argv = setArg.values;
            for (int i = 0; i < newv.length; i++) {
                if (argv[i] == Rule.KEEP) {
                    newv[i] = oldv[i];
                } else {
                    newv[i] = argv[i];
                }
            }
            return new State(newv);
        }
        /**
         * WX^̒loB
         */
        public State getReg(RegisterIndex reg, State oldS) {
            int regOffset = reg.head;
            int regSize = WmIndex.A.size; // Assumes all registers have the same size.
            Object[] oldv = oldS.values;
            Object[] propv = new Object[regSize];
            for (int i = 0; i < regSize; i++) {
                propv[i] = oldv[regOffset + i];
            }
            return new State(propv);
        }
        /**
         * WX^ɒlZbgBw肵WX^ȊO̒l͕ێB
         */
        public State setReg(RegisterIndex reg, State pprop, State oldS) {
            int regOffset = reg.head;
            Object[] oldv = oldS.values;
            Object[] newv = oldv.clone(); // Copy the other registers.
            Object[] propv = pprop.values;
            int regSize = WmIndex.A.size; // Assumes all registers have the same size.
            Lab.assertTrue(regSize == propv.length);
            for (int i = 0; i < regSize; i++) {
                newv[regOffset + i] = propv[i];
            }
            return new State(newv);
        }
        /**
         * [LOɏǉBĂꍇ fail B
         */
        public State wmAdd(State setArg, State oldS) {
            final boolean alog = true;
            System.err.println("wmAdd: not debugged yet!");
            if (alog) {
                System.out.println("wmAdd: s: "+ setArg);
                System.out.println("wmAdd: o: "+ oldS);
            }
            Object[] prior = new Object[WmIndex.size];
            for (int i = 0; i < prior.length; i++) {
                if (setArg.values[i] == Rule.KEEP) {
                    prior[i] = oldS.values[i];
                } else {
                    prior[i] = setArg.values[i];
                }
            }
            if (alog) printArray("wmAdd: prior", prior);
            Object[] likelihood = new Object[WmIndex.size];
            if (alog) printArray("wmAdd: likelihood", likelihood);

            // ̏q͖IɊϑȂĂIɒl set B
            //Lab.assertTrue(setArg.get(Energy) == Rule.KEEP);
            //Lab.assertTrue(setArg.get(Where) == Rule.KEEP);
            //Lab.assertTrue(setArg.get(WmIndex.A.C0.Where) == Rule.KEEP); //??

            Object[] belief = new Object[WmIndex.size];
            // \ prior Ɗϑ likelihood ̖oꂽ fail B
            for (int i = 0; i < belief.length; i++) {
                if (prior[i] == Rule.WILDCARD) {
                    belief[i] = likelihood[i];
                } else if (prior[i] == Rule.PLS) {
                    if (likelihood[i] == Rule.ZERO) {
                        return null; // fail
                    } else {
                        belief[i] = likelihood[i];
                    }
                } else {
                    if (likelihood[i] == null) {
                        belief[i] = prior[i];
                    } else if (likelihood[i] == prior[i]) {
                        belief[i] = prior[i];
                    } else {
                        // likelihood[i] != prior[i]
                        return null; // fail
                    }
                }
            }
            belief[WmIndex.A.C0.When] = Time.Now;
            //belief[State.wmIndex(Reg.A, 0, Energy)] = energy;
            belief[WmIndex.A.C0.Where] = currentRoom;
            if (alog) printArray("wmAdd: belief", belief);
            for (int i = 0; i < belief.length; i++) {
                if (belief[i] == null) {
                    System.out.println("wmAdd: b["+ i+ "]="+ belief[i]); 
                    Lab.assertTrue(false);
                }
            }

            return new State(belief);
        }

        public int getCurrentRoomID() {
            return roomNameToRoomId(currentRoom);
        }
        public int roomNameToRoomId(Area roomName) {
            for (int i = 0; i < world.roomNames.length; i++) {
                if (roomName == world.roomNames[i]) return i;
            }
            throw new Error("roomNameToRoomId : "+ roomName);
        }

        /**
         * }bv̒烉_ɂP̂IňʒuԂB 
         */
        public int findObjectFromMap() {
            // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
            // }bv̂̐̕𐔂B
            int c = 0;
            int roomID = getCurrentRoomID();
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        c++;
                    }
                }
            }
            // _ r Ԗڂ̂̕IԁB
            int r = Lab.irand(c);
            c = 0;
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        if (c++ == r) return y * roomSizeX + x;
                    }
                }
            }
            return -1; // Not found.
        }
        /**
         * }bv̒w肳ꂽ̂PTďꏊԂB
         * TB 
         */
        public int findItemFromTheRoom(Item item) {
            int roomID = getCurrentRoomID();
            for (int i = 0; i < world.map[roomID].length; i++) {
                if (world.map[roomID][i] == item) return i;
            }
            throw new Error("findItemFromMap: not found "+ item);
        }

        /** ANV a.oldR sA a.newS ϑB
         * Vꍇ a.reward ̒lɉZB
         */
        public void takePrimitiveActionAndObserve() {
            PrimitiveAction action = oldR.getAction();
            //int roomID = getCurrentRoomID();
            //newS.set(WmIndex.A.C0.When, Time.Now);
            switch (action) {
            //        case EatO1: {
            //            // O1 HׂȂ炻 Leftovers ɕϊB
            //            // W̉ĂȂƂ́HƂ肠G[B
            //            // HׂȂƂ́HƂ肠G[B
            //            int x = newS.getInt(O1_where);
            //            if (x == -1) {
            //                Lab.assertTrue(false);
            //            } else {
            //                Object target = world.map[roomID][x];
            //                if (target == Nut) {
            //                    world.map[roomID][x] = Space;
            //                    energy++;
            //                    newS.set(Energy, energy);
            //                } else {
            //                    Lab.assertTrue(false);
            //                }
            //            }
            //            observeO1();
            //        } break;
            //
            //        case MoveO2toO1: {
            //            // O2  O1 ̏ꏊɈړAO1, O2 ͌`EʒuωB
            //            int x1 = newS.getInt(O1_where);
            //            int x2 = newS.getInt(O2_where);
            //            if (x1 == -1 || x2 == -1) {
            //                Lab.assertTrue(false);
            //            } else if (x1 == 0 || x2 == 0) {
            //                // Fail ׂH
            //                Lab.assertTrue(false);
            //            } else {
            //                Object target = world.map[roomID][x1];
            //                Object item = world.map[roomID][x2];
            //                if (target == Shell && item == Stone) {
            //                    world.map[roomID][x1] = Nut;
            //                    world.map[roomID][x2] = Space;
            //                } else {
            //                    // Fail ׂH
            //                    Lab.assertTrue(false);
            //                }
            //                observeO1();
            //            }
            //        } break;
            //
            //        case MoveSelfAndEatO1: {
            //            // O1 HׂȂ玩g O1 ɈړĐHׂB
            //            int selfX = findItemFromTheRoom(selfItem);
            //
            //            int x = newS.getInt(O1_where);
            //            if (x == -1) {
            //                Lab.assertTrue(false);
            //            } else if (x == 0) {
            //                // Fail ׂH
            //                Lab.assertTrue(false);
            //            } else {
            //                Object target = world.map[roomID][x];
            //                if (target == Nut) {
            //                    world.map[roomID][x] = selfItem;
            //                    world.map[roomID][selfX] = Space;
            //                    energy++;
            //                    newS.set(Energy, energy);
            //                } else {
            //                    //System.out.println("Stolen!");
            //                    //Lab.assertTrue(false);
            //                }
            //            }
            //            observeO1();
            //        } break;
            //        
            //        case Say: {
            //            Verb verb = (Verb)actionParamState.get(S_verb);
            //            Object obj = actionParamState.get(S_object);
            //            switch (verb) {
            //            case WhereIs : {
            //                Lab.assertTrue(obj instanceof Item);
            //                int x = findItemFromTheRoom((Item)obj);  
            //                //newS.set(RegNo, 1);
            //                newS.set(O1_what, obj);
            //                newS.set(O1_where, x);
            //            } break;

            //            case GiveMe : {
            //                // }bv obj uȀꏊ O1 ɃZbgB
            //                Lab.assertTrue(obj instanceof Item);
            //                putItemAtRandomPosInRoom(world.map[roomID], (Item)obj);
            //                int x = findItemFromTheRoom((Item)obj);
            //                //newS.set(RegNo, 1);
            //                newS.set(O1_what, obj);
            //                newS.set(O1_where, x);
            //            } break;
            //            
            //            case HereIs : {
            //                // sentence(HereIs,Nut) ƔbĂ
            //                // O1 ̏ꏊ Nut  Thanks ƕԎB
            //                // Nut łȂꍇ͉ȂB
            //                // (ݒ̃^XNŗpƉB)
            //                int o1 = newS.getInt(O1_what);
            //                int x1 = newS.getInt(O1_where);
            //                Item item = world.map[roomID][x1];
            //                if (obj == Nut && obj == item) {
            //                    newS.set(S_verb, Verb.Thanks);
            //                    newS.set(S_object, 0);
            //                }
            //            } break;
            //
            //            default:{
            //                Lab.assertTrue(false);
            //            } break;
            //            }
            //            
            //        } break;
            //
            //        case MoveToRoom: {
            //            RoomName newRoomName = (RoomName)actionParamState.get(Where);
            //            Lab.assertTrue(newRoomName != null);
            //            int newRoomID = roomNameToRoomId(newRoomName);
            //            // map ̍XVB
            //            int pos = findItemFromTheRoom(selfItem);
            //            world.map[roomID][pos] = Space;
            //            currentRoom = newRoomName;
            //            putItemAtRandomPosInRoom(world.map[newRoomID], selfItem);
            //            newS.set(Where, newRoomName);
            //            // IuWFNgWX^ׂ͂ăNAB
            //            //newS.set(RegNo, 0);
            //            newS.set(O1_what, 0);
            //            newS.set(O1_where, 0);
            //            newS.set(O2_what, 0);
            //            newS.set(O2_where, 0);
            //        } break;
            case Listen : {
                if (sentenceBuf != null) {
                    if (false) { // B
                        // obt@̒g s WX^ɏށB
                        for (int i = 0; i < WmIndex.S.size; i++) {
                            newS.set(WmIndex.S.head + i, 
                                    sentenceBuf.get(WmIndex.A.head + i));
                        }
                        if (panel.flag("Show sentenceBuf in action log")) {
                            env.viewPanel.println("Action log of "+ agentName, 
                                    "Listen: sentenceBuf="+ sentenceBuf);
                        }           
                    } else {
                        // obt@̒g a WX^ɏށB
                        for (int i = 0; i < WmIndex.A.size; i++) {
                            newS.set(WmIndex.A.head + i, 
                                    sentenceBuf.get(WmIndex.A.head + i));
                        }
                        if (panel.flag("Show sentenceBuf in action log")) {
                            env.viewPanel.println("Action log of "+ agentName, 
                                    "Listen: sentenceBuf="+ sentenceBuf);
                        }           
                    }
                    // obt@͋ɂB
                    sentenceBuf = null;
                } else {
                    // Do nothing. Just listen to new utterance.
                }
            } break;
            case SayIt : {
                // a WX^̏ԃ`FbNBԈĂ΃G[bZ[Wo Fail B
                // TODOF ƂƎB
                Lab.assertTrue(oldS.get(WmIndex.A.C0.DoWhat) == WantsToSayTo);
                
                if (false) { // Bb a ł͂Ȃ s WX^ɓĂB
                    // B
                    Object targetName = oldS.get(WmIndex.S.C0.O0);
                    Agent a = world.findAgent(targetName);
                    if (a == null) {
                        throw new Error("SayIt: targetName "+ targetName+ " does not exist.");
                    }
                    if (a.sentenceBuf == null) {
                        // be𑊎̕obt@ɏށB
                        State buf = new State(new Object[WmIndex.A.size]);
                        for (int i = 0; i < WmIndex.S.size; i++) {
                            buf.set(WmIndex.A.head + i, 
                                    oldS.get(WmIndex.S.head + i));
                        }
                        buf.set(WmIndex.A.C0.Who, this.agentName); // ID
                        buf.set(WmIndex.A.C0.O0, a.agentName); // ID
                        buf.set(WmIndex.A.C0.DoWhat, SaidTo);
                        a.sentenceBuf = buf;

                        //  s WX^̒l WantsToSayTo  SaidTo ɕύXB
                        newS.set(WmIndex.S.C0.DoWhat, SaidTo);
                    } else {
                        // Do nothing. The utterance is just ignored.
                    }
                } else {
                    // B
                    Object targetName = oldS.get(WmIndex.A.C0.O0);
                    Agent a = world.findAgent(targetName);
                    if (a == null) {
                        throw new Error("SayIt: targetName "+ targetName+ " does not exist.");
                    }
                    if (a.sentenceBuf == null) {
                        // be𑊎̕obt@ɏށB
                        State buf = new State(new Object[WmIndex.A.size]);
                        for (int i = 0; i < WmIndex.A.size; i++) {
                            buf.set(WmIndex.A.head + i, 
                                    oldS.get(WmIndex.A.head + i));
                        }
                        buf.set(WmIndex.A.C0.Who, this.agentName); // ID
                        buf.set(WmIndex.A.C0.O0, a.agentName); // ID
                        buf.set(WmIndex.A.C0.DoWhat, SaidTo);
                        a.sentenceBuf = buf;

//                        //  a WX^̒l s WX^ɃRs[B
//                        for (int i = 0; i < WmIndex.A.size; i++) {
//                            newS.set(WmIndex.S.head + i, 
//                                    oldS.get(WmIndex.A.head + i));
//                        }
//                        // a WX^NAB
//                        for (int i = 0; i < WmIndex.A.size; i++) {
//                            newS.set(WmIndex.A.head + i, 0);
//                        }
                        //  a WX^̒l WantsToSayTo  SaidTo ɕύXB
                        newS.set(WmIndex.A.C0.DoWhat, SaidTo);

                        // V a WX^̓eGs\[hLɂĂB
                        State aReg = getReg(WmIndex.A, newS);
                        episodeMem.add(0, aReg); // Insert to the top of the list.
                        episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);

                    } else {
                        // Do nothing. The utterance is just ignored.
                    }
                }
            } break;


            default: {
                System.out.println("action: "+ action);
                Lab.assertTrue(false);
            } break;
            }
        }
        /**
         * [LO newS ̂̕P̒lɍ킹čXVB
         * ̂Q̒l 0 ƂB
         * ꕔ̑ΊOANV̎sɌĂ΂B
         * TODO: ̂̈ړgbLO@\Ă悢B
         */
        public void observeO1() {
            //        int x = newS.getInt(O1_where);
            //        if (x == 0) return;
            //        Object obj = world.map[getCurrentRoomID()][x];
            //        //newS.set(RegNo, 1);
            //        newS.set(O1_what, obj);
            //        newS.set(O1_where, x);
            //        newS.set(O2_what, 0);
            //        newS.set(O2_where, 0);
        }

        // Proven-proposition list
        public List<State> episodeMem = null;
        /**
         * episodeList  query Ƀ}b`Gs\[hPIB
         * PȂꍇ null ԂB
         */
        public State findEpisode(State query) {
            // ܂͊ȒPȎBŏɌ̂PԂB
            return episodeMem.stream().filter(s -> s.episodeMatch(query))
                    .findFirst().orElse(null);
        }
        /**
         * knowledgeBase  query ̒lƃ}b`mPIB 
         * PȂꍇ null ԂB
         * class Rule 𗬗pȎB
         */
        public State findKnowledge(State query) {
            episodeMemLog("findKnowledge: query="+ query);
            Object[] vals = new Object[WmIndex.size * 2];
            for (int i = 0; i < WmIndex.size; i++) {
                vals[i] = Rule.ZERO;
            }
            for (int i = 0; i < WmIndex.E.size; i++) {
                vals[WmIndex.E.head + i] = query.values[i];
            }
            // Dummy value for g.
            for (int i = 0; i < WmIndex.size; i++) {
                vals[WmIndex.size + i] = Rule.WILDCARD;
            }
            episodeMemLog("findKnowledge: (s,g)="+ new State(vals));
            //episodeLog("findKnowledge: kb size="+ knowledgeBase.size());
            // (s,g) Ƀ}b`郋[IB
            // [̐ parallelStream gĂ݂B
            List<Rule> matched = knowledgeBase.stream().filter(
                    r -> r.knowledgeMatch(vals)
                    ).collect(Collectors.toList());
            if (matched.size() == 0) return null;

            float[] q = calcRulePriorities(matched);
            Lab.assertTrue(q.length != 0);
            // softmax  Rule PIB
            int index = softmax(q);
            if (panel.flag("findKnowledge: Show matched rules", false)){
                env.viewPanel.println("matched"+ agentName, "counter="+ world.counter);
                for (int i = 0; i < matched.size(); i++) {
                    env.viewPanel.println("matched"+ agentName, i+ ":"+ matched.get(i));
                }
                env.viewPanel.println("matched"+ agentName, "selected: "+ index);
                env.viewPanel.println("priority"+ agentName, "counter="+ world.counter);
                for (int i = 0; i < q.length; i++) {
                    env.viewPanel.println("priority"+ agentName, i+ ":"+ q[i]);
                }
                env.viewPanel.println("probTable"+ agentName, "counter="+ world.counter);
                for (int i = 0; i < probTable.length; i++) {
                    env.viewPanel.println("probTable"+ agentName, i+ ":"+ probTable[i]);
                }
            }
            Rule selected = matched.get(index);
            episodeMemLog("findKnowledge: selected="+ selected);
            State param = new State(selected.getActionParam());
            episodeMemLog("findKnowledge: param="+ param);
            State ret = getReg(WmIndex.E, param);
            episodeMemLog("findKnowledge: ret="+ ret);
            return ret;
        }
        public void episodeMemLog(String s) {
            if (episodeMemLogFlag) {
                env.viewPanel.println(episodeMemLogLabel+ agentName, "c="+ world.counter+ ": "+ s);
            }

        }
    }
    //--------------------------------------------------
    public boolean visualizeFlag;
    public boolean mapVisualizeFlag;
    public boolean episodeMemLogFlag;
    public String episodeMemLogLabel = "Episode mem log of ";
    public class World {
        public Area[] roomNames;
        public Item[][] map;
        public Agent[] agents;
        public Agent findAgent(Object name) {
            for (int i = 0; i < agents.length; i++) {
                if (agents[i].agentName == name) return agents[i];
            }
            return null;
        }
        //
        public World(){
        }
        int counter = 0;
        public void main(){
            int episodes = 0;
            for (;;){
                int steps = main1();
                env.viewPanel.scatterPlot("Step/Episode", episodes, steps);
                env.viewPanel.print1("episodes=", ""+ episodes++);
            }
        }
        public int main1() {
            visualizeFlag = panel.flag("visualizeFlag", true);
            mapVisualizeFlag = panel.flag("mapVisualizeFlag", false);
            episodeMemLogFlag = panel.flag("episodeMemLogFlag", true);
            panel.speedControl("Episode loop", 0);
            mainCode.setMap(this);
            initRooms();
            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                a.setDefaultStartAndGoal();
            }
            mainCode.initEpisode(this);
            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                //a.observe(Rule.makeState(w(), Rule.KEEP), a.oldS);
                a.chooseFirstAction();
            }
            int steps = 0;
            // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
            while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
                for (int i = 0; i < agents.length; i++) {
                    Agent agent = agents[i];
                    env.viewPanel.print1("counter=", ""+ counter++);
                    if (visualizeFlag){
                        panel.speedControl("Step loop", 100);
                        if (mapVisualizeFlag) visualizeMap();
                        visualizeAgentState(agent);
                    }

                    agent.takeAction();
                    agent.chooseAction();
                    agent.update();

                    if (visualizeFlag){
                        if (mapVisualizeFlag) visualizeMap();
                        visualizeAgentState(agent);
                    }
                }
            }
            return steps;
        }
        public void visualizeAgentState(Agent agent){
            {
                String goalsLabel = "Goals of "+ agent.agentName;
                env.viewPanel.setText(goalsLabel, ""); // Clear text.
                for (int i = 0; i < agent.stack.size(); i++) {
                    // Print elements from bottom to top.
                    env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
                }
                env.viewPanel.println(goalsLabel, ""+ agent.oldG);
            }
            {
                String logLabel = "Log of "+ agent.agentName;
                env.viewPanel.println(logLabel, "---");
                String s = "stack size="+ agent.stack.size()+ ":";
                for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                    // Add elements from top to bottom.
                    s += agent.stack.get(i)+ ", ";
                }
                env.viewPanel.println(logLabel, s);
                env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                        ", "+ agent.oldG);
                env.viewPanel.println(logLabel, ""+ agent.oldR);
            }
            String ruleLabel = "rule.q of "+ agent.agentName;
            env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
            env.viewPanel.resetGraphData(ruleLabel);
            agent.rules.forEach(r -> {
                env.viewPanel.plot(ruleLabel, r.q);
            });
        }


        public void initRooms(){
            //map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
            for (int r = 0; r < map.length; r++) {
                for (int p = 0; p < map[r].length; p++) {
                    map[r][p] = Space;
                }
                // 
                // x=0 or y=0 ̍WɕuȂ悤ɂ邽߂ɕǂĂB
                for (int x = 0; x < roomSizeX; x++) {
                    map[r][x] = Wall; 
                }
                for (int y = 0; y < roomSizeY; y++) {
                    map[r][y * roomSizeX] = Wall;
                }
            }
            //mainCode.initMap(map);
            //        if (visualizeFlag){
            //            env.viewPanel.paint("Map", mapPainter);
            //        }
        }
        public void visualizeMap(){
            env.viewPanel.paint("Map", mapPainter);
        }
        public MapPainter mapPainter = new MapPainter();
        public int charSize = panel.getInt("charSize", 24, 1, 40);
        public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
        //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
        public class MapPainter extends Lab.Code implements Lab.Painter {
            public Dimension getSize(){
                int totalSizeX = mapSizeX * roomSizeX;
                int totalSizeY = mapSizeY * roomSizeY;
                return new Dimension(charSize * (totalSizeX + 1),
                        charSize * (totalSizeY + 1));
            }
            int counter = 0;
            public void paintComponent(Graphics g, MouseEvent lastEvent) {
                // W (0,0) ƂB
                // x=0 or y=0 ͕ǁBǂł͂Ȃ x, y >= 1 Ŵݕ`悷B 
                g.setFont(f);
                for (int ry = 0; ry < mapSizeY; ry++) {
                    for (int rx = 0; rx < mapSizeX; rx++) {
                        g.setColor(Color.BLACK);
                        g.drawString(roomNames[ry * mapSizeX + rx].toString(),
                                posX(rx, ry, 1, roomSizeY-1), 
                                posY(rx, ry, 1, roomSizeY-1));

                        for (int y = 1; y < roomSizeY; y++) {
                            for (int x = 1; x < roomSizeX; x++) {
                                int r = ry * mapSizeX + rx;
                                int p = y * roomSizeX + x; 
                                String str = map[r][p].code;
                                g.setColor(Color.BLACK);
                                g.drawString(str,
                                        posX(rx, ry, x, y-1), 
                                        posY(rx, ry, x, y-1));
                            }
                        }
                    }
                }
                for (int i = 0; i < agents.length; i++) {
                    paintAgent(agents[i], g);
                }
            }
            public void paintAgent(Agent a, Graphics g) {
                int roomID = a.getCurrentRoomID();
                int selfRX = roomID % mapSizeX;
                int selfRY = roomID / mapSizeX;
                int selfX = 0, selfY = 0;
                // Find self
                for (int y = 1; y < roomSizeY; y++) {
                    for (int x = 1; x < roomSizeX; x++) {
                        if (map[roomID][y * roomSizeX + x] == a.agentName) {
                            selfX = x; selfY = y;
                        }
                    }
                }
                Lab.assertTrue(selfX != 0 && selfY != 0);

                //            int rx = roomID % mapSizeX;
                //            int ry = roomID / mapSizeX;
                //            int where1 = a.newS.getInt(O1_where);
                //            Lab.assertTrue(where1 != -1);
                //            int x1 =  where1 % roomSizeX;
                //            int y1 =  where1 / roomSizeX;
                //            int where2 = a.newS.getInt(O2_where);
                //            Lab.assertTrue(where2 != -1);
                //            int x2 =  where2 % roomSizeX;
                //            int y2 =  where2 / roomSizeX;
                //            
                //            if (x1 != 0 && y1 != 0) {
                //                g.setColor(Color.GREEN);
                //                g.drawRect(posX(rx, ry, x1, y1), posY(rx, ry, x1, y1),
                //                        charSize - 2, charSize - 2);
                //                g.drawString("1", 
                //                        posX(rx, ry, x1, y1), posY(rx, ry, x1, y1));
                //                
                //                g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                //                        posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                //                        posX(rx, ry, x1, y1) + charSize/2,
                //                        posY(rx, ry, x1, y1) + charSize/2);
                //            }
                //            if (x2 != 0 && y2 != 0) {
                //                g.setColor(Color.RED);
                //                // `̘g2sNZ炵ĕ\B
                //                g.drawRect(posX(rx, ry, x2, y2) + 2, posY(rx, ry, x2, y2) + 2,
                //                        charSize - 2, charSize - 2);
                //                g.drawString("2", 
                //                        posX(rx, ry, x2, y2), posY(rx, ry, x2, y2));
                //                
                //                g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                //                        posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                //                        posX(rx, ry, x2, y2) + charSize/2,
                //                        posY(rx, ry, x2, y2) + charSize/2);
                //            }
            }
        }
        public int posX(int rx, int ry, int x, int y) {
            return (rx * roomSizeX + x) * charSize;
        }
        public int posY(int rx, int ry, int x, int y) {
            return  (mapSizeY * roomSizeY 
                    - (ry * roomSizeY + y) 
                    )
                    * charSize;
        }
        public Integer stateElemToInteger(Object elem) {
            if (elem instanceof Integer) {
                return (Integer)elem;
            } else {
                return null;
            }
        }

        /**
         * fobOpɏóB
         */
        public void printWorldInfo() {
            System.out.println();
            System.out.println("mainCode = "+  AbstractMainCode.this.getClass().getName());
            System.out.println();

            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                System.out.println("Rules for agent "+ a.agentName);
                for (int j = 0; j < a.rules.size(); j++) {
                    System.out.println(""+ a.rules.get(j));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    //--------------------------------------------------
    // DSL for rule definition. 
    VariableN o1 = new VariableN("o1");
    VariableN x1 = new VariableN("x1");
    VariableN o2 = new VariableN("o2");
    VariableN x2 = new VariableN("x2");
    VariableN x = new VariableN("x");
    VariableN y = new VariableN("y");
    VariableN z = new VariableN("z");
    VariableN room = new VariableN("room");
    public static final String __ = Rule.WILDCARD; // Two underscores.
    public static final String PLS = Rule.PLS;
    public static final String NA = "NA".intern();
    public RegisterN a(Conj conj, ClauseN c0, ClauseN c1) { return new RegisterN("a", conj, c0, c1); }
    public RegisterN b(Conj conj, ClauseN c0, ClauseN c1) { return new RegisterN("b", conj, c0, c1); }
    public RegisterN s(Conj conj, ClauseN c0, ClauseN c1) { return new RegisterN("s", conj, c0, c1); }
    public RegisterN e(Conj conj, ClauseN c0, ClauseN c1) { return new RegisterN("e", conj, c0, c1); }
    public RegisterN a(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
        return new RegisterN("a", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
    }
    public RegisterN b(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
        return new RegisterN("b", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
    }
    public RegisterN s(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
        return new RegisterN("s", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
    }
    public RegisterN e(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
        return new RegisterN("e", Conj.Simple, new ClauseN(when, where, who, doWhat, o0, o1), null); 
    }

    public RegisterN a(Object who, Object doWhat) {
        return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
    }
    public RegisterN b(Object who, Object doWhat) {
        return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
    }
    public RegisterN s(Object who, Object doWhat) {
        return new RegisterN("s", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
    }
    public RegisterN e(Object who, Object doWhat) {
        return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0), null); 
    }

    public RegisterN a(Object doWhat) {
        return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
    }
    public RegisterN b(Object doWhat) {
        return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
    }
    public RegisterN s(Object doWhat) {
        return new RegisterN("s", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
    }
    public RegisterN e(Object doWhat) {
        return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Area.Anywhere, 0, doWhat, 0, 0), null); 
    }

    public ClauseN c(Object when, Object where, Object who, Object doWhat, Object o0, Object o1) {
        return new ClauseN(when, where, who, doWhat, o0, o1); 
    }
    public ClauseN c(Object who, Object doWhat) {
        return new ClauseN(Time.Anytime, Area.Anywhere, who, doWhat, 0, 0); 
    }
    //public ClauseN c(Object... args) { return parseClause(args); }
    //public PropositionN a(Object... args) { return parseSimpleSentence("a", args); }
    //public PropositionN b(Object... args) { return parseSimpleSentence("b", args); }
    //public PropositionN s(Object... args) { return parseSimpleSentence("s", args); }
    //public PropositionN e(Object... args) { return parseSimpleSentence("e", args); }
    //public PropositionN parseSimpleSentence(String regName, Object[] args) {
    //    return new PropositionN(regName, Conj.Simple, parseClause(args), null);
    //}
    //public ClauseN parseClause(Object[] args) {
    //    if (args.length != 6) throw new Error("parseClauseArgs: args' length is not 6: "+ args);
    //    return new ClauseN(args[0], args[1], args[2], args[3], args[4], args[5]);
    //}
    public StateN w(RegisterN a, RegisterN b, RegisterN s, RegisterN e){
        if (! (a.regName.equals("a")
                && b.regName.equals("b")
                && s.regName.equals("s")
                && e.regName.equals("e")
                )){
            throw new Error("Syntax error in s("+ a+ ", "+ b+ ", "+ s+ ", "+ e+ ")");
        }
        return new StateN(a, b, s, e);
    }
    // w(a(...), b(...)) or w(a(...), e(...))
    public StateN w(RegisterN a, RegisterN x){ 
        if (! a.regName.equals("a")){
            throw new Error("Syntax error in s("+ a+ ", "+ x+ ")");
        } else if (x.regName.equals("b")) {
            return new StateN(a, x, null, null);
        } else if (x.regName.equals("s")) {
            return new StateN(a, null, x, null);
        } else if (x.regName.equals("e")) {
            return new StateN(a, null, null, x);
        } else {
            throw new Error("Syntax error in s("+ a+ ", "+ x+ ")");          
        }
    }
    // w(a(...)) or w(b(...)) or w(s(...)) or w(e(...))
    public StateN w(RegisterN x){ 
        if (x.regName.equals("a")){
            return new StateN(x, null, null, null);
        } else if (x.regName.equals("b")) {
            return new StateN(null, x, null, null);
        } else if (x.regName.equals("s")) {
            return new StateN(null, null, x, null);
        } else if (x.regName.equals("e")) {
            return new StateN(null, null, null, x);
        } else {
            throw new Error("Syntax error in s("+ x+ ")");          
        }
    }
    public StateN w() {
        return new StateN(null, null, null, null);
    }
    public ActionN call(StateN s){ return new ActionN(Call, s); }
    public ActionN call(RegisterN s){ return new ActionN(Call, w(s)); }
    public ActionN set(RegisterN s) { return new ActionN(Set, w(s)); }
    public ActionN set(StateN s) { return new ActionN(Set, s); }
    //public ActionN setA(Conj conj, ClauseN c0, ClauseN c1) { return new ActionN(SetA, w(new RegisterN("a", conj, c0, c1))); }
    //public ActionN setB(Conj conj, ClauseN c0, ClauseN c1) { return new ActionN(SetB, w(new RegisterN("b", conj, c0, c1))); }
    //public ActionN setA(ClauseN c0) { return new ActionN(SetA, w(new RegisterN("a", Conj.Simple, c0, null))); }
    //public ActionN setB(ClauseN c0) { return new ActionN(SetB, w(new RegisterN("b", Conj.Simple, c0, null))); }

    public ActionN recall(RegisterN s){
        if (! s.regName.equals("e")) throw new Error("Argument of recall should be e(...)");
        return new ActionN(Recall, w(s)); 
    }
    public ActionN recall(ClauseN c){ return new ActionN(Recall, w(e(Conj.Simple, c, null))); }
    //public ActionN memorize(StateN s){ return new ActionN(Memorize, s); }
    //public ActionN memorize(RegisterN s){ return new ActionN(Memorize, w(s)); }
    //  public ActionN say(Object... args){
    //    return new ActionN(Say, new StateN(Arrays.asList(args)));
    //}

    // To define task goal. Usage: taskGoal(a(...));
    public void taskGoal(StateN x) {
        StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
        rule(w(), tg, call(x));
        rule(x, tg, set(a(Verb.TaskCompleted)));
    }

    /**
     * Agent ƂɎs[WA̍ۂɈꎞIɓϐB
     */
    public List<RuleN> ruleList;
    // rule(s, g, call/set(...))
    public void rule(StateN s, StateN g, ActionN a){ ruleList.add(new RuleN(s, g, a)); }
    public void rule(RegisterN s, StateN g, ActionN a){ ruleList.add(new RuleN(w(s), g, a)); }
    // rule(s, g, Primitive)
    public void rule(StateN s, StateN g, PrimitiveAction a){ ruleList.add(new RuleN(s, g, new ActionN(a, null))); }
    public void rule(RegisterN s, StateN g, PrimitiveAction a){ ruleList.add(new RuleN(w(s), g, new ActionN(a, null))); }
    // rule(s, g, Primitive, s(...))
    public void rule(StateN s, StateN g, PrimitiveAction a, StateN arg){ ruleList.add(new RuleN(s, g, new ActionN(a, arg))); }
    public void rule(RegisterN s, StateN g, PrimitiveAction a, StateN arg){ ruleList.add(new RuleN(w(s), g, new ActionN(a, arg))); }

    /**
     * Agent ƂɎ錾ImA̍ۂɈꎞIɓϐB
     */
    public List<Rule> knowledgeList = new ArrayList<>();
    /**
     * Knowledge declaration.
     */
    public void k(RegisterN e) {
        // ̓sɂAm e  class Rule ̃CX^XɃGR[hĕێB
        if (! e.regName.equals("e")) throw new Error("Knowledge declaration: Usege: k(e(...));");
        RuleN ruleN = new RuleN(new StateN(null, null, null, e), 
                new StateN(null, null, null, null), 
                new ActionN(Set, w(e)));
        Rule r = new Rule(ruleN);
        knowledgeList.add(r);
        System.out.println("k: sharedKnowledgeBase.add: "+ r );
    }



    // End of DSL functions.

    // Methods for Task initialization.
    //
    public abstract Agent[] makeAgents(World world);
    /**
     * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
     * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
     * ݒ肷邱Ƃ\B
     */
    public void initAgentsTable(World world) {
        for (int i = 0; i < world.agents.length; i++) {
            Agent a = world.agents[i];
            ruleList = new ArrayList<>();
            addRules(i);
            a.rules = ruleList.stream().map(
                    ruleN ->  new Rule(ruleN)
                    ).collect(Collectors.toList());
            for (int j = 0; j < a.rules.size(); j++) {
                a.rules.get(j).ruleID = j; // Use for debug.
            }

            // KvȂ q lBƂ肠Ô܂܂ƂB

            if (panel.flag("Add incorrect rules", false)) {
                addIncorrectRules(a);
            }
        }
    }
    public abstract void addRules(int agentID);
    /*
     * KȂs[ǉBs[̉l̊wK@\̃eXgEfړIB
     */
    public void addIncorrectRules(Agent a) {
        // ruleList ݂̌̒lgāAȂs[쐬B
        List<RuleN> extraRuleList = new ArrayList<>();
        // es[ƂɁAANV Fail ɕςuԈs[vǉB
        int n = ruleList.size();
        ruleList.forEach(rule -> {
            extraRuleList.add(new RuleN(rule.s,
                    rule.g, 
                    new ActionN(Fail, null))
                    );
        });
        a.rules.addAll(extraRuleList.stream().map(
                ruleN ->  new Rule(ruleN)
                ).collect(Collectors.toList())
                );
    }

    /**
     * }bṽCAEg̐ݒB
     * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
     */
    public void setMap(World world) {
        mapSizeX = 1;
        mapSizeY = 1;
        world.roomNames = new Area[]{ Area.Room1 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    /**
     * wK̃Gs\[hsƂ̏̃\bhōsB 
     */
    public abstract void initEpisode(World world); 

    public static void putItemAtRandomPosInRoom(Item[] room, Item item){
        for (int i = 0; i < 10000; i++) {
            int x = Lab.irand(room.length);
            if (room[x] == Space){
                room[x] = item;
                return;
            }
        }
        throw new Error("putItemAtRandomPosInRoom0: no space found.");
    }
}
//--------------------------------------------------
//--------------------------------------------------
//Demo Task definitions
//f  Nut ̏ꏊ𕷂ꂽ狳ĂB
//Ƃ肠Ӑ}ȂB
//public static class DemoLang2 extends AbstractMainCode {
//public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
//public void listRules(){
//    // Thanks ƌĂ炤Tu[`B
////    StateN g1 = s(sentence(Verb.Thanks, 0));
////    rule(s(sentence(Verb.WhereIs, x)), g1, Call, s(o1(x,PLS)));
////    rule(s(o1(x,PLS),sentence(Verb.WhereIs, x)), g1, Say, s(sentence(Verb.HereIs, x)));
//
//    // Nut IuWFNgWX^ɓTu[`B
//    StateN g2 = s(o1(x,PLS));
//    rule(s(), g2, Set, s(r(1),o1(PLS,PLS)));
//}
//public void initEpisode(World world){ 
//    world.agents[0].currentRoom = RoomName.Room1;
//    putItemAtRandomPosInRoom(world.map[0], Self);
//    putItemAtRandomPosInRoom(world.map[0], Grass);
//    putItemAtRandomPosInRoom(world.map[0], Grass);
//    putItemAtRandomPosInRoom(world.map[0], Grass);
//    putItemAtRandomPosInRoom(world.map[0], Nut);
//    world.agents[0].setStartAndGoal(
//            Rule.makeState(s(sentence(Verb.WhereIs, Nut)), 0),
//            Rule.makeState(s(sentence(Verb.Thanks,0)), __)
//            );
//}
//}

//fobOp
//public static class Demo0 extends AbstractMainCode {
//public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
//public void listRules(){
// // Shell ɓB
// StateN g1 = s(o1(Shell,PLS));
// //rule(s(), g1, Set, s(r(1),o1(PLS,PLS)));
// rule(s(), g1, Set, s(r(1),o1(Shell,PLS)));
//}
//public void initEpisode(World world){
// world.agents[0].energy = 1;
// world.agents[0].currentRoom = RoomName.Room1;
// putItemAtRandomPosInRoom(world.map[0], Self);
// putItemAtRandomPosInRoom(world.map[0], Grass);
// putItemAtRandomPosInRoom(world.map[0], Grass);
// putItemAtRandomPosInRoom(world.map[0], Stone);
// putItemAtRandomPosInRoom(world.map[0], Shell);
// world.agents[0].setGoal(
//         Rule.makeState(s(o1(Shell,PLS)), __)
//         );
//}
//}


//TODO: bH
//public static class Test1Agents extends AbstractMainCode {
//public Agent[] makeAgents(World world) { return new Agent[] {
//        new Agent(Self, world),
//        new Agent(Brother, world)}; }
//public final StateN goal0 = s(energy(3)); 
//public final StateN goal1 = s(energy(100)); 
//public void listRules(){
//    // ***********
//}
//public void setMap(World world) {
//    mapSizeX = 2;
//    mapSizeY = 1;
//    world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
//    world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
//    Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
//}
//public void initEpisode(World world){ 
//    world.agents[0].currentRoom = RoomName.Room1;
//    world.agents[0].energy = 1;
//    world.agents[0].setGoal(
//            Rule.makeState(goal0, __)
//            );
//    world.agents[1].currentRoom = RoomName.Room2;
//    world.agents[1].energy = 1;
//    world.agents[1].setGoal(
//            Rule.makeState(goal1, __)
//            );
//    
//    putItemAtRandomPosInRoom(world.map[0], Self);
//    putItemAtRandomPosInRoom(world.map[0], Grass);
//    putItemAtRandomPosInRoom(world.map[0], Grass);
//    putItemAtRandomPosInRoom(world.map[0], Nut);
//    putItemAtRandomPosInRoom(world.map[0], Nut);
//    putItemAtRandomPosInRoom(world.map[1], Brother);
//    putItemAtRandomPosInRoom(world.map[1], Grass);
//    putItemAtRandomPosInRoom(world.map[1], Grass);
//    putItemAtRandomPosInRoom(world.map[1], Nut);
//    putItemAtRandomPosInRoom(world.map[1], Nut);
//}
//}


public static class Test0Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] { new Agent(Alice, world)}; }
    public void addRules(int agentID){
        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, set(tg));
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new Area[]{ Area.Room1,  Area.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
    }
}

//eXgvÕev[gB
public static class Test1Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {return new Agent[] { new Agent(Alice, world) }; }
    public void addRules(int agentID) {
        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, set(tg));
        //rule(w(), tg, set(a(5)));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

public static class Test2Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object P = "P";
        Object Q = "Q";
        Object R = "R";

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, call(a(R)));
        rule(w(a(R)), tg, set(tg));

        // P,Q  R
        // ̏Ƃ܂ a(Q) 藧Ă邾 set(a(R)) Ă܂B
        // Ă͑f܂ɊԈႤuvASYB
        // ͂AׂĂ̑O񂪐藧Ă邱Ƃ`FbNĂ set(a(R)) ȂƂ߁B
        rule(w(), w(a(R)), call(a(P)));
        rule(w(a(P)), w(a(R)), call(a(Q)));
        rule(w(a(Q)), w(a(R)), set(a(R)));

        //  P
        rule(w(), w(a(P)), set(a(P)));

        //  Q
        rule(w(), w(a(Q)), set(a(Q)));

    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//_̗B
public static class Test3Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object P = "P";
        Object Q = "Q";
        Object R = "R";

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, call(a(R)));
        rule(w(a(R)), tg, set(tg));

        // P,Q  R
        rule(w(), w(a(R)), call(a(P)));
        rule(w(a(P)), w(a(R)), call(a(Q)));
        rule(w(a(Q)), w(a(R)), recall(e(P)));
        rule(w(a(Q),e(P)), w(a(R)), set(a(R)));

        //  P
        rule(w(), w(a(P)), set(a(P)));

        //  Q
        rule(w(), w(a(Q)), set(a(Q)));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//recall ߂̃eXgB
public static class Test4Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object P = "P";
        Object Q = "Q";

        k(e(1,P));
        k(e(2,P));
        k(e(3,Q));
        k(e(4,Q));

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        // mx[X烉_ɑzNB
        //rule(w(), tg, recall(e(1,P)));
        rule(w(), tg, recall(e(0,P)));
        rule(w(), tg, recall(e(0,Q)));
        rule(w(), tg, recall(e(PLS,P)));
        rule(w(), tg, recall(e(PLS,Q)));
        rule(w(), tg, recall(e(__,P)));
        rule(w(), tg, recall(e(__,Q)));
        rule(w(), tg, recall(e(1,__)));
        //      rule(w(), tg, set(a(10,P)));
        //      rule(w(), tg, set(a(11,P)));

    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//recall ߂̃eXgB
public static class Test5Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object P = "P";
        Object Q = "Q";

        k(e(1, x, x, 2, y, y));
        k(e(x, x, x, y, y, y));
        k(e(x, y, z, x, y, z));

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        // mx[X烉_ɑzNB
        rule(w(), tg, recall(e(1, 2, 3, 4, 5, 6)));
        rule(w(), tg, recall(e(1, 1, 1, 2, 2, 2)));
        rule(w(), tg, recall(e(1, 2, 3, 1, 2, 3)));
        rule(w(), tg, recall(e(1, 0, 0, 0, 0, 0)));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//ȂBӖL̃NG̃ChJ[h 0 ɕςA}b`ȂȂB 
public static class Test6Episode2 extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        VariableN x1 = new VariableN("x1");
        VariableN x2 = new VariableN("x2");
        VariableN x3 = new VariableN("x3");
        VariableN x4 = new VariableN("x4");
        VariableN x5 = new VariableN("x5");
        VariableN x6 = new VariableN("x6");
        VariableN y1 = new VariableN("y1");
        VariableN y2 = new VariableN("y2");
        VariableN y3 = new VariableN("y3");
        VariableN y4 = new VariableN("y4");
        VariableN y5 = new VariableN("y5");
        VariableN y6 = new VariableN("y6");
        Object Socrates = "Socrates";
        Object Is = "Is";
        Object AMan = "AMan";
        Object Mortal = "Mortal";
        Conj If = Conj.If;

        k(e(0, 0, Socrates, Is, AMan, 0));
        k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
        rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));

        // Modus Ponens
        RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
        RegisterN eif0y = e(If, c(0,0,0,0,0,0), c(y1,y2,y3,y4,y5,y6));
        RegisterN ax = a(x1,x2,x3,x4,x5,x6);
        RegisterN ay = a(y1,y2,y3,y4,y5,y6);
        rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
        rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
        rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
        rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

        RegisterN ex = e(x1,x2,x3,x4,x5,x6);
        rule(w(),   w(ax), recall(ex));
        rule(w(ex), w(ax), set(ax));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}
//ӖLgBiNGChJ[h܂łBA 0 ɕςƓȂBj
public static class Test6Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        VariableN x1 = new VariableN("x1");
        VariableN x2 = new VariableN("x2");
        VariableN x3 = new VariableN("x3");
        VariableN x4 = new VariableN("x4");
        VariableN x5 = new VariableN("x5");
        VariableN x6 = new VariableN("x6");
        VariableN y1 = new VariableN("y1");
        VariableN y2 = new VariableN("y2");
        VariableN y3 = new VariableN("y3");
        VariableN y4 = new VariableN("y4");
        VariableN y5 = new VariableN("y5");
        VariableN y6 = new VariableN("y6");
        Object Socrates = "Socrates";
        Object Is = "Is";
        Object AMan = "AMan";
        Object Mortal = "Mortal";
        Conj If = Conj.If;

        // XXX: when, where  0 ?
        k(e(0, 0, Socrates, Is, AMan, 0));
        k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

        //      StateN tg = w(a(Verb.TaskCompleted)); // task goal
        //      rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
        //      rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));
        taskGoal(w(a(0, 0, Socrates, Is, Mortal, 0)));      

        // Modus Ponens
        RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
        RegisterN eif0y = e(If, c(__,__,__,__,__,__), c(y1,y2,y3,y4,y5,y6));
        RegisterN ax = a(x1,x2,x3,x4,x5,x6);
        RegisterN ay = a(y1,y2,y3,y4,y5,y6);
        rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
        rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
        rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
        rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

        RegisterN ex = e(x1,x2,x3,x4,x5,x6);
        rule(w(),   w(ax), recall(ex));
        rule(w(ex), w(ax), set(ax));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

public static class Test7Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object Yesterday = "Yesterday";
        Object Today = "Today";
        Object Home = "Home";
        Object Chocolate = "Chocolate";
        Object Snack = "Snack";
        Object Exists = "Exists";
        Object Brother = "Brother";
        Object NotEat = "NotEat";

        k(e(Yesterday, Home, Chocolate, Exists, 0,  0));
        k(e(Yesterday, Home, Snack, Exists, 0,  0));
        k(e(Today, Home, Brother, NotEat, Chocolate, 0));

        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        StateN g = w(a(Today, Home, PLS, Exists, 0, 0));     // ƂɉiĤׂj邩m肽B
        rule(w(), tg, call(g));
        rule(g, tg, set(a(Verb.TaskCompleted)));

        rule(w(), g, recall(e(Yesterday, Home, PLS, Exists, 0,  0)));
        rule(w(e(Yesterday, Home, x, Exists, 0,  0)), g, set(a(Yesterday, Home, x, Exists, 0,  0)));
        // ͂Ȃ recall ł͂ȂA call ďׂ݂ؖB
        rule(w(a(Yesterday, Home, x, Exists, 0,  0)), g, recall(e(Today, Home, Brother, NotEat, x, 0)));
        rule(w(a(Yesterday, Home, x, Exists, 0,  0), e(Today, Home, Brother, NotEat, x, 0)), 
                g, set(a(Today, Home, x, Exists, 0, 0)));
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}


//Ԉ錾Im̉leXgBfB
public static class Test0008Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) {
        return new Agent[] { new Agent(Alice, world) };
    }
    public void addRules(int agentID) {
        Object P = "P";
        Object Q = "Q";
        Conj If = Conj.If;

        k(e(If, c(P,1), c(Q,1)));
        k(e(If, c(P,2), c(Q,2)));
        k(e(If, c(P,1), c(Q,2)));
        k(e(If, c(P,2), c(Q,1)));
        // ̂Q̂ǂꂩ_ɑzNB
        // XXX:  If zNȂ悤ɂȂƁB
        k(e(1, P));
        k(e(2, P));

        /*
         * P ̒l Q 𐄘_AԈlȂ fail BlȂ^XNIB
         */
        StateN tg = w(a(Verb.TaskCompleted)); // task goal
        rule(w(), tg, call(w(a(Q, PLS))));
        rule(w(e(P,1),a(Q,1)), tg, set(a(Verb.TaskCompleted)));
        rule(w(e(P,2),a(Q,2)), tg, set(a(Verb.TaskCompleted)));
        rule(w(e(P,1),a(Q,2)), tg, Fail);
        rule(w(e(P,2),a(Q,1)), tg, Fail);

        // _
        //??????
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//------------------------------------------------------------------
// ΘbeXgP̋ʐeNXB
public abstract static class TScissors extends AbstractMainCode {
    public Agent[] makeAgents(World world) {return new Agent[] { 
            new Agent(Alice, world), 
            new Agent(Bob, world),
            new Agent(Carol, world), 
        };
    }
    /** eViIŋʂɎm`B */ 
    public void addCommonRules(int agentID) {
        if (agentID == 0) {
            Lab.assertTrue(world.agents[agentID].agentName == Alice);
        } else if (agentID == 1) {
            Lab.assertTrue(world.agents[agentID].agentName == Bob);
        } else if (agentID == 2) {
            Lab.assertTrue(world.agents[agentID].agentName == Carol);
        } else {
            Lab.assertTrue(false);
        }
    }
    /** eViIŗL̒m`B */ 
    public void addScenarioRules(int agentID) {
        //    if (agentID == 0) {
        //    } else if (agentID == 1) {
        //    } else if (agentID == 2) {
        //    } else {
        //        Lab.assertTrue(false);
        //    }
    }
    public void addRules(int agentID) {
        addCommonRules(agentID);
        addScenarioRules(agentID);
    }
    public void setMap(World world) {
        world.map = new Item[0][0];
    }
    public void initEpisode(World world) {
    }
}

//ΘbeXgP̂P
// Bob  Alice ɔbă^XNIB
// Alice inT~̏ꏊm肽Bj
// Bob unT~ Room1 ɂBv
public static class TestS1 extends TScissors {
    public void addScenarioRules(int agentID) {
        if (agentID == 0) {
            Lab.assertTrue(world.agents[agentID].agentName == Alice);
            taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
            StateN g = w(a(Now, PLS, Scissors, Exists, 0, 0));
            rule(w(), g, Listen);
            rule(w(a(ThatO2, c(Now, Here, Bob, SaidTo, Alice, 0),
                    c(Now, x, Scissors, Exists, 0, 0))),
                    g,
                    set(a(Now, x, Scissors, Exists, 0, 0)));

        } else if (agentID == 1) {
            Lab.assertTrue(world.agents[agentID].agentName == Bob);
            rule(w(), w(), set(a(ThatO2,
                    c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                    c(Now, Room1, Scissors, Exists, 0, 0))));
            rule(w(a(ThatO2, 
                    c(Now, Here, Bob, WantsToSayTo, __, __), 
                    c(__, __, __, __, __, __))), w(), SayIt);

        } else if (agentID == 2) {
            Lab.assertTrue(world.agents[agentID].agentName == Carol);
            rule(w(), w(), Fail);

        } else {
            Lab.assertTrue(false);
        }
    }
    public void initEpisode(World world) {
    }
}
//ΘbeXgP̂Q
//Alice
// inT~̏ꏊm肽Bj
// inT~̏ꏊmĂ邩Ȃl͒Nm肽Bj
// iBob mĂBj
// uBob, nT~͂ǂɂHvƕB
// ԓ҂
// BobunT~ x ɂBvƌȂ΃nT~ x ɂB
//Bob:
// AliceɁunT~͂ǂɂHvƕꂽuAlice, nT~ Room1 ɂBvƕԎB
public static class TestS2 extends TScissors {
    public void addScenarioRules(int agentID) {
        if (agentID == 0) {
            Lab.assertTrue(world.agents[agentID].agentName == Alice);
            taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
            
            // nT~ǂɂ邩mĂԁB
            StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
            // unT~ǂɂ邩NmĂ邩vmĂԁB
            StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0)));

            // Rule 2-7
            rule(w(), g1, call(g2));
            rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))),
                    g1,
                    set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                            c(Now, Wh, Scissors, Exists, 0, 0))));
            rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
            rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
            rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
                    c(Now, x, Scissors, Exists, 0, 0))),
                    g1,
                    set(a(Now, x, Scissors, Exists, 0, 0)));

            // Bob mĂƌߑłB
            rule(w(), g2, set(a(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))));

        } else if (agentID == 1) {
            Lab.assertTrue(world.agents[agentID].agentName == Bob);
            rule(w(), w(), Listen);
            // ꂽƂɑɕԓB
            // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
            rule(w(a(ThatO2, 
                    c(Now, Here, Alice, SaidTo, Bob, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))),
                    w(), 
                    set(a(ThatO2,
                    c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                    c(Now, Room1, Scissors, Exists, 0, 0))));
            rule(w(a(ThatO2,
                    c(Now, Here, Bob, WantsToSayTo, __, __), 
                    c(__, __, __, __, __, __))), w(), SayIt);

        } else if (agentID == 2) {
            Lab.assertTrue(world.agents[agentID].agentName == Carol);
            rule(w(), w(), Fail);

        } else {
            Lab.assertTrue(false);
        }
    }
    public void initEpisode(World world) {
    }
}

//ΘbeXgP̂R
// Q̔C
// RgCĔ\XChɂ̂B
public static class TestS3 extends TScissors {
    public void addScenarioRules(int agentID) {
        if (agentID == 0) {
            Lab.assertTrue(world.agents[agentID].agentName == Alice);
            taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
            
            k(e(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0)));
            
            // nT~ǂɂ邩mĂԁB
            StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
            // unT~ǂɂ邩NmĂ邩vmĂԁB
            StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0)));

            // Rule 2-7
            rule(w(), g1, call(g2));
            rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))),
                    g1,
                    set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                            c(Now, Wh, Scissors, Exists, 0, 0))));
            rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
            rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
            rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
                    c(Now, x, Scissors, Exists, 0, 0))),
                    g1,
                    set(a(Now, x, Scissors, Exists, 0, 0)));

            // NmĂ邩voĂ݂B
            rule(w(), g2, recall(e(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))));
            rule(w(e(ThatO1, c(Now, Here, z, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))), 
                    g2, 
                    set(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))));

        } else if (agentID == 1) {
            Lab.assertTrue(world.agents[agentID].agentName == Bob);
            rule(w(), w(), Listen);
            // ꂽƂɑɕԓB
            // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
            rule(w(a(ThatO2, 
                    c(Now, Here, Alice, SaidTo, Bob, 0),
                    c(Now, Wh, Scissors, Exists, 0, 0))),
                    w(), 
                    set(a(ThatO2,
                    c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                    c(Now, Room1, Scissors, Exists, 0, 0))));
            rule(w(a(ThatO2,
                    c(Now, Here, Bob, WantsToSayTo, __, __), 
                    c(__, __, __, __, __, __))), w(), SayIt);

        } else if (agentID == 2) {
            Lab.assertTrue(world.agents[agentID].agentName == Carol);
            rule(w(), w(), Fail);

        } else {
            Lab.assertTrue(false);
        }
    }  
    public void initEpisode(World world) {
    }
}



//Default dummy task.
public static class Demo0_Dummy extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
    public void addRules(int agentID){
        throw new StopPressed();
    }
    public void initEpisode(World world){ throw new Error(); }
}
}
