//Copyright (c) 2021 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

CxgWX^EGs\[hL̋@\̃eXgEfpt[[NB

*/

package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v5.PrimitiveAction.*;
import static tmm1.TMM3v5.ER_Index.*;
import static tmm1.TMM3v5.SR_Index.*;
import static tmm1.TMM3v5.Item.*;
//import static tmm1.TMM3v5.Tense.*;
//import static tmm1.TMM3v5.Verb.*;
//import static tmm1.TMM3v5.RoomName.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v5 {
public static void main(String[] args) {
    Lab.addSelectableClass(TMM3v5.class);
    System.out.println(Lab.selectableClasses + "");

    LabCode labCode = new LabCode();
    //labCode.main(AbstractMainCode.class);
    labCode.main(Test0Episode.class);
}
// For debug.
public static void printArray(String s, Object[] a) {
    System.out.print(s+ ": ");
    for (int i = 0; i < a.length; i++) {
		System.out.print(a[i]+ ",");
	}
    System.out.println();
}

/**
 * Primitive actions 
 */
public static enum PrimitiveAction {
    EatO1,
    MoveO2toO1,
    MoveSelfAndEatO1,
    MoveToRoom,
    MoveToRoomWithO1,
    Call,
    Return,
    Set,
    Memorize,
    Recall,
    Say,
    Fail,
}
/**
 * Index of Event Representation 
 */
public static enum ER_Index {
    RegNo,
    // Objects
    O1_what,
    O1_where,
    O2_what,
    O2_where,
    Want_who,
    Want_what,
    CurrentRoom,
    AbsTime,
    RelTime,
    Energy,
    ;
    public static final int length = ER_Index.class.getEnumConstants().length;
}
/**
 * Index of Semantic Representation of a sentence 
 */
public static enum SR_Index {
    // Clause
    S_tense,
    S_subject,
    S_verb,
    S_object,
    S_complement,
    ;
    public static final int length = SR_Index.class.getEnumConstants().length;
}
public static enum Tense {
    Present,
    Past,
    Future,
}
//public static class EventN {
//    public Object[] elems;
//    public int eventNo;
//    public EventN(int eventNo, Object[] elems) {
//        this.eventNo = eventNo;
//        this.elems = elems;
//    }
//}
public static class ERElementN {
    public int eventNo;
    public ER_Index index;
    public Object val;
    public ERElementN(int eventNo, ER_Index index, Object x){
        this.eventNo = eventNo; this.index = index; this.val = x;
    }
    public String toString(){
        return eventNo+ "."+ index+ "("+ val+ ")"; 
    }
}
public static class SRElementN {
    public SR_Index index;
    public Object val;
    public SRElementN(SR_Index index, Object x){
        this.index = index; this.val = x;
    }
    public String toString(){
        return index+ "("+ val+ ")"; 
    }
}
public static enum Item {
    Wall("\u58c1"),  // 
//    Self(""),  // q
//    Mother(""),  // 
//    Brother("Z"),  // Z
//    Stone(""), // 
//    Shell("<>"), // k
//    Nut("o "), // 
//    Grass("h"), // 
    Self("q"),  // q
    Mother(""),  // 
    Brother("Z"),  // Z
    Stone(""), // 
    Shell("k"), // k
    Nut(""), // 
    Grass(""), // 
    //Meat(""), // 
    Nothing(""), // 
    Space("E"); // E 

    public final String code;
    private Item(String code){
        this.code = code;
    }
}
public static enum Verb {
    WhereIs,
    GiveMe,
    HereIs,
    Thanks,
}
public static enum RoomName {
    Room1,
    Room2,
    Room3,
    Storage,
    Garden,
    Shop,
    Park,
}
// Abstract syntax nodes for DSL
public static class StateN {
    public List<Object> elems;
    public StateN(List<Object> vars) { this.elems = vars; }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("s(");
        elems.forEach(obj -> {
            buf.append(obj.toString());
            buf.append(", ");
        });
        buf.append(")");
        return buf.toString();
    }
}
public static class RuleN {
    public StateN s, g;
    public ActionN a;
    public RuleN(StateN s, StateN g, ActionN a){ 
        this.s = s; this.g = g; this.a = a;
    }
    public String toString(){
        return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
    }
}
public static class ActionN {
    public PrimitiveAction a;
    public StateN m;
    public ActionN(PrimitiveAction a, StateN m){ 
        this.a = a; this.m = m;
    }
    public String toString(){
        if (m == null){
            return a.toString();
        } else {
            return a.toString()+ "("+ m+ ")";
        }
    }
}
/**
 * pattern variable 
 */
public static class VariableN {
    public String name;
    public VariableN(String name){ this.name = name; }
}
//public static class UnionN {
//    public StateN[] args;
//    public UnionN(StateN... args){ this.args = args; }
//}


//--------------------------------------------------
/**
 * Q(s,g,a) 𒊏ۉ[B
 * lxNgƃp^[}b`đIB 
 * Usage:
 *   r = new Rule(ruleN);
 *   boolean matched = r.match(vals);
 *   if (matched){
 *      // Access to the last matching results.
 *      Action a = r.getAction();
 *      State s = new State(r.getActionParam());
 *   }
 */
public static class Rule {
    /**
     * Q value of this rule.
     */
    public float q;
    /**
     * Counter for demo.
     */
    public int useCounter = 0;
    /**
     * Number of variables appeared in this Rule.
     */
    public int numVars;
    // \ȃIuWFNgB
    public static final String UNBOUND = "__UNBOUND__";
    // p^[}b`IɖϐɑftHglB
    // O̒lɂ̂݃}b`B
    public static final String PLS = "+".intern();
    // [LO̒l̕ێB
    public static final String KEEP = "=".intern();
    // ChJ[hBCӂ̒lƃ}b`B
    public static final String WILDCARD = "__".intern(); // Two underscores.
    // 萔 0
    public static final Integer ZERO = 0; 
    public Object[] env;
    public Object[] patternVec; // Concatenated pattern of s and g.
    public PrimitiveAction action;
    public Object[] actionPatternVec;  // Pattern of m of action C_m.
    public int idCounter = 0;
    public Map<VariableN,PatternVariable> vmap = new HashMap<>(); 
    public Rule(RuleN ruleN){
        // ruleN ƂɃp^[\zB
        List<Object> elems = transStateN(ruleN.s, WILDCARD);
        elems.addAll(transStateN(ruleN.g, WILDCARD));
        numVars = vmap.size() + 
                (int)elems.stream()
                .filter(e -> e == WILDCARD || e == PLS)
                .count();
        patternVec = elems.toArray();
        action = ruleN.a.a;
        if (ruleN.a.m == null) {
            // It is primitive action.
            actionPatternVec = null;
        } else if (action == PrimitiveAction.Set){
            actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
        } else {
            actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
        }
        env = new Object[vmap.size()];
        vmap = null;
    }
    public Rule(){
       // Implicitly called from ReturnRule().
    }
    // q̗Œ蒷̃[LO̗vfɕϊB
    // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
    public List<Object> transStateN(StateN state, Object defaultValue){
        Object[] sa = state.elems.toArray();
        //printArray("sa", sa);
        Object[] arr = new Object[State.getWMsize()];
        for (int i = 0; i < sa.length; i++) {
            Object elem = sa[i];
            //System.out.println("sa["+ i+ "]="+ elem);
            int index;
            Object val;
            if (elem instanceof ERElementN) {
                ERElementN e = ((ERElementN) elem);
                index = State.getIndexER(e.eventNo, e.index);
                val = e.val;
            } else if (elem instanceof SRElementN) {
                SRElementN e = (SRElementN)elem;
                index = State.getIndexSR(e.index);
                val = e.val;
            } else {
                throw new Error(elem+ " is not a Predicate : "+ sa);
            }
            if (arr[index] != null) {
                throw new Error("Duplicated Predicates: "+ elem+ " in "+ sa);
            }
            arr[index] = transArg(val);
        }
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] == null) {
                arr[i] = defaultValue;
            }
        }
        List<Object> ret = new ArrayList<>();
        ret.addAll(Arrays.asList(arr));
        if (true) {
            System.out.println("transStateN: default="+ defaultValue+ " : "+ state);
            System.out.println(" "+ ret);
        }
        return ret;
    }
    // q̈Bϐɓ id  PatternVariable 蓖ĂB
    public Object transArg(Object e) {
        Object re;
        if (e instanceof String) {
            e = ((String)e).intern();
        }
        if (e == WILDCARD){
            re = e;
        } else if (e instanceof VariableN){
            if (vmap.containsKey(e)){
                re = vmap.get(e);
            } else {
                re = new PatternVariable(((VariableN)e).name,
                        idCounter++);
                vmap.put((VariableN)e, (PatternVariable)re);
            }
        } else if (e instanceof Integer){
            int i = (Integer)e;
            // Accepts only small integers that can be compared with == operator.
            Lab.assertTrue( -128 <= i && i <= 127); 
            re = e;
        } else {
            re = e;
        }
        return re;
    }
    // TODO: t@N^O\Bϐ蓖ĂŏɂB
    public boolean match(Object[] vals){
        Lab.assertTrue(vals.length == patternVec.length);
        for (int i = 0; i < env.length; i++) {
            env[i] = UNBOUND;
        }
        for (int i = 0; i < vals.length; i++) {
            //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
            Lab.assertTrue(vals[i] != KEEP);
            Lab.assertTrue(patternVec[i] != KEEP);
            if (patternVec[i] == WILDCARD){
                // Do nothing.
            } else if (patternVec[i] == PLS){
                if (vals[i] == ZERO) return false;
                //if (vals[i] == WILDCARD) return false;
            } else {
                Object pval;
                if (patternVec[i] instanceof PatternVariable){
                    int id = ((PatternVariable)patternVec[i]).id;
                    if (env[id] == UNBOUND && vals[i] != WILDCARD){
                        pval = env[id] = vals[i];
                    } else {
                        pval = env[id];
                    }
                    //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                    //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                    //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                } else {
                    pval = patternVec[i];
                }
                // pval ͕ϐ蓖čς݂̃p^[̒lB
                // pval ̕ vals[i] LȂ return false B
                if (pval == WILDCARD){
                    System.out.println("this="+ this);
                    Lab.assertTrue(false);
                } else if (pval == UNBOUND){
                    // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                    Lab.assertTrue(vals[i] == WILDCARD);
                    // XXX: ̂悤ȏł悢̂낤H
                } else if (pval == PLS){
                    if (vals[i] == ZERO) return false;
                    //if (vals[i] == WILDCARD) return false;
                } else {
                    if (vals[i] != pval) return false;
                }
            }
            //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
            //for (int j = 0; j < env.length; j++) {
            //    System.out.println("env["+ j+ "]="+ env[j]);
            //}
        }
        //System.out.println("*** match ****");
        return true;
    }
    public PrimitiveAction getAction(){
        return action;
    }
    // p^[}b`́ul̃xNgvoB
    public Object[] getActionParam(){
        Object[] ret = actionPatternVec.clone();
        for (int i = 0; i < ret.length; i++) {
            if (ret[i] == WILDCARD){
                // ret[i] = WILDCARD;
            } else if (ret[i] instanceof PatternVariable){
                int id = ((PatternVariable)actionPatternVec[i]).id;
                if (env[id] == UNBOUND){
                    throw new Error("UNBOUND in action param");
                } else {
                    ret[i] = env[id];
                }
            }
        }
        return ret;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        Lab.assertTrue(patternVec.length % 2 == 0);
        int stateLength = patternVec.length / 2;
        buf.append("rule((");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[i]+ ",");
        }
        buf.append("), (");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[stateLength + i]+ ",");
        }
        buf.append("), ");
        if (actionPatternVec != null){
            buf.append(action+ "(");
            for (int i = 0; i < actionPatternVec.length; i++) {
                buf.append(actionPatternVec[i]+ ",");
            }
            buf.append(")");
        } else {
            buf.append(action+ "");
        }
        buf.append(").q = "+ q);
        return buf.toString();
    }
    public static class PatternVariable {
        String name;
        int id;
        public PatternVariable(String name, int id){ 
            this.name = name; this.id = id; 
        }
        //public String toString() { return ""+ id+ ":"+ name; }
        public String toString() { return ""+ name; }
    }
    // Special instance used for Action.Return
    public static final Rule returnRule = new ReturnRule();
    // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
    //   ReturnRule ̃CX^X𖳗gĂB
    public static State makeState(StateN stateN, Object defaultValue) {
        return new State(returnRule.transStateN(stateN, defaultValue).toArray());
    }
}
public static class ReturnRule extends Rule {
    public ReturnRule(){
        action = PrimitiveAction.Return;
        q = 0; // Q(g,g,RET) == 0
    }
    public String toString(){
        return "rule(Return).q = "+ q;
    }
}
/**
 * Q(s,g,call(m))  s, g, m \邽߂̃f[^\B
 */
public static class State {
    public Object[] values;
    public State(Object[] values) { this.values = values; }
//    public Object[] getVec(){
//        return values;
//    }
    /**
     * Compares two states in order to check if the agent reaches 
     * the subgoal state g. 
     * State g may contain the special values: PLS and/or WILDCARD. 
     */
    public boolean satisfies(State g){
        Object[] gv = g.values;
        Lab.assertTrue(values.length == gv.length);
        for (int i = 0; i < gv.length; i++) {
            if (gv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (gv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != gv[i]) return false;
            }
        }
        return true;
    }
    /**
     * Gs\[hL̂߂̃}b`OB
     * key Ɋ܂܂ĂqꂪׂĊ܂܂ĂȂ true ԂB
     * TODO: L[Ώۂ State ł͂ȂCxgɕύXB
     */
    public boolean episodeMatch(State key) {
        Object[] kv = key.values;
        //printArray("episodeMatch: key", kv);
        //printArray("episodeMatch: state", values);
        Lab.assertTrue(values.length == kv.length);
        for (int i = 0; i < kv.length; i++) {
            if (kv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (kv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != kv[i]) return false;
            }
        }
        return true;
        
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("State(");
        for (int i = 0; i < values.length; i++) {
            buf.append(values[i].toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
    
    // Working Memory management
    public static final int headerSize = 1;
    public static final int numEventRegisters = 2;
    public static final int getWMsize() {
        return headerSize 
                + numEventRegisters * ER_Index.length
                + SR_Index.length;
    }
    
    // State  n Ԗڂ̗vf𐮐ɂĕԂB̏ꍇ -1 ԂB
    public int getIntArg(int n) {
        Object x = values[n];
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        } else {
            return -1;
        }
    }
    public Object get(ER_Index index) { return get(1, index); }
    public int getInt(ER_Index index) {return getInt(1, index); }
    public void set(ER_Index index, Object x) { set(1, index, x); }
    public Object get(int eventNo, ER_Index index) { 
        return values[getIndexER(eventNo, index)]; 
    }
    public int getInt(int eventNo, ER_Index index) { 
        return getIntArg(getIndexER(eventNo, index)); 
    }
    public void set(int eventNo, ER_Index index, Object x) {
        values[getIndexER(eventNo, index)] = x; 
        }
    public static final int getIndexER(int eventNo, ER_Index index) {
        return headerSize
                + (eventNo - 1) * ER_Index.length
                + index.ordinal();
    }
    //
    public Object get(SR_Index index) { return values[getIndexSR(index)]; }
    public int getInt(SR_Index index) { return getIntArg(getIndexSR(index)); }
    public void set(SR_Index index, Object x) { values[getIndexSR(index)] = x; }
    public static final int getIndexSR(SR_Index index) {
        return headerSize
                + numEventRegisters * ER_Index.length
                + index.ordinal();
    }
}


//--------------------------------------------------
public static abstract class AbstractMainCode extends Lab.MainCode {
    //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
    public int maxSteps = panel.getInt("max steps", 100, 1, 10000);
    public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
    public float rewardC = panel.getFloat("R^C", -1, -10, 0);
//  public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
//  public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
    public int mapSizeX;
    public int mapSizeY;
    public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
    public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
    public float vScale; 
    public lab.Lab.WTextArea qView = null;
    public AbstractMainCode mainCode = this; // Main ZN^őIB
 
    public void main() {
        World world = new World();
        world.printWorldInfo();
        world.main();
    }
    
    public class Agent {
        public State newS; // state
        public State newG; // subgoal
        public Rule newR; // rule 
        public State oldS;
        public State oldG;
        public Rule oldR;
        public State actionParamState; 
        public float reward;
        public Stack<State> stack;
        public State start, goal;
        public boolean failedFlag;
        public float stackValue;
        public State failedState;
        //
        public World world;
        public RoomName currentRoom;
        public int energy;
        //public int currentPos;
        public Item selfItem; // Item that represents the agent itself.
        public List<Rule> rules;
        //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
        public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
        //
        public Agent(Item selfItem, World world){
            this.selfItem = selfItem;
            this.world = world;
        }
        public void setGoal(State g){
            State s = Rule.makeState(s(energy(1)), 0);
            setStartAndGoal(s, g);
        }
        public void setStartAndGoal(State s, State g){
            oldS = newS = start = s;
            oldG = newG = goal = g;
            failedState = s;
        }
        public void chooseFirstAction(){
            stack = new Stack<State>();
            chooseAction();
            oldR = newR;
        }
        // 
        public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
        public void takeAction(){
            PrimitiveAction action = oldR.getAction();
            failedFlag = false;

            if (panel.flag("Action log", true)) {
                StringBuffer buf = new StringBuffer();
                // indent
                for (int i = 0; i < stack.size(); i++) {
                    buf.append("  ");
                }
                buf.append(action.toString());
                if (actionParamState != null) {
                    buf.append('(');
                    Object[] values = actionParamState.values;
                    if (values.length > 0) {
                        buf.append(values[0].toString());
                        for (int i = 1; i < values.length; i++) {
                            buf.append(',');
                            buf.append(values[i].toString());
                        }
                    }
                    buf.append(')');
                }
                env.viewPanel.println("Action log "+ selfItem, buf.toString());
            }

            if (action == PrimitiveAction.Return){
                newS = oldS;
                newG = stack.pop();
                reward = 0;
            } else if (action == PrimitiveAction.Call){
                newS = oldS;
                stack.push(oldG);
                newG = actionParamState;
                reward = rewardC;
            } else if (action == PrimitiveAction.Set){
                //newS = actionParamState;

                newS = observe(actionParamState, oldS);
                if (newS != null){
                    newG = oldG;
                    reward = rewardC;
                } else {
                    // fail
                    failedFlag = true;
                    stackValue = evalStack(oldG, stack);
                    newS = failedState;  // XXX:
                    newG = goal;
                    stack.clear();
                    reward = rewardC + failPenalty;
                }
            } else if (action == PrimitiveAction.Fail){
                failedFlag = true;
                stackValue = evalStack(oldG, stack);
                newS = failedState;
                newG = goal;
                stack.clear();
                reward = rewardC + failPenalty;
            } else {
                reward = rewardC;
                State newS = new State(oldS.values.clone());
                takePrimitiveActionAndObserve();
                newG = oldG;
            }
        }
        public void chooseAction(){
            if (newS.satisfies(newG)){
                newR = Rule.returnRule;
                actionParamState = null;
            } else {
                List<Rule> matched = selectMatchedRules(newS, newG);
                
//                matched.forEach(r -> {
//                    System.out.println("matched: "+ r);
//                    if (r.action == Action.Call || r.action == Action.Set) {
//                        System.out.println("  a="+ r.action);
//                        System.out.println("  m="+ new State(r.getActionParam()));
//                    }
//                });
                
                float[] q = calcRulePriorities(matched);
                if (q.length == 0){
                    throw new Error("No action selected: (news,newG)="+ 
                            newS+ ", "+ newG);
                }
                // softmax  Rule PIB
                int index = softmax(q);
                if (panel.flag("Show matched rules", false)){
                    for (int i = 0; i < matched.size(); i++) {
                        env.viewPanel.println("matched"+ selfItem, i+ ":"+ matched.get(i));
                    }
                    for (int i = 0; i < q.length; i++) {
                        env.viewPanel.println("priority"+ selfItem, i+ ":"+ q[i]);
                    }
                    for (int i = 0; i < probTable.length; i++) {
                        env.viewPanel.println("probTable"+ selfItem, i+ ":"+ probTable[i]);
                    }
                }
                newR = matched.get(index);
                if (newR.actionPatternVec == null) {
                    actionParamState = null;
                } else {
                    actionParamState = new State(newR.getActionParam());
                }
            }
        }
        public List<Rule> selectMatchedRules(State s, State g){
            // s,g ̒lzB
            Object[] vals = new Object[s.values.length + g.values.length];
            for (int i = 0; i < s.values.length; i++) {
                vals[i] = s.values[i];
            }
            for (int i = 0; i < g.values.length; i++) {
                vals[i + s.values.length] = g.values[i];
            }
            //rules.forEach(r -> r.resetMatchResult());
            // (s,g) Ƀ}b`郋[IB
            // [̐ parallelStream gĂ݂B
            List<Rule> matched = rules.stream().filter(
                    r -> r.match(vals)
            ).collect(Collectors.toList());
            return matched;
        }
        public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
        public float[] calcRulePriorities(List<Rule> matched){
            float[] q = new float[matched.size()];
            for (int i = 0; i < q.length; i++) {
                Rule r = matched.get(i);
                // numVars ɉyieB^Bϐ̐Ȃ[DB
                float val = r.q - genericityPenalty * r.numVars;
                q[i] = val;
            }
            return q;
        }
        public void update() {
            if (oldR == Rule.returnRule){
                // Do nothing.
            } else if (failedFlag){
                float delta = reward + newR.q - oldR.q - stackValue;
                oldR.q += alpha * delta;
            } else {
                //q[oldS][oldA] += alpha * (reward + q[newS][newA] - q[oldS][oldA]);
                float vg; // V_g(g')
                if (oldG == newG){
                    vg = 0;
                } else {
                    vg = evalValue(oldG, newG);
                }
                //System.out.println(oldR+ ":vg="+vg);
                float delta;
                delta = reward + newR.q - oldR.q + vg;
                //System.out.println(delta);
                oldR.q += alpha * delta;
            }

            oldS = newS;
            oldG = newG;
            oldR = newR;
        }
        // Not tested enough.
        // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
        public float evalStack(State g, Stack<State> stack) {
            State ss = g;
            float ret = 0;
            for (int i = stack.size() - 1; i >= 0; i--) {
                //System.out.println("Stack!:"+ stack.get(i));
                State gg = stack.get(i);
                //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
                ret += evalValue(gg, ss);
                ss = gg;
            }
            //System.out.println("evalStack = "+ ret);
            return ret;
        }
        public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
        /** Returns V_g(s) */
        public float evalValue(State g, State s){
            List<Rule> matched = selectMatchedRules(s, g);
            float[] q = calcRulePriorities(matched);
            if (approxValueEvalFlag){
                // V_g(s) \approx max_a Q(s,g,a)
                int i = Lab.argmax(q); 
                return matched.get(i).q;
            } else {
                // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
                calcProbTable(q, 0, q.length);
                float val = 0;
                for (int i = 0; i < probTable.length; i++) {
                    // To avoid 0 * -Infinity = NaN
                    float value = matched.get(i).q;
                    if (value != Float.NEGATIVE_INFINITY){
                        val += probTable[i] * value;
                    }
                }
                return val; 
            }
        }
        
        
        // Softmax
        public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
        public int softmax(float[] q){ return softmax(q, 0, q.length); }
        public int softmax(float[] q, int from, int to){
            calcProbTable(q, from, to);
//            System.out.println("probTable=");
//            for (int i = 0; i < probTable.length; i++) {
//                System.out.print(probTable[i]+ ", ");
//            }
//            System.out.println();
            float r = Lab.rand();
            double sum = 0;
            for (int i = from; i < to; i++){
                sum += probTable[i]; 
                if (sum > r) {
                    Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                    return i;
                }
            }
            Lab.assertTrue(sum - 0.001f < 1);
            Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
            return to - 1;
        }
        // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
        public void calcProbTable(float[] q, int from, int to){
            if (q.length != probTable.length){
                probTable = new double[q.length];
            }
            float max = Lab.max(q);
            double total = 0;
            for (int i = from; i < to; i++){
                // To avoid overflow, subtract max.
                // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
                double val = Math.exp(beta * (q[i] - max));
                probTable[i] = val;
                total += val;
//                 System.out.println("q["+ i+ "]="+ q[i]);
//                 System.out.println("val="+ val);
            }
//            System.out.println("total="+ total);
            Lab.assertTrue(total > 0);
            for (int i = from; i < to; i++){
                probTable[i] /= total;
            }
        }
        
        public boolean achieved() {
            return stack.size() == 0 && newR.getAction() == PrimitiveAction.Return; 
        }
        
        
        /**
         * ̎ state ̒lA\Ɗϑ𓥂܂Č肵ԂB
         * \ƊϑĂꍇ fail \l null ԂB
         */
        public State observe(State setArg, State oldS) {
        	final boolean alog = true;
        	if (alog) {
        		System.out.println("s: "+ setArg);
        		System.out.println("o: "+ oldS);
        	}
            Object[] prior = new Object[State.getWMsize()];
            for (int i = 0; i < prior.length; i++) {
                if (setArg.values[i] == Rule.KEEP) {
                    prior[i] = oldS.values[i];
                } else {
                    prior[i] = setArg.values[i];
                }
            }
            if (alog) printArray("prior", prior);
            Object[] likelihood = new Object[State.getWMsize()];
//            for (int i = 0; i < likelihood.length; i++) {
//                likelihood[i] = null;
//            }

            int eventNo = 1; // XXX: e1 ߑłH
            //printArray("setArg", setArg.values);
            //System.out.println("RegNo: "+ setArg.get(RegNo));
            if (setArg.get(RegNo) != Rule.KEEP) {
                Lab.assertTrue(setArg.get(RegNo) instanceof Integer);
                int r = setArg.getInt(RegNo);
                // }bvォ畨̂PTB
                int x = findObjectFromMap();
                Lab.assertTrue(x != -1); // ̃fł͕K̂ƉB
                Object o = world.map[getCurrentRoomID()][x];
                //System.out.println("observe: "+ "o="+ o+ ", x="+ x);

                if (r == 1) {
                    likelihood[State.getIndexER(eventNo, O1_what)] = o;
                    likelihood[State.getIndexER(eventNo, O1_where)] = x;
                } else if (r == 2) {
                    likelihood[State.getIndexER(eventNo, O2_what)] = o;
                    likelihood[State.getIndexER(eventNo, O2_where)] = x;
                } else {
                    Lab.assertTrue(false);
                }
            }
            if (alog) printArray("likelihood", likelihood);

            // ̏q͖IɊϑȂĂIɒl set B
            Lab.assertTrue(setArg.get(Energy) == Rule.KEEP);
            Lab.assertTrue(setArg.get(CurrentRoom) == Rule.KEEP);
            
            Object[] belief = new Object[State.getWMsize()];
            // \ prior Ɗϑ likelihood ̖oꂽ fail B
            for (int i = 0; i < belief.length; i++) {
                if (prior[i] == Rule.WILDCARD) {
                    belief[i] = likelihood[i];
                } else if (prior[i] == Rule.PLS) {
                    if (likelihood[i] == Rule.ZERO) {
                         return null; // fail
                    } else {
                        belief[i] = likelihood[i];
                    }
                } else {
                    if (likelihood[i] == null) {
                        belief[i] = prior[i];
                    } else if (likelihood[i] == prior[i]) {
                        belief[i] = prior[i];
                    } else {
                        // likelihood[i] != prior[i]
                        return null; // fail
                    }
                }
            }
            belief[State.getIndexER(eventNo, RelTime)] = Tense.Present;
            belief[State.getIndexER(eventNo, Energy)] = energy;
            belief[State.getIndexER(eventNo, CurrentRoom)] = currentRoom;
            if (alog) printArray("belief", belief);
            for (int i = 0; i < belief.length; i++) {
                if (belief[i] == null) {
                    System.out.println("b["+ i+ "]="+ belief[i]); 
                    Lab.assertTrue(false);
                }
            }
            
            return new State(belief);
        }

        public int getCurrentRoomID() {
            return roomNameToRoomId(currentRoom);
        }
        public int roomNameToRoomId(RoomName roomName) {
            for (int i = 0; i < world.roomNames.length; i++) {
                if (roomName == world.roomNames[i]) return i;
            }
            throw new Error("roomNameToRoomId : "+ roomName);
        }

        /**
         * }bv̒烉_ɂP̂IňʒuԂB 
         */
        public int findObjectFromMap() {
            // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
            // }bv̂̐̕𐔂B
            int c = 0;
            int roomID = getCurrentRoomID();
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        c++;
                    }
                }
            }
            // _ r Ԗڂ̂̕IԁB
            int r = Lab.irand(c);
            c = 0;
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        if (c++ == r) return y * roomSizeX + x;
                    }
                }
            }
            return -1; // Not found.
        }
        /**
         * }bv̒w肳ꂽ̂PTďꏊԂB
         * TB 
         */
        public int findItemFromTheRoom(Item item) {
            int roomID = getCurrentRoomID();
            for (int i = 0; i < world.map[roomID].length; i++) {
                if (world.map[roomID][i] == item) return i;
            }
            throw new Error("findItemFromMap: not found "+ item);
        }
        
        /** ANV a.oldR sA a.newS ϑB
         * Vꍇ a.reward ̒lɉZB
         */
        public void takePrimitiveActionAndObserve() {
            PrimitiveAction action = oldR.getAction();
            int roomID = getCurrentRoomID();
            newS.set(RelTime, Tense.Present);
            switch (action) {
            case EatO1: {
                // O1 HׂȂ炻 Leftovers ɕϊB
                // W̉ĂȂƂ́HƂ肠G[B
                // HׂȂƂ́HƂ肠G[B
                int x = newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x];
                    if (target == Nut) {
                        world.map[roomID][x] = Space;
                        energy++;
                        newS.set(Energy, energy);
                    } else {
                        Lab.assertTrue(false);
                    }
                }
                observeO1();
            } break;

            case MoveO2toO1: {
                // O2  O1 ̏ꏊɈړAO1, O2 ͌`EʒuωB
                int x1 = newS.getInt(O1_where);
                int x2 = newS.getInt(O2_where);
                if (x1 == -1 || x2 == -1) {
                    Lab.assertTrue(false);
                } else if (x1 == 0 || x2 == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x1];
                    Object item = world.map[roomID][x2];
                    if (target == Shell && item == Stone) {
                        world.map[roomID][x1] = Nut;
                        world.map[roomID][x2] = Space;
                    } else {
                        // Fail ׂH
                        Lab.assertTrue(false);
                    }
                    observeO1();
                }
            } break;

            case MoveSelfAndEatO1: {
                // O1 HׂȂ玩g O1 ɈړĐHׂB
                int selfX = findItemFromTheRoom(selfItem);

                int x = newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else if (x == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x];
                    if (target == Nut) {
                        world.map[roomID][x] = selfItem;
                        world.map[roomID][selfX] = Space;
                        energy++;
                        newS.set(Energy, energy);
                    } else {
                        //System.out.println("Stolen!");
                        //Lab.assertTrue(false);
                    }
                }
                observeO1();
            } break;
            
            case Say: {
                Verb verb = (Verb)actionParamState.get(S_verb);
                Object obj = actionParamState.get(S_object);
                switch (verb) {
                case WhereIs : {
                    Lab.assertTrue(obj instanceof Item);
                    int x = findItemFromTheRoom((Item)obj);  
                    newS.set(RegNo, 1);
                    newS.set(O1_what, obj);
                    newS.set(O1_where, x);
                } break;
                
                case GiveMe : {
                    // }bv obj uȀꏊ O1 ɃZbgB
                    Lab.assertTrue(obj instanceof Item);
                    putItemAtRandomPosInRoom(world.map[roomID], (Item)obj);
                    int x = findItemFromTheRoom((Item)obj);
                    newS.set(RegNo, 1);
                    newS.set(O1_what, obj);
                    newS.set(O1_where, x);
                } break;
                
                case HereIs : {
                    // sentence(HereIs,Nut) ƔbĂ
                    // O1 ̏ꏊ Nut  Thanks ƕԎB
                    // Nut łȂꍇ͉ȂB
                    // (ݒ̃^XNŗpƉB)
                    int o1 = newS.getInt(O1_what);
                    int x1 = newS.getInt(O1_where);
                    Item item = world.map[roomID][x1];
                    if (obj == Nut && obj == item) {
                        newS.set(S_verb, Verb.Thanks);
                        newS.set(S_object, 0);
                    }
                } break;

                default:{
                    Lab.assertTrue(false);
                } break;
                }
                
            } break;

            case MoveToRoom: {
                RoomName newRoomName = (RoomName)actionParamState.get(CurrentRoom);
                Lab.assertTrue(newRoomName != null);
                int newRoomID = roomNameToRoomId(newRoomName);
                // map ̍XVB
                int pos = findItemFromTheRoom(selfItem);
                world.map[roomID][pos] = Space;
                currentRoom = newRoomName;
                putItemAtRandomPosInRoom(world.map[newRoomID], selfItem);
                newS.set(CurrentRoom, newRoomName);
                // IuWFNgWX^ׂ͂ăNAB
                newS.set(RegNo, 0);
                newS.set(O1_what, 0);
                newS.set(O1_where, 0);
                newS.set(O2_what, 0);
                newS.set(O2_where, 0);
            } break;
            
            case Recall: {
                State e = findEpisode(actionParamState);
                if (e == null) {
                    System.out.println("Recall: episode not found");
                } else {
                    // XXX: ŎBzNe merge B
                    // {͑zNe̓Gs\[hWX^ɓꂽB
                    Object[] ev = e.values;
                    Object[] sv = newS.values;
                    printArray("ev", ev);
                    printArray("sv", sv);
                    for (int i = 0; i < ev.length; i++) {
                        if (ev[i] == Rule.ZERO) {
                            // Do nothing.
                        } else {
                            // XXX: merge ɏՓ˂NꍇBƂ肠B
                            if (sv[i] != Rule.ZERO && sv[i] != ev[i]) System.out.println("!=");
                            sv[i] = ev[i];
                        }
                    }
                    printArray("new sv", sv);
                }
            } break;
            

            default: {
                System.out.println("action: "+ action);
                Lab.assertTrue(false);
            } break;
            }
        }
        /**
         * [LO newS ̂̕P̒lɍ킹čXVB
         * ̂Q̒l 0 ƂB
         * ꕔ̑ΊOANV̎sɌĂ΂B
         * TODO: ̂̈ړgbLO@\Ă悢B
         */
        public void observeO1() {
            int x = newS.getInt(O1_where);
            if (x == 0) return;
            Object obj = world.map[getCurrentRoomID()][x];
            newS.set(RegNo, 1);
            newS.set(O1_what, obj);
            newS.set(O1_where, x);
            newS.set(O2_what, 0);
            newS.set(O2_where, 0);
        }
        
        // Gs\[hL
        public List<State> episodes = new ArrayList<State>();
        public State findEpisode(State key) {
            // ܂͊ȒPȎBŏɌ̂PԂB
            // PȂꍇ null ԂB
            return episodes.stream().filter(s -> s.episodeMatch(key))
                    .findFirst().orElse(null);
        }
    }
    //--------------------------------------------------
    public boolean visualizeFlag;
    public class World {
        public RoomName[] roomNames;
        public Item[][] map;
        public Agent[] agents;
        //
        public World(){
            agents = mainCode.makeAgents(this);
            mainCode.initAgentsTable(this);
        }
        int counter = 0;
        public void main(){
            int episodes = 0;
            for (;;){
            	int steps = main1();
                env.viewPanel.scatterPlot("Step/Episode", episodes, steps);
                episodes++;
            }
        }
        public int main1() {
            visualizeFlag = panel.flag("visualizeFlag", true);
            panel.speedControl("Episode loop", 0);
            mainCode.setMap(this);
            initRooms();
            mainCode.initEpisode(this);
//            State start = mainCode.startState();
//            State goal = mainCode.goalState();
//            for (int i = 0; i < agents.length; i++) {
//                Agent agent = agents[i];
//                agent.setStartAndGoal(start, goal);
//                agent.chooseFirstAction();
//            }
            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                a.observe(Rule.makeState(s(), Rule.KEEP), a.oldS);
                a.chooseFirstAction();
            }
            int steps = 0;
            // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
            while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
                for (int i = 0; i < agents.length; i++) {
                    Agent agent = agents[i];
                    env.viewPanel.print1("counter=", ""+ counter++);
                    if (visualizeFlag){
                        panel.speedControl("Step loop", 100);
                        visualizeMap();
                        visualizeAgentState(agent);
                    }
                    
                    agent.takeAction();
                    agent.chooseAction();
                    agent.update();

                    if (visualizeFlag){
                        visualizeMap();
                        visualizeAgentState(agent);
                    }
                }
            }
            return steps;
        }
        public void visualizeAgentState(Agent agent){
            {
                String goalsLabel = "Goals "+ agent.selfItem;
                env.viewPanel.setText(goalsLabel, ""); // Clear text.
                for (int i = 0; i < agent.stack.size(); i++) {
                    // Print elements from bottom to top.
                    env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
                }
                env.viewPanel.println(goalsLabel, ""+ agent.oldG);
            }
            {
                String logLabel = "Log "+ agent.selfItem;
                env.viewPanel.println(logLabel, "---");
                String s = "stack size="+ agent.stack.size()+ ":";
                for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                    // Add elements from top to bottom.
                    s += agent.stack.get(i)+ ", ";
                }
                env.viewPanel.println(logLabel, s);
                env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                        ", "+ agent.oldG);
                env.viewPanel.println(logLabel, ""+ agent.oldR);
            }
            String ruleLabel = "rule.q "+ agent.selfItem;
            env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
            env.viewPanel.resetGraphData(ruleLabel);
            agent.rules.forEach(r -> {
                env.viewPanel.plot(ruleLabel, r.q);
            });
        }
        
        
        public void initRooms(){
            //map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
            for (int r = 0; r < map.length; r++) {
                for (int p = 0; p < map[r].length; p++) {
                    map[r][p] = Space;
                }
                // 
                // x=0 or y=0 ̍WɕuȂ悤ɂ邽߂ɕǂĂB
                for (int x = 0; x < roomSizeX; x++) {
                    map[r][x] = Wall; 
                }
                for (int y = 0; y < roomSizeY; y++) {
                    map[r][y * roomSizeX] = Wall;
                }
            }
            //mainCode.initMap(map);
//            if (visualizeFlag){
//                env.viewPanel.paint("Map", mapPainter);
//            }
        }
        public void visualizeMap(){
            env.viewPanel.paint("Map", mapPainter);
        }
        public MapPainter mapPainter = new MapPainter();
        public int charSize = panel.getInt("charSize", 24, 1, 40);
        public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
        //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
        public class MapPainter extends Lab.Code implements Lab.Painter {
            public Dimension getSize(){
                int totalSizeX = mapSizeX * roomSizeX;
                int totalSizeY = mapSizeY * roomSizeY;
                return new Dimension(charSize * (totalSizeX + 1),
                        charSize * (totalSizeY + 1));
            }
            int counter = 0;
            public void paintComponent(Graphics g, MouseEvent lastEvent) {
                // W (0,0) ƂB
                // x=0 or y=0 ͕ǁBǂł͂Ȃ x, y >= 1 Ŵݕ`悷B 
                g.setFont(f);
                for (int ry = 0; ry < mapSizeY; ry++) {
                    for (int rx = 0; rx < mapSizeX; rx++) {
                        g.setColor(Color.BLACK);
                        g.drawString(roomNames[ry * mapSizeX + rx].toString(),
                            posX(rx, ry, 1, roomSizeY-1), 
                            posY(rx, ry, 1, roomSizeY-1));
                        
                        for (int y = 1; y < roomSizeY; y++) {
                            for (int x = 1; x < roomSizeX; x++) {
                                int r = ry * mapSizeX + rx;
                                int p = y * roomSizeX + x; 
                                String str = map[r][p].code;
                                g.setColor(Color.BLACK);
                                g.drawString(str,
                                    posX(rx, ry, x, y-1), 
                                    posY(rx, ry, x, y-1));
                            }
                        }
                    }
                }
                for (int i = 0; i < agents.length; i++) {
                    paintAgent(agents[i], g);
                }
            }
            public void paintAgent(Agent a, Graphics g) {
                int roomID = a.getCurrentRoomID();
                int selfRX = roomID % mapSizeX;
                int selfRY = roomID / mapSizeX;
                int selfX = 0, selfY = 0;
                // Find self
                for (int y = 1; y < roomSizeY; y++) {
                    for (int x = 1; x < roomSizeX; x++) {
                        if (map[roomID][y * roomSizeX + x] == a.selfItem) {
                            selfX = x; selfY = y;
                        }
                    }
                }
                Lab.assertTrue(selfX != 0 && selfY != 0);

                int rx = roomID % mapSizeX;
                int ry = roomID / mapSizeX;
                int where1 = a.newS.getInt(O1_where);
                Lab.assertTrue(where1 != -1);
                int x1 =  where1 % roomSizeX;
                int y1 =  where1 / roomSizeX;
                int where2 = a.newS.getInt(O2_where);
                Lab.assertTrue(where2 != -1);
                int x2 =  where2 % roomSizeX;
                int y2 =  where2 / roomSizeX;
                
                if (x1 != 0 && y1 != 0) {
                    g.setColor(Color.GREEN);
                    g.drawRect(posX(rx, ry, x1, y1), posY(rx, ry, x1, y1),
                            charSize - 2, charSize - 2);
                    g.drawString("1", 
                            posX(rx, ry, x1, y1), posY(rx, ry, x1, y1));
                    
                    g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posX(rx, ry, x1, y1) + charSize/2,
                            posY(rx, ry, x1, y1) + charSize/2);
                }
                if (x2 != 0 && y2 != 0) {
                    g.setColor(Color.RED);
                    // `̘g2sNZ炵ĕ\B
                    g.drawRect(posX(rx, ry, x2, y2) + 2, posY(rx, ry, x2, y2) + 2,
                            charSize - 2, charSize - 2);
                    g.drawString("2", 
                            posX(rx, ry, x2, y2), posY(rx, ry, x2, y2));
                    
                    g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posX(rx, ry, x2, y2) + charSize/2,
                            posY(rx, ry, x2, y2) + charSize/2);
                }
            }
        }
        public int posX(int rx, int ry, int x, int y) {
            return (rx * roomSizeX + x) * charSize;
        }
        public int posY(int rx, int ry, int x, int y) {
            return  (mapSizeY * roomSizeY 
                      - (ry * roomSizeY + y) 
                      )
                    * charSize;
        }
        public Integer stateElemToInteger(Object elem) {
            if (elem instanceof Integer) {
                return (Integer)elem;
            } else {
                return null;
            }
        }
        
        /**
         * fobOpɏóB
         */
        public void printWorldInfo() {
            System.out.println("Task = "+ this.getClass().getName());

            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                System.out.println("Rules for agent "+ a.selfItem);
                for (int j = 0; j < a.rules.size(); j++) {
                    System.out.println(j+ ":"+ a.rules.get(j));
                }
                System.out.println();
            }
        }
    }
    
    //--------------------------------------------------
    // DSL for rule definition. 
    VariableN o1 = new VariableN("o1");
    VariableN x1 = new VariableN("x1");
    VariableN o2 = new VariableN("o2");
    VariableN x2 = new VariableN("x2");
    VariableN x = new VariableN("x");
    VariableN p = new VariableN("p");
    VariableN t = new VariableN("t");
    VariableN s = new VariableN("s");
    VariableN v = new VariableN("v");
    VariableN o = new VariableN("o");
    VariableN c = new VariableN("c");
    VariableN room = new VariableN("room");
    public static final String __ = Rule.WILDCARD; // Two underscores.
    public static final String PLS = Rule.PLS;
    public static final String NA = "NA".intern();
    public StateN s(Object... args){
        return new StateN(Arrays.asList(flatten(args)));
     }
    public StateN s(StateN s){ return s; }
    public ActionN call(Object... args){ return new ActionN(Call, s(args)); }
    public ActionN call(StateN s){ return new ActionN(Call, s); }
    public ActionN set(Object... args){ return new ActionN(Set, s(args)); }
    public ActionN set(StateN s){ return new ActionN(Set, s); }
    public ActionN recall(Object... args){ return new ActionN(Recall, s(args)); }
    public ActionN recall(StateN s){ return new ActionN(Recall, s); }
    public ActionN memorize(Object... args){ return new ActionN(Memorize, s(args)); }
    public ActionN memorize(StateN s){ return new ActionN(Memorize, s); }
    public StateN union(StateN... args){
    	// TODO: qꂪ΃G[ɂׂH
        List<Object> a = new ArrayList<>();
        for (int i = 0; i < args.length; i++) {
            a.addAll(args[i].elems);
        }
        return new StateN(a); 
    }
//    public ActionN say(Object... args){
//        return new ActionN(Say, new StateN(Arrays.asList(args)));
//    }

    List<RuleN> ruleList;
    // rule(s, g, call/set(...))
    public void rule(StateN s, StateN g, ActionN a){
        ruleList.add(new RuleN(s, g, a));
    }
    // rule(s, g, Primitive)
    public void rule(StateN s, StateN g, PrimitiveAction a){
        ruleList.add(new RuleN(s, g, new ActionN(a, null)));
    }
    // rule(s, g, Primitive, s(...))
    public void rule(StateN s, StateN g, PrimitiveAction a, StateN arg){
        ruleList.add(new RuleN(s, g, new ActionN(a, arg)));
    }

    // Predicates
    public Object[] r(Object reg) {
        return new Object[] { new ERElementN(1, RegNo, reg) };
    }
    public Object[] o1(Object what, Object where) {
        return new Object[] { 
                new ERElementN(1, O1_what, what), 
                new ERElementN(1, O1_where, where) };
    }
    public Object[] o2(Object what, Object where) {
        return new Object[] { 
                new ERElementN(1, O2_what, what), 
                new ERElementN(1, O2_where, where) };
    }
    public Object[] energy(Object value) {
        return new Object[] { new ERElementN(1, Energy, value) };
    }
    public Object[] relTime(Object t) {
        return new Object[] { new ERElementN(1, RelTime, t) };
    }
    public Object[] currentRoom(Object r) {
        return new Object[] { new ERElementN(1, CurrentRoom, r) };
    }
    public Object[] e1(Object[]... args) { return flatten(args); }
    public Object[] e2(Object[]... args) { return changeEventNo(2, args); }
    public Object[] changeEventNo(int eventNo, Object[] args) {
        Object[] e1 = flatten(args);
        //printArray("e1", e1);
        Object[] ret = new Object[e1.length];
        for (int i = 0; i < ret.length; i++) {
            ERElementN elem = (ERElementN)e1[i];
            ret[i] = new ERElementN(eventNo, elem.index, elem.val);
        }
        //printArray("ret", ret);
        return ret;
    }
    public Object[] sentence(Object tense, 
            Object subject, Object verb, Object object, Object complement) {
        return new Object[] { 
                new SRElementN(SR_Index.S_tense, tense),
                new SRElementN(SR_Index.S_subject, subject),
                new SRElementN(SR_Index.S_verb, verb),
                new SRElementN(SR_Index.S_object, object),
                new SRElementN(SR_Index.S_complement, complement)};
    }
    public Object[] sentence(Object verb, Object object) {
        return new Object[] { 
                new SRElementN(SR_Index.S_tense, NA),
                new SRElementN(SR_Index.S_subject, NA),
                new SRElementN(SR_Index.S_verb, verb),
                new SRElementN(SR_Index.S_object, object),
                new SRElementN(SR_Index.S_complement, NA)};
    }
    private static void flattenTest() {
        Object[] a = {1,2,3};
        Object[] b = {4,a,5,6};
        Object[][] c = {a,{7,8},{},{9},b};
        Object[] d = {};
        Object[] nested = {c,d,a,b,d};
        System.out.println("flatten test:");
        Object[] flat = flatten(nested);
        for (int i = 0; i < flat.length; i++) {
            //System.out.println(i+ ":"+ flat[i]);
            System.out.print(flat[i]+ " ");
        }
        System.out.println();
    }
    public static Object[] flatten(Object[] nested) {
        Vector<Object> v = new Vector<>();
        for (int i = 0; i < nested.length; i++) {
            if (nested[i] instanceof Object[]) {
                Object[] a = flatten((Object[])nested[i]);
                for (int j = 0; j < a.length; j++) {
                    v.add(a[j]);
                }
            } else {
                v.add(nested[i]);
            }
        }
        return v.toArray(); 
    }
    // End of DSL functions.
    
    // Methods for Task initialization.
    //
    public abstract Agent[] makeAgents(World world);
    /**
     * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
     * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
     * ݒ肷邱Ƃ\B
     */
    public void initAgentsTable(World world) {
        for (int i = 0; i < world.agents.length; i++) {
            Agent a = world.agents[i];
            ruleList = new ArrayList<>();
            listRules();
            a.rules = ruleList.stream().map(
                    ruleN ->  new Rule(ruleN)
                ).collect(Collectors.toList());
            // KvȂ q lBƂ肠Ô܂܂ƂB

            if (panel.flag("Add incorrect rules", true)) {
            	addIncorrectRules(a);
            }
        }
    }
    public abstract void listRules();
    /*
     * KȂs[ǉBs[̉l̊wK@\̃eXgEfړIB
     */
    public void addIncorrectRules(Agent a) {
    	// ruleList ݂̌̒lgāAȂs[쐬B
    	List<RuleN> extraRuleList = new ArrayList<>();
    	// es[ƂɁAANV Fail ɕςuԈs[vǉB
    	int n = ruleList.size();
    	ruleList.forEach(rule -> {
    		extraRuleList.add(new RuleN(rule.s,
    				rule.g, 
    				new ActionN(Fail, null))
    		);
    	});
        a.rules.addAll(extraRuleList.stream().map(
                ruleN ->  new Rule(ruleN)
            ).collect(Collectors.toList())
        		);
    }

    /**
     * }bṽCAEg̐ݒB
     * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
     */
    public void setMap(World world) {
        mapSizeX = 1;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public abstract void initEpisode(World world); 
    
    public static void putItemAtRandomPosInRoom(Item[] room, Item item){
        for (int i = 0; i < 10000; i++) {
            int x = Lab.irand(room.length);
            if (room[x] == Space){
                room[x] = item;
                return;
            }
        }
        throw new Error("putItemAtRandomPosInRoom0: no space found.");
    }
}
//--------------------------------------------------
//--------------------------------------------------
// Demo Task definitions

// f Nut ̏ꏊ𕷂B
public static class DemoLang1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1, s());

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Nut ̏ꏊ𕷂B
        rule(s(), g2, Say, s(sentence(Verb.WhereIs,Nut)));
    }
    public void initEpisode(World world){
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(2)), __)
                );
    }
}
//f  Nut ̏ꏊ𕷂ꂽ狳ĂB
// Ƃ肠Ӑ}ȂB
public static class DemoLang2 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Thanks ƌĂ炤Tu[`B
        StateN g1 = s(sentence(Verb.Thanks, 0));
        rule(s(sentence(Verb.WhereIs, x)), g1, Call, s(o1(x,PLS)));
        rule(s(o1(x,PLS),sentence(Verb.WhereIs, x)), g1, Say, s(sentence(Verb.HereIs, x)));

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(x,PLS));
        rule(s(), g2, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setStartAndGoal(
                Rule.makeState(s(sentence(Verb.WhereIs, Nut)), 0),
                Rule.makeState(s(sentence(Verb.Thanks,0)), __)
                );
    }
}

// gړĎRHׂ^XNB
public static class Demo2 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(4));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1, s());

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){ 
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(4)), __)
                );
    }
}

// ΂kɂԂďoĂHׂ^XNB
public static class Demo1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1, s());

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Shell  Stone TB
        rule(s(), g2, Call, s(o1(Shell,PLS),o2(Stone,PLS)));
        rule(s(o1(Shell,PLS),o2(Stone,PLS)), g2, MoveO2toO1, s());

        // Shell  Stone IuWFNgWX^ɓTu[`B
        StateN g3 = s(o1(Shell,PLS),o2(Stone,PLS));
        rule(s(), g3, Set, s(r(2),o2(PLS,PLS)));
        rule(s(o2(Stone,PLS)), g3, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Stone);
        putItemAtRandomPosInRoom(world.map[0], Shell);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(2)), __)
                );
    }
}

// fobOp
public static class Demo0 extends AbstractMainCode {
 public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
 public void listRules(){
     // Shell ɓB
     StateN g1 = s(o1(Shell,PLS));
     //rule(s(), g1, Set, s(r(1),o1(PLS,PLS)));
     rule(s(), g1, Set, s(r(1),o1(Shell,PLS)));
 }
 public void initEpisode(World world){
     world.agents[0].energy = 1;
     world.agents[0].currentRoom = RoomName.Room1;
     putItemAtRandomPosInRoom(world.map[0], Self);
     putItemAtRandomPosInRoom(world.map[0], Grass);
     putItemAtRandomPosInRoom(world.map[0], Grass);
     putItemAtRandomPosInRoom(world.map[0], Stone);
     putItemAtRandomPosInRoom(world.map[0], Shell);
     world.agents[0].setGoal(
             Rule.makeState(s(o1(Shell,PLS)), __)
             );
 }
}

public static class Test1Rooms1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(5));
        rule(s(), g1, call(currentRoom(RoomName.Room1)));
        rule(s(), g1, call(currentRoom(RoomName.Room2)));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1);

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, set(r(1),o1(PLS,PLS)));
        rule(s(), g2, Fail); // Ƃǂ߂ fail

        // ̈ړB
        rule(s(), s(currentRoom(room)), MoveToRoom, s(currentRoom(room)));
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(5)), __)
                );
    }
}

public static class Test1Agents extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {
            new Agent(Self, world),
            new Agent(Brother, world)}; }
    public final StateN goal0 = s(energy(3)); 
    public final StateN goal1 = s(energy(100)); 
    public void listRules(){
        // Nut HׂTu[`B
        StateN g0 = goal0;
        rule(s(), g0, call(currentRoom(RoomName.Room1)));
        rule(s(), g0, call(currentRoom(RoomName.Room2)));
        rule(s(), g0, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g0, MoveSelfAndEatO1);

        StateN g1 = goal1;
        rule(s(), g1, call(currentRoom(RoomName.Room1)));
        rule(s(), g1, call(currentRoom(RoomName.Room2)));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1);

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, set(r(1),o1(PLS,PLS)));
        rule(s(), g2, Fail); // Ƃǂ߂ fail

        // ̈ړB
        rule(s(), s(currentRoom(room)), MoveToRoom, s(currentRoom(room)));
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = RoomName.Room1;
        world.agents[0].energy = 1;
        world.agents[0].setGoal(
                Rule.makeState(goal0, __)
                );
        world.agents[1].currentRoom = RoomName.Room2;
        world.agents[1].energy = 1;
        world.agents[1].setGoal(
                Rule.makeState(goal1, __)
                );
        
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[1], Brother);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        putItemAtRandomPosInRoom(world.map[1], Nut);
    }
}


// Gs\[hL̃eXgp^XNB
public static class Test0Episode extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] { new Agent(Self, world)}; }
    public void listRules(){

        // o1 ԁB
        StateN g1 = s(e1(relTime(Tense.Present), o1(o1, PLS)));
        // ߋɂĕ p  o1 ƂGs\[hB
        StateN episode = s(e2(relTime(Tense.Past), 
                currentRoom(PLS),
                o1(o1, PLS)));
        //  p ɂԁB
        StateN g2 = s(e1(relTime(Tense.Present),
                currentRoom(p)));

        // ߋɕ p  Stone ǂvoA
        rule(s(), g1, recall(episode));
        // ̏ꏊ p ɍȂ o1 TB
        rule(s(e1(relTime(Tense.Present), currentRoom(p)),
        		e2(relTime(Tense.Past), 
                        currentRoom(p),
                        o1(o1, PLS))),
                g1,
                set(r(1),o1(o1, PLS))); 

        // ΂ꏊ镔ƈႤȂ΂̕ɈړB
        rule(s(e2(relTime(Tense.Past), currentRoom(p), o1(o1, PLS))), 
                g1, 
                MoveToRoom, s(currentRoom(p))); 
        
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = RoomName.Room1;
        world.agents[0].energy = 1;
        // ΂ꏊm邱ƂS[B
        world.agents[0].setGoal(
                Rule.makeState(s(e1(relTime(Tense.Present),
                        currentRoom(PLS),
                        o1(Stone, PLS))),
                __)
                );
        //  Room1 ɂB
        putItemAtRandomPosInRoom(world.map[0], Self);
        // Room1  Room2 ̂ǂ炩Ƀ_ɐ΂uB
        //int roomID = Lab.irand(2);
        int roomID = stoneRoomID();
        putItemAtRandomPosInRoom(world.map[roomID], Stone);
        RoomName stoneRoom = world.roomNames[roomID]; 
        // Gs\[hL̏B
        // ߋɂĕ stoneRoom  Stone ƂGs\[hB
        world.agents[0].episodes.add(Rule.makeState(
                s(e2(relTime(Tense.Past), 
                        currentRoom(stoneRoom),
                        o1(Stone, 1))), // ꏊ͓K
                Rule.ZERO));
    }
    public int stoneRoomID() { return 0; } 
}
public static class Test1Episode extends Test0Episode {
    public int stoneRoomID() { return 1; }
}


// Default dummy task.
public static class Demo0_Dummy extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        throw new StopPressed();
    }
    public void initEpisode(World world){ throw new Error(); }
}
}
