//Copyright (c) 2021 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

CxgWX^̃fɌāA
܂̓}`G[WFgA}`[̊go[WB

*/

package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v4.Action.*;
import static tmm1.TMM3v4.WM_Index.*;
import static tmm1.TMM3v4.Item.*;
//import static tmm1.TMM3v4.Tense.*;
//import static tmm1.TMM3v4.Verb.*;
//import static tmm1.TMM3v4.RoomName.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v4 {
public static void main(String[] args) {
    Lab.addSelectableClass(TMM3v4.class);
    System.out.println(Lab.selectableClasses + "");

    LabCode labCode = new LabCode();
    labCode.main(AbstractMainCode.class);
}
/**
 * primitive actions 
 */
public static enum Action {
    EatO1,
    MoveO2toO1,
    MoveSelfAndEatO1,
    MoveToRoom,
    MoveToRoomWithO1,
    Call,
    Return,
    Set,
    Say,
    Fail;
}
public static enum WM_Index {
    RegNo,
    // Objects
    O1_what,
    O1_where,
    O2_what,
    O2_where,
    Want_who,
    Want_what,
    // Clause
    S_tense,
    S_subject,
    S_verb,
    S_object,
    S_complement,
    CurrentRoom,
    //CurrentPos,
    Energy,
    Last_WM; // Dummy
    public ElementN p(Object x) {
        return new ElementN(this, x);
    }
}
public static class ElementN {
    public WM_Index index;
    public Object val;
    public ElementN(WM_Index index, Object x){
        this.index = index; this.val = x;
    }
    public String toString(){
        return index+ "("+ val+ ")"; 
    }
}
public static enum Item {
    Wall("\u58c1"),  // 
//    Self(""),  // q
//    Mother(""),  // 
//    Brother("Z"),  // Z
//    Stone(""), // 
//    Shell("<>"), // k
//    Nut("o "), // 
//    Grass("h"), // 
    Self("q"),  // q
    Mother(""),  // 
    Brother("Z"),  // Z
    Stone(""), // 
    Shell("k"), // k
    Nut(""), // 
    Grass(""), // 
    //Meat(""), // 
    Nothing(""), // 
    Space("E"); // E 

    public final String code;
    private Item(String code){
        this.code = code;
    }
}
public static enum Tense {
    Present,
    Past,
    Future;
}
public static enum Verb {
    WhereIs,
    GiveMe,
    HereIs,
    Thanks,
    Last_Verb; // Dummy
}
public static enum RoomName {
    Room1,
    Room2,
    Room3,
    Storage,
    Garden,
    Shop,
    Park,
    Last_RoomName; // Dummy
}
// Abstract syntax nodes for DSL
public static class StateN {
    public List<Object> elems;
    public StateN(List<Object> vars) { this.elems = vars; }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("s(");
        elems.forEach(obj -> {
            buf.append(obj.toString());
            buf.append(", ");
        });
        buf.append(")");
        return buf.toString();
    }
}
public static class RuleN {
    public StateN s, g;
    public ActionN a;
    public RuleN(StateN s, StateN g, ActionN a){ 
        this.s = s; this.g = g; this.a = a;
    }
    public String toString(){
        return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
    }
}
public static class ActionN {
    public Action a;
    public StateN m;
    public ActionN(Action a, StateN m){ 
        this.a = a; this.m = m;
    }
    public String toString(){
        if (m == null){
            return a.toString();
        } else {
            return a.toString()+ "("+ m+ ")";
        }
    }
}
/**
 * pattern variable 
 */
public static class VariableN {
    public String name;
    public VariableN(String name){ this.name = name; }
}

//--------------------------------------------------
/**
 * Q(s,g,a) 𒊏ۉ[B
 * lxNgƃp^[}b`đIB 
 * Usage:
 *   r = new Rule(ruleN);
 *   boolean matched = r.match(vals);
 *   if (matched){
 *      // Access to the last matching results.
 *      Action a = r.getAction();
 *      State s = new State(r.getActionParam());
 *   }
 */
public static class Rule {
    /**
     * Q value of this rule.
     */
    public float q;
    /**
     * Counter for demo.
     */
    public int useCounter = 0;
    /**
     * Number of variables appeared in this Rule.
     */
    public int numVars;
    // \ȃIuWFNgB̃IuWFNgƐ΂ɏdȂȂIuWFNgB
    public static final Object UNBOUND = new Object[]{"UNBOUND"};
    // p^[}b`IɖϐɑftHglB
    // O̒lɂ̂݃}b`B
    public static final String PLS = "+".intern();
    // [LO̒l̕ێB
    public static final String KEEP = "=".intern();
    // ChJ[hBCӂ̒lƃ}b`B
    public static final String WILDCARD = "__".intern(); // Two underscores.
    // 萔 0
    public static final Integer ZERO = 0; // autoboxing 
    public Object[] env;
    public Object[] patternVec; // Concatenated pattern of s and g.
    public Action action;
    public Object[] actionPatternVec;  // Pattern of m of action C_m.
    public int idCounter = 0;
    public Map<VariableN,PatternVariable> vmap = new HashMap<>(); 
    public Rule(RuleN ruleN){
        // ruleN ƂɃp^[\zB
        List<Object> elems = transStateN(ruleN.s, WILDCARD);
        elems.addAll(transStateN(ruleN.g, WILDCARD));
        numVars = vmap.size() + 
                (int)elems.stream()
                .filter(e -> e == WILDCARD || e == PLS)
                .count();
        patternVec = elems.toArray();
        action = ruleN.a.a;
        if (ruleN.a.m == null) {
            // It is primitive action.
            actionPatternVec = null;
        } else if (action == Action.Set){
            actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
        } else {
            actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
        }
        env = new Object[vmap.size()];
        vmap = null;
    }
    public Rule(){
       // Implicitly called from ReturnRule().
    }
    // q̗Œ蒷̃[LO̗vfɕϊB
    // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
    public List<Object> transStateN(StateN state, Object defaultValue){
        if (false){
            // flatten test
            Object[] a = {1,2,3};
            Object[] b = {4,a,5,6};
            Object[][] c = {a,{7,8},{},{9},b};
            Object[] d = {};
            Object[] nested = {c,d,a,b,d};
            System.out.println("flatten test:");
            Object[] flat = flatten(nested);
            for (int i = 0; i < flat.length; i++) {
                //System.out.println(i+ ":"+ flat[i]);
                System.out.print(flat[i]+ " ");
            }
            System.out.println();
        }
        Object[] sa = flatten(state.elems.toArray());
        Object[] arr = new Object[WM_Index.Last_WM.ordinal()];
        for (int i = 0; i < sa.length; i++) {
            Object elem = sa[i];
            if (elem instanceof ElementN) {
                ElementN e = (ElementN)elem;
                int index = e.index.ordinal();
                if (arr[index] != null) {
                    throw new Error("Duplicated Predicates: "+ elem+ " in "+ sa);
                }
                arr[index] = transArg(e.val);
            } else {
                throw new Error(elem+ " is not a Predicate : "+ sa);
            }
        }
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] == null) {
                arr[i] = defaultValue;
            }
        }
        List<Object> ret = new ArrayList<>();
        ret.addAll(Arrays.asList(arr));
        return ret;
    }
    public static Object[] flatten(Object[] nested) {
        Vector<Object> v = new Vector<>();
        for (int i = 0; i < nested.length; i++) {
            if (nested[i] instanceof Object[]) {
                Object[] a = flatten((Object[])nested[i]);
                for (int j = 0; j < a.length; j++) {
                    v.add(a[j]);
                }
            } else {
                v.add(nested[i]);
            }
        }
        return v.toArray(); 
    }
    // q̈Bϐɓ id  PatternVariable 蓖ĂB
    public Object transArg(Object e) {
        Object re;
        if (e instanceof String) {
            e = ((String)e).intern();
        }
        if (e == WILDCARD){
            re = e;
        } else if (e instanceof VariableN){
            if (vmap.containsKey(e)){
                re = vmap.get(e);
            } else {
                re = new PatternVariable(((VariableN)e).name,
                        idCounter++);
                vmap.put((VariableN)e, (PatternVariable)re);
            }
        } else if (e instanceof Integer){
            int i = (Integer)e;
            // Accepts only small integers that can be compared with == operator.
            Lab.assertTrue( -128 <= i && i <= 127); 
            re = e;
        } else {
            re = e;
        }
        return re;
    }
    // TODO: t@N^O\Bϐ蓖ĂŏɂB
    public boolean match(Object[] vals){
        Lab.assertTrue(vals.length == patternVec.length);
        for (int i = 0; i < env.length; i++) {
            env[i] = UNBOUND;
        }
        for (int i = 0; i < vals.length; i++) {
            //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
            Lab.assertTrue(vals[i] != KEEP);
            Lab.assertTrue(patternVec[i] != KEEP);
            if (patternVec[i] == WILDCARD){
                // Do nothing.
            } else if (patternVec[i] == PLS){
                if (vals[i] == ZERO) return false;
                //if (vals[i] == WILDCARD) return false;
            } else {
                Object pval;
                if (patternVec[i] instanceof PatternVariable){
                    int id = ((PatternVariable)patternVec[i]).id;
                    if (env[id] == UNBOUND && vals[i] != WILDCARD){
                        pval = env[id] = vals[i];
                    } else {
                        pval = env[id];
                    }
                    //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                    //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                    //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                } else {
                    pval = patternVec[i];
                }
                // pval ͕ϐ蓖čς݂̃p^[̒lB
                // pval ̕ vals[i] LȂ return false B
                if (pval == WILDCARD){
                    System.out.println("this="+ this);
                    Lab.assertTrue(false);
                } else if (pval == UNBOUND){
                    // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                    Lab.assertTrue(vals[i] == WILDCARD);
                    // XXX: ̂悤ȏł悢̂낤H
                } else if (pval == PLS){
                    if (vals[i] == ZERO) return false;
                    //if (vals[i] == WILDCARD) return false;
                } else {
                    if (vals[i] != pval) return false;
                }
            }
            //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
            //for (int j = 0; j < env.length; j++) {
            //    System.out.println("env["+ j+ "]="+ env[j]);
            //}
        }
        //System.out.println("*** match ****");
        return true;
    }
    public Action getAction(){
        return action;
    }
    // p^[}b`́ul̃xNgvoB
    public Object[] getActionParam(){
        //Lab.assertTrue(action == Action.Call || action == Action.Set);
        Object[] ret = actionPatternVec.clone();
        for (int i = 0; i < ret.length; i++) {
            if (ret[i] == WILDCARD){
                ret[i] = WILDCARD;
            } else if (ret[i] instanceof PatternVariable){
                int id = ((PatternVariable)actionPatternVec[i]).id;
                if (env[id] == UNBOUND){
                    throw new Error("UNBOUND in action param");
                    //ret[i] = PLS;
                } else {
                    ret[i] = env[id];
                }
            }
        }
        return ret;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        Lab.assertTrue(patternVec.length % 2 == 0);
        int stateLength = patternVec.length / 2;
        buf.append("rule((");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[i]+ ",");
        }
        buf.append("), (");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[stateLength + i]+ ",");
        }
        buf.append("), ");
        if (actionPatternVec != null){
            buf.append(action+ "(");
            for (int i = 0; i < actionPatternVec.length; i++) {
                buf.append(actionPatternVec[i]+ ",");
            }
            buf.append(")");
        } else {
            buf.append(action+ "");
        }
        buf.append(").q = "+ q);
        return buf.toString();
    }
    public static class PatternVariable {
        String name;
        int id;
        public PatternVariable(String name, int id){ 
            this.name = name; this.id = id; 
        }
        //public String toString() { return ""+ id+ ":"+ name; }
        public String toString() { return ""+ name; }
    }
    // Special instance used for Action.Return
    public static final Rule returnRule = new ReturnRule();
    // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
    //   ReturnRule ̃CX^X𖳗gĂB
    public static State makeState(StateN stateN, Object defaultValue) {
        return new State(returnRule.transStateN(stateN, defaultValue).toArray());
    }
}
public static class ReturnRule extends Rule {
    public ReturnRule(){
        action = Action.Return;
        q = 0; // Q(g,g,RET) == 0
    }
    public String toString(){
        return "rule(Return).q = "+ q;
    }
}
/**
 * Q(s,g,C_m)  s, g, m \邽߂̃f[^\B
 */
public static class State {
    public Object[] values;
    public State(Object[] values) { this.values = values; }
    public Object[] getVec(){
        return values;
    }
    /**
     * Compares two states in order to check if the agent reaches 
     * the subgoal state x. 
     * State x may contain the special values: PLS and/or WILDCARD. 
     */
    public boolean satisfies(State x){
        Object[] xv = x.values;
        Lab.assertTrue(values.length == xv.length);
        for (int i = 0; i < xv.length; i++) {
            if (xv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (xv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != xv[i]) return false;
            }
        }
        return true;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("State(");
        for (int i = 0; i < values.length; i++) {
            buf.append(values[i].toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
    // State  n Ԗڂ̗vf𐮐ɂĕԂB̏ꍇ -1 ԂB
    public int getIntArg(int n) {
        Object x = values[n];
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        } else {
            return -1;
        }
    }
    public Object get(WM_Index index) { return values[index.ordinal()]; }
    public int getInt(WM_Index index) { 
        return getIntArg(index.ordinal()); 
    }
    public void set(WM_Index index, Object x) { values[index.ordinal()] = x; }
}


//--------------------------------------------------
public static abstract class AbstractMainCode extends Lab.MainCode {
    //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
    public int maxSteps = panel.getInt("max steps", 100, 1, 10000);
    public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
    public float rewardC = panel.getFloat("R^C", -1, -10, 0);
//  public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
//  public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
    public int mapSizeX;
    public int mapSizeY;
    public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
    public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
    public float vScale; 
    public lab.Lab.WTextArea qView = null;
    public AbstractMainCode mainCode = this; // Main ZN^őIB
 
    public void main() {
        World world = new World();
        world.printWorldInfo();
        world.main();
    }
    
    public class Agent {
        public State newS; // state
        public State newG; // subgoal
        public Rule newR; // rule 
        public State oldS;
        public State oldG;
        public Rule oldR;
        public State actionParamState; 
        public float reward;
        public Stack<State> stack;
        public State start, goal;
        public boolean failedFlag;
        public float stackValue;
        public State failedState;
        public World world;
        public RoomName currentRoom;
        public int energy;
        //public int currentPos;
        public Item selfItem; // Item that represents the agent itself.
        public List<Rule> rules;
        //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
        public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
        //
        public Agent(Item selfItem, World world){
            this.selfItem = selfItem;
            this.world = world;
        }
        public void setGoal(State g){
            State s = Rule.makeState(s(energy(1)), 0);
            setStartAndGoal(s, g);
        }
        public void setStartAndGoal(State s, State g){
            oldS = newS = start = s;
            oldG = newG = goal = g;
            failedState = s;
        }
        public void chooseFirstAction(){
            stack = new Stack<State>();
            chooseAction();
            oldR = newR;
        }
        // 
        public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
        public void takeAction(){
            Action action = oldR.getAction();
            failedFlag = false;

            if (panel.flag("Action log", true)) {
                StringBuffer buf = new StringBuffer();
                // indent
                for (int i = 0; i < stack.size(); i++) {
                    buf.append("  ");
                }
                buf.append(action.toString());
                if (actionParamState != null) {
                    buf.append('(');
                    Object[] values = actionParamState.values;
                    if (values.length > 0) {
                        buf.append(values[0].toString());
                        for (int i = 1; i < values.length; i++) {
                            buf.append(',');
                            buf.append(values[i].toString());
                        }
                    }
                    buf.append(')');
                }
                env.viewPanel.println("Action log "+ selfItem, buf.toString());
            }

            if (action == Action.Return){
                newS = oldS;
                newG = stack.pop();
                reward = 0;
            } else if (action == Action.Call){
                newS = oldS;
                stack.push(oldG);
                newG = actionParamState;
                reward = rewardC;
            } else if (action == Action.Set){
                //newS = actionParamState;

                newS = observe(actionParamState, oldS);
                if (newS != null){
                    newG = oldG;
                    reward = rewardC;
                } else {
                    // fail
                    failedFlag = true;
                    stackValue = evalStack(oldG, stack);
                    newS = failedState;
                    newG = goal;
                    stack.clear();
                    reward = rewardC + failPenalty;
                }
            } else if (action == Action.Fail){
                failedFlag = true;
                stackValue = evalStack(oldG, stack);
                newS = failedState;
                newG = goal;
                stack.clear();
                reward = rewardC + failPenalty;
            } else {
                reward = rewardC;
                State newS = new State(oldS.values.clone());
                takePrimitiveActionAndObserve();
                newG = oldG;
            }
        }
        public void chooseAction(){
            if (newS.satisfies(newG)){
                newR = Rule.returnRule;
                actionParamState = null;
            } else {
                List<Rule> matched = selectMatchedRules(newS, newG);
                
//                matched.forEach(r -> {
//                    System.out.println("matched: "+ r);
//                    if (r.action == Action.Call || r.action == Action.Set) {
//                        System.out.println("  a="+ r.action);
//                        System.out.println("  m="+ new State(r.getActionParam()));
//                    }
//                });
                
                float[] q = calcRulePriorities(matched);
                if (q.length == 0){
                    throw new Error("No action selected: (news,newG)="+ 
                            newS+ ", "+ newG);
                }
                // softmax  Rule PIB
                int index = softmax(q);
                if (panel.flag("Show matched rules", false)){
                    for (int i = 0; i < matched.size(); i++) {
                        env.viewPanel.println("matched"+ selfItem, i+ ":"+ matched.get(i));
                    }
                    for (int i = 0; i < q.length; i++) {
                        env.viewPanel.println("priority"+ selfItem, i+ ":"+ q[i]);
                    }
                    for (int i = 0; i < probTable.length; i++) {
                        env.viewPanel.println("probTable"+ selfItem, i+ ":"+ probTable[i]);
                    }
                }
                newR = matched.get(index);
                if (newR.actionPatternVec == null) {
                    actionParamState = null;
                } else {
                    actionParamState = new State(newR.getActionParam());
                }
            }
        }
        public List<Rule> selectMatchedRules(State s, State g){
            // s,g ̒lzB
            Object[] vals = new Object[s.values.length + g.values.length];
            for (int i = 0; i < s.values.length; i++) {
                vals[i] = s.values[i];
            }
            for (int i = 0; i < g.values.length; i++) {
                vals[i + s.values.length] = g.values[i];
            }
            //rules.forEach(r -> r.resetMatchResult());
            // (s,g) Ƀ}b`郋[IB
            // [̐ parallelStream gĂ݂B
            List<Rule> matched = rules.stream().filter(
                    r -> r.match(vals)
            ).collect(Collectors.toList());
            return matched;
        }
        public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
        public float[] calcRulePriorities(List<Rule> matched){
            float[] q = new float[matched.size()];
            for (int i = 0; i < q.length; i++) {
                Rule r = matched.get(i);
                // numVars ɉyieB^Bϐ̐Ȃ[DB
                float val = r.q - genericityPenalty * r.numVars;
                q[i] = val;
            }
            return q;
        }
        public void update() {
            if (oldR == Rule.returnRule){
                // Do nothing.
            } else if (failedFlag){
                float delta = reward + newR.q - oldR.q - stackValue;
                oldR.q += alpha * delta;
            } else {
                //q[oldS][oldA] += alpha * (reward + q[newS][newA] - q[oldS][oldA]);
                float vg; // V_g(g')
                if (oldG == newG){
                    vg = 0;
                } else {
                    vg = evalValue(oldG, newG);
                }
                //System.out.println(oldR+ ":vg="+vg);
                float delta;
                delta = reward + newR.q - oldR.q + vg;
                //System.out.println(delta);
                oldR.q += alpha * delta;
            }

            oldS = newS;
            oldG = newG;
            oldR = newR;
        }
        // Not tested enough.
        // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
        public float evalStack(State g, Stack<State> stack) {
            State ss = g;
            float ret = 0;
            for (int i = stack.size() - 1; i >= 0; i--) {
                //System.out.println("Stack!:"+ stack.get(i));
                State gg = stack.get(i);
                //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
                ret += evalValue(gg, ss);
                ss = gg;
            }
            //System.out.println("evalStack = "+ ret);
            return ret;
        }
        public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
        /** Returns V_g(s) */
        public float evalValue(State g, State s){
            List<Rule> matched = selectMatchedRules(s, g);
            float[] q = calcRulePriorities(matched);
            if (approxValueEvalFlag){
                // V_g(s) \approx max_a Q(s,g,a)
                int i = Lab.argmax(q); 
                return matched.get(i).q;
            } else {
                // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
                calcProbTable(q, 0, q.length);
                float val = 0;
                for (int i = 0; i < probTable.length; i++) {
                    // To avoid 0 * -Infinity = NaN
                    float value = matched.get(i).q;
                    if (value != Float.NEGATIVE_INFINITY){
                        val += probTable[i] * value;
                    }
                }
                return val; 
            }
        }
        
        
        // Softmax
        public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
        public int softmax(float[] q){ return softmax(q, 0, q.length); }
        public int softmax(float[] q, int from, int to){
            calcProbTable(q, from, to);
//            System.out.println("probTable=");
//            for (int i = 0; i < probTable.length; i++) {
//                System.out.print(probTable[i]+ ", ");
//            }
//            System.out.println();
            float r = Lab.rand();
            double sum = 0;
            for (int i = from; i < to; i++){
                sum += probTable[i]; 
                if (sum > r) {
                    Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                    return i;
                }
            }
            Lab.assertTrue(sum - 0.001f < 1);
            Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
            return to - 1;
        }
        // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
        public void calcProbTable(float[] q, int from, int to){
            if (q.length != probTable.length){
                probTable = new double[q.length];
            }
            float max = Lab.max(q);
            double total = 0;
            for (int i = from; i < to; i++){
                // To avoid overflow, subtract max.
                // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
                double val = Math.exp(beta * (q[i] - max));
                probTable[i] = val;
                total += val;
//                 System.out.println("q["+ i+ "]="+ q[i]);
//                 System.out.println("val="+ val);
            }
//            System.out.println("total="+ total);
            Lab.assertTrue(total > 0);
            for (int i = from; i < to; i++){
                probTable[i] /= total;
            }
        }
        
        public boolean achieved() {
            return stack.size() == 0 && newR.getAction() == Action.Return; 
        }
        
        
        /**
         * ̎ state ̒lA\Ɗϑ𓥂܂Č肵ԂB
         * \ƊϑĂꍇ fail \l null ԂB
         */
        public State observe(State setArg, State oldS) {
            Object[] prior = new Object[WM_Index.Last_WM.ordinal()];
            for (int i = 0; i < prior.length; i++) {
                if (setArg.values[i] == Rule.KEEP) {
                    prior[i] = oldS.values[i];
                } else {
                    prior[i] = setArg.values[i];
                }
            }
            Object[] likelihood = new Object[WM_Index.Last_WM.ordinal()];
//            for (int i = 0; i < likelihood.length; i++) {
//                likelihood[i] = null;
//            }

            if (setArg.get(RegNo) != Rule.KEEP) {
                Lab.assertTrue(setArg.get(RegNo) instanceof Integer);
                int r = setArg.getInt(RegNo);
                // }bvォ畨̂PTB
                int x = findObjectFromMap();
                Lab.assertTrue(x != -1); // ̃fł͕K̂ƉB
                Object o = world.map[getCurrentRoomID()][x];

                if (r == 1) {
                    likelihood[O1_what.ordinal()] = o;
                    likelihood[O1_where.ordinal()] = x;
                } else if (r == 2) {
                    likelihood[O2_what.ordinal()] = o;
                    likelihood[O2_where.ordinal()] = x;
                } else {
                    Lab.assertTrue(false);
                }
            }

            // ̏q͖IɊϑȂĂIɒl set B
            Lab.assertTrue(setArg.get(Energy) == Rule.KEEP);
            Lab.assertTrue(setArg.get(CurrentRoom) == Rule.KEEP);
            
            Object[] belief = new Object[WM_Index.Last_WM.ordinal()];
            // \ prior Ɗϑ likelihood ̖oꂽ fail B
            for (int i = 0; i < belief.length; i++) {
                if (prior[i] == Rule.WILDCARD) {
                    belief[i] = likelihood[i];
                } else if (prior[i] == Rule.PLS) {
                    if (likelihood[i] == Rule.ZERO) {
                         return null; // fail
                    } else {
                        belief[i] = likelihood[i];
                    }
                } else {
                    if (likelihood[i] == null) {
                        belief[i] = prior[i];
                    } else if (likelihood[i] == prior[i]) {
                        belief[i] = prior[i];
                    } else {
                        // likelihood[i] != prior[i]
                        return null; // fail
                    }
                }
                Lab.assertTrue(belief[i] != null);
            }

            belief[Energy.ordinal()] = energy;
            belief[CurrentRoom.ordinal()] = currentRoom;

            return new State(belief);
        }

        public int getCurrentRoomID() {
            return roomNameToRoomId(currentRoom);
        }
        public int roomNameToRoomId(RoomName roomName) {
            for (int i = 0; i < world.roomNames.length; i++) {
                if (roomName == world.roomNames[i]) return i;
            }
            throw new Error("roomNameToRoomId : "+ roomName);
        }

        /**
         * }bv̒烉_ɂP̂IňʒuԂB 
         */
        public int findObjectFromMap() {
            // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
            // }bv̂̐̕𐔂B
            int c = 0;
            int roomID = getCurrentRoomID();
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        c++;
                    }
                }
            }
            // _ r Ԗڂ̂̕IԁB
            int r = Lab.irand(c);
            c = 0;
            for (int x = 1; x < roomSizeX; x++) {
                for (int y = 1; y < roomSizeY; y++) {
                    if (world.map[roomID][y * roomSizeX + x] != Space) {
                        if (c++ == r) return y * roomSizeX + x;
                    }
                }
            }
            return -1; // Not found.
        }
        /**
         * }bv̒w肳ꂽ̂PTďꏊԂB
         * TB 
         */
        public int findItemFromTheRoom(Item item) {
            int roomID = getCurrentRoomID();
            for (int i = 0; i < world.map[roomID].length; i++) {
                if (world.map[roomID][i] == item) return i;
            }
            throw new Error("findItemFromMap: not found "+ item);
        }
        
        /** ANV a.oldR sA a.newS ϑB
         * Vꍇ a.reward ̒lɉZB
         */
        public void takePrimitiveActionAndObserve() {
            Action action = oldR.getAction();
            int roomID = getCurrentRoomID();
            switch (action) {
            case EatO1: {
                // O1 HׂȂ炻 Leftovers ɕϊB
                // W̉ĂȂƂ́HƂ肠G[B
                // HׂȂƂ́HƂ肠G[B
                int x = newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x];
                    if (target == Nut) {
                        world.map[roomID][x] = Space;
                        energy++;
                        newS.set(Energy, energy);
                    } else {
                        Lab.assertTrue(false);
                    }
                }
                observeO1();
            } break;

            case MoveO2toO1: {
                // O2  O1 ̏ꏊɈړAO1, O2 ͌`EʒuωB
                int x1 = newS.getInt(O1_where);
                int x2 = newS.getInt(O2_where);
                if (x1 == -1 || x2 == -1) {
                    Lab.assertTrue(false);
                } else if (x1 == 0 || x2 == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x1];
                    Object item = world.map[roomID][x2];
                    if (target == Shell && item == Stone) {
                        world.map[roomID][x1] = Nut;
                        world.map[roomID][x2] = Space;
                    } else {
                        // Fail ׂH
                        Lab.assertTrue(false);
                    }
                    observeO1();
                }
            } break;

            case MoveSelfAndEatO1: {
                // O1 HׂȂ玩g O1 ɈړĐHׂB
                int selfX = findItemFromTheRoom(selfItem);

                int x = newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else if (x == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = world.map[roomID][x];
                    if (target == Nut) {
                        world.map[roomID][x] = selfItem;
                        world.map[roomID][selfX] = Space;
                        energy++;
                        newS.set(Energy, energy);
                    } else {
                        //System.out.println("Stolen!");
                        //Lab.assertTrue(false);
                    }
                }
                observeO1();
            } break;
            
            case Say: {
                Verb verb = (Verb)actionParamState.get(S_verb);
                Object obj = actionParamState.get(S_object);
                switch (verb) {
                case WhereIs : {
                    Lab.assertTrue(obj instanceof Item);
                    int x = findItemFromTheRoom((Item)obj);  
                    newS.set(RegNo, 1);
                    newS.set(O1_what, obj);
                    newS.set(O1_where, x);
                } break;
                
                case GiveMe : {
                    // }bv obj uȀꏊ O1 ɃZbgB
                    Lab.assertTrue(obj instanceof Item);
                    putItemAtRandomPosInRoom(world.map[roomID], (Item)obj);
                    int x = findItemFromTheRoom((Item)obj);
                    newS.set(RegNo, 1);
                    newS.set(O1_what, obj);
                    newS.set(O1_where, x);
                } break;
                
                case HereIs : {
                    // sentence(HereIs,Nut) ƔbĂ
                    // O1 ̏ꏊ Nut  Thanks ƕԎB
                    // Nut łȂꍇ͉ȂB
                    // (ݒ̃^XNŗpƉB)
                    int o1 = newS.getInt(O1_what);
                    int x1 = newS.getInt(O1_where);
                    Item item = world.map[roomID][x1];
                    if (obj == Nut && obj == item) {
                        newS.set(S_verb, Verb.Thanks);
                        newS.set(S_object, 0);
                    }
                } break;

                default:{
                    Lab.assertTrue(false);
                } break;
                }
                
            } break;

            case MoveToRoom: {
                RoomName newRoomName = (RoomName)actionParamState.get(CurrentRoom);
                Lab.assertTrue(newRoomName != null);
                int newRoomID = roomNameToRoomId(newRoomName);
                // map ̍XVB
                int pos = findItemFromTheRoom(selfItem);
                world.map[roomID][pos] = Space;
                currentRoom = newRoomName;
                putItemAtRandomPosInRoom(world.map[newRoomID], selfItem);
                newS.set(CurrentRoom, newRoomName);
                // IuWFNgWX^ׂ͂ăNAB
                newS.set(RegNo, 0);
                newS.set(O1_what, 0);
                newS.set(O1_where, 0);
                newS.set(O2_what, 0);
                newS.set(O2_where, 0);
            } break;

            default: {
                Lab.assertTrue(false);
            } break;
            }
        }
        /**
         * [LO newS ̂̕P̒lɍ킹čXVB
         * ̂Q̒l 0 ƂB
         * ꕔ̑ΊOANV̎sɌĂ΂B
         * TODO: ̂̈ړgbLO@\Ă悢B
         */
        public void observeO1() {
            int x = newS.getInt(O1_where);
            if (x == 0) return;
            Object obj = world.map[getCurrentRoomID()][x];
            newS.set(RegNo, 1);
            newS.set(O1_what, obj);
            newS.set(O1_where, x);
            newS.set(O2_what, 0);
            newS.set(O2_where, 0);
        }

    }
    //--------------------------------------------------
    public boolean visualizeFlag;
    public class World {
        public RoomName[] roomNames;
        public Item[][] map;
        public Agent[] agents;
        //
        public World(){
            agents = mainCode.makeAgents(this);
            mainCode.initAgentsTable(this);
        }
        public void main(){
            int counter = 0;
            for (;;){
                visualizeFlag = panel.flag("visualizeFlag", true);
                panel.speedControl("Episode loop", 0);
                mainCode.setMap(this);
                initRooms();
                mainCode.initEpisode(this);
//                State start = mainCode.startState();
//                State goal = mainCode.goalState();
//                for (int i = 0; i < agents.length; i++) {
//                    Agent agent = agents[i];
//                    agent.setStartAndGoal(start, goal);
//                    agent.chooseFirstAction();
//                }
                for (int i = 0; i < agents.length; i++) {
                    Agent a = agents[i];
                    a.observe(Rule.makeState(s(), Rule.KEEP), a.oldS);
                    a.chooseFirstAction();
                }
                int steps = 0;
                // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
                while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
                    for (int i = 0; i < agents.length; i++) {
                        Agent agent = agents[i];
                        env.viewPanel.print1("counter=", ""+ counter++);
                        if (visualizeFlag){
                            panel.speedControl("Step loop", 100);
                            visualizeMap();
                            visualizeAgentState(agent);
                        }
                        
                        agent.takeAction();
                        agent.chooseAction();
                        agent.update();

                        if (visualizeFlag){
                            visualizeMap();
                            visualizeAgentState(agent);
                        }
                    }
                }
            }
        }
        public void visualizeAgentState(Agent agent){
            {
                String goalsLabel = "Goals "+ agent.selfItem;
                env.viewPanel.setText(goalsLabel, ""); // Clear text.
                for (int i = 0; i < agent.stack.size(); i++) {
                    // Print elements from bottom to top.
                    env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
                }
                env.viewPanel.println(goalsLabel, ""+ agent.oldG);
            }
            {
                String logLabel = "Log "+ agent.selfItem;
                env.viewPanel.println(logLabel, "---");
                String s = "stack size="+ agent.stack.size()+ ":";
                for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                    // Add elements from top to bottom.
                    s += agent.stack.get(i)+ ", ";
                }
                env.viewPanel.println(logLabel, s);
                env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                        ", "+ agent.oldG);
                env.viewPanel.println(logLabel, ""+ agent.oldR);
            }
            String ruleLabel = "rule.q "+ agent.selfItem;
            env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
            env.viewPanel.resetGraphData(ruleLabel);
            agent.rules.forEach(r -> {
                env.viewPanel.plot(ruleLabel, r.q);
            });
        }
        
        
        public void initRooms(){
            //map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
            for (int r = 0; r < map.length; r++) {
                for (int p = 0; p < map[r].length; p++) {
                    map[r][p] = Space;
                }
                // 
                // x=0 or y=0 ̍WɕuȂ悤ɂ邽߂ɕǂĂB
                for (int x = 0; x < roomSizeX; x++) {
                    map[r][x] = Wall; 
                }
                for (int y = 0; y < roomSizeY; y++) {
                    map[r][y * roomSizeX] = Wall;
                }
            }
            //mainCode.initMap(map);
//            if (visualizeFlag){
//                env.viewPanel.paint("Map", mapPainter);
//            }
        }
        public void visualizeMap(){
            env.viewPanel.paint("Map", mapPainter);
        }
        public MapPainter mapPainter = new MapPainter();
        public int charSize = panel.getInt("charSize", 24, 1, 40);
        public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
        //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
        public class MapPainter extends Lab.Code implements Lab.Painter {
            public Dimension getSize(){
                int totalSizeX = mapSizeX * roomSizeX;
                int totalSizeY = mapSizeY * roomSizeY;
                return new Dimension(charSize * (totalSizeX + 1),
                        charSize * (totalSizeY + 1));
            }
            int counter = 0;
            public void paintComponent(Graphics g, MouseEvent lastEvent) {
                // W (0,0) ƂB
                // x=0 or y=0 ͕ǁBǂł͂Ȃ x, y >= 1 Ŵݕ`悷B 
                g.setFont(f);
                for (int ry = 0; ry < mapSizeY; ry++) {
                    for (int rx = 0; rx < mapSizeX; rx++) {
                        g.setColor(Color.BLACK);
                        g.drawString(roomNames[ry * mapSizeX + rx].toString(),
                            posX(rx, ry, 1, roomSizeY-1), 
                            posY(rx, ry, 1, roomSizeY-1));
                        
                        for (int y = 1; y < roomSizeY; y++) {
                            for (int x = 1; x < roomSizeX; x++) {
                                int r = ry * mapSizeX + rx;
                                int p = y * roomSizeX + x; 
                                String str = map[r][p].code;
                                g.setColor(Color.BLACK);
                                g.drawString(str,
                                    posX(rx, ry, x, y-1), 
                                    posY(rx, ry, x, y-1));
                            }
                        }
                    }
                }
                for (int i = 0; i < agents.length; i++) {
                    paintAgent(agents[i], g);
                }
            }
            public void paintAgent(Agent a, Graphics g) {
                int roomID = a.getCurrentRoomID();
                int selfRX = roomID % mapSizeX;
                int selfRY = roomID / mapSizeX;
                int selfX = 0, selfY = 0;
                // Find self
                for (int y = 1; y < roomSizeY; y++) {
                    for (int x = 1; x < roomSizeX; x++) {
                        if (map[roomID][y * roomSizeX + x] == a.selfItem) {
                            selfX = x; selfY = y;
                        }
                    }
                }
                Lab.assertTrue(selfX != 0 && selfY != 0);

                int rx = roomID % mapSizeX;
                int ry = roomID / mapSizeX;
                int where1 = a.newS.getInt(O1_where);
                Lab.assertTrue(where1 != -1);
                int x1 =  where1 % roomSizeX;
                int y1 =  where1 / roomSizeX;
                int where2 = a.newS.getInt(O2_where);
                Lab.assertTrue(where2 != -1);
                int x2 =  where2 % roomSizeX;
                int y2 =  where2 / roomSizeX;
                
                if (x1 != 0 && y1 != 0) {
                    g.setColor(Color.GREEN);
                    g.drawRect(posX(rx, ry, x1, y1), posY(rx, ry, x1, y1),
                            charSize - 2, charSize - 2);
                    g.drawString("1", 
                            posX(rx, ry, x1, y1), posY(rx, ry, x1, y1));
                    
                    g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posX(rx, ry, x1, y1) + charSize/2,
                            posY(rx, ry, x1, y1) + charSize/2);
                }
                if (x2 != 0 && y2 != 0) {
                    g.setColor(Color.RED);
                    // `̘g2sNZ炵ĕ\B
                    g.drawRect(posX(rx, ry, x2, y2) + 2, posY(rx, ry, x2, y2) + 2,
                            charSize - 2, charSize - 2);
                    g.drawString("2", 
                            posX(rx, ry, x2, y2), posY(rx, ry, x2, y2));
                    
                    g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                            posX(rx, ry, x2, y2) + charSize/2,
                            posY(rx, ry, x2, y2) + charSize/2);
                }
            }
        }
        public int posX(int rx, int ry, int x, int y) {
            return (rx * roomSizeX + x) * charSize;
        }
        public int posY(int rx, int ry, int x, int y) {
            return  (mapSizeY * roomSizeY 
                      - (ry * roomSizeY + y) 
                      )
                    * charSize;
        }
        public Integer stateElemToInteger(Object elem) {
            if (elem instanceof Integer) {
                return (Integer)elem;
            } else {
                return null;
            }
        }
        
        /**
         * fobOpɏóB
         */
        public void printWorldInfo() {
            System.out.println("Task = "+ this.getClass().getName());

            for (int i = 0; i < agents.length; i++) {
                Agent a = agents[i];
                System.out.println("Rules for agent "+ a.selfItem);
                for (int j = 0; j < a.rules.size(); j++) {
                    System.out.println(j+ ":"+ a.rules.get(j));
                }
                System.out.println();
            }
        }
    }
    
    //--------------------------------------------------
    // DSL for rule definition. 
    VariableN o1 = new VariableN("o1");
    VariableN x1 = new VariableN("x1");
    VariableN o2 = new VariableN("o2");
    VariableN x2 = new VariableN("x2");
    VariableN x = new VariableN("x");
    VariableN t = new VariableN("t");
    VariableN s = new VariableN("s");
    VariableN v = new VariableN("v");
    VariableN o = new VariableN("o");
    VariableN c = new VariableN("c");
    VariableN room = new VariableN("room");
    public static final String __ = Rule.WILDCARD; // Two underscores.
    public static final String PLS = Rule.PLS;
    public static final String NA = "NA".intern();
    public StateN s(Object... args){
       return new StateN(Arrays.asList(args));
    }
    public ActionN call(Object... args){
        return new ActionN(Call, new StateN(Arrays.asList(args)));
    }
    public ActionN set(Object... args){
        return new ActionN(Set, new StateN(Arrays.asList(args)));
    }
//    public ActionN say(Object... args){
//        return new ActionN(Say, new StateN(Arrays.asList(args)));
//    }

    List<RuleN> ruleList;
    // rule(s, g, call/set(...))
    public void rule(StateN s, StateN g, ActionN a){
        ruleList.add(new RuleN(s, g, a));
    }
    // rule(s, g, Primitive)
    public void rule(StateN s, StateN g, Action a){
        ruleList.add(new RuleN(s, g, new ActionN(a, null)));
    }
    // rule(s, g, Primitive, s(...))
    public void rule(StateN s, StateN g, Action a, StateN arg){
        ruleList.add(new RuleN(s, g, new ActionN(a, arg)));
    }

    // Predicates
    public Object[] r(Object reg) {
        return new Object[] { RegNo.p(reg) };
    }
    public Object[] o1(Object what, Object where) {
        return new Object[] { O1_what.p(what), O1_where.p(where) };
    }
    public Object[] o2(Object what, Object where) {
        return new Object[] { O2_what.p(what), O2_where.p(where) };
    }
    public Object[] energy(Object value) {
        return new Object[] { Energy.p(value) };
    }
    public Object[] sentence(Object tense, 
            Object subject, Object verb, Object object, Object complement) {
        return new Object[] { 
                S_tense.p(tense),
                S_subject.p(subject),
                S_verb.p(verb),
                S_object.p(object),
                S_complement.p(complement)};
    }
    public Object[] sentence(Object verb, Object object) {
        return new Object[] { 
                S_tense.p(NA),
                S_subject.p(NA),
                S_verb.p(verb),
                S_object.p(object),
                S_complement.p(NA)};
    }
    public Object[] currentRoom(Object r) {
        return new Object[] { CurrentRoom.p(r) };
    }
    // End of DSL functions.
    
    // Methods for Task initialization.
    //
    public abstract Agent[] makeAgents(World world);
    /**
     * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
     * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
     * ݒ肷邱Ƃ\B
     */
    public void initAgentsTable(World world) {
        for (int i = 0; i < world.agents.length; i++) {
            Agent a = world.agents[i];
            ruleList = new ArrayList<>();
            listRules();
            a.rules = ruleList.stream().map(
                    ruleN ->  new Rule(ruleN)
                ).collect(Collectors.toList());
            // KvȂ q lBƂ肠Ô܂܂ƂB
        }
        
    }
    public abstract void listRules();

    /**
     * }bṽCAEg̐ݒB
     * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
     */
    public void setMap(World world) {
        mapSizeX = 1;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public abstract void initEpisode(World world); 
    
    public static void putItemAtRandomPosInRoom(Item[] room, Item item){
        for (int i = 0; i < 10000; i++) {
            int x = Lab.irand(room.length);
            if (room[x] == Space){
                room[x] = item;
                return;
            }
        }
        throw new Error("putItemAtRandomPosInRoom0: no space found.");
    }
}
//--------------------------------------------------
//--------------------------------------------------
// Demo Task definitions

// f Nut ̏ꏊ𕷂B
public static class DemoLang1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1, s());

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Nut ̏ꏊ𕷂B
        rule(s(), g2, Say, s(sentence(Verb.WhereIs,Nut)));
    }
    public void initEpisode(World world){
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(2)), __)
                );
    }
}
//f  Nut ̏ꏊ𕷂ꂽ狳ĂB
// Ƃ肠Ӑ}ȂB
public static class DemoLang2 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Thanks ƌĂ炤Tu[`B
        StateN g1 = s(sentence(Verb.Thanks, 0));
        rule(s(sentence(Verb.WhereIs, x)), g1, Call, s(o1(x,PLS)));
        rule(s(o1(x,PLS),sentence(Verb.WhereIs, x)), g1, Say, s(sentence(Verb.HereIs, x)));

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(x,PLS));
        rule(s(), g2, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setStartAndGoal(
                Rule.makeState(s(sentence(Verb.WhereIs, Nut)), 0),
                Rule.makeState(s(sentence(Verb.Thanks,0)), __)
                );
    }
}

// gړĎRHׂ^XNB
public static class Demo2 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(4));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1, s());

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){ 
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(4)), __)
                );
    }
}

// ΂kɂԂďoĂHׂ^XNB
public static class Demo1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, Call, s(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1, s());

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Shell  Stone TB
        rule(s(), g2, Call, s(o1(Shell,PLS),o2(Stone,PLS)));
        rule(s(o1(Shell,PLS),o2(Stone,PLS)), g2, MoveO2toO1, s());

        // Shell  Stone IuWFNgWX^ɓTu[`B
        StateN g3 = s(o1(Shell,PLS),o2(Stone,PLS));
        rule(s(), g3, Set, s(r(2),o2(PLS,PLS)));
        rule(s(o2(Stone,PLS)), g3, Set, s(r(1),o1(PLS,PLS)));
    }
    public void initEpisode(World world){
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Stone);
        putItemAtRandomPosInRoom(world.map[0], Shell);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(2)), __)
                );
    }
}

public static class Test1Rooms1 extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(5));
        rule(s(), g1, call(currentRoom(RoomName.Room1)));
        rule(s(), g1, call(currentRoom(RoomName.Room2)));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1);

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, set(r(1),o1(PLS,PLS)));
        rule(s(), g2, Fail); // Ƃǂ߂ fail

        // ̈ړB
        rule(s(), s(currentRoom(room)), MoveToRoom, s(currentRoom(room)));
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].energy = 1;
        world.agents[0].currentRoom = RoomName.Room1;
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        world.agents[0].setGoal(
                Rule.makeState(s(energy(5)), __)
                );
    }
}

public static class Test1Agents extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {
            new Agent(Self, world),
            new Agent(Brother, world)}; }
    public final StateN goal0 = s(energy(3)); 
    public final StateN goal1 = s(energy(100)); 
    public void listRules(){
        // Nut HׂTu[`B
        StateN g0 = goal0;
        rule(s(), g0, call(currentRoom(RoomName.Room1)));
        rule(s(), g0, call(currentRoom(RoomName.Room2)));
        rule(s(), g0, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g0, MoveSelfAndEatO1);

        StateN g1 = goal1;
        rule(s(), g1, call(currentRoom(RoomName.Room1)));
        rule(s(), g1, call(currentRoom(RoomName.Room2)));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1);

        // Nut IuWFNgWX^ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        rule(s(), g2, set(r(1),o1(PLS,PLS)));
        rule(s(), g2, Fail); // Ƃǂ߂ fail

        // ̈ړB
        rule(s(), s(currentRoom(room)), MoveToRoom, s(currentRoom(room)));
    }
    public void setMap(World world) {
        mapSizeX = 2;
        mapSizeY = 1;
        world.roomNames = new RoomName[]{ RoomName.Room1,  RoomName.Room2 };
        world.map = new Item[mapSizeX * mapSizeY][roomSizeX * roomSizeY];
        Lab.assertTrue(mapSizeX * mapSizeY == world.roomNames.length);
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = RoomName.Room1;
        world.agents[0].energy = 1;
        world.agents[0].setGoal(
                Rule.makeState(goal0, __)
                );
        world.agents[1].currentRoom = RoomName.Room2;
        world.agents[1].energy = 1;
        world.agents[1].setGoal(
                Rule.makeState(goal1, __)
                );
        
        putItemAtRandomPosInRoom(world.map[0], Self);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Grass);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[0], Nut);
        putItemAtRandomPosInRoom(world.map[1], Brother);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Grass);
        putItemAtRandomPosInRoom(world.map[1], Nut);
        putItemAtRandomPosInRoom(world.map[1], Nut);
    }
}


// Default dummy task.
public static class Demo0_Dummy extends AbstractMainCode {
    public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Self, world)}; }
    public void listRules(){
        throw new StopPressed();
    }
    public void initEpisode(World world){ throw new Error(); }
}
}
