//Copyright (c) 2021 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

f̍ŏ̃o[WB


*/

package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v3.Action.*;
import static tmm1.TMM3v3.Item.*;
import static tmm1.TMM3v3.WM_Index.*;

import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v3 {
public static void main(String[] args) {
    Lab.addSelectableClass(TMM3v3.class);
    System.out.println(Lab.selectableClasses + "");

    LabCode labCode = new LabCode();
    labCode.main(Main.class);
}
/**
 * primitive actions 
 */
public static enum Action {
    EatO1,
    MoveO2toO1,
    MoveSelfAndEatO1,
    Call,
    Return,
    Set,
    Say,
    Fail;
}
public static enum WM_Index {
    RegNo,
    // Objects
    O1_what,
    O1_where,
    O2_what,
    O2_where,
    Want_who,
    Want_what,
    // Clause
    S_verb,
    S_object,
    Energy,
    Last_WM; // Dummy
    public ElementN p(Object x) {
        return new ElementN(this, x);
    }
}
public static class ElementN {
    public WM_Index index;
    public Object val;
    public ElementN(WM_Index index, Object x){
        this.index = index; this.val = x;
    }
    public String toString(){
        return index+ "("+ val+ ")"; 
    }
}
public static enum Item {
    Wall("\u58c1"),  // 
    Self(""),  // g
    Stone(""), // 
    Shell("k"), // k
    Nut(""), // 
//    Stone(new String(new int[] {0x1F528},0,1)), // n}[
    Grass(""), // 
    //Meat(""), // 
    Nothing(""), // 
    Space("E"); // E 

    public final String code;
    private Item(String code){
        this.code = code;
    }
}
public static enum Verb {
    WhereIs,
    GiveMe,
    HereIs,
    Thanks,
    Last_Verb; // Dummy
}

// Abstract syntax nodes for DSL
public static class StateN {
    public List<Object> elems;
    public StateN(List<Object> vars) { this.elems = vars; }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("s(");
        elems.forEach(obj -> {
            buf.append(obj.toString());
            buf.append(", ");
        });
        buf.append(")");
        return buf.toString();
    }
}
//public static class CallN {
//    public StateN m;
//    public CallN(StateN m){ this.m = m; }
//    public String toString() {
//        return "call("+ m+ ")";
//    }
//}
//public static class SetN {
//    public StateN m;
//    public SetN(StateN m){ this.m = m; }
//    public String toString() {
//        return "set("+ m+ ")";
//    }
//}
//public static class SayN {
//    public StateN m;
//    public SayN(StateN m){ this.m = m; }
//    public String toString() {
//        return "say("+ m+ ")";
//    }
//}
public static class RuleN {
    public StateN s, g;
    public ActionN a;
    public RuleN(StateN s, StateN g, ActionN a){ 
        this.s = s; this.g = g; this.a = a;
    }
    public String toString(){
        return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
    }
}
public static class ActionN {
    public Action a;
    public StateN m;
    public ActionN(Action a, StateN m){ 
        this.a = a; this.m = m;
    }
    public String toString(){
        if (m == null){
            return a.toString();
        } else {
            return a.toString()+ "("+ m+ ")";
        }
    }
}
/**
 * pattern variable 
 */
public static class VariableN {
    public String name;
    public VariableN(String name){ this.name = name; }
}
public static abstract class DemoCode extends Lab.Code {
    VariableN o1 = new VariableN("o1");
    VariableN x1 = new VariableN("x1");
    VariableN o2 = new VariableN("o2");
    VariableN x2 = new VariableN("x2");
    VariableN x = new VariableN("x");
    public static final String __ = Rule.WILDCARD; // Two underscores.
    public static final String PLS = Rule.PLS;
    public StateN s(Object... args){
       return new StateN(Arrays.asList(args));
    }
//    public CallN call(Object... args){
//        return new CallN(new StateN(Arrays.asList(args)));
//    }
//    public SetN set(Object... args){
//       return new SetN(new StateN(Arrays.asList(args)));
//    }
//    public SayN say(Object... args){
//        return new SayN(new StateN(Arrays.asList(args)));
//    }
    public ActionN call(Object... args){
        return new ActionN(Call, new StateN(Arrays.asList(args)));
    }
    public ActionN set(Object... args){
        return new ActionN(Set, new StateN(Arrays.asList(args)));
    }
    public ActionN say(Object... args){
        return new ActionN(Say, new StateN(Arrays.asList(args)));
    }
    List<RuleN> ruleList = new ArrayList<>();
    public void rule(StateN s, StateN g, Action a){
        ruleList.add(new RuleN(s, g, new ActionN(a, null)));
    }
//    public void q(StateN s, StateN g, Action a, StateN m){
//        ruleList.add(new RuleN(s, g, new ActionN(a, m)));
//    }
//    public void rule(StateN s, StateN g, CallN c){
//        ruleList.add(new RuleN(s, g, new ActionN(Action.Call, c.m)));
//    }
//    public void rule(StateN s, StateN g, SetN c){
//        ruleList.add(new RuleN(s, g, new ActionN(Action.Set, c.m)));
//    }
    public void rule(StateN s, StateN g, ActionN a){
        ruleList.add(new RuleN(s, g, a));
    }

    // Predicates
    public Object[] r(Object reg) {
        return new Object[] { RegNo.p(reg) };
    }
    public Object[] o1(Object what, Object where) {
        return new Object[] { O1_what.p(what), O1_where.p(where) };
    }
    public Object[] o2(Object what, Object where) {
        return new Object[] { O2_what.p(what), O2_where.p(where) };
    }
    public Object[] energy(Object value) {
        return new Object[] { Energy.p(value) };
    }
    public Object[] sentence(Object verb, Object object) {
        return new Object[] { S_verb.p(verb), S_object.p(object) };
    }
    
    //    
    abstract public State startState();
    abstract public State goalState();
        
    //
    public abstract List<RuleN> makeRules();
    public abstract void initMap(Item[] map);
    
    public static void putItemAtRandomPosition(Item[] map, Item item){
        for(;;){
            int x = Lab.irand(map.length);
            if (map[x] == Space){
                map[x] = item;
                return;
            }
        }
    }
}
//--------------------------------------------------
//--------------------------------------------------
// Demo Task definitions

// f Nut ̏ꏊ𕷂B
public static class DemoLang1 extends DemoCode {
    public List<RuleN> makeRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1);

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Nut ̏ꏊ𕷂B
        rule(s(), g2, say(sentence(Verb.WhereIs,Nut)));

        return ruleList;
    }
    public State startState() {
//        State s = State.zeroState();
//        s.set(Energy, 1);
//        return s;
        return Rule.makeState(s(energy(1)), 0);
    }
    public State goalState() {
//        State s = State.wildcardState();
//        s.set(Energy, 2);
//        return s;
        return Rule.makeState(s(energy(2)), __);
    }
    public void initMap(Item[] map) {
        putItemAtRandomPosition(map, Self);
        putItemAtRandomPosition(map, Grass);
        putItemAtRandomPosition(map, Grass);
        putItemAtRandomPosition(map, Grass);
        putItemAtRandomPosition(map, Nut);
    }
}
//f  Nut ̏ꏊ𕷂ꂽ狳ĂB
// Ƃ肠Ӑ}ȂB
public static class DemoLang2 extends DemoCode {
 public List<RuleN> makeRules(){
     // Thanks ƌĂ炤Tu[`B
     StateN g1 = s(sentence(Verb.Thanks, 0));
     //rule(s(sentence(Verb.WhereIs, x)), g1, call(o1(x,PLS)));
     rule(s(sentence(Verb.WhereIs, x)), g1, call(o1(x,PLS)));
     rule(s(o1(x,PLS),sentence(Verb.WhereIs, x)), g1, say(sentence(Verb.HereIs, x)));

     // Nut IuWFNgWX^ɓTu[`B
     StateN g2 = s(o1(x,PLS));
     rule(s(), g2, set(r(1),o1(PLS,PLS)));

     return ruleList;
 }
 public State startState() {
//     State s = State.zeroState();
//     s.set(S_verb, Verb.WhereIs);
//     s.set(S_object, Nut);
//     return s;
     return Rule.makeState(s(sentence(Verb.WhereIs, Nut)), 0);
 }
 public State goalState() {
//     State s = State.wildcardState();
//     s.set(S_verb, Verb.Thanks);
//     s.set(S_object, 0);
//     return s;
     return Rule.makeState(s(sentence(Verb.Thanks,0)), __);
 }
 public void initMap(Item[] map) {
     putItemAtRandomPosition(map, Self);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Nut);
 }
}
//f g̓_~[B
public static class DemoLang0 extends DemoCode {
 public List<RuleN> makeRules(){
     // Nut HׂTu[`B
     StateN g1 = s(energy(2));
     rule(s(), g1, call(o1(Nut,PLS)));
     rule(s(o1(Nut,PLS)), g1, EatO1);

     // Nut ɓTu[`B
     StateN g2 = s(o1(Nut,PLS));
     // Shell  Stone TB
     rule(s(), g2, call(o1(Shell,PLS),o2(Stone,PLS)));
     rule(s(o1(Shell,PLS),o2(Stone,PLS)), g2, MoveO2toO1);

     // Shell  Stone IuWFNgWX^ɓTu[`B
     StateN g3 = s(o1(Shell,PLS),o2(Stone,PLS));
     rule(s(), g3, set(r(2),o2(PLS,PLS)));
     rule(s(o2(Stone,PLS)), g3, set(r(1),o1(PLS,PLS)));

     return ruleList;
 }
 public State startState() {
//     State s = State.zeroState();
//     s.set(Energy, 1);
//     return s;
     return Rule.makeState(s(energy(1)), 0);
 }
 public State goalState() {
//     State s = State.wildcardState();
//     s.set(Energy, 2);
//     return s;
     return Rule.makeState(s(energy(2)), __);
 }
 public void initMap(Item[] map) {
     putItemAtRandomPosition(map, Self);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Stone);
     putItemAtRandomPosition(map, Shell);
 }
}


// gړĎRHׂ^XNB
public static class Demo2 extends DemoCode {
 public List<RuleN> makeRules(){
     // Nut HׂTu[`B
     StateN g1 = s(energy(4));
     rule(s(), g1, call(o1(Nut,PLS)));
     rule(s(o1(Nut,PLS)), g1, MoveSelfAndEatO1);

     // Nut IuWFNgWX^ɓTu[`B
     StateN g2 = s(o1(Nut,PLS));
     rule(s(), g2, set(r(1),o1(PLS,PLS)));
     
     return ruleList;
 }
 public State startState() {
//     State s = State.zeroState();
//     s.set(Energy, 1);
//     return s;
     return Rule.makeState(s(energy(1)), 0);
 }
 public State goalState() {
//     //StateN s = s(RegNo.p(1), O1_what.p(Nothing),O1_where.p(PLS));
//     State s = State.wildcardState();
//     s.set(Energy, 4);
//     return s;
     return Rule.makeState(s(energy(4)), __);
//     StateN s = s(energy(1));
//     List<Object> vec = Rule.returnRule.transStateN(s, false); 
//     return new State(vec.toArray());
 }
 public void initMap(Item[] map) {
     putItemAtRandomPosition(map, Self);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Grass);
     putItemAtRandomPosition(map, Nut);
     putItemAtRandomPosition(map, Nut);
     putItemAtRandomPosition(map, Nut);
 }
}

// ΂kɂԂďoĂHׂ^XNB
public static class Demo1 extends DemoCode {
    public List<RuleN> makeRules(){
        // Nut HׂTu[`B
        StateN g1 = s(energy(2));
        rule(s(), g1, call(o1(Nut,PLS)));
        rule(s(o1(Nut,PLS)), g1, EatO1);

        // Nut ɓTu[`B
        StateN g2 = s(o1(Nut,PLS));
        // Shell  Stone TB
        rule(s(), g2, call(o1(Shell,PLS),o2(Stone,PLS)));
        rule(s(o1(Shell,PLS),o2(Stone,PLS)), g2, MoveO2toO1);

        // Shell  Stone IuWFNgWX^ɓTu[`B
        StateN g3 = s(o1(Shell,PLS),o2(Stone,PLS));
        rule(s(), g3, set(r(2),o2(PLS,PLS)));
        rule(s(o2(Stone,PLS)), g3, set(r(1),o1(PLS,PLS)));
        //rule(s(), g3, set(r(2)));
        //rule(s(o2(Stone,PLS)), g3, set(r(1)));
        
//        // Nut HׂTu[`B
//        StateN g1 = s(RegNo.p(1),O1_what.p(Nothing),O1_where.p(PLS));
//        rule(s(), g1, call(RegNo.p(1),O1_what.p(Nut),O1_where.p(PLS)));
//        rule(s(O1_what.p(Nut),O1_where.p(PLS)), g1, EatO1);
//
//        // Nut ɓTu[`B
//        StateN g2 = s(RegNo.p(1),O1_what.p(Nut),O1_where.p(PLS));
//        // Shell  Stone TB
//        rule(s(), g2, call(RegNo.p(1),O1_what.p(Shell),O1_where.p(PLS),
//                O2_what.p(Stone),O2_where.p(PLS)));
//        rule(s(O1_what.p(Shell),O1_where.p(PLS),
//                        O2_what.p(Stone),O2_where.p(PLS)),
//                g2, MoveO2toO1);
//
//        // Shell  Stone IuWFNgWX^ɓTu[`B
//        StateN g3 = s(RegNo.p(1),O1_what.p(Shell),O1_where.p(PLS),
//                      O2_what.p(Stone),O2_where.p(PLS));
//        rule(s(), g3, set(RegNo.p(2),O2_what.p(PLS),O2_where.p(PLS)));
//        rule(s(RegNo.p(2),O2_what.p(Stone),O2_where.p(PLS)), g3, 
//                set(RegNo.p(1),O1_what.p(PLS),O1_where.p(PLS)));
//        rule(s(RegNo.p(1),O2_what.p(Stone),O2_where.p(PLS)), g3, 
//                set(RegNo.p(1),O1_what.p(PLS),O1_where.p(PLS)));

        return ruleList;
    }
    public State startState() {
//        State s = State.zeroState();
//        s.set(Energy, 1);
//        return s;
        return Rule.makeState(s(energy(1)), 0);
    }
    public State goalState() {
//        //StateN s = s(RegNo.p(1), O1_what.p(Nothing),O1_where.p(PLS));
//        State s = State.wildcardState();
////        s.set(RegNo, 1);
////        s.set(O1_what, Nothing);
////        s.set(O1_where, PLS);
//        s.set(Energy, 2);
//        return s;
        return Rule.makeState(s(energy(2)), __);
//        StateN s = s(r(1), o1(Nothing,PLS));
//        // returnRule ̃CX^X𖳗gďB
//        List<Object> vec = Rule.returnRule.transStateN(s, false); 
//        return new State(vec.toArray());
    }
    public void initMap(Item[] map) {
        putItemAtRandomPosition(map, Self);
        putItemAtRandomPosition(map, Grass);
        putItemAtRandomPosition(map, Grass);
        putItemAtRandomPosition(map, Stone);
        putItemAtRandomPosition(map, Shell);
    }
}
// Default dummy task.
public static class Demo0_Dummy extends DemoCode {
    public List<RuleN> makeRules(){
        throw new StopPressed();
    }
    public State startState() { throw new Error(); }
    public State goalState() { throw new Error(); }
    public void initMap(Item[] map) { throw new Error(); }
}

//--------------------------------------------------
/**
 * Q(s,g,a) 𒊏ۉ[B
 * lxNgƃp^[}b`đIB 
 * Usage:
 *   r = new Rule(ruleN);
 *   boolean matched = r.match(vals);
 *   if (matched){
 *      // Access to the last matching results.
 *      Action a = r.getAction();
 *      State s = new State(r.getActionParam());
 *   }
 */
public static class Rule {
    /**
     * Q value of this rule.
     */
    public float q;
    /**
     * Counter for demo.
     */
    public int useCounter = 0;
    /**
     * Number of variables appeared in this Rule.
     */
    public int numVars;
    // \ȃIuWFNgB̃IuWFNgƐ΂ɏdȂȂIuWFNgB
    public static final Object UNBOUND = new Object[]{"UNBOUND"};
    // p^[}b`IɖϐɑftHglB
    // O̒lɂ̂݃}b`B
    public static final String PLS = "+".intern();
    // [LO̒l̕ێB
    public static final String KEEP = "=".intern();
    // ChJ[hBCӂ̒lƃ}b`B
    public static final String WILDCARD = "__".intern(); // Two underscores.
    // 萔 0
    public static final Integer ZERO = 0; // autoboxing 
    public Object[] env;
    public Object[] patternVec; // Concatenated pattern of s and g.
    public Action action;
    public Object[] actionPatternVec;  // Pattern of m of action C_m.
    public int idCounter = 0;
    public Map<VariableN,PatternVariable> vmap = new HashMap<>(); 
    public Rule(RuleN ruleN){
        // ruleN ƂɃp^[\zB
        List<Object> elems = transStateN(ruleN.s, WILDCARD);
        elems.addAll(transStateN(ruleN.g, WILDCARD));
        numVars = vmap.size() + 
                (int)elems.stream()
                .filter(e -> e == WILDCARD || e == PLS)
                .count();
        patternVec = elems.toArray();
        action = ruleN.a.a;
        if (ruleN.a.m == null) {
            // It is primitive action.
            actionPatternVec = null;
        } else if (action == Action.Set){
            actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
        } else {
            actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
        }
        env = new Object[vmap.size()];
        vmap = null;
    }
    public Rule(){
       // Implicitly called from ReturnRule().
    }
    // q̗Œ蒷̃[LO̗vfɕϊB
    // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
    public List<Object> transStateN(StateN state, Object defaultValue){
    	if (false){
        	// flatten test
    		Object[] a = {1,2,3};
    		Object[] b = {4,a,5,6};
    		Object[][] c = {a,{7,8},{},{9},b};
    		Object[] d = {};
    		Object[] nested = {c,d,a,b,d};
    		System.out.println("flatten test:");
    		Object[] flat = flatten(nested);
    		for (int i = 0; i < flat.length; i++) {
    			//System.out.println(i+ ":"+ flat[i]);
				System.out.print(flat[i]+ " ");
			}
			System.out.println();
    	}
    	Object[] sa = flatten(state.elems.toArray());
        Object[] arr = new Object[WM_Index.Last_WM.ordinal()];
        for (int i = 0; i < sa.length; i++) {
            Object elem = sa[i];
            if (elem instanceof ElementN) {
                ElementN e = (ElementN)elem;
                int index = e.index.ordinal();
                if (arr[index] != null) {
                    throw new Error("Duplicated Predicates: "+ elem+ " in "+ sa);
                }
                arr[index] = transArg(e.val);
            } else {
                throw new Error(elem+ " is not a Predicate : "+ sa);
            }
        }
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] == null) {
                arr[i] = defaultValue;
            }
        }
        List<Object> ret = new ArrayList<>();
        ret.addAll(Arrays.asList(arr));
        return ret;
    }
    public static Object[] flatten(Object[] nested) {
    	Vector<Object> v = new Vector<>();
    	for (int i = 0; i < nested.length; i++) {
    		if (nested[i] instanceof Object[]) {
    			Object[] a = flatten((Object[])nested[i]);
    			for (int j = 0; j < a.length; j++) {
        			v.add(a[j]);
				}
    		} else {
    			v.add(nested[i]);
    		}
		}
    	return v.toArray(); 
    }
    // q̈Bϐɓ id  PatternVariable 蓖ĂB
    public Object transArg(Object e) {
        Object re;
        if (e instanceof String) {
            e = ((String)e).intern();
        }
        if (e == WILDCARD){
            re = e;
        } else if (e instanceof VariableN){
            if (vmap.containsKey(e)){
                re = vmap.get(e);
            } else {
                re = new PatternVariable(((VariableN)e).name,
                        idCounter++);
                vmap.put((VariableN)e, (PatternVariable)re);
            }
        } else if (e instanceof Integer){
            int i = (Integer)e;
            // Accepts only small integers that can be compared with == operator.
            Lab.assertTrue( -128 <= i && i <= 127); 
            re = e;
        } else {
            re = e;
        }
        return re;
    }
    // TODO: t@N^O\Bϐ蓖ĂŏɂB
    public boolean match(Object[] vals){
        Lab.assertTrue(vals.length == patternVec.length);
        for (int i = 0; i < env.length; i++) {
            env[i] = UNBOUND;
        }
        for (int i = 0; i < vals.length; i++) {
            //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
            Lab.assertTrue(vals[i] != KEEP);
            Lab.assertTrue(patternVec[i] != KEEP);
            if (patternVec[i] == WILDCARD){
                // Do nothing.
            } else if (patternVec[i] == PLS){
                if (vals[i] == ZERO) return false;
                //if (vals[i] == WILDCARD) return false;
            } else {
                Object pval;
                if (patternVec[i] instanceof PatternVariable){
                    int id = ((PatternVariable)patternVec[i]).id;
                    if (env[id] == UNBOUND && vals[i] != WILDCARD){
                        pval = env[id] = vals[i];
                    } else {
                        pval = env[id];
                    }
                    //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                    //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                    //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                } else {
                    pval = patternVec[i];
                }
                // pval ͕ϐ蓖čς݂̃p^[̒lB
                // pval ̕ vals[i] LȂ return false B
                if (pval == WILDCARD){
                    System.out.println("this="+ this);
                    Lab.assertTrue(false);
                } else if (pval == UNBOUND){
                    // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                    Lab.assertTrue(vals[i] == WILDCARD);
                    // XXX: ̂悤ȏł悢̂낤H
                } else if (pval == PLS){
                    if (vals[i] == ZERO) return false;
                    //if (vals[i] == WILDCARD) return false;
                } else {
                    if (vals[i] != pval) return false;
                }
            }
            //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
            //for (int j = 0; j < env.length; j++) {
            //    System.out.println("env["+ j+ "]="+ env[j]);
            //}
        }
        //System.out.println("*** match ****");
        return true;
    }
    public Action getAction(){
        return action;
    }
    // p^[}b`́ul̃xNgvoB
    public Object[] getActionParam(){
        //Lab.assertTrue(action == Action.Call || action == Action.Set);
        Object[] ret = actionPatternVec.clone();
        for (int i = 0; i < ret.length; i++) {
            if (ret[i] == WILDCARD){
                ret[i] = WILDCARD;
            } else if (ret[i] instanceof PatternVariable){
                int id = ((PatternVariable)actionPatternVec[i]).id;
                if (env[id] == UNBOUND){
                    throw new Error("UNBOUND in action param");
                    //ret[i] = PLS;
                } else {
                    ret[i] = env[id];
                }
            }
        }
        return ret;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        Lab.assertTrue(patternVec.length % 2 == 0);
        int stateLength = patternVec.length / 2;
        buf.append("rule((");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[i]+ ",");
        }
        buf.append("), (");
        for (int i = 0; i < stateLength; i++) {
            buf.append(patternVec[stateLength + i]+ ",");
        }
        buf.append("), ");
        if (actionPatternVec != null){
            buf.append(action+ "(");
            for (int i = 0; i < actionPatternVec.length; i++) {
                buf.append(actionPatternVec[i]+ ",");
            }
            buf.append(")");
        } else {
            buf.append(action+ "");
        }
        buf.append(").q = "+ q);
        return buf.toString();
    }
    public static class PatternVariable {
        String name;
        int id;
        public PatternVariable(String name, int id){ 
            this.name = name; this.id = id; 
        }
        //public String toString() { return ""+ id+ ":"+ name; }
        public String toString() { return ""+ name; }
    }
    // Special instance used for Action.Return
    public static final Rule returnRule = new ReturnRule();
    // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
    //   ReturnRule ̃CX^X𖳗gĂB
    public static State makeState(StateN stateN, Object defaultValue) {
        return new State(returnRule.transStateN(stateN, defaultValue).toArray());
    }
}
public static class ReturnRule extends Rule {
    public ReturnRule(){
        action = Action.Return;
        q = 0; // Q(g,g,RET) == 0
    }
    public String toString(){
        return "rule(Return).q = "+ q;
    }
}
/**
 * Q(s,g,C_m)  s, g, m \邽߂̃f[^\B
 */
public static class State {
    public Object[] values;
    public State(Object[] values) { this.values = values; }
    public Object[] getVec(){
        return values;
    }
//    /** 
//     * ׂĂ̗vf 0  state ĕԂB 
//     */
//    public static State zeroState() {
//        Object[] v = new Object[WM_Index.Last_WM.ordinal()];
//        for (int i = 0; i < v.length; i++) {
//            v[i] = Rule.ZERO;
//        }
//        return new State(v);
//    }
//    /** 
//     * ׂĂ̗vf WILDCARD  state ĕԂB 
//     */
//    public static State wildcardState() {
//        Object[] v = new Object[WM_Index.Last_WM.ordinal()];
//        for (int i = 0; i < v.length; i++) {
//            v[i] = Rule.WILDCARD;
//        }
//        return new State(v);
//    }
    /**
     * Compares two states in order to check if the agent reaches 
     * the subgoal state x. 
     * State x may contain the special values: PLS and/or WILDCARD. 
     */
    public boolean satisfies(State x){
        Object[] xv = x.values;
        Lab.assertTrue(values.length == xv.length);
        for (int i = 0; i < xv.length; i++) {
            if (xv[i] == Rule.PLS){
                if (values[i] == Rule.ZERO) return false;
                if (values[i] == Rule.WILDCARD) return false;
            } else if (xv[i] == Rule.WILDCARD){
                // Do nothing.
            } else {
                if (values[i] != xv[i]) return false;
            }
        }
        return true;
    }
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("State(");
        for (int i = 0; i < values.length; i++) {
            buf.append(values[i].toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
    // State  n Ԗڂ̗vf𐮐ɂĕԂB̏ꍇ -1 ԂB
    public int getIntArg(int n) {
        Object x = values[n];
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        } else {
            return -1;
        }
    }
    public Object get(WM_Index index) { return values[index.ordinal()]; }
    public int getInt(WM_Index index) { 
        return getIntArg(index.ordinal()); 
    }
    public void set(WM_Index index, Object x) { values[index.ordinal()] = x; }
}


//--------------------------------------------------
public static class Main extends Lab.MainCode {
    //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
    public int maxSteps = panel.getInt("max steps", 100, 1, 10000);
    public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
    public float rewardC = panel.getFloat("R^C", -1, -10, 0);
    public int sizeX = panel.getInt("map size x", 14, 1, 100);
    public int sizeY = panel.getInt("map size Y", 10, 1, 100);
    public float vScale; 
    public lab.Lab.WTextArea qView = null;
    public DemoCode demoCode = panel.getCode("Demo", DemoCode.class);
    
    public void main() {
        World world = new World();
        world.main();
    }
    
    public class Agent {
        public State newS; // state
        public State newG; // subgoal
        public Rule newR; // rule 
        public State oldS;
        public State oldG;
        public Rule oldR;
        public State actionParamState; 
        public float reward;
        public Stack<State> stack;
        public State start, goal;
        public boolean failedFlag;
        public float stackValue;
        public State failedState;
        public World world;
        public List<Rule> rules;
        //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
        public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
        //
        public Agent(World world){
            this.world = world;
            initTable();
        }
        public void initEnv() {
        }
        public void initTable() {
            System.out.println("Task = "+ demoCode.getClass().getName());
            rules = demoCode.makeRules().stream().map(
                ruleN ->  new Rule(ruleN)
            ).collect(Collectors.toList());
            // KvȂ q lBƂ肠Ô܂܂ƂB

            //rules.forEach(r -> System.out.println(r));
            for (int i = 0; i < rules.size(); i++) {
                System.out.println(i+ ":"+ rules.get(i));
            }
        }
        public void setStartAndGoal(State s, State g){
            oldS = newS = start = s;
            oldG = newG = goal = g;
            failedState = s;
        }
        public void chooseFirstAction(){
            stack = new Stack<State>();
            chooseAction();
            oldR = newR;
        }
        // 
        public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
        public void takeAction(){
            Action action = oldR.getAction();
            failedFlag = false;

            if (panel.flag("Action log", true)) {
                StringBuffer buf = new StringBuffer();
                // indent
                for (int i = 0; i < stack.size(); i++) {
                    buf.append("  ");
                }
                buf.append(action.toString());
                //if (action == Action.Call || action == Action.Set) {
                if (actionParamState != null) {
                    buf.append('(');
                    Object[] values = actionParamState.values;
                    if (values.length > 0) {
                        buf.append(values[0].toString());
                        for (int i = 1; i < values.length; i++) {
                            buf.append(',');
                            buf.append(values[i].toString());
                        }
                    }
                    buf.append(')');
                }
                env.viewPanel.println("Action log", buf.toString());
            }

            if (action == Action.Return){
                newS = oldS;
                newG = stack.pop();
                reward = 0;
            } else if (action == Action.Call){
                newS = oldS;
                stack.push(oldG);
                newG = actionParamState;
                reward = rewardC;
            } else if (action == Action.Set){
                //newS = actionParamState;

                newS = world.observe(actionParamState, oldS);
                if (newS != null){
                    newG = oldG;
                    reward = rewardC;
                } else {
                    // fail
                    failedFlag = true;
                    stackValue = evalStack(oldG, stack);
                    newS = failedState;
                    newG = goal;
                    stack.clear();
                    reward = rewardC + failPenalty;
                }
            } else if (action == Action.Fail){
                failedFlag = true;
                stackValue = evalStack(oldG, stack);
                newS = failedState;
                newG = goal;
                stack.clear();
                reward = rewardC + failPenalty;
            } else {
                reward = rewardC;
                State newS = new State(oldS.values.clone());
                world.takePrimitiveActionAndObserve(this);
                newG = oldG;
            }
        }
        public void chooseAction(){
            if (newS.satisfies(newG)){
                newR = Rule.returnRule;
                actionParamState = null;
            } else {
                List<Rule> matched = selectMatchedRules(newS, newG);
                
//                matched.forEach(r -> {
//                    System.out.println("matched: "+ r);
//                    if (r.action == Action.Call || r.action == Action.Set) {
//                        System.out.println("  a="+ r.action);
//                        System.out.println("  m="+ new State(r.getActionParam()));
//                    }
//                });
                
                float[] q = calcRulePriorities(matched);
                if (q.length == 0){
                    throw new Error("No action selected: (news,newG)="+ 
                            newS+ ", "+ newG);
                }
                // softmax  Rule PIB
                int index = softmax(q);
                if (panel.flag("Show matched rules", false)){
                    for (int i = 0; i < matched.size(); i++) {
                        env.viewPanel.println("matched", i+ ":"+ matched.get(i));
                    }
                    for (int i = 0; i < q.length; i++) {
                        env.viewPanel.println("priority", i+ ":"+ q[i]);
                    }
                    for (int i = 0; i < probTable.length; i++) {
                        env.viewPanel.println("probTable", i+ ":"+ probTable[i]);
                    }
                }
                newR = matched.get(index);
                if (newR.actionPatternVec == null) {
                    actionParamState = null;
                } else {
                    actionParamState = new State(newR.getActionParam());
                }
            }
        }
        public List<Rule> selectMatchedRules(State s, State g){
            // s,g ̒lzB
            Object[] vals = new Object[s.values.length + g.values.length];
            for (int i = 0; i < s.values.length; i++) {
                vals[i] = s.values[i];
            }
            for (int i = 0; i < g.values.length; i++) {
                vals[i + s.values.length] = g.values[i];
            }
            //rules.forEach(r -> r.resetMatchResult());
            // (s,g) Ƀ}b`郋[IB
            // [̐ parallelStream gĂ݂B
            List<Rule> matched = rules.stream().filter(
                    r -> r.match(vals)
            ).collect(Collectors.toList());
            return matched;
        }
        public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
        public float[] calcRulePriorities(List<Rule> matched){
            float[] q = new float[matched.size()];
            for (int i = 0; i < q.length; i++) {
                Rule r = matched.get(i);
                // numVars ɉyieB^Bϐ̐Ȃ[DB
                float val = r.q - genericityPenalty * r.numVars;
                q[i] = val;
            }
            return q;
        }
        public void update() {
            if (oldR == Rule.returnRule){
                // Do nothing.
            } else if (failedFlag){
                float delta = reward + newR.q - oldR.q - stackValue;
                oldR.q += alpha * delta;
            } else {
                //q[oldS][oldA] += alpha * (reward + q[newS][newA] - q[oldS][oldA]);
                float vg; // V_g(g')
                if (oldG == newG){
                    vg = 0;
                } else {
                    vg = evalValue(oldG, newG);
                }
                //System.out.println(oldR+ ":vg="+vg);
                float delta;
                delta = reward + newR.q - oldR.q + vg;
                //System.out.println(delta);
                oldR.q += alpha * delta;
            }

            oldS = newS;
            oldG = newG;
            oldR = newR;
        }
        // Not tested enough.
        // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
        public float evalStack(State g, Stack<State> stack) {
            State ss = g;
            float ret = 0;
            for (int i = stack.size() - 1; i >= 0; i--) {
                System.out.println("Stack!:"+ stack.get(i));
                State gg = stack.get(i);
                System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
                ret += evalValue(gg, ss);
                ss = gg;
            }
            System.out.println("evalStack = "+ ret);
            return ret;
        }
        public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
        /** Returns V_g(s) */
        public float evalValue(State g, State s){
            List<Rule> matched = selectMatchedRules(s, g);
            float[] q = calcRulePriorities(matched);
            if (approxValueEvalFlag){
                // V_g(s) \approx max_a Q(s,g,a)
                int i = Lab.argmax(q); 
                return matched.get(i).q;
            } else {
                // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
                calcProbTable(q, 0, q.length);
                float val = 0;
                for (int i = 0; i < probTable.length; i++) {
                    // To avoid 0 * -Infinity = NaN
                    float value = matched.get(i).q;
                    if (value != Float.NEGATIVE_INFINITY){
                        val += probTable[i] * value;
                    }
                }
                return val; 
            }
        }
        
        
        // Softmax
        public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
        public int softmax(float[] q){ return softmax(q, 0, q.length); }
        public int softmax(float[] q, int from, int to){
            calcProbTable(q, from, to);
//            System.out.println("probTable=");
//            for (int i = 0; i < probTable.length; i++) {
//                System.out.print(probTable[i]+ ", ");
//            }
//            System.out.println();
            float r = Lab.rand();
            double sum = 0;
            for (int i = from; i < to; i++){
                sum += probTable[i]; 
                if (sum > r) {
                    Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                    return i;
                }
            }
            Lab.assertTrue(sum - 0.001f < 1);
            Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
            return to - 1;
        }
        // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
        public void calcProbTable(float[] q, int from, int to){
            if (q.length != probTable.length){
                probTable = new double[q.length];
            }
            float max = Lab.max(q);
            double total = 0;
            for (int i = from; i < to; i++){
                // To avoid overflow, subtract max.
                // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
                double val = Math.exp(beta * (q[i] - max));
                probTable[i] = val;
                total += val;
//                 System.out.println("q["+ i+ "]="+ q[i]);
//                 System.out.println("val="+ val);
            }
//            System.out.println("total="+ total);
            Lab.assertTrue(total > 0);
            for (int i = from; i < to; i++){
                probTable[i] /= total;
            }
        }
        
        public boolean achieved() {
            return stack.size() == 0 && newR.getAction() == Action.Return; 
        }
    }
    //--------------------------------------------------
    public boolean visualizeFlag;
    public class World {
        public Item[] map;
        public Agent agent;
        //
        public World(){
        }
        public void main(){
            agent = new Agent(this);
            {
                State start = demoCode.startState();
                State goal = demoCode.goalState();
                System.out.println("Start = "+ start);
                System.out.println("Goal = "+ goal);
            }
            int counter = 0;
            for (;;){
                visualizeFlag = panel.flag("visualizeFlag", true);
                panel.speedControl("Episode loop", 0);
                initMap();
//                State start = new State(new Object[]{0, 0,0, 0,0});
//                State goal = new State(new Object[]{1,Nothing,Rule.PLS,
//                        Rule.WILDCARD,Rule.WILDCARD});
                State start = demoCode.startState();
                State goal = demoCode.goalState();
                if (panel.flag("Print start and goal", false)) {
                	System.out.println("Start = "+ start);
                	System.out.println("Goal = "+ goal);
                }

                agent.setStartAndGoal(start, goal);
                agent.chooseFirstAction();
                int steps = 0;
                while (! agent.oldS.satisfies(goal) && steps++ < maxSteps){
                    env.viewPanel.print1("counter=", ""+ counter++);
                    if (visualizeFlag){
                        panel.speedControl("Step loop", 100);
                        visualizeMap();
                        visualizeAgentState();
                    }
                    
                    agent.takeAction();
                    agent.chooseAction();
                    agent.update();

                }
                if (visualizeFlag){
                    visualizeMap();
                    visualizeAgentState();
                }
            }
        }
        public void visualizeAgentState(){
            {
                String goalsLabel = "Goals";
                env.viewPanel.setText(goalsLabel, ""); // Clear text.
                for (int i = 0; i < agent.stack.size(); i++) {
                    // Print elements from bottom to top.
                    env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
                }
                env.viewPanel.println(goalsLabel, ""+ agent.oldG);
            }
            {
                String logLabel = "Log";
                env.viewPanel.println(logLabel, "---");
                String s = "stack size="+ agent.stack.size()+ ":";
                for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                    // Add elements from top to bottom.
                    s += agent.stack.get(i)+ ", ";
                }
                env.viewPanel.println(logLabel, s);
                env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                        ", "+ agent.oldG);
                env.viewPanel.println(logLabel, ""+ agent.oldR);
            }
            //env.viewPanel.plotWithFixedY("rule.q", 0, -10, 0);// dummy
            env.viewPanel.scatterPlotFixedY("rule.q", 0, 0, -10, 0);// dummy
            env.viewPanel.resetGraphData("rule.q");
            agent.rules.forEach(r -> {
                env.viewPanel.plot("rule.q", r.q);
            });
        }
        
        
        public void initMap(){
            map = new Item[sizeX * sizeY];
            for (int x = 0; x < map.length; x++) {
                map[x] = Space;
            }
            // 
            // x=0 or y=0 ̍WɕuȂ悤ɂ邽߂ɕǂĂB
            for (int x = 0; x < sizeX; x++) {
                map[x * sizeY + 0] = Wall; 
            }
            for (int y = 0; y < sizeY; y++) {
                map[y] = Wall;
            }
            demoCode.initMap(map);
//            if (visualizeFlag){
//                env.viewPanel.paint("Map", mapPainter);
//            }
      }
        public void visualizeMap(){
            env.viewPanel.paint("Map", mapPainter);
        }
        public MapPainter mapPainter = new MapPainter();
        public int charSize = panel.getInt("charSize", 24, 1, 40);
        public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
        //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
        public class MapPainter extends Lab.Code implements Lab.Painter {
            public Dimension getSize(){
                return new Dimension(charSize * (sizeX + 1) + 1, 
                        charSize * (sizeY + 1) + 2);
            }
            int counter = 0;
            public void paintComponent(Graphics g, MouseEvent lastEvent) {
                // LȍW x, y >= 1 ƂB 
                // W (1,1) ƂB
                g.setFont(f);
                for (int y = 1; y < sizeY; y++) {
                    for (int x = 1; x < sizeX; x++) {
                        String str = map[x * sizeY + y].code;
                        g.setColor(Color.BLACK);
                        g.drawString(str, //Character.toString(c),
                                    x * charSize, (sizeY - y + 1) * charSize);
                    }
                }
                int selfX = 0, selfY = 0;
                // Find self
                for (int y = 1; y < sizeY; y++) {
                    for (int x = 1; x < sizeX; x++) {
                        if (map[x * sizeY + y] == Self) {
                            selfX = x; selfY = y;
                        }
                    }
                }
                Lab.assertTrue(selfX != 0 && selfY != 0);

                int where1 = agent.newS.getInt(O1_where);
                Lab.assertTrue(where1 != -1);
                int x1 =  where1 / sizeY;
                int y1 =  where1 % sizeY;
                int where2 = agent.newS.getInt(O2_where);
                Lab.assertTrue(where2 != -1);
                int x2 =  where2 / sizeY;
                int y2 =  where2 % sizeY;
                
                if (x1 != 0 && y1 != 0) {
                    g.setColor(Color.GREEN);
                    g.drawRect(x1 * charSize, (sizeY - y1 - 0) * charSize,
                            charSize - 2, charSize - 2);
                    g.drawString("1", x1 * charSize, (sizeY - y1 - 0) * charSize);
                    
                    g.drawLine(selfX * charSize + charSize/2,
                            (sizeY - selfY) * charSize + charSize/2,
                            x1 * charSize + charSize/2,
                            (sizeY - y1) * charSize + charSize/2);
                }
                if (x2 != 0 && y2 != 0) {
                    g.setColor(Color.RED);
                    g.drawRect(x2 * charSize + 2, (sizeY - y2 - 0) * charSize + 2,
                            charSize - 2, charSize - 2);
                    g.drawString("2", x2 * charSize, (sizeY - y2 - 0) * charSize);
                    
                    g.drawLine(selfX * charSize + charSize/2,
                            (sizeY - selfY) * charSize + charSize/2,
                            x2 * charSize + charSize/2,
                            (sizeY - y2) * charSize + charSize/2);
                }
                
                // O2  O1 ֍B
//                if (agent.newR.action == MoveO2toO1
//                        && x1 != 0 && y1 != 0 && x2 != 0 && y2 != 0) {
//                    g.setColor(Color.BLACK);
//                    g.drawLine(x1 * charSize + charSize/2,
//                            (sizeY - y1) * charSize + charSize/2,
//                            x2 * charSize + charSize/2,
//                            (sizeY - y2) * charSize + charSize/2);
//
//                }
            }
        }
        public Integer stateElemToInteger(Object elem) {
            if (elem instanceof Integer) {
                return (Integer)elem;
            } else {
                return null;
            }
        }
        /**
         * ̎ state ̒lA\Ɗϑ𓥂܂Č肵ԂB
         * \ƊϑĂꍇ fail \l null ԂB
         */
        public State observe(State setArg, State oldS) {
            Lab.assertTrue(setArg.get(RegNo) instanceof Integer);
            Object[] prior = new Object[WM_Index.Last_WM.ordinal()];
            Object[] likelihood = new Object[WM_Index.Last_WM.ordinal()];
            int r = setArg.getInt(RegNo);
            for (int i = 0; i < prior.length; i++) {
                if (setArg.values[i] == Rule.KEEP) {
                    prior[i] = oldS.values[i];
                } else {
                    prior[i] = setArg.values[i];
                }
            }
            for (int i = 0; i < likelihood.length; i++) {
                likelihood[i] = null;
            }
            // }bvォ畨̂PTB
            int x = findObjectFromMap();
            //int px = pos[0], py = pos[1];
            Lab.assertTrue(x != -1); // ̃fł͕K̂ƉB
            Object o = map[x];
            //int x =  px * map.length + py;

            if (r == 1) {
                likelihood[O1_what.ordinal()] = o;
                likelihood[O1_where.ordinal()] = x;
            } else if (r == 2) {
                likelihood[O2_what.ordinal()] = o;
                likelihood[O2_where.ordinal()] = x;
            } else {
                Lab.assertTrue(false);
            }
            
            Object[] belief = new Object[WM_Index.Last_WM.ordinal()];
            // \ prior Ɗϑ likelihood ̖oꂽ fail B
            for (int i = 0; i < belief.length; i++) {
                if (prior[i] == Rule.WILDCARD) {
                    belief[i] = likelihood[i];
                } else if (prior[i] == Rule.PLS) {
                    if (likelihood[i] == Rule.ZERO) {
                         return null; // fail
                    } else {
                        belief[i] = likelihood[i];
                    }
                } else {
                    if (likelihood[i] == null) {
                        belief[i] = prior[i];
                    } else if (likelihood[i] == prior[i]) {
                        belief[i] = prior[i];
                    } else {
                        // likelihood[i] != prior[i]
                        return null; // fail
                    }
                }
                Lab.assertTrue(belief[i] != null);
            }

            return new State(belief);
        }

        /**
         * }bv̒烉_ɂP̂IňʒuԂB 
         */
        public int findObjectFromMap() {
            // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
            // }bv̂̐̕𐔂B
            int c = 0;
            for (int x = 1; x < sizeX; x++) {
                for (int y = 1; y < sizeY; y++) {
                    if (map[x * sizeY + y] != Space) {
                        c++;
                    }
                }
            }
            // _ r Ԗڂ̂̕IԁB
            int r = Lab.irand(c);
            c = 0;
            for (int x = 1; x < sizeX; x++) {
                for (int y = 1; y < sizeY; y++) {
                    if (map[x * sizeY + y] != Space) {
                        if (c++ == r) return x * sizeY + y;
                    }
                }
            }
            return -1; // Not found.
        }
        /**
         * }bv̒w肳ꂽ̂PTďꏊԂB
         * TB 
         */
        public int findItemFromMap(Item item) {
            for (int i = 0; i < map.length; i++) {
                if (map[i] == item) return i;
            }
            throw new Error("findItemFromMap: not found "+ item);
        }
        
        /**
         * [LO newS ̂̕P̒lɍ킹čXVB
         * ̂Q̒l 0 ƂB
         * ꕔ̑ΊOANV̎sɌĂ΂B
         * TODO: ̂̈ړgbLO@\Ă悢B
         */
        public void observeO1(Agent a) {
            int x = a.newS.getInt(O1_where);
            if (x == 0) return;
            Object obj = map[x];
            a.newS.set(RegNo, 1);
            a.newS.set(O1_what, obj);
            a.newS.set(O1_where, x);
            a.newS.set(O2_what, 0);
            a.newS.set(O2_where, 0);
        }

        /** ANV a.oldR sA a.newS ϑB
         * Vꍇ a.reward ̒lɉZB
         */
        public void takePrimitiveActionAndObserve(Agent a) {
            Action action = a.oldR.getAction();
            switch (action) {
            case EatO1: {
                // O1 HׂȂ炻 Leftovers ɕϊB
                // W̉ĂȂƂ́HƂ肠G[B
                // HׂȂƂ́HƂ肠G[B
                int x = a.newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else {
                    Object target = map[x];
                    if (target == Nut) {
                        map[x] = Space;
                        a.newS.set(Energy, a.newS.getInt(Energy) + 1);
                    } else {
                        Lab.assertTrue(false);
                    }
                }
                observeO1(a);
            } break;

            case MoveO2toO1: {
                // O2  O1 ̏ꏊɈړAO1, O2 ͌`EʒuωB
                int x1 = a.newS.getInt(O1_where);
                int x2 = a.newS.getInt(O2_where);
                if (x1 == -1 || x2 == -1) {
                    Lab.assertTrue(false);
                } else if (x1 == 0 || x2 == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = map[x1];
                    Object item = map[x2];
                    if (target == Shell && item == Stone) {
                        map[x1] = Nut;
                        map[x2] = Space;
                    } else {
                        // Fail ׂH
                        Lab.assertTrue(false);
                    }
                    observeO1(a);
                }
            } break;

            case MoveSelfAndEatO1: {
                // O1 HׂȂ玩g O1 ɈړĐHׂB
                int selfX = findItemFromMap(Self);

                int x = a.newS.getInt(O1_where);
                if (x == -1) {
                    Lab.assertTrue(false);
                } else if (x == 0) {
                    // Fail ׂH
                    Lab.assertTrue(false);
                } else {
                    Object target = map[x];
                    if (target == Nut) {
                        map[x] = Self;
                        map[selfX] = Space;
                        a.newS.set(Energy, a.newS.getInt(Energy) + 1);
                    } else {
                        Lab.assertTrue(false);
                    }
                }
                observeO1(a);
            } break;
            
            case Say: {
                Verb verb = (Verb)agent.actionParamState.get(S_verb);
                Object obj = agent.actionParamState.get(S_object);
                switch (verb) {
                case WhereIs : {
                    // obj Tďu O1 ɃZbgB
//                    int ox = 0, oy = 0;
//                    for (int y = 1; y < sizeY; y++) {
//                        for (int x = 1; x < sizeX; x++) {
//                            if (map[x][y] == obj) {
//                                ox = x; oy = y;
//                            }
//                        }
//                    }
//                    Lab.assertTrue(ox != 0 && oy != 0);
//                    int x = ox * map.length + oy;
                    Lab.assertTrue(obj instanceof Item);
                    int x = findItemFromMap((Item)obj);  
                    a.newS.set(RegNo, 1);
                    a.newS.set(O1_what, obj);
                    a.newS.set(O1_where, x);
                } break;
                
                case GiveMe : {
                    // }bv obj uȀꏊ O1 ɃZbgB
                    Lab.assertTrue(obj instanceof Item);
                    DemoCode.putItemAtRandomPosition(map, (Item)obj);
                    int x = findItemFromMap((Item)obj);
                    a.newS.set(RegNo, 1);
                    a.newS.set(O1_what, obj);
                    a.newS.set(O1_where, x);
                } break;
                
                case HereIs : {
                    // sentence(HereIs,Nut) ƔbĂ
                    // O1 ̏ꏊ Nut  Thanks ƕԎB
                    // Nut łȂꍇ͉ȂB
                    // (ݒ̃^XNŗpƉB)
                    int o1 = a.newS.getInt(O1_what);
                    int x1 = a.newS.getInt(O1_where);
                    Item item = map[x1];
                    if (obj == Nut && obj == item) {
                        a.newS.set(S_verb, Verb.Thanks);
                        a.newS.set(S_object, 0);
                    }
                } break;

                default:{
                    Lab.assertTrue(false);
                } break;
                }
                
            } break;

            default: {
                Lab.assertTrue(false);
            } break;
            }
        }
    }
}
}
