//Copyright (c) 2024 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*


ꐙTu,l,|,쐒,cG,
GȒm\𐶂ݏoɌ܂Ŋȑfꂽ̐݌v,
28 lHm\w ėplHm\(SIG-AGI), 2024.


TODO: 
E AzL͖̎ߋ̃R[hėpĂB蒼ׂB
E Gs\[hL̑zN͍łV̂I邪A_ɂׂB
E 錾ILEGs\[hL̃p^[}b`ASY̏ڍ׎dl悭ĕׂB

*/


package tmm1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v13.PrimitiveAction.*;
import static tmm1.TMM3v13.WObj.*;
import static tmm1.TMM3v13.Conj.*;
import static tmm1.TMM3v13.Time.*;
import static tmm1.TMM3v13.Room.*;
import static tmm1.TMM3v13.Verb.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;

public class TMM3v13 {
public static void main(String[] args) {
  Lab.addSelectableClass(TMM3v13.class);
  System.out.println(Lab.selectableClasses + "");

  LabCode labCode = new LabCode();
  labCode.main(AbstractMainCode.class);
}

//For debug.
public static void printArray(String s, Object[] a) {
  System.out.print(s+ ": ");
  for (int i = 0; i < a.length; i++) {
      System.out.print(a[i]+ ",");
  }
  System.out.println();
}

/**
* Primitive actions 
*/
public static enum PrimitiveAction {
  SetWithCost1,
  SetWithCost2,
  SetWithCost3,
  SetWithCost4,
  //
//  EatO1,
  Eat,
//  ApplyO1toO2,
  Apply,
  GoDir,
  GoToRoom,
  Bring,
  //
  RecogRoom,
  FindItem,
  FindSecondItem,
  Try,
  Call,
  Return,
  Exit,
  Set,
  CallM,
  SetM,
  Recall,
  SayIt,
  Listen,
  //
  NewSituation,
  //
  NOP,
  Fail,
}
/**
*  Working memory layout definition
* 
*     |     A     |     E     |
*      ^ WmIndex.A.head   
*                  ^ WmIndex.E.head   
*      <----------> WmIndex.A.size
*      <----------------------> WmIndex.size
*/
public static class WmIndex {
  public static final RegisterIndex A;
  //public static final RegisterIndex B;
  public static final RegisterIndex E;
  public static final int size;
  static {
      int i = 0;
      A = new RegisterIndex(i); i += A.size;
      //B = new RegisterIndex(i); i += B.size;
      E = new RegisterIndex(i); i += E.size;
      size = i;
  }
  public static boolean printRawFlag = false; /** WX^̒l𐶂̃xNg܂ print */
  public static final String valuesToString(Object[] values) {
      if (values.length == WmIndex.size) {
          Object e = filledObject(values, 0, values.length);
          if (e != null) {
              return "w("+ e+ ")";
          } else {
              return "w("+ WmIndex.A.valuesToString(values, "a")+ " "+
                      WmIndex.E.valuesToString(values, "e")+ " "+
                      ")";
          }
      } else if (values.length == WmIndex.A.size) {
          return WmIndex.A.valuesToString(values, "r");
      } else if (values.length == WmIndex.size * 2) {
          Object[] s = new Object[WmIndex.size];
          Object[] g = new Object[WmIndex.size];
          for (int i = 0; i < s.length; i++) {
              s[i] = values[i];
              g[i] = values[i + WmIndex.size];
          }
          return "s("+ WmIndex.valuesToString(s)+ ") g("+ WmIndex.valuesToString(g)+ ")"; 
      } else {
          throw new Error("valuesToString: "+ values);
      }
  }
  public static final Object filledObject(Object[] values, int start, int end) {
      Object e = values[start];
      for (int i = start+1; i < end; i++) {
          if (values[i] != e) return null;
      }
      return e;
  }
  public static final String valuesToString(Object[] values, int start, int end) {
      Object e = WmIndex.filledObject(values, start, end);
      if (e != null) {
          return e.toString();
      } else {
          StringBuffer buf = new StringBuffer();
          buf.append(values[start]);
          for (int i = start+1; i < end; i++) {
              buf.append(' ');
              buf.append(values[i]);
          }
          return buf.toString();
      }
  }
}
public static class RegisterIndex {
  public final int head;
  public final int headerSize;
  public final int size;
  public final int EID; // Currently not used.
  public final int Conj;
  public ClauseIndex C1; 
  public ClauseIndex C2; 
  public ClauseIndex C3; 
  public RegisterIndex(int offset) {
      head = offset;
      int i = 0;
      EID = 0; // dummy //EID = offset + i;  i++;
      Conj = offset + i;  i++;
      headerSize = i;
      C1 = new ClauseIndex(offset + i); i += C1.size;
      C2 = new ClauseIndex(offset + i); i += C2.size;
      C3 = new ClauseIndex(offset + i); i += C3.size;
      size = i;
  }
  public String valuesToString(Object[] values, String regName) {
      Object e = WmIndex.filledObject(values, head, head+size);
      if (e != null) {
          return regName+ "("+ e+ ")";
      } else {
          return regName+ "("+
                  values[Conj]+ " "+
                  this.C1.valuesToString(values, "c1")+ " "+
                  this.C2.valuesToString(values, "c2")+ " "+
                  this.C3.valuesToString(values, "c3")+
                  ")";
      }
  }
}
public static class ClauseIndex {
  //public final int When, Where, Who, DoWhat, O1, O2;
  // Situation |= <<Verv, Subject, Object1, Object2, Location, Time, Polarity>>>
  public final int Situation, V, S, O1, O2, L, T, P;
  public final int head;
  public final int size;
  public ClauseIndex(int offset) {
      head = offset;
      int i = 0;
      Situation  = offset + i++;
      V  = offset + i++;
      S  = offset + i++;
      O1 = offset + i++;
      O2 = offset + i++;
      L  = offset + i++;
      T  = offset + i++; 
      P  = offset + i++; 
      size = i;
  }
  public String valuesToString(Object[] values, String name) {
      return name+ "("+ WmIndex.valuesToString(values, head, head+size)+ ")";
  }
}

public static class Situation {
  public static Situation Usual = new Situation("Usual", null);  // Top of situation hierarchy. Default situation.
  public static Situation Actual = new Situation("Actual", Usual); // The current actual situation.
  public String name;
  public Situation parent;
  public Situation(String name, Situation parent) {
      this.name = name;
      this.parent = parent;
  }
  public String toString() {
      return name;
  }
}
public static class TempSituation extends Situation {
  public static int idCounter = 0;
  public int id;
  public TempSituation(Situation parent) {
      super("TempSitu"+ idCounter, parent);
      this.id = idCounter++;
  }
}
//TODO: ΎɂׂB
public static enum Time {
  Today,
  Yesterday,
  Anytime,
  Now,
}
/**
 * G[WFg̕ 
 */
public static class WObj {
    /** Interned String */
    public String name;
    public WObj(String name) {
        this.name = name.intern();
    }
//  public static WObj Alice = new WObj("Alice");    // The fist generic agent.
//  public static WObj Bob = new WObj("Bob");        // The second generic agent.
//  public static WObj Carol = new WObj("Carol");    // The third generic agent.
  public static WObj Stone = new WObj("Stone");
  public static WObj Nutshell = new WObj("Nutshell");
  public static WObj Nut = new WObj("Nut");
  public static WObj Grass = new WObj("Grass");

  public static WObj Box = new WObj("Box");
  public static WObj Key = new WObj("Key"); 
  public static WObj Gold = new WObj("Gold"); 
  
  public static WObj Scissors = new WObj("Scissors");
  public static WObj Nothing = new WObj("Nothing");
  public static WObj Wh = new WObj("Wh");
  public static WObj Space = new WObj("Space");
  public String toString() {
      return name;
  }
}
/** p~\ */
public static class Item extends WObj {
    public Item(String name){
        super(name);
    }
}
public static class Room extends WObj {
    public Room(String name) {
        super(name);
    }
//    public static String North = "North".intern();
//    public static String East = "East".intern();
//    public static String West = "West".intern();
//    public static String South = "South".intern();
//    public static String[] directions = new String[]{North, East, West, South}; 
    //
    public static Room Room1 = new Room("Room1");
    public static Room Room2 = new Room("Room2");
    public static Room Room3 = new Room("Room3");
    public static Room Room4 = new Room("Room4");
    public static Room Room5 = new Room("Room5");

    public static Room Here = new Room("Here");
    public static Room Anywhere = new Room("Anywhere");
    public String toString() {
        return name;
    }
}

//public static class Box extends WObj {
//  public String name;
//  public Object content = null;
//  public Box(String name) { super(name); }
//  public String toString() { return name+ "("+ content+ ")"; }
//  public static final Box Box1 = new Box("Box1"); 
//  public static final Box Box2 = new Box("Box2"); 
//  public static final Box Box3 = new Box("Box3"); 
//}
//public static class Key extends WObj {
//  public String name;
//  public Key(String name)  { super(name); }
//  public String toString() { return name; }
//  public static final Key Key1 = new Key("Key1"); 
//  public static final Key Key2 = new Key("Key2"); 
//  public static final Key Key3 = new Key("Key3"); 
//}

public static enum Conj {
  Simple,
  SaysThat,
  And,
  While,
  If,
  ThatO1,
  ThatO2,
  Achieves,
  Causes,  
  //
  PbyC,
  Case,
}
public static enum Verb {
  Is,
  Has,
  Ate,
  CanNotEat,
//  WantToTakeO1ToO2,
//  WantToApplyO1ToO2,
  AppliedO1ToO2,
  CanNotApply,
  IsAwareOf,
  IsAwareOfNo, // ꎞI
  FindsNothing,
  Thanks,
  Knows,
  Exists,
  LookingAt,
  LookingAt2,
  DoesNotExist, // ꎞI
  WantsToSayTo,
  SaidTo,
  CameFrom,
  BroughtO1FromO2,
  //
  SuperSituation,
  Contradiction,
  //
  TaskCompleted,
  Failed,
}

//Abstract syntax nodes for DSL
public static class ClauseN {
  public Object situation, v, s, o1, o2, l, t, p; 
  public ClauseN(Object situation,Object v,Object s,Object o1,Object o2,Object l,Object t,Object p) {
      this.situation = situation;
      this.v = v;
      this.s = s;
      this.o1 = o1;
      this.o2 = o2;
      this.l = l;
      this.t = t;
      this.p = p;
  }
  public Object[] transN() {
      return new Object[] { situation, v, s, o1, o2, l, t, p};
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("c(");
      buf.append(""+ situation); buf.append(", ");
      buf.append(""+ v); buf.append(", ");
      buf.append(""+ s); buf.append(", ");
      buf.append(""+ o1); buf.append(", ");
      buf.append(""+ o2); buf.append(", ");
      buf.append(""+ l); buf.append(", ");
      buf.append(""+ t); buf.append(", ");
      buf.append(""+ p);
      buf.append(")");
      return buf.toString();
  }
}
public static class RegisterN {
  public String regName;
  public Object conj;
  public ClauseN c1, c2, c3; 
  public RegisterN(String regName, Object conj, ClauseN c1, ClauseN c2) {
      this.regName = regName; this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = null;
  }
  public RegisterN(String regName, Object conj, ClauseN c1, ClauseN c2, ClauseN c3) {
      this.regName = regName; this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = c3;
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { 
              conj == null ? 0 : conj, 
                      c1 == null ? zeroV() : c1.transN(), 
                              c2 == null ? zeroV() : c2.transN(), 
                                      c3 == null ? zeroV() : c3.transN() 
      };
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append(regName+ "(");
      buf.append(""+ conj); buf.append(", ");
      buf.append(""+ c1); buf.append(", ");
      buf.append(""+ c2);
      buf.append(")");
      return buf.toString();
  }
  public Object[] zeroV() {
      Object[] ret = new Object[WmIndex.A.C1.size]; // Assumes all clauses have the same length.
      for (int i = 0; i < ret.length; i++) {
          ret[i] = 0;
      }
      return ret;
  }
}
public static class StateN {
  public RegisterN a, b, e;
  public StateN(RegisterN a, RegisterN b, RegisterN e) { 
      this.a = a; this.b = b; this.e = e; 
  }
  public Object[] transN(Object defaultValue) {
      return new Object[] { 
              a == null ? defaultV(defaultValue) : a.transN(defaultValue),
                      //b == null ? defaultV(defaultValue) : b.transN(defaultValue),
                      e == null ? defaultV(defaultValue) : e.transN(defaultValue),
      };    
  }
  public Object[] defaultV(Object defaultValue) {
      Object[] ret = new Object[WmIndex.A.size]; // Normal register.
      for (int i = 0; i < ret.length; i++) {
          ret[i] = defaultValue;
      }
      return ret;
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      buf.append("s(");
      buf.append(""+ a); buf.append(", ");
      buf.append(""+ b); buf.append(", ");
      buf.append(""+ e); buf.append(", ");
      buf.append(")");
      return buf.toString();
  }
}
public static class RuleN {
  public String name;
  public StateN s, g;
  public ActionN a;
  public RuleN(String name, StateN s, StateN g, ActionN a){ 
      this.name = name; this.s = s; this.g = g; this.a = a;
  }
  public String toString(){
      return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
  }
}
public static class ActionN {
  public PrimitiveAction a;
  public StateN m; // Arguments of the primitive action.
  public ActionN(PrimitiveAction a, StateN m){ 
      this.a = a; this.m = m;
  }
  public String toString(){
      if (m == null){
          return a.toString();
      } else {
          return a.toString()+ "("+ m+ ")";
      }
  }
}
/**
* pattern variable 
*/
public static class VariableN {
  public String name;
  public VariableN(String name){ this.name = name; }
}
//public static class UnionN {
//public StateN[] args;
//public UnionN(StateN... args){ this.args = args; }
//}

//--------------------------------------------------
/**
* Q(s,g,a) 𒊏ۉ[B
* lxNgƃp^[}b`đIB 
* Usage:
*   r = new Rule(ruleN);
*   boolean matched = r.match(vals);
*   if (matched){
*      // Access to the last matching results.
*      Action a = r.getAction();
*      State s = new State(r.getActionParam());
*   }
*/
public static class Rule {
  /**
   * Q value of this rule.
   */
  public float q = 0;
  /**
   * Base value for the subroutine called by this rule.
   */
  public float base = 0;
  
  // for Monte Carlo Learning
  public float monteQ = 0;
  public float monteBase = 0;
  
  /**
   *  Rule name. Used for debug.
   */
  public String name;
  /**
   * Counter for demo.
   */
  public int useCounter = 0;
  /**
   * Number of variables, WILDCARD, and PLS appeared in this Rule.
   */
  public int numVars;
  // \ȃIuWFNgB
  public static final String UNBOUND = "__UNBOUND__";
  // p^[}b`IɖϐɑftHglB
  // O̒lɂ̂݃}b`B
  public static final String PLS = "PLS".intern();
  // [LO̒l̕ێB
  public static final String KEEP = "=".intern();
  // ChJ[hBCӂ̒lƃ}b`B
  public static final String WILDCARD = "__".intern(); // Two underscores.
  // 萔 0
  public static final Integer ZERO = 0; 
  public Object[] env;
  public Object[] patternVec; // Concatenated pattern of s and g.
  public PrimitiveAction action;
  public Object[] actionPatternVec;  // Pattern of m of action C_m.
  public int idCounter = 0;
  public Map<VariableN,PatternVariable> vmap = new HashMap<>();
  public RuleN ruleN; // for debug
  public Rule(RuleN ruleN){
      // ruleN ƂɃp^[\zB
      this.name = ruleN.name;
      this.ruleN = ruleN;
      List<Object> elems = transStateN(ruleN.s, WILDCARD);
      elems.addAll(transStateN(ruleN.g, WILDCARD));
      numVars = vmap.size() + 
              (int)elems.stream()
      .filter(e -> e == WILDCARD || e == PLS)
      .count();
      patternVec = elems.toArray();
      action = ruleN.a.a;
      if (ruleN.a.m == null) {
          // It is primitive action.
          actionPatternVec = null;
      } else if (action == PrimitiveAction.Set || action == PrimitiveAction.SetM){
          actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.SetA){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.SetB){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          //    } else if (action == PrimitiveAction.Add){
          //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
      } else {
          actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
      }
      env = new Object[vmap.size()];
      vmap = null;
  }
  public Rule(){
      // Implicitly called from ReturnRule().
  }
  // q̗Œ蒷̃[LO̗vfɕϊB
  // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
  public List<Object> transStateN(StateN state, Object defaultValue){
      Object[] sa = flatten(state.transN(defaultValue));

      //    System.out.println("transStateN:");
      //    System.out.println("state="+ state);
      //    printArray("state.transN", state.transN(defaultValue));
      //    printArray("state.transN 0", (Object[])(state.transN(defaultValue))[0]);
      //    printArray("sa", sa);
      //    System.out.println("sa.length:"+ sa.length);
      //    System.out.println("wm size: "+ WmIndex.size);
      Lab.assertTrue(sa.length == WmIndex.size);

      Object[] arr = new Object[WmIndex.size];
      for (int i = 0; i < sa.length; i++) {
          Lab.assertTrue(sa[i] != null);
          arr[i] = transArg(sa[i]);
      }
      List<Object> ret = new ArrayList<>();
      ret.addAll(Arrays.asList(arr));
      if (false) {
          System.out.println("transStateN: default="+ defaultValue+ " : "+ state);
          System.out.println(" "+ ret);
      }
      return ret;
  }
  private static void flattenTest() {
      Object[] a = {1,2,3};
      Object[] b = {4,a,5,6};
      Object[][] c = {a,{7,8},{},{9},b};
      Object[] d = {};
      Object[] nested = {c,d,a,b,d};
      System.out.println("flatten test:");
      Object[] flat = flatten(nested);
      for (int i = 0; i < flat.length; i++) {
          //System.out.println(i+ ":"+ flat[i]);
          System.out.print(flat[i]+ " ");
      }
      System.out.println();
  }
  public static Object[] flatten(Object[] nested) {
      Vector<Object> v = new Vector<>();
      for (int i = 0; i < nested.length; i++) {
          if (nested[i] instanceof Object[]) {
              Object[] a = flatten((Object[])nested[i]);
              for (int j = 0; j < a.length; j++) {
                  v.add(a[j]);
              }
          } else {
              v.add(nested[i]);
          }
      }
      return v.toArray(); 
  }
  // q̈Bϐɓ id  PatternVariable 蓖ĂB
  public Object transArg(Object e) {
      Object re;
      if (e instanceof String) {
          e = ((String)e).intern();
      }
      if (e == WILDCARD){
          re = e;
      } else if (e instanceof VariableN){
          if (vmap.containsKey(e)){
              re = vmap.get(e);
          } else {
              re = new PatternVariable(((VariableN)e).name,
                      idCounter++);
              vmap.put((VariableN)e, (PatternVariable)re);
          }
      } else if (e instanceof Integer){
          int i = (Integer)e;
          // Accepts only small integers that can be compared with == operator.
          Lab.assertTrue( -128 <= i && i <= 127); 
          re = e;
      } else {
          re = e;
      }
      return re;
  }
  // TODO: t@N^O\Bϐ蓖ĂŏɂB
  public boolean ruleMatch(Object[] vals){
      Lab.assertTrue(vals.length == patternVec.length);
      for (int i = 0; i < env.length; i++) {
          env[i] = UNBOUND;
      }
      for (int i = 0; i < vals.length; i++) {
          //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
          Lab.assertTrue(vals[i] != KEEP);
          Lab.assertTrue(patternVec[i] != KEEP);
          if (patternVec[i] == WILDCARD){
              // Do nothing.
          } else if (patternVec[i] == PLS){
              if (vals[i] == ZERO) return false;
              //if (vals[i] == WILDCARD) return false;
          } else {
              Object pval;
              if (patternVec[i] instanceof PatternVariable){
                  int id = ((PatternVariable)patternVec[i]).id;
                  if (env[id] == UNBOUND && vals[i] != WILDCARD){
                      pval = env[id] = vals[i];
                  } else {
                      pval = env[id];
                  }
                  //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                  //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                  //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
              } else {
                  pval = patternVec[i];
              }
              // pval ͕ϐ蓖čς݂̃p^[̒lB
              // pval ̕ vals[i] LȂ return false B
              if (pval == WILDCARD){
                  System.out.println("this="+ this);
                  Lab.assertTrue(false);
              } else if (pval == UNBOUND){
                  // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                  Lab.assertTrue(vals[i] == WILDCARD);
                  // XXX: ̂悤ȏł悢̂낤H
              } else if (pval == PLS){
                  if (vals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else {
                  if (vals[i] != pval) return false;
              }
          }
          //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
          //for (int j = 0; j < env.length; j++) {
          //    System.out.println("env["+ j+ "]="+ env[j]);
          //}
      }
      //System.out.println("*** match ****");
      return true;
  }
  // ӖLp̃p^[}b`\bhB
  // ܂ŎbŎBdl͍B
  public boolean knowledgeMatch(Object[] qvals){
      Lab.assertTrue(qvals.length == patternVec.length);
      for (int i = 0; i < env.length; i++) {
          env[i] = UNBOUND;
      }
      for (int i = 0; i < qvals.length; i++) {
          //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
          Lab.assertTrue(qvals[i] != KEEP);
          Lab.assertTrue(patternVec[i] != KEEP);
          if (patternVec[i] == WILDCARD){
              //Lab.assertTrue(false); // not implemented
              // Not implemented and do nothing so far.
          } else if (patternVec[i] == PLS){
              Lab.assertTrue(false); // not implemented
              if (qvals[i] == ZERO) return false;
              //if (vals[i] == WILDCARD) return false;
          } else if (patternVec[i] == ZERO){
              //Lab.assertTrue(false); // not implemented
              // Not implemented and do nothing so far.
          } else {
              Object pval;
              if (patternVec[i] instanceof PatternVariable){
                  int id = ((PatternVariable)patternVec[i]).id;
                  if (env[id] == UNBOUND && qvals[i] != WILDCARD){
                      pval = env[id] = qvals[i];
                  } else {
                      pval = env[id];
                  }
                  //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                  //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                  //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
              } else {
                  pval = patternVec[i];
              }
              // pval ͕ϐ蓖čς݂̃p^[̒lB
              // pval ̕ vals[i] LȂ return false B
              if (pval == WILDCARD){
                  System.out.println("this="+ this);
                  Lab.assertTrue(false);
              } else if (pval == UNBOUND){
                  // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                  Lab.assertTrue(qvals[i] == WILDCARD);
                  // XXX: ̂悤ȏł悢̂낤H
              } else if (pval == PLS){
                  if (qvals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else {
                  // p^[ʂ̒lANG 0, WILDCARD, PLS ̏ꍇ̓}b`B
                  if (qvals[i] == ZERO || qvals[i] == WILDCARD || qvals[i] == PLS) {
                      // Do nothing.
                  } else {
                      if (qvals[i] != pval) return false; 
                  }
              }
          }
          //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
          //for (int j = 0; j < env.length; j++) {
          //    System.out.println("env["+ j+ "]="+ env[j]);
          //}
      }
      //System.out.println("*** match ****");
      return true;
  }
  public PrimitiveAction getAction(){
      return action;
  }
  // p^[}b`́ul̃xNgvoBO match ɂϐ蓖ĂpB
  public Object[] getActionParam(){
      Object[] ret = actionPatternVec.clone();
      for (int i = 0; i < ret.length; i++) {
          if (ret[i] == WILDCARD){
              // ret[i] = WILDCARD;
          } else if (ret[i] instanceof PatternVariable){
              int id = ((PatternVariable)actionPatternVec[i]).id;
              if (env[id] == UNBOUND){
                  //System.out.println("???:"+ this);
                  //System.out.println("???: var="+ ret[i]+ ",id="+ id);
                  throw new Error("UNBOUND in action param : "+ this);
              } else {
                  ret[i] = env[id];
              }
          }
      }
      return ret;
  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      {
          Lab.assertTrue(patternVec.length == WmIndex.size * 2);
          buf.append(name);
          buf.append(":");
          buf.append("rule(");
          buf.append(WmIndex.valuesToString(patternVec));
          buf.append(" ");
          if (actionPatternVec != null){
              Lab.assertTrue(actionPatternVec.length == WmIndex.size);
              buf.append(action+ " ");
              buf.append(WmIndex.valuesToString(actionPatternVec));
          } else {
              buf.append(action+ "");
          }
          buf.append("):"+ q);
      }
      if (WmIndex.printRawFlag) {
          buf.append(" raw: ");
          Lab.assertTrue(patternVec.length % 2 == 0);
          int stateLength = patternVec.length / 2;
          buf.append(name);
          buf.append(":");
          buf.append("rule((");
          for (int i = 0; i < stateLength; i++) {
              buf.append(patternVec[i]+ ",");
          }
          buf.append("), (");
          for (int i = 0; i < stateLength; i++) {
              buf.append(patternVec[stateLength + i]+ ",");
          }
          buf.append("), ");
          if (actionPatternVec != null){
              buf.append(action+ "(");
              for (int i = 0; i < actionPatternVec.length; i++) {
                  buf.append(actionPatternVec[i]+ ",");
              }
              buf.append(")");
          } else {
              buf.append(action+ "");
          }
          buf.append("):"+ q);
      }
      return buf.toString();
  }
  public static class PatternVariable {
      String name;
      int id;
      public PatternVariable(String name, int id){ 
          this.name = name; this.id = id; 
      }
      //public String toString() { return ""+ id+ ":"+ name; }
      public String toString() { return ""+ name; }
  }
  // Special instance used for Action.Return
  public static final Rule returnRule = new ReturnRule();
  // Special instance used as a dummy caller of each episode. 
  public static final Rule startRule = new StartRule();
  // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
  //   ReturnRule ̃CX^X𖳗gĂB
  public static State makeState(StateN stateN, Object defaultValue) {
      return new State(returnRule.transStateN(stateN, defaultValue).toArray());
  }
}
public static class ReturnRule extends Rule {
  public ReturnRule(){
      name = "ReturnRule";
      action = PrimitiveAction.Return;
      q = 0; // Q(g,g,RET) == 0
  }
  public String toString(){
      return name+ ": "+ q;
  }
}
public static class StartRule extends Rule {
  public StartRule(){
      name = "StartRule";
  }
  public String toString(){
      return name+ ": "+ q;
  }
}
/**
* Q(s,g,call(m))  s, g, m \邽߂̃f[^\B
*/
public static class State {
  public Object[] values;
  public State(Object[] values) { this.values = values; }
  //public Object[] getVec(){
  //    return values;
  //}
  /**
   * Compares two states in order to check if the agent reaches 
   * the subgoal state g. 
   * State g may contain the special values: PLS and/or WILDCARD. 
   */
  public boolean satisfies(State g){
      Object[] gv = g.values;
      Lab.assertTrue(values.length == gv.length);
      for (int i = 0; i < gv.length; i++) {
          if (gv[i] == Rule.PLS){
              if (values[i] == Rule.ZERO) return false;
              if (values[i] == Rule.WILDCARD) return false;
          } else if (gv[i] == Rule.WILDCARD){
              // Do nothing.
          } else {
              if (values[i] != gv[i]) return false;
          }
      }
      return true;
  }
  /**
   * Gs\[hL̂߂̃}b`OB
   * query Ɋ܂܂ĂqꂪׂĊ܂܂ĂȂ true ԂB
   * TODO: L[Ώۂ State ł͂ȂCxgɕύXB
   */
  public boolean episodeMatch(State query) {
      Object[] qv = query.values;
      //printArray("episodeMatch: query", kv);
      //printArray("episodeMatch: state", values);
      Lab.assertTrue(values.length == qv.length);
      for (int i = 0; i < qv.length; i++) {
          if (qv[i] == Rule.PLS){
              if (values[i] == Rule.ZERO) return false;
              if (values[i] == Rule.WILDCARD) return false;
          } else if (qv[i] == Rule.WILDCARD){
              // Do nothing.
          } else {
              if (values[i] != qv[i]) return false;
          }
      }
      return true;

  }
  public String toString(){
      StringBuffer buf = new StringBuffer();
      {      
          buf.append(WmIndex.valuesToString(values));
      }
      if (WmIndex.printRawFlag) {
          buf.append(" raw: (");
          for (int i = 0; i < values.length; i++) {
              buf.append(values[i].toString());
              buf.append(",");
          }
          buf.append(")");
      }
      return buf.toString();
  }


  public WObj getWObj(int index) { 
      return (WObj)values[index]; 
  }
  public Object get(int index) { 
      return values[index]; 
  }
  // State  n Ԗڂ̗vf𐮐ɂĕԂB
  public int getInt(int n) {
      Object x = values[n];
      if (x instanceof Integer) {
          return ((Integer)x).intValue();
      } else {
          //return -1;
          throw new Error("x is not an Integer. x="+ x);
      }
  }
  public void set(int index, Object x) { 
      values[index] = x;
  }
  public void clearReg(RegisterIndex r) {
      for (int i = 0; i < r.size; i++) {
          values[r.head + i] = 0;
      }
  }
  public void copyRegFrom(RegisterIndex r, State s) {
      for (int i = 0; i < r.size; i++) {
          values[r.head + i] = s.values[r.head + i];
      }
  }
}
/**
* Agent  takeAction ̏ĂrŃANV fail Ƃ throw B
* ݕsgpB  
*
*/
public static class Fail extends Exception {}

/**
 * v~eBuANVsɔOB 
 */
public static class PrimitiveError extends Exception {}


//--------------------------------------------------
public static abstract class AbstractMainCode extends Lab.MainCode {
  //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
  public int maxSteps = panel.getInt("max steps", 1000, 1, 10000);
  public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
  public float rewardC = panel.getFloat("1 step cost", -1, -10, 0);
  public boolean useOldUpdateRule = panel.flag("useOldUpdateRule", false);
  public boolean sarsaLearningFlag = panel.flag("sarsaLearningFlag", false);
  public boolean extraMonteLearningFlag = panel.flag("extraMonteLearningFlag", false);
  //public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
  //public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
  //public int mapSizeX; // not uesd
  //public int mapSizeY; // not used
//  public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
//  public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
  public float vScale; 
  public lab.Lab.WTextArea qView = null;
  public AbstractMainCode mainCode = this; // Main ZN^őIB
  public World world;

  public void main() {
      world = new World();
      world.init();
      world.main();
  }

  public class Agent extends WObj {
      public State newS; // state
      public State newG; // subgoal
      public Rule newR; // rule 
      public State oldS;
      public State oldG;
      public Rule oldR;
      public State actionParamState; 
      public float reward;
      public Stack<State> stack;
      public Stack<Rule> callerStack;
      public Rule caller;
      // for Monte Carlo Learning
      public Stack<Rule> ruleHistory;
      public Stack<Float> rewardHistory;
      public Stack<Rule> callerHistory;
      public Stack<Stack<Rule>> callerStackHistory;
      
      //
      public State start, goal;
      public boolean failedFlag;
      public float stackValue;
      public State failedState;
      //
      public World world;
      public Room currentRoom;
      public int energy;
      //public int currentPos;
      //public Item agentItem; // Item that represents the agent itself.
      public List<Rule> rules;
      public List<Rule> knowledgeBase;
      public State sentenceBuf;
      //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
      public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
      //
      public Agent(String name, World world){
          super(name);
          this.world = world;
          this.currentRoom = Here; // Dummy
      }
//      // depricated
//      public Agent(Item selfItem, World world){
//          this.agentItem = selfItem;
//          this.world = world;
//          this.currentRoom = Here; // Dummy
//      }
      public void setDefaultStartAndGoal(){
          State s = Rule.makeState(w(), Rule.ZERO);
          State g = Rule.makeState(w(a(Verb.TaskCompleted)), Rule.WILDCARD);
          knowledgeBase = List.copyOf(knowledgeList);
          setStartAndGoal(s, g);
      }
      public void setStartAndGoal(State s, State g){
          oldS = newS = start = s;
          oldG = newG = goal = g;
          failedState = s;

          //System.out.println("setStartAndGoal: s="+ s);
          //System.out.println("setStartAndGoal: g="+ g);
          //System.out.println("s.satisfies(g)="+ s.satisfies(g));
      }
      public void initEpisodeAndChooseFirstAction(){
          ruleHistory = new Stack<Rule>();
          rewardHistory = new Stack<Float>();
          callerHistory = new Stack<Rule>();
          callerStackHistory = new Stack<Stack<Rule>>();

          stack = new Stack<State>();
          callerStack = new Stack<Rule>();
          stack.push(oldG);
          caller = Rule.startRule;
          callerStack.push(Rule.returnRule); // Dummy whose base value is 0.
          episodeMem = new ArrayList<State>();
          episodeMemLog("episodeList cleared.");
          sentenceBuf = null;
          chooseAction();
          oldR = newR;
      }
      // 
      public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
      public void takeAction(){
          PrimitiveAction action = oldR.getAction();
          failedFlag = false;
          episodeMemLog(oldR.toString());

          if (panel.flag("Action log", true)) {
              StringBuffer buf = new StringBuffer();
              // indent
              for (int i = 0; i < stack.size(); i++) {
                  buf.append("  ");
              }
              buf.append("c="+ world.counter+ ": rule "+ oldR.name+ ": ");
              buf.append(action.toString());
              if (action == PrimitiveAction.Return) {
                  buf.append(' ');
                  buf.append(oldS.toString());
              } else if (actionParamState != null) {
                  buf.append(" ");
                  buf.append(actionParamState);
                  if (WmIndex.printRawFlag) {
                      buf.append('(');
                      Object[] values = actionParamState.values;
                      if (values.length > 0) {
                          buf.append(values[0].toString());
                          for (int i = 1; i < values.length; i++) {
                              buf.append(',');
                              buf.append(values[i].toString());
                          }
                      }
                      buf.append(')');
                  }
              }
              env.viewPanel.println("Action log of "+ this.name, buf.toString());
              if (panel.flag("Show sentenceBuf in action log", false)) {
                  env.viewPanel.println("Action log of "+ this.name, 
                          "sentenceBuf="+ sentenceBuf);
              }
          }

          try { // catch (Fail)
              if (action == PrimitiveAction.Return){
                  newS = oldS;
                  newG = stack.pop();
                  reward = rewardC;
                  
              } else if (action == PrimitiveAction.Exit){
                  newS = wmSet(actionParamState, oldS);
                  newG = stack.pop();
                  reward = rewardC;

              } else if (action == PrimitiveAction.Call){
                  stack.push(oldG);
                  newS = oldS;
                  newG = actionParamState;
                  reward = rewardC;

//              } else if (action == PrimitiveAction.Try){
//                  Lab.assertTrue(false); // wK
//                  newS = oldS;
//                  //newS.clear(WmIndex.A);
//                  //newS.clear(WmIndex.E);
//                  stack.push(oldG);
//                  newG = actionParamState;
//                  reward = rewardC;

              } else if (action == PrimitiveAction.CallM){
                  Lab.assertTrue(false); // wK
                  // w肵mŐ錾Im̑zN݂B
                  State pp = null;
                  //              if (Lab.irand(2) == 0) {
                  if (panel.getFloat("recall when callM", 1f, 0f, 1f) > Lab.rand()) {
                      State query = getReg(WmIndex.A, actionParamState);
                      pp = doRecall(query);
                  }
                  if (pp == null) {
                      // Do call.
                      // 錾ILɌȂΕʂɃTu[`ĂяoB
                      newS = oldS;
                      //newS.clear(WmIndex.A);
                      //newS.clear(WmIndex.E);
                      stack.push(oldG);
                      newG = actionParamState;
                      reward = rewardC; //??
                  } else {
                      episodeMemLog(" Cache hit: "+ pp);
                      newS = setReg(WmIndex.A, pp, oldS);
                      episodeMemLog(" newS="+ newS);
                      newG = oldG;
                      reward = rewardC; //??
                  }          

              } else if (action == PrimitiveAction.Set
                      || action == PrimitiveAction.SetWithCost1
                      || action == PrimitiveAction.SetWithCost2
                      || action == PrimitiveAction.SetWithCost3
                      || action == PrimitiveAction.SetWithCost4
                      ){
                  // NOTE: Ώۂ a WX^̏ꍇ Set ł͂Ȃ SetM Ă΂B
                  newS = wmSet(actionParamState, oldS);
                  newG = oldG;
                  //reward = rewardC;
                  if (action == Set) {
                      reward = rewardC;
                  } else if (action == SetWithCost1) {
                      reward = panel.getFloat("SetWithCost1", -1, -2, 0);
                  } else if (action == SetWithCost2) {
                      reward = panel.getFloat("SetWithCost2", -1, -2, 0);
                  } else if (action == SetWithCost3) {
                      reward = panel.getFloat("SetWithCost3", -1, -2, 0);
                  } else if (action == SetWithCost4) {
                      reward = panel.getFloat("SetWithCost4", -1, -2, 0);
                  } else {
                      Lab.assertTrue(false);
                  }
              } else if (action == PrimitiveAction.SetM){
                  newS = wmSet(actionParamState, oldS);
                  rememberAreg(newS);
                  //                State aReg = getReg(WmIndex.A, newS);
                  //                episodeMem.add(0, aReg); // Insert to the top of the list.
                  //                episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);
                  newG = oldG;
                  reward = rewardC;

              } else if (action == PrimitiveAction.Recall){
                  State query = getReg(WmIndex.E, actionParamState);
                  State pp = doRecall(query);
                  if (pp == null) {
                      episodeMemLog(" Recall failed.");
                      throw new Fail();
                  } else {
                      newS = setReg(WmIndex.E, pp, oldS);
                      episodeMemLog(" newS="+ newS);
                      newG = oldG;
                      reward = rewardC;
                  }              

              } else if (action == PrimitiveAction.NOP){
                  newS = oldS;
                  newG = oldG;
                  reward = rewardC;

              } else if (action == PrimitiveAction.Fail){
                  throw new Fail();

              } else {
                  reward = rewardC;
                  newS = new State(oldS.values.clone());
                  takePrimitiveActionAndObserve();
                  newG = oldG;
              }

          } catch (Fail f) {
              if (true) {
                  if (panel.flag("Action log", true)) {
                      env.viewPanel.println("Action log of "+ this.name, "Failed.");
                  }                
                  newS = Rule.makeState(w(a(Failed)), Rule.ZERO);
                  newS.clearReg(WmIndex.E);
                  newG = oldG;
                  reward = rewardC + failPenalty;
                  
              } else {
                  // Old implementation.
                  if (true) System.err.println("Fail occurred.");
                  if (panel.flag("Action log", true)) {
                      env.viewPanel.println("Action log of "+ this.name, "Failed.");
                  }                
                  failedFlag = true;
                  if (useOldUpdateRule) {
                      stackValue = evalStack(oldG, stack);
                  }
                  newS = failedState;
                  //newS.clear(WmIndex.A);
                  newS.clearReg(WmIndex.E);

//                  // old implementation
//                  newG = goal;
//                  stack.clear();
                  while (! stack.isEmpty()) {
                      newG = stack.pop();
//                      if (newG == null) { // "try" action marker
//                          newG = stack.pop();
//                          break;
//                      }
                  }

                  //episodeMem.clear();  // ??
                  reward = rewardC + failPenalty;
              }
          }
          //        // KŌɌ݂̎Eꏊ̐lWX^ɐݒ
          //        newS.set(WmIndex.V.When, world.currentTime);
          //        newS.set(WmIndex.V.Where, currentRoom);
      }
      public void chooseAction(){
          if (newS.satisfies(newG)){
              newR = Rule.returnRule;
              actionParamState = null;
          } else {
              List<Rule> matched = selectMatchedRules(newS, newG);

              //            matched.forEach(r -> {
              //                System.out.println("matched: "+ r);
              //                if (r.action == Action.Call || r.action == Action.Set) {
              //                    System.out.println("  a="+ r.action);
              //                    System.out.println("  m="+ new State(r.getActionParam()));
              //                }
              //            });

              float[] q = calcRulePriorities(matched);
              if (q.length == 0){
                  throw new Error("No action-rule selected: (newS,newG)="+ 
                          newS+ ", "+ newG);
              }
              // softmax  Rule PIB
              int index = softmax(q);
              if (panel.flag("Show matched rules", false)){
                  for (int i = 0; i < matched.size(); i++) {
                      env.viewPanel.println("matched "+ this.name, "c="+ world.counter+ ": "+ i+ ":"+ matched.get(i));
                  }
                  for (int i = 0; i < q.length; i++) {
                      env.viewPanel.println("priority "+ this.name, "c="+ world.counter+ ": "+ i+ ":"+ q[i]);
                  }
                  for (int i = 0; i < probTable.length; i++) {
                      env.viewPanel.println("probTable "+ this.name, "c="+ world.counter+ ": "+ i+ ":"+ probTable[i]);
                  }
              }
              newR = matched.get(index);
              if (newR.actionPatternVec == null) {
                  actionParamState = null;
              } else {
                  actionParamState = new State(newR.getActionParam());
              }
          }
      }
      public List<Rule> selectMatchedRules(State s, State g){
          // s,g ̒lzB
          Object[] vals = new Object[s.values.length + g.values.length];
          for (int i = 0; i < s.values.length; i++) {
              vals[i] = s.values[i];
          }
          for (int i = 0; i < g.values.length; i++) {
              vals[i + s.values.length] = g.values[i];
          }
          // (s,g) Ƀ}b`郋[IB
          // [̐ parallelStream gĂ݂B
          List<Rule> matched = rules.stream().filter(
                  r -> r.ruleMatch(vals)
                  ).collect(Collectors.toList());
          return matched;
      }
      public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
      public float[] calcRulePriorities(List<Rule> matched){
          float[] q = new float[matched.size()];
          for (int i = 0; i < q.length; i++) {
              Rule r = matched.get(i);
              // numVars ɉyieB^Bϐ̐Ȃ[DB
              float val = r.q - genericityPenalty * r.numVars;
              q[i] = val;
          }
          return q;
      }
      // sarsaLearningFlag  true ̂Ƃ SIG-AGI-025-08  Sarsa
      public void update() {
          ruleHistory.push(oldR);
          rewardHistory.push(reward);
          callerHistory.push(caller);
          callerStackHistory.push((Stack<Rule>)callerStack.clone()); // shallow copy of the stack
          if (failedFlag){
              // fail ͔p~\B
              // IȊwKł͂Ȃ̂ŒӁB
              if (sarsaLearningFlag) oldR.q += alpha * (reward + newR.q - oldR.q);
          } else if (oldR == Rule.returnRule) {
              if (sarsaLearningFlag) caller.base += alpha * (reward + newR.q - caller.base);
              caller = callerStack.pop();
              Lab.assertTrue(Rule.returnRule.q == 0);
              Lab.assertTrue(Rule.returnRule.base == 0);
          } else if (oldR.getAction() == PrimitiveAction.Exit){
              if (sarsaLearningFlag) oldR.q += alpha * (reward + (newR.q - caller.base) - oldR.q);
              caller = callerStack.pop();
          } else if (oldR.getAction() == PrimitiveAction.Call) {
              callerStack.push(caller);
              caller = oldR;
              if (sarsaLearningFlag) oldR.q += alpha * (reward + (newR.q + oldR.base) - oldR.q);
          } else {
              if (sarsaLearningFlag) oldR.q += alpha * (reward + newR.q - oldR.q);
          }

          oldS = newS;
          oldG = newG;
          oldR = newR;
      }
      // Monte-carlo learning.
      public boolean printBaseForMonteCarloFlag = false; 
      public void monteLearning() {
          Lab.assertTrue(Rule.returnRule.q == 0);
          Lab.assertTrue(Rule.startRule.q == 0);
          Lab.assertTrue(Rule.returnRule.base == 0);
          Rule oldR = Rule.returnRule; // Dummy whose Q value is 0.
          float T = 0; // Total reward until the end of the episode.
          if (printBaseForMonteCarloFlag) System.out.println("");
          while (! ruleHistory.isEmpty()) {
              Rule newR = oldR; // newR = rule_{t+1}, oldR = rule_t in the episode.
              oldR = ruleHistory.pop();
              Rule caller = callerHistory.pop();
              Stack<Rule> callerStack = callerStackHistory.pop();
              float reward = rewardHistory.pop(); 
              T += reward;
              if (oldR == Rule.returnRule){
                  if (printBaseForMonteCarloFlag) System.out.println("returnRule");
                  caller.base += alpha * (reward + newR.q - caller.base);
              } else {
                  float base = 0;
                  if (printBaseForMonteCarloFlag) System.out.println("normal rule");
                  for (Rule c : callerStack) {
                      if (printBaseForMonteCarloFlag) System.out.println(" c.base = "+ c.base);
                      base += c.base;
                  }
                  oldR.q += alpha * ((T - caller.base - base) - oldR.q);
              }
          }
      }
      // Monte-carlo learning just for algorithm comparison test.
      // SIG-AGI-025-08  eJ@ɂwKB
      // *** This is an old version which does not support multi-task. ***
      public void extraMonteLearning() {
          Lab.assertTrue(Rule.returnRule.monteQ == 0);
          Lab.assertTrue(Rule.startRule.monteQ == 0);
          Lab.assertTrue(Rule.returnRule.monteBase == 0);
          float G = 0; // Total reward until the end of the episode.
          while (! ruleHistory.isEmpty()) {
              Rule oldR = ruleHistory.pop();
              Rule caller = callerHistory.pop();
              G += rewardHistory.pop();
              if (oldR == Rule.returnRule){
                  caller.monteBase += alpha * (G - caller.monteBase);
              } else {
                  oldR.monteQ += alpha * ((G - caller.monteBase) - oldR.monteQ);
              }
          }
      }
      // Not tested enough.
      // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
      public float evalStack(State g, Stack<State> stack) {
          State ss = g;
          float ret = 0;
          for (int i = stack.size() - 1; i >= 0; i--) {
              //System.out.println("Stack!:"+ stack.get(i));
              State gg = stack.get(i);
              //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
              ret += evalValue(gg, ss);
              ss = gg;
          }
          //System.out.println("evalStack = "+ ret);
          return ret;
      }
      public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
      /** Returns V_g(s) */
      public float evalValue(State g, State s){
          List<Rule> matched = selectMatchedRules(s, g);
          float[] q = calcRulePriorities(matched);
          if (approxValueEvalFlag){
              // V_g(s) \approx max_a Q(s,g,a)
              int i = Lab.argmax(q); 
              return matched.get(i).q;
          } else {
              // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
              calcProbTable(q, 0, q.length);
              float val = 0;
              for (int i = 0; i < probTable.length; i++) {
                  // To avoid 0 * -Infinity = NaN
                  float value = matched.get(i).q;
                  if (value != Float.NEGATIVE_INFINITY){
                      val += probTable[i] * value;
                  }
              }
              return val; 
          }
      }


      // Softmax
      public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
      public int softmax(float[] q){ return softmax(q, 0, q.length); }
      public int softmax(float[] q, int from, int to){
          calcProbTable(q, from, to);
          //        System.out.println("probTable=");
          //        for (int i = 0; i < probTable.length; i++) {
          //            System.out.print(probTable[i]+ ", ");
          //        }
          //        System.out.println();
          float r = Lab.rand();
          double sum = 0;
          for (int i = from; i < to; i++){
              sum += probTable[i]; 
              if (sum > r) {
                  Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                  return i;
              }
          }
          Lab.assertTrue(sum - 0.001f < 1);
          Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
          return to - 1;
      }
      // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
      public void calcProbTable(float[] q, int from, int to){
          if (q.length != probTable.length){
              probTable = new double[q.length];
          }
          float max = Lab.max(q);
          double total = 0;
          for (int i = from; i < to; i++){
              // To avoid overflow, subtract max.
              // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
              double val = Math.exp(beta * (q[i] - max));
              probTable[i] = val;
              total += val;
              //             System.out.println("q["+ i+ "]="+ q[i]);
              //             System.out.println("val="+ val);
          }
          //        System.out.println("total="+ total);
          Lab.assertTrue(total > 0);
          for (int i = from; i < to; i++){
              probTable[i] /= total;
          }
      }

      public boolean achieved() {
          return stack.size() == 0 && newR.getAction() == PrimitiveAction.Return; 
      }
      /**
       * [LO̒lXVBvf̒l KEEP ̏ꍇ͂̑O̒lێB
       */
      public State wmSet(State setArg, State oldS) {
          Object[] oldv = oldS.values;
          Object[] newv = oldv.clone(); // Copy the other registers.
          Object[] argv = setArg.values;
          for (int i = 0; i < newv.length; i++) {
              if (argv[i] == Rule.KEEP) {
                  newv[i] = oldv[i];
              } else {
                  newv[i] = argv[i];
              }
          }
          return new State(newv);
      }
      /**
       * WX^̒loB
       */
      public State getReg(RegisterIndex reg, State oldS) {
          int regOffset = reg.head;
          int regSize = WmIndex.A.size; // Assumes all registers have the same size.
          Object[] oldv = oldS.values;
          Object[] propv = new Object[regSize];
          for (int i = 0; i < regSize; i++) {
              propv[i] = oldv[regOffset + i];
          }
          return new State(propv);
      }
      /**
       * WX^ɒlZbgBw肵WX^ȊO̒l͕ێB
       */
      public State setReg(RegisterIndex reg, State pprop, State oldS) {
          int regOffset = reg.head;
          Object[] oldv = oldS.values;
          Object[] newv = oldv.clone(); // Copy the other registers.
          Object[] propv = pprop.values;
          int regSize = WmIndex.A.size; // Assumes all registers have the same size.
          Lab.assertTrue(regSize == propv.length);
          for (int i = 0; i < regSize; i++) {
              newv[regOffset + i] = propv[i];
          }
          return new State(newv);
      }

      public int getCurrentRoomID() {
          return roomNameToRoomId(currentRoom);
      }
      public int roomNameToRoomId(Room roomName) {
          for (int i = 0; i < world.rooms.length; i++) {
              //System.out.println("n="+ roomName+ ", a[i]="+ world.areas[i]);
              if (roomName == world.rooms[i]) return i;
          }
          throw new Error("roomNameToRoomId : "+ roomName);
      }


      /** ANV a.oldR sA a.newS ϑB
       * Vꍇ a.reward ̒lɉZB
       */
      public void takePrimitiveActionAndObserve() throws Fail {
          PrimitiveAction action = oldR.getAction();
          //newS.set(WmIndex.A.C0.When, Time.Now);
          switch (action) {
          case Eat: {
              try {
                  // S HׂȂHׂB
                  Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == Ate);
                  WObj o1 = oldG.getWObj(WmIndex.A.C1.O1);
                  if (! world.containsItem(currentRoom, o1)) throw new PrimitiveError();
                  
                  Verb verb;
                  if (world.containsItem(currentRoom, o1)) {
                      // HׂꍇB
                      if (o1 == Nut) {
                          world.removeItem(currentRoom, o1);
                          energy++;
                          verb = Ate;
                      } else {
                          verb = CanNotEat;
                      }
                  } else {
                      verb = IsAwareOfNo;
                  }
                  State newRegA = Rule.makeState(w(a(c(verb,this,o1,0,currentRoom,Now,true))), Rule.ZERO);
                  newS.copyRegFrom(WmIndex.A, newRegA);
                  rememberAreg(newS);
                  world.vCommands.add(new VCommand(Eat, this.name, o1));
              } catch (PrimitiveError e) {
                  Lab.assertTrue(false); // not implemented
              }
          } break;

          case Apply: {
              Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == AppliedO1ToO2);
              WObj o1 = oldG.getWObj(WmIndex.A.C1.O1);
              WObj o2 = oldG.getWObj(WmIndex.A.C1.O2);
              Verb verb;
              if (! world.containsItem(currentRoom, o1)) {
                  verb = CanNotApply;
              } else if (! world.containsItem(currentRoom, o2)) {
                  verb = CanNotApply;
              } else {
                  if (o1 == Stone && o2 == Nutshell) {
                      world.removeItem(currentRoom, o1);
                      world.removeItem(currentRoom, o2);
                      world.addItem(currentRoom, Nut);
                      verb = AppliedO1ToO2;
                  } else if (o1 == Key && o2 == Box){
                      world.removeItem(currentRoom, o1);
                      world.removeItem(currentRoom, o2);
                      world.addItem(currentRoom, Gold);
                      verb = AppliedO1ToO2;
                  } else {
                      verb = CanNotApply;
                  }
                  world.vCommands.add(new VCommand(Apply, this.name, o1, o2));
              }
              State newRegA = Rule.makeState(w(a(c(verb,this,o1,o2,currentRoom,Now,true))), Rule.ZERO);
              newS.copyRegFrom(WmIndex.A, newRegA);
              rememberAreg(newS);
          } break;
          

          case GoDir: {
              Lab.assertTrue(false); // TODO: situation 
//              String dir = (String)actionParamState.getWObj(WmIndex.A.C1.S);
//              // ړvZB˂ꍇ݂͌̃GÂ܂܁B
//              int newRoomID = neighborRoomID(roomID, dir);
//              Room oldRoom = currentRoom;
//              Room newRoom = world.rooms[newRoomID];
//
//              world.removeItem(currentRoom, this);
//              currentRoom = newRoom;
//              world.addItem(currentRoom, this);
//              //
//              recogRoom();
//              world.vCommands.add(new VCommand(GoDir, this.name, oldRoom, newRoom));
          } break;

          case GoToRoom: {
//              Room oldRoom = currentRoom;
//              Room newRoom = (Room)actionParamState.get(WmIndex.A.C1.S);
              Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == CameFrom);
              //Room oldRoom = (Room)oldG.get(WmIndex.A.C1.O1);
              Room oldRoom = this.currentRoom;
              Room newRoom = (Room)oldG.get(WmIndex.A.C1.L);
              if (world.checkImpassableRoutes(currentRoom, newRoom)) {
                  newRoom  = world.rooms[0]; // Go to the start room.
              }
              world.removeItem(currentRoom, this);
              currentRoom = newRoom;
              world.addItem(currentRoom, this);
              //
              //recogRoom();
              State newRegA = Rule.makeState(w(a(c(CameFrom,this,oldRoom,0,newRoom,Now,true))), Rule.ZERO);
              newS.copyRegFrom(WmIndex.A, newRegA);
              rememberAreg(newS);
              world.vCommands.add(new VCommand(GoToRoom, this.name, oldRoom, newRoom));
          } break;

          case Bring: {
              Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == BroughtO1FromO2);
              WObj o1 = oldG.getWObj(WmIndex.A.C1.O1);
              Room oldRoom = (Room)oldG.get(WmIndex.A.C1.O2);
              Room newRoom = (Room)oldG.get(WmIndex.A.C1.L);
              Verb verb;
              if (! world.containsItem(currentRoom, o1)) {
                  verb = CanNotApply; // TODO: K؂ȖOɕύX
              } else {
                  world.removeItem(currentRoom, this);
                  world.removeItem(currentRoom, o1);
                  currentRoom = newRoom;
                  world.addItem(currentRoom, this);
                  world.addItem(currentRoom, o1);
                  verb = BroughtO1FromO2;
              }
              //
              State newRegA = Rule.makeState(w(a(c(verb,this,o1,oldRoom,currentRoom,Now,true))), Rule.ZERO);
              newS.copyRegFrom(WmIndex.A, newRegA);
              rememberAreg(newS);
              world.vCommands.add(new VCommand(Bring, this.name, oldRoom, newRoom, o1));
          } break;

          case RecogRoom : {
              recogRoom();
          } break;

          case FindItem : {
              Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == LookingAt);
              Object o1 = oldG.get(WmIndex.A.C1.O1);
              boolean p;
              Object foundObj;
              if (o1 == PLS) {
                  if (world.numItems(currentRoom) > 0) {
                      foundObj = world.findRandomItem(currentRoom);
                      p = true;
                  } else {
                      // uȂv͂ǂ\H
                      Lab.assertTrue(false); // not implemented
                      throw new Error();
                  }
              } else {
                  foundObj = o1;
                  p = world.containsItem(currentRoom, o1);
              }
              State newRegA = Rule.makeState(w(a(c(LookingAt,this,foundObj,0,currentRoom,Now,p))), Rule.ZERO);
              newS.copyRegFrom(WmIndex.A, newRegA);
              rememberAreg(newS);
              world.vCommands.add(new VCommand(FindItem, this.name, o1));                  
          } break;

          case FindSecondItem : {
              Lab.assertTrue(oldG.get(WmIndex.A.C1.V) == LookingAt2);
              //Object firstItem = newS.get(WmIndex.A.C1.O1);
              Object o1 = oldG.get(WmIndex.A.C1.O1);
              Object o2 = oldG.get(WmIndex.A.C1.O2);
              boolean p;
              Lab.assertTrue(o2 != PLS);
              p = world.containsItem(currentRoom, o2);
              State newRegA = Rule.makeState(w(a(c(LookingAt2,this,o1,o2,currentRoom,Now,p))), Rule.ZERO);
              newS.copyRegFrom(WmIndex.A, newRegA);
              rememberAreg(newS);
              world.vCommands.add(new VCommand(FindSecondItem, this.name, o2));                  
          } break;

          case Listen : {
              if (sentenceBuf != null) {
                  // obt@̒g a WX^ɏށB
                  for (int i = 0; i < WmIndex.A.size; i++) {
                      newS.set(WmIndex.A.head + i, 
                              sentenceBuf.get(WmIndex.A.head + i));
                  }
                  rememberAreg(newS);
                  if (panel.flag("Show sentenceBuf in action log")) {
                      env.viewPanel.println("Action log of "+ this.name, 
                              "Listen: sentenceBuf="+ sentenceBuf);
                  }           
                  world.vCommands.add(new VCommand(Listen, this.name, sentenceBuf.toString()));
                  // obt@͋ɂB
                  sentenceBuf = null;
              } else {
                  // Do nothing. Just listen to new utterance.
              }
          } break;

          case SayIt : {
              Lab.assertTrue(false); // TODO: situation 
              // a WX^̏ԃ`FbNBԈĂ΃G[bZ[Wo Fail B
              // TODOF ƂƎB
              Lab.assertTrue(oldS.get(WmIndex.A.C1.V) == WantsToSayTo);

              // B
              WObj targetName = oldS.getWObj(WmIndex.A.C1.O1);
              Agent a = world.findAgent(targetName);
              if (a == null) {
                  throw new Error("SayIt: targetName "+ targetName+ " does not exist.");
              }
              if (a.sentenceBuf == null) {
                  // be𑊎̕obt@ɏށB
                  State buf = new State(new String[WmIndex.A.size]);
                  for (int i = 0; i < WmIndex.A.size; i++) {
                      buf.set(WmIndex.A.head + i, 
                              oldS.get(WmIndex.A.head + i));
                  }
                  buf.set(WmIndex.A.C1.S, a.name); // ID
                  buf.set(WmIndex.A.C1.O1, a.name); // ID
                  buf.set(WmIndex.A.C1.V, SaidTo);
                  a.sentenceBuf = buf;

                  //  a WX^̒l WantsToSayTo  SaidTo ɕύXB
                  newS.set(WmIndex.A.C1.V, SaidTo);

                  // V a WX^̓eGs\[hLɂĂB
                  rememberAreg(newS);
                  //                State aReg = getReg(WmIndex.A, newS);
                  //                episodeMem.add(0, aReg); // Insert to the top of the list.
                  //                episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);
                  world.vCommands.add(new VCommand(SayIt, this.name, a.name, a.sentenceBuf.toString()));

              } else {
                  // Do nothing. The utterance is just ignored.
              }
          } break;


          case NewSituation: {
              // TODO: actionParamState gȂX^CɏB
              Situation parent = (Situation)actionParamState.get(WmIndex.A.C1.S);
              Situation subSituation = new TempSituation(parent);
              //
              // TODO: makeState gďȂB
//              State newRegA = Rule.makeState(w(a(c(verb,this,o1,o2,currentRoom,Now,true))), Rule.ZERO);
//              newS.copyRegFrom(WmIndex.A, newRegA);
              newS.clearReg(WmIndex.A);
              newS.set(WmIndex.A.Conj, Conj.Simple);
              newS.set(WmIndex.A.C1.Situation, Situation.Usual);
              newS.set(WmIndex.A.C1.V, SuperSituation);
              newS.set(WmIndex.A.C1.S, parent);
              newS.set(WmIndex.A.C1.O1, subSituation);
              newS.set(WmIndex.A.C1.O2, 0);
              newS.set(WmIndex.A.C1.L, 0);
              newS.set(WmIndex.A.C1.T, 0);
              newS.set(WmIndex.A.C1.P, true);

              rememberAreg(newS);
              
              //world.vCommands.add(new VCommand(GoDir, this.name, oldRoom, newRoom));
          } break;
          
          default: {
              System.out.println("The primitive action not implemented: "+ action);
              Lab.assertTrue(false);
          } break;
          }
      }
//      /** ׂ̃GAԂB˂ꍇ݂͌̃GAB */
//      public int neighborRoomID(int roomID, String dir) {
//          int rx = roomID % mapSizeX;
//          int ry = roomID / mapSizeX;
//          if (dir == West && rx > 0) {
//              rx--;
//          } else if (dir == North && ry < mapSizeY - 1) {
//              ry++;
//          } else if (dir == South && ry > 0) {
//              ry--;
//          } else if (dir == East && rx < mapSizeX - 1) {
//              rx++;
//          } else {
//              // Do nothing.
//              //throw new Error("dir="+ dir);
//          }
//          return ry * mapSizeX + rx;
//      }
      public void recogRoom() {
          State newRegA = Rule.makeState(w(a(c(Exists,this,0,0,currentRoom,Now,true))), Rule.ZERO);
          newS.copyRegFrom(WmIndex.A, newRegA);
          rememberAreg(newS);

      }
      public void rememberAreg(State newS) {
          State aReg = getReg(WmIndex.A, newS);
          episodeMem.add(0, aReg); // Insert to the top of the list.
          episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);          
      }

      // not used
      public void findItem(State actionParamState) throws Fail {
          Boolean logFlag = panel.flag("findItem: logFlag", false); 
          if (logFlag) System.out.println("findItem: actionParamState="+ actionParamState);
          int oID = actionParamState.getInt(WmIndex.A.C1.S);
          Object whatP = actionParamState.get(WmIndex.A.C1.O1);
          Object firstObj = oldS.get(WmIndex.A.C1.S);
          if (logFlag) {
              System.out.println("findItem: world.counter="+ world.counter);
              System.out.println("objID="+ oID);
              System.out.println("whatP="+ whatP);
          }
          Lab.assertTrue(oID == 1 || oID == 2);
          Lab.assertTrue(whatP != null);
          Lab.assertTrue(whatP != Rule.WILDCARD);
          Lab.assertTrue(whatP != Rule.ZERO);

          // SWX^̒l oldS  newS ɃRs[B
          newS = new State(oldS.values.clone());
          Verb verb;
          Object foundObj;
          boolean p;

          if (whatP == PLS) {
              if (world.numItems(currentRoom) > 0) {
                  // Room 烉_ɕ̂PIB
                  //verb = IsAwareOf;
                  verb = Exists;
                  foundObj = world.findRandomItem(currentRoom);
                  p = true;
              } else {
                  // ̂PȂꍇB
                  verb = FindsNothing;
                  foundObj = 0;
                  p = true;
              }
          } else {
              verb = Exists;
              foundObj = whatP;
              p = world.containsItem(currentRoom, whatP);
          }

          State newRegA;
          if (oID == 1) {
              newRegA = Rule.makeState(w(a(c(verb,foundObj,0,0,currentRoom,Now,p))), Rule.ZERO); 
          } else if (oID == 2) {
              newRegA = Rule.makeState(w(a(c(verb,firstObj,foundObj,0,currentRoom,Now,p))), Rule.ZERO); 
          } else {
              throw new Error();
          }
          newS.copyRegFrom(WmIndex.A, newRegA);          
          rememberAreg(newS);

          if (logFlag) {
              System.out.println("newS="+ newS);
          }
      }

      // Proven-proposition list
      /**
       * 
       */
      public List<State> episodeMem = null;
      /**
       * episodeList  query Ƀ}b`Gs\[hPIB
       * PȂꍇ null ԂB
       */
      public State findEpisode(State query) {
          // ܂͊ȒPȎBŏɌ̂PԂB
          return episodeMem.stream().filter(s -> s.episodeMatch(query))
                  .findFirst().orElse(null);
      }
      /**
       * knowledgeBase  query ̒lƃ}b`mPIB 
       * PȂꍇ null ԂB
       * class Rule 𗬗pȎB
       */
      public State findKnowledge(State query) {
          episodeMemLog("findKnowledge: query="+ query);
          Object[] vals = new Object[WmIndex.size * 2];
          for (int i = 0; i < WmIndex.size; i++) {
              vals[i] = Rule.ZERO;
          }
          for (int i = 0; i < WmIndex.E.size; i++) {
              vals[WmIndex.E.head + i] = query.values[i];
          }
          // Dummy value for g.
          for (int i = 0; i < WmIndex.size; i++) {
              vals[WmIndex.size + i] = Rule.WILDCARD;
          }
          episodeMemLog("findKnowledge: (s,g)="+ new State(vals));
          //episodeLog("findKnowledge: kb size="+ knowledgeBase.size());
          // (s,g) Ƀ}b`郋[IB
          // [̐ parallelStream gĂ݂B
          List<Rule> matched = knowledgeBase.stream().filter(
                  r -> r.knowledgeMatch(vals)
                  ).collect(Collectors.toList());
          if (matched.size() == 0) return null;

          float[] q = calcRulePriorities(matched);
          Lab.assertTrue(q.length != 0);
          // softmax  Rule PIB * 錾Im̉lׂ͂ēB
          int index = softmax(q);
          if (panel.flag("findKnowledge: Show matched rules", false)){
              env.viewPanel.println("matched"+ this.name, "counter="+ world.counter);
              for (int i = 0; i < matched.size(); i++) {
                  env.viewPanel.println("matched"+ this.name, i+ ":"+ matched.get(i));
              }
              env.viewPanel.println("matched"+ this.name, "selected: "+ index);
              env.viewPanel.println("priority"+ this.name, "counter="+ world.counter);
              for (int i = 0; i < q.length; i++) {
                  env.viewPanel.println("priority"+ this.name, i+ ":"+ q[i]);
              }
              env.viewPanel.println("probTable"+ this.name, "counter="+ world.counter);
              for (int i = 0; i < probTable.length; i++) {
                  env.viewPanel.println("probTable"+ this.name, i+ ":"+ probTable[i]);
              }
          }
          Rule selected = matched.get(index);
          episodeMemLog("findKnowledge: selected="+ selected);
          State param = new State(selected.getActionParam());
          episodeMemLog("findKnowledge: param="+ param);
          State ret = getReg(WmIndex.E, param);
          episodeMemLog("findKnowledge: ret="+ ret);
          return ret;
      }
      public void episodeMemLog(String s) {
          if (episodeMemLogFlag) {
              env.viewPanel.println(episodeMemLogLabel+ this.name, "c="+ world.counter+ ": "+ s);
          }
      }
      /**
       * Returns null if no episode found.
       */
      public State doRecall(State query) {
          episodeMemLog("doRecall");
          //episodeMemLog(" param="+ actionParamState);
          episodeMemLog(" query="+ query);
          State pp;
          // w肵mŃGs\[hLƐ錾Îǂ炩DIɑzNB
          // TODO: ɍŐṼGs\[hzN̂ł͂ȂA_ɑIB
          //        if (Lab.irand(2) == 0) {
          if (panel.getFloat("episode:knowledge", 0.5f, 0f, 1f) > Lab.rand()) {
              pp = findEpisode(query);
              if (pp == null) {
                  pp = findKnowledge(query);
              }
          } else {
              pp = findKnowledge(query);
              if (pp == null) {
                  pp = findEpisode(query);
              }
          }
          if (pp == null) {
              episodeMemLog(" Not found.");
          } else {
              episodeMemLog(" Found: "+ pp);
          }
          return pp;
      }
  }
  //--------------------------------------------------
  public boolean visualizeFlag;
  public boolean mapVisualizeFlag;
  public boolean episodeMemLogFlag;
  public String episodeMemLogLabel = "Episode mem log of ";
  public class World {
      public Room[] rooms;
      public Map<Room,Set<Object>> roomStates;
      //public Room[] map; // not used !
      /** Array of {room1, room2}. Used by GoToRoom. */
      public Room[][] impassableRoutes;
      public Agent[] agents;
      public List<VCommand> vCommands = new ArrayList<>();

      public Agent findAgent(Object name) {
          for (int i = 0; i < agents.length; i++) {
              if (agents[i].name == name) return agents[i];
          }
          return null;
      }
      //
      public World(){
      }
      public void init() {
          agents = mainCode.makeAgents(this);
          mainCode.setMap(this);
          mainCode.initAgentsTable(this);
          printWorldInfo();
      }
      public int counter = 0;
      public int currentTime; 
      public void main(){
          int episodes = 0;
          for (;;){
              int steps = episode();
              env.viewPanel.scatterPlot("Step/Episode", episodes, steps);
              env.viewPanel.print1("episodes=", ""+ episodes++);
          }
      }
      public int episode() {
          currentTime = 0;
          visualizeFlag = panel.flag("visualizeFlag", true);
          mapVisualizeFlag = panel.flag("mapVisualizeFlag", true);
          episodeMemLogFlag = panel.flag("episodeMemLogFlag", true);
          panel.speedControl("Episode loop", 0);
          for (int i = 0; i < agents.length; i++) {
              Agent a = agents[i];
              a.setDefaultStartAndGoal();
          }
          world.initRoomStates();
          impassableRoutes = new Room[0][];
          mainCode.initEpisode(this);
          if (visualizeFlag){
              if (mapVisualizeFlag) startVisualizeMap();
          }
          for (int i = 0; i < agents.length; i++) {
              Agent agent = agents[i];
              //a.observe(Rule.makeState(w(), Rule.KEEP), a.oldS);
              agent.initEpisodeAndChooseFirstAction();
              if (visualizeFlag){
                  if (mapVisualizeFlag) visualizeMap();
                  visualizeAgentState(agent);
              }
              if (panel.flag("Action log", true)) {
                  env.viewPanel.println("Action log of "+ agent.name, "");   
                  env.viewPanel.println("Action log of "+ agent.name, "First action choosed.");   
              }
          }
          // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
          //while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
          while (! agents[0].stack.isEmpty() && currentTime++ < maxSteps){
              for (int i = 0; i < agents.length; i++) {
                  env.viewPanel.print1("counter=", ""+ counter++);
                  Agent agent = agents[i];
                  if (visualizeFlag){
                      panel.speedControl("Step loop", 1);
                      //                    if (mapVisualizeFlag) visualizeMap();
                      //                    visualizeAgentState(agent);
                  }

                  agent.takeAction();
                  agent.chooseAction();
                  agent.update();

                  if (visualizeFlag){
                      if (mapVisualizeFlag) visualizeMap();
                      visualizeAgentState(agent);
                  }
              }
              if (panel.button("Print all rule.q")) {
                  printAllruleQ();
              }
          }
          if (visualizeFlag){
              if (mapVisualizeFlag) endVisualizeMap();
          }
          for (int i = 0; i < agents.length; i++) {
              Agent agent = agents[i];
              if (extraMonteLearningFlag) {
                  Stack<Rule> ruleHistoryCopy = (Stack<Rule>)agent.ruleHistory.clone();
                  Stack<Float> rewardHistoryCopy = (Stack<Float>)agent.rewardHistory.clone();
                  Stack<Rule> callerHistoryCopy = (Stack<Rule>)agent.callerHistory.clone();         

                  agent.extraMonteLearning();

                  agent.ruleHistory = ruleHistoryCopy;
                  agent.rewardHistory = rewardHistoryCopy;
                  agent.callerHistory = callerHistoryCopy;
              }
              if (! sarsaLearningFlag) agent.monteLearning();
          }                    
//          if (extraMonteLearningFlag) {
//              for (int i = 0; i < agents.length; i++) {
//                  Agent agent = agents[i];
//                  agent.monteLearning();
//              }                    
//          }
          return currentTime;
      }
      public void visualizeAgentState(Agent agent){
          {
              String goalsLabel = "Goals of "+ agent.name;
              env.viewPanel.setText(goalsLabel, ""); // Clear text.
              for (int i = 0; i < agent.stack.size(); i++) {
                  // Print elements from bottom to top.
                  env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
              }
              env.viewPanel.println(goalsLabel, ""+ agent.oldG);
          }
          {
              String logLabel = "Log of "+ agent.name;
              env.viewPanel.println(logLabel, "---");
              env.viewPanel.println(logLabel, "world.counter = "+ world.counter);
              if (agent.failedFlag) env.viewPanel.println(logLabel, "Last action failed.");
              String s = "stack size="+ agent.stack.size()+ ":";
              for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                  // Add elements from top to bottom.
                  s += agent.stack.get(i)+ ", ";
              }
              env.viewPanel.println(logLabel, s);
              env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                      ", "+ agent.oldG);
              env.viewPanel.println(logLabel, ""+ agent.oldR);
          }
          String ruleLabel = "rule.q of "+ agent.name;
          env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
          env.viewPanel.resetGraphData(ruleLabel);
          agent.rules.forEach(r -> {
              env.viewPanel.plot(ruleLabel, r.q);
          });
//          for (int i = 0; i < agent.rules.size(); i++) {
//              env.viewPanel.scatterPlot(ruleLabel+ " learning", world.counter, agent.rules.get(i).q);
//          }
          if (extraMonteLearningFlag) {
              String monteRuleLabel = "rule.monteQ of "+ agent.name;
              env.viewPanel.scatterPlotFixedY(monteRuleLabel, 0, 0, -10, 0);// dummy
              env.viewPanel.resetGraphData(monteRuleLabel);
              agent.rules.forEach(r -> {
                  env.viewPanel.plot(monteRuleLabel, r.monteQ);
              });
//              for (int i = 0; i < agent.rules.size(); i++) {
//                  env.viewPanel.scatterPlot(monteRuleLabel+ " learning", world.counter, agent.rules.get(i).monteQ);
//              }
          }
      }
      
      
      //------------------------------------------------------
      //  access methods for the world state.
      //public Map<Room,Set<Object>> worldState;
      public void initRoomStates() {
          roomStates = new HashMap<Room,Set<Object>>();
          for (int i = 0; i < rooms.length; i++) {
              Set<Object> set = new HashSet<Object>();
              roomStates.put(rooms[i], set);
          }
      }
      public int numItems(Room room) {
          Lab.assertTrue(room != null);
          Set<Object> set = roomStates.get(room);
          if (set != null) {
              return set.size();
          } else {
              throw new Error();
          }
      }
      public boolean containsItem(Room room, Object item) {
          Lab.assertTrue(room != null);
          Set<Object> set = roomStates.get(room);
          if (set != null) {
              return set.contains(item);
          } else {
              throw new Error();
          }
      }
      public void removeItem(Room room, Object item) {
          Lab.assertTrue(room != null);
          Set<Object> set = roomStates.get(room);
          Lab.assertTrue(set.contains(item));
          if (set != null) {
              set.remove(item);
          } else {
              throw new Error();
          }
      }
      public void addItem(Room room, Object item) {
          Lab.assertTrue(room != null);
          Set<Object> set = roomStates.get(room);
          Lab.assertTrue(! set.contains(item));
          if (set != null) {
              set.add(item);
          } else {
              throw new Error();
          }
      }
      public Object findRandomItem(Room room) {
          Lab.assertTrue(room != null);
          Set<Object> set = roomStates.get(room);
          if (set != null) {
              Object[] items = set.toArray();
              if (items.length == 0) {
                  return null;
              } else {
                  return items[Lab.irand(items.length)];
              }
          } else {
              throw new Error();
          }
      }
      public String roomStatesToString() {
          StringBuffer buf = new StringBuffer();
          for (int i = 0; i < rooms.length; i++) {
              buf.append(rooms[i]+ ":");
              Set<Object> set = roomStates.get(rooms[i]);
              Object[] a = set.toArray();
              // TODO: 񏇂Ń\[g
              for (int j = 0; j < a.length; j++) {
                  buf.append(" "+ a[j]);
              }
              buf.append(System.getProperty("line.separator"));
          }
          return buf.toString();
      }

      //------------------------------------------------------

      public boolean checkImpassableRoutes(Room r1, Room r2) {
          for (int i = 0; i < world.impassableRoutes.length; i++) {
              Room[] pair = world.impassableRoutes[i];
              if (pair[0] == r1 && pair[1] == r2) return true;
          }
          return false;
      }
      
      //------------------------------------------------------

      public void visualizeMap(){
          if (panel.flag("Print Map", true)) printMap();
//          env.viewPanel.paint("Map", mapPainter);
          vCommands.clear();
      }
      
      public String lastMapString;
      public String printMapLabel = "World log";
      public int printMapRowSize = -1;
      // eGs\[h̍ŏɌĂ΂B
      public void startVisualizeMap(){
          lastMapString = "";
          if (panel.flag("Print Map", true)) {
              env.viewPanel.println(printMapLabel, "");

              lab.Lab.WTextArea c = (lab.Lab.WTextArea)env.viewPanel.findWComponent(printMapLabel);
              int rows = panel.getInt(printMapLabel+ " row size", 30, 10, 200);
              if (printMapRowSize != rows) {
                  printMapRowSize = rows;
                  // TCYύXꂽe̓ZbgB
                  c.setSize(rows, 80);
              }
              env.viewPanel.println(printMapLabel, "==========");
              env.viewPanel.println(printMapLabel, "Start episode.");
          }
      }
      public void endVisualizeMap(){
          if (panel.flag("Print Map", true)) {
              env.viewPanel.println(printMapLabel, "");
              env.viewPanel.println(printMapLabel, "End episode.");
              env.viewPanel.println(printMapLabel, "==========");
          }
      }
      public void printMap() {
          String str = world.roomStatesToString();
          boolean skipPrintMap = str.equals(lastMapString); 
          lastMapString = str;
          if (skipPrintMap && vCommands.size() == 0) {
              env.viewPanel.print(printMapLabel, ".");
          } else {
              env.viewPanel.println(printMapLabel, "");
              env.viewPanel.println(printMapLabel, "t="+ world.currentTime);
              if (vCommands.size() != 0) {
                  vCommands.forEach(com -> env.viewPanel.println(printMapLabel, " "+ com.toString()));
              }
              if (! skipPrintMap) {
                  env.viewPanel.print(printMapLabel, str);
              }
          }
      }
      public String allruleQLabel = "All rule.q";
      public String allruleMonteQLabel = "All rule.monteQ";
      public void printAllruleQ() {
          env.viewPanel.setText(allruleQLabel, "");
          for (int i = 0; i < agents.length; i++) {
              env.viewPanel.println(allruleQLabel, ""+ agents[i].name);
              env.viewPanel.println(allruleQLabel, "returnRule.q: "+ Rule.returnRule.q);
              env.viewPanel.println(allruleQLabel, "returnRule.base: "+ Rule.returnRule.base);
              env.viewPanel.println(allruleQLabel, "startRule.q: "+ Rule.startRule.q);
              env.viewPanel.println(allruleQLabel, "startRule.base: "+ Rule.startRule.base);
              env.viewPanel.println(allruleQLabel, "r.base:");
              for (int j = 0; j < agents[i].rules.size(); j++) {
                  Rule r = agents[i].rules.get(j);
                  env.viewPanel.println(allruleQLabel, j+ "\t"+ r.name+ "\t"+ r.base);
              }
              env.viewPanel.println(allruleQLabel, "");
              env.viewPanel.println(allruleQLabel, "r.q:");
              for (int j = 0; j < agents[i].rules.size(); j++) {
                  Rule r = agents[i].rules.get(j);
                  env.viewPanel.println(allruleQLabel, j+ "\t"+ r.name+ "\t"+ r.q);
              }
              env.viewPanel.println(allruleQLabel, "");
          }
          if (extraMonteLearningFlag) {
              env.viewPanel.setText(allruleMonteQLabel, "");
              for (int i = 0; i < agents.length; i++) {
                  env.viewPanel.println(allruleMonteQLabel, ""+ agents[i].name);
                  env.viewPanel.println(allruleMonteQLabel, "returnRule.monteQ: "+ Rule.returnRule.monteQ);
                  env.viewPanel.println(allruleMonteQLabel, "returnRule.monteBase: "+ Rule.returnRule.monteBase);
                  env.viewPanel.println(allruleMonteQLabel, "startRule.monteQ: "+ Rule.startRule.monteQ);
                  env.viewPanel.println(allruleMonteQLabel, "startRule.monteBase: "+ Rule.startRule.monteBase);
                  env.viewPanel.println(allruleMonteQLabel, "r.monateBase:");
                  for (int j = 0; j < agents[i].rules.size(); j++) {
                      Rule r = agents[i].rules.get(j);
                      env.viewPanel.println(allruleMonteQLabel, j+ "\t"+ r.name+ "\t"+ r.monteBase);
                  }
                  env.viewPanel.println(allruleMonteQLabel, "");
                  env.viewPanel.println(allruleMonteQLabel, "r.monteQ:");
                  for (int j = 0; j < agents[i].rules.size(); j++) {
                      Rule r = agents[i].rules.get(j);
                      env.viewPanel.println(allruleMonteQLabel, j+ "\t"+ r.name+ "\t"+ r.monteQ);
                  }
                  env.viewPanel.println(allruleMonteQLabel, "");
              }
          }
      }

      /**
       * fobOpɏóB
       */
      public void printWorldInfo() {
          System.out.println();
          System.out.println("mainCode = "+  AbstractMainCode.this.getClass().getName());
          System.out.println();

          for (int i = 0; i < agents.length; i++) {
              Agent a = agents[i];
              System.out.println("Rules for agent "+ a.name);
              for (int j = 0; j < a.rules.size(); j++) {
                  System.out.println(""+ a.rules.get(j));
              }
              System.out.println();
          }
          System.out.println();
      }
  }

  /** R}h */
  public static class VCommand {
      PrimitiveAction action;
      Object args[];
      public VCommand(PrimitiveAction action, Object... args) {
          this.action = action; this.args = args;
      }
      public String toString() {
          StringBuffer buf = new StringBuffer();
          buf.append(action+ "(");
          for (int i = 0; i < args.length; i++) {
              buf.append(args[i]+ ",");
          }
          buf.append(")");
          return buf.toString();
      }
  }
  

  //--------------------------------------------------
  // DSL for rule definition. 
  VariableN x = new VariableN("x");
  VariableN y = new VariableN("y");
  VariableN z = new VariableN("z");
  public static final String __ = Rule.WILDCARD; // Two underscores.
  public static final String PLS = Rule.PLS;
  public static final String NA = "NA".intern();
  public void checkTypeN(Object x, Class c) {
      checkObjectN(x);
      if (! (c.isInstance(x) || x == Rule.ZERO || x instanceof VariableN)) dslWarning("Not "+ c.getSimpleName()+ ": "+ x);
  }
  public void checkObjectN(Object x) {
      if (x instanceof StateN || x instanceof RegisterN || x instanceof ClauseN) {
          throw new Error("DSL Syntax Error: Not normal Object : "+ x);
      }
  }
  public void dslWarning(String s) {
      System.out.println("DSL Warning : "+ s);
  }
  /** ÂR[hėp邽߂̊֐B */
  public ClauseN c6(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
      //return new ClauseN(Situation.Usual, doWhat, who, o1, o2, where, when, true);
      checkObjectN(when);
      checkObjectN(where);
      checkObjectN(who);
      checkObjectN(doWhat);
      checkObjectN(o1);
      checkObjectN(o2);
      return c(doWhat, who, o1, o2, where, when, true);
  }
  public RegisterN a(Object conj, ClauseN c1, ClauseN c2) { return new RegisterN("a", conj, c1, c2); }
  public RegisterN a(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { return new RegisterN("a", conj, c1, c2, c3); }
  public RegisterN b(Object conj, ClauseN c1, ClauseN c2) {
      throw new Error("Not used.");
      //return new RegisterN("b", conj, c1, c2); 
  }
  public RegisterN e(Object conj, ClauseN c1, ClauseN c2) { return new RegisterN("e", conj, c1, c2); }
  public RegisterN e(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { return new RegisterN("e", conj, c1, c2, c3); }
  public RegisterN a6(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
      return new RegisterN("a", Conj.Simple, c6(when, where, who, doWhat, o1, o2), null); 
  }
  public RegisterN b6(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
      return new RegisterN("b", Conj.Simple, c6(when, where, who, doWhat, o1, o2), null); 
  }
  public RegisterN e6(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
      return new RegisterN("e", Conj.Simple, c6(when, where, who, doWhat, o1, o2), null); 
  }

  /** Obsolete */
  public RegisterN aR(Object who, Object doWhat) {
      return new RegisterN("a", Conj.Simple, c6(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
  }
  /** Obsolete */
  public RegisterN bR(Object who, Object doWhat) {
      return new RegisterN("b", Conj.Simple, c6(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
  }
  /** Obsolete */
  public RegisterN eR(Object who, Object doWhat) {
      return new RegisterN("e", Conj.Simple, c6(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
  }
  public RegisterN a(Object verb, Object subject) {
      return new RegisterN("a", Conj.Simple, c6(Time.Anytime, Room.Anywhere, subject, verb, 0, 0), null); 
  }
  public RegisterN b(Object verb, Object subject) {
      return new RegisterN("b", Conj.Simple, c6(Time.Anytime, Room.Anywhere, subject, verb, 0, 0), null);
  }
  public RegisterN e(Object verb, Object subject) {
      return new RegisterN("e", Conj.Simple, c6(Time.Anytime, Room.Anywhere, subject, verb, 0, 0), null);
  }

  public RegisterN a(Object doWhat) {
      return new RegisterN("a", Conj.Simple, c6(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
  }
  public RegisterN b(Object doWhat) {
      return new RegisterN("b", Conj.Simple, c6(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
  }
  public RegisterN e(Object doWhat) {
      return new RegisterN("e", Conj.Simple, c6(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
  }

  public RegisterN a(ClauseN c) {
      return new RegisterN("a", Conj.Simple, c, null); 
  }
  public RegisterN b(ClauseN c) {
      return new RegisterN("b", Conj.Simple, c, null); 
  }
  public RegisterN e(ClauseN c) {
      return new RegisterN("e", Conj.Simple, c, null); 
  }
  public static class RegisterNArgs {
      public Object conj;
      public ClauseN c1, c2, c3;
      public RegisterNArgs(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { 
          this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = c3;
      }
  }
  public RegisterN a(RegisterNArgs a) {
      return new RegisterN("a", a.conj, a.c1, a.c2, a.c3); 
  }
  public RegisterN b(RegisterNArgs a) {
      return new RegisterN("b", a.conj, a.c1, a.c2, a.c3); 
  }
  public RegisterN e(RegisterNArgs a) {
      return new RegisterN("e", a.conj, a.c1, a.c2, a.c3); 
  }

  // Clause definition with 7 args.
  public ClauseN c(Object v,Object s,Object o1,Object o2,Object l,Object t,Object p) {
      checkTypeN(v, Verb.class);
      checkTypeN(p, Boolean.class);
      //return new ClauseN(Situation.Usual, v, s, o1, o2, l, t, p); 
      return new ClauseN(Situation.Actual, v, s, o1, o2, l, t, p); 
      //if (! (p instanceof Boolean || p == Rule.ZERO || p instanceof VariableN)) dslWarning("Not Boolean : "+ p);
      //return c(Situation.Usual, v, s, o1, o2, l, t, p); 
  }
  // Clause definition with 4 args.
  public ClauseN c(Object v,Object s,Object o1,Object o2) {
      return c(v, s, o1, o2, 0, 0, true);
  }
  // Clause definition with 3 args.
  public ClauseN c(Object v,Object s,Object o1) {
      return c(v, s, o1, 0, 0, 0, true);
  }
  // Clause definition with 2 args.
  public ClauseN c(Object v,Object s) {
      return c(v, s, 0, 0, 0, 0, true);
  }
  // Clause definition with 1 args.
  public ClauseN c(Object v) {
      return c(v, 0, 0, 0, 0, 0, true);
  }

  // Macro definitions.
  // Change situation of the clause.
  public ClauseN Supports(Object sit, ClauseN c) {
      return new ClauseN(sit, c.v, c.s, c.o1, c.o2, c.l, c.t, c.p);
  }
  public ClauseN not(ClauseN c) {
      Boolean newP;
      if (c.p == Boolean.TRUE) {
          newP = false;
      } else if (c.p == Boolean.FALSE) {
          newP = true;
      } else {
          throw new Error("Macro \"Not\" could not operate the value : "+ c.p);
      }
      return new ClauseN(c.situation, c.v, c.s, c.o1, c.o2, c.l, c.t, newP);
  }
  public ClauseN changePolalityTrue(ClauseN c) {
      return new ClauseN(c.situation, c.v, c.s, c.o1, c.o2, c.l, c.t, true);
  }
  public ClauseN Whether(ClauseN c) {
      return new ClauseN(c.situation, c.v, c.s, c.o1, c.o2, c.l, c.t, PLS);
  }

  public ClauseN oldc2(Object who, Object doWhat) {
      return c6(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0); 
  }
  public StateN w(RegisterN a, RegisterN b, RegisterN e){
      if (! (a.regName.equals("a")
              && b.regName.equals("b")
              && e.regName.equals("e")
              )){
          throw new Error("Syntax error in w("+ a+ ", "+ b+ ", "+ e+ ")");
      }
      return new StateN(a, b, e);
  }
  // w(a(...), b(...)) or w(a(...), e(...))
  public StateN w(RegisterN a, RegisterN x){ 
      if (! a.regName.equals("a")){
          throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");
      } else if (x.regName.equals("b")) {
          return new StateN(a, x, null);
      } else if (x.regName.equals("e")) {
          return new StateN(a, null, x);
          //    } else if (x.regName.equals("v")) {
          //        return new StateN(a, null, null, x);
      } else {
          throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");          
      }
  }
  // w(a(...)) or w(b(...)) or w(e(...))
  public StateN w(RegisterN x){ 
      if (x.regName.equals("a")){
          return new StateN(x, null, null);
      } else if (x.regName.equals("b")) {
          return new StateN(null, x, null);
      } else if (x.regName.equals("e")) {
          return new StateN(null, null, x);
      } else {
          throw new Error("Syntax error in w("+ x+ ")");          
      }
  }
  public StateN w() {
      return new StateN(null, null, null);
  }
  public ActionN call(StateN s){ return new ActionN(Call, s); }
  public ActionN call(RegisterN s){ return new ActionN(Call, w(s)); }
  public ActionN tryCall(StateN s){ return new ActionN(Try, s); }
  public ActionN tryCall(RegisterN s){ return new ActionN(Try, w(s)); }
  public ActionN callm(RegisterN s){
      if (! s.regName.equals("a")) throw new Error("Argument of callm should be a(...)");
      return new ActionN(CallM, w(s));
  }
  //public ActionN call(VisualRegisterN v){ return new ActionN(VisualCall, w(v)); }
  public ActionN set(RegisterN s) { 
      if (s.regName.equals("a")) {
          return new ActionN(SetM, w(s));
          //return new ActionN(Set, w(s));
      } else {
          return new ActionN(Set, w(s));
      }
  }
  //public ActionN set(StateN s) { return new ActionN(Set, s); }
  
  public ActionN exit(RegisterN s) { return new ActionN(Exit, w(s)); }
  public ActionN exit(StateN s) { return new ActionN(Exit, s); }

  public ActionN recall(RegisterN s){
      if (! s.regName.equals("e")) throw new Error("Argument of recall should be e(...)");
      return new ActionN(Recall, w(s)); 
  }
  public ActionN recall(ClauseN c){ return new ActionN(Recall, w(e(Conj.Simple, c, null))); }
  /**
   * v~eBũp^n߂̎d|Ap~\B
   * p^ g ʂĂ킽B 
   */
  public ActionN primitive(PrimitiveAction prim, Object... args) {
      Object[] argv = new Object[6];
      Lab.assertTrue(args.length <= argv.length);
      for (int i = 0; i < argv.length; i++) argv[i] = 0; // default value
      for (int i = 0; i < args.length; i++) argv[i] = args[i];
      return new ActionN(prim, w(a(c(prim, argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]))));
  }
  public ActionN primitive(PrimitiveAction prim, StateN arg) {
      return new ActionN(prim, arg);
  }

  public ActionN findItem(Object what) { return findItemAction(1, what); }
  public ActionN findSecondItem(Object what) { return findItemAction(2, what); }
  public ActionN findItemAction(int regID, Object what) {
      return new ActionN(FindItem, w(a6(0,0,regID,0,what,0)));
  }

  public ClauseN varClause(String name) {
      VariableN[] a = new VariableN[WmIndex.A.C1.size];
      for (int i = 0; i < a.length; i++) {
          a[i] = new VariableN(name+ i);
      }
      return new ClauseN(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7]); 
  }
  public RegisterNArgs varRegisterNArgs(String name) {
      return new RegisterNArgs(new VariableN(name+ "_conj"),
              varClause(name+ "_c1_"),
              varClause(name+ "_c2_"),
              varClause(name+ "_c3_"));
  }

  // To define task goal. Usage: taskGoal(a(...));
  public void taskGoal(StateN x) {
      setRulesName("tg");
      StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
      rule(w(), tg, call(x));
      rule(x, tg, set(a(Verb.TaskCompleted)));
  }

  /**
   * Agent ƂɎs[WA̍ۂɈꎞIɓϐB
   */
  public List<RuleN> ruleList;
  public String rulesName = "";
  public int rulesI = 0;
  /**
   * fobOpɁA`s[ɂ킩₷OtB
   *  "t" ȂAȌ`s[ t1, t2, ... ƂOIɕtB
   */
  public void setRulesName(String s) {
      rulesName = s;
      rulesI = 0;
  }
  private void addRule1(StateN s, StateN g, ActionN a) {
      rulesI++;
      ruleList.add(new RuleN(rulesName+ "."+ rulesI, s, g, a));
  }
  // rule(s, g, call/set(...))
  public void rule(StateN s, StateN g, ActionN a){ addRule1(s, g, a); }
  public void rule(RegisterN s, StateN g, ActionN a){ addRule1(w(s), g, a); }
  // rule(s, g, Primitive)
  public void rule(StateN s, StateN g, PrimitiveAction a){ addRule1(s, g, new ActionN(a, null)); }
  public void rule(RegisterN s, StateN g, PrimitiveAction a){ addRule1(w(s), g, new ActionN(a, null)); }
  // rule(s, g, Primitive, s(...))
  public void rule(StateN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(s, g, new ActionN(a, arg)); }
  public void rule(RegisterN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(w(s), g, new ActionN(a, arg)); }

  /**
   * Agent ƂɎ錾ImA̍ۂɈꎞIɓϐB
   */
  public List<Rule> knowledgeList = new ArrayList<>();
  /**
   * Knowledge declaration.
   */
  public void k(RegisterN e) {
      // ̓sɂAm e  class Rule ̃CX^XɃGR[hĕێB
      if (! e.regName.equals("e")) throw new Error("Knowledge declaration: Usege: k(e(...));");
      rulesI++;
      RuleN ruleN = new RuleN("k-"+ rulesName+ rulesI,
              new StateN(null, null, e), 
              new StateN(null, null, null), 
              new ActionN(Set, w(e)));
      Rule r = new Rule(ruleN);
      knowledgeList.add(r);
      System.out.println("k: sharedKnowledgeBase.add: "+ r );
  }



  // End of DSL functions.

  // Methods for Task initialization.
  //
  public abstract Agent[] makeAgents(World world);
  /**
   * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
   * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
   * ݒ肷邱Ƃ\B
   */
  public void initAgentsTable(World world) {
      for (int i = 0; i < world.agents.length; i++) {
          Agent a = world.agents[i];
          ruleList = new ArrayList<>();
          addRules(world, i);
          a.rules = ruleList.stream().map(
                  ruleN ->  new Rule(ruleN)
                  ).collect(Collectors.toList());
          //        for (int j = 0; j < a.rules.size(); j++) {
          //            a.rules.get(j).name = j; // Use for debug.
          //        }

          // KvȂ q lBƂ肠Ô܂܂ƂB

          if (panel.flag("Add incorrect rules", false)) {
              addIncorrectRules(a);
          }
      }
  }
  public abstract void addRules(World world, int agentID);
  /*
   * KȂs[ǉBs[̉l̊wK@\̃eXgEfړIB
   */
  public void addIncorrectRules(Agent a) {
      // ruleList ݂̌̒lgāAȂs[쐬B
      List<RuleN> extraRuleList = new ArrayList<>();
      // es[ƂɁAANV Fail ɕςuԈs[vǉB
      int n = ruleList.size();
      ruleList.forEach(rule -> {
          extraRuleList.add(new RuleN("*"+ rule.name,
                  rule.s,
                  rule.g, 
                  new ActionN(NOP, null))
                  );
      });
      a.rules.addAll(extraRuleList.stream().map(
              ruleN ->  new Rule(ruleN)
              ).collect(Collectors.toList())
              );
  }

  /**
   * }bṽCAEg̐ݒB
   * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
   */
  public void setMap(World world) {
      //mapSizeX = 1;
      //mapSizeY = 1;
      world.rooms = new Room[]{ Room.Room1 };
      //world.map = new Room[mapSizeX * mapSizeY];
      //Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
  }
  // ̃}bv̐ݒBKvɉ setMap ̒ĂԁB
  public void setEmptyMap(World world) {
      //mapSizeX = 0;
      //mapSizeY = 0;
      world.rooms = new Room[]{};
      //world.map = new Room[mapSizeX * mapSizeY];
      //Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
  }
  /**
   * wK̃Gs\[hsƂ̏̃\bhōsB 
   */
  public abstract void initEpisode(World world); 

}




//------------------------------------------------------------------
//exit ΉsveXg̋ʐeNXB
public abstract static class TestPlanning extends AbstractMainCode {
  public Agent Alice; 
  public Agent[] makeAgents(World world) {
      Alice = new Agent("Alice", world); 
      return new Agent[] { Alice };
  }
  public RegisterNArgs A(ClauseN s, ClauseN g) {
      return new RegisterNArgs(Achieves, s, g, c6(0,0,0,0,0,0));
  }
  public RegisterNArgs B(ClauseN s, ClauseN sg, ClauseN g) {
      return new RegisterNArgs("B", s, sg, g);
  }
  public RegisterNArgs F(ClauseN s, ClauseN sg, ClauseN g) {
      return new RegisterNArgs("F", s, sg, g);
  }
  ClauseN cPLS = c6(__,__,PLS,PLS,__,__);

  public void addPlanningRules() {
      if (panel.flag("New Planning Template", true)) {
      ClauseN s = varClause("s");
      ClauseN a = varClause("a");
      ClauseN g = varClause("g");
      ClauseN x = varClause("x");
      ClauseN y = varClause("y");
      ClauseN sg = varClause("sg");
      ClauseN ssg = varClause("ssg");
      
      setRulesName("FPpan"); // Forward Planning
      // OAɂsv
      StateN fp = w(a(F(s,cPLS,g)));
      rule(w(a(Failed)), fp, exit(a(Failed))); // ʂ̗Onh
      // Start planning.
      rule(w(), fp, call(a(A(s,cPLS))));
      rule(w(a(A(s,sg))), fp, set(a(F(s,sg,sg))));
      // Loop. 
      rule(w(a(F(s,cPLS,sg))), fp, call(a(A(sg,cPLS))));
      rule(w(a(A(sg,ssg))), fp, recall(e(F(s,cPLS,sg))));
      rule(w(a(A(sg,ssg)), e(F(s,cPLS,sg))), fp, set(a(F(s,sg,ssg))));


      setRulesName("P/G");  // Plan and Go
      VariableN start = new VariableN("start");
      ClauseN roomS = c6(Now, start, Alice, Exists, 0, 0); 
      VariableN goal = new VariableN("goal");
      ClauseN roomG = c6(Now, goal, Alice, Exists, 0, 0); 
      StateN pg = w(a(roomG)); 
      // ̏ꏊ̔FEsvEsA[vB
      // sv悪 fail ꍇ͍ŏ̍s[蒼B
      rule(w(), pg, primitive(RecogRoom));
      rule(w(a(roomS)), pg, call(a(F(roomS,cPLS,roomG))));
      rule(w(a(F(roomS,a,roomG))), pg, call(a(a)));
      } else {
          ClauseN s = varClause("s");
          ClauseN a = varClause("a");
          ClauseN g = varClause("g");
          ClauseN x = varClause("x");
          ClauseN y = varClause("y");
          ClauseN sg = varClause("sg");
          ClauseN ssg = varClause("ssg");
          
          setRulesName("FPpan"); // Forward Planning
          // OAɂsv
          StateN fp = w(a(F(s,cPLS,g)));
          rule(w(a(Failed)), fp, exit(a(Failed))); // ʂ̗Onh
          // Start planning.
          rule(w(), fp, call(a(A(s,cPLS))));
          rule(w(a(A(s,sg))), fp, set(a(F(s,sg,sg))));
          // Loop. 
          rule(w(a(F(s,cPLS,sg))), fp, call(a(A(sg,cPLS))));
          rule(w(a(A(sg,ssg))), fp, recall(e(F(s,cPLS,sg))));
          rule(w(a(A(sg,ssg)), e(F(s,cPLS,sg))), fp, set(a(F(s,sg,ssg))));


          setRulesName("P/G");  // Plan and Go
          VariableN start = new VariableN("start");
          ClauseN roomS = c6(Now, start, Alice, Exists, 0, 0); 
          VariableN goal = new VariableN("goal");
          ClauseN roomG = c6(Now, goal, Alice, Exists, 0, 0); 
          StateN pg = w(a(roomG)); 
          // ̏ꏊ̔FEsvEsA[vB
          // sv悪 fail ꍇ͍ŏ̍s[蒼B
          rule(w(), pg, primitive(RecogRoom));
          rule(w(a(roomS)), pg, call(a(F(roomS,cPLS,roomG))));
          rule(w(a(F(roomS,a,roomG))), pg, call(a(a)));
          }
  }

  public static class S extends Room {
      public S(int id) {
          super("S"+ id);
      }
  }
}

//exit Ή̍sveXgP
//꒼̃}bvF r1->r2->r3->r4->5
public static class TestPlanning1 extends TestPlanning {
  ClauseN room1 = c6(Now, Room1, Alice, Exists, 0, 0); 
  ClauseN room2 = c6(Now, Room2, Alice, Exists, 0, 0); 
  ClauseN room3 = c6(Now, Room3, Alice, Exists, 0, 0); 
  ClauseN room4 = c6(Now, Room4, Alice, Exists, 0, 0); 
  ClauseN room5 = c6(Now, Room5, Alice, Exists, 0, 0);
  public void addRules(World world, int agentID) {
      
      addPlanningRules();

      setRulesName("Act");
      rule(w(a6(Now, Room1, Alice, Exists, 0, 0)), w(a6(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
      rule(w(a6(Now, Room2, Alice, Exists, 0, 0)), w(a6(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
      rule(w(a6(Now, Room3, Alice, Exists, 0, 0)), w(a6(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
      rule(w(a6(Now, Room4, Alice, Exists, 0, 0)), w(a6(Now, Room5, Alice, Exists, 0, 0)), primitive(GoToRoom, Room5));

      setRulesName("Inf");
      // ꂼ̃GA瓌ɂPړł邱Ƃuؖv鐄_KB
      rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
      rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room3))));
      rule(w(), w(a(A(room3,cPLS))), set(a(A(room3,room4))));
      rule(w(), w(a(A(room4,cPLS))), set(a(A(room4,room5))));
  }
  public void setMap(World world) {
      //mapSizeX = 5;
      //mapSizeY = 1;
      world.rooms = new Room[]{ 
              Room1,Room2,Room3,Room4,Room5, 
      };
      //world.map = new Room[mapSizeX * mapSizeY];
      //Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
  }

  public void initEpisode(World world) {
      world.agents[0].currentRoom = world.rooms[0];
      world.addItem(world.rooms[0], Alice);
      Agent agent = world.agents[0];
      if (Lab.rand() > panel.getFloat("G = Room3 or Room5", 1f, 0, 1)) {
          agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(room3)), Rule.WILDCARD);
      } else {
          agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(room5)), Rule.WILDCARD);
      }
  }
}


//exit Ή̍sveXgQ 
//room1->room2->room4, room1->room3->room4
public static class TestPlanning2 extends TestPlanning {
  ClauseN room1 = c6(Now, Room1, Alice, Exists, 0, 0); 
  ClauseN room2 = c6(Now, Room2, Alice, Exists, 0, 0); 
  ClauseN room3 = c6(Now, Room3, Alice, Exists, 0, 0); 
  ClauseN room4 = c6(Now, Room4, Alice, Exists, 0, 0);
  public void addRules(World world, int agentID) {

      addPlanningRules();

      setRulesName("Act");
      //rule(w(a(Failed)), w(a(Now, __, Alice, Exists, 0, 0)), exit(a(Failed)));
      rule(w(a6(Now, Room1, Alice, Exists, 0, 0)), w(a6(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
      rule(w(a6(Now, Room2, Alice, Exists, 0, 0)), w(a6(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
      rule(w(a6(Now, Room1, Alice, Exists, 0, 0)), w(a6(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
      rule(w(a6(Now, Room3, Alice, Exists, 0, 0)), w(a6(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));

      setRulesName("Inf");
      rule(w(), w(a(A(cPLS,cPLS))), exit(a(Failed)));
      rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
      rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room4))));
      rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room3))));
      rule(w(), w(a(A(room3,cPLS))), set(a(A(room3,room4))));
  }
  public void setMap(World world) {
      //mapSizeX = 4;
      //mapSizeY = 1;
      world.rooms = new Room[]{ 
              Room1,Room2,Room3,Room4, 
      };
      //world.map = new Room[mapSizeX * mapSizeY];
      //Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
  }

  public String impassableRoute = (String)panel.getSelectedValue("Impassable Routes", 
          new Object[] {"nothing", "r1->r2", "r2->r4"});
  public void initEpisode(World world) {
      world.agents[0].currentRoom = world.rooms[0];
      world.addItem(world.rooms[0], Alice);
      
      Agent agent = world.agents[0];
      agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
      agent.oldG = agent.newG = Rule.makeState(w(a(room4)), Rule.WILDCARD);
      switch (impassableRoute) {
      case "r1->r2":
          world.impassableRoutes = new Room[][] {{Room1, Room2}};
          break;
      case "r2->r4":
          world.impassableRoutes = new Room[][] {{Room2, Room4}};
          break;
      default:
          break;
      }
  }
}

//r1->r2->r3, r1->r4->r5
public static class TestPlanning3 extends TestPlanning {
  ClauseN room1 = c6(Now, Room1, Alice, Exists, 0, 0); 
  ClauseN room2 = c6(Now, Room2, Alice, Exists, 0, 0); 
  ClauseN room3 = c6(Now, Room3, Alice, Exists, 0, 0); 
  ClauseN room4 = c6(Now, Room4, Alice, Exists, 0, 0); 
  ClauseN room5 = c6(Now, Room5, Alice, Exists, 0, 0);
  public void addRules(World world, int agentID) {
      
      addPlanningRules();

      setRulesName("Act");
      rule(w(a6(Now, Room1, Alice, Exists, 0, 0)), w(a6(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
      rule(w(a6(Now, Room2, Alice, Exists, 0, 0)), w(a6(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
      rule(w(a6(Now, Room1, Alice, Exists, 0, 0)), w(a6(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
      rule(w(a6(Now, Room4, Alice, Exists, 0, 0)), w(a6(Now, Room5, Alice, Exists, 0, 0)), primitive(GoToRoom, Room5));

      setRulesName("Inf");
      rule(w(), w(a(A(cPLS,cPLS))), exit(a(Failed)));
      rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
      rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room3))));
      rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room4))));
      rule(w(), w(a(A(room4,cPLS))), set(a(A(room4,room5))));      
  }
  public void setMap(World world) {
      //mapSizeX = 5;
      //mapSizeY = 1;
      world.rooms = new Room[]{ 
              Room1,Room2,Room3,Room4,Room5, 
      };
      //world.map = new Room[mapSizeX * mapSizeY];
      //Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
  }

  public void initEpisode(World world) {
      world.agents[0].currentRoom = world.rooms[0];
      world.addItem(world.rooms[0], Alice);
      Agent agent = world.agents[0];
      if (Lab.rand() > panel.getFloat("G = Room3 or Room5", 0.5f, 0, 1)) {
          agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(room3)), Rule.WILDCARD);
      } else {
          agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(room5)), Rule.WILDCARD);
      }
  }
}


//------------------------------------------------------------------
//exit ΉsveXg̋ʐeNXB
public abstract static class TestSituation extends AbstractMainCode {
    public Agent Alice; 
    public Agent[] makeAgents(World world) {
        Alice = new Agent("Alice", world); 
        return new Agent[] { Alice };
    }
  //ClauseN cPLS = c6(__,__,PLS,PLS,__,__);
  ClauseN cPLS = c(__,__,PLS,PLS,__,__,PLS);

  // DSL macro
  // Sub-situation ss inherits from super-situation s.
  public ClauseN Inherits(Object s, Object ss) {
      return Supports(Situation.Usual, c(SuperSituation, s, ss));
  }
  // Clause c is assumed in situation ss that inherits from s. 
  public RegisterNArgs Assumed(Object s, Object ss, ClauseN c) {
      checkTypeN(s, Situation.class);
      checkTypeN(ss, Situation.class);
      return new RegisterNArgs(And, Inherits(s, ss), Supports(ss, c), null);
  }
  // Clause c is proved by contradiction.
  public RegisterNArgs PbyC(ClauseN c) {
      return new RegisterNArgs(PbyC, c, null, null);
  }
}
//w@
public static class TestSituation1 extends TestSituation {
  public void addRules(World world, int agentID) {
      if (false) {
          setRulesName("DSL-test");
          // type check test
          rule(w(), w(), set(a(Exists, Alice)));
          //rule(w(), w(), set(a(Alice, Exists)));
          //rule(w(), w(), set(a(Exists, Alice, 0, 0, Here, Now, true)));
          //rule(w(), w(), set(a(Exists, Alice, 0, 0, Here, Now, true))); // not defined a(7)
          //rule(w(), w(), set(a(c(Alice, Exists, 0, 0, Here, Now, true))));
          rule(w(), w(), set(a(c(Alice, Exists, 0, 0, Here, Now, 0))));
          rule(w(), w(), set(a(c(Exists, Alice, 0, 0, Here, Now, x))));
          rule(w(), w(), set(a(c(Exists, Alice, 0, 0, Here, Now, 1))));
          rule(w(), w(), set(a(Supports(Situation.Usual, c(Exists, Alice, 0, 0, Here, Now, true)))));
          //rule(w(), w(), set(a(Situation.Usual, c(Exists, Alice, 0, 0, Here, Now, true)))); // 
      }
      // w@ŏؖTu[`B
      {
          VariableN s = new VariableN("s"); // situation
          VariableN ss = new VariableN("ss"); // sub-situation of s
          ClauseN c = varClause("c");     // clause
          //  PbyC ̎ł͋ɐ true ł閽肾󂯕tB
          ClauseN g = changePolalityTrue(varClause("g"));     // goal

          //  Proof by Contradiction
          setRulesName("pbcg");
          StateN pbcg = w(a(PbyC(Supports(s,g))));  // s |= g
          rule(w(), pbcg, call(a(Assumed(s, PLS, not(g)))));
          rule(w(a(Assumed(s, ss, not(g)))), pbcg, set(a(Supports(ss, not(g)))));
          rule(w(a(Supports(ss, not(g)))), pbcg, call(a(Supports(ss, c(Contradiction)))));
          rule(w(a(Supports(ss, c(Contradiction)))), pbcg, recall(e(Assumed(s, ss, not(g)))));
          rule(w(a(Supports(ss, c(Contradiction))), e(Assumed(s, ss, not(g)))),
                  pbcg, set(a(PbyC(Supports(s,g)))));
          
          // s p ss Ő c B
          StateN ag = w(a(Assumed(s, PLS, c)));
          setRulesName("ag");
          rule(w(), ag, primitive(NewSituation,s)); // call primitive
          rule(w(a(Inherits(s, ss))), ag, set(a(Supports(ss, c))));
          rule(w(a(Supports(ss, c))), ag, recall(e(Inherits(s, ss))));
          rule(w(a(Supports(ss, c)), e(Inherits(s, ss))), ag, set(a(Assumed(s, ss, c))));
      }
      // eXgp^XN
      {
          // Verb (predicates)
          Object C = "C"; // The chocolate exits.
          Object A = "A"; // Someone ate the chocolate.
          Object G = "G"; // Garbage, chocolate wrappers, in the trash can.

          // Called from PbyC to prove Contradiction.  
          VariableN s = new VariableN("s"); // situation
          VariableN ss = new VariableN("ss"); // sub-situation
          k(e(If, Supports(ss, not(c(A))), Supports(ss, not(c(G))))); // ss|=not A -> ss|=not G
          setRulesName("cg");
          StateN cg = w(a(Supports(ss, c(Contradiction))));
          rule(w(a(Supports(ss, not(c(A))))), cg, 
                  recall(e(If, Supports(ss, not(c(A))), Supports(ss, cPLS))));
          rule(w(a(Supports(ss, not(c(A)))), e(If, Supports(ss, not(c(A))), Supports(ss, not(c(G))))), cg,
                  set(a(Supports(ss, not(c(G))))));
          rule(w(a(Supports(ss, not(c(G))))), cg, call(a(Supports(ss, c(G)))));
          rule(w(a(Supports(ss, c(G)))), cg, recall(e(Supports(ss, not(c(G))))));
          rule(w(a(Supports(ss, c(G))), e(Supports(ss, not(c(G))))), cg, set(a(Supports(ss, c(Contradiction)))));

          k(e(Supports(Situation.Actual, c(G))));
          setRulesName("ssgg");
          StateN ssgg = w(a(Supports(ss, c(G))));
          rule(w(), ssgg, recall(e(Inherits(PLS, ss))));
          rule(w(e(Inherits(s, ss))), ssgg, set(a(Inherits(s, ss))));
          rule(w(a(Inherits(s, ss)), e(Inherits(s, ss))),  ssgg, recall(e(Supports(s, c(G)))));
          rule(w(a(Inherits(s, ss)), e(Supports(s, c(G)))), ssgg, set(a(Supports(ss, c(G)))));

          
          //            // `R[gNHׂǂm肽B
//          ClauseN ca = Supports(Situation.Actual, c(A));
//          StateN wag = w(a(Whether(ca))); // To know whether someone ate the chocolate.
//          setRulesName("wag");
//          rule(w(), wag, call(a(PbyC(ca))));
//          rule(w(a(PbyC(ca))), wag, set(a(ca)));
//          taskGoal(ca);

          // w@ɂA`R[gHׂꂽƂؖB
          taskGoal(w(a(PbyC(Supports(Situation.Actual, c(A))))));
          
          // Test
          {
              //rule(w(), cg, set(a(not(c(A)))));
              //taskGoal(w(a(Supports(Situation.Usual, c(G))))); // ssg
              //taskGoal(w(a(Supports(Situation.Usual, c(Contradiction))))); // cg
          }
      }
  }

  public void initEpisode(World world) {
      world.agents[0].currentRoom = world.rooms[0];
      world.addItem(world.rooms[0], Alice);
  }
}

//ꍇ
public static class TestSituation2 extends TestSituation {
  public RegisterNArgs Case(Object s, Object ss, ClauseN a, ClauseN p) {
      checkTypeN(s, Situation.class);
      checkTypeN(ss, Situation.class);
      return new RegisterNArgs(Case, Inherits(s, ss), a, p);
  }
  public void addRules(World world, int agentID) {
   // Tu[`
   {
       VariableN s = new VariableN("s"); // situation
       VariableN ss = new VariableN("ss"); // sub-situation of s
       ClauseN c = varClause("c");     // clause
       // ̎ł͋ɐ true ł閽肾󂯕tB
       ClauseN g = changePolalityTrue(varClause("g"));     // goal

       // case
       StateN cgg = w(a(Case(s, PLS, c, g))); // c : assumption, g : goal
       setRulesName("cgg");
       rule(w(), cgg, call(a(Assumed(s,PLS,c))));
       rule(w(a(Assumed(s,ss,c))), cgg, set(a(Supports(ss,c))));
       rule(w(a(Supports(ss,c))), cgg, call(a(Supports(ss,g))));
       rule(w(a(Supports(ss,g))), cgg, recall(e(Assumed(s,ss,c))));
       rule(w(a(Supports(ss,g)), e(Assumed(s,ss,c))), cgg, set(a(Case(s, ss, c, g))));
               
       // s p ss Ő c B
       StateN ag = w(a(Assumed(s, PLS, c)));
       setRulesName("ag");
       rule(w(), ag, primitive(NewSituation,s)); // call primitive
       rule(w(a(Inherits(s, ss))), ag, set(a(Supports(ss, c))));
       rule(w(a(Supports(ss, c))), ag, recall(e(Inherits(s, ss))));
       rule(w(a(Supports(ss, c)), e(Inherits(s, ss))), ag, set(a(Assumed(s, ss, c))));
   }
   // eXgp^XN
   {
       VariableN s = new VariableN("s"); // situation
       VariableN ss = new VariableN("ss"); // sub-situation of s
       //VariableN ss1 = new VariableN("ss1"); // sub-situation of s
       //VariableN ss2 = new VariableN("ss2"); // sub-situation of s
       // Verb (predicates)
       ClauseN S = c("S");  // I need to go to school.
       ClauseN R = c("R");  // It's raining.
       ClauseN E1 = c("E1");  // An event E1 will be held.
       ClauseN E2 = c("E2");  // An event E2 will be held.

       // wZɍsׂؖB
       StateN cg = w(a(Supports(s, S)));
       setRulesName("cg");
       rule(w(), cg, call(a(Case(s, PLS, R,S))));
       rule(w(a(Case(s, __, R,S))), cg, call(a(Case(s, PLS, not(R),S))));
       rule(w(a(Case(s, __, not(R),S))), cg, recall(e(Case(s, PLS, R,S))));
       rule(w(a(Case(s, __, not(R),S)), e(Case(s, __, R,S))), cg, set(a(Supports(s,S))));         
//       rule(w(a(Case(s, ss1, R,S))), cg, call(a(Case(s, PLS, not(R),S))));
//       rule(w(a(Case(s, ss2, not(R),S))), cg, recall(e(Case(s, PLS, R,S))));
//       rule(w(a(Case(s, ss2, not(R),S)), e(Case(s, ss1, R,S))), cg, set(a(Supports(s,S))));         

       //̈m
       RegisterN ssR = a(Supports(ss, R));
       RegisterN ssNotR = a(Supports(ss, not(R)));
       RegisterN ssE1 = a(Supports(ss, E1));
       RegisterN ssE2 = a(Supports(ss, E2));
       RegisterN ssS = a(Supports(ss, S));
       
       setRulesName("ssSg");
       rule(w(ssR), w(ssS), set(ssE1));
       rule(w(ssE1), w(ssS), set(ssS));
       rule(w(ssNotR), w(ssS), set(ssE2));
       rule(w(ssE2), w(ssS), set(ssS));
       
       // Does not work !
       Situation Flood = new Situation("Flood", Situation.Usual);
       rule(w(a(Supports(Flood, R))), w(a(Supports(Flood, S))), set(a(Supports(Flood, not(E1)))));
       
       //
       if(panel.flag("Case Flood", false)) {
           taskGoal(w(a(Supports(Flood, S))));
       } else {
           taskGoal(w(a(Supports(Situation.Actual, S))));
       }
   }
}

public void initEpisode(World world) {
   world.agents[0].currentRoom = world.rooms[0];
   world.addItem(world.rooms[0], Alice);
}
}


//-----------------------------------------------------------
public abstract static class TestEnv extends AbstractMainCode {
    public Agent Alice; 
    public Agent[] makeAgents(World world) {
        Alice = new Agent("Alice", world); 
        return new Agent[] { Alice };
    }
    public void addPrimitiveRules(World world, int agentID) {
        VariableN r = new VariableN("r");
        
        setRulesName("prim");
    
        rule(w(),
                w(a(c(LookingAt,Alice,PLS,0,PLS,Now,PLS))), FindItem);
        rule(w(a(c(AppliedO1ToO2,Alice,__,__,__,Now,true))),
                w(a(c(LookingAt,Alice,x,0,PLS,Now,PLS))), FindItem);

        rule(w(),
                w(a(c(LookingAt2,Alice,x,PLS,r,Now,true))), 
                call(a(c(LookingAt,Alice,x,0,r,Now,PLS)))); // ȂH
        rule(w(a(c(LookingAt,Alice,x,0,r,Now,true))),
                w(a(c(LookingAt2,Alice,x,PLS,r,Now,PLS))), FindSecondItem);

        rule(w(a(c(LookingAt2,Alice,x,y,r,Now,true))),
                w(a(c(AppliedO1ToO2,Alice,x,y,r,Now,true))), Apply);

        rule(w(a(c(LookingAt,Alice,Nut,0,r,Now,true))), 
                w(a(c(Ate,Alice,Nut,0,r,Now,true))), Eat);

        rule(w(), 
                w(a(c(Exists,PLS,0,0,PLS,Now,true))), RecogRoom);

        rule(w(), 
                w(a(c(CameFrom,Alice,PLS,0,PLS,Now,true))), GoToRoom);

        rule(w(a(c(LookingAt,Alice,x,0,r,Now,true))), 
                w(a(c(BroughtO1FromO2,Alice,x,r,PLS,Now,true))), Bring);
    }
}

//΂kɂԂďoĂHׂ^XNB
public static class TestEnv1 extends TestEnv {
    public void addRules(World world, int agentID) {
        addPrimitiveRules(world, agentID);
        
        StateN s1 = w(a(c(LookingAt,Alice,Stone,0,Room1,Now,true)));
        StateN s2 = w(a(c(LookingAt2,Alice,Stone,Nutshell,Room1,Now,true)));
        StateN s3 = w(a(c(AppliedO1ToO2,Alice,Stone,Nutshell,Room1,Now,true)));
        StateN s4 = w(a(c(LookingAt,Alice,Nut,0,Room1,Now,true)));
        StateN g = w(a(c(Ate,Alice,Nut,0,Room1,Now,true)));
        taskGoal(g);
        
        setRulesName("g");
        rule(w(), g, call(s1));
        rule(s1, g, call(s2));
        rule(s2, g, call(s3));
        rule(s3, g, call(s4));
        //rule(s4, g, call(g));
//        rule(w(a(c(LookingAt,Alice,Stone,0,x,Now,true))), g, findSecondItem(Nutshell));
//        rule(w(a(c(LookingAt2,Alice,Stone,Nutshell,x,Now,true))), g, ApplyItToO1);
//        rule(w(a(c(AppliedO1ToO2,Alice,Stone,Nutshell,x,Now,true))), g, findItem(Nut));
//        rule(w(a(c(Exists,Nut,0,0,x,Now,true))), g, EatIt);
    }
    public void initEpisode(World world){
        world.agents[0].currentRoom = Room1;
        world.addItem(world.rooms[0], Alice);
        world.addItem(world.rooms[0], Grass);
        world.addItem(world.rooms[0], Stone);
        world.addItem(world.rooms[0], Nutshell);
    }
}

//ʂ̕ɕ̂ĂeXgvOB
public static class TestEnv2 extends TestEnv {
    public void addRules(World world, int agentID) {
        addPrimitiveRules(world, agentID);

        StateN s1 = w(a(c(Exists,Alice,0,0,Room1,Now,true)));
        StateN s2 = w(a(c(CameFrom,Alice,Room1,0,Room2,Now,true)));
        StateN s3 = w(a(c(LookingAt,Alice,Stone,0,Room2,Now,true)));
        StateN s4 = w(a(c(BroughtO1FromO2,Alice,Stone,Room2,Room3,Now,true)));
        StateN s5 = w(a(c(LookingAt,Alice,Stone,0,Room3,Now,true)));
        StateN s6 = w(a(c(LookingAt2,Alice,Stone,Nutshell,Room3,Now,true)));
        StateN s7 = w(a(c(AppliedO1ToO2,Alice,Stone,Nutshell,Room3,Now,true)));
        StateN s8 = w(a(c(LookingAt,Alice,Nut,0,Room3,Now,true)));
        StateN g = w(a(c(Ate,Alice,Nut,0,Room3,Now,true)));
        taskGoal(g);

        setRulesName("g");
        rule(w(), g, call(s1));
        rule(s1, g, call(s2));
        rule(s2, g, call(s3));
        rule(s3, g, call(s4));
        rule(s4, g, call(s5));
        rule(s5, g, call(s6));
        rule(s6, g, call(s7));
        rule(s7, g, call(s8));
        //rule(s8, g, call(g));
//        rule(w(), g, RecogRoom);
//        rule(w(a(c(Exists,Alice,0,0,Room1,Now,true))), g, primitive(GoToRoom, Room2));
//        rule(w(a(c(Exists,Alice,0,0,Room2,Now,true))), g, findItem(Stone));
//        rule(w(a(c(Exists,Stone,0,0,Room2,Now,true))), g, call(tookg));
//        rule(tookg, g, findItem(Stone));
//        rule(w(a(c(Exists,Stone,0,0,Room3,Now,true))), g, findSecondItem(Nutshell));
//        rule(w(a(c(Exists,Stone,Nutshell,0,Room3,Now,true))), g, ApplyItToO1);
//        rule(w(a(c(AppliedO1ToO2,Alice,Stone,Nutshell,Room3,Now,true))), g, findItem(Nut));
//        rule(w(a(c(Exists,Nut,0,0,Room3,Now,true))), g, EatIt);

    }
    public void setMap(World world) {
        world.rooms = new Room[]{ Room1,  Room2 ,  Room3 };
    }
    public void initEpisode(World world){ 
        world.agents[0].currentRoom = Room1;
        world.addItem(world.rooms[0], Alice);
        world.addItem(world.rooms[0], Grass);
        world.addItem(world.rooms[1], Stone);
        world.addItem(world.rooms[1], Grass);
        world.addItem(world.rooms[2], Nutshell);
        world.addItem(world.rooms[2], Grass);
    }
}

//  Key  Box g{̃eXgvOB
public static class TestXEnv3 extends TestEnv {
  public void addRules(World world, int agentID) {
      addPrimitiveRules(world, agentID);
      
      StateN s1 = w(a(c(CameFrom,Alice,Room1,0,Room2,Now,true)));
      StateN s2 = w(a(c(LookingAt,Alice,Key,0,Room2,Now,true)));
      StateN s3 = w(a(c(BroughtO1FromO2,Alice,Key,Room2,Room3,Now,true)));
      StateN s4 = w(a(c(LookingAt,Alice,Key,0,Room3,Now,true)));
      StateN s5 = w(a(c(LookingAt2,Alice,Key,Box,Room3,Now,true)));
      StateN s6 = w(a(c(AppliedO1ToO2,Alice,Key,Box,Room3,Now,true)));
      StateN g = w(a(c(LookingAt,Alice,Gold,0,Room3,Now,true)));
      taskGoal(g);
      
      setRulesName("g");
      rule(w(), g, call(s1));
      rule(s1, g, call(s2));
      rule(s2, g, call(s3));
      rule(s3, g, call(s4));
      rule(s4, g, call(s5));
      rule(s5, g, call(s6));
      //rule(s6, g, call(g));
  }
  public void setMap(World world) {
      world.rooms = new Room[]{ Room1,  Room2 ,  Room3 };
  }
  public void initEpisode(World world){ 
      world.agents[0].currentRoom = Room1;
      world.addItem(world.rooms[0], Alice);
      world.addItem(world.rooms[1], Key);
      world.addItem(world.rooms[2], Box);
      //world.addItem(world.rooms[2], Stone); // test
  }
}

//Key  Box ̃^XNB葽̏󋵂ɓKp\ȃvOB
public static class TestXEnv4 extends TestEnv {
    public void addRules(World world, int agentID) {
        addPrimitiveRules(world, agentID);
        VariableN r1 = new VariableN("r1");
        VariableN r2 = new VariableN("r2");

        StateN g = w(a(c(LookingAt,Alice,Gold,0,PLS,Now,true)));
        taskGoal(g);

        //main
        setRulesName("g");
        rule(w(), g, call(a(c(LookingAt2,Alice,Key,Box,PLS,Now,true))));
        rule(w(a(c(LookingAt2,Alice,Key,Box,r1,Now,true))),
                g, call(a(c(AppliedO1ToO2,Alice,Key,Box,r1,Now,true))));
        
        //
        StateN l2g = w(a(c(LookingAt2,Alice,x,y,PLS,Now,true)));
        setRulesName("l2g");
        rule(w(), l2g, call(a(c(LookingAt,Alice,x,0,PLS,Now,PLS))));
        setRulesName("l2g1");
        rule(w(a(c(LookingAt,Alice,x,0,r1,Now,true))), l2g, 
                call(a(c(LookingAt2,Alice,x,y,r1,Now,PLS))));
        // If y found, return from l2g,
        // otherwise:
        rule(w(a(c(LookingAt2,Alice,x,y,r1,Now,false))), l2g,
                call(a(c(Exists,y,0,0,PLS,Now,true))));
        rule(w(a(c(Exists,y,0,0,r2,Now,true))), l2g, 
                recall(e(c(LookingAt,Alice,x,0,PLS,Now,true))));
        rule(w(a(c(Exists,y,0,0,r2,Now,true)),
                e(c(LookingAt,Alice,x,0,r1,Now,true))),
                l2g,
                call(a(c(BroughtO1FromO2,Alice,x,r1,r2,Now,true))));
        // Goto the first rule.
        
        setRulesName("l2g2");
        rule(w(a(c(LookingAt,Alice,x,0,r1,Now,false))), l2g,
                call(a(c(Exists,x,0,0,PLS,Now,true))));
        rule(w(a(c(Exists,x,0,0,r1,Now,true))), l2g, 
                call(a(c(CameFrom,Alice,__,0,r1,Now,true))));
        // Goto the first rule.
        
        // Take x from r1 to r2. 
        StateN bg = w(a(c(BroughtO1FromO2,Alice,x,r1,r2,Now,true)));
        setRulesName("bg");
        rule(w(a(c(Exists,y,0,0,r2,Now,true)),
                e(c(LookingAt,Alice,x,0,r1,Now,true))),
                bg,
                set(a(c(LookingAt,Alice,x,0,r1,Now,true))));
        // After, the execution of primitive TakeO1, goto the first rule.
        
        // Infer where x is.
        setRulesName("wg");
        rule(w(), w(a(c(Exists,Key,0,0,PLS,Now,true))), 
                set(a(c(Exists,Key,0,0,Room2,Now,true))));
        rule(w(), w(a(c(Exists,Box,0,0,PLS,Now,true))), 
                set(a(c(Exists,Box,0,0,Room3,Now,true))));
      }
      public void setMap(World world) {
        world.rooms = new Room[]{ Room1,  Room2 ,  Room3 };
      }
      public void initEpisode(World world){ 
        world.agents[0].currentRoom = Room1;
        world.addItem(world.rooms[0], Alice);
        world.addItem(world.rooms[1], Key);
        world.addItem(world.rooms[2], Box);
        //world.addItem(world.rooms[2], Stone); // test
      }
}

//Default dummy task.
public static class Demo0_Dummy extends AbstractMainCode {
  public Agent[] makeAgents(World world) { return new Agent[] {}; }
  public void addRules(World world, int agentID){
      throw new StopPressed();
  }
  public void initEpisode(World world){ throw new Error(); }
}
}
