//Copyright (c) 2024 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

ELŔ\eB

ꐙTu,cG,l,|,쐒,
eJ RGoal ASỶ,
26 lHm\w ėplHm\(SIG-AGI), 2024.


TODO: 
E AzL͖̎ߋ̃R[hėpĂB蒼ׂB
E Gs\[hL̑zN͍łV̂I邪A_ɂׂB
E 錾ILEGs\[hL̃p^[}b`ASY̏ڍ׎dlׂ͌B

*/


package tmm1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;

import static tmm1.TMM3v11.PrimitiveAction.*;
import static tmm1.TMM3v11.Item.*;
import static tmm1.TMM3v11.Conj.*;
import static tmm1.TMM3v11.Time.*;
import static tmm1.TMM3v11.Room.*;
import static tmm1.TMM3v11.Verb.*;


import lab.Lab;
import lab.Lab.LabCode;
import lab.Lab.StopPressed;
import tmm1.TMM3v10.Rule;

public class TMM3v11 {
  public static void main(String[] args) {
      Lab.addSelectableClass(TMM3v11.class);
      System.out.println(Lab.selectableClasses + "");

      LabCode labCode = new LabCode();
      labCode.main(AbstractMainCode.class);
  }

  //For debug.
  public static void printArray(String s, Object[] a) {
      System.out.print(s+ ": ");
      for (int i = 0; i < a.length; i++) {
          System.out.print(a[i]+ ",");
      }
      System.out.println();
  }

  /**
   * Primitive actions 
   */
  public static enum PrimitiveAction {
      SetWithCost1,
      SetWithCost2,
      SetWithCost3,
      SetWithCost4,
      //
      EatO1,
      ApplyO1toO2,
      GoDir,
      GoToRoom,
      TakeO1ToO2,
      //
      RecogRoom,
      FindItem,
      Try,
      Call,
      Return,
      Exit,
      Set,
      CallM,
      SetM,
      Recall,
      SayIt,
      Listen,
      NOP,
      Fail,
  }
  /**
   *  Working memory layout definition
   * 
   *     |     A     |     E     |
   *      ^ WmIndex.A.head   
   *                  ^ WmIndex.E.head   
   *      <----------> WmIndex.A.size
   *      <----------------------> WmIndex.size
   */
  public static class WmIndex {
      public static final RegisterIndex A;
      //public static final RegisterIndex B;
      public static final RegisterIndex E;
      public static final int size;
      static {
          int i = 0;
          A = new RegisterIndex(i); i += A.size;
          //B = new RegisterIndex(i); i += B.size;
          E = new RegisterIndex(i); i += E.size;
          size = i;
      }
      public static boolean printRawFlag = false; /** WX^̒l𐶂̃xNg܂ print */
      public static final String valuesToString(Object[] values) {
          if (values.length == WmIndex.size) {
              Object e = filledObject(values, 0, values.length);
              if (e != null) {
                  return "w("+ e+ ")";
              } else {
                  return "w("+ WmIndex.A.valuesToString(values, "a")+ " "+
                          WmIndex.E.valuesToString(values, "e")+ " "+
                          ")";
              }
          } else if (values.length == WmIndex.A.size) {
              return WmIndex.A.valuesToString(values, "r");
          } else if (values.length == WmIndex.size * 2) {
              Object[] s = new Object[WmIndex.size];
              Object[] g = new Object[WmIndex.size];
              for (int i = 0; i < s.length; i++) {
                  s[i] = values[i];
                  g[i] = values[i + WmIndex.size];
              }
              return "s("+ WmIndex.valuesToString(s)+ ") g("+ WmIndex.valuesToString(g)+ ")"; 
          } else {
              throw new Error("valuesToString: "+ values);
          }
      }
      public static final Object filledObject(Object[] values, int start, int end) {
          Object e = values[start];
          for (int i = start+1; i < end; i++) {
              if (values[i] != e) return null;
          }
          return e;
      }
      public static final String valuesToString(Object[] values, int start, int end) {
          Object e = WmIndex.filledObject(values, start, end);
          if (e != null) {
              return e.toString();
          } else {
              StringBuffer buf = new StringBuffer();
              buf.append(values[start]);
              for (int i = start+1; i < end; i++) {
                  buf.append(' ');
                  buf.append(values[i]);
              }
              return buf.toString();
          }
      }
  }
  public static class RegisterIndex {
      public final int head;
      public final int headerSize;
      public final int size;
      public final int Conj;
      public ClauseIndex C1; 
      public ClauseIndex C2; 
      public ClauseIndex C3; 
      public RegisterIndex(int offset) {
          head = offset;
          int i = 0;
          Conj = offset + i;  i++;
          headerSize = i;
          C1 = new ClauseIndex(offset + i); i += C1.size;
          C2 = new ClauseIndex(offset + i); i += C2.size;
          C3 = new ClauseIndex(offset + i); i += C3.size;
          size = i;
      }
      public String valuesToString(Object[] values, String regName) {
          Object e = WmIndex.filledObject(values, head, head+size);
          if (e != null) {
              return regName+ "("+ e+ ")";
          } else {
              return regName+ "("+
                      values[Conj]+ " "+
                      this.C1.valuesToString(values, "c1")+ " "+
                      this.C2.valuesToString(values, "c2")+ " "+
                      this.C3.valuesToString(values, "c3")+
                      ")";
          }
      }
  }
  public static class ClauseIndex {
      public final int When, Where, Who, DoWhat, O1, O2;
      public final int head;
      public final int size;
      public ClauseIndex(int offset) {
          head = offset;
          int i = 0;
          When    = offset + i++; 
          Where   = offset + i++;
          Who     = offset + i++;
          DoWhat  = offset + i++;
          O1      = offset + i++;
          O2      = offset + i++;
          size = i;
      }
      public String valuesToString(Object[] values, String name) {
          return name+ "("+ WmIndex.valuesToString(values, head, head+size)+ ")";
      }
  }

  //TODO: ΎɂׂB
  public static enum Time {
      Today,
      Yesterday,
      Anytime,
      Now,
  }
  public static enum Item {
      Wall("\u58c1"),  // 
      //Stone(""), // 
      //Shell("<>"), // k
      //Nut("o "), // 
      //Grass("h"), // 
      Alice("`"),  // Fist generic agent.
      Bob("a"),  //  Second generic agent.
      Carol("b"),  //  Third generic agent.
      Stone(""), // 
      Shell("k"), // k
      Nut(""), // 
      Grass(""), // 
      Scissors(""), // 
      //Meat(""), // 
      Nothing(""), // 
      Wh("Wh"), // wh-word for questions
      //
      Space("E"); // E

      public final String code;
      private Item(String code){
          this.code = code;
      }
  }
  
  public static class Box {
      public String name;
      public Object content = null;
      public Box(String name) { this.name = name; }
      public String toString() { return name+ "("+ content+ ")"; }
      public static final Box Box1 =new Box("Box1"); 
      public static final Box Box2 =new Box("Box2"); 
      public static final Box Box3 =new Box("Box3"); 
  }
  public static class Key {
      public String name;
      public Key(String name) { this.name = name; }
      public String toString() { return name; }
      public static final Key Key1 =new Key("Key1"); 
      public static final Key Key2 =new Key("Key2"); 
      public static final Key Key3 =new Key("Key3"); 
  }

  public static enum Conj {
      Simple,
      SaysThat,
      And,
      While,
      If,
      ThatO1,
      ThatO2,
      Achieves,
      Causes,  
  }
  public static enum Verb {
      Is,
      Has,
      Ate,
      CanNotEat,
      WantToTakeO1ToO2,
      WantToApplyO1ToO2,
      AppliedO1ToO2,
      CanNotApply,
      IsAwareOf,
      IsAwareOfNo, // ꎞI
      FindsNothing,
      Thanks,
      Knows,
      Exists,
      DoesNotExist, // ꎞI
      WantsToSayTo,
      SaidTo,
      TookO1FromO2,
      TaskCompleted,
      Failed,
  }
  public static class Room {
      public String name;
      public Room(String name) {
          this.name = name;
      }
      public static String North = "North".intern();
      public static String East = "East".intern();
      public static String West = "West".intern();
      public static String South = "South".intern();
      public static String[] directions = new String[]{North, East, West, South}; 
      //
      public static Room Room1 = new Room("Room1");
      public static Room Room2 = new Room("Room2");
      public static Room Room3 = new Room("Room3");
      public static Room Room4 = new Room("Room4");
      public static Room Room5 = new Room("Room5");

      public static Room Bathroom = new Room("Bathroom");
      public static Room Kitchen = new Room("Kitchen");
      public static Room Bedroom = new Room("Bedroom");
      public static Room Closet = new Room("Closet");
      public static Room LivingRoom = new Room("LivingRoom");
      public static Room GuestRoom = new Room("GuestRoom");
      public static Room Garage = new Room("Garage");
      public static Room Entrance = new Room("Entrance");
      public static Room Garden = new Room("Garden");

      public static Room Here = new Room("Here");
      public static Room Anywhere = new Room("Anywhere");
      public String toString() {
          return name;
      }
  }

  //Abstract syntax nodes for DSL
  public static class ClauseN {
      public Object when, where, who, doWhat, o1, o2;
      public ClauseN(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
          this.when = when;
          this.where = where;
          this.who = who;
          this.doWhat = doWhat;
          this.o1 = o1;
          this.o2 = o2;
      }
      public Object[] transN() {
          return new Object[] { when, where, who, doWhat, o1, o2 };
      }
      public String toString(){
          StringBuffer buf = new StringBuffer();
          buf.append("c(");
          buf.append(""+ when); buf.append(", ");
          buf.append(""+ where); buf.append(", ");
          buf.append(""+ doWhat); buf.append(", ");
          buf.append(""+ o1); buf.append(", ");
          buf.append(""+ o2);
          buf.append(")");
          return buf.toString();
      }
  }
  public static class RegisterN {
      public String regName;
      public Object conj;
      public ClauseN c1, c2, c3; 
      public RegisterN(String regName, Object conj, ClauseN c1, ClauseN c2) {
          this.regName = regName; this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = null;
      }
      public RegisterN(String regName, Object conj, ClauseN c1, ClauseN c2, ClauseN c3) {
          this.regName = regName; this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = c3;
      }
      public Object[] transN(Object defaultValue) {
          return new Object[] { 
                  conj == null ? 0 : conj, 
                          c1 == null ? zeroV() : c1.transN(), 
                                  c2 == null ? zeroV() : c2.transN(), 
                                          c3 == null ? zeroV() : c3.transN() 
          };
      }
      public Object[] zeroV() {
          Object[] ret = new Object[WmIndex.A.C1.size]; // Assumes all clauses have the same length.
          for (int i = 0; i < ret.length; i++) {
              ret[i] = 0;
          }
          return ret;
      }
      public String toString(){
          StringBuffer buf = new StringBuffer();
          buf.append(regName+ "(");
          buf.append(""+ conj); buf.append(", ");
          buf.append(""+ c1); buf.append(", ");
          buf.append(""+ c2);
          buf.append(")");
          return buf.toString();
      }
  }
  public static class StateN {
      public RegisterN a, b, e;
      public StateN(RegisterN a, RegisterN b, RegisterN e) { 
          this.a = a; this.b = b; this.e = e; 
      }
      public Object[] transN(Object defaultValue) {
          return new Object[] { 
                  a == null ? defaultV(defaultValue) : a.transN(defaultValue),
                          //b == null ? defaultV(defaultValue) : b.transN(defaultValue),
                          e == null ? defaultV(defaultValue) : e.transN(defaultValue),
          };    
      }
      public Object[] defaultV(Object defaultValue) {
          Object[] ret = new Object[WmIndex.A.size]; // Normal register.
          for (int i = 0; i < ret.length; i++) {
              ret[i] = defaultValue;
          }
          return ret;
      }
      public String toString(){
          StringBuffer buf = new StringBuffer();
          buf.append("s(");
          buf.append(""+ a); buf.append(", ");
          buf.append(""+ b); buf.append(", ");
          buf.append(""+ e); buf.append(", ");
          buf.append(")");
          return buf.toString();
      }
  }
  public static class RuleN {
      public String name;
      public StateN s, g;
      public ActionN a;
      public RuleN(String name, StateN s, StateN g, ActionN a){ 
          this.name = name; this.s = s; this.g = g; this.a = a;
      }
      public String toString(){
          return "rule("+ s+ ", "+ g+ ", "+ a+ ")";
      }
  }
  public static class ActionN {
      public PrimitiveAction a;
      public StateN m; // Arguments of the primitive action.
      public ActionN(PrimitiveAction a, StateN m){ 
          this.a = a; this.m = m;
      }
      public String toString(){
          if (m == null){
              return a.toString();
          } else {
              return a.toString()+ "("+ m+ ")";
          }
      }
  }
  /**
   * pattern variable 
   */
  public static class VariableN {
      public String name;
      public VariableN(String name){ this.name = name; }
  }
  //public static class UnionN {
  //public StateN[] args;
  //public UnionN(StateN... args){ this.args = args; }
  //}

  //--------------------------------------------------
  /**
   * Q(s,g,a) 𒊏ۉ[B
   * lxNgƃp^[}b`đIB 
   * Usage:
   *   r = new Rule(ruleN);
   *   boolean matched = r.match(vals);
   *   if (matched){
   *      // Access to the last matching results.
   *      Action a = r.getAction();
   *      State s = new State(r.getActionParam());
   *   }
   */
  public static class Rule {
      /**
       * Q value of this rule.
       */
      public float q = 0;
      /**
       * Base value for the subroutine called by this rule.
       */
      public float base = 0;
      
      // for Monte Carlo Learning
      public float monteQ = 0;
      public float monteBase = 0;
      
      /**
       *  Rule name. Used for debug.
       */
      public String name;
      /**
       * Counter for demo.
       */
      public int useCounter = 0;
      /**
       * Number of variables, WILDCARD, and PLS appeared in this Rule.
       */
      public int numVars;
      // \ȃIuWFNgB
      public static final String UNBOUND = "__UNBOUND__";
      // p^[}b`IɖϐɑftHglB
      // O̒lɂ̂݃}b`B
      public static final String PLS = "PLS".intern();
      // [LO̒l̕ێB
      public static final String KEEP = "=".intern();
      // ChJ[hBCӂ̒lƃ}b`B
      public static final String WILDCARD = "__".intern(); // Two underscores.
      // 萔 0
      public static final Integer ZERO = 0; 
      public Object[] env;
      public Object[] patternVec; // Concatenated pattern of s and g.
      public PrimitiveAction action;
      public Object[] actionPatternVec;  // Pattern of m of action C_m.
      public int idCounter = 0;
      public Map<VariableN,PatternVariable> vmap = new HashMap<>();
      public RuleN ruleN; // for debug
      public Rule(RuleN ruleN){
          // ruleN ƂɃp^[\zB
          this.name = ruleN.name;
          this.ruleN = ruleN;
          List<Object> elems = transStateN(ruleN.s, WILDCARD);
          elems.addAll(transStateN(ruleN.g, WILDCARD));
          numVars = vmap.size() + 
                  (int)elems.stream()
          .filter(e -> e == WILDCARD || e == PLS)
          .count();
          patternVec = elems.toArray();
          action = ruleN.a.a;
          if (ruleN.a.m == null) {
              // It is primitive action.
              actionPatternVec = null;
          } else if (action == PrimitiveAction.Set || action == PrimitiveAction.SetM){
              actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
              //    } else if (action == PrimitiveAction.SetA){
              //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
              //    } else if (action == PrimitiveAction.SetB){
              //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
              //    } else if (action == PrimitiveAction.Add){
              //        actionPatternVec = transStateN(ruleN.a.m, KEEP).toArray();
          } else {
              actionPatternVec = transStateN(ruleN.a.m, WILDCARD).toArray();
          }
          env = new Object[vmap.size()];
          vmap = null;
      }
      public Rule(){
          // Implicitly called from ReturnRule().
      }
      // q̗Œ蒷̃[LO̗vfɕϊB
      // qꂪw肳ĂȂꍇ͗vf defaultValue ƂB
      public List<Object> transStateN(StateN state, Object defaultValue){
          Object[] sa = flatten(state.transN(defaultValue));

          //    System.out.println("transStateN:");
          //    System.out.println("state="+ state);
          //    printArray("state.transN", state.transN(defaultValue));
          //    printArray("state.transN 0", (Object[])(state.transN(defaultValue))[0]);
          //    printArray("sa", sa);
          //    System.out.println("sa.length:"+ sa.length);
          //    System.out.println("wm size: "+ WmIndex.size);
          Lab.assertTrue(sa.length == WmIndex.size);

          Object[] arr = new Object[WmIndex.size];
          for (int i = 0; i < sa.length; i++) {
              Lab.assertTrue(sa[i] != null);
              arr[i] = transArg(sa[i]);
          }
          List<Object> ret = new ArrayList<>();
          ret.addAll(Arrays.asList(arr));
          if (false) {
              System.out.println("transStateN: default="+ defaultValue+ " : "+ state);
              System.out.println(" "+ ret);
          }
          return ret;
      }
      private static void flattenTest() {
          Object[] a = {1,2,3};
          Object[] b = {4,a,5,6};
          Object[][] c = {a,{7,8},{},{9},b};
          Object[] d = {};
          Object[] nested = {c,d,a,b,d};
          System.out.println("flatten test:");
          Object[] flat = flatten(nested);
          for (int i = 0; i < flat.length; i++) {
              //System.out.println(i+ ":"+ flat[i]);
              System.out.print(flat[i]+ " ");
          }
          System.out.println();
      }
      public static Object[] flatten(Object[] nested) {
          Vector<Object> v = new Vector<>();
          for (int i = 0; i < nested.length; i++) {
              if (nested[i] instanceof Object[]) {
                  Object[] a = flatten((Object[])nested[i]);
                  for (int j = 0; j < a.length; j++) {
                      v.add(a[j]);
                  }
              } else {
                  v.add(nested[i]);
              }
          }
          return v.toArray(); 
      }
      // q̈Bϐɓ id  PatternVariable 蓖ĂB
      public Object transArg(Object e) {
          Object re;
          if (e instanceof String) {
              e = ((String)e).intern();
          }
          if (e == WILDCARD){
              re = e;
          } else if (e instanceof VariableN){
              if (vmap.containsKey(e)){
                  re = vmap.get(e);
              } else {
                  re = new PatternVariable(((VariableN)e).name,
                          idCounter++);
                  vmap.put((VariableN)e, (PatternVariable)re);
              }
          } else if (e instanceof Integer){
              int i = (Integer)e;
              // Accepts only small integers that can be compared with == operator.
              Lab.assertTrue( -128 <= i && i <= 127); 
              re = e;
          } else {
              re = e;
          }
          return re;
      }
      // TODO: t@N^O\Bϐ蓖ĂŏɂB
      public boolean ruleMatch(Object[] vals){
          Lab.assertTrue(vals.length == patternVec.length);
          for (int i = 0; i < env.length; i++) {
              env[i] = UNBOUND;
          }
          for (int i = 0; i < vals.length; i++) {
              //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
              Lab.assertTrue(vals[i] != KEEP);
              Lab.assertTrue(patternVec[i] != KEEP);
              if (patternVec[i] == WILDCARD){
                  // Do nothing.
              } else if (patternVec[i] == PLS){
                  if (vals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else {
                  Object pval;
                  if (patternVec[i] instanceof PatternVariable){
                      int id = ((PatternVariable)patternVec[i]).id;
                      if (env[id] == UNBOUND && vals[i] != WILDCARD){
                          pval = env[id] = vals[i];
                      } else {
                          pval = env[id];
                      }
                      //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                      //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                      //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                  } else {
                      pval = patternVec[i];
                  }
                  // pval ͕ϐ蓖čς݂̃p^[̒lB
                  // pval ̕ vals[i] LȂ return false B
                  if (pval == WILDCARD){
                      System.out.println("this="+ this);
                      Lab.assertTrue(false);
                  } else if (pval == UNBOUND){
                      // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                      Lab.assertTrue(vals[i] == WILDCARD);
                      // XXX: ̂悤ȏł悢̂낤H
                  } else if (pval == PLS){
                      if (vals[i] == ZERO) return false;
                      //if (vals[i] == WILDCARD) return false;
                  } else {
                      if (vals[i] != pval) return false;
                  }
              }
              //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
              //for (int j = 0; j < env.length; j++) {
              //    System.out.println("env["+ j+ "]="+ env[j]);
              //}
          }
          //System.out.println("*** match ****");
          return true;
      }
      // ӖLp̃p^[}b`\bhB
      // ܂ŎbŎBdl͍B
      public boolean knowledgeMatch(Object[] qvals){
          Lab.assertTrue(qvals.length == patternVec.length);
          for (int i = 0; i < env.length; i++) {
              env[i] = UNBOUND;
          }
          for (int i = 0; i < qvals.length; i++) {
              //System.out.println(i+ ":"+ patternVec[i]+ ","+ vals[i]);
              Lab.assertTrue(qvals[i] != KEEP);
              Lab.assertTrue(patternVec[i] != KEEP);
              if (patternVec[i] == WILDCARD){
                  //Lab.assertTrue(false); // not implemented
                  // Not implemented and do nothing so far.
              } else if (patternVec[i] == PLS){
                  Lab.assertTrue(false); // not implemented
                  if (qvals[i] == ZERO) return false;
                  //if (vals[i] == WILDCARD) return false;
              } else if (patternVec[i] == ZERO){
                  //Lab.assertTrue(false); // not implemented
                  // Not implemented and do nothing so far.
              } else {
                  Object pval;
                  if (patternVec[i] instanceof PatternVariable){
                      int id = ((PatternVariable)patternVec[i]).id;
                      if (env[id] == UNBOUND && qvals[i] != WILDCARD){
                          pval = env[id] = qvals[i];
                      } else {
                          pval = env[id];
                      }
                      //System.out.println("i="+ i+ ", pval="+ pval+ ", vals[i]="+ 
                      //   vals[i]+ ", env["+ id+ "]="+ env[id]);
                      //System.out.println(vals[i]+" == "+pval+":"+(vals[i]==pval));
                  } else {
                      pval = patternVec[i];
                  }
                  // pval ͕ϐ蓖čς݂̃p^[̒lB
                  // pval ̕ vals[i] LȂ return false B
                  if (pval == WILDCARD){
                      System.out.println("this="+ this);
                      Lab.assertTrue(false);
                  } else if (pval == UNBOUND){
                      // g ̗vf WILDCARD ƃp^[ϐ}b`ꍇB
                      Lab.assertTrue(qvals[i] == WILDCARD);
                      // XXX: ̂悤ȏł悢̂낤H
                  } else if (pval == PLS){
                      if (qvals[i] == ZERO) return false;
                      //if (vals[i] == WILDCARD) return false;
                  } else {
                      // p^[ʂ̒lANG 0, WILDCARD, PLS ̏ꍇ̓}b`B
                      if (qvals[i] == ZERO || qvals[i] == WILDCARD || qvals[i] == PLS) {
                          // Do nothing.
                      } else {
                          if (qvals[i] != pval) return false; 
                      }
                  }
              }
              //System.out.println("i="+ i+ ", vals[i]="+ vals[i]);
              //for (int j = 0; j < env.length; j++) {
              //    System.out.println("env["+ j+ "]="+ env[j]);
              //}
          }
          //System.out.println("*** match ****");
          return true;
      }
      public PrimitiveAction getAction(){
          return action;
      }
      // p^[}b`́ul̃xNgvoBO match ɂϐ蓖ĂpB
      public Object[] getActionParam(){
          Object[] ret = actionPatternVec.clone();
          for (int i = 0; i < ret.length; i++) {
              if (ret[i] == WILDCARD){
                  // ret[i] = WILDCARD;
              } else if (ret[i] instanceof PatternVariable){
                  int id = ((PatternVariable)actionPatternVec[i]).id;
                  if (env[id] == UNBOUND){
                      //System.out.println("???:"+ this);
                      //System.out.println("???: var="+ ret[i]+ ",id="+ id);
                      throw new Error("UNBOUND in action param : "+ this);
                  } else {
                      ret[i] = env[id];
                  }
              }
          }
          return ret;
      }
      public String toString(){
          StringBuffer buf = new StringBuffer();
          {
              Lab.assertTrue(patternVec.length == WmIndex.size * 2);
              buf.append(name);
              buf.append(":");
              buf.append("rule(");
              buf.append(WmIndex.valuesToString(patternVec));
              buf.append(" ");
              if (actionPatternVec != null){
                  Lab.assertTrue(actionPatternVec.length == WmIndex.size);
                  buf.append(action+ " ");
                  buf.append(WmIndex.valuesToString(actionPatternVec));
              } else {
                  buf.append(action+ "");
              }
              buf.append("):"+ q);
          }
          if (WmIndex.printRawFlag) {
              buf.append(" raw: ");
              Lab.assertTrue(patternVec.length % 2 == 0);
              int stateLength = patternVec.length / 2;
              buf.append(name);
              buf.append(":");
              buf.append("rule((");
              for (int i = 0; i < stateLength; i++) {
                  buf.append(patternVec[i]+ ",");
              }
              buf.append("), (");
              for (int i = 0; i < stateLength; i++) {
                  buf.append(patternVec[stateLength + i]+ ",");
              }
              buf.append("), ");
              if (actionPatternVec != null){
                  buf.append(action+ "(");
                  for (int i = 0; i < actionPatternVec.length; i++) {
                      buf.append(actionPatternVec[i]+ ",");
                  }
                  buf.append(")");
              } else {
                  buf.append(action+ "");
              }
              buf.append("):"+ q);
          }
          return buf.toString();
      }
      public static class PatternVariable {
          String name;
          int id;
          public PatternVariable(String name, int id){ 
              this.name = name; this.id = id; 
          }
          //public String toString() { return ""+ id+ ":"+ name; }
          public String toString() { return ""+ name; }
      }
      // Special instance used for Action.Return
      public static final Rule returnRule = new ReturnRule();
      // Special instance used as a dummy caller of each episode. 
      public static final Rule startRule = new StartRule();
      // DSL Ŏw肳ꂽe State Bp^[ϐ͎gȂƁB
      //   ReturnRule ̃CX^X𖳗gĂB
      public static State makeState(StateN stateN, Object defaultValue) {
          return new State(returnRule.transStateN(stateN, defaultValue).toArray());
      }
  }
  public static class ReturnRule extends Rule {
      public ReturnRule(){
          name = "ReturnRule";
          action = PrimitiveAction.Return;
          q = 0; // Q(g,g,RET) == 0
      }
      public String toString(){
          return name+ ": "+ q;
      }
  }
  public static class StartRule extends Rule {
      public StartRule(){
          name = "StartRule";
      }
      public String toString(){
          return name+ ": "+ q;
      }
  }
  /**
   * Q(s,g,call(m))  s, g, m \邽߂̃f[^\B
   */
  public static class State {
      public Object[] values;
      public State(Object[] values) { this.values = values; }
      //public Object[] getVec(){
      //    return values;
      //}
      /**
       * Compares two states in order to check if the agent reaches 
       * the subgoal state g. 
       * State g may contain the special values: PLS and/or WILDCARD. 
       */
      public boolean satisfies(State g){
          Object[] gv = g.values;
          Lab.assertTrue(values.length == gv.length);
          for (int i = 0; i < gv.length; i++) {
              if (gv[i] == Rule.PLS){
                  if (values[i] == Rule.ZERO) return false;
                  if (values[i] == Rule.WILDCARD) return false;
              } else if (gv[i] == Rule.WILDCARD){
                  // Do nothing.
              } else {
                  if (values[i] != gv[i]) return false;
              }
          }
          return true;
      }
      /**
       * Gs\[hL̂߂̃}b`OB
       * query Ɋ܂܂ĂqꂪׂĊ܂܂ĂȂ true ԂB
       * TODO: L[Ώۂ State ł͂ȂCxgɕύXB
       */
      public boolean episodeMatch(State query) {
          Object[] qv = query.values;
          //printArray("episodeMatch: query", kv);
          //printArray("episodeMatch: state", values);
          Lab.assertTrue(values.length == qv.length);
          for (int i = 0; i < qv.length; i++) {
              if (qv[i] == Rule.PLS){
                  if (values[i] == Rule.ZERO) return false;
                  if (values[i] == Rule.WILDCARD) return false;
              } else if (qv[i] == Rule.WILDCARD){
                  // Do nothing.
              } else {
                  if (values[i] != qv[i]) return false;
              }
          }
          return true;

      }
      public String toString(){
          StringBuffer buf = new StringBuffer();
          {      
              buf.append(WmIndex.valuesToString(values));
          }
          if (WmIndex.printRawFlag) {
              buf.append(" raw: (");
              for (int i = 0; i < values.length; i++) {
                  buf.append(values[i].toString());
                  buf.append(",");
              }
              buf.append(")");
          }
          return buf.toString();
      }


      public Object get(int index) { 
          return values[index]; 
      }
      // State  n Ԗڂ̗vf𐮐ɂĕԂB
      public int getInt(int n) {
          Object x = values[n];
          if (x instanceof Integer) {
              return ((Integer)x).intValue();
          } else {
              //return -1;
              throw new Error("x is not an Integer. x="+ x);
          }
      }
      public void set(int index, Object x) { 
          values[index] = x;
      }
      public void clear(RegisterIndex r) {
          for (int i = 0; i < r.size; i++) {
              values[r.head + i] = 0;
          }
      }
  }
  /**
   * Agent  takeAction ̏ĂrŃANV fail Ƃ throw B  
   *
   */
  public static class Fail extends Exception {}


  //--------------------------------------------------
  public static abstract class AbstractMainCode extends Lab.MainCode {
      //public int maxEpisodes = panel.getInt("max episodes", 1000000, 1, 100000);
      public int maxSteps = panel.getInt("max steps", 1000, 1, 10000);
      public float alpha = panel.getFloat("alpha", 0.01f, 0, 1);
      public float rewardC = panel.getFloat("1 step cost", -1, -10, 0);
      public boolean useOldUpdateRule = panel.flag("useOldUpdateRule", false);
      public boolean sarsaLearningFlag = panel.flag("sarsaLearningFlag", false);
      public boolean extraMonteLearningFlag = panel.flag("extraMonteLearningFlag", false);
      //public int mapSizeX = panel.getInt("map size X", 3, 1, 100);
      //public int mapSizeY = panel.getInt("map size Y", 1, 1, 100);
      public int mapSizeX;
      public int mapSizeY;
//      public int roomSizeX = panel.getInt("room size X", 7, 1, 100);
//      public int roomSizeY = panel.getInt("room size Y", 9, 1, 100);
      public float vScale; 
      public lab.Lab.WTextArea qView = null;
      public AbstractMainCode mainCode = this; // Main ZN^őIB
      public World world;

      public void main() {
          world = new World();
          world.init();
          world.main();
      }

      public class Agent {
          public State newS; // state
          public State newG; // subgoal
          public Rule newR; // rule 
          public State oldS;
          public State oldG;
          public Rule oldR;
          public State actionParamState; 
          public float reward;
          public Stack<State> stack;
          public Stack<Rule> callerStack;
          public Rule caller;
          // for Monte Carlo Learning
          public Stack<Rule> ruleHistory;
          public Stack<Float> rewardHistory;
          public Stack<Rule> callerHistory;
          public Stack<Stack<Rule>> callerStackHistory;
          
          //
          public State start, goal;
          public boolean failedFlag;
          public float stackValue;
          public State failedState;
          //
          public World world;
          public Room currentRoom;
          public int energy;
          //public int currentPos;
          public Item agentItem; // Item that represents the agent itself.
          public List<Rule> rules;
          public List<Rule> knowledgeBase;
          public State sentenceBuf;
          //public float initVal = panel.getFloat("Table init value", 0, -50, 0);
          public float beta = panel.getFloat("beta", 1, 0.01f, 100); // for softmax
          //
          public Agent(Item selfItem, World world){
              this.agentItem = selfItem;
              this.world = world;
              this.currentRoom = Here; // Dummy
          }
          public void setDefaultStartAndGoal(){
              State s = Rule.makeState(w(), Rule.ZERO);
              State g = Rule.makeState(w(a(Verb.TaskCompleted)), Rule.WILDCARD);
              knowledgeBase = List.copyOf(knowledgeList);
              setStartAndGoal(s, g);
          }
          public void setStartAndGoal(State s, State g){
              oldS = newS = start = s;
              oldG = newG = goal = g;
              failedState = s;

              //System.out.println("setStartAndGoal: s="+ s);
              //System.out.println("setStartAndGoal: g="+ g);
              //System.out.println("s.satisfies(g)="+ s.satisfies(g));
          }
          public void initEpisodeAndChooseFirstAction(){
              ruleHistory = new Stack<Rule>();
              rewardHistory = new Stack<Float>();
              callerHistory = new Stack<Rule>();
              callerStackHistory = new Stack<Stack<Rule>>();

              stack = new Stack<State>();
              callerStack = new Stack<Rule>();
              stack.push(oldG);
              caller = Rule.startRule;
              callerStack.push(Rule.returnRule); // Dummy whose base value is 0.
              episodeMem = new ArrayList<State>();
              episodeMemLog("episodeList cleared.");
              sentenceBuf = null;
              chooseAction();
              oldR = newR;
          }
          // 
          public float failPenalty = panel.getFloat("fail penalty", -0, -100, 0);
          public void takeAction(){
              PrimitiveAction action = oldR.getAction();
              failedFlag = false;
              episodeMemLog(oldR.toString());

              if (panel.flag("Action log", true)) {
                  StringBuffer buf = new StringBuffer();
                  // indent
                  for (int i = 0; i < stack.size(); i++) {
                      buf.append("  ");
                  }
                  buf.append("c="+ world.counter+ ": rule "+ oldR.name+ ": ");
                  buf.append(action.toString());
                  if (action == PrimitiveAction.Return) {
                      buf.append(' ');
                      buf.append(oldS.toString());
                  } else if (actionParamState != null) {
                      buf.append(" ");
                      buf.append(actionParamState);
                      if (WmIndex.printRawFlag) {
                          buf.append('(');
                          Object[] values = actionParamState.values;
                          if (values.length > 0) {
                              buf.append(values[0].toString());
                              for (int i = 1; i < values.length; i++) {
                                  buf.append(',');
                                  buf.append(values[i].toString());
                              }
                          }
                          buf.append(')');
                      }
                  }
                  env.viewPanel.println("Action log of "+ agentItem, buf.toString());
                  if (panel.flag("Show sentenceBuf in action log", false)) {
                      env.viewPanel.println("Action log of "+ agentItem, 
                              "sentenceBuf="+ sentenceBuf);
                  }
              }

              try { // catch (Fail)
                  if (action == PrimitiveAction.Return){
                      newS = oldS;
                      newG = stack.pop();
                      reward = rewardC;
                      
                  } else if (action == PrimitiveAction.Exit){
                      newS = wmSet(actionParamState, oldS);
                      newG = stack.pop();
                      reward = rewardC;

                  } else if (action == PrimitiveAction.Call){
                      stack.push(oldG);
                      newS = oldS;
                      newG = actionParamState;
                      reward = rewardC;

//                  } else if (action == PrimitiveAction.Try){
//                      Lab.assertTrue(false); // wK
//                      newS = oldS;
//                      //newS.clear(WmIndex.A);
//                      //newS.clear(WmIndex.E);
//                      stack.push(oldG);
//                      newG = actionParamState;
//                      reward = rewardC;

                  } else if (action == PrimitiveAction.CallM){
                      Lab.assertTrue(false); // wK
                      // w肵mŐ錾Im̑zN݂B
                      State pp = null;
                      //              if (Lab.irand(2) == 0) {
                      if (panel.getFloat("recall when callM", 1f, 0f, 1f) > Lab.rand()) {
                          State query = getReg(WmIndex.A, actionParamState);
                          pp = doRecall(query);
                      }
                      if (pp == null) {
                          // Do call.
                          // 錾ILɌȂΕʂɃTu[`ĂяoB
                          newS = oldS;
                          //newS.clear(WmIndex.A);
                          //newS.clear(WmIndex.E);
                          stack.push(oldG);
                          newG = actionParamState;
                          reward = rewardC; //??
                      } else {
                          episodeMemLog(" Cache hit: "+ pp);
                          newS = setReg(WmIndex.A, pp, oldS);
                          episodeMemLog(" newS="+ newS);
                          newG = oldG;
                          reward = rewardC; //??
                      }          

                  } else if (action == PrimitiveAction.Set
                          || action == PrimitiveAction.SetWithCost1
                          || action == PrimitiveAction.SetWithCost2
                          || action == PrimitiveAction.SetWithCost3
                          || action == PrimitiveAction.SetWithCost4
                          ){
                      // NOTE: Ώۂ a WX^̏ꍇ Set ł͂Ȃ SetM Ă΂B
                      newS = wmSet(actionParamState, oldS);
                      newG = oldG;
                      //reward = rewardC;
                      if (action == Set) {
                          reward = rewardC;
                      } else if (action == SetWithCost1) {
                          reward = panel.getFloat("SetWithCost1", -1, -2, 0);
                      } else if (action == SetWithCost2) {
                          reward = panel.getFloat("SetWithCost2", -1, -2, 0);
                      } else if (action == SetWithCost3) {
                          reward = panel.getFloat("SetWithCost3", -1, -2, 0);
                      } else if (action == SetWithCost4) {
                          reward = panel.getFloat("SetWithCost4", -1, -2, 0);
                      } else {
                          Lab.assertTrue(false);
                      }
                  } else if (action == PrimitiveAction.SetM){
                      newS = wmSet(actionParamState, oldS);
                      rememberAreg(newS);
                      //                State aReg = getReg(WmIndex.A, newS);
                      //                episodeMem.add(0, aReg); // Insert to the top of the list.
                      //                episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);
                      newG = oldG;
                      reward = rewardC;

                  } else if (action == PrimitiveAction.Recall){
                      State query = getReg(WmIndex.E, actionParamState);
                      State pp = doRecall(query);
                      if (pp == null) {
                          episodeMemLog(" Recall failed.");
                          throw new Fail();
                      } else {
                          newS = setReg(WmIndex.E, pp, oldS);
                          episodeMemLog(" newS="+ newS);
                          newG = oldG;
                          reward = rewardC;
                      }              

                  } else if (action == PrimitiveAction.NOP){
                      newS = oldS;
                      newG = oldG;
                      reward = rewardC;

                  } else if (action == PrimitiveAction.Fail){
                      throw new Fail();

                  } else {
                      reward = rewardC;
                      newS = new State(oldS.values.clone());
                      takePrimitiveActionAndObserve();
                      newG = oldG;
                  }

              } catch (Fail f) {
                  if (true) {
                      if (panel.flag("Action log", true)) {
                          env.viewPanel.println("Action log of "+ agentItem, "Failed.");
                      }                
                      newS = Rule.makeState(w(a(Failed)), Rule.ZERO);
                      newS.clear(WmIndex.E);
                      newG = oldG;
                      reward = rewardC + failPenalty;
                      
                  } else {
                      // Old implementation.
                      if (true) System.err.println("Fail occurred.");
                      if (panel.flag("Action log", true)) {
                          env.viewPanel.println("Action log of "+ agentItem, "Failed.");
                      }                
                      failedFlag = true;
                      if (useOldUpdateRule) {
                          stackValue = evalStack(oldG, stack);
                      }
                      newS = failedState;
                      //newS.clear(WmIndex.A);
                      newS.clear(WmIndex.E);

//                      // old implementation
//                      newG = goal;
//                      stack.clear();
                      while (! stack.isEmpty()) {
                          newG = stack.pop();
//                          if (newG == null) { // "try" action marker
//                              newG = stack.pop();
//                              break;
//                          }
                      }

                      //episodeMem.clear();  // ??
                      reward = rewardC + failPenalty;
                  }
              }
              //        // KŌɌ݂̎Eꏊ̐lWX^ɐݒ
              //        newS.set(WmIndex.V.When, world.currentTime);
              //        newS.set(WmIndex.V.Where, currentRoom);
          }
          public void chooseAction(){
              if (newS.satisfies(newG)){
                  newR = Rule.returnRule;
                  actionParamState = null;
              } else {
                  List<Rule> matched = selectMatchedRules(newS, newG);

                  //            matched.forEach(r -> {
                  //                System.out.println("matched: "+ r);
                  //                if (r.action == Action.Call || r.action == Action.Set) {
                  //                    System.out.println("  a="+ r.action);
                  //                    System.out.println("  m="+ new State(r.getActionParam()));
                  //                }
                  //            });

                  float[] q = calcRulePriorities(matched);
                  if (q.length == 0){
                      throw new Error("No action selected: (newS,newG)="+ 
                              newS+ ", "+ newG);
                  }
                  // softmax  Rule PIB
                  int index = softmax(q);
                  if (panel.flag("Show matched rules", false)){
                      for (int i = 0; i < matched.size(); i++) {
                          env.viewPanel.println("matched "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ matched.get(i));
                      }
                      for (int i = 0; i < q.length; i++) {
                          env.viewPanel.println("priority "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ q[i]);
                      }
                      for (int i = 0; i < probTable.length; i++) {
                          env.viewPanel.println("probTable "+ agentItem, "c="+ world.counter+ ": "+ i+ ":"+ probTable[i]);
                      }
                  }
                  newR = matched.get(index);
                  if (newR.actionPatternVec == null) {
                      actionParamState = null;
                  } else {
                      actionParamState = new State(newR.getActionParam());
                  }
              }
          }
          public List<Rule> selectMatchedRules(State s, State g){
              // s,g ̒lzB
              Object[] vals = new Object[s.values.length + g.values.length];
              for (int i = 0; i < s.values.length; i++) {
                  vals[i] = s.values[i];
              }
              for (int i = 0; i < g.values.length; i++) {
                  vals[i + s.values.length] = g.values[i];
              }
              // (s,g) Ƀ}b`郋[IB
              // [̐ parallelStream gĂ݂B
              List<Rule> matched = rules.stream().filter(
                      r -> r.ruleMatch(vals)
                      ).collect(Collectors.toList());
              return matched;
          }
          public float genericityPenalty = panel.getFloat("gen penalty", 100, 0, 100);
          public float[] calcRulePriorities(List<Rule> matched){
              float[] q = new float[matched.size()];
              for (int i = 0; i < q.length; i++) {
                  Rule r = matched.get(i);
                  // numVars ɉyieB^Bϐ̐Ȃ[DB
                  float val = r.q - genericityPenalty * r.numVars;
                  q[i] = val;
              }
              return q;
          }
          // sarsaLearningFlag  true ̂Ƃ SIG-AGI-025-08  Sarsa
          public void update() {
              ruleHistory.push(oldR);
              rewardHistory.push(reward);
              callerHistory.push(caller);
              callerStackHistory.push((Stack<Rule>)callerStack.clone()); // shallow copy of the stack
              if (failedFlag){
                  // fail ͔p~\B
                  // IȊwKł͂Ȃ̂ŒӁB
                  if (sarsaLearningFlag) oldR.q += alpha * (reward + newR.q - oldR.q);
              } else if (oldR == Rule.returnRule) {
                  if (sarsaLearningFlag) caller.base += alpha * (reward + newR.q - caller.base);
                  caller = callerStack.pop();
                  Lab.assertTrue(Rule.returnRule.q == 0);
                  Lab.assertTrue(Rule.returnRule.base == 0);
              } else if (oldR.getAction() == PrimitiveAction.Exit){
                  if (sarsaLearningFlag) oldR.q += alpha * (reward + (newR.q - caller.base) - oldR.q);
                  caller = callerStack.pop();
              } else if (oldR.getAction() == PrimitiveAction.Call) {
                  callerStack.push(caller);
                  caller = oldR;
                  if (sarsaLearningFlag) oldR.q += alpha * (reward + (newR.q + oldR.base) - oldR.q);
              } else {
                  if (sarsaLearningFlag) oldR.q += alpha * (reward + newR.q - oldR.q);
              }

              oldS = newS;
              oldG = newG;
              oldR = newR;
          }
          // Monte-carlo learning.
          public boolean printBaseForMonteCarloFlag = false; 
          public void monteLearning() {
              Lab.assertTrue(Rule.returnRule.q == 0);
              Lab.assertTrue(Rule.startRule.q == 0);
              Lab.assertTrue(Rule.returnRule.base == 0);
              Rule oldR = Rule.returnRule; // Dummy whose Q value is 0.
              float T = 0; // Total reward until the end of the episode.
              if (printBaseForMonteCarloFlag) System.out.println("");
              while (! ruleHistory.isEmpty()) {
                  Rule newR = oldR; // newR = rule_{t+1}, oldR = rule_t in the episode.
                  oldR = ruleHistory.pop();
                  Rule caller = callerHistory.pop();
                  Stack<Rule> callerStack = callerStackHistory.pop();
                  float reward = rewardHistory.pop(); 
                  T += reward;
                  if (oldR == Rule.returnRule){
                      if (printBaseForMonteCarloFlag) System.out.println("returnRule");
                      caller.base += alpha * (reward + newR.q - caller.base);
                  } else {
                      float base = 0;
                      if (printBaseForMonteCarloFlag) System.out.println("normal rule");
                      for (Rule c : callerStack) {
                          if (printBaseForMonteCarloFlag) System.out.println(" c.base = "+ c.base);
                          base += c.base;
                      }
                      oldR.q += alpha * ((T - caller.base - base) - oldR.q);
                  }
              }
          }
          // Monte-carlo learning just for algorithm comparison test.
          // SIG-AGI-025-08  eJ@ɂwKB
          // *** This is an old version which does not support multi-task. ***
          public void extraMonteLearning() {
              Lab.assertTrue(Rule.returnRule.monteQ == 0);
              Lab.assertTrue(Rule.startRule.monteQ == 0);
              Lab.assertTrue(Rule.returnRule.monteBase == 0);
              float G = 0; // Total reward until the end of the episode.
              while (! ruleHistory.isEmpty()) {
                  Rule oldR = ruleHistory.pop();
                  Rule caller = callerHistory.pop();
                  G += rewardHistory.pop();
                  if (oldR == Rule.returnRule){
                      caller.monteBase += alpha * (G - caller.monteBase);
                  } else {
                      oldR.monteQ += alpha * ((G - caller.monteBase) - oldR.monteQ);
                  }
              }
          }
          // Not tested enough.
          // V(g,Stack) = V_g1(g)+V_g2(g1)+...+V_gn(g_(n-1))
          public float evalStack(State g, Stack<State> stack) {
              State ss = g;
              float ret = 0;
              for (int i = stack.size() - 1; i >= 0; i--) {
                  //System.out.println("Stack!:"+ stack.get(i));
                  State gg = stack.get(i);
                  //System.out.println("evalValue(gg,ss)="+ evalValue(gg, ss));
                  ret += evalValue(gg, ss);
                  ss = gg;
              }
              //System.out.println("evalStack = "+ ret);
              return ret;
          }
          public boolean approxValueEvalFlag = panel.flag("approxValueEvalFlag", false);
          /** Returns V_g(s) */
          public float evalValue(State g, State s){
              List<Rule> matched = selectMatchedRules(s, g);
              float[] q = calcRulePriorities(matched);
              if (approxValueEvalFlag){
                  // V_g(s) \approx max_a Q(s,g,a)
                  int i = Lab.argmax(q); 
                  return matched.get(i).q;
              } else {
                  // V_g(s) = \Sigma_a \pi((s,g),a)Q(s,g,a)
                  calcProbTable(q, 0, q.length);
                  float val = 0;
                  for (int i = 0; i < probTable.length; i++) {
                      // To avoid 0 * -Infinity = NaN
                      float value = matched.get(i).q;
                      if (value != Float.NEGATIVE_INFINITY){
                          val += probTable[i] * value;
                      }
                  }
                  return val; 
              }
          }


          // Softmax
          public double[] probTable = new double[0]; /** \pi(a) \in [0,1] */
          public int softmax(float[] q){ return softmax(q, 0, q.length); }
          public int softmax(float[] q, int from, int to){
              calcProbTable(q, from, to);
              //        System.out.println("probTable=");
              //        for (int i = 0; i < probTable.length; i++) {
              //            System.out.print(probTable[i]+ ", ");
              //        }
              //        System.out.println();
              float r = Lab.rand();
              double sum = 0;
              for (int i = from; i < to; i++){
                  sum += probTable[i]; 
                  if (sum > r) {
                      Lab.assertTrue(q[i] != Float.NEGATIVE_INFINITY); 
                      return i;
                  }
              }
              Lab.assertTrue(sum - 0.001f < 1);
              Lab.assertTrue(q[to - 1] != Float.NEGATIVE_INFINITY); 
              return to - 1;
          }
          // \pi((s,g),a) = exp(beta * Q(s,g,a)) / a' exp(beta * Q(s,g,a'))
          public void calcProbTable(float[] q, int from, int to){
              if (q.length != probTable.length){
                  probTable = new double[q.length];
              }
              float max = Lab.max(q);
              double total = 0;
              for (int i = from; i < to; i++){
                  // To avoid overflow, subtract max.
                  // exp(a-c)/\Sigma_i exp(ai-c) = exp(a)/\Sigma_i exp(ai)  
                  double val = Math.exp(beta * (q[i] - max));
                  probTable[i] = val;
                  total += val;
                  //             System.out.println("q["+ i+ "]="+ q[i]);
                  //             System.out.println("val="+ val);
              }
              //        System.out.println("total="+ total);
              Lab.assertTrue(total > 0);
              for (int i = from; i < to; i++){
                  probTable[i] /= total;
              }
          }

          public boolean achieved() {
              return stack.size() == 0 && newR.getAction() == PrimitiveAction.Return; 
          }
          /**
           * [LO̒lXVBvf̒l KEEP ̏ꍇ͂̑O̒lێB
           */
          public State wmSet(State setArg, State oldS) {
              Object[] oldv = oldS.values;
              Object[] newv = oldv.clone(); // Copy the other registers.
              Object[] argv = setArg.values;
              for (int i = 0; i < newv.length; i++) {
                  if (argv[i] == Rule.KEEP) {
                      newv[i] = oldv[i];
                  } else {
                      newv[i] = argv[i];
                  }
              }
              return new State(newv);
          }
          /**
           * WX^̒loB
           */
          public State getReg(RegisterIndex reg, State oldS) {
              int regOffset = reg.head;
              int regSize = WmIndex.A.size; // Assumes all registers have the same size.
              Object[] oldv = oldS.values;
              Object[] propv = new Object[regSize];
              for (int i = 0; i < regSize; i++) {
                  propv[i] = oldv[regOffset + i];
              }
              return new State(propv);
          }
          /**
           * WX^ɒlZbgBw肵WX^ȊO̒l͕ێB
           */
          public State setReg(RegisterIndex reg, State pprop, State oldS) {
              int regOffset = reg.head;
              Object[] oldv = oldS.values;
              Object[] newv = oldv.clone(); // Copy the other registers.
              Object[] propv = pprop.values;
              int regSize = WmIndex.A.size; // Assumes all registers have the same size.
              Lab.assertTrue(regSize == propv.length);
              for (int i = 0; i < regSize; i++) {
                  newv[regOffset + i] = propv[i];
              }
              return new State(newv);
          }

          public int getCurrentRoomID() {
              return roomNameToRoomId(currentRoom);
          }
          public int roomNameToRoomId(Room roomName) {
              for (int i = 0; i < world.rooms.length; i++) {
                  //System.out.println("n="+ roomName+ ", a[i]="+ world.areas[i]);
                  if (roomName == world.rooms[i]) return i;
              }
              throw new Error("roomNameToRoomId : "+ roomName);
          }

//          /**
//           * }bv̒烉_ɂP̂IňʒuԂB 
//           */
//          public int findObjectFromMap() {
//              // }bv̂̐̕𐔂Bǁix=0 or y=0j͂̂B
//              // }bv̂̐̕𐔂B
//              int c = 0;
//              int roomID = getCurrentRoomID();
//              for (int x = 1; x < roomSizeX; x++) {
//                  for (int y = 1; y < roomSizeY; y++) {
//                      if (world.map[roomID][y * roomSizeX + x] != Space) {
//                          c++;
//                      }
//                  }
//              }
//              // _ r Ԗڂ̂̕IԁB
//              int r = Lab.irand(c);
//              c = 0;
//              for (int x = 1; x < roomSizeX; x++) {
//                  for (int y = 1; y < roomSizeY; y++) {
//                      if (world.map[roomID][y * roomSizeX + x] != Space) {
//                          if (c++ == r) return y * roomSizeX + x;
//                      }
//                  }
//              }
//              return -1; // Not found.
//          }
//          /**
//           * }bv̒w肳ꂽ̂PTďꏊԂB
//           * TB 
//           */
//          public int findItemFromTheRoom(Item item) {
//              int roomID = getCurrentRoomID();
//              for (int i = 0; i < world.map[roomID].length; i++) {
//                  if (world.map[roomID][i] == item) return i;
//              }
//              throw new Error("findItemFromMap: not found "+ item);
//          }


          /** ANV a.oldR sA a.newS ϑB
           * Vꍇ a.reward ̒lɉZB
           */
          public void takePrimitiveActionAndObserve() throws Fail {
              PrimitiveAction action = oldR.getAction();
              int roomID = getCurrentRoomID();
              //newS.set(WmIndex.A.C0.When, Time.Now);
              switch (action) {
              case EatO1: {
                  // O1 HׂȂHׂB
                  Object target = newS.get(WmIndex.A.C1.O1);
                  Object verb;
                  if (world.containsItem(currentRoom, target)) {
                      // HׂꍇB
                      if (target == Nut) {
                          world.removeItem(currentRoom, target);
                          energy++;
                          verb = Ate;
                      } else {
                          verb = CanNotEat;
                      }
                  } else {
                      verb = IsAwareOfNo;
                  }
                  //updateVreg();

                  newS.clear(WmIndex.A);
                  newS.set(WmIndex.A.Conj, Conj.Simple);
                  newS.set(WmIndex.A.C1.When, Now);
                  newS.set(WmIndex.A.C1.Where, currentRoom);
                  newS.set(WmIndex.A.C1.Who, this.agentItem);
                  newS.set(WmIndex.A.C1.DoWhat, verb);
                  newS.set(WmIndex.A.C1.O1, target);

                  rememberAreg(newS);
                  world.vCommands.add(new VCommand(EatO1, agentItem, target));
              } break;

              case ApplyO1toO2: {
                  Object o1 = newS.get(WmIndex.A.C1.O1);
                  Object o2 = newS.get(WmIndex.A.C1.O2);
//                  Object o1 = newS.get(WmIndex.A.C1.O1);
//                  Object o2 = newS.get(WmIndex.A.C2.O1);
                  Object verb;
                  if (! world.containsItem(currentRoom, o1)) {
                      verb = CanNotApply;
                  } else if (! world.containsItem(currentRoom, o2)) {
                      verb = CanNotApply;
                  } else {
                      if (o1 == Stone && o2 == Shell) {
                          world.removeItem(currentRoom, o1);
                          world.removeItem(currentRoom, o2);
                          world.addItem(currentRoom, Nut);
                          verb = AppliedO1ToO2;

                      } else if (o1 == Key.Key1 && o2 == Box.Box1 ||
                              o1 == Key.Key2 && o2 == Box.Box2 ||
                              o1 == Key.Key3 && o2 == Box.Box3
                              ) {
                          Object content = ((Box)o2).content; 
                          world.removeItem(currentRoom, o1);
                          world.removeItem(currentRoom, o2);
                          if (content != null) {
                              world.addItem(currentRoom, content);
                          }
                          verb = AppliedO1ToO2;
                                  
                      } else {
                          verb = CanNotApply;
                      }
                      //updateVreg();
                      world.vCommands.add(new VCommand(ApplyO1toO2, agentItem, o1, o2));
                  }
                  newS.clear(WmIndex.A);
                  newS.set(WmIndex.A.Conj, Conj.Simple);
                  newS.set(WmIndex.A.C1.When, Now);
                  newS.set(WmIndex.A.C1.Where, currentRoom);
                  newS.set(WmIndex.A.C1.Who, this.agentItem);
                  newS.set(WmIndex.A.C1.DoWhat, verb);
                  newS.set(WmIndex.A.C1.O1, o1);
                  newS.set(WmIndex.A.C1.O2, o2);
                  rememberAreg(newS);
              } break;

              case GoDir: {
                  int argc = actionParamState.getInt(WmIndex.A.C1.head);
                  Lab.assertTrue(argc == 1);
                  String dir = (String)actionParamState.get(WmIndex.A.C1.head + 1);
                  // ړvZB˂ꍇ݂͌̃GÂ܂܁B
                  int newRoomID = neighborRoomID(roomID, dir);
                  Room oldRoom = currentRoom;
                  Room newRoom = world.rooms[newRoomID];

                  world.removeItem(currentRoom, agentItem);
                  currentRoom = newRoom;
                  world.addItem(currentRoom, agentItem);
                  //
                  recogRoom();
                  world.vCommands.add(new VCommand(GoDir, agentItem, oldRoom, newRoom));
              } break;

              case GoToRoom: {
                  int argc = actionParamState.getInt(WmIndex.A.C1.head);
                  Lab.assertTrue(argc == 1);
                  Room oldRoom = currentRoom;
                  Room newRoom = (Room)actionParamState.get(WmIndex.A.C1.head + 1);
                  if (world.checkImpassableRoutes(currentRoom, newRoom)) {
                      newRoom  = world.rooms[0]; // Go to the start room.
                  }
                  world.removeItem(currentRoom, agentItem);
                  currentRoom = newRoom;
                  world.addItem(currentRoom, agentItem);
                  //
                  recogRoom();
                  world.vCommands.add(new VCommand(GoToRoom, agentItem, oldRoom, newRoom));
              } break;

              case TakeO1ToO2: {
                  Object o1 = newS.get(WmIndex.A.C1.O1);
                  Room newRoom = (Room)newS.get(WmIndex.A.C1.O2);
                  Room oldRoom = currentRoom;
                  Object verb;
                  if (! world.containsItem(currentRoom, o1)) {
                      verb = CanNotApply; // TODO: K؂ȖOɕύX
                  } else {
                      world.removeItem(currentRoom, agentItem);
                      world.removeItem(currentRoom, o1);
                      currentRoom = newRoom;
                      world.addItem(currentRoom, agentItem);
                      world.addItem(currentRoom, o1);
                      verb = TookO1FromO2;
                  }

                  //
                  newS.clear(WmIndex.A);
                  newS.set(WmIndex.A.Conj, Conj.Simple);
                  newS.set(WmIndex.A.C1.When, Now);
                  newS.set(WmIndex.A.C1.Where, currentRoom);
                  newS.set(WmIndex.A.C1.Who, this.agentItem);
                  newS.set(WmIndex.A.C1.DoWhat, verb);
                  newS.set(WmIndex.A.C1.O1, o1);
                  newS.set(WmIndex.A.C1.O2, oldRoom);

                  rememberAreg(newS);

                  world.vCommands.add(new VCommand(TakeO1ToO2, agentItem, oldRoom, newRoom, o1));

              } break;

              case RecogRoom : {
                  recogRoom();
              } break;

              case FindItem : {
                  findItem(actionParamState);
              } break;

              case Listen : {
                  if (sentenceBuf != null) {
                      // obt@̒g a WX^ɏށB
                      for (int i = 0; i < WmIndex.A.size; i++) {
                          newS.set(WmIndex.A.head + i, 
                                  sentenceBuf.get(WmIndex.A.head + i));
                      }
                      rememberAreg(newS);
                      if (panel.flag("Show sentenceBuf in action log")) {
                          env.viewPanel.println("Action log of "+ agentItem, 
                                  "Listen: sentenceBuf="+ sentenceBuf);
                      }           
                      world.vCommands.add(new VCommand(Listen, agentItem, sentenceBuf.toString()));
                      // obt@͋ɂB
                      sentenceBuf = null;
                  } else {
                      // Do nothing. Just listen to new utterance.
                  }
              } break;

              case SayIt : {
                  // a WX^̏ԃ`FbNBԈĂ΃G[bZ[Wo Fail B
                  // TODOF ƂƎB
                  Lab.assertTrue(oldS.get(WmIndex.A.C1.DoWhat) == WantsToSayTo);

                  // B
                  Object targetName = oldS.get(WmIndex.A.C1.O1);
                  Agent a = world.findAgent(targetName);
                  if (a == null) {
                      throw new Error("SayIt: targetName "+ targetName+ " does not exist.");
                  }
                  if (a.sentenceBuf == null) {
                      // be𑊎̕obt@ɏށB
                      State buf = new State(new Object[WmIndex.A.size]);
                      for (int i = 0; i < WmIndex.A.size; i++) {
                          buf.set(WmIndex.A.head + i, 
                                  oldS.get(WmIndex.A.head + i));
                      }
                      buf.set(WmIndex.A.C1.Who, this.agentItem); // ID
                      buf.set(WmIndex.A.C1.O1, a.agentItem); // ID
                      buf.set(WmIndex.A.C1.DoWhat, SaidTo);
                      a.sentenceBuf = buf;

                      //  a WX^̒l WantsToSayTo  SaidTo ɕύXB
                      newS.set(WmIndex.A.C1.DoWhat, SaidTo);

                      // V a WX^̓eGs\[hLɂĂB
                      rememberAreg(newS);
                      //                State aReg = getReg(WmIndex.A, newS);
                      //                episodeMem.add(0, aReg); // Insert to the top of the list.
                      //                episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);
                      world.vCommands.add(new VCommand(SayIt, agentItem, a.agentItem, a.sentenceBuf.toString()));

                  } else {
                      // Do nothing. The utterance is just ignored.
                  }
              } break;


              default: {
                  System.out.println("action: "+ action);
                  Lab.assertTrue(false);
              } break;
              }
          }
          /** ׂ̃GAԂB˂ꍇ݂͌̃GAB */
          public int neighborRoomID(int roomID, String dir) {
              int rx = roomID % mapSizeX;
              int ry = roomID / mapSizeX;
              if (dir == West && rx > 0) {
                  rx--;
              } else if (dir == North && ry < mapSizeY - 1) {
                  ry++;
              } else if (dir == South && ry > 0) {
                  ry--;
              } else if (dir == East && rx < mapSizeX - 1) {
                  rx++;
              } else {
                  // Do nothing.
                  //throw new Error("dir="+ dir);
              }
              return ry * mapSizeX + rx;
          }
          public void recogRoom() {
              newS.clear(WmIndex.A);
              newS.set(WmIndex.A.Conj, Conj.Simple);
              newS.set(WmIndex.A.C1.When, Now);
              newS.set(WmIndex.A.C1.Where, currentRoom);
              newS.set(WmIndex.A.C1.Who, this.agentItem);
              newS.set(WmIndex.A.C1.DoWhat, Exists);
              newS.set(WmIndex.A.C1.O1, 0);
              newS.set(WmIndex.A.C1.O2, 0);

              rememberAreg(newS);

          }
          public void rememberAreg(State newS) {
              State aReg = getReg(WmIndex.A, newS);
              episodeMem.add(0, aReg); // Insert to the top of the list.
              episodeMemLog("Set: episodeList.add:"+ episodeMem.size()+ ":"+  aReg);          
          }

          public void findItem(State actionParamState) throws Fail {
              Boolean logFlag = panel.flag("findItem: logFlag", false); 
              if (logFlag) System.out.println("findItem: actionParamState="+ actionParamState);
              int objID = actionParamState.getInt(WmIndex.A.C1.Who);
              Object whatP = actionParamState.get(WmIndex.A.C1.O1);
              if (logFlag) {
                  System.out.println("findItem: world.counter="+ world.counter);
                  System.out.println("objID="+ objID);
                  System.out.println("whatP="+ whatP);
              }
              Lab.assertTrue(objID == 1 || objID == 2);
              Lab.assertTrue(whatP != null);
              Lab.assertTrue(whatP != Rule.WILDCARD);
              Lab.assertTrue(whatP != Rule.ZERO);

              // SWX^̒l oldS  newS ɃRs[B
              newS = new State(oldS.values.clone());
              Object verb;
              Object obj;

              if (whatP == PLS) {
                  if (world.numItems(currentRoom) > 0) {
                      // Room 烉_ɕ̂PIB
                      verb = IsAwareOf;
                      obj = world.findRandomItem(currentRoom);
                  } else {
                      // ̂PȂꍇB
                      verb = FindsNothing;
                      obj = null;
                  }
              } else {
                  if (world.containsItem(currentRoom, whatP)) {
                      verb = IsAwareOf;
                      obj = whatP;
                  } else {
                      verb = IsAwareOfNo;
                      obj = whatP;
                  }
              }

              RegisterIndex r;
              if (objID == 1) {
                  r = WmIndex.A;
              } else if (objID == 2) {
                  r = WmIndex.E;
              } else {
                  throw new Error();
              }
              newS.clear(r);
              newS.set(r.Conj, Conj.Simple);
              newS.set(r.C1.When, Now);
              newS.set(r.C1.Where, currentRoom);
              newS.set(r.C1.Who, this.agentItem);
              newS.set(r.C1.DoWhat, verb);
              newS.set(r.C1.O1, obj);
              newS.set(r.C1.O2, 0);
              rememberAreg(newS);

              if (logFlag) {
                  System.out.println("newS="+ newS);
              }
          }
//          Object calcBelief(Object p, Object l) throws Fail {
//              Object b;
//              if (p == Rule.WILDCARD) {
//                  b = l;
//              } else if (p == Rule.PLS) {
//                  if (l == Rule.ZERO) {
//                      throw new Fail();
//                  } else {
//                      b = l;
//                  }
//              } else {
//                  if (l == null) {
//                      b = p;
//                  } else if (l == p) {
//                      b = p;
//                  } else {
//                      // l != p
//                      throw new Fail();
//                  }
//              }            
//              return b;
//          }


          // Proven-proposition list
          /**
           * 
           */
          public List<State> episodeMem = null;
          /**
           * episodeList  query Ƀ}b`Gs\[hPIB
           * PȂꍇ null ԂB
           */
          public State findEpisode(State query) {
              // ܂͊ȒPȎBŏɌ̂PԂB
              return episodeMem.stream().filter(s -> s.episodeMatch(query))
                      .findFirst().orElse(null);
          }
          /**
           * knowledgeBase  query ̒lƃ}b`mPIB 
           * PȂꍇ null ԂB
           * class Rule 𗬗pȎB
           */
          public State findKnowledge(State query) {
              episodeMemLog("findKnowledge: query="+ query);
              Object[] vals = new Object[WmIndex.size * 2];
              for (int i = 0; i < WmIndex.size; i++) {
                  vals[i] = Rule.ZERO;
              }
              for (int i = 0; i < WmIndex.E.size; i++) {
                  vals[WmIndex.E.head + i] = query.values[i];
              }
              // Dummy value for g.
              for (int i = 0; i < WmIndex.size; i++) {
                  vals[WmIndex.size + i] = Rule.WILDCARD;
              }
              episodeMemLog("findKnowledge: (s,g)="+ new State(vals));
              //episodeLog("findKnowledge: kb size="+ knowledgeBase.size());
              // (s,g) Ƀ}b`郋[IB
              // [̐ parallelStream gĂ݂B
              List<Rule> matched = knowledgeBase.stream().filter(
                      r -> r.knowledgeMatch(vals)
                      ).collect(Collectors.toList());
              if (matched.size() == 0) return null;

              float[] q = calcRulePriorities(matched);
              Lab.assertTrue(q.length != 0);
              // softmax  Rule PIB * 錾Im̉lׂ͂ēB
              int index = softmax(q);
              if (panel.flag("findKnowledge: Show matched rules", false)){
                  env.viewPanel.println("matched"+ agentItem, "counter="+ world.counter);
                  for (int i = 0; i < matched.size(); i++) {
                      env.viewPanel.println("matched"+ agentItem, i+ ":"+ matched.get(i));
                  }
                  env.viewPanel.println("matched"+ agentItem, "selected: "+ index);
                  env.viewPanel.println("priority"+ agentItem, "counter="+ world.counter);
                  for (int i = 0; i < q.length; i++) {
                      env.viewPanel.println("priority"+ agentItem, i+ ":"+ q[i]);
                  }
                  env.viewPanel.println("probTable"+ agentItem, "counter="+ world.counter);
                  for (int i = 0; i < probTable.length; i++) {
                      env.viewPanel.println("probTable"+ agentItem, i+ ":"+ probTable[i]);
                  }
              }
              Rule selected = matched.get(index);
              episodeMemLog("findKnowledge: selected="+ selected);
              State param = new State(selected.getActionParam());
              episodeMemLog("findKnowledge: param="+ param);
              State ret = getReg(WmIndex.E, param);
              episodeMemLog("findKnowledge: ret="+ ret);
              return ret;
          }
          public void episodeMemLog(String s) {
              if (episodeMemLogFlag) {
                  env.viewPanel.println(episodeMemLogLabel+ agentItem, "c="+ world.counter+ ": "+ s);
              }
          }
          /**
           * Returns null if no episode found.
           */
          public State doRecall(State query) {
              episodeMemLog("doRecall");
              //episodeMemLog(" param="+ actionParamState);
              episodeMemLog(" query="+ query);
              State pp;
              // w肵mŃGs\[hLƐ錾Îǂ炩DIɑzNB
              // TODO: ɍŐṼGs\[hzN̂ł͂ȂA_ɑIB
              //        if (Lab.irand(2) == 0) {
              if (panel.getFloat("episode:knowledge", 0.5f, 0f, 1f) > Lab.rand()) {
                  pp = findEpisode(query);
                  if (pp == null) {
                      pp = findKnowledge(query);
                  }
              } else {
                  pp = findKnowledge(query);
                  if (pp == null) {
                      pp = findEpisode(query);
                  }
              }
              if (pp == null) {
                  episodeMemLog(" Not found.");
              } else {
                  episodeMemLog(" Found: "+ pp);
              }
              return pp;
          }
      }
      //--------------------------------------------------
      public boolean visualizeFlag;
      public boolean mapVisualizeFlag;
      public boolean episodeMemLogFlag;
      public String episodeMemLogLabel = "Episode mem log of ";
      public class World {
          public Room[] rooms;
          public Map<Room,Set<Object>> roomStates;
          public Room[] map;
          /** Array of {room1, room2}. Used by GoToRoom. */
          public Room[][] impassableRoutes;
          public Agent[] agents;
          public List<VCommand> vCommands = new ArrayList<>();

          public Agent findAgent(Object name) {
              for (int i = 0; i < agents.length; i++) {
                  if (agents[i].agentItem == name) return agents[i];
              }
              return null;
          }
          //
          public World(){
          }
          public void init() {
              agents = mainCode.makeAgents(this);
              mainCode.setMap(this);
              mainCode.initAgentsTable(this);
              printWorldInfo();
          }
          public int counter = 0;
          public Integer currentTime = 0; // not used. 
          public void main(){
              int episodes = 0;
              for (;;){
                  int steps = episode();
                  env.viewPanel.scatterPlot("Step/Episode", episodes, steps);
                  env.viewPanel.print1("episodes=", ""+ episodes++);
              }
          }
          public int episode() {
              visualizeFlag = panel.flag("visualizeFlag", true);
              mapVisualizeFlag = panel.flag("mapVisualizeFlag", true);
              episodeMemLogFlag = panel.flag("episodeMemLogFlag", true);
              panel.speedControl("Episode loop", 0);
              for (int i = 0; i < agents.length; i++) {
                  Agent a = agents[i];
                  a.setDefaultStartAndGoal();
              }
              world.initRoomStates();
              impassableRoutes = new Room[0][];
              mainCode.initEpisode(this);
              if (visualizeFlag){
                  if (mapVisualizeFlag) startVisualizeMap();
              }
              for (int i = 0; i < agents.length; i++) {
                  Agent agent = agents[i];
                  //a.observe(Rule.makeState(w(), Rule.KEEP), a.oldS);
                  agent.initEpisodeAndChooseFirstAction();
                  if (visualizeFlag){
                      if (mapVisualizeFlag) visualizeMap();
                      visualizeAgentState(agent);
                  }
                  if (panel.flag("Action log", true)) {
                      env.viewPanel.println("Action log of "+ agent.agentItem, "");   
                      env.viewPanel.println("Action log of "+ agent.agentItem, "First action choosed.");   
                  }
              }
              int steps = 0;
              // uOԖڂ̃G[WFgṽS[BGs\[hIƂB
              //while (! agents[0].oldS.satisfies(agents[0].goal) && steps++ < maxSteps){
              while (! agents[0].stack.isEmpty() && steps++ < maxSteps){
                  currentTime++;
                  for (int i = 0; i < agents.length; i++) {
                      env.viewPanel.print1("counter=", ""+ counter++);
                      Agent agent = agents[i];
                      if (visualizeFlag){
                          panel.speedControl("Step loop", 1);
                          //                    if (mapVisualizeFlag) visualizeMap();
                          //                    visualizeAgentState(agent);
                      }

                      agent.takeAction();
                      agent.chooseAction();
                      agent.update();

                      if (visualizeFlag){
                          if (mapVisualizeFlag) visualizeMap();
                          visualizeAgentState(agent);
                      }
                  }
                  if (panel.button("Print all rule.q")) {
                      printAllruleQ();
                  }
              }
              for (int i = 0; i < agents.length; i++) {
                  Agent agent = agents[i];
                  if (extraMonteLearningFlag) {
                      Stack<Rule> ruleHistoryCopy = (Stack<Rule>)agent.ruleHistory.clone();
                      Stack<Float> rewardHistoryCopy = (Stack<Float>)agent.rewardHistory.clone();
                      Stack<Rule> callerHistoryCopy = (Stack<Rule>)agent.callerHistory.clone();         

                      agent.extraMonteLearning();

                      agent.ruleHistory = ruleHistoryCopy;
                      agent.rewardHistory = rewardHistoryCopy;
                      agent.callerHistory = callerHistoryCopy;
                  }
                  if (! sarsaLearningFlag) agent.monteLearning();
              }                    
//              if (extraMonteLearningFlag) {
//                  for (int i = 0; i < agents.length; i++) {
//                      Agent agent = agents[i];
//                      agent.monteLearning();
//                  }                    
//              }
              return steps;
          }
          public void visualizeAgentState(Agent agent){
              {
                  String goalsLabel = "Goals of "+ agent.agentItem;
                  env.viewPanel.setText(goalsLabel, ""); // Clear text.
                  for (int i = 0; i < agent.stack.size(); i++) {
                      // Print elements from bottom to top.
                      env.viewPanel.println(goalsLabel, ""+ agent.stack.get(i));
                  }
                  env.viewPanel.println(goalsLabel, ""+ agent.oldG);
              }
              {
                  String logLabel = "Log of "+ agent.agentItem;
                  env.viewPanel.println(logLabel, "---");
                  env.viewPanel.println(logLabel, "world.counter = "+ world.counter);
                  if (agent.failedFlag) env.viewPanel.println(logLabel, "Last action failed.");
                  String s = "stack size="+ agent.stack.size()+ ":";
                  for (int i = agent.stack.size() - 1; i >= 0 ; i--) {
                      // Add elements from top to bottom.
                      s += agent.stack.get(i)+ ", ";
                  }
                  env.viewPanel.println(logLabel, s);
                  env.viewPanel.println(logLabel, "s,g="+ agent.oldS+
                          ", "+ agent.oldG);
                  env.viewPanel.println(logLabel, ""+ agent.oldR);
              }
              String ruleLabel = "rule.q of "+ agent.agentItem;
              env.viewPanel.scatterPlotFixedY(ruleLabel, 0, 0, -10, 0);// dummy
              env.viewPanel.resetGraphData(ruleLabel);
              agent.rules.forEach(r -> {
                  env.viewPanel.plot(ruleLabel, r.q);
              });
//              for (int i = 0; i < agent.rules.size(); i++) {
//                  env.viewPanel.scatterPlot(ruleLabel+ " learning", world.counter, agent.rules.get(i).q);
//              }
              if (extraMonteLearningFlag) {
                  String monteRuleLabel = "rule.monteQ of "+ agent.agentItem;
                  env.viewPanel.scatterPlotFixedY(monteRuleLabel, 0, 0, -10, 0);// dummy
                  env.viewPanel.resetGraphData(monteRuleLabel);
                  agent.rules.forEach(r -> {
                      env.viewPanel.plot(monteRuleLabel, r.monteQ);
                  });
//                  for (int i = 0; i < agent.rules.size(); i++) {
//                      env.viewPanel.scatterPlot(monteRuleLabel+ " learning", world.counter, agent.rules.get(i).monteQ);
//                  }
              }
          }
          //------------------------------------------------------
          //  access methods for the world state.
          //public Map<Room,Set<Object>> worldState;
          public void initRoomStates() {
              roomStates = new HashMap<Room,Set<Object>>();
              for (int i = 0; i < rooms.length; i++) {
                  Set<Object> set = new HashSet<Object>();
                  roomStates.put(rooms[i], set);
              }
          }
          public int numItems(Room room) {
              Lab.assertTrue(room != null);
              Set<Object> set = roomStates.get(room);
              if (set != null) {
                  return set.size();
              } else {
                  throw new Error();
              }
          }
          public boolean containsItem(Room room, Object item) {
              Lab.assertTrue(room != null);
              Set<Object> set = roomStates.get(room);
              if (set != null) {
                  return set.contains(item);
              } else {
                  throw new Error();
              }
          }
          public void removeItem(Room room, Object item) {
              Lab.assertTrue(room != null);
              Set<Object> set = roomStates.get(room);
              Lab.assertTrue(set.contains(item));
              if (set != null) {
                  set.remove(item);
              } else {
                  throw new Error();
              }
          }
          public void addItem(Room room, Object item) {
              Lab.assertTrue(room != null);
              Set<Object> set = roomStates.get(room);
              Lab.assertTrue(! set.contains(item));
              if (set != null) {
                  set.add(item);
              } else {
                  throw new Error();
              }
          }
          public Object findRandomItem(Room room) {
              Lab.assertTrue(room != null);
              Set<Object> set = roomStates.get(room);
              if (set != null) {
                  Object[] items = set.toArray();
                  if (items.length == 0) {
                      return null;
                  } else {
                      return items[Lab.irand(items.length)];
                  }
              } else {
                  throw new Error();
              }
          }
          public String roomStatesToString() {
              StringBuffer buf = new StringBuffer();
              for (int i = 0; i < rooms.length; i++) {
                  buf.append(rooms[i]+ ":");
                  Set<Object> set = roomStates.get(rooms[i]);
                  Object[] a = set.toArray();
                  // TODO: 񏇂Ń\[g
                  for (int j = 0; j < a.length; j++) {
                      buf.append(" "+ a[j]);
                  }
                  buf.append(System.getProperty("line.separator"));
              }
              return buf.toString();
          }

          //------------------------------------------------------

          public boolean checkImpassableRoutes(Room r1, Room r2) {
              for (int i = 0; i < world.impassableRoutes.length; i++) {
                  Room[] pair = world.impassableRoutes[i];
                  if (pair[0] == r1 && pair[1] == r2) return true;
              }
              return false;
          }
          
          //------------------------------------------------------

          public void visualizeMap(){
              if (panel.flag("Print Map", true)) printMap();
              env.viewPanel.paint("Map", mapPainter);
              vCommands.clear();
          }
          
          public String lastMapString;
          public String printMapLabel = "World log";
          public int printMapRowSize = -1;
          // eGs\[h̍ŏɌĂ΂B
          public void startVisualizeMap(){
              lastMapString = "";
              if (panel.flag("Print Map", true)) {
                  env.viewPanel.println(printMapLabel, "");

                  lab.Lab.WTextArea c = (lab.Lab.WTextArea)env.viewPanel.findWComponent(printMapLabel);
                  int rows = panel.getInt(printMapLabel+ " row size", 30, 10, 200);
                  if (printMapRowSize != rows) {
                      printMapRowSize = rows;
                      // TCYύXꂽe̓ZbgB
                      c.setSize(rows, 80);
                  }
                  
                  env.viewPanel.println(printMapLabel, "==========");
                  env.viewPanel.println(printMapLabel, "Start episode.");

              }
          }
          public void printMap() {
              String str = world.roomStatesToString();
              boolean skipPrintMap = str.equals(lastMapString); 
              lastMapString = str;
              if (skipPrintMap && vCommands.size() == 0) {
                  env.viewPanel.print(printMapLabel, ".");
              } else {
                  env.viewPanel.println(printMapLabel, "");
                  env.viewPanel.println(printMapLabel, "c="+ world.counter);
                  if (vCommands.size() != 0) {
                      vCommands.forEach(com -> env.viewPanel.println(printMapLabel, com.toString()));
                  }
                  if (! skipPrintMap) {
                      env.viewPanel.print(printMapLabel, str);
                  }
              }
          }
          public String allruleQLabel = "All rule.q";
          public String allruleMonteQLabel = "All rule.monteQ";
          public void printAllruleQ() {
              env.viewPanel.setText(allruleQLabel, "");
              for (int i = 0; i < agents.length; i++) {
                  env.viewPanel.println(allruleQLabel, ""+ agents[i].agentItem);
                  env.viewPanel.println(allruleQLabel, "returnRule.q: "+ Rule.returnRule.q);
                  env.viewPanel.println(allruleQLabel, "returnRule.base: "+ Rule.returnRule.base);
                  env.viewPanel.println(allruleQLabel, "startRule.q: "+ Rule.startRule.q);
                  env.viewPanel.println(allruleQLabel, "startRule.base: "+ Rule.startRule.base);
                  env.viewPanel.println(allruleQLabel, "r.base:");
                  for (int j = 0; j < agents[i].rules.size(); j++) {
                      Rule r = agents[i].rules.get(j);
                      env.viewPanel.println(allruleQLabel, j+ "\t"+ r.name+ "\t"+ r.base);
                  }
                  env.viewPanel.println(allruleQLabel, "");
                  env.viewPanel.println(allruleQLabel, "r.q:");
                  for (int j = 0; j < agents[i].rules.size(); j++) {
                      Rule r = agents[i].rules.get(j);
                      env.viewPanel.println(allruleQLabel, j+ "\t"+ r.name+ "\t"+ r.q);
                  }
                  env.viewPanel.println(allruleQLabel, "");
              }
              if (extraMonteLearningFlag) {
                  env.viewPanel.setText(allruleMonteQLabel, "");
                  for (int i = 0; i < agents.length; i++) {
                      env.viewPanel.println(allruleMonteQLabel, ""+ agents[i].agentItem);
                      env.viewPanel.println(allruleMonteQLabel, "returnRule.monteQ: "+ Rule.returnRule.monteQ);
                      env.viewPanel.println(allruleMonteQLabel, "returnRule.monteBase: "+ Rule.returnRule.monteBase);
                      env.viewPanel.println(allruleMonteQLabel, "startRule.monteQ: "+ Rule.startRule.monteQ);
                      env.viewPanel.println(allruleMonteQLabel, "startRule.monteBase: "+ Rule.startRule.monteBase);
                      env.viewPanel.println(allruleMonteQLabel, "r.monateBase:");
                      for (int j = 0; j < agents[i].rules.size(); j++) {
                          Rule r = agents[i].rules.get(j);
                          env.viewPanel.println(allruleMonteQLabel, j+ "\t"+ r.name+ "\t"+ r.monteBase);
                      }
                      env.viewPanel.println(allruleMonteQLabel, "");
                      env.viewPanel.println(allruleMonteQLabel, "r.monteQ:");
                      for (int j = 0; j < agents[i].rules.size(); j++) {
                          Rule r = agents[i].rules.get(j);
                          env.viewPanel.println(allruleMonteQLabel, j+ "\t"+ r.name+ "\t"+ r.monteQ);
                      }
                      env.viewPanel.println(allruleMonteQLabel, "");
                  }
              }
          }
          
          public MapPainter mapPainter = new MapPainter();
          public int charSize = panel.getInt("charSize", 24, 1, 40);
          public Font f = new Font("lr SVbN", Font.PLAIN, charSize);
          //public Font f = new Font("Segoe UI Emoji", Font.PLAIN, charSize);
          public class MapPainter extends Lab.Code implements Lab.Painter {
              public Dimension getSize(){
                  // dummy
                  return new Dimension(100,100);

//                  int totalSizeX = mapSizeX * roomSizeX;
//                  int totalSizeY = mapSizeY * roomSizeY;
//                  int totalSizeX = mapSizeX * roomSizeX;
//                  int totalSizeY = mapSizeY * roomSizeY;
//                  return new Dimension(charSize * (totalSizeX + 1),
//                          charSize * (totalSizeY + 1));
              }
              int counter = 0;
              public void paintComponent(Graphics g, MouseEvent lastEvent) {
//                  if (map.length == 0) return;
//                  // W (0,0) ƂB
//                  // x=0 or y=0 ͕ǁBǂł͂Ȃ x, y >= 1 Ŵݕ`悷B 
//                  g.setFont(f);
//                  for (int ry = 0; ry < mapSizeY; ry++) {
//                      for (int rx = 0; rx < mapSizeX; rx++) {
//                          g.setColor(Color.BLACK);
//                          g.drawString(areas[ry * mapSizeX + rx].name,
//                                  posX(rx, ry, 1, roomSizeY-1), 
//                                  posY(rx, ry, 1, roomSizeY-1));
//
//                          for (int y = 1; y < roomSizeY; y++) {
//                              for (int x = 1; x < roomSizeX; x++) {
//                                  int r = ry * mapSizeX + rx;
//                                  int p = y * roomSizeX + x; 
//                                  String str = map[r][p].code;
//                                  g.setColor(Color.BLACK);
//                                  g.drawString(str,
//                                          posX(rx, ry, x, y-1), 
//                                          posY(rx, ry, x, y-1));
//                              }
//                          }
//                      }
//                  }
//                  for (int i = 0; i < agents.length; i++) {
//                      paintAgent(agents[i], g);
//                  }
              }
              public void paintAgent(Agent a, Graphics g) {
                  //            for (int i = 0; i < vCommands.size(); i++) {
                  //                paintVCommand(g, vCommands.get(i));
                  //            }
                  //
                  //            int roomID = a.getCurrentRoomID();
                  ////            int selfRX = roomID % mapSizeX;
                  ////            int selfRY = roomID / mapSizeX;
                  ////            int selfX = 0, selfY = 0;
                  //            int selfPos = -1;
                  //            // Find self
                  ////            for (int y = 1; y < roomSizeY; y++) {
                  ////                for (int x = 1; x < roomSizeX; x++) {
                  ////                    if (map[roomID][y * roomSizeX + x] == a.agentName) {
                  ////                        selfX = x; selfY = y;
                  ////                        selfPos = y * roomSizeX + x;
                  ////                    }
                  ////                }
                  ////            }
                  ////            Lab.assertTrue(selfX != 0 && selfY != 0);
                  //            for (int i = 0; i < map[roomID].length; i++) {
                  //                if (map[roomID][i] == a.agentItem) {
                  //                    selfPos = i;
                  //                }
                  //            }
                  //            Lab.assertTrue(selfPos != -1);
                  //
                  ////            int rx = roomID % mapSizeX;
                  ////            int ry = roomID / mapSizeX;
                  //            int where1 = a.newS.getInt(WmIndex.V.O1Where);
                  //            Lab.assertTrue(where1 != -1);
                  ////            int x1 =  where1 % roomSizeX;
                  ////            int y1 =  where1 / roomSizeX;
                  //            int where2 = a.newS.getInt(WmIndex.V.O2Where);
                  //            Lab.assertTrue(where2 != -1);
                  ////            int x2 =  where2 % roomSizeX;
                  ////            int y2 =  where2 / roomSizeX;
                  //            
                  //            if (where1 != 0) {
                  //                g.setColor(Color.GREEN);
                  ////                g.drawRect(posX(rx, ry, x1, y1), posY(rx, ry, x1, y1),
                  ////                        charSize - 2, charSize - 2);
                  ////                g.drawString("1", 
                  ////                        posX(rx, ry, x1, y1), posY(rx, ry, x1, y1));
                  ////                
                  ////                g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                  ////                        posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                  ////                        posX(rx, ry, x1, y1) + charSize/2,
                  ////                        posY(rx, ry, x1, y1) + charSize/2);
                  //                g.drawRect(posX(roomID, where1), posY(roomID, where1),
                  //                        charSize - 2, charSize - 2);
                  //                g.drawString("1", 
                  //                        posX(roomID, where1), posY(roomID, where1));
                  //                
                  //                g.drawLine(posX(roomID, selfPos) + charSize/2,
                  //                        posY(roomID, selfPos) + charSize/2,
                  //                        posX(roomID, where1) + charSize/2,
                  //                        posY(roomID, where1) + charSize/2);
                  //            }
                  //            if (where2 != 0) {
                  //                g.setColor(Color.RED);
                  //                // `̘g2sNZ炵ĕ\B
                  ////                g.drawRect(posX(rx, ry, x2, y2) + 2, posY(rx, ry, x2, y2) + 2,
                  ////                        charSize - 2, charSize - 2);
                  ////                g.drawString("2", 
                  ////                        posX(rx, ry, x2, y2), posY(rx, ry, x2, y2));
                  ////                
                  ////                g.drawLine(posX(selfRX, selfRY, selfX, selfY) + charSize/2,
                  ////                        posY(selfRX, selfRY, selfX, selfY) + charSize/2,
                  ////                        posX(rx, ry, x2, y2) + charSize/2,
                  ////                        posY(rx, ry, x2, y2) + charSize/2);
                  //                g.drawRect(posX(roomID, where2) + 2, posY(roomID, where2) + 2,
                  //                        charSize - 2, charSize - 2);
                  //                g.drawString("2", 
                  //                        posX(roomID, where2), posY(roomID, where2));
                  //                
                  //                g.drawLine(posX(roomID, selfPos) + charSize/2,
                  //                        posY(roomID, selfPos) + charSize/2,
                  //                        posX(roomID, where2) + charSize/2,
                  //                        posY(roomID, where2) + charSize/2);
                  //            }
                  //            if (false) {
                  //                // A WX^̈ꕔ\Ă݂B
                  //                g.setColor(Color.GRAY);
                  //                Font font = g.getFont();
                  //                g.setFont(font.deriveFont(font.getSize2D() / 3));
                  //                g.drawString(""+ a.newG.get(WmIndex.A.C1.Where)+ 
                  //                        ","+ a.newG.get(WmIndex.A.C1.Who)+ 
                  //                        ","+ a.newG.get(WmIndex.A.C1.DoWhat), 
                  //                        posX(roomID, selfPos), posY(roomID, selfPos));
                  //                g.setFont(font);
                  //            }
              }
          } // class MapPainter
//          public int posX(int rx, int ry, int x, int y) {
//              return (rx * roomSizeX + x) * charSize;
//          }
//          public int posY(int rx, int ry, int x, int y) {
//              return  (mapSizeY * roomSizeY 
//                      - (ry * roomSizeY + y) 
//                      )
//                      * charSize;
//          }
//          public int posX(int roomID, int pos) {
//              int rx = roomID % mapSizeX;
//              int ry = roomID / mapSizeX;
//              int x = pos % roomSizeX;
//              int y = pos / roomSizeX;
//              return (rx * roomSizeX + x) * charSize;
//          }
//          public int posY(int roomID, int pos) {
//              int rx = roomID % mapSizeX;
//              int ry = roomID / mapSizeX;
//              int x = pos % roomSizeX;
//              int y = pos / roomSizeX;
//              return  (mapSizeY * roomSizeY 
//                      - (ry * roomSizeY + y) 
//                      )
//                      * charSize;
//          }
          public Integer stateElemToInteger(Object elem) {
              if (elem instanceof Integer) {
                  return (Integer)elem;
              } else {
                  return null;
              }
          }
          public void paintVCommand(Graphics g, VCommand com) {
              if (com.action == GoDir) {
//                  Lab.assertTrue(com.args.length == 5);
//                  Item item = (Item)com.args[0];
//                  int oldRoomID = (Integer)com.args[1];
//                  int newRoomID = (Integer)com.args[2];
//                  int oldPos = (Integer)com.args[3];
//                  int newPos = (Integer)com.args[4];
//                  java.awt.Stroke oldStroke = ((java.awt.Graphics2D)g).getStroke();
//                  ((java.awt.Graphics2D)g).setStroke(new java.awt.BasicStroke(14));
//                  g.setColor(new Color(230,230,230)); // very light gray
//                  g.drawLine(posX(oldRoomID, oldPos) + charSize/2,
//                          posY(oldRoomID, oldPos) + charSize/2,
//                          posX(newRoomID, newPos) + charSize/2,
//                          posY(newRoomID, newPos) + charSize/2);
//                  ((java.awt.Graphics2D)g).setStroke(oldStroke);

//              } else if (com.action == MoveO1toO2) {
//                  Lab.assertTrue(com.args.length == 5);
//                  Item item = (Item)com.args[0];
//                  int oldRoomID = (Integer)com.args[1];
//                  int newRoomID = (Integer)com.args[2];
//                  int oldPos = (Integer)com.args[3];
//                  int newPos = (Integer)com.args[4];
//                  java.awt.Stroke oldStroke = ((java.awt.Graphics2D)g).getStroke();
//                  ((java.awt.Graphics2D)g).setStroke(new java.awt.BasicStroke(14));
//                  g.setColor(new Color(230,255,230)); // very light green
//                  g.drawLine(posX(oldRoomID, oldPos) + charSize/2,
//                          posY(oldRoomID, oldPos) + charSize/2,
//                          posX(newRoomID, newPos) + charSize/2,
//                          posY(newRoomID, newPos) + charSize/2);
//                  ((java.awt.Graphics2D)g).setStroke(oldStroke);

              } else {
                  throw new Error();
              }
          }

          /**
           * fobOpɏóB
           */
          public void printWorldInfo() {
              System.out.println();
              System.out.println("mainCode = "+  AbstractMainCode.this.getClass().getName());
              System.out.println();

              for (int i = 0; i < agents.length; i++) {
                  Agent a = agents[i];
                  System.out.println("Rules for agent "+ a.agentItem);
                  for (int j = 0; j < a.rules.size(); j++) {
                      System.out.println(""+ a.rules.get(j));
                  }
                  System.out.println();
              }
              System.out.println();
          }
      }

      /** R}h */
      public static class VCommand {
          PrimitiveAction action;
          Object args[];
          public VCommand(PrimitiveAction action, Object... args) {
              this.action = action; this.args = args;
          }
          public String toString() {
              StringBuffer buf = new StringBuffer();
              buf.append(action+ "(");
              for (int i = 0; i < args.length; i++) {
                  buf.append(args[i]+ ",");
              }
              buf.append(")");
              return buf.toString();
          }
      }
      

      //--------------------------------------------------
      // DSL for rule definition. 
      VariableN x = new VariableN("x");
      VariableN y = new VariableN("y");
      VariableN z = new VariableN("z");
      public static final String __ = Rule.WILDCARD; // Two underscores.
      public static final String PLS = Rule.PLS;
      public static final String NA = "NA".intern();
      public RegisterN a(Object conj, ClauseN c1, ClauseN c2) { return new RegisterN("a", conj, c1, c2); }
      public RegisterN a(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { return new RegisterN("a", conj, c1, c2, c3); }
      public RegisterN b(Object conj, ClauseN c1, ClauseN c2) {
          throw new Error("Not used.");
          //return new RegisterN("b", conj, c1, c2); 
      }
      public RegisterN e(Object conj, ClauseN c1, ClauseN c2) { return new RegisterN("e", conj, c1, c2); }
      public RegisterN e(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { return new RegisterN("e", conj, c1, c2, c3); }
      public RegisterN a(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
          return new RegisterN("a", Conj.Simple, new ClauseN(when, where, who, doWhat, o1, o2), null); 
      }
      public RegisterN b(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
          return new RegisterN("b", Conj.Simple, new ClauseN(when, where, who, doWhat, o1, o2), null); 
      }
      public RegisterN e(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
          return new RegisterN("e", Conj.Simple, new ClauseN(when, where, who, doWhat, o1, o2), null); 
      }

      public RegisterN a(Object who, Object doWhat) {
          return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
      }
      public RegisterN b(Object who, Object doWhat) {
          return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
      }
      public RegisterN e(Object who, Object doWhat) {
          return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0), null); 
      }

      public RegisterN a(Object doWhat) {
          return new RegisterN("a", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
      }
      public RegisterN b(Object doWhat) {
          return new RegisterN("b", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
      }
      public RegisterN e(Object doWhat) {
          return new RegisterN("e", Conj.Simple, new ClauseN(Time.Anytime, Room.Anywhere, 0, doWhat, 0, 0), null); 
      }

      public RegisterN a(ClauseN c) {
          return new RegisterN("a", Conj.Simple, c, null); 
      }
      public RegisterN b(ClauseN c) {
          return new RegisterN("b", Conj.Simple, c, null); 
      }
      public RegisterN e(ClauseN c) {
          return new RegisterN("e", Conj.Simple, c, null); 
      }
      public static class RegisterNArgs {
          public Object conj;
          public ClauseN c1, c2, c3;
          public RegisterNArgs(Object conj, ClauseN c1, ClauseN c2, ClauseN c3) { 
              this.conj = conj; this.c1 = c1; this.c2 = c2; this.c3 = c3;
          }
      }
      public RegisterN a(RegisterNArgs a) {
          return new RegisterN("a", a.conj, a.c1, a.c2, a.c3); 
      }
      public RegisterN b(RegisterNArgs a) {
          return new RegisterN("b", a.conj, a.c1, a.c2, a.c3); 
      }
      public RegisterN e(RegisterNArgs a) {
          return new RegisterN("e", a.conj, a.c1, a.c2, a.c3); 
      }

      public ClauseN c(Object when, Object where, Object who, Object doWhat, Object o1, Object o2) {
          return new ClauseN(when, where, who, doWhat, o1, o2); 
      }
      public ClauseN c(Object who, Object doWhat) {
          return new ClauseN(Time.Anytime, Room.Anywhere, who, doWhat, 0, 0); 
      }
      //public ClauseN c(Object... args) { return parseClause(args); }
      //public PropositionN a(Object... args) { return parseSimpleSentence("a", args); }
      //public PropositionN b(Object... args) { return parseSimpleSentence("b", args); }
      //public PropositionN s(Object... args) { return parseSimpleSentence("s", args); }
      //public PropositionN e(Object... args) { return parseSimpleSentence("e", args); }
      //public PropositionN parseSimpleSentence(String regName, Object[] args) {
      //    return new PropositionN(regName, Conj.Simple, parseClause(args), null);
      //}
      //public ClauseN parseClause(Object[] args) {
      //    if (args.length != 6) throw new Error("parseClauseArgs: args' length is not 6: "+ args);
      //    return new ClauseN(args[0], args[1], args[2], args[3], args[4], args[5]);
      //}
      public StateN w(RegisterN a, RegisterN b, RegisterN e){
          if (! (a.regName.equals("a")
                  && b.regName.equals("b")
                  && e.regName.equals("e")
                  )){
              throw new Error("Syntax error in w("+ a+ ", "+ b+ ", "+ e+ ")");
          }
          return new StateN(a, b, e);
      }
      // w(a(...), b(...)) or w(a(...), e(...))
      public StateN w(RegisterN a, RegisterN x){ 
          if (! a.regName.equals("a")){
              throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");
          } else if (x.regName.equals("b")) {
              return new StateN(a, x, null);
          } else if (x.regName.equals("e")) {
              return new StateN(a, null, x);
              //    } else if (x.regName.equals("v")) {
              //        return new StateN(a, null, null, x);
          } else {
              throw new Error("Syntax error in w("+ a+ ", "+ x+ ")");          
          }
      }
      // w(a(...)) or w(b(...)) or w(e(...))
      public StateN w(RegisterN x){ 
          if (x.regName.equals("a")){
              return new StateN(x, null, null);
          } else if (x.regName.equals("b")) {
              return new StateN(null, x, null);
          } else if (x.regName.equals("e")) {
              return new StateN(null, null, x);
          } else {
              throw new Error("Syntax error in w("+ x+ ")");          
          }
      }
      public StateN w() {
          return new StateN(null, null, null);
      }
      public ActionN call(StateN s){ return new ActionN(Call, s); }
      public ActionN call(RegisterN s){ return new ActionN(Call, w(s)); }
      public ActionN tryCall(StateN s){ return new ActionN(Try, s); }
      public ActionN tryCall(RegisterN s){ return new ActionN(Try, w(s)); }
      public ActionN callm(RegisterN s){
          if (! s.regName.equals("a")) throw new Error("Argument of callm should be a(...)");
          return new ActionN(CallM, w(s));
      }
      //public ActionN call(VisualRegisterN v){ return new ActionN(VisualCall, w(v)); }
      public ActionN set(RegisterN s) { 
          if (s.regName.equals("a")) {
              return new ActionN(SetM, w(s));
              //return new ActionN(Set, w(s));
          } else {
              return new ActionN(Set, w(s));
          }
      }
      public ActionN set(StateN s) { return new ActionN(Set, s); }
      
      public ActionN exit(RegisterN s) { return new ActionN(Exit, w(s)); }
      public ActionN exit(StateN s) { return new ActionN(Exit, s); }

      public ActionN recall(RegisterN s){
          if (! s.regName.equals("e")) throw new Error("Argument of recall should be e(...)");
          return new ActionN(Recall, w(s)); 
      }
      public ActionN recall(ClauseN c){ return new ActionN(Recall, w(e(Conj.Simple, c, null))); }
      public ActionN primitive(PrimitiveAction prim, Object... args) {
          Object[] argv = new Object[WmIndex.A.C1.size - 1];
          Lab.assertTrue(args.length <= argv.length);
          for (int i = 0; i < argv.length; i++) argv[i] = 0; // default value
          for (int i = 0; i < args.length; i++) argv[i] = args[i];
          Integer argc = args.length;
          return new ActionN(prim, w(a(argc,argv[0],argv[1],argv[2],argv[3],argv[4])));
      }
      public ActionN primitive(PrimitiveAction prim, StateN arg) {
          return new ActionN(prim, arg);
      }

      //public ActionN obsAgent(Object what, Object where) { return obsAction(0, what, where); }
      public ActionN findItemA(Object what) { return findItemAction(1, what); }
      public ActionN findItemE(Object what) { return findItemAction(2, what); }
      public ActionN findItemAction(int regID, Object what) {
          return new ActionN(FindItem, w(a(0,0,regID,0,what,0)));
      }

      public ClauseN varClause(String name) {
          VariableN[] a = new VariableN[WmIndex.A.C1.size];
          for (int i = 0; i < a.length; i++) {
              a[i] = new VariableN(name+ i);
          }
          return new ClauseN(a[0],a[1],a[2],a[3],a[4],a[5]); 
      }
      public RegisterNArgs varRegisterNArgs(String name) {
          return new RegisterNArgs(new VariableN(name+ "_conj"),
                  varClause(name+ "_c1_"),
                  varClause(name+ "_c2_"),
                  varClause(name+ "_c3_"));
      }

      // To define task goal. Usage: taskGoal(a(...));
      public void taskGoal(StateN x) {
          setRulesName("tg");
          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
          rule(w(), tg, call(x));
          rule(x, tg, set(a(Verb.TaskCompleted)));
      }

      /**
       * Agent ƂɎs[WA̍ۂɈꎞIɓϐB
       */
      public List<RuleN> ruleList;
      public String rulesName = "";
      public int rulesI = 0;
      /**
       * fobOpɁA`s[ɂ킩₷OtB
       *  "t" ȂAȌ`s[ t1, t2, ... ƂOIɕtB
       */
      public void setRulesName(String s) {
          rulesName = s;
          rulesI = 0;
      }
      private void addRule1(StateN s, StateN g, ActionN a) {
          rulesI++;
          ruleList.add(new RuleN(rulesName+ "."+ rulesI, s, g, a));
      }
      // rule(s, g, call/set(...))
      public void rule(StateN s, StateN g, ActionN a){ addRule1(s, g, a); }
      public void rule(RegisterN s, StateN g, ActionN a){ addRule1(w(s), g, a); }
      // rule(s, g, Primitive)
      public void rule(StateN s, StateN g, PrimitiveAction a){ addRule1(s, g, new ActionN(a, null)); }
      public void rule(RegisterN s, StateN g, PrimitiveAction a){ addRule1(w(s), g, new ActionN(a, null)); }
      // rule(s, g, Primitive, s(...))
      public void rule(StateN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(s, g, new ActionN(a, arg)); }
      public void rule(RegisterN s, StateN g, PrimitiveAction a, StateN arg){ addRule1(w(s), g, new ActionN(a, arg)); }

      /**
       * Agent ƂɎ錾ImA̍ۂɈꎞIɓϐB
       */
      public List<Rule> knowledgeList = new ArrayList<>();
      /**
       * Knowledge declaration.
       */
      public void k(RegisterN e) {
          // ̓sɂAm e  class Rule ̃CX^XɃGR[hĕێB
          if (! e.regName.equals("e")) throw new Error("Knowledge declaration: Usege: k(e(...));");
          rulesI++;
          RuleN ruleN = new RuleN("k-"+ rulesName+ rulesI,
                  new StateN(null, null, e), 
                  new StateN(null, null, null), 
                  new ActionN(Set, w(e)));
          Rule r = new Rule(ruleN);
          knowledgeList.add(r);
          System.out.println("k: sharedKnowledgeBase.add: "+ r );
      }



      // End of DSL functions.

      // Methods for Task initialization.
      //
      public abstract Agent[] makeAgents(World world);
      /**
       * e Agent ɁA\bh listRules ŗ񋓂Ăs[ݒ肷B
       * ̃\bhIo[Ch邱ƂŁA Agent ƂɈقȂs[
       * ݒ肷邱Ƃ\B
       */
      public void initAgentsTable(World world) {
          for (int i = 0; i < world.agents.length; i++) {
              Agent a = world.agents[i];
              ruleList = new ArrayList<>();
              addRules(world, i);
              a.rules = ruleList.stream().map(
                      ruleN ->  new Rule(ruleN)
                      ).collect(Collectors.toList());
              //        for (int j = 0; j < a.rules.size(); j++) {
              //            a.rules.get(j).name = j; // Use for debug.
              //        }

              // KvȂ q lBƂ肠Ô܂܂ƂB

              if (panel.flag("Add incorrect rules", false)) {
                  addIncorrectRules(a);
              }
          }
      }
      public abstract void addRules(World world, int agentID);
      /*
       * KȂs[ǉBs[̉l̊wK@\̃eXgEfړIB
       */
      public void addIncorrectRules(Agent a) {
          // ruleList ݂̌̒lgāAȂs[쐬B
          List<RuleN> extraRuleList = new ArrayList<>();
          // es[ƂɁAANV Fail ɕςuԈs[vǉB
          int n = ruleList.size();
          ruleList.forEach(rule -> {
              extraRuleList.add(new RuleN("*"+ rule.name,
                      rule.s,
                      rule.g, 
                      new ActionN(NOP, null))
                      );
          });
          a.rules.addAll(extraRuleList.stream().map(
                  ruleN ->  new Rule(ruleN)
                  ).collect(Collectors.toList())
                  );
      }

      /**
       * }bṽCAEg̐ݒB
       * ̃\bhI[o[Ch邱ƂňقȂ郌CAEg̃}bvɂ邱Ƃ\B
       */
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      // ̃}bv̐ݒB setMap ̒ĂԁB
      public void setEmptyMap(World world) {
          mapSizeX = 0;
          mapSizeY = 0;
          world.rooms = new Room[]{};
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      /**
       * wK̃Gs\[hsƂ̏̃\bhōsB 
       */
      public abstract void initEpisode(World world); 

  }


  public static class Test0Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] { new Agent(Alice, world)}; }
      public void addRules(World world, int agentID){
          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, set(tg));
      }
      public void setMap(World world) {
          mapSizeX = 2;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1,  Room.Room2 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
      }
  }

  //eXgvÕev[gB
  public static class Test1Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {return new Agent[] { new Agent(Alice, world) }; }
      public void addRules(World world, int agentID) {
          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, set(tg));
          //rule(w(), tg, set(a(5)));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  public static class Test2Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";
          Object R = "R";

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, call(a(R)));
          rule(w(a(R)), tg, set(tg));

          // P,Q  R
          // ̏Ƃ܂ a(Q) 藧Ă邾 set(a(R)) Ă܂B
          // Ă͑f܂ɊԈႤuvASYB
          // ͂AׂĂ̑O񂪐藧Ă邱Ƃ`FbNĂ set(a(R)) ȂƂ߁B
          rule(w(), w(a(R)), call(a(P)));
          rule(w(a(P)), w(a(R)), call(a(Q)));
          rule(w(a(Q)), w(a(R)), set(a(R)));

          //  P
          rule(w(), w(a(P)), set(a(P)));

          //  Q
          rule(w(), w(a(Q)), set(a(Q)));

      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  //_̗B
  public static class Test3Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";
          Object R = "R";

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, call(a(R)));
          rule(w(a(R)), tg, set(tg));

          // P,Q  R
          rule(w(), w(a(R)), call(a(P)));
          rule(w(a(P)), w(a(R)), call(a(Q)));
          rule(w(a(Q)), w(a(R)), recall(e(P)));
          rule(w(a(Q),e(P)), w(a(R)), set(a(R)));

          //  P
          rule(w(), w(a(P)), set(a(P)));

          //  Q
          rule(w(), w(a(Q)), set(a(Q)));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  //recall ߂̃eXgB
  public static class Test4Episode_endless extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";

          k(e(1,P));
          k(e(2,P));
          k(e(3,Q));
          k(e(4,Q));

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          // mx[X烉_ɑzNB
          //rule(w(), tg, recall(e(1,P)));
          rule(w(), tg, recall(e(0,P)));
          rule(w(), tg, recall(e(0,Q)));
          rule(w(), tg, recall(e(PLS,P)));
          rule(w(), tg, recall(e(PLS,Q)));
          rule(w(), tg, recall(e(__,P)));
          rule(w(), tg, recall(e(__,Q)));
          rule(w(), tg, recall(e(1,__)));
          //      rule(w(), tg, set(a(10,P)));
          //      rule(w(), tg, set(a(11,P)));

      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  //recall ߂̃eXgB
  public static class Test5Episode_endless extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";

          k(e(1, x, x, 2, y, y));
          k(e(x, x, x, y, y, y));
          k(e(x, y, z, x, y, z));

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          // mx[X烉_ɑzNB
          rule(w(), tg, recall(e(1, 2, 3, 4, 5, 6)));
          rule(w(), tg, recall(e(1, 1, 1, 2, 2, 2)));
          rule(w(), tg, recall(e(1, 2, 3, 1, 2, 3)));
          rule(w(), tg, recall(e(1, 0, 0, 0, 0, 0)));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  //ȂBӖL̃NG̃ChJ[h 0 ɕςA}b`ȂȂB 
  public static class Test6Episode2_endless extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          VariableN x1 = new VariableN("x1");
          VariableN x2 = new VariableN("x2");
          VariableN x3 = new VariableN("x3");
          VariableN x4 = new VariableN("x4");
          VariableN x5 = new VariableN("x5");
          VariableN x6 = new VariableN("x6");
          VariableN y1 = new VariableN("y1");
          VariableN y2 = new VariableN("y2");
          VariableN y3 = new VariableN("y3");
          VariableN y4 = new VariableN("y4");
          VariableN y5 = new VariableN("y5");
          VariableN y6 = new VariableN("y6");
          Object Socrates = "Socrates";
          Object Is = "Is";
          Object AMan = "AMan";
          Object Mortal = "Mortal";
          Object If = Conj.If;

          k(e(0, 0, Socrates, Is, AMan, 0));
          k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
          rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));

          // Modus Ponens
          RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
          RegisterN eif0y = e(If, c(0,0,0,0,0,0), c(y1,y2,y3,y4,y5,y6));
          RegisterN ax = a(x1,x2,x3,x4,x5,x6);
          RegisterN ay = a(y1,y2,y3,y4,y5,y6);
          rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
          rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
          rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
          rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

          RegisterN ex = e(x1,x2,x3,x4,x5,x6);
          rule(w(),   w(ax), recall(ex));
          rule(w(ex), w(ax), set(ax));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }
  //ӖLgBiNGChJ[h܂łBA 0 ɕςƓȂBj
  public static class Test6Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          VariableN x1 = new VariableN("x1");
          VariableN x2 = new VariableN("x2");
          VariableN x3 = new VariableN("x3");
          VariableN x4 = new VariableN("x4");
          VariableN x5 = new VariableN("x5");
          VariableN x6 = new VariableN("x6");
          VariableN y1 = new VariableN("y1");
          VariableN y2 = new VariableN("y2");
          VariableN y3 = new VariableN("y3");
          VariableN y4 = new VariableN("y4");
          VariableN y5 = new VariableN("y5");
          VariableN y6 = new VariableN("y6");
          Object Socrates = "Socrates";
          Object Is = "Is";
          Object AMan = "AMan";
          Object Mortal = "Mortal";
          Conj If = Conj.If;

          // XXX: when, where  0 ?
          k(e(0, 0, Socrates, Is, AMan, 0));
          k(e(If, c(0, 0, x, Is, AMan, 0), c(0, 0, x, Is, Mortal, 0)));

          //      StateN tg = w(a(Verb.TaskCompleted)); // task goal
          //      rule(w(), tg, call(a(0, 0, Socrates, Is, Mortal, 0)));
          //      rule(w(a(0, 0, Socrates, Is, Mortal, 0)), tg, set(a(Verb.TaskCompleted)));
          taskGoal(w(a(0, 0, Socrates, Is, Mortal, 0)));      

          // Modus Ponens
          RegisterN eifxy = e(If, c(x1,x2,x3,x4,x5,x6), c(y1,y2,y3,y4,y5,y6));
          RegisterN eif0y = e(If, c(__,__,__,__,__,__), c(y1,y2,y3,y4,y5,y6));
          RegisterN ax = a(x1,x2,x3,x4,x5,x6);
          RegisterN ay = a(y1,y2,y3,y4,y5,y6);
          rule(w(),       w(ay), recall(eif0y));  // y ؖ邽߂ x  y zN
          rule(w(eifxy),  w(ay), call(ax));       // x  y Ȃ y ؖ邽߂ x ؖ
          rule(w(ax),     w(ay), recall(eifxy));  // x Ȃ y ؖ邽߂ x  y zN
          rule(w(ax, eifxy), w(ay), set(ay));     // x, x  y Ȃ y 藧

          RegisterN ex = e(x1,x2,x3,x4,x5,x6);
          rule(w(),   w(ax), recall(ex));
          rule(w(ex), w(ax), set(ax));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  public static class Test7Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object Yesterday = "Yesterday";
          Object Today = "Today";
          Object Home = "Home";
          Object Chocolate = "Chocolate";
          Object Snack = "Snack";
          Object Exists = "Exists";
          Object Brother = "Brother";
          Object NotEat = "NotEat";

          k(e(Yesterday, Home, Chocolate, Exists, 0,  0));
          k(e(Yesterday, Home, Snack, Exists, 0,  0));
          k(e(Today, Home, Brother, NotEat, Chocolate, 0));

          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          StateN g = w(a(Today, Home, PLS, Exists, 0, 0));     // ƂɉiĤׂj邩m肽B
          rule(w(), tg, call(g));
          rule(g, tg, set(a(Verb.TaskCompleted)));

          rule(w(), g, recall(e(Yesterday, Home, PLS, Exists, 0,  0)));
          rule(w(e(Yesterday, Home, x, Exists, 0,  0)), g, set(a(Yesterday, Home, x, Exists, 0,  0)));
          // ͂Ȃ recall ł͂ȂA call ďׂ݂ؖB
          rule(w(a(Yesterday, Home, x, Exists, 0,  0)), g, recall(e(Today, Home, Brother, NotEat, x, 0)));
          rule(w(a(Yesterday, Home, x, Exists, 0,  0), e(Today, Home, Brother, NotEat, x, 0)), 
                  g, set(a(Today, Home, x, Exists, 0, 0)));
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }


  //Ԉ錾Im̉leXgBfB
  public static class Test0008Episode extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";
          Conj If = Conj.If;

          k(e(If, c(P,1), c(Q,1)));
          k(e(If, c(P,2), c(Q,2)));
          k(e(If, c(P,1), c(Q,2)));
          k(e(If, c(P,2), c(Q,1)));
          // ̂Q̂ǂꂩ_ɑzNB
          // XXX:  If zNȂ悤ɂȂƁB
          k(e(1, P));
          k(e(2, P));

          /*
           * P ̒l Q 𐄘_AԈlȂ fail BlȂ^XNIB
           */
          StateN tg = w(a(Verb.TaskCompleted)); // task goal
          rule(w(), tg, call(w(a(Q, PLS))));
          rule(w(e(P,1),a(Q,1)), tg, set(a(Verb.TaskCompleted)));
          rule(w(e(P,2),a(Q,2)), tg, set(a(Verb.TaskCompleted)));
          rule(w(e(P,1),a(Q,2)), tg, Fail);
          rule(w(e(P,2),a(Q,1)), tg, Fail);

          // _
          //??????
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }

  //------------------------------------------------------------------

  //}`[P̋ʐeNXB
  //Not used.
  public abstract static class TMultiRoom extends AbstractMainCode {
      public Agent[] makeAgents(World world) {return new Agent[] { 
              new Agent(Alice, world), 
              new Agent(Bob, world),
              new Agent(Carol, world), 
      };
      }
      /** eViIŋʂɎm`B */ 
      public void addCommonRules(int agentID) {
          if (agentID == 0) {
              Lab.assertTrue(world.agents[agentID].agentItem == Alice);
          } else if (agentID == 1) {
              Lab.assertTrue(world.agents[agentID].agentItem == Bob);
          } else if (agentID == 2) {
              Lab.assertTrue(world.agents[agentID].agentItem == Carol);
          } else {
              Lab.assertTrue(false);
          }
      }
      /** eViIŗL̒m`B */ 
      public void addScenarioRules(int agentID) {
          //    if (agentID == 0) {
          //    } else if (agentID == 1) {
          //    } else if (agentID == 2) {
          //    } else {
          //        Lab.assertTrue(false);
          //    }
      }
      public void addRules(World world, int agentID) {
          addCommonRules(agentID);
          addScenarioRules(agentID);
      }
      public void setMap(World world) {
          mapSizeX = 2;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1,  Room.Room2 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world) {
      }
  }

  //΂kɂԂďoĂHׂ^XNB
  public static class TestEnv1 extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
      public void addRules(World world, int agentID) {
          StateN g = w(a(Now, __, Alice, Ate, Nut, 0));
          taskGoal(g);
          
          rule(w(), g, findItemA(Stone));
          rule(w(a(Now,x,Alice,IsAwareOf,Stone,0)), g, findItemE(Shell));
          rule(w(a(Now,x,Alice,IsAwareOf,Stone,0),
                  e(Now,x,Alice,IsAwareOf,Shell,0)), 
                  g,
                  set(a(Now,x,Alice,WantToApplyO1ToO2,Stone,Shell)));
          rule(a(Now,x,Alice,WantToApplyO1ToO2,Stone,Shell), g, 
                  ApplyO1toO2);
          rule(a(Now,x,Alice,AppliedO1ToO2,Stone,Shell), g, findItemA(Nut));
          rule(a(Now,x,Alice,IsAwareOf,Nut,0), g, EatO1);
          
      }
      public void initEpisode(World world){
          world.agents[0].energy = 1;
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          world.addItem(world.rooms[0], Grass);
          world.addItem(world.rooms[0], Stone);
          world.addItem(world.rooms[0], Shell);
      }
  }

  // ʂ̕ɕ̂ĂeXgvOB
  public static class TestEnv2 extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
      public void addRules(World world, int agentID) {
          StateN g = w(a(Now, __, Alice, Ate, Nut, 0));
          taskGoal(g);

          rule(w(), g, RecogRoom);
          rule(w(a(Now,Room1,Alice,Exists,0,0)), g, primitive(GoToRoom, Room2));
          rule(w(a(Now,Room2,Alice,Exists,0,0)), g, findItemA(Stone));
          rule(w(a(Now,Room2,Alice,IsAwareOf,Stone,0)), g, 
                  set(a(Now,Room2,Alice,WantToTakeO1ToO2,Stone,Room3)));
          rule(w(a(Now,Room2,Alice,WantToTakeO1ToO2,Stone,Room3)), g, TakeO1ToO2);

          rule(w(a(Now,Room3,Alice,TookO1FromO2,Stone,Room2)), g, findItemA(Stone));
          rule(w(a(Now,x,Alice,IsAwareOf,Stone,0)), g, findItemE(Shell));
          rule(w(a(Now,x,Alice,IsAwareOf,Stone,0),
                  e(Now,x,Alice,IsAwareOf,Shell,0)), 
                  g,
                  set(a(Now,x,Alice,WantToApplyO1ToO2,Stone,Shell)));
          rule(a(Now,x,Alice,WantToApplyO1ToO2,Stone,Shell), g, 
                  ApplyO1toO2);
          rule(a(Now,x,Alice,AppliedO1ToO2,Stone,Shell), g, findItemA(Nut));
          rule(a(Now,x,Alice,IsAwareOf,Nut,0), g, EatO1);            
      }
      public void setMap(World world) {
          mapSizeX = 3;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1,  Room.Room2 ,  Room.Room3 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].energy = 1;
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          world.addItem(world.rooms[0], Grass);
          world.addItem(world.rooms[1], Stone);
          world.addItem(world.rooms[1], Grass);
          world.addItem(world.rooms[2], Shell);
          world.addItem(world.rooms[2], Grass);
      }
  }

  //̃̕eXgvOB܂kTBɐ΂TB΂ĂĊkB
  //BUG:  Now ͕̈sSB
  public static class TestEnv3 extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
      public void addRules(World world, int agentID) {
          StateN g1 = w(a(Now, __, Alice, Ate, Nut, 0));
          StateN g2 = w(a(Now,__,Alice,IsAwareOf,Nut,0));
          StateN g3 = w(a(And, c(Now,__,Alice,IsAwareOf,Stone,0), c(Now,__,Alice,IsAwareOf,Shell,0)));
          StateN gx = w(a(Now,__,Alice,IsAwareOf,x,0));
          taskGoal(g1);

          // Nut HׂTu[`
          rule(w(), g1, call(g2));
          rule(g2, g1, EatO1);            

          // Nut ɓTu[`
          rule(w(), g2, call(g3));
          rule(a(And, c(Now,y,Alice,IsAwareOf,Stone,0), c(Now,y,Alice,IsAwareOf,Shell,0)),
                  g2, set(a(Now,y,Alice,WantToApplyO1ToO2,Stone,Shell)));
          rule(a(Now,x,Alice,WantToApplyO1ToO2,Stone,Shell), g2, ApplyO1toO2);
          rule(a(Now,x,Alice,AppliedO1ToO2,Stone,Shell), g2, findItemA(Nut));
          
          // Stone  Shell 𓯎ɔFTu[`
          rule(w(), g3, call(a(Now,__,Alice,IsAwareOf,Shell,0)));
          rule(w(a(Now,__,Alice,IsAwareOf,Shell,0)), g3,
              call(a(Now,__,Alice,IsAwareOf,Stone,0)));
          rule(w(a(Now,__,Alice,IsAwareOf,Stone,0)), g3,
              recall(e(Now,PLS,Alice,IsAwareOf,Shell,0)));
          rule(w(a(Now,__,Alice,IsAwareOf,Stone,0), e(Now,y,Alice,IsAwareOf,Shell,0)),
                  g3,
                  set(a(Now,__,Alice,WantToTakeO1ToO2,Stone,y)));
          rule(w(a(Now,__,Alice,WantToTakeO1ToO2,Stone,y)), g3, TakeO1ToO2);
          rule(w(a(Now,y,Alice,TookO1FromO2,Stone,__)), g3, 
                  set(a(And, c(Now,y,Alice,IsAwareOf,Stone,0), c(Now,y,Alice,IsAwareOf,Shell,0))));

          // x TTu[`B
          rule(w(), gx, findItemA(x));
          rule(w(a(Now,__,Alice,IsAwareOfNo,x,0)), gx, primitive(GoToRoom, Room1));
          rule(w(a(Now,__,Alice,IsAwareOfNo,x,0)), gx, primitive(GoToRoom, Room2));
      }
      public void setMap(World world) {
          mapSizeX = 2;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1,  Room.Room2 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          world.addItem(world.rooms[Lab.irand(2)], Stone); // ǂ炩̕Ƀ_ɔzu
          world.addItem(world.rooms[Lab.irand(2)], Shell); // ǂ炩̕Ƀ_ɔzu
      }
  }

  // Dummy 
  public static class TestEnv4 extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] {
              new Agent(Alice, world), new Agent(Bob, world)};
      }
      public void addRules(World world, int agentID) {
          if (true) throw new Lab.StopPressed();
      }
      public void setMap(World world) {
          mapSizeX = 3;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1,  Room.Room2 ,  Room.Room3 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          world.addItem(world.rooms[0], Grass);
          world.addItem(world.rooms[1], Stone);
          world.addItem(world.rooms[1], Grass);
          world.addItem(world.rooms[2], Shell);
          world.addItem(world.rooms[2], Grass);
      }
  }


  //------------------------------------------------------------------
  //ΘbeXgP̋ʐeNXB
  public abstract static class TScissors extends AbstractMainCode {
      public Agent[] makeAgents(World world) {return new Agent[] { 
              new Agent(Alice, world), 
              new Agent(Bob, world),
              new Agent(Carol, world), 
      };
      }
      /** eViIŋʂɎm`B */ 
      public void addCommonRules(int agentID) {
          if (agentID == 0) {
              Lab.assertTrue(world.agents[agentID].agentItem == Alice);
          } else if (agentID == 1) {
              Lab.assertTrue(world.agents[agentID].agentItem == Bob);
          } else if (agentID == 2) {
              Lab.assertTrue(world.agents[agentID].agentItem == Carol);
          } else {
              Lab.assertTrue(false);
          }
      }
      /** eViIŗL̒m`B */ 
      public void addScenarioRules(int agentID) {
          //    if (agentID == 0) {
          //    } else if (agentID == 1) {
          //    } else if (agentID == 2) {
          //    } else {
          //        Lab.assertTrue(false);
          //    }
      }
      public void addRules(World world, int agentID) {
          addCommonRules(agentID);
          addScenarioRules(agentID);
      }
      //public void setMap(World world) {
      // world.map = new Item[0][0];
      //}
      public void initEpisode(World world) {
          //world.agents[0].energy = 1;
          world.agents[0].currentRoom = world.rooms[0];
          world.agents[1].currentRoom = world.rooms[0];
          world.agents[2].currentRoom = world.rooms[0];
          world.addItem(world.rooms[0], Alice);
          world.addItem(world.rooms[0], Bob);
          world.addItem(world.rooms[0], Carol);
      }
  }


  //ΘbeXgP̂P
  //Bob  Alice ɔbă^XNIB
  //Alice inT~̏ꏊm肽Bj
  //Bob unT~ Room1 ɂBv
  public static class TestS1 extends TScissors {
      public void addScenarioRules(int agentID) {
          if (agentID == 0) {
              Lab.assertTrue(world.agents[agentID].agentItem == Alice);
              taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));
              StateN g = w(a(Now, PLS, Scissors, Exists, 0, 0));
              rule(w(), g, Listen);
              rule(w(a(ThatO2, c(Now, Here, Bob, SaidTo, Alice, 0),
                      c(Now, x, Scissors, Exists, 0, 0))),
                      g,
                      set(a(Now, x, Scissors, Exists, 0, 0)));

          } else if (agentID == 1) {
              Lab.assertTrue(world.agents[agentID].agentItem == Bob);
              rule(w(), w(), set(a(ThatO2,
                      c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                      c(Now, Room1, Scissors, Exists, 0, 0))));
              rule(w(a(ThatO2, 
                      c(Now, Here, Bob, WantsToSayTo, __, __), 
                      c(__, __, __, __, __, __))), w(), SayIt);

          } else if (agentID == 2) {
              Lab.assertTrue(world.agents[agentID].agentItem == Carol);
              rule(w(), w(), Fail);

          } else {
              Lab.assertTrue(false);
          }
      }
      //public void initEpisode(World world) {
      //}
  }
  //ΘbeXgP̂Q
  //Alice
  //inT~̏ꏊm肽Bj
  //inT~̏ꏊmĂ邩Ȃl͒Nm肽Bj
  //iBob mĂBj
  //uBob, nT~͂ǂɂHvƕB
  //ԓ҂
  //BobunT~ x ɂBvƌȂ΃nT~ x ɂB
  //Bob:
  //AliceɁunT~͂ǂɂHvƕꂽuAlice, nT~ Room1 ɂBvƕԎB
  public static class TestS2 extends TScissors {
      public void addScenarioRules(int agentID) {
          if (agentID == 0) {
              Lab.assertTrue(world.agents[agentID].agentItem == Alice);
              taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));

              // nT~ǂɂ邩mĂԁB
              StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
              // unT~ǂɂ邩NmĂ邩vmĂԁB
              StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0)));

              // Rule 2-7
              rule(w(), g1, call(g2));
              rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))),
                      g1,
                      set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                              c(Now, Wh, Scissors, Exists, 0, 0))));
              rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
              rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
              rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
                      c(Now, x, Scissors, Exists, 0, 0))),
                      g1,
                      set(a(Now, x, Scissors, Exists, 0, 0)));

              // Bob mĂƌߑłB
              rule(w(), g2, set(a(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))));

          } else if (agentID == 1) {
              Lab.assertTrue(world.agents[agentID].agentItem == Bob);
              rule(w(), w(), Listen);
              // ꂽƂɑɕԓB
              // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
              rule(w(a(ThatO2, 
                      c(Now, Here, Alice, SaidTo, Bob, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))),
                      w(), 
                      set(a(ThatO2,
                              c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                              c(Now, Room1, Scissors, Exists, 0, 0))));
              rule(w(a(ThatO2,
                      c(Now, Here, Bob, WantsToSayTo, __, __), 
                      c(__, __, __, __, __, __))), w(), SayIt);

          } else if (agentID == 2) {
              Lab.assertTrue(world.agents[agentID].agentItem == Carol);
              rule(w(), w(), Fail);

          } else {
              Lab.assertTrue(false);
          }
      }
      //public void initEpisode(World world) {
      //}
  }

  //ΘbeXgP̂R
  //Q̔C
  //RgCĔ\XChɂ̂B
  public static class TestS3 extends TScissors {
      public void addScenarioRules(int agentID) {
          if (agentID == 0) {
              Lab.assertTrue(world.agents[agentID].agentItem == Alice);
              taskGoal(w(a(Now, PLS, Scissors, Exists, 0, 0)));

              k(e(ThatO1, c(Now, Here, Bob, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0)));

              // nT~ǂɂ邩mĂԁB
              StateN g1 = w(a(Now, PLS, Scissors, Exists, 0, 0));
              // unT~ǂɂ邩NmĂ邩vmĂԁB
              StateN g2 = w(a(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0)));

              // Rule 2-7
              rule(w(), g1, call(g2));
              rule(w(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))),
                      g1,
                      set(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                              c(Now, Wh, Scissors, Exists, 0, 0))));
              rule(w(a(ThatO2, c(Now, Here, Alice, WantsToSayTo, z, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))), g1, SayIt);
              rule(w(a(ThatO2, c(Now, Here, Alice, SaidTo, z, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))), g1, Listen);
              rule(w(a(ThatO2, c(Now, Here, __, SaidTo, Alice, 0),
                      c(Now, x, Scissors, Exists, 0, 0))),
                      g1,
                      set(a(Now, x, Scissors, Exists, 0, 0)));

              // NmĂ邩voĂ݂B
              rule(w(), g2, recall(e(ThatO1, c(Now, Here, PLS, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))));
              rule(w(e(ThatO1, c(Now, Here, z, Knows, 0, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))), 
                      g2, 
                      set(a(ThatO1, c(Now, Here, z, Knows, 0, 0),
                              c(Now, Wh, Scissors, Exists, 0, 0))));

          } else if (agentID == 1) {
              Lab.assertTrue(world.agents[agentID].agentItem == Bob);
              rule(w(), w(), Listen);
              // ꂽƂɑɕԓB
              // unT~̏ꏊ͂ǂvƕꂽuRoom1 ɂvƂB
              rule(w(a(ThatO2, 
                      c(Now, Here, Alice, SaidTo, Bob, 0),
                      c(Now, Wh, Scissors, Exists, 0, 0))),
                      w(), 
                      set(a(ThatO2,
                              c(Now, Here, Bob, WantsToSayTo, Alice, 0),
                              c(Now, Room1, Scissors, Exists, 0, 0))));
              rule(w(a(ThatO2,
                      c(Now, Here, Bob, WantsToSayTo, __, __), 
                      c(__, __, __, __, __, __))), w(), SayIt);

          } else if (agentID == 2) {
              Lab.assertTrue(world.agents[agentID].agentItem == Carol);
              rule(w(), w(), Fail);

          } else {
              Lab.assertTrue(false);
          }
      }  
      //public void initEpisode(World world) {
      //}
  }

  //------------------------------------------------------------------
  //sveXg̋ʐeNXB
  public abstract static class TThought1 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {return new Agent[] { 
              new Agent(Alice, world), 
              //new Agent(Bob, world),
      };
      }
      public void setMap(World world) {
          mapSizeX = 5;
          mapSizeY = 1;
          world.rooms = new Room[]{ 
                  Room1,Room2,Room3,Room4,Room5, 
          };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }

      public void initEpisode(World world) {
          //world.agents[0].energy = 1;
          world.agents[0].currentRoom = world.rooms[0];
          //world.agents[1].currentRoom = world.areas[0];
          world.addItem(world.rooms[0], Alice);
          //world.addItem(world.rooms[0], Bob);
      }
  }
  //sveXgP̂P
  public static class TestT1 extends TThought1 {
      public void addRules(World world, int agentID) {
          {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              ClauseN cPLS = c(__,__,PLS,PLS,__,__);

              rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
              rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));

              StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
              rule(w(), gp, recall(e(Achieves,cPLS,cPLS,g)));
              rule(w(e(Achieves,sg,x,g)), gp, set(a(Achieves,sg,x,g)));

              rule(w(a(Achieves,sg,x,g)), gp, recall(e(Achieves,cPLS,cPLS,sg)));
              rule(w(a(Achieves,sg,cPLS,g), e(Achieves,ssg,y,sg)), gp,
                      set(a(Achieves,ssg,sg,g)));
          }

          StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
          taskGoal(tg);
          //rule(w(), tg, primitive(GoToRoom, Room2)); // test

          // ǂɈړɂ́A܂̏ꏊFB
          rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(RecogRoom));

          // ɂPړTu[`^ĂB
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

          // ꂼ̃GA瓌ɂPړłƂ錾ImB
          k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                  c(Now, Room2, Alice, Exists, 0, 0), 
                  c(Now, Room2, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                  c(Now, Room3, Alice, Exists, 0, 0), 
                  c(Now, Room3, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                  c(Now, Room4, Alice, Exists, 0, 0), 
                  c(Now, Room4, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                  c(Now, Room5, Alice, Exists, 0, 0), 
                  c(Now, Room5, Alice, Exists, 0, 0)));
      }
  }
  //sveXgP2
  public static class TestT1_2 extends TThought1 {
      public void addRules(World world, int agentID) {
          {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              ClauseN cPLS = c(__,__,PLS,PLS,__,__);

              rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
              rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));

              StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
              rule(w(), gp, recall(e(Achieves,cPLS,cPLS,g)));
              rule(w(e(Achieves,sg,x,g)), gp, set(a(Achieves,sg,x,g)));

              rule(w(a(Achieves,sg,x,g)), gp, recall(e(Achieves,cPLS,cPLS,sg)));
              rule(w(a(Achieves,sg,cPLS,g), e(Achieves,ssg,y,sg)), gp,
                      set(a(Achieves,ssg,sg,g)));
          }

          StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
          taskGoal(tg);
          //rule(w(), tg, primitive(GoToRoom, Room2)); // test

          // ǂɈړɂ́A܂̏ꏊFB
          rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(RecogRoom));

          // ɂPړTu[`^ĂB
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

          // ꂼ̃GA瓌ɂPړłƂ錾ImB
          k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                  c(Now, Room2, Alice, Exists, 0, 0), 
                  c(Now, Room2, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                  c(Now, Room3, Alice, Exists, 0, 0), 
                  c(Now, Room3, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                  c(Now, Room4, Alice, Exists, 0, 0), 
                  c(Now, Room4, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                  c(Now, Room5, Alice, Exists, 0, 0), 
                  c(Now, Room5, Alice, Exists, 0, 0)));
      }
  }



  //callm ̃eXgBIȂvOB
  public static class TestT0_callm_endless extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      public void addRules(World world, int agentID) {
          Object P = "P";
          Object Q = "Q";
          Object R = "R";

          taskGoal(w(a(R)));

          setRulesName("R");
          rule(w(), w(a(R)), set(a(P)));
          rule(w(a(P)), w(a(R)), set(a(Q)));
          rule(w(a(Q)), w(a(R)), callm(a(P)));

          rule(w(), w(a(P)), Fail);
      }
      public void setMap(World world) {
          setEmptyMap(world);
      }
      public void initEpisode(World world) {
      }
  }


  //A̍sveXg callm go[WB
  public static class TestT1_3 extends TThought1 {
      public void addRules(World world, int agentID) {
          {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              ClauseN cPLS = c(__,__,PLS,PLS,__,__);

              rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
              //    rule(w(a(Achieves,s,a,g)), w(a(g)), call(a(a)));
              rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
              rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

              StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
              rule(w(), gp, callm(a(Achieves,cPLS,cPLS,g)));
              rule(w(a(Achieves,sg,x,g)), gp, callm(a(Achieves,cPLS,cPLS,sg)));
              rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,sg,cPLS,g)));
              rule(w(a(Achieves,ssg,y,sg), e(Achieves,sg,x,g)), gp,
                      set(a(Achieves,ssg,sg,g)));
          }

          StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
          taskGoal(tg);
          //rule(w(), tg, primitive(GoToRoom, Room2)); // test

          // ǂɈړɂ́A܂̏ꏊFB
          rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(RecogRoom));

          // ɂPړTu[`^ĂB
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

          // ꂼ̃GA瓌ɂPړłƂ錾ImB
          k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                  c(Now, Room2, Alice, Exists, 0, 0), 
                  c(Now, Room2, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                  c(Now, Room3, Alice, Exists, 0, 0), 
                  c(Now, Room3, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                  c(Now, Room4, Alice, Exists, 0, 0), 
                  c(Now, Room4, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                  c(Now, Room5, Alice, Exists, 0, 0), 
                  c(Now, Room5, Alice, Exists, 0, 0)));
      }
  }



  //OAōsvB
  public static class TestT1_4 extends TThought1 {
      public void addRules(World world, int agentID) {
          {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              ClauseN cPLS = c(__,__,PLS,PLS,__,__);

              rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
              rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
              rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

              StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning
              rule(w(), gp, callm(a(Achieves,s,cPLS,cPLS)));
              rule(w(a(Achieves,s,x,ssg)), gp, callm(a(Achieves,ssg,cPLS,cPLS)));
              rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,s,cPLS,ssg)));
              rule(w(a(Achieves,ssg,y,sg), e(Achieves,s,x,ssg)), gp,
                      set(a(Achieves,s,ssg,sg)));

          }

          StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
          taskGoal(tg);

          // ǂɈړɂ́A܂̏ꏊFB
          rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(RecogRoom));

          // ɂPړTu[`^ĂB
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

          // ꂼ̃GA瓌ɂPړłƂ錾ImB
          k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                  c(Now, Room2, Alice, Exists, 0, 0), 
                  c(Now, Room2, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                  c(Now, Room3, Alice, Exists, 0, 0), 
                  c(Now, Room3, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                  c(Now, Room4, Alice, Exists, 0, 0), 
                  c(Now, Room4, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                  c(Now, Room5, Alice, Exists, 0, 0), 
                  c(Now, Room5, Alice, Exists, 0, 0)));
      }
  }


  //AƑOAōsvBقڏIȂB
  public static class TestT1_3_4_endless extends TThought1 {
      public void addRules(World world, int agentID) {
          {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              ClauseN cPLS = c(__,__,PLS,PLS,__,__);

              setRulesName("P");
              rule(w(a(s)), w(a(g)), call(a(Achieves,s,cPLS,g)));
              rule(w(a(Achieves,s,a,g)), w(a(g)), recall(e(s)));
              rule(w(a(Achieves,s,a,g),e(s)), w(a(g)), call(a(a)));

              StateN gp = w(a(Achieves,s,cPLS,g)); // Goal of planning

              // A
              setRulesName("B");
              rule(w(), gp, callm(a(Achieves,cPLS,cPLS,g)));
              rule(w(a(Achieves,sg,x,g)), gp, callm(a(Achieves,cPLS,cPLS,sg)));
              rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,sg,cPLS,g)));
              rule(w(a(Achieves,ssg,y,sg), e(Achieves,sg,x,g)), gp,
                      set(a(Achieves,ssg,sg,g)));
              // OA
              setRulesName("F");
              rule(w(), gp, callm(a(Achieves,s,cPLS,cPLS)));
              rule(w(a(Achieves,s,x,ssg)), gp, callm(a(Achieves,ssg,cPLS,cPLS)));
              rule(a(Achieves,ssg,y,sg), gp, recall(e(Achieves,s,cPLS,ssg)));
              rule(w(a(Achieves,ssg,y,sg), e(Achieves,s,x,ssg)), gp,
                      set(a(Achieves,s,ssg,sg)));
          }

          setRulesName("K");
          StateN tg = w(a(Now, Room5, Alice, Exists, 0, 0));
          taskGoal(tg);
          //rule(w(), tg, primitive(GoToRoom, Room2)); // test

          //ǂɈړɂ́A܂̏ꏊFB
          rule(w(), w(a(Now, __, Alice, Exists, 0, 0)), primitive(RecogRoom));

          //ɂPړTu[`^ĂB
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoDir, East));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoDir, East));

          //ꂼ̃GA瓌ɂPړłƂ錾ImB
          k(e(Achieves, c(Now, Room1, Alice, Exists, 0, 0),
                  c(Now, Room2, Alice, Exists, 0, 0), 
                  c(Now, Room2, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room2, Alice, Exists, 0, 0),
                  c(Now, Room3, Alice, Exists, 0, 0), 
                  c(Now, Room3, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room3, Alice, Exists, 0, 0),
                  c(Now, Room4, Alice, Exists, 0, 0), 
                  c(Now, Room4, Alice, Exists, 0, 0)));
          k(e(Achieves, c(Now, Room4, Alice, Exists, 0, 0),
                  c(Now, Room5, Alice, Exists, 0, 0), 
                  c(Now, Room5, Alice, Exists, 0, 0)));
      }
  }

  // Test task for multi-exit RGoal.
  public static class TestXMulti01 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));    // 1
          // route 1
          rule(w(a(1,Q)), g0, set(a(1,R))); // 2
          rule(w(a(1,R)), g0, set(a(1,G))); // 3
          // route 2
          rule(w(a(2,Q)), g0, set(a(2,G))); // 4
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, findItemA(Stone));  // 1
          rule(w(a(Now,Room1,Alice,IsAwareOf,Stone,0)), g1, set(a(1,Q)));   // 2
          rule(w(a(Now,Room1,Alice,IsAwareOfNo,Stone,0)), g1, set(a(2,Q))); // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }

  // 蕡GȗBĂяõlXgB
  public static class TestXMulti02 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object O = "O";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      Object V = "V";
      Object W = "W";
      Object X = "X";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,T));
          StateN g2 = w(a(PLS,S));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,O)));
//          rule(w(a(1,O)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));

          setRulesName("g0");
          rule(w(a(1,O)), g0, set(a(1,P)));  // 1
          rule(w(a(1,O)), g0, set(a(2,P)));  // 2 
          // {} -> P(1) -> call(T(+))
          rule(w(a(1,P)), g0, call(g1));  // 3
          // {} -> P(1) -> T(1) -> X(1)
          rule(w(a(1,T)), g0, set(a(1,X)));  // 4
          // {} -> P(1) -> T(2) -> W(1)
          rule(w(a(2,T)), g0, set(a(1,W)));  // 5
          // {} -> P(1) -> T(3) -> V(1)
          rule(w(a(3,T)), g0, set(a(1,V)));  // 6
          // {} -> P(2) -> Q(1) -> R(1) -> ... -> X(1) -> G(1)  
          rule(w(a(2,P)), g0, set(a(2,Q)));  // 7
          rule(w(a(2,Q)), g0, set(a(2,R)));  // 8
          rule(w(a(2,R)), g0, set(a(3,S)));  // 9
          rule(w(a(3,S)), g0, set(a(4,T)));  // 10
          rule(w(a(4,T)), g0, set(a(1,U)));  // 11
          rule(w(a(1,U)), g0, set(a(1,V)));  // 12
          rule(w(a(1,V)), g0, set(a(1,W)));  // 13
          rule(w(a(1,W)), g0, set(a(1,X)));  // 14
          rule(w(a(1,X)), g0, set(a(1,G)));  // 15
          
          setRulesName("g1");
          // P(1) -> S(x) -> T(x)
          rule(w(a(1,P)), g1, call(g2));  // 1
          rule(w(a(x,S)), g1, set(a(x,T)));  // 2
          // P(1) -> Q(1) -> R(1) -> T(3)
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 3
          rule(w(a(1,Q)), g1, set(a(1,R)));  // 4
          rule(w(a(1,R)), g1, set(a(3,T)));  // 5
          
          setRulesName("g2");
          rule(w(a(1,P)), g2, findItemA(Stone));   // 1
          rule(w(a(Now,Room1,Alice,IsAwareOf,Stone,0)), g2, set(a(1,S)));   // 2
          rule(w(a(Now,Room1,Alice,IsAwareOfNo,Stone,0)), g2, set(a(2,S)));  // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,O)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }
  
  // ċA̗B
  public static class TestXMulti03 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));  // 1
          rule(g1, g0, set(a(1,G)));      // 2
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, call(g1));    // 1
          rule(w(a(1,P)), g1, set(a(1,Q))); // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }
  
  // fail ̃eXgB
  public static class TestXMulti04fail extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));    // 1
          // route 1
          rule(w(a(1,Q)), g0, set(a(1,R))); // 2
          rule(w(a(1,R)), g0, set(a(1,G))); // 3
          // route 2
          rule(w(a(2,Q)), g0, set(a(2,G))); // 4
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, Fail);        // 1
          rule(w(a(1,P)), g1, set(a(2,Q))); // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
          agent.failedState = agent.oldS;
      }
  }    
  // fail ̃eXgB
  public static class TestXMulti05fail extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object O = "O";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      Object V = "V";
      Object W = "W";
      Object X = "X";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,T));
          StateN g2 = w(a(PLS,S));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,O)));
//          rule(w(a(1,O)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));

          setRulesName("g0");
          rule(w(a(1,O)), g0, set(a(1,P)));  // 1
          rule(w(a(1,O)), g0, set(a(2,P)));  // 2 
          // {} -> P(1) -> call(T(+))
          rule(w(a(1,P)), g0, call(g1));  // 3
          // {} -> P(1) -> T(1) -> X(1)
          rule(w(a(1,T)), g0, set(a(1,X)));  // 4
          // {} -> P(1) -> T(2) -> W(1)
          rule(w(a(2,T)), g0, set(a(1,W)));  // 5
          // {} -> P(1) -> T(3) -> V(1)
          rule(w(a(3,T)), g0, set(a(1,V)));  // 6
          // {} -> P(2) -> Q(1) -> R(1) -> ... -> X(1) -> G(1)  
          rule(w(a(2,P)), g0, set(a(2,Q)));  // 7
          rule(w(a(2,Q)), g0, set(a(2,R)));  // 8
          rule(w(a(2,R)), g0, set(a(3,S)));  // 9
          rule(w(a(3,S)), g0, set(a(4,T)));  // 10
          rule(w(a(4,T)), g0, set(a(1,U)));  // 11
          rule(w(a(1,U)), g0, set(a(1,V)));  // 12
          rule(w(a(1,V)), g0, set(a(1,W)));  // 13
          rule(w(a(1,W)), g0, set(a(1,X)));  // 14
          rule(w(a(1,X)), g0, set(a(1,G)));  // 15
          
          setRulesName("g1");
          // P(1) -> S(x) -> T(x)
          rule(w(a(1,P)), g1, call(g2));  // 1
          rule(w(a(x,S)), g1, set(a(x,T)));  // 2
          // P(1) -> Q(1) -> R(1) -> T(3)
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 3
          rule(w(a(1,Q)), g1, set(a(1,R)));  // 4
          rule(w(a(1,R)), g1, set(a(3,T)));  // 5
          
          setRulesName("g2");
          rule(w(a(1,P)), g2, Fail);          // 1 
          rule(w(a(1,P)), g2, set(a(2,S)));   // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,O)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
          agent.failedState = agent.oldS;
      }
  }
  
  // Test exit statement.
  public static class TestXMulti06 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));    // 1
          // route 1
          rule(w(a(1,Q)), g0, set(a(1,R))); // 2
          rule(w(a(1,R)), g0, set(a(1,G))); // 3
          // route 2
          rule(w(a(2,Q)), g0, set(a(1,G))); // 4
          // route 3
          rule(w(a(2,P)), g0, set(a(1,G))); // 5
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 1
          rule(w(a(1,P)), g1, set(a(2,Q)));  // 2
          rule(w(a(1,P)), g1, exit(a(2,P)));  // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }

  // exit ċAĂяoB
  public static class TestXMulti07 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));  // 1
          rule(g1, g0, set(a(1,G)));      // 2
          rule(w(a(2,P)), g0, set(a(1,G))); // 3
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, call(g1));     // 1
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 2
          rule(w(a(1,P)), g1, exit(a(2,P))); // 3
          rule(w(a(2,P)), g1, set(a(1,Q))); // 4
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }    
  
  // exit Ă蒼eXgB
  public static class TestXMulti08 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));    // 1
          // route 1
          rule(w(a(1,Q)), g0, set(a(1,R))); // 2
          rule(w(a(1,R)), g0, set(a(1,G))); // 3
          // route 2
          rule(w(a(2,Q)), g0, set(a(2,G))); // 4
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, exit(a(1,P))); // 1
          rule(w(a(1,P)), g1, set(a(2,Q)));  // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }        

  // exit čēx exit Ă蒼B
  public static class TestXMulti09 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object O = "O";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      Object V = "V";
      Object W = "W";
      Object X = "X";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,T));
          StateN g2 = w(a(PLS,S));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,O)));
//          rule(w(a(1,O)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));

          setRulesName("g0");
          rule(w(a(1,O)), g0, set(a(1,P)));  // 1
          rule(w(a(1,O)), g0, set(a(2,P)));  // 2 
          // P(1) -> call(T(+))
          rule(w(a(1,P)), g0, call(g1));  // 3
          // P(1) -> T(1) -> X(1)
          rule(w(a(1,T)), g0, set(a(1,X)));  // 4
          // P(1) -> T(2) -> W(1)
          rule(w(a(2,T)), g0, set(a(1,W)));  // 5
          // P(1) -> T(3) -> V(1)
          rule(w(a(3,T)), g0, set(a(1,V)));  // 6
          // P(2) -> Q(1) -> R(1) -> ... -> X(1) -> G(1)  
          rule(w(a(2,P)), g0, set(a(2,Q)));  // 7
          rule(w(a(2,Q)), g0, set(a(2,R)));  // 8
          rule(w(a(2,R)), g0, set(a(3,S)));  // 9
          rule(w(a(3,S)), g0, set(a(4,T)));  // 10
          rule(w(a(4,T)), g0, set(a(1,U)));  // 11
          rule(w(a(1,U)), g0, set(a(1,V)));  // 12
          rule(w(a(1,V)), g0, set(a(1,W)));  // 13
          rule(w(a(1,W)), g0, set(a(1,X)));  // 14
          rule(w(a(1,X)), g0, set(a(1,G)));  // 15
          
          setRulesName("g1");
          // P(1) -> S(x) -> T(x)
          rule(w(a(1,P)), g1, call(g2));     // 1
          rule(w(a(x,S)), g1, set(a(x,T)));  // 2
          // P(1) -> Q(1) -> R(1) -> T(3)
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 3
          rule(w(a(1,Q)), g1, set(a(1,R)));  // 4
          rule(w(a(1,R)), g1, set(a(3,T)));  // 5
          // P(1) -> exit(O(1)) -> exit(O(1))
          rule(w(a(1,O)), g1, exit(a(1,O)));  // 6
          
          setRulesName("g2");
          rule(w(a(1,P)), g2, exit(a(1,O)));  // 1 
          rule(w(a(1,P)), g2, set(a(1,S)));   // 2 
          rule(w(a(1,P)), g2, set(a(2,S)));   // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,O)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }   
  }
  
  // ̌ĂяoAϐgp̃eXgB
  public static class TestXMulti10 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object E = "E";
      Object G = "G";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          // 
          rule(w(a(1,P)), g0, call(g1));      // 1
          rule(w(a(1,Q)), g0, set(a(1,G)));   // 2
          rule(w(a(1,E)), g0, set(a(1,G)));   // 3
          // 
          rule(w(a(1,P)), g0, set(a(2,P)));   // 4
          rule(w(a(2,P)), g0, call(g1));      // 5
          //   Q(2) -> R(2) -> G(1) 
          rule(w(a(2,Q)), g0, set(a(2,R)));   // 6
          rule(w(a(2,R)), g0, set(a(1,G)));   // 7
          //   E(2) -> Q(2) -> R(1) -> G(1) 
          rule(w(a(2,E)), g0, set(a(2,Q)));   // 8
          rule(w(a(2,Q)), g0, set(a(1,R)));   // 9
          rule(w(a(1,R)), g0, set(a(1,G)));   // 10
          
          setRulesName("g1");
          rule(w(a(x,P)), g1, set(a(x,Q)));   // 1
          rule(w(a(x,P)), g1, exit(a(x,E)));  // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }        
      
  // Unstable task.
  public static class TestXMulti11 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,Q));

//          setRulesName("tg");
//          StateN tg = w(a(Verb.TaskCompleted)); // Built-in task goal.
//          rule(w(), tg, set(a(1,P)));
//          rule(w(a(1,P)), tg, call(g0));
//          rule(g0, tg, set(a(Verb.TaskCompleted)));
          
          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));    // 1
          // route 1
          rule(w(a(1,Q)), g0, set(a(1,R))); // 2
          rule(w(a(1,R)), g0, set(a(1,S))); // 3
          // route 2
          rule(w(a(2,Q)), g0, set(a(1,S))); // 4
          // route 3
          rule(w(a(2,P)), g0, set(a(1,S))); // 5
          // ǉB 1/2 ̊mŃ[vB
          rule(w(a(1,S)), g0, set(a(1,S))); // 6
          rule(w(a(1,S)), g0, set(a(1,G))); // 7
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, set(a(1,Q)));  // 1
          rule(w(a(1,P)), g1, set(a(2,Q)));  // 2
          rule(w(a(1,P)), g1, exit(a(2,P)));  // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          if (Lab.rand() < panel.getFloat("P(Stone)", 0.5f, 0, 1)) {
              world.addItem(world.rooms[0], Stone);
          }
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }

  // set, call, exit
  public static class TestXMulti12 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = w(a(PLS,S));
          StateN g2 = w(a(2,R));

          setRulesName("g0");
          rule(w(a(1,P)), g0, call(g1));       // 1
          // S1 -> T1 -> G1
          rule(w(a(1,S)), g0, set(a(1,T)));    // 2
          rule(w(a(1,T)), g0, set(a(1,G)));    // 3
          // S2 -> G1
          rule(w(a(2,S)), g0, set(a(1,G)));    // 4
          // Q3 -> R3 -> S3 -> T3 -> U3 -> G1
          //rule(w(a(3,Q)), g0, set(a(3,R)));    // 5
          rule(w(a(3,Q)), g0, primitive(SetWithCost3, w(a(3,R))));
          rule(w(a(3,R)), g0, set(a(3,S)));    // 6
          rule(w(a(3,S)), g0, set(a(3,T)));    // 7
          rule(w(a(3,T)), g0, set(a(3,U)));    // 8
          rule(w(a(3,U)), g0, set(a(1,G)));    // 9
          
          setRulesName("g1");
          // P1 -> Q1 -> R1 -> S1
          rule(w(a(1,P)), g1, set(a(1,Q)));    // 1
          //rule(w(a(1,Q)), g1, set(a(1,R)));    // 2
          rule(w(a(1,Q)), g1, primitive(SetWithCost1, w(a(1,R))));
          rule(w(a(1,R)), g1, set(a(1,S)));    // 3 
          // P1 -> call(R2) -> S2
          rule(w(a(1,P)), g1, call(g2));       // 4
          rule(w(a(2,R)), g1, set(a(2,S)));    // 5
          // exit(Q3)
          rule(w(a(1,P)), g1, exit(a(3,Q)));   // 6

          setRulesName("g2");
          //rule(w(a(1,P)), g2, set(a(2,R)));    // 1
          rule(w(a(1,P)), g2, primitive(SetWithCost2, w(a(2,R))));
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
          // XC_\ĂB
          panel.getFloat("SetWithCost1", -1, -2, 0);
          panel.getFloat("SetWithCost2", -1, -2, 0);
          panel.getFloat("SetWithCost3", -1, -2, 0);
      }
  }
  

  // subtask sharing
  public static class TestXMulti13 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      Object V = "V";
      public boolean shareSubTaskFlag = panel.flag("shareSubTaskFlag", true);
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));

          
          setRulesName("g0");
          rule(w(a(1,S)), g0, call(a(1,T)));   // 1
          rule(w(a(1,T)), g0, primitive(SetWithCost1, w(a(1,G)))); // 2
          rule(w(a(1,U)), g0, set(a(1,V)));    // 3 
          rule(w(a(1,V)), g0, primitive(SetWithCost2, w(a(1,G)))); // 4
          
          rule(w(a(2,S)), g0, call(a(2,T)));   // 5
          rule(w(a(2,T)), g0, primitive(SetWithCost3, w(a(2,G)))); // 6
          rule(w(a(2,U)), g0, set(a(2,V)));    // 7
          rule(w(a(2,V)), g0, primitive(SetWithCost4, w(a(2,G)))); // 8
          
          if (shareSubTaskFlag) {
              StateN g1 = w(a(PLS,T));
              setRulesName("g1");
              // Sx -> Tx
              rule(w(a(x,S)), g1, set(a(x,T)));    // 1
              rule(w(a(x,S)), g1, exit(a(x,U)));   // 2
          
          } else {
              StateN g1 = w(a(1,T));
              StateN g2 = w(a(2,T));
              setRulesName("g1");
              // S1 -> T1
              rule(w(a(1,S)), g1, set(a(1,T)));    // 1
              rule(w(a(1,S)), g1, exit(a(1,U)));   // 2

              setRulesName("g2");
              // S2 -> T2
              rule(w(a(2,S)), g2, set(a(2,T)));    // 1
              rule(w(a(2,S)), g2, exit(a(2,U)));   // 2
          }
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          Agent agent = world.agents[0];
          int task = Lab.irand(2) + 1;
          agent.oldS = agent.newS = Rule.makeState(w(a(task,S)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(task,G)), Rule.WILDCARD);
          // XC_\ĂB
//          panel.getFloat("SetWithCost1", -10, -2, 0);
//          panel.getFloat("SetWithCost2", -12, -2, 0);
//          panel.getFloat("SetWithCost3", -20, -2, 0);
//          panel.getFloat("SetWithCost4", -21, -2, 0);
          panel.getFloat("SetWithCost1", -1, -2, 0);
          panel.getFloat("SetWithCost2", -2, -2, 0);
          panel.getFloat("SetWithCost3", -4, -2, 0);
          panel.getFloat("SetWithCost4", -6, -2, 0);
      }
  }
  
  // Multi-task test.
  public static class TestXMulti14 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }
      Object G = "G";
      Object P = "P";
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      public void addRules(World world, int agentID) {
          StateN g1 = w(a(1,G));
          StateN g2 = w(a(2,G));
          StateN g3 = w(a(1,T));
          StateN g4 = w(a(4,U));
          
          setRulesName("g1");
          rule(w(a(1,P)), g1, set(a(1,U))); // 1
          rule(w(a(1,U)), g1, call(g3));    // 2
          rule(w(a(1,T)), g1, set(a(1,Q))); // 3
          rule(w(a(1,Q)), g1, set(a(1,R))); // 4
          rule(w(a(1,R)), g1, set(a(1,G))); // 5
          
          setRulesName("g2");
          rule(w(a(2,P)), g2, set(a(2,Q))); // 1
          rule(w(a(2,Q)), g2, set(a(1,U))); // 2
          rule(w(a(1,U)), g2, call(g3));    // 3
          rule(w(a(1,T)), g2, set(a(2,G))); // 4
          
          setRulesName("g3");
          rule(w(a(1,U)), g3, call(g4)); // 1 
          rule(w(a(4,U)), g3, set(a(1,T))); // 2

          setRulesName("g4");
          rule(w(a(1,U)), g4, set(a(2,U))); // 1 
          rule(w(a(2,U)), g4, set(a(3,U))); // 2
          rule(w(a(3,U)), g4, set(a(4,U))); // 3
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          if (Lab.rand() > panel.getFloat("G(1) or G(2)", 0.5f, 0, 1)) {
              agent.oldS = agent.newS = Rule.makeState(w(a(1,P)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(1,G)), Rule.WILDCARD);
          } else {
              agent.oldS = agent.newS = Rule.makeState(w(a(2,P)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(2,G)), Rule.WILDCARD);
          }
      }
  }  
  
  // return AB
  // NOTE: Set the slider value "gen penalty" to 100000.
  public static class TestXMulti15 extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { new Agent(Alice, world) };
      }

      public StateN P(Object x, Object y) {
          return w(a(0,0,0,"P",x,y));
      }
      Object Q = "Q";
      Object R = "R";
      Object S = "S";
      Object T = "T";
      Object U = "U";
      Object E = "E";
      Object G = "G";
      public void addRules(World world, int agentID) {

          StateN g0 = w(a(PLS,G));
          StateN g1 = P(PLS,PLS);
          StateN g2 = P(1,PLS);
          
          setRulesName("g0");
          // 
          rule(w(a(1,S)), g0, call(g1));      // 1
          //   P(1,1) -> Q(1) -> G(1) 
          rule(P(1,1), g0, set(a(1,Q)));      // 2 
          rule(w(a(1,Q)), g0, set(a(1,G)));   // 3
          //   P(1,2) -> G(1) 
          rule(P(1,2), g0, set(a(1,G)));      // 4
          
          setRulesName("g1");
          rule(w(a(1,S)), g1, call(g2));    // 1

          setRulesName("g2");
          rule(w(a(1,S)), g2, set(P(1,1)));   // 1
          rule(w(a(1,S)), g2, set(P(1,2)));   // 2
      }
      public void setMap(World world) {
          mapSizeX = 1;
          mapSizeY = 1;
          world.rooms = new Room[]{ Room.Room1 };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }
      public void initEpisode(World world){ 
          world.agents[0].currentRoom = Room.Room1;
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(1,S)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(PLS,G)), Rule.WILDCARD);
      }
  }        

  //------------------------------------------------------------------
  // exit ΉsveXg̋ʐeNXB
  public abstract static class TestXPlanning extends AbstractMainCode {
      public Agent[] makeAgents(World world) {
          return new Agent[] { 
              new Agent(Alice, world), 
              //new Agent(Bob, world),
          };
      }
      public RegisterNArgs A(ClauseN s, ClauseN g) {
          return new RegisterNArgs(Achieves, s, g, c(0,0,0,0,0,0));
      }
      public RegisterNArgs B(ClauseN s, ClauseN sg, ClauseN g) {
          return new RegisterNArgs("B", s, sg, g);
      }
      public RegisterNArgs F(ClauseN s, ClauseN sg, ClauseN g) {
          return new RegisterNArgs("F", s, sg, g);
      }
      ClauseN cPLS = c(__,__,PLS,PLS,__,__);

      public void addPlanningRules() {
          if (panel.flag("New Planning Template", true)) {
          ClauseN s = varClause("s");
          ClauseN a = varClause("a");
          ClauseN g = varClause("g");
          ClauseN x = varClause("x");
          ClauseN y = varClause("y");
          ClauseN sg = varClause("sg");
          ClauseN ssg = varClause("ssg");
          
          setRulesName("FPpan"); // Forward Planning
          // OAɂsv
          StateN fp = w(a(F(s,cPLS,g)));
          rule(w(a(Failed)), fp, exit(a(Failed))); // ʂ̗Onh
          // Start planning.
          rule(w(), fp, call(a(A(s,cPLS))));
          rule(w(a(A(s,sg))), fp, set(a(F(s,sg,sg))));
          // Loop. 
          rule(w(a(F(s,cPLS,sg))), fp, call(a(A(sg,cPLS))));
          rule(w(a(A(sg,ssg))), fp, recall(e(F(s,cPLS,sg))));
          rule(w(a(A(sg,ssg)), e(F(s,cPLS,sg))), fp, set(a(F(s,sg,ssg))));


          setRulesName("P/G");  // Plan and Go
          VariableN start = new VariableN("start");
          ClauseN roomS = c(Now, start, Alice, Exists, 0, 0); 
          VariableN goal = new VariableN("goal");
          ClauseN roomG = c(Now, goal, Alice, Exists, 0, 0); 
          StateN pg = w(a(roomG)); 
          // ̏ꏊ̔FEsvEsA[vB
          // sv悪 fail ꍇ͍ŏ̍s[蒼B
          rule(w(), pg, primitive(RecogRoom));
          rule(w(a(roomS)), pg, call(a(F(roomS,cPLS,roomG))));
          rule(w(a(F(roomS,a,roomG))), pg, call(a(a)));
          } else {
              ClauseN s = varClause("s");
              ClauseN a = varClause("a");
              ClauseN g = varClause("g");
              ClauseN x = varClause("x");
              ClauseN y = varClause("y");
              ClauseN sg = varClause("sg");
              ClauseN ssg = varClause("ssg");
              
              setRulesName("FPpan"); // Forward Planning
              // OAɂsv
              StateN fp = w(a(F(s,cPLS,g)));
              rule(w(a(Failed)), fp, exit(a(Failed))); // ʂ̗Onh
              // Start planning.
              rule(w(), fp, call(a(A(s,cPLS))));
              rule(w(a(A(s,sg))), fp, set(a(F(s,sg,sg))));
              // Loop. 
              rule(w(a(F(s,cPLS,sg))), fp, call(a(A(sg,cPLS))));
              rule(w(a(A(sg,ssg))), fp, recall(e(F(s,cPLS,sg))));
              rule(w(a(A(sg,ssg)), e(F(s,cPLS,sg))), fp, set(a(F(s,sg,ssg))));


              setRulesName("P/G");  // Plan and Go
              VariableN start = new VariableN("start");
              ClauseN roomS = c(Now, start, Alice, Exists, 0, 0); 
              VariableN goal = new VariableN("goal");
              ClauseN roomG = c(Now, goal, Alice, Exists, 0, 0); 
              StateN pg = w(a(roomG)); 
              // ̏ꏊ̔FEsvEsA[vB
              // sv悪 fail ꍇ͍ŏ̍s[蒼B
              rule(w(), pg, primitive(RecogRoom));
              rule(w(a(roomS)), pg, call(a(F(roomS,cPLS,roomG))));
              rule(w(a(F(roomS,a,roomG))), pg, call(a(a)));
              }
      }
  
      public static class S extends Room {
          public S(int id) {
              super("S"+ id);
          }
      }
}
  
  // exit Ή̍sveXgP
  // ꒼̃}bvF r1->r2->r3->r4->5
  public static class TestXPlanning1 extends TestXPlanning {
      ClauseN room1 = c(Now, Room1, Alice, Exists, 0, 0); 
      ClauseN room2 = c(Now, Room2, Alice, Exists, 0, 0); 
      ClauseN room3 = c(Now, Room3, Alice, Exists, 0, 0); 
      ClauseN room4 = c(Now, Room4, Alice, Exists, 0, 0); 
      ClauseN room5 = c(Now, Room5, Alice, Exists, 0, 0);
      public void addRules(World world, int agentID) {
          
          addPlanningRules();

          setRulesName("Act");
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoToRoom, Room5));

          setRulesName("Inf");
          // ꂼ̃GA瓌ɂPړł邱Ƃuؖv鐄_KB
          rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
          rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room3))));
          rule(w(), w(a(A(room3,cPLS))), set(a(A(room3,room4))));
          rule(w(), w(a(A(room4,cPLS))), set(a(A(room4,room5))));
      }
      public void setMap(World world) {
          mapSizeX = 5;
          mapSizeY = 1;
          world.rooms = new Room[]{ 
                  Room1,Room2,Room3,Room4,Room5, 
          };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }

      public void initEpisode(World world) {
          world.agents[0].currentRoom = world.rooms[0];
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          if (Lab.rand() > panel.getFloat("G = Room3 or Room5", 1f, 0, 1)) {
              agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(room3)), Rule.WILDCARD);
          } else {
              agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(room5)), Rule.WILDCARD);
          }
      }
  }


  // exit Ή̍sveXgQ 
  // room1->room2->room4, room1->room3->room4
  public static class TestXPlanning2 extends TestXPlanning {
      ClauseN room1 = c(Now, Room1, Alice, Exists, 0, 0); 
      ClauseN room2 = c(Now, Room2, Alice, Exists, 0, 0); 
      ClauseN room3 = c(Now, Room3, Alice, Exists, 0, 0); 
      ClauseN room4 = c(Now, Room4, Alice, Exists, 0, 0);
      public void addRules(World world, int agentID) {

          addPlanningRules();

          setRulesName("Act");
          //rule(w(a(Failed)), w(a(Now, __, Alice, Exists, 0, 0)), exit(a(Failed)));
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
          rule(w(a(Now, Room3, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));

          setRulesName("Inf");
          rule(w(), w(a(A(cPLS,cPLS))), exit(a(Failed)));
          rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
          rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room4))));
          rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room3))));
          rule(w(), w(a(A(room3,cPLS))), set(a(A(room3,room4))));
      }
      public void setMap(World world) {
          mapSizeX = 4;
          mapSizeY = 1;
          world.rooms = new Room[]{ 
                  Room1,Room2,Room3,Room4, 
          };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }

      public String impassableRoute = (String)panel.getSelectedValue("Impassable Routes", 
              new Object[] {"nothing", "r1->r2", "r2->r4"});
      public void initEpisode(World world) {
          world.agents[0].currentRoom = world.rooms[0];
          world.addItem(world.rooms[0], Alice);
          
          Agent agent = world.agents[0];
          agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
          agent.oldG = agent.newG = Rule.makeState(w(a(room4)), Rule.WILDCARD);
          switch (impassableRoute) {
          case "r1->r2":
              world.impassableRoutes = new Room[][] {{Room1, Room2}};
              break;
          case "r2->r4":
              world.impassableRoutes = new Room[][] {{Room2, Room4}};
              break;
          default:
              break;
          }
      }
  }

  // r1->r2->r3, r1->r4->r5
  public static class TestXPlanning3 extends TestXPlanning {
      ClauseN room1 = c(Now, Room1, Alice, Exists, 0, 0); 
      ClauseN room2 = c(Now, Room2, Alice, Exists, 0, 0); 
      ClauseN room3 = c(Now, Room3, Alice, Exists, 0, 0); 
      ClauseN room4 = c(Now, Room4, Alice, Exists, 0, 0); 
      ClauseN room5 = c(Now, Room5, Alice, Exists, 0, 0);
      public void addRules(World world, int agentID) {
          
          addPlanningRules();

          setRulesName("Act");
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room2, Alice, Exists, 0, 0)), primitive(GoToRoom, Room2));
          rule(w(a(Now, Room2, Alice, Exists, 0, 0)), w(a(Now, Room3, Alice, Exists, 0, 0)), primitive(GoToRoom, Room3));
          rule(w(a(Now, Room1, Alice, Exists, 0, 0)), w(a(Now, Room4, Alice, Exists, 0, 0)), primitive(GoToRoom, Room4));
          rule(w(a(Now, Room4, Alice, Exists, 0, 0)), w(a(Now, Room5, Alice, Exists, 0, 0)), primitive(GoToRoom, Room5));

          setRulesName("Inf");
          rule(w(), w(a(A(cPLS,cPLS))), exit(a(Failed)));
          rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room2))));
          rule(w(), w(a(A(room2,cPLS))), set(a(A(room2,room3))));
          rule(w(), w(a(A(room1,cPLS))), set(a(A(room1,room4))));
          rule(w(), w(a(A(room4,cPLS))), set(a(A(room4,room5))));      
      }
      public void setMap(World world) {
          mapSizeX = 5;
          mapSizeY = 1;
          world.rooms = new Room[]{ 
                  Room1,Room2,Room3,Room4,Room5, 
          };
          world.map = new Room[mapSizeX * mapSizeY];
          Lab.assertTrue(mapSizeX * mapSizeY == world.rooms.length);
      }

      public void initEpisode(World world) {
          world.agents[0].currentRoom = world.rooms[0];
          world.addItem(world.rooms[0], Alice);
          Agent agent = world.agents[0];
          if (Lab.rand() > panel.getFloat("G = Room3 or Room5", 0.5f, 0, 1)) {
              agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(room3)), Rule.WILDCARD);
          } else {
              agent.oldS = agent.newS = Rule.makeState(w(a(room1)), Rule.ZERO);
              agent.oldG = agent.newG = Rule.makeState(w(a(room5)), Rule.WILDCARD);
          }
      }
  }



  //Default dummy task.
  public static class Demo0_Dummy extends AbstractMainCode {
      public Agent[] makeAgents(World world) { return new Agent[] {new Agent(Alice, world)}; }
      public void addRules(World world, int agentID){
          throw new StopPressed();
      }
      public void initEpisode(World world){ throw new Error(); }
  }
}
