package qbc;

import lab.Lab;
import lab.Lab.LabCode;
import qbc.QBN.B;
import qbc.QBN.QBNnet;
import qbc.QBN.ResultVisualizer;
import qbc.QBN.StdoutVisualizer;
import qbc.QBN.VarEnv;

public class QBNlab {
	public static void main(String[] args) {
        Lab.addSelectableClass(QBNlab.class);
        System.out.println(Lab.selectableClasses + "");

        LabCode labCode = new LabCode();
        labCode.main(QBNtestMain.class);

	}
    public static enum B {
        N1,N2,N3,N4,N5,
        True, False;
        public static Object[][][] netData01 = { 
            {{N1}, 
                {False,},
                {True,},
            },
            {{N2},
                {False,},
                {True,},
            },
            {{N3, N1, N2},
                {False, False, False,},
                {True, True, False,},
                {True, False, True,},
                {True, True, True,},
            },
            {{N4, N3},
                {False, False,},
                {True, True,},
            },
            {{N5, N3},
                {True, True,},
                {False, False,},
            },
        };
    }
    public static enum WhereWhat01 {
        A0, A1, A2,
        X,Y,
        Where, What,
        G0,G1,G2,
        V0,V1,V2,
        ;
        public static String __ = QBN.WildCard; // Two underscores.
        public static Object[][][] netData01 = { 
            {{Where}, 
                {A0},
                {A1},
                {A2},
            },
            {{What},
                {X},
                {Y},
            },
            {{G0,Where,What},
                {X,A0,X},
                {Y,A0,Y},
                {__,A1,__},
                {__,A2,__},
            },
            {{G1,Where,What},
                {__,A0,__},
                {X,A1,X},
                {Y,A1,Y},
                {__,A2,__},
            },
            {{G2,Where,What},
                {__,A0,__},
                {__,A1,__},
                {X,A2,X},
                {Y,A2,Y},
            },
            {{V0,G0},
                {X,X},
                {Y,Y},
            },
            {{V1,G1},
                {X,X},
                {Y,Y},
            },
            {{V2,G2},
                {X,X},
                {Y,Y},
            },
        };
    }
	
    public static class QBNtestMain extends Lab.MainCode {
        public QBNnetCode netCode = panel.getCode("netCode", QBNnetCode.class);
        public VisualizerCode visualizerCode = panel.getCode("visualizer", VisualizerCode.class);  
		public void main() {
            QBNnet net = netCode.makeQBNnet();
	        System.out.println("net:");
	        System.out.println(net.toString());
	        net.infer(visualizerCode);
		}
    }
    public abstract static class QBNnetCode extends Lab.Code {
        public abstract QBNnet makeQBNnet();
    }
    public static class NetCode01 extends QBNnetCode {
        public QBNnet makeQBNnet(){
            return new QBNnet(B.netData01);
        }
    }
    public static class NetCodeWhereWhat01 extends QBNnetCode {
        public QBNnet makeQBNnet(){
            return new QBNnet(WhereWhat01.netData01);
        }
    }
    public abstract static class VisualizerCode extends Lab.Code implements ResultVisualizer {
    }
    public static class TextVisualizerCode extends VisualizerCode {
        public int resultCount = 0;
		public void call(QBNnet net, VarEnv varEnv) {
            resultCount++;
            env.viewPanel.print1("result "+ resultCount, varEnv.toString());
		}
    }
    public static class StdoutVisualizerCode extends VisualizerCode {
        public int resultCount = 0;
		public void call(QBNnet net, VarEnv varEnv) {
            resultCount++;
            System.out.println(" result "+  resultCount);
            System.out.println(varEnv.toString());
		}
    }
}
