/**
 * 萫IxCWAlbg _GW
 *   炭 prolog xɑB ϐ̕וɂđx傫ςB
 *   iőŃm[hɑ΂`ԁAňŎwԁBj
 *  
 *  Java8 ̋@\gB
 *  
 *  ## m[gob z:  push ̃eXgB
 *  
 */

package qbc;

import java.util.*;

import lab.Lab;

public class QBN {
    public static void main(String[] args) {
        // CPT ̒l null ͋ȂB
        QBNnet net = new QBNnet(netData01);
        System.out.println("net:");
        System.out.println(net.toString());
        net.infer(new StdoutVisualizer());
            
    }
    public static final String WildCard = "__".intern();
    public static final String Phi = "0".intern();
    public static final String Open = "0".intern();
    public static final String Inhibit = "1".intern();
    public static enum B {
        True, False,
    }
    /*
     *  E zɂxCWAlbg̒`tH[}bgF
     *  {
     *      { // Pڂ̃m[h̒`
     *          // ŏ̗vf͐eqm[h̔z
     *          {qm[hAem[hPAem[hQAEEE},
     *          // ȍ~̗vf͓mOɂȂeqm[h̒l̑g̔z
     *          {qm[h̒lAem[h̒lPAem[h̒lQAEEE},
     *          {qm[h̒lAem[h̒lPAem[h̒lQAEEE},
     *          ...
     *      },
     *      { // Qڂ̃m[h̒`
     *          ...
     *      },
     *      ...
     *  }:
     *  
     *  E m[hƒl Object ^ł΂Ȃł悢B 
     *    == ZqŔrB String ͎I intern ĂgB
     *    
     *  Elɂ̓ChJ[hwłB QBN.wildCard ̒lƂĒ`ĂB
     */
    public static Object[][][] netData01 = {
        {{"N1"}, 
            {B.False,},
            {B.True,},
        },
        {{"N2"},
            {B.False,},
            {B.True,},
        },
        {{"N3", "N1", "N2",},
            {B.False, B.False, B.False,},
            {B.True, B.True, B.False,},
            {B.True, B.False, B.True,},
            {B.True, B.True, B.True,},
        },
        {{"N4", "N3"},
            {B.False, B.False,},
            {B.True, B.True,},
        },
        {{"N5", "N3"},
            {B.True, B.True,},
            {B.False, B.False,},
        },
    };

    /**
     */
    public static class QBNnet {
        public VarEnv initialEnv = new EmptyEnv();
        public QBNnode[] allNodes;
        public QBNnet(Object[][][] netData) {
            if (true){
                System.out.println("netData = "+ netDataToString(netData));
            }
            allNodes = Arrays.stream(netData)
                    .map(d -> new QBNnode(d)).toArray(QBNnode[]::new);
        }

//        public void print(String mess) {
//            System.out.println(mess);
//            System.out.println("allNodes:");
//            for (int i = 0; i < allNodes.length; i++) {
//                allNodes[i].print();
//            }
//            initialEnv.print("initialEnv:");
//        }
        public static String netDataToString(Object[][][] netData){
            String ret = "{ ";
            for (int i = 0; i < netData.length; i++) {
                ret += "{"+ Lab.lineSeparator;
                for (int j = 0; j < netData[i].length; j++) {
                    ret += "    {";
                    for (int k = 0; k < netData[i][j].length; k++) {
                        ret += netData[i][j][k]+ ", ";
                    }
                    ret += "},"+ Lab.lineSeparator;
                }
                ret += "  }, ";
            } 
            ret += "};"+ Lab.lineSeparator;
            return ret;
        }
        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("allNodes:");
            buf.append(Lab.lineSeparator);
            for (int i = 0; i < allNodes.length; i++) {
                buf.append(allNodes[i].toString());
            }
            buf.append("initialEnv:");
            buf.append(Lab.lineSeparator);
            initialEnv.toString();
            return buf.toString();
        }

        public void setVal(Object var, Object val) {
            initialEnv = initialEnv.bind(var, val);
        }

        /**
         * TB action ĂԁB
         *  XXX: action Pł̂H̂߂ɒTPXebvƂɌĂԊ֐~B
         *  
         *   intern ݁B Object ͍̂ equals ł͂Ȃ == ŔrB
         */
        public void infer(ResultVisualizer visualizer) {
            infer1(allNodes, 0, initialEnv, visualizer);
        }
        public void sortAndInfer(ResultVisualizer visualizer, boolean bottomUp) {
            
            infer1(sortNode(allNodes, bottomUp), 0, initialEnv, visualizer);
        }
        public QBNnode[] sortNode(QBNnode[] nodes, boolean bottomUp) {
            if (true) System.out.println("Start sortNode.");
            List<QBNnode> nodeList = Arrays.asList(nodes);
            List<List<QBNnode>> layers = new ArrayList<>();
            Set<QBNnode> selectedNodes = new HashSet<>();
            if (bottomUp){
                // Find leaf nodes.
                List<QBNnode> leafNodes = new ArrayList<>();
                nodeList.forEach(node -> {
                childFound: {
                    for (int i = 0; i < nodes.length; i++) {
                        for (int j = 1; j < nodes[i].varNames.length; j++) { 
                            if (node.name == nodes[i].varNames[j]) break childFound;
                        }
                    }
                    // No children found.
                    leafNodes.add(node);
                    selectedNodes.add(node);
                }
                });
                layers.add(leafNodes);
                
                // Make each layer.
                List<QBNnode> currentLayer = leafNodes;
                while (selectedNodes.size() < nodes.length){
                    List<QBNnode> nextLayer = new ArrayList<>();
                    currentLayer.forEach(node -> {
                        for (int j = 1; j < node.varNames.length; j++) {
                            Object p = node.varNames[j];
                            QBNnode pn = nodeList.stream()
                                    .filter(n -> n.name == p)
                                    .findFirst()
                                    .get();
                            if (! selectedNodes.contains(pn)){
                                nextLayer.add(pn);
                                selectedNodes.add(pn);
                            }
                        }
                    });
                    layers.add(nextLayer);
                    currentLayer = nextLayer;
                }
            } else {
                // Find root nodes.
                List<QBNnode> rootNodes = new ArrayList<>();
                nodeList.forEach(node -> {
                    if (node.varNames.length == 1){
                        rootNodes.add(node);
                        selectedNodes.add(node);
                    }
                });
                layers.add(rootNodes);
                
                // Make each layer.
                List<QBNnode> currentLayer = rootNodes;
                while (selectedNodes.size() < nodes.length){
                    List<QBNnode> nextLayer = new ArrayList<>();
                    for (int i = 0; i < nodes.length; i++) {
                        QBNnode node = nodes[i];
                        if (! selectedNodes.contains(node)){
                            parentFound:
                            for (int j = 1; j < node.varNames.length; j++) {
                                Object p = node.varNames[j];
                                for (int k = 0; k < currentLayer.size(); k++){
                                   if (currentLayer.get(k).name == p){
                                       nextLayer.add(node);
                                       selectedNodes.add(node);
                                       break parentFound;
                                   }
                                }
                            }
                        }
                    }
                    layers.add(nextLayer);
                    currentLayer = nextLayer;
                }
            }
            // Flattern.
            List<QBNnode> sortedNodes = new ArrayList<>();
            layers.forEach(layer -> {
                layer.forEach(n -> sortedNodes.add(n));
            });
            
            // Make sorted list.
            QBNnode[] ret = (QBNnode[])sortedNodes.toArray(new QBNnode[0]);
            // For debug.
            if (true){
                System.out.println("sortNode:");
                for (int i = 0; i < ret.length; i++) {
                    System.out.print(i+ ": ");
                    for (int j = 0; j < ret[i].varNames.length; j++) {
                        System.out.print(ret[i].varNames[j]+ ", ");
                    }
                    System.out.println();
                } 
            }
            return ret;
        }

        public void infer1(QBNnode[] nodes, int i, VarEnv curEnv, ResultVisualizer visualizer) {
            if (nodes.length == i) {
                if (visualizer != null) visualizer.call(this, curEnv);
                return;
            }
        tryNextCp:
            for (Object[] cp : nodes[i].cpt){
                // ϐčċNĂяoB
                // Ɏs牽Ɏ̂bos̒lցB
                VarEnv newEnv = curEnv;
                for (int k = 0; k < cp.length; k++) {
                    Object var = nodes[i].varNames[k];
                    Object val = cp[k];
                    if (val == QBN.WildCard){
                            // Do nothing.
                    } else {
                        newEnv = newEnv.bind(var, val);
                        if (newEnv == null) {
                            // ȑO bind lƖꍇ fail Ƃ݂ȂA
                            // Ⴄl̑gݍ킹B
                            continue tryNextCp;
                        }
                    }
                }
                infer1(nodes, i + 1, newEnv, visualizer);
            }
        }
    }
    public static interface ResultVisualizer {
    	public abstract void call(QBNnet net, VarEnv env);
    }
    public static class StdoutVisualizer implements ResultVisualizer {
        public int resultCount = 0;
		public void call(QBNnet net, VarEnv varEnv) {
            resultCount++;
            System.out.println(" result "+  resultCount);
            System.out.println(varEnv.toString());
		}
    }

    public static class QBNnode {
        public Object name; // Name of this node.
        public Object[] varNames; // {this node, parent node1, ...}
        public Object[][] cpt;
        public QBNnode(Object[][] nodeData) {
            //
            varNames = internArray(nodeData[0]);
            name = varNames[0];
            cpt = new Object[nodeData.length - 1][];
            for (int i = 0; i < cpt.length; i++) {
                cpt[i] = internArray(nodeData[i+1]); 
            }
        }
        public void print() {
            System.out.print("  varNames: ");
            for (int i = 0; i < varNames.length; i++) {
                System.out.print(varNames[i]+ ", ");
            }
            System.out.println();
            System.out.println("  cpt:");
            for (int i = 0; i < cpt.length; i++) {
                System.out.print("    ");
                for (int j = 0; j < cpt[i].length; j++) {
                    System.out.print(cpt[i][j]+ ", ");
                }
                System.out.println();
            }
        }
        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("  varNames: ");
            for (int i = 0; i < varNames.length; i++) {
                buf.append(varNames[i]+ ", ");
            }
            buf.append(Lab.lineSeparator);
            buf.append("  cpt:");
            buf.append(Lab.lineSeparator);
            for (int i = 0; i < cpt.length; i++) {
                buf.append("    ");
                for (int j = 0; j < cpt[i].length; j++) {
                    buf.append(cpt[i][j]+ ", ");
                }
                buf.append(Lab.lineSeparator);
            }
            return buf.toString();
        }
    }
    public static Object[] internArray(Object[] a){
        return Arrays.stream(a)
                .map(x -> x instanceof String ? ((String)x).intern() : x)
                .toArray();
    }

    public static class VarEnv {
        public Object thisVar;
        public Object thisVal;
        public VarEnv nextEnv;

        public VarEnv(Object var, Object val, VarEnv varEnv) {
            thisVar = var;
            thisVal = val;
            nextEnv = varEnv;
        }

        public Object findVal(Object var) {
            VarEnv ee = this;
            while (! (ee instanceof EmptyEnv)){
                if (ee.thisVar == var) return ee.thisVal;
                ee = ee.nextEnv;
            }
            return null;
        }

        public VarEnv bind(Object var, Object val) {
            Object v = findVal(var);
            if (v == null) return new VarEnv(var, val, this);
            if (v != val) return null;
            return this;
        }
        public void print(String mess){
            System.out.println(mess);
            VarEnv ee = this;
            while (! (ee instanceof EmptyEnv)){
                System.out.println(ee.thisVar+ " : "+ ee.thisVal);
                ee = ee.nextEnv;
            }
        }
        public String toString(){
            StringBuffer buf = new StringBuffer();
            VarEnv ee = this;
            while (! (ee instanceof EmptyEnv)){
                buf.append(ee.thisVar+ " : "+ ee.thisVal);
                buf.append(Lab.lineSeparator);
                ee = ee.nextEnv;
            }
            return buf.toString();
        }
    }
    public static class EmptyEnv extends VarEnv {
        public EmptyEnv() {
            // Set dummy values for parent's fields.
            super(null, null, null);
        }
    }

}
