/**
 QBC g֌W̃eXgvOt@CB
*/

package qbc;

import java.util.ArrayList;
import java.util.List;

import lab.Lab;
import lab.Lab.LabCode;
import qbc.QBC.QBCMain;
import qbc.QBC.QBCVisualizerCode;
import qbc.QBC.QBCdsl;
import qbc.QBC.QBCnet;
import qbc.QBC.QBCnetCode;
import qbc.QBC.QBCtest0.MakeNet;
import qbc.QBN.QBNnet;
import qbc.QBN.ResultVisualizer;
import qbc.QBN.VarEnv;
import qbc.QBNlab.B;
import qbc.QBNlab.QBNnetCode;
import qbc.QBNlab.VisualizerCode;

public class Memory {
    public static void main(String[] args) {
        Lab.addSelectableClass(QBN.class);
        Lab.addSelectableClass(QBNlab.class);
        Lab.addSelectableClass(QBC.class);
        Lab.addSelectableClass(Memory.class);
        System.out.println(Lab.selectableClasses + "");

        LabCode labCode = new LabCode();
        labCode.main(QBCMain.class);
    }
    /** 
     * X^bNB
     * X^bNӂƈAX^bN̒ꂩ㏑ĂB
     */
    public static class Stack2 extends QBCnetCode {
        public QBCnet makeQBCnet(){
            return MakeNet.Dummy.makeNet();
        }
        public static enum MakeNet implements QBCdsl {
            Top,PTop,
            M1,M2,M3,
            PM1,PM2,PM3,
            OP,IN,OUT,
            Push,Pop,Nop,
            Spush1,Spop1,Snop1,
            Spush2,Spop2,Snop2,
            Spush3,Spop3,Snop3,
            A,B,
            Dummy;
            public QBCnet makeNet(){
                QBCnet net = new QBCnet();
                net.tableNodeList.add(tableNode(Top, table(
                        // childNames: [
                        // PTop, OP, 
                        // M1->PM1, M2->PM2, M3->PM3, 
                        // M1->IN, M2->IN, M3->IN, 
                        // M1->OUT, M2->OUT, M3->OUT]
                        // {Push,Pop,Nop}x{S1,S2,S3} ɑ΂ăQ[g`B
                        row(Spush1,or(Spush3,Spop3,Snop3),Push,
                                I,O,O, O,I,I, I,I,I),//input to M1
                        row(Spop1,or(Spush2,Spop2,Snop2),Pop, 
                                O,O,O, I,I,I, I,O,I),//output from M2
                        row(Snop1,or(Spush1,Spop1,Snop1),Nop, 
                                O,O,O, I,I,I, I,I,I),
                        row(Spush2,or(Spush1,Spop1,Snop1),Push, 
                                O,I,O, I,O,I, I,I,I),//input to M2
                        row(Spop2,or(Spush3,Spop3,Snop3),Pop, 
                                O,O,O, I,I,I, I,I,O),//output from M3
                        row(Snop2,or(Spush2,Spop2,Snop2),Nop, 
                                O,O,O, I,I,I, I,I,I),
                        row(Spush3,or(Spush2,Spop2,Snop2),Push, 
                                O,O,I, I,I,O, I,I,I),//input to M3
                        row(Spop3,or(Spush1,Spop1,Snop1),Pop, 
                                O,O,O, I,I,I, O,I,I),//output from M1
                        row(Snop3,or(Spush3,Spop3,Snop3),Nop, 
                                O,O,O, I,I,I, I,I,I)
                        )));
                net.tableNodeList.add(tableNode(PTop, table(
                        row(Spush1),row(Spop1),row(Snop1),
                        row(Spush2),row(Spop2),row(Snop2),
                        row(Spush3),row(Spop3),row(Snop3)
                        )));
                net.tableNodeList.add(tableNode(M1, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(M2, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(M3, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(PM1, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(PM2, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(PM3, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(OP, table(
                        row(Push), row(Pop), row(Nop))));
                net.tableNodeList.add(tableNode(IN, table(
                        row(A), row(B))));
                net.tableNodeList.add(tableNode(OUT, table(
                        row(A), row(B))));
                net.gateMatrixList.add(gateMatrix(
                        list(), list(Top), list(PTop,OP)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M1), list(PM1)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M2), list(PM2)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M3), list(PM3)));
                net.gateMatrixList.add(gateMatrix(
                        list(Top), list(M1,M2,M3), list(IN)));
                net.gateMatrixList.add(gateMatrix(
                        list(Top), list(M1,M2,M3), list(OUT)));
                return net;
            }
        }
    }
    /** 
     * X^bNBȂB
      row(S1,A,B),row(S1,C,D) ƋLq row(S1, or(A,C), or(B,D)) ƓŁA
    qm[h̒l̑g͂Sʂ肷ׂĂi炵j_ɒӁB
     */
    public static class Stack1 extends QBCnetCode {
        public QBCnet makeQBCnet(){
            return MakeNet.Dummy.makeNet();
        }
        public static enum MakeNet implements QBCdsl {
            Top,PTop,
            M1,M2,M3,M4,
            PM1,PM2,PM3,PM4,
            OP,IN,OUT,
            Push,Pop,Nop,
            S1,S2,S3,S4,
            A,B,
            Dummy;
            public QBCnet makeNet(){
                QBCnet net = new QBCnet();
                net.tableNodeList.add(tableNode(Top, table(
                        // childNames: [
                        // PTop, OP, 
                        // M1->PM1, M2->PM2, M3->PM3, 
                        // M1->IN, M2->IN, M3->IN, 
                        // M1->OUT, M2->OUT, M3->OUT]
                        // {Push,Pop,Nop}x{S1,S2,S3} ɑ΂ăQ[g`B
                        row(S1,S3,Push, I,O,O, O,I,I, I,I,I),//input to M1
                        row(S1,S2,Pop, O,O,O, I,I,I, I,O,I),//output from M2
                        row(S1,S1,Nop, O,O,O, I,I,I, I,I,I),
                        row(S2,S1,Push, O,I,O, I,O,I, I,I,I),//input to M2
                        row(S2,S3,Pop, O,O,O, I,I,I, I,I,O),//output from M3
                        row(S2,S2,Nop, O,O,O, I,I,I, I,I,I),
                        row(S3,S2,Push, O,O,I, I,I,O, I,I,I),//input to M3
                        row(S3,S1,Pop, O,O,O, I,I,I, O,I,I),//output from M1
                        row(S3,S3,Nop, O,O,O, I,I,I, I,I,I)
                        )));
                net.tableNodeList.add(tableNode(PTop, table(
                        row(S1),row(S2),row(S3)
                        )));
                net.tableNodeList.add(tableNode(M1, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(M2, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(M3, table(
                        row(A,A,A,A), row(B,B,B,B))));
                net.tableNodeList.add(tableNode(PM1, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(PM2, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(PM3, table(row(A), row(B))));
                net.tableNodeList.add(tableNode(OP, table(
                        row(Push), row(Pop), row(Nop))));
                net.tableNodeList.add(tableNode(IN, table(
                        row(A), row(B))));
                net.tableNodeList.add(tableNode(OUT, table(
                        row(A), row(B))));
                net.gateMatrixList.add(gateMatrix(
                        list(), list(Top), list(PTop,OP)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M1), list(PM1)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M2), list(PM2)));
                net.gateMatrixList.add(gateMatrix(list(Top), list(M3), list(PM3)));
                net.gateMatrixList.add(gateMatrix(
                        list(Top), list(M1,M2,M3), list(IN)));
                net.gateMatrixList.add(gateMatrix(
                        list(Top), list(M1,M2,M3), list(OUT)));
                return net;
            }
        }
    }
    /** 
     * eXgvÕev[gB
     */
    public static class QBCtest0 extends QBCnetCode {
        public QBCnet makeQBCnet(){
            return MakeNet.Dummy.makeNet();
        }
        public static enum MakeNet implements QBCdsl {
            U1,U2,X1,X2,
            A,B,C,D,E,F,
            W,X,Y,Z,
            V1,V2,V3,V4,
            Dummy;
            public QBCnet makeNet(){
                QBCnet net = new QBCnet();
                net.tableNodeList.add(tableNode(U1, table(
                        row(V1,A,A),
                        row(V2,B,B)
                        )));
                net.tableNodeList.add(tableNode(U2, table(
                        row(V1,__,__),
                        row(V2,A,__)
                        )));
                net.tableNodeList.add(tableNode(X1, table(
                        row(A), row(B)
                        )));
                net.tableNodeList.add(tableNode(X2, table(
                        row(A), row(B)
                        )));
                net.gateMatrixList.add(gateMatrix(
                        list(), list(U1,U2), list(X1,X2)
                        ));
                return net;
            }
        }
    }
    /**
     * pam̒`̃ev[g  
     */
    public static class QBN0 extends QBNnetCode {
        public QBNnet makeQBNnet(){
            return new QBNnet(Net.netData);
        }
        public static enum Net {
            N1,N2,N3,N4,N5,
            True, False,
            Dummy;
            public static String __ = QBN.WildCard; // Two underscores.
            public static Object[][][] netData = { 
                {{N1}, 
                    {False,},
                    {True,},
                },
                {{N2},
                    {False,},
                    {True,},
                },
                {{N3, N1, N2},
                    {False, False, False,},
                    {True, True, False,},
                    {True, False, True,},
                    {True, True, True,},
                },
                {{N4, N3},
                    {False, False,},
                    {True, True,},
                },
                {{N5, N3},
                    {True, True,},
                    {False, False,},
                },
            };
        }
    }
    public static class QBNMain2 extends Lab.MainCode {
        public QBNnetCode netCode = panel.getCode("netCode", QBNnetCode.class);
        public QBNVisualizerCode2 visualizerCode
            = panel.getCode("visualizer", QBNVisualizerCode2.class);
        public void main() {
            QBNnet net = netCode.makeQBNnet();
            visualizerCode.init(net);
            System.out.println("net:");
            System.out.println(net.toString());
            net.infer(visualizerCode);
            visualizerCode.finish();
        }
    }
    public abstract static class QBNVisualizerCode2 extends Lab.Code implements ResultVisualizer {
        public abstract void init(QBNnet qbnNet);
        public abstract void finish();
    }
    // pam̉̒l̑gbru`ŃeLXgóB
    public static class QBNVisualizeCSV1 extends QBNVisualizerCode2 {
        public int counter = 0;
        public List<Object> varList = new ArrayList<>();
        public Lab.WTextArea textArea;
        public void init(QBNnet qbnNet){
            textArea = new Lab.WTextArea(env, "Solutions");
            for (int i = 0; i < qbnNet.allNodes.length; i++) {
                varList.add(qbnNet.allNodes[i].name);
            }
              
            varList.forEach(var -> {
                textArea.print(var+ ", ");
            });
            textArea.println("");
        }
        public void call(QBNnet net, VarEnv varEnv) {
            counter++;
            varList.forEach(var -> {
                textArea.print(varEnv.findVal(var)+ ", ");
            });
            textArea.println("");
        }
        public void finish(){
            textArea.println(counter+ " solutions.");
        }
    }
    /**
     * WX^̓쌴mFB  
     */
    public static class Register1 extends QBNnetCode {
        public QBNnet makeQBNnet(){
            return new QBNnet(Net.netData);
        }
        public static enum Net {
            C,T,A,B,GTA,GTB,GAAP,GBBP,AP,BP,
            CopyAtoB,CopyBtoA,Nop,
            True, False,
            Dummy;
            public static String __ = QBN.WildCard; // Two underscores.
            public static Object[][][] netData = { 
                {{C}, 
                    {CopyAtoB,},
                    {CopyBtoA,},
                    {Nop,},
                },
                {{T},
                    {True,},
                    {False,},
                },
                {{A, GTA},
                    {True, True,},
                    {False, False,},
                },
                {{B, GTB},
                    {True, True,},
                    {False, False,},
                },
                {{GTA, C, T},
                    {True, CopyAtoB, True,},
                    {False, CopyAtoB, False,},
                    {True, CopyBtoA, True,},
                    {False, CopyBtoA, False,},
                    {__, Nop, __,},
                },
                {{GTB, C, T},
                    {True, CopyAtoB, True,},
                    {False, CopyAtoB, False,},
                    {True, CopyBtoA, True,},
                    {False, CopyBtoA, False,},
                    {__, Nop, __,},
                },
                {{GAAP, C, A},
                    {True, CopyAtoB, True,},
                    {False, CopyAtoB, False,},
                    {__, CopyBtoA, __,},
                    {True, Nop, True,},
                    {False, Nop, False,},
                },
                {{GBBP, C, B},
                    {__, CopyAtoB, __,},
                    {True, CopyBtoA, True,},
                    {False, CopyBtoA, False,},
                    {True, Nop, True,},
                    {False, Nop, False,},
                },
                {{AP, GAAP},
                    {True, True,},
                    {False, False,},
                },
                {{BP, GBBP},
                    {True, True,},
                    {False, False,},
                },
            };
        }
    }
    /**
     * ̓쌴mFB  
     */
    public static class Memory1 extends QBNnetCode {
        public QBNnet makeQBNnet(){
            return new QBNnet(Net.netData);
        }
        public static enum Net {
            C,A,D,
            GDM1,GDM2,GDM3,
            M1,M2,M3,
            GM1P,GM2P,GM3P,
            M1P,M2P,M3P,
            A1,A2,A3,
            Read, Write,
            True, False,
            Dummy;
            public static String __ = QBN.WildCard; // Two underscores.
            public static Object[][][] netData = { 
                {{C}, 
                    {Read,},
                    {Write,},
                },
                {{A},
                    {A1, },
                    {A2, },
                    {A3, },
                },
                {{D},
                    {True, },
                    {False, },
                },
                {{M1, GDM1},
                    {True, True,},
                    {False, False,},
                },
                {{M1P, GM1P},
                    {True, True,},
                    {False, False,},
                },
                {{M2, GDM2},
                    {True, True,},
                    {False, False,},
                },
                {{M2P, GM2P},
                    {True, True,},
                    {False, False,},
                },
                {{M3, GDM3},
                    {True, True,},
                    {False, False,},
                },
                {{M3P, GM3P},
                    {True, True,},
                    {False, False,},
                },
                //
                {{GDM1, A, D, },
                    {True, A1, True, },
                    {False, A1, False, },
                    {__, A2, __, },
                    {__, A3, __, },
                },
                {{GM1P, C, A, M1},
                    {__, Write, A1, __, },
                    {True, Write, A2, True, },
                    {False, Write, A2, False, },
                    {True, Write, A3, True, },
                    {False, Write, A3, False, },
                    {True, Read, __, True, },
                    {False, Read, __, False, },
                },
                {{GDM2, A, D, },
                    {__, A1, __, },
                    {True, A2, True, },
                    {False, A2, False, },
                    {__, A3, __, },
                },
                {{GM2P, C, A, M2},
                    {True, Write, A1, True, },
                    {False, Write, A1, False, },
                    {__, Write, A2, __, },
                    {True, Write, A3, True, },
                    {False, Write, A3, False, },
                    {True, Read, __, True, },
                    {False, Read, __, False, },
                },
                {{GDM3, A, D, },
                    {__, A1, __, },
                    {__, A2, __, },
                    {True, A3, True, },
                    {False, A3, False, },
                },
                {{GM3P, C, A, M3},
                    {True, Write, A1, True, },
                    {False, Write, A1, False, },
                    {True, Write, A2, True, },
                    {False, Write, A2, False, },
                    {__, Write, A3, __, },
                    {True, Read, __, True, },
                    {False, Read, __, False, },
                },

            };
        }
    }
}
