//  BESOM-lab Ver.3
//  Copyright (c) 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//  Author: Yuuji Ichisugi

/*
 * lab.Lab : Immediate mode GUI library for Java 
 */

/*
邱
E  class Lab  static field iϐj͂ȂB
܂ selectableClasses cĂB

E Lab.checkEDT = true; AI[o[wbh傫̂ł̂ false ɂ邱ƁB

EG[bZ[WɂBB

R[fBOK
EʁAׂẴNX class Lab  public static member ƂĒ`B

 */

package lab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;


import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;


public class Lab {
    /**
     * eXgpC[` 
     */
    public static void main(String[] args) {
        System.out.println("Start labLab test program.");
        
        // test
        Lab.addSelectableClass(Test.class);
        //System.out.println(Lab.selectableClasses+ "");
        
        LabCode labCode = new LabCode();
        labCode.main();
    }
    /**
     * AvP[VNɌĂяoR[hB 
     * viewPanel ݒ肵AZN^ftHg MainCode PIсAAsB
     * ̂Ƃ́AZN^I邩 Start {^邽тɁAl̏JԂB
     * 
     * Iɂ́ÃR[h inner code ɂȂ悤ɂB
     */
    public static class LabCode extends Lab.Code {
        public WPanel mainPanel = null;
        public void main(){
            main(null);
        }
        public <T extends MainCode> void main(Class<T> defaultMainCodeClass){
            LabEnv env = new LabEnv();
            mainPanel = new WPanel(env);
            env.viewPanel = new WPanel(env); 

            Lab.invokeAndWait(new FrameInitializer(mainPanel, env.viewPanel));
            
            env.rootPanel = mainPanel;

            // Iɂ Start/Stop ̃gO{^ɂB
            mainPanel.flag(Lab.playbackLabel);
            mainPanel.button(Lab.stopLabel);
            mainPanel.button(Lab.startLabel);

            for (;;){
                int lastRandState = Lab.randState;
                System.out.println("randState="+ lastRandState);
                MainCode currentCode;
                if (defaultMainCodeClass == null){
                    currentCode = mainPanel.getCode("Main:", MainCode.class);
                } else {
                    currentCode = mainPanel.getCode("Main:", MainCode.class, 
                            defaultMainCodeClass);
                }
                //mainPanel.getCode("Main2:", MainCode.class); // test

                env.viewPanel.resetWPanel();
                
                // TO discard current state of Stop button.
                mainPanel.button(Lab.stopLabel);
                try {
                    System.err.println("Start.");
                    currentCode.main();
                    System.err.println("Done.");
                } catch (StopPressed e){
                    System.err.println("Stop button pressed.");
                    // To discard current state of Start button.
                    mainPanel.button(Lab.startLabel);
                }
                
                while (! mainPanel.button(Lab.startLabel)){
                    Lab.sleep(50);
                }
                if (mainPanel.flag(Lab.playbackLabel)){
                    Lab.randState = lastRandState;
                }
            }
        }
        public class FrameInitializer implements Runnable {
            private JFrame frame;
            private WPanel newPanel;
            private WPanel viewPanel;
            public FrameInitializer(WPanel panel, WPanel viewPanel) {
                this.newPanel = panel;
                this.viewPanel = viewPanel;
            }
            public void run() { 
                frame = new JFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

                frame.setSize(1100, 950); // 2022-07-20
                //frame.setSize(1100, 1150);
                //frame.setSize(1800, 1150);
                frame.setTitle("Lab3");
                
                JSplitPane jContentPane = new JSplitPane();
                jContentPane.setResizeWeight(1); // R|[lg̉ςB
                jContentPane.setContinuousLayout(true);
                jContentPane.setDividerLocation(650);
                frame.setContentPane(jContentPane);
                JPanel jPanelLeft = new JPanel();
                JPanel jPanelRight = new JPanel();
                jContentPane.setLeftComponent(jPanelLeft);
                jContentPane.setRightComponent(jPanelRight);

                jPanelRight.setLayout(new BoxLayout(jPanelRight, BoxLayout.Y_AXIS));

                JScrollPane jScrollPaneRight = new JScrollPane();
                jPanelRight.add(jScrollPaneRight);

                jScrollPaneRight.setViewportView(newPanel.jpanel);
                
                jPanelLeft.setLayout(new BoxLayout(jPanelLeft, BoxLayout.Y_AXIS));
                JScrollPane jScrollPaneLeft = new JScrollPane();
                jPanelLeft.add(jScrollPaneLeft);
                jScrollPaneLeft.setViewportView(viewPanel.jpanel);
                
                viewPanel.env.jScrollPane = jScrollPaneLeft;
                
                // frame ׂ̂ẴR|[lg̐ݒ肪IĂA
                frame.setVisible(true);
            }
        }
        public void params() {
        }
    }
    public static int panelColumnWidth = 350;
    public static String startLabel = "                      Start                      ";
    public static String stopLabel = "Stop";
    public static String playbackLabel = "Reuse last rand seed";
    public static class LabEnv {
        /**
         * ԊO̓͗pplB
         */
        public WPanel rootPanel = null;
        /**
         * SR[hʂ̏o͗pplB
         */
        public WPanel viewPanel = null;
        /**
         * o̓pl JScrollPane B
         */
        public JScrollPane jScrollPane;
        public void checkStop(){
            if (rootPanel.button(stopLabel)){
                throw new StopPressed();
            }
        }
        
    }
    public static class StopPressed extends RuntimeException {}
    /**
     * paint() ֘ÃfobObZ[W\tOB
     */
    public static boolean paintDebug = false;
    /**
     * fthĩANZXv\B
     */
    public static boolean useAccessLamp = true;
    /**
     * ݂̃Xbh EDT  EDT KvȌŃ`FbNB
     * true ɂƐxsxȂ邱ƂB 
     */
    public static final boolean checkEDT = true;
        
    /**
     * R[hZN^ɂI\ȃR[hIuWFNgׂC^[tF[XB
     * R[hIuWFNg panel Ƃ field A
     * ɑ΂ setter/getter ĂKvB
     * BUG: ł̓R[hZN^ class Code ̃TuNXɂΉĂȂB
     *   setPanel \bhgĂȂB
     */
    public static interface Selectable {
        public abstract String getCodeExplanation();
        public abstract void setPanel(WPanel panel);
        public abstract WPanel getPanel();
        public abstract void setLab(LabEnv env);
        public abstract LabEnv getLab();
        /**
         * ̃TuR[h̃R[hZN^ǉ邽߂̃\bhB
         * KvȂ΃TuNX override ă[UB
         * ̃\bh́A MainCode IɃt[[N玩IɌĂ΂B
         */
        // p~BƂ肠RgAEg
        //public abstract void initCodeSelectors(){}
        /**
         * 䕔ilǂ݂A Code  field ̒lɐݒ肷郁\bhB
         * ƁA WCodeSelector#getCode ĂяoɃt[[N
         * IɌĂ΂B 
         */
        //public abstract void params();  // p~I
    }
    /**
     * R[hZN^ɂI\ȃR[hIuWFNg̃NXB
     * ʂ̃[ÚÃNXpăR[hIuWFNg̃NX`B
     */
    public static abstract class Code implements Selectable {
        public String getCodeExplanation(){ return null; }
        public void setPanel(WPanel panel) { this.panel = panel; }
        public WPanel getPanel() { return panel; }
        /**
         * ̃R[h̃TuplB
         * ̕ϐ̒l̓t[[NIɐݒ肷B
         */
        public WPanel panel = Lab.getCurrentInnerPanel();
        /*
         * pl panel ܂ރplB
         * ̕ϐ̒l̓t[[NIɐݒ肷B
         * 
         * gĂȂ悤Ȃ̂ō폜B
         */
        public void setLab(LabEnv env){ this.env = env; }
        public LabEnv getLab(){ return env; }
        /**
         * 
         */
        public LabEnv env;
        public void codeSelected(){} // fobOp̃\bhB not used
    }
    /**
     * NɑI\ɂȂR[hB
     * R[hIA Start {^ main() sB
     */
    public static abstract class MainCode extends Code {
        public abstract void main();
    }
    /**
     * dcsŃR[hsB
     * GNZvV Error ɕϊB
     */
    public static void invokeAndWait(final Runnable a){
        try {
            SwingUtilities.invokeAndWait(a);
        } catch (InterruptedException e) {
            e.printStackTrace();
            throw new Error(""+ e);
        } catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new Error(""+ e);
        }
    }
    /**
     *  WPanel ɔzufthi  abstract class B
     * ̃NX̃TuNX`Ƃ́AאS̒ӂ𕥂ƁI
     *      AvP[VXbhfthR|[lg̃\bhĂ΂ȂB
     *      AvP[VXbhƂdcs̊Ԃ̋Lf[^͕KbNB
     * ȂǁB
     *  WComponent ̃TuNX̃\bh́AɃAvP[VXbĥ݂ĂяoB
     * ALf[^ւ̃ANZX͂dcsĂтB̏ꍇ̓bNB
     *  
     */
    public static abstract class WComponent {
        public JComponent jpanel; // ̂fthi̖{
        // ANZXv
        public AccessLamp accessLamp = null;
        public void addAccessLamp(JComponent jpanel){
            addAccessLamp(jpanel, true);
        }
        public void addAccessLamp(JComponent jpanel, boolean useModifyLabel){
            if (Lab.useAccessLamp){
                Lab.checkEDT();
                accessLamp = new AccessLamp(useModifyLabel);
                jpanel.add(accessLamp);
            }
        }
        public void lampReset(){
            Lab.checkNotEDT();
            if (accessLamp != null) Lab.invokeAndWait(doLampReset); 
        }
        public void lampModify(){
            Lab.checkEDT();
            if (accessLamp != null) accessLamp.lampModify();
        }
        public void lampSet(){
            Lab.checkNotEDT();
            if (accessLamp != null) Lab.invokeAndWait(doLampSet);
        }
        public void lampAccess(){
            Lab.checkNotEDT();
            if (accessLamp != null) {
                // łĂق̂ invokeAndWait ͎g킸A
                // synchronized method gB
                accessLamp.lampAccess();
            }
        }
        public Runnable doLampReset = new Runnable(){
            public void run(){ accessLamp.lampReset(); }
        };
        public Runnable doLampSet = new Runnable(){
            public void run(){ accessLamp.lampSet(); }
        };
        public Runnable doLampAccess = new Runnable(){
            public void run(){ accessLamp.lampAccess(); }
        };
    }
    
    /**
     * fthiׂplB
     * pl̓lXgłB 
     */
    public static class WPanel {
        public JComponent jpanel = null;
        public LabEnv env;
        public WPanel(LabEnv env){
            Lab.checkNotEDT();
            this.env = env;
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    jpanel = new JPanel();
                    jpanel.setBorder(new LineBorder(Color.GRAY));
                    jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.Y_AXIS));
                    // ȂHH
                    //Dimension size = new Dimension(Lab.panelColumnWidth, 100);
                    //jpanel.setMinimumSize(size);
                }
            });
        }

        public void resetWPanel(){
            labels = new String[0];
            components = new WComponent[0];
            final JComponent w = this.jpanel;
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    w.removeAll();
                    w.revalidate();
                    w.repaint();
                }
            });
        }
        
        public String[] labels = {};
        public WComponent[] components = {};
        public WComponent findWComponent(String label){
            for (int i = 0; i < labels.length; i++) {
                if (labels[i] == label) return returnFoundWComponent(components[i]);
            }
            label = label.intern();
            for (int i = 0; i < labels.length; i++) {
                if (labels[i] == label) return returnFoundWComponent(components[i]);
            }
            return null;
        }
        public WComponent returnFoundWComponent(WComponent c){
            c.lampAccess();
            return c;
        }
        public synchronized void addWComponent(String label, WComponent c){
            Lab.checkNotEDT();
            label = label.intern();
            for (int i = 0; i < labels.length; i++) {
                if (labels[i] == label) return; // G[ɂׂH
            }
            String[] newLabels = new String[labels.length + 1];
            WComponent[] newComponents = new WComponent[components.length + 1];
            for (int i = 0; i < labels.length; i++) {
               newLabels[i] = labels[i];
               newComponents[i] = components[i];
           }
           newLabels[labels.length] = label;
           newComponents[components.length] = c;
           labels = newLabels;
           components = newComponents;
           Lab.invokeAndWait(new ComponentAdder(this, c.jpanel));

           Lab.invokeAndWait(new Runnable(){
               public void run(){
                   JScrollPane s = env.jScrollPane;
                   JScrollBar bar = s.getVerticalScrollBar();
                   bar.setValue(bar.getMaximum());                   
               }
           });
        }
        public void componentNotFound(String label){
            throw new Error("WPanel: Component \""+ label+ "\" not found.");
        }
        public WPanel[] getMultiPanel(final String label, int num){
            WMultiPanel c = (WMultiPanel)findWComponent(label);
            if (c == null){
                // ȂꍇG[ɂׂH
                c = new WMultiPanel(label, num, this.env);
                addWComponent(label, c);
            }
            return c.panels;
        }
//        public void setFloat(String label, float val){
//            setFloat(label, val, 0, 1.0f);
//        }
//        public void setFloat(String label, float init, float min, float max){
        public void setFloat(String label, float val){
            WFloatSlider c = (WFloatSlider)findWComponent(label);
            if (c == null){
                // ȂꍇG[B
                componentNotFound(label);
//                c = new WFloatSlider(label, init, min, max);
//                addWComponent(label, c);
            }
            c.lampSet();
            c.setFloatValue(val);
        }
        public float getFloat(String label, float init, float min, float max){
            WFloatSlider c = (WFloatSlider)findWComponent(label);
            if (c == null){
                c = new WFloatSlider(label, init, min, max);
                addWComponent(label, c);
                c.setFloatValue(init);
                c.lampReset();
            }
            return c.getFloatValue();
        }
//        public void setInt(String label, int val){
//            setInt(label, val, 0, 100);
//        }
//        public void setInt(String label, int init, int min, int max){
        public void setInt(String label, int val){
            WIntSlider c = (WIntSlider)findWComponent(label);
            if (c == null){
                componentNotFound(label);
//                c = new WIntSlider(label, init, min, max);
//                addWComponent(label, c);
            }
            c.lampSet();
            c.setIntValue(val);
        }
        public int getInt(String label, int init, int min, int max){
            WIntSlider c = (WIntSlider)findWComponent(label);
            if (c == null){
                c = new WIntSlider(label, init, min, max);
                addWComponent(label, c);
                c.setIntValue(init);
            }
            return c.getIntValue();
        }
        public Object getSelectedValue(String label, Object[] values){
            WSelector c = (WSelector)findWComponent(label);
            if (c == null){
                c = new WSelector(label, values);
                addWComponent(label, c);
            }
            return c.getSelectedValue();
        }
        public <T extends Selectable, T2 extends T> T getCode(String label, Class<T> type,
                Class<T2> defaultCode){
            WCodeSelector c = (WCodeSelector)findWComponent(label);
            if (c == null){
                c = new WCodeSelector(label, type, defaultCode, this.env);
                addWComponent(label, c);
            }
            T code = (T)c.getSelectedCode();
            code.setLab(this.env);
            return code;
        }
        public <T extends Selectable> T getCode(String label, Class<T> type){
            return getCode(label, type, null);
        }
//        public boolean getOldButtonValue(String label){
//            WOldButton c = (WOldButton)findWComponent(label);
//            if (c == null){
//                c = new WOldButton(label);
//                addWComponent(label, c);
//            }
//            return c.getButtonValue();
//        }
        public <T extends Selectable, T2 extends T> void setCode(String label, Class<T> type){
            WCodeSelector c = (WCodeSelector)findWComponent(label);
            if (c == null){
                componentNotFound(label);
            }
            c.setCodeValue(type);
            c.lampSet();
        }
        public WPanel getSubpanel(String label){
            WCodeSelector c = (WCodeSelector)findWComponent(label);
            if (c == null){
                componentNotFound(label);
            }
            synchronized (c) {
                return c.itemsCodes[c.selectedIndex].getPanel();
            }
        }
        public void speedControl(String label, int period){
            WSpeedController c = (WSpeedController)findWComponent(label);
            if (c == null){
                c = new WSpeedController(label, period, env);
                addWComponent(label, c);
            }
            c.speedControl();
        }
        public boolean button(String label){
            WButton c = (WButton)findWComponent(label);
            if (c == null){
                c = new WButton(label);
                addWComponent(label, c);
            }
            return c.getButtonValue();
        }
        //public void paint(String label, Painter painter, int period){
        public void paint(String label, Painter painter){
            WCanvas c = (WCanvas)findWComponent(label);
            if (c == null){
                c = new WCanvas(label, painter);
                addWComponent(label, c);
            }
            c.paint(painter, 0);
        }
        public boolean flag(String label){
            return flag(label, false);
        }
        public boolean flag(String label, boolean defaultValue){
            WCheckBox c = (WCheckBox)findWComponent(label);
            if (c == null){
                c = new WCheckBox(label);
                addWComponent(label, c);
                c.setBoolean(defaultValue);
                
            }
            return c.getBoolean();
        }
        public void setFlag(String label, boolean val){
            WCheckBox c = (WCheckBox)findWComponent(label);
            if (c == null){
                componentNotFound(label);
//                c = new WCheckBox(label);
//                addWComponent(label, c);
            }
            c.lampSet();
            c.setBoolean(val);
        }
        public void println(String label, String str){
            WTextArea c = (WTextArea)findWComponent(label);
            if (c == null){
                c = new WTextArea(label);
                addWComponent(label, c);
            }
            c.println(str);
        }
        public void print(String label, String str){
            WTextArea c = (WTextArea)findWComponent(label);
            if (c == null){
                c = new WTextArea(label);
                addWComponent(label, c);
            }
            c.print(str);
        }
        public void setText(String label, String str){
            WTextArea c = (WTextArea)findWComponent(label);
            if (c == null){
                c = new WTextArea(label);
                addWComponent(label, c);
            }
            c.setText(str);
        }
        public void print1(String label, String str){
            WTextField c = (WTextField)findWComponent(label);
            if (c == null){
                c = new WTextField(label);
                addWComponent(label, c);
            }
            c.print1(str);
        }
        //public void paint(String label, float[] vec, int period){
        public void paint(String label, float[] vec){
            WCanvas c = (WCanvas)findWComponent(label);
            if (c == null){
                c = new WCanvas(label, new VecPainter(vec));
                addWComponent(label, c);
            }
            // XXX: ȂB
            VecPainter p = (VecPainter)c.painter;
            p.vec = vec;
            c.paint(p, 0);
        }
        public void plot(String label, float y){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
                c.setAutoXFlag(true);
                c.setGraphType("line");
            }
            c.plot1(y);
        }
        public void plotWithFixedY(String label, float y, float min, float max){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
                c.setAutoXFlag(true);
                c.setGraphType("line");
                c.fixY(min, max);
            }
            c.plot1(y);
        }
        public void linePlot(String label, float x, float y){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.setGraphType("line");
            c.plot(x, y);
        }
        public void scatterPlot(String label, float x, float y){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.setGraphType("scatter");
            c.plot(x, y);
        }
        public void linePlotFixedY(String label, float x, float y, float min, float max){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.fixY(min, max);
            c.setGraphType("line");
            c.plot(x, y);
        }
        public void scatterPlotFixedY(String label, float x, float y, float min, float max){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.fixY(min, max);
            c.setGraphType("scatter");
            c.plot(x, y);
        }
        public void newGraph(String label){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.newGraph();
        }
        public void resetGraphData(String label){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.resetGraphData();
        }
        public void setMaxDataSize(String label, int maxDataSize){
            WGraph c = (WGraph)findWComponent(label);
            if (c == null){
                c = new WGraph(env, label);
                addWComponent(label, c);
            }
            c.setMaxDataSize(maxDataSize);
        }
        
        
        
        public static class ComponentAdder implements Runnable {
            private JComponent w;
            private JComponent c;
            private JScrollPane s;
            public ComponentAdder(WPanel w, JComponent c) {
                this.w = w.jpanel;
                this.c = c;
                this.s = w.env.jScrollPane;
            }
            public void run() {
                c.setAlignmentX(Component.LEFT_ALIGNMENT);
                w.add(c);
                c.revalidate();
                c.repaint();
                w.repaint(); // svHH
            }
        }

    }
    public static class WMultiPanel extends WComponent {
        public String label;
        public WPanel[] panels;
        public WMultiPanel(String label, final int num, LabEnv env){
            this.label = label;
            panels = new WPanel[num];
            for (int i = 0; i < num; i++) {
                panels[i] = new WPanel(env);
            }
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    jpanel = new JPanel();
                    jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
                    for (int i = 0; i < num; i++) {
                        JScrollPane scroll = new JScrollPane();
                        scroll.setPreferredSize(new Dimension(Lab.panelColumnWidth, 100));
                        scroll.setMinimumSize(scroll.getPreferredSize());
                        scroll.setViewportView(panels[i].jpanel);
                        jpanel.add(scroll);
                    }
                }
            });
            
        }
        
    }
    // BUG: modified \ "*" }[NtƃCAEgB
    //  ftHg FlowLayout  BoxLayout ɕςĂ݂܂uB
    public static class AccessLamp extends JPanel {
        public JLabel jlabel;
        public JPanel lamp;
        public javax.swing.Timer timer = null;
        public int accessed = 0;
        public AccessLamp(boolean useModifyLabel){
            Lab.checkEDT();
            //this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
            lamp = new JPanel();
            lamp.setPreferredSize(new Dimension(7, 7));
            lamp.setBorder(new LineBorder(Color.GRAY));
            lamp.setMaximumSize(lamp.getPreferredSize());
            this.add(lamp);
            jlabel = new JLabel();
            lampReset();
            lampAccess();
            jlabel.setMaximumSize(this.getPreferredSize());
            jlabel.setMinimumSize(this.getPreferredSize());
            if (useModifyLabel){
                this.add(jlabel);
            }
            jlabel.setBackground(new Color(0, 255, 0));
            //this.setMaximumSize(this.getPreferredSize()); // svH
            //this.setBorder(new LineBorder(Color.RED)); // for debug
            
            timer = new javax.swing.Timer(100, taskPerformer);
            timer.start();
        }
        public void lampReset(){
            Lab.checkEDT();
            jlabel.setText("   ");
        }
        public void lampModify(){
            Lab.checkEDT();
            jlabel.setText("*");
        }
        public void lampSet(){
            Lab.checkEDT();
            jlabel.setText("+");
            lampAccess();
        }
        public void lampAccess(){
            synchronized (this){
                accessed = colors.length;
            }
        }
        public Color[] colors = new Color[16];
        {
            for (int i = 0; i < colors.length; i++) {
                colors[i] = new Color(0, 255 * i / colors.length, 0);
            }
        }
        public ActionListener taskPerformer = new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                //System.out.println("performed:"+ this);
                Color color;
                synchronized (AccessLamp.this){
                   if (accessed <= 0) return;
                   accessed--;
                   color = colors[accessed];
                }
                lamp.setBackground(color);
            }
        };
    }
    
    public static class WFloatSlider extends WComponent {
        public JLabel tlabel;
        public JTextField tval;
        public JSlider slider;
        // ActionListener  ENTER L[ꂽƂCxg󂯎B
        public ActionListener floatActionListner = new ActionListener(){
            public void actionPerformed(ActionEvent arg0) {
                float val;
                try {
                  val = Float.parseFloat(tval.getText());
                } catch (NumberFormatException e){
                    val = minValue;
                }
                WFloatSlider.this.setValueFromTextField(val);
            }
        };
        public DocumentListener floatTextListner = new DocumentListener(){
            @Override
            public void changedUpdate(DocumentEvent e) {
            }
            @Override
            public void insertUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("insert");
            }
            @Override
            public void removeUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("remove");
            }
        };
        public ChangeListener sliderChangeListener = new ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent e) {
                //System.out.println("Changed!"+ slider.getValue());
                setValueFromSlider(slider.getValue());
            }
        };
        
        public WFloatSlider(final String label,
                  final float init, final float min, final float max){
            this.minValue = min;
            this.maxValue = max;
            this.floatValue = init; 
              
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            tlabel = new JLabel(label);
            tlabel.setHorizontalAlignment(JLabel.RIGHT);
            tlabel.setToolTipText(label);
            tlabel.setPreferredSize(new java.awt.Dimension(80,20));

            tval = new JTextField();
            tval.setToolTipText("Type ENTER to change the value.");
            java.awt.Dimension tvalSize = new java.awt.Dimension(50,20);
            tval.setPreferredSize(tvalSize);
            tval.setMaximumSize(tvalSize);
            tval.addActionListener(floatActionListner);
            tval.getDocument().addDocumentListener(floatTextListner);

            slider = new JSlider();
            
            slider.setMinimum(0);
            slider.setMaximum(100); // ߂
            
            slider.setPaintLabels(true);
            Hashtable labelTable = new Hashtable();
            labelTable.put( new Integer( 0 ), new JLabel(""+ min) );
            labelTable.put( new Integer( 50 ), new JLabel(""+ (min+max)/2 ));
            labelTable.put( new Integer( 100 ), new JLabel(""+ max) );
            slider.setLabelTable( labelTable );

            slider.addChangeListener(sliderChangeListener);

            jpanel = new JPanel(); // ftHg FlowLayout
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(tlabel);
            jpanel.add(slider);
            jpanel.add(tval);

            Dimension d = jpanel.getPreferredSize();
            // ꂪȂƁA㉺TCY߂ςLĂ܂B
            jpanel.setMaximumSize(new Dimension(d.width, d.height));
                }
            });
        }
        float floatValue;
        float minValue;
        float maxValue;

        public void adjustJTextFieldVal(){
            Lab.checkEDT();
            tval.setText(""+ floatValue);
            tval.setCaretPosition(0);
            tval.setBackground(Color.WHITE);
        }
        // XC_̃nh setFloatValueFromEDT ĂсA
        // floatValue ̒l JTextField ̒lςĂ܂Ȃ悤ɁA
        // ChangeListener ꎞ remove ĂlςB
        public void adjustSliderValue(float x){
            Lab.checkEDT();
            int intVal = (int)((x - minValue) * 100 / (maxValue - minValue));
            if (minValue <= x && x <= maxValue){
                slider.setEnabled(true);
                slider.removeChangeListener(sliderChangeListener);
                slider.setValue(intVal);
                slider.addChangeListener(sliderChangeListener);
            } else {
                slider.setEnabled(false);
            }
        }
        // EDT ŎsB
        public synchronized void setValueFromSlider(int intVal){
            Lab.checkEDT();
            this.lampModify();
            floatValue = (intVal / 100.0f) * (maxValue - minValue) + minValue;
            adjustJTextFieldVal();
        }
        // EDT ŎsB
        public synchronized void setValueFromTextField(float x){
            Lab.checkEDT();
            this.lampModify();
            adjustSliderValue(x);
            floatValue = x;
            adjustJTextFieldVal();
        }
        // EDT ŎsB
        public synchronized void setFloatValueFromCode(float x){
            Lab.checkEDT();
            adjustSliderValue(x);
            floatValue = x;
            adjustJTextFieldVal();
        }
        public void setFloatValue(final float x) {
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    setFloatValueFromCode(x);
                }
            });
        }
        public synchronized float getFloatValue(){
            return floatValue;
        }
    }
    // 啔 WFloatSlider ̃Rs[B
    public static class WIntSlider extends WComponent {
        public JLabel tlabel;
        public JTextField tval;
        public JSlider slider;
        public ActionListener intActionListner = new ActionListener(){
            public void actionPerformed(ActionEvent arg0) {
                int val;
                try {
                  val = Integer.parseInt(tval.getText());
                } catch (NumberFormatException e){
                    val = minValue;
                }
                WIntSlider.this.setValueFromTextField(val);
            }
        };
        public DocumentListener intTextListner = new DocumentListener(){
            @Override
            public void changedUpdate(DocumentEvent e) {
            }
            @Override
            public void insertUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("insert");
            }
            @Override
            public void removeUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("remove");
            }
        };
        public ChangeListener sliderChangeListener = new ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent e) {
                //System.out.println("Changed!"+ slider.getValue());
                setValueFromSlider(slider.getValue());
            }
        };
                
        public WIntSlider(final String label,
                  final int init, final int min, final int max){
            this.minValue = min;
            this.maxValue = max;
            this.intValue = init; 
              
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            tlabel = new JLabel(label);
            tlabel.setHorizontalAlignment(JLabel.RIGHT);
            tlabel.setToolTipText(label);
            tlabel.setPreferredSize(new java.awt.Dimension(80,20));

            tval = new JTextField();
            tval.setToolTipText("Type ENTER to change the value.");
            java.awt.Dimension tvalSize = new java.awt.Dimension(50,20);
            tval.setPreferredSize(tvalSize);
            tval.setMaximumSize(tvalSize);
            tval.addActionListener(intActionListner);
            tval.getDocument().addDocumentListener(intTextListner);

            slider = new JSlider();
            
            slider.setMinimum(min);
            slider.setMaximum(max);
            
            slider.setPaintLabels(true);
            Hashtable labelTable = new Hashtable();
            labelTable.put( new Integer( min ), new JLabel(""+ min) );
            labelTable.put( new Integer( (min+max)/2 ), new JLabel(""+ (min+max)/2 ));
            labelTable.put( new Integer( max ), new JLabel(""+ max) );
            slider.setLabelTable( labelTable );


            slider.addChangeListener(sliderChangeListener);

            jpanel = new JPanel(); // ftHg FlowLayout
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(tlabel);
            jpanel.add(slider);
            jpanel.add(tval);

            Dimension d = jpanel.getPreferredSize();
            // ꂪȂƁA㉺TCY߂ςLĂ܂B
            jpanel.setMaximumSize(new Dimension(d.width, d.height));
                }
            });
        }
        int intValue;
        int minValue;
        int maxValue;

        public void adjustJTextFieldVal(){
            Lab.checkEDT();
            tval.setText(""+ intValue);
            tval.setCaretPosition(0);
            tval.setBackground(Color.WHITE);
        }
        public void adjustSliderValue(int x){
            Lab.checkEDT();
            if (minValue <= x && x <= maxValue){
                slider.setEnabled(true);
                slider.removeChangeListener(sliderChangeListener);
                slider.setValue(x);
                slider.addChangeListener(sliderChangeListener);
            } else {
                slider.setEnabled(false);
            }
        }
        // EDT ŎsB
        public synchronized void setValueFromSlider(int intVal){
            Lab.checkEDT();
            this.lampModify();
            this.intValue = intVal;
            adjustJTextFieldVal();
        }
        // EDT ŎsB
        public synchronized void setValueFromTextField(int x){
            Lab.checkEDT();
            this.lampModify();
            adjustSliderValue(x);
            this.intValue = x;
            adjustJTextFieldVal();
        }
        // EDT ŎsB
        public synchronized void setintValueFromCode(int x){
            Lab.checkEDT();
            adjustSliderValue(x);
            intValue = x;
            adjustJTextFieldVal();
        }
        public void setIntValue(final int x) {
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    setintValueFromCode(x);
                }
            });
        }
        public synchronized int getIntValue(){
            return intValue;
        }
    }
    public static class WSelector extends WComponent {
        public JLabel jlabel;
        public JComboBox selector;
        public Object selectedValue;
        
        public WSelector(final String label, final Object[] values){
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            jlabel = new JLabel();
            jlabel.setText(label);

            selector = new JComboBox();
            for (int i = 0; i < values.length; i++) {
                selector.addItem(values[i]);
            }
            selector.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    synchronized(WSelector.this){
                        WSelector.this.lampModify();
                        selectedValue = selector.getSelectedItem();
                    }
                }
            });
            synchronized(WSelector.this){
                selectedValue = selector.getSelectedItem();
            }
            selector.setMaximumSize(selector.getPreferredSize());

            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(jlabel);
            jpanel.add(selector);
            //jpanel.add(Box.createGlue()); // sv
            jpanel.setMaximumSize(jpanel.getPreferredSize());

//            FlowLayout flowLayout = new FlowLayout();
//            //flowLayout.setAlignment(java.awt.FlowLayout.RIGHT);
//            flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
//            jpanel.setLayout(flowLayout);

//            Dimension d = jpanel.getPreferredSize();
//            jpanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, d.height));
                }
            });
        }
        public synchronized Object getSelectedValue(){
            return selectedValue;
        }
    }
    /**
     * TODO: ݂̎ł̓R[h̃lXg̐[ n ɑ΂ O(2^n) ̃pl
     * ŏɍsĂ܂B
     *  ̖ɂ́A inner panel ̐ZN^؂ւ
     * lazy ɍs΂悢̂AZN^؂ւ̃nh͂dcsŎsA
     * inner panel ̐̓AvP[VXbhŎsȂ΂ȂȂ̂ŁA
     * BȂ̂ŁA̖͓ʕuBlXg̐[[ȂΑ傫Ȗ͂ȂB
     */
    public static class WCodeSelector extends WComponent {
        public JPanel selectorPanel;
        public JLabel jlabel;
        public JComboBox selector;
        public JPanel innerPanels;
        public int selectedIndex = -1; // Used from getSubpanel

        public <T extends Selectable, T2 extends T> 
        WCodeSelector(String label, Class<T> type, Class<T2> defaultCode, LabEnv env){
            this(label, WCodeSelector.candidateClasses(type, defaultCode), env);
        }
        public <T extends Selectable> 
         WCodeSelector(final String label, Class<T>[] classes, LabEnv env){

          setItemsCodes(classes, env);

            // ܊֌W
            //       jpanel
            //            selectorPanel
            //                jlabel
            //                selector
            //            innerPanels
            //                JIndentedWPanel
            //                ...

            Lab.invokeAndWait(new Runnable(){
                public void run(){
            jlabel = new JLabel();
            jlabel.setText(label);

            selector = new JComboBox();

            selectorPanel = new JPanel();
            addAccessLamp(selectorPanel);
            selectorPanel.add(jlabel, null);
            selectorPanel.add(selector, null);

            FlowLayout flowLayout = new FlowLayout();
            //flowLayout.setAlignment(java.awt.FlowLayout.RIGHT);
            flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
            selectorPanel.setLayout(flowLayout);
            //selectorPanel.setLayout(new BoxLayout(selectorPanel, BoxLayout.X_AXIS));

            Dimension d = selectorPanel.getPreferredSize();
            selectorPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, d.height));
            
            innerPanels = new JPanel();
            innerPanels.setLayout(new BoxLayout(innerPanels, BoxLayout.Y_AXIS));
            
            setItemsPanels(innerPanels);
                        
            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.Y_AXIS));
            
            jpanel.add(selectorPanel);
            jpanel.add(innerPanels);
            jpanel.setBorder(new LineBorder(Color.GRAY));
            selector.addActionListener(selectorActionListener);
                }
            });
        }
        public ActionListener selectorActionListener = new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                //System.out.println("ActionEvent:"+ e);
                WCodeSelector.this.lampModify();
                int index = selector.getSelectedIndex();
                JPanel p = itemsPanels[index];
                
                synchronized(WCodeSelector.this){
                    if (selectedIndex != -1) itemsPanels[selectedIndex].setVisible(false);
                    p.setVisible(true);
                    p.revalidate(); 
                    p.repaint();
                    selectedIndex = index; // L̈ւ̏݁B
                }
            }
        };
        public static <T extends Selectable, T2 extends T> Class<T>[]
         candidateClasses(Class<T> type, Class<T2> defaultCode){
            Class[] vec = candidateClasses1(type);
            if (defaultCode == null) return vec;
            Class[] newVec = new Class[vec.length + 1];
            // 擪ɗvfPǉB
            newVec[0] = defaultCode;
            for (int i = 0; i < vec.length; i++) {
                newVec[i+1] = vec[i]; 
            }
            return newVec;
        }
        public static <T extends Selectable> Class<T>[]
            candidateClasses1(Class<T> type){
            Lab.checkNotEDT();
            Vector<Class<T>> vec = new Vector<Class<T>>();
            for (Class<?> c : Lab.selectableClasses){
                if (type.isAssignableFrom(c)
                        && isInstantiatable(c)){
                    vec.add((Class<T>)c);
                }
            }
            // selectableClasses Ɍォǉꂽ̂ZN^̏ɂ悤ɋtɂB
            // oNX͖Oɒǉ̂ŁAZN^ɂ͖ŐtŏoB
            // NXɓtĂꍇ́At̐V̂ɂ邱ƂɂȂB
            java.util.Collections.reverse(vec);
            if (vec.size() == 0){
                throw new Error("getCode: No Code matched to the specified type: "
                        + type);
            }
            Class[] a = new Class[vec.size()];
            //System.out.println("vec="+ vec);
            vec.toArray(a);
            return a;
        }

        public String[] itemsExplanations;
        public Selectable[] itemsCodes;
        public JPanel[] itemsPanels;
        public <T extends Selectable> 
                    void setItemsCodes(Class<T>[] classes, LabEnv env){
            Lab.checkNotEDT();
            Vector<Selectable> objs = new Vector<Selectable>();
            for (Class c : classes) {
                if (isInstantiatable(c)){
                    objs.add(newCodeObject(c, new WPanel(env)));
                }
            }
            itemsExplanations = new String[objs.size()];
            itemsCodes = new Selectable[objs.size()];
            itemsPanels = new JPanel[objs.size()];
            for (int i = 0; i < objs.size(); i++) {
                Selectable code = objs.get(i);
                itemsCodes[i] = code;
                String expl = code.getCodeExplanation();
                if (expl == null){
                    Class c = code.getClass();
                    expl = c.getName();
                }
                itemsExplanations[i] = expl;
                //Lab.setPanelToNewCode(code, new WPanel(lab));
                //code.setPanel(new WPanel(lab));
                //code.params();
            }
            if (itemsCodes.length < 1){
                String s = "";
                for (Class c : classes) {
                    s += c.getName() + " ";
                }
                throw new Error("getCode: No candidate found: "+ s);
            }
            //Lab.assertTrue(itemsCodes.length >= 1);
            synchronized (this) {
                selectedIndex = 0;
            }
        }
        public static boolean isInstantiatable(Class c){
            if (c.isInterface()) return false;
            return ! java.lang.reflect.Modifier.isAbstract(c.getModifiers());
        }
        // EDT sB
        public void setItemsPanels(final JPanel innerPanels){
            Lab.checkEDT();
            for (int i = 0; i < itemsPanels.length; i++) {
                JComponent jpanel = itemsCodes[i].getPanel().jpanel;
                JIndentedWPanel innerPanel = new JIndentedWPanel(jpanel);
                itemsPanels[i] = innerPanel;
            }
            //selector.removeAllItems();
            for (int i = 0; i < itemsPanels.length; i++) {
               itemsPanels[i].setVisible(false);
               selector.addItem(itemsExplanations[i]);
               innerPanels.add(itemsPanels[i]);
            }
            // ftHgőIĂplŏ猩悤ɂĂB
            itemsPanels[0].setVisible(true);
        }
        
        public static Selectable newCodeObject(Class c, WPanel panel){
            if (Lab.printNewCodeMessage){
                System.out.println("New code instance: "+ c.getName());
            }
            try {
                Lab.threadLocalCurrentPanel.set(panel);
                return (Selectable)c.newInstance();
            } catch (InstantiationException e) {
                e.printStackTrace();
                throw new Error(""+ e);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new Error(""+ e);
            } finally {
                Lab.threadLocalCurrentPanel.set(null);
            }
        }
        public synchronized Object getSelectedCode(){
            int index = selector.getSelectedIndex();
            Selectable code = itemsCodes[index];
            Selectable newCode = newCodeObject(code.getClass(), code.getPanel());
            //newCode.setPanel(code.getPanel());
            //newCode.params();
            return newCode;
        }
        public <T extends Selectable> void setCodeValue(final Class<T> type){
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    setValueFromCode(type);
                }
            });
        }
        // BUG: type.getCodeExplanation() ɂ͖ΉB
        public synchronized <T extends Selectable> void setValueFromCode(Class<T> type){
            Lab.checkEDT();
            String name = type.getName();
            int index = -1;
            found: {
                for (int i = 0; i < itemsExplanations.length; i++) {
                    if (itemsExplanations[i].equals(name)) {
                        index = i;
                        break found;
                    }
                }
                throw new Error("setCode: item named \""+ name+ "\" not found in the code selector.");
            }
            selector.setSelectedIndex(index);
        }
    }
    /**
     * true ɂƁAR[hIuWFNg̃CX^X邽тɃbZ[WóB
     */
    public static boolean printNewCodeMessage = true;
    // R[hIuWFNg̕ϐ panel ̏ɎglꏊB
    // ̃}`XbhlA ThreadLocal gB
    public static ThreadLocal<WPanel> threadLocalCurrentPanel = new ThreadLocal<WPanel>();
    public static WPanel getCurrentInnerPanel(){
        return Lab.threadLocalCurrentPanel.get();
    }
    public static class JIndentedWPanel extends JPanel {
        /*
         * ܊֌WF
         *         this
         *             placeHolder
         *             indent
         *             innerPanel
         */
        public JIndentedWPanel(final JComponent innerPanel){
            Lab.checkEDT();
            JPanel placeHolder = new JPanel();
            Dimension placeHolderSize = new Dimension(2,2);
            placeHolder.setMinimumSize(placeHolderSize);
            placeHolder.setPreferredSize(placeHolderSize);
            placeHolder.setMaximumSize(placeHolderSize);
            //placeHolder.setBorder(new LineBorder(Color.GRAY)); // for debug
            JButton indent = new JButton();
            JIndentedWPanel.this.setLayout(new BoxLayout(JIndentedWPanel.this, BoxLayout.X_AXIS));
            indent.setPreferredSize(new java.awt.Dimension(10,15));
            indent.setMaximumSize(indent.getPreferredSize());
            //indentPanel.setBackground(Color.RED); // for debug
            indent.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    JComponent c = innerPanel; 
                    if (c.isVisible()){
                        c.setVisible(false);
                    } else {
                        c.setVisible(true);
                    }
                    c.revalidate(); c.repaint();
                }
            });

            this.add(placeHolder);
            this.add(indent);
            this.add(innerPanel);
            innerPanel.setBorder(new LineBorder(Color.GRAY));
            
            // l߂ɂȂ悤ɁB
            JIndentedWPanel.this.add(Box.createHorizontalGlue());
        }
    }
    
//    public static class WOldButton extends WComponent {
//        public JButton button;
//        public boolean flag;
//        
//        public WOldButton(final String label){
//            Lab.invokeAndWait(new Runnable(){
//                public void run(){
//            button = new JButton(label);
//            button.addActionListener(new java.awt.event.ActionListener() {
//                public void actionPerformed(java.awt.event.ActionEvent e) {
//                    synchronized (WOldButton.this){
//                        flag = true;
//                    }
//                }
//            });
//                    
//            jpanel = new JPanel();
//            jpanel.add(button, null);
//
//            Dimension d = jpanel.getPreferredSize();
//            jpanel.setMaximumSize(new Dimension(d.width, d.height));
//                }
//            });
//        }
//
//       public boolean getButtonValue() {
//           synchronized (this){
//               if (flag == false) return false;
//               flag = false;
//               return true;
//           }
//       }
//    }
    public static class WSpeedController extends WComponent {
        public JButton pauseButton;
        public JButton stepButton;
        public boolean pause = false;
        public boolean step = false;
        public String pauseLabel =   " Pause  ";
        public String restartLabel = "Resume";
        public int period;
        public JTextField tval;
//        public java.util.Timer timer;
//        public int time = 0;
        public long previousTime = 0;
        public LabEnv env;
        
        public WSpeedController(final String label, final int period, 
                LabEnv env){
            this.period = period;
            this.env = env;
            Lab.invokeAndWait(new Runnable(){
                public void run(){
                    
            JLabel jlabel = new JLabel(label);

            pauseButton = new JButton(pauseLabel);
            pauseButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    synchronized (WSpeedController.this){
                        if (pause){
                            pause = false;
                            pauseButton.setText(pauseLabel);
                            stepButton.setEnabled(false);
                        } else {
                            pause = true;
                            pauseButton.setText(restartLabel);
                            stepButton.setEnabled(true);
                        }
                    }
                }
            });

            stepButton = new JButton("Step");
            stepButton.setEnabled(false);
            stepButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    //System.out.println("JToggleButton: actionPerformed");
                    synchronized (WSpeedController.this){
                        step = true;
                    }
                }
            });

            tval = new JTextField();
            tval.setToolTipText("Type ENTER to change the value.");
            java.awt.Dimension tvalSize = new java.awt.Dimension(50,20);
            tval.setText(""+ period);
            tval.setPreferredSize(tvalSize);
            tval.setMaximumSize(tvalSize);
            tval.addActionListener(periodActionListner);
            tval.getDocument().addDocumentListener(periodTextListner);

            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(jlabel);
            jpanel.add(pauseButton);
            jpanel.add(new JLabel(" "));
            jpanel.add(stepButton);
            jpanel.add(new JLabel("   period(msec)"));
            jpanel.add(tval);
            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
        }
        // ActionListener  ENTER L[ꂽƂCxg󂯎B
        public ActionListener periodActionListner = new ActionListener(){
            public void actionPerformed(ActionEvent arg0) {
                int val;
                try {
                    val = Integer.parseInt(tval.getText());
                } catch (NumberFormatException e){
                    val = 100;
                }
                WSpeedController.this.setValueFromTextField(val);
            }
        };
        public DocumentListener periodTextListner = new DocumentListener(){
            @Override
            public void changedUpdate(DocumentEvent e) {
            }
            @Override
            public void insertUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("insert");
            }
            @Override
            public void removeUpdate(DocumentEvent e) {
                tval.setBackground(Color.ORANGE);
                //System.out.println("remove");
            }
        };
        public synchronized void setValueFromTextField(int val){
            Lab.checkEDT();
            period = val;
            tval.setText(""+ period);
            tval.setCaretPosition(0);
            tval.setBackground(Color.WHITE);
        }

        public void speedControl(){
            env.checkStop();
            boolean oldPause;
            int oldPeriod;
            synchronized (this) { 
                oldPause = pause;
                oldPeriod = period;
            }
            if (oldPause){
                while (true){
                    synchronized (this) { 
                        if (!pause) {
                            previousTime = System.currentTimeMillis();
                            return;
                        }
                        if (step){
                            step = false;
                            return;
                        }
                    }
                    env.checkStop();
                    this.lampAccess();
                    Lab.sleep(100); 
                }
            } else {
                if (oldPeriod <= 0) return;
                // ^C}[҂B
                while (true){
                    synchronized (this) { 
                        oldPause = pause;
                        oldPeriod = period;
                    }
                    if (oldPause) { speedControl(); return; }
                    long currentTime = System.currentTimeMillis();
                    if (currentTime >= previousTime + oldPeriod * 2){
                        // R}B
                    }
                    if (currentTime >= previousTime + oldPeriod){
                        previousTime = currentTime;
                        return;
                    }
                    env.checkStop();
                    this.lampAccess();
                    Lab.sleep(10); // Œ 10msec ͑҂B
                }
            }
       }
    }    
    public static class WButton extends WComponent {
        public JToggleButton button;
        public boolean flag;
        
        public WButton(final String label){
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            button = new JToggleButton(label);
            button.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    //System.out.println("JToggleButton: actionPerformed");
                    synchronized (WButton.this){
                        flag = button.isSelected();
                    }
                }
            });
            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(button);
            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
        }

       public synchronized boolean getButtonValue() {
           boolean oldValue = flag;
           if (flag){
               flag = false;
               // ĂяoAvP[VXbhɂ߂悤ɁA
               // ł invokeLater gB
               SwingUtilities.invokeLater(new Runnable(){
                  public void run(){
                      //System.out.println("getButtonValue: invokeLater");
                      // ւ񂾃{^ɖ߂B
                      // ̎ actionPerformed Cxg͔ȂB
                      button.setSelected(false);
                  }
               });
           }
           return oldValue;
       }
    }    
    public static class WCheckBox extends WComponent {
        public JCheckBox button;
        //public JPanel panel;
        public boolean flag;
        
        public WCheckBox(final String label){
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            button = new JCheckBox(label);
            button.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    //System.out.println("JToggleButton: actionPerformed");
                    synchronized (WCheckBox.this){
                        WCheckBox.this.lampModify();
                        flag = button.isSelected();
                    }
                }
            });
            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            addAccessLamp(jpanel);
            jpanel.add(button);
            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
        }

       public synchronized boolean getBoolean() {
           return flag;
       }
       public synchronized void setBoolean (final boolean val){
           flag = val;
           SwingUtilities.invokeLater(new Runnable(){
               public void run(){
                   button.setSelected(val);
               }
            });
       }
    }
    public static class WTextArea extends WComponent {
        public JTextArea textArea;
        public JScrollPane scrollPane;
        public JScrollBar verticalScrollBar;
        public String label;
        
        public WTextArea(LabEnv env, String label){
            this(label);
            env.viewPanel.addWComponent(label, this);
        }
        public WTextArea(final String label){
            this.label = label;
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            textArea = new JTextArea(10, 85);
            textArea.setFont(new java.awt.Font(java.awt.Font.MONOSPACED,
                    java.awt.Font.PLAIN, 12));
            scrollPane = new JScrollPane(textArea);
            scrollPane.setBorder(new TitledBorder(label));
            verticalScrollBar = scrollPane.getVerticalScrollBar();
            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            
            addAccessLamp(jpanel, false);
            jpanel.add(scrollPane);
            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
        }
        // JTextArea  append, setText  thread safe Ȃ̂ŃbNsvB
        public void println(final String str) {
            this.lampAccess();
            textArea.append(str);
            textArea.append(System.getProperty("line.separator"));
            textArea.setCaretPosition(textArea.getText().length());
        }
        public void print(final String str) {
            this.lampAccess();
            textArea.append(str);
        }
        public void setText(final String str) {
            this.lampAccess();
            textArea.setText(str);
        }
        public void setSize(final int rows, final int columns){
            Lab.invokeAndWait(new Runnable(){
               public void run(){
                   //textArea.setRows(rows);
                   //textArea.setColumns(columns);

                   // 蒼B
                   JTextArea oldTextArea = textArea;
                   jpanel.remove(scrollPane);
                   textArea = new JTextArea(rows, columns);
//                   textArea.setFont(new java.awt.Font(java.awt.Font.MONOSPACED,
//                           java.awt.Font.PLAIN, 12));
                   textArea.setFont(oldTextArea.getFont());
                   scrollPane = new JScrollPane(textArea);
                   scrollPane.setBorder(new TitledBorder(label));
                   jpanel.add(scrollPane);
                   jpanel.setMaximumSize(jpanel.getPreferredSize());
                   jpanel.revalidate();
               }
            });
        }
        public void setFontSize(final int s){
            Lab.invokeAndWait(new Runnable(){
               public void run(){
                   textArea.setFont(new java.awt.Font(java.awt.Font.MONOSPACED,
                           java.awt.Font.PLAIN, s));
               }
            });
        }

    }
    public static class WTextField extends WComponent {
        public JTextField textArea;
        
        public WTextField(final String label){
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            textArea = new JTextField(85);
            textArea.setFont(new java.awt.Font(java.awt.Font.MONOSPACED,
                    java.awt.Font.PLAIN, 12));
            textArea.setMaximumSize(textArea.getPreferredSize());
            jpanel = new JPanel();
            jpanel.setBorder(new LineBorder(Color.GRAY));
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            
            addAccessLamp(jpanel, false);
            jpanel.add(new JLabel(label));
            jpanel.add(textArea);
            
            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
        }
        // JTextField  thread safe Ȃ̂ŃbNsvB
        public void print1(final String str) {
            textArea.setText(str);
        }
    }
    /**
     */
    public static class WCanvas extends WComponent {
        public JTextArea textArea;
        public JLabCanvas jLabCanvas;
        public Dimension canvasSize;
        public JScrollPane scrollPane;
        public JScrollBar verticalScrollBar;
        public Painter painter;
        public MouseEvent lastEvent = null;
        
        Graphics offScreen = null;
        Image image = null;

        public WCanvas(final String label, final Painter painter){
            this.painter = painter;

            Lab.invokeAndWait(new Runnable(){
                public void run(){
            jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, BoxLayout.X_AXIS));
            jpanel.setBorder(new TitledBorder(label));
            addAccessLamp(jpanel, false);

            canvasSize = painter.getSize();
            jLabCanvas = new JLabCanvas(WCanvas.this);
            jLabCanvas.setPreferredSize(canvasSize);
            jLabCanvas.setBackground(java.awt.Color.white);
            jLabCanvas.addMouseListener(new java.awt.event.MouseAdapter (){
                public void mouseClicked(MouseEvent e) {
                    synchronized (WCanvas.this){
                        lastEvent = e;
                    }
                }
            });
            jLabCanvas.addMouseMotionListener(new java.awt.event.MouseMotionListener(){
                public void mouseDragged(MouseEvent e) {
                    updateLastEvent(e);
                }
                public void mouseMoved(MouseEvent e) {
                    updateLastEvent(e);
                }
                void updateLastEvent(MouseEvent e) {
                    synchronized (WCanvas.this){
                        if (lastEvent == null ||
                                lastEvent.getID() != MouseEvent.MOUSE_CLICKED){
                            lastEvent = e;
                        }
                    }
                }
            });
            jpanel.add(jLabCanvas);

//            JPanel placeHolder = new JPanel();
//            placeHolder.setPreferredSize(new java.awt.Dimension(10,10));
//            jpanel.add(placeHolder);
//            
//            textArea = new JTextArea(5, 10);
//            scrollPane = new JScrollPane(textArea);
//            verticalScrollBar = scrollPane.getVerticalScrollBar();
//            jpanel.add(scrollPane, null);

            Dimension d = jpanel.getPreferredSize();
            jpanel.setMaximumSize(new Dimension(d.width, d.height));
                }
            });
            
        }
        /**
         *  image ̒gXVB
         *  AO paint  period msec o߂ĂȂΉȂB
         *  period = 0 ̂Ƃ͂ɍXVB
         *  XVꂽ image ͋߂Ȃ炸ʂɕ\B
         *  TODO:  period ̎dlɂĂ͌\B
         *   o͕iƂɎw肷̂ł͂ȂO[oɎw肵֗H
         *  iႦfXbhG[NĂAfthĂȂ΁A
         *  Ō paint() e\͂Bj
         */
        public void paint(Painter painter, int period){
            Lab.checkNotEDT();
            if (Lab.paintDebug){
                System.out.println("paint called: this="+ this+ ", " +
                        "offScreen="+ offScreen);
            }
            long currentTime = System.currentTimeMillis();
            if (period > 0){
                if (previousTime + period > currentTime) return;
            }
            previousTime = currentTime;
            
            if (offScreen == null){
                Lab.invokeAndWait(new Runnable(){
                    public void run(){
                        synchronized (this){
                            image = jLabCanvas.createImage(canvasSize.width, canvasSize.height);
                        }
                    }
                });
                if (image != null){
                    offScreen = image.getGraphics();
                }
            }
            if (offScreen != null){
                // ʂ̃NA
                offScreen.setColor(Color.WHITE); // wiF߂
                offScreen.fillRect(0, 0, canvasSize.width, canvasSize.height);
                offScreen.setColor(Color.BLACK);
                if (Lab.paintDebug){
                    System.out.println("Invoking paintComponent(offScreen)");
                }
                try {
                    // `r image   JLabCanvas gȂ悤ɃbNB
                    // iA`撆ɃG[NȀuԂ̏Ԃ`Bj
                    synchronized (this) {
                        painter.paintComponent(offScreen, lastEvent);
                        lastEvent = null;
                    }
                } finally {
                    // repaint  thread safe B
                    jLabCanvas.repaint();
                }
            }
        }
        public long previousTime = System.currentTimeMillis();
   }
    // 
    public static class JLabCanvas extends JPanel {
        WCanvas wcanvas;
        public JLabCanvas(WCanvas wcanvas){
            this.wcanvas = wcanvas;
        }
        public void paintComponent(Graphics g){
            super.paintComponent(g);
            Lab.checkEDT();
            if (Lab.paintDebug){
                System.out.println("paintComponent called: this="+ this);
            }
            // ItXN[  g ɕ`B
            synchronized (wcanvas){
                g.drawImage(wcanvas.image, 0, 0, this);
            }
        }
    }
    /**
     * [U͂̃NXpĕ`惋[`B
     * paintComponent ͂dcsł͂Ȃf̃XbhŝŁA
     * r̕Kv͂ȂB
     */ 
    public static interface Painter {
        public abstract Dimension getSize();
        public abstract void paintComponent(Graphics g, MouseEvent lastEvent);
    }
    
    // TODO: TƂɋ؂Ȃǂđ傫Ȕz₷B
    // TODO: dzł悤ɂB
    // TODO: TCY̓IȕωɂΉł悤ɂH
    public static class VecPainter implements Painter {
        public int pSize = 4;  // Pvf pSize x pSize ̐`ŏB
        public int xPixels = 200;
        public int yPixels = pSize * 3;
        public float[] vec;
        public VecPainter(float[] vec){
            this.vec = vec;
            xPixels = (vec.length + 1) * 2 * pSize;
        }
        public Dimension getSize() {
            return new Dimension(xPixels, yPixels);
        }
        public void paintComponent(Graphics g, MouseEvent lastEvent){
            if (vec == null) return;
            for (int i = 0; i < vec.length; i++) {
                g.setColor(Lab.toGrayColor(0.3f));
                g.drawRect(4 + i*2*pSize-1, pSize-1, pSize+1, pSize+1);
                g.setColor(Lab.toGrayColor(vec[i]));
                g.fillRect(4 + i*2*pSize, pSize, pSize, pSize);
           }
            //g.drawRect(posX(xVec[0])-1, posY(yVec[0])-1, 2, 2);
        }
   }

    public static class WGraph extends WCanvas {
        public JTextArea textArea;
        public JScrollPane scrollPane;
        public JScrollBar verticalScrollBar;
        public WPanel viewPanel;
        public String label;
        public boolean autoXFlag = false;
        public int autoX = 0;
        
        public WGraph(LabEnv env, String label){
            super(label, new GraphPainter());
            this.viewPanel = env.viewPanel;
            this.label = label;
            
            Lab.invokeAndWait(new Runnable(){
                public void run(){
            JPanel placeHolder = new JPanel();
            placeHolder.setPreferredSize(new java.awt.Dimension(10,10));
            jpanel.add(placeHolder);
            
            textArea = new JTextArea(5, 15);
            textArea.setTabSize(4);
            scrollPane = new JScrollPane(textArea);
            scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
            scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            verticalScrollBar = scrollPane.getVerticalScrollBar();
            jpanel.add(scrollPane);

            jpanel.setMaximumSize(jpanel.getPreferredSize());
                }
            });
            viewPanel.addWComponent(label, this);
        }
        public void setAutoXFlag(boolean b){ autoXFlag = b; autoX = 0; }
        public void plot1(float y){ plot(autoX++, y); }
        public void plot(float x, float y) {
            Lab.checkNotEDT();
            textArea.append(x+ "\t"+ y);
            textArea.append(System.getProperty("line.separator"));
            textArea.setCaretPosition(textArea.getText().length());
            //System.out.println("plot: "+ label+ ": "+ x+ " "+ y);
            //
            ((GraphPainter)painter).addData(x, y);
            viewPanel.paint(label, painter);
        }
        public void setGraphType(String type){
            ((GraphPainter)painter).setGraphType(type);
        }
        public void fixX(float minX, float maxX){
            ((GraphPainter)painter).fixX(minX, maxX);
        }
        public void fixY(float minY, float maxY){
            ((GraphPainter)painter).fixY(minY, maxY);
        }
        public void resetGraphData(){
            ((GraphPainter)painter).resetGraphData();
            autoX = 0;
            textArea.setText("");
        }
        // New features implemented on 2018-12
        public void newGraph(){
            ((GraphPainter)painter).newGraph();
            textArea.setText("");
        }
        public void setMaxDataSize(int n){
            ((GraphPainter)painter).setMaxDataSize(n);
        }
   }
   public static class GraphPainter implements Painter {
        public int xPixels = 200;
        public int yPixels = 100;
        //float[] xVec; 
        //float[] yVec;
        boolean fixedX = false;
        boolean fixedY = false;
        float minX;
        float minY;
        float maxX;
        float maxY;
        float oX = 0;
        float oY = 0;
        float scaleX = 1;
        float scaleY = 1;
        public String graphType = "line";
        //
        int maxDataSize = 1000;
        GraphData currentGraph;
        Vector allGraphs;
        public GraphPainter() {
            resetGraphData();
        }
        public Dimension getSize(){
            return new Dimension(xPixels, yPixels);
        }
        public void setGraphType(String type){
            graphType = type;
        }
        public void fixX(float minX, float maxX){
            fixedX = true; this.minX = minX; this.maxX = maxX;
        }
        public void fixY(float minY, float maxY){
            fixedY = true; this.minY = minY; this.maxY = maxY;
        }
        public void resetGraphData(){
            allGraphs = new Vector();
            newGraph();
        }
        public void newGraph(){
            currentGraph = new GraphData(maxDataSize);
            allGraphs.add(currentGraph);
        }
        public void addData(float x, float y){
            currentGraph.addData(x, y);
        }
        public void setMaxDataSize(int n){
            maxDataSize = n;
            resetGraphData();
        }
        public void paintComponent(Graphics g, MouseEvent lastEvent){
            Lab.checkNotEDT();
            if (! fixedX){
                minX = Float.MAX_VALUE;
                maxX = -Float.MAX_VALUE;
            }
            if (! fixedY){
                minY = Float.MAX_VALUE;
                maxY = -Float.MAX_VALUE;
            }
            for (int i = 0; i < allGraphs.size(); i++) {
                GraphData d = (GraphData)allGraphs.get(i);
                if (! fixedX){
                    for (int j = d.bottom; j != d.top; j = (j + 1) % d.bufSize) {
                        if (d.xVec[j] < minX) minX = d.xVec[j];
                        if (d.xVec[j] > maxX) maxX = d.xVec[j];
                    }
                }
                if (! fixedY){
                    for (int j = d.bottom; j != d.top; j = (j + 1) % d.bufSize) {
                        if (d.yVec[j] < minY) minY = d.yVec[j];
                        if (d.yVec[j] > maxY) maxY = d.yVec[j];
                    }
                }
            }
            oX = minX;
            oY = minY;
            scaleX = maxX - minX;
            scaleY = maxY - minY;
            for (int i = 0; i < allGraphs.size(); i++) {
                drawGraph(g, (GraphData)allGraphs.get(i), 
                        Lab.toGrayColor((i + 1f) / allGraphs.size()));
            }
            // Plot the last point with a big blue squire.
            GraphData d = currentGraph;
            if (d.bottom != d.top){
                g.setColor(Color.BLUE);
                int last = (d.top - 1 + d.bufSize) % d.bufSize;
                g.drawRect(posX(d.xVec[last])-2, posY(d.yVec[last])-2, 4, 4);
            }
        }
        public void drawGraph(Graphics g, GraphData d, Color color){
            if (d.bottom == d.top) return;
            if (graphType.equals("scatter")){
                g.setColor(color);
                for (int i = d.bottom; i != d.top; i = (i + 1) % d.bufSize) {
                    g.drawRect(posX(d.xVec[i])-1, posY(d.yVec[i])-1, 2, 2);
                }
            } else if (graphType.equals("line")){
                g.setColor(color);
                g.drawRect(posX(d.xVec[d.bottom])-1, posY(d.yVec[d.bottom])-1, 2, 2);
                for (int i = d.bottom, next = (i + 1) % d.bufSize;
                        next != d.top;
                        i = next, next = (next + 1) % d.bufSize) {
                    g.drawLine(posX(d.xVec[i]), posY(d.yVec[i]),
                            posX(d.xVec[next]), posY(d.yVec[next]));
                    g.drawRect(posX(d.xVec[next])-1, posY(d.yVec[next])-1, 2, 2);
                }
            } else {
                throw new Error("WGraph: Illegal graphType: "+ graphType);
            }
        }
        public int posX(float x){
            // x1 in [0,1]
            float x1 = (x - oX) / scaleX; 
            return (int)(x1 * xPixels);
        }
        public int posY(float y){
            // y1 in [0,1]
            float y1 = (y - oY) / scaleY; 
            return -(int)(y1 * yPixels) + yPixels;
        }
        public static class GraphData {
            public float[] xVec;
            public float[] yVec;
            int top = 0;
            int bottom = 0;
            int bufSize;
            public GraphData(int maxDataSize){
                this.bufSize = maxDataSize + 1;
                xVec = new float[this.bufSize];
                yVec = new float[this.bufSize];
            }
            public void addData(float x, float y){
                xVec[top] = x; 
                yVec[top] = y;
                top = (top + 1) % bufSize;
                if (top == bottom){
                    bottom = (bottom + 1) % bufSize;
                }
            }
        }
    }
   // Not used.
   public static class OldGraphPainter implements Painter {
       public int xPixels = 200;
       public int yPixels = 100;
       float[] xVec = new float[0]; 
       float[] yVec = new float[0];
       boolean fixedX = false;
       boolean fixedY = false;
       float minX = Float.MAX_VALUE;
       float minY = Float.MAX_VALUE;
       float maxX = -Float.MAX_VALUE;
       float maxY = -Float.MAX_VALUE;
       float oX = 0;
       float oY = 0;
       float scaleX = 1;
       float scaleY = 1;
       public String graphType = "line";
       public Dimension getSize(){
           return new Dimension(xPixels, yPixels);
       }
       public void setGraphType(String type){
           graphType = type;
       }
       public static float[] append(float[] a, float n){
           float[] newA = new float[a.length + 1];
           for (int i = 0; i < a.length; i++) newA[i] = a[i];
           newA[a.length] = n;
           return newA;
       }
       public void fixX(float minX, float maxX){
           fixedX = true; this.minX = minX; this.maxX = maxX;
       }
       public void fixY(float minY, float maxY){
           fixedY = true; this.minY = minY; this.maxY = maxY;
       }
       public void addData(float x, float y){
           xVec = append(xVec, x);
           yVec = append(yVec, y);
           if (! fixedX){
               if (x < minX) minX = x;
               if (x > maxX) maxX = x;
           }
           if (! fixedY){
               if (y < minY) minY = y;
               if (y > maxY) maxY = y;
           }

           oX = minX;
           oY = minY;
           scaleX = maxX - minX;
           scaleY = maxY - minY;
       }
       public void resetData(){
           xVec = new float[0]; 
           yVec = new float[0];            
           if (! fixedX){
               minX = Float.MAX_VALUE;
               maxX = -Float.MAX_VALUE;
           }
           if (! fixedY){
               minY = Float.MAX_VALUE;
               maxY = -Float.MAX_VALUE;
           }
       }
       public void paintComponent(Graphics g, MouseEvent lastEvent){
           if (xVec.length == 0) return;
           if (graphType.equals("scatter")){
               g.setColor(Color.BLACK);
               for (int i = 0; i < xVec.length; i++) {
                   g.drawRect(posX(xVec[i])-1, posY(yVec[i])-1, 2, 2);
               }
               g.setColor(Color.BLUE);
               g.drawRect(posX(xVec[xVec.length-1])-2, posY(yVec[yVec.length-1])-2, 4, 4);
           } else if (graphType.equals("line")){
               // TODO: { x ̒l sort Ă悤ɂׂB
               // CN^ sort ASY悢낤B
               // ȀꍇA textarea ւ̏o͂ƐHႤƂɁH
               g.setColor(Color.BLACK);
               g.drawRect(posX(xVec[0])-1, posY(yVec[0])-1, 2, 2);
               for (int i = 1; i < xVec.length; i++) {
                   //System.out.println(posX(xVec[i-1])+ ","+ posY(yVec[i-1]));
                   g.drawLine(posX(xVec[i-1]), posY(yVec[i-1]),
                           posX(xVec[i]), posY(yVec[i]));
                   g.drawRect(posX(xVec[i])-1, posY(yVec[i])-1, 2, 2);
               }
           } else {
               throw new Error("WGraph: Illegal graphType: "+ graphType);
           }
       }
       public int posX(float x){
           // x1 in [0,1]
           float x1 = (x - oX) / scaleX; 
           return (int)(x1 * xPixels);
       }
       public int posY(float y){
           // y1 in [0,1]
           float y1 = (y - oY) / scaleY; 
           return -(int)(y1 * yPixels) + yPixels;
       }
   }
   /**
    * byte[row][col] Ƃ`̃OCXP[摜`B
    * OB
    */
   public static class GrayImagePainter implements Lab.Painter {
       public int pSize = 2;
       public byte[][] image;
       public GrayImagePainter(byte[][] image){
           this.image = image;
       }
       public Dimension getSize(){
           return new Dimension(image[0].length * pSize, image.length * pSize);
       }
       public void paintComponent(Graphics g, MouseEvent lastEvent) {
           for (int row = 0; row < image.length; row++) {
               for (int col = 0; col < image[row].length; col++) {
                   g.setColor(Lab.toGrayColor(1-(image[row][col] & 0xff) / 256.0f));
                   g.fillRect(col * pSize, row * pSize, pSize, pSize);
               }
           }
       }
       
   }
   /**
    * float[imageSize * imageSize] Ƃ`̃OCXP[摜`B
    * OB
    */
   public static class GrayImageDataPainter implements Lab.Painter {
       public int pSize = 2;
       public float[] data;
       public int imageSize;
       public GrayImageDataPainter(float[] data, int imageSize){
           this.data = data;
           this.imageSize = imageSize;
       }
       public Dimension getSize(){
           return new Dimension(imageSize * pSize, imageSize * pSize);
       }
       public void paintComponent(Graphics g, MouseEvent lastEvent) {
           for (int row = 0; row < imageSize; row++) {
               for (int col = 0; col < imageSize; col++) {
                   g.setColor(Lab.toGrayColor(data[row * imageSize + col]));
                   g.fillRect(col * pSize, row * pSize, pSize, pSize);
               }
           }
       }
       
   }

    
    //--------------------------------------------------------------------

    // R[hZN^̌⃊Xg
    // [U͌A̕ϐ𒼐ڎQƂĂ͂ȂB
    public static Vector<Class<?>> selectableClasses
        = new Vector<Class<?>>();
    
    /**
     * NXR[hZN^̑ĨXgɒǉB
     * d`FbN͂ȂB
     * static member class ͍ċAIɒǉB
     */
    public static void addSelectableClass(Class<?> c){
        // Selectable  implements ĂNXo^B 
//        // do^͔B
//        if (Lab.Selectable.class.isAssignableFrom(c) &&
//                ! Lab.selectableClasses.contains(c)){
            Lab.selectableClasses.add((Class<Selectable>)c);
//        }
        // public  member class ̔z𓾂Bpꂽ̂܂ށB
        Class<?>[] members = c.getClasses();
        // NX̎zŃ\[gB
        java.util.Arrays.sort(members, new ClassComparator());
        for (Class<?> mem : members){
            addSelectableClass(mem);
        }
    }
    public static class ClassComparator implements java.util.Comparator {
        public int compare(Object arg0, Object arg1) {
            return ((Class)arg0).getName().compareTo(((Class)arg1).getName());
        }
    }
    
    
    
    //--------------------------------------------------------------------
    // Lab ̃[eBeB֐
    // XXX:  Lab  static method ł̂HʃNXɂׂH
    public static final float epsilon = 1e-30f; 

    public static int randState = 20050928;
    public static void setRandomSeed(int seed){ randState = seed; }
    /**
     * `@ɂ[
     * @return 0 &lt= r &lt 1 ̒lB
     */
    public static final float rand(){
        randState = randState * 1103515245 + 12345;
        // ꂾƎXl 1.0f ɂȂĂ܂B
        //float val = ((float)(randState & 0x7fffffff)) / 0x7fffffff;
        float val = ((float)(randState & 0x7fffff00)) / 0x7fffffff;
        // TODO: Ȃ悤ȂA̍s̓RgAEgB
        if (val >= 1f) System.out.println("randState="+ randState);
        return val;
    }
    /**
     * @param max
     * @return 0 &lt= r &lt max ̐lB
     */
    public static final int irand(int max){
        return (int)Math.floor(Lab.rand() * max);
    }
    public static long lastTime = System.currentTimeMillis();
    public static final String lineSeparator = System.getProperty("line.separator");
    /**
     * bos\R float z𕶎ɕϊB
     * table[i][l][j] \Qs w^l_ij  l ƂɏcɕׂB 
     */
    public static String toString(float[][][] table) {
        StringBuffer buf = new StringBuffer();
        if (table.length == 0){
            throw new Error("fatal");
        }
        buf.append("{  // table[i][l][j]");
        buf.append(Lab.lineSeparator);
        for (int l = 0; l < table[0].length; l++) {
            buf.append("  {  // l="+ l);
            buf.append(Lab.lineSeparator);
            for (int i = 0; i < table.length; i++) {
                float[][] vecs = table[i];
                float[] vec = vecs[l];
                buf.append("    {");
                for (int j = 0; j < vec.length; j++) {
                    buf.append(vec[j]);
                    buf.append(", ");
                }
                buf.append("},  // i="+ i);
                buf.append(Lab.lineSeparator);
            }
            buf.append("  },");
            //buf.append(Lab.lineSeparator);
        }
        buf.append('}');
        buf.append(Lab.lineSeparator);
        return buf.toString();
    }
    /**
     * bos\R float zPvfP̃RpNgȕ\ŕɕϊB
     * table[i][l][j] \Qs w^l_ij  l ƂɉɕׂB 
     */
    public static String toCompactString(float[][][] table){
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < table.length; i++) {
            float[][] vecs = table[i];
            for (int l = 0; l < vecs.length; l++) {
                float[] vec = vecs[l];
                for (int j = 0; j < vec.length; j++) {
                    buf.append(Lab.toChar(vec[j]));
                }
                buf.append(' ');
            }
            buf.append(Lab.lineSeparator);
        }
        buf.append(Lab.lineSeparator);
        return buf.toString();
    }
    public static void print(float[][][] table){
        System.out.println(Lab.toCompactString(table));
//        for (int i = 0; i < table.length; i++) {
//            float[][] vecs = table[i];
//            for (int l = 0; l < vecs.length; l++) {
//                float[] vec = vecs[l];
//                for (int j = 0; j < vec.length; j++) {
//                    System.out.print(Lab.toChar(vec[j]));
//                }
//                System.out.print(' ');
//            }
//            System.out.println();
//        }
//        System.out.println();
    }
    // p~\H
    public static void printCompact(String str, float[] vec){
        System.out.print(str); Lab.printCompact(vec);
    }
    // p~\H
    public static void printCompact(float[] vec){
        for (int i = 0; i < vec.length; i++) {
            System.out.print(Lab.toChar(vec[i]));
        }
        System.out.println();
    }
    public static String toCompactString(float[][] vec){
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vec.length; i++) {
            for (int j = 0; j < vec[i].length; j++) {
                buf.append(Lab.toChar(vec[i][j]));
            }
            buf.append(Lab.lineSeparator);
        }
        return buf.toString();
    }
    public static String toCompactString(float[] vec){
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vec.length; i++) {
            buf.append(Lab.toChar(vec[i]));
        }
        return buf.toString();
    }
    public static String toCompactString(boolean[] vec){
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vec.length; i++) {
            buf.append(vec[i] ? '1' : '0');
        }
        return buf.toString();
    }
    public static String toString(float[] vec){
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i < vec.length; i++) {
            buf.append(vec[i]);
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
    public static String toString(int[] vec){
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i < vec.length; i++) {
            buf.append(vec[i]);
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
    // p~\H
    public static void printArray(String str, float[] vec){
        System.out.println(str+ Lab.toString(vec));
//        System.out.print(str+ "{");
//        for (int i = 0; i < vec.length; i++) {
//            System.out.print(vec[i]+ ", ");
//        }
//        System.out.println("}");
    }
    // p~\H
    public static void printArray(String str, int[] vec){
        System.out.print(str+ "{");
        for (int i = 0; i < vec.length; i++) {
            System.out.print(vec[i]+ ", ");
        }
        System.out.println("}");
    }
    public static void initVec(float[] a, float val) {
        for (int i = 0; i < a.length; i++) a[i] = val;
    }
    public static void copyVecFromTo(float[] from, float[] to){
        Lab.assertTrue(from.length == to.length);
        for (int i = 0; i < to.length; i++) {
            to[i] = from[i];
        }
    }
    /**
     * StringBuffer ̔zŕ\ꂽ` border ͂ŉɘAB
     *  rect1 ͔j󂳂B
     * Usage:
     *    rect1 = Lab.appendStringRectRight(rect1, rect2, "|");
     */
    public static StringBuffer[] appendStringRectRight(StringBuffer[] rect1,
            StringBuffer[] rect2, String border){
        Lab.assertTrue(rect1.length == rect2.length);
        int r1length = 0;
        for (int i = 0; i < rect1.length; i++) {
            if (r1length < rect1[i].length()){
                r1length = rect1[i].length();
            }
        }
        for (int i = 0; i < rect1.length; i++) {
            for (int j = rect1[i].length(); j < r1length; j++) {
                rect1[i].append(' ');
            }
            rect1[i].append(border);
            rect1[i].append(rect2[i]);
        }
        return rect1;
    }
    /**
     * StringBuffer ̔zŕ\ꂽ` border ͂ŏcɘAB
     * Usage:
     *    rect1 = Lab.appendStringRectBelow(rect1, rect2, "-");
     */
    public static StringBuffer[] appendStringRectBelow(StringBuffer[] rect1,
            StringBuffer[] rect2, String border){
        int max = 0;
        for (int i = 0; i < rect1.length; i++) {
            if (max < rect1[i].length()) max = rect1[i].length();
        }
        for (int i = 0; i < rect2.length; i++) {
            if (max < rect2[i].length()) max = rect2[i].length();
        }

        StringBuffer[] ret = new StringBuffer[rect1.length + rect2.length + 1];
        for (int i = 0; i < rect1.length; i++) {
            ret[i] = rect1[i];
        }
        StringBuffer bbuf = new StringBuffer();
        for (int i = 0; bbuf.length() < max; i++) {
            bbuf.append(border);
        }
        ret[rect1.length] = bbuf;
        for (int i = rect1.length + 1, j = 0; i < ret.length; i++, j++) {
            ret[i] = rect2[j];
        }
        return ret;
    }
    /**
     * aPɂȂ悤ɃXP[B
     */
    public static final void normalizeVec(float[] vec){
        float total = 0;
        for (int i = 0; i < vec.length; i++) {
            total += vec[i];
        }
        if (total < Lab.epsilon){
            // ψ̒lB
            float v =  1.0f / vec.length;
            for (int i = 0; i < vec.length; i++) {
                vec[i] = v;
            }
        } else {
            for (int i = 0; i < vec.length; i++) {
                vec[i] /= total;
            }
        }
    }
    /** 
     * őlPɂȂ悤ɃXP[B
     * @param vec
     */
    public static final void rescaleVec(float[] vec){
        float max = 0;
        for (int i = 0; i < vec.length; i++) {
            if (vec[i] > max){
                max = vec[i];
            }
        }
        if (max < Lab.epsilon){
            System.out.println("Warning: rescaleVec: max < epsilon");
            Lab.initVec(vec, 1f);
        } else {
            float r = 1 / max;
            for (int i = 0; i < vec.length; i++) {
                vec[i] *= r;
            }
        }
    }
    /**
     * returns logVal + log(x)
     * bZ[ŴׂĂ̗vfOɂȂȂ悤ɍŒl epsilon ɂĂ|B
     */
    public static float logMul(float logVal, float x) {
        if (x < Lab.epsilon) x = Lab.epsilon;
        return (float) (logVal + Math.log(x));
    }
    /**
     * returns logVal - log(x)
     * logMul Ŋ|l̂̂PŊƂɎgB
     * āAl logMul ƓlɏĂ犄B
     */
    public static float logDiv(float logVal, float x) {
        if (x < Lab.epsilon) x = Lab.epsilon;
        return (float) (logVal - Math.log(x));
    }
    /**
     * z̗vfƂ exp Ből͂PɂB
     * @param vec
     */
    public static void rescaleAndExp(float[] vec){
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < vec.length; i++) {
            if (vec[i] > max){
                max = vec[i];
            }
        }
        if (max == Float.NEGATIVE_INFINITY){
            System.out.println("Warning: rescaleAndExp: max == -Infinity");
            Lab.initVec(vec, 1f);
        } else {
            for (int i = 0; i < vec.length; i++) {
                vec[i] -= max;
                vec[i] = (float)Math.exp(vec[i]);
            }
        }
        //Lab.printArray("vec", vec);
    }
    /**
     *  ΐ̒l̓z̍őlOɂB
     * @param vec
     */
    public static void rescaleLog(float[] vec){
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < vec.length; i++) {
            if (vec[i] > max){
                max = vec[i];
            }
        }
        if (max == Float.NEGATIVE_INFINITY){
            System.out.println("Warning: rescaleLog: max == -Infinity");
            Lab.initVec(vec, 1f);
        } else {
            for (int i = 0; i < vec.length; i++) {
                vec[i] -= max;
            }
        }
    }
    public static float log(float x){
        return (float)Math.log(x);
    }
    public static void logVec(float[] vec){
        for (int i = 0; i < vec.length; i++) {
            vec[i] = (float)Math.log(vec[i]); 
        }
    }
    /**
     * őlԂB
     */
    public static float max(float[] vec){
        float val = -1f / 0; // -Infinity
        for (int i = 0; i < vec.length; i++) {
            if (vec[i] > val) val = vec[i];
        }
        return val;
    }
    /**
     * vec[i] ̂ő̒l i ԂB
     */
    public static int argmax(float[] vec){
        int index = -1;
        float val = -Float.MAX_VALUE; // float ̍ŏl
        for (int i = 0; i < vec.length; i++) {
            if (vec[i] > val) {
                index = i;
                val = vec[i];
            }
        }
        return index;
    }
    public static float min(float f1, float f2){
        if (f1 < f2) {
            return f1;
        } else {
            return f2;
        }
    }
    public static float clip(float min, float x, float max){
        if (x < min) return min;
        if (x > max) return max;
        return x;
    }
    public static int min(int f1, int f2){
        if (f1 < f2) {
            return f1;
        } else {
            return f2;
        }
    }
    public static void assertTrue(boolean b){
        if (!b) throw new Error("Lab.assert failed.");
    }
    public static void sleep(long t){
        try {
            Thread.sleep(t);
        } catch (InterruptedException e) {
            e.printStackTrace();
            throw new Error(""+ e);
        }
    }
    // not used?
    public static void setMaxSize(JComponent c){
        Dimension d = c.getPreferredSize();
        c.setMaximumSize(new Dimension(d.width, d.height));
    }

    public static void checkEDT(){
        if (checkEDT){
            Lab.assertTrue(java.awt.EventQueue.isDispatchThread());
        }
    }
    public static void checkNotEDT(){
        if (checkEDT){
            Lab.assertTrue(! java.awt.EventQueue.isDispatchThread());
        }
    }

    // O͔AP͍ƂBiXp[XȍsƂ₷̂ŁBj
    public static Color[] grayColors = null;
    public static Color toGrayColor(float x){
        if (x != x){
            // x is NaN.
            return Color.red;
        }
        if (x < 0) { return Color.YELLOW;  }
        if (x > 1) { return Color.GREEN;  }
        if (grayColors == null){
            grayColors = new Color[256];
            for (int i = 0; i < 256; i++) {
                grayColors[256-1-i] = new Color(i, i, i);
            }
        }
        int w = (int)Math.floor(x * 256);
        if (w >= 256) w = 255;
        return grayColors[w];
    }
    public static char toChar(float x){
        if (0 < x && x < 0.1f) return '.';
        if (x == 0) return '0';
        if (x == 1f) return '*';
        if (x != x) return 'N';
        if (x > 1) return '+';
        if (x < 0) return '-';
        int w = (int)Math.floor(x * 10);
        // x == 1 ̂Ƃ ':' ɂȂB
        char c = (char) ('0' + w);
        return c;
    }
}


//-----------------------------------------------------------------
// test
class Test {
    public static class M3Mouse extends Lab.MainCode {
        MouseTestPainter painter = panel.getCode("Painter", MouseTestPainter.class);
        public void main(){
            painter.init(this);
            for (;;){
                panel.speedControl("Loop", 0);
                // XC_ŃXs[ĥŁA sleep gB
                Lab.sleep(panel.getInt("Speed", 10, 0, 100));
                step();
                //env.viewPanel.paint("Mouse Test", painter, 10);
                env.viewPanel.paint("Mouse Test", painter);
            }
        }
        int sizeX = panel.getInt("sizeX", 600, 0, 2000);
        int sizeY = panel.getInt("sizeY", 600, 0, 2000);
        int modelCounter = 0;
        int obstacleNumber = panel.getInt("Obstracle num", 30, 0, 100);
        Obstacle[] obstacles = new Obstacle[obstacleNumber];
        {
            // Initialization.
            for (int i = 0; i < obstacles.length; i++) {
                obstacles[i] = new Obstacle(this);
            }
        }
        // Dynamically changeable parameters.
        int objR;
        void updateParams(){
            objR = panel.getInt("Obj r", 10, 1, 100);
        }
        void step(){
            modelCounter++;
            updateParams();
            for (int i = 0; i < obstacles.length; i++) {
                obstacles[i].move();
            }
        }
        public static class MouseTestPainter extends Lab.Code implements Lab.Painter {
            M3Mouse m;
            int paintCounter = 0;
            int objLength = panel.getInt("Obj length", 20, 1, 1000);
            int objX[] = new int[objLength];
            int objY[] = new int[objLength];
            void init(M3Mouse m){
                this.m = m;
                for (int i = 0; i < objX.length; i++) {
                    objX[i] = 0;
                    objY[i] = m.sizeY;
                }
            }
            public Dimension getSize() {
                return new Dimension(m.sizeX, m.sizeY);
            }
            /*
             * ܂悢X^Cł͂ȂB
             * ׂẴf[^̓f m ɎāA
             * painter ͕`悾ׂ낤B
             * lastEvent Afɉe^̂烂fɂ̂܂ܓnׂB
             */
            public void paintComponent(Graphics g, MouseEvent lastEvent) {
                g.drawString("p="+ paintCounter++, 10, 10);
                g.drawString("m="+ m.modelCounter, 10, 20);
                if (lastEvent != null){
                    for (int i = objX.length - 1; i >= 1; i--) {
                        objX[i] = objX[i-1];
                        objY[i] = objY[i-1];
                    }
                    objX[0] = lastEvent.getX() - m.objR;
                    objY[0] = lastEvent.getY() - m.objR;
                }
                for (int i = 0; i < objX.length; i++) {
                    g.drawRect(objX[i], objY[i], m.objR*2, m.objR*2);
                }
                g.fillRect(objX[0], objY[0], m.objR*2, m.objR*2);

                boolean stop = false;
                for (int i = 0; i < m.obstacles.length; i++) {
                    m.obstacles[i].draw(g);
                    for (int j = 0; j < objX.length; j++) {
                        if (m.obstacles[i].check(objX[j], objY[j])){
                            g.setColor(Color.RED);
                            g.drawRect(objX[j],objY[j], m.objR, m.objR);
                            g.setColor(Color.BLACK);
                            stop = true;
                        }
                    }
                }
                if (stop) throw new lab.Lab.StopPressed();
            }
        }
        static class Obstacle {
            M3Mouse m;
            int x;
            int y;
            int dx;
            int dy;
            int delay;
            Obstacle(M3Mouse m){
                this.m = m;
                x = Lab.irand(m.sizeX);
                y = 0;
                dx = Lab.irand(2) * 2 - 1;
                dy = 1;
                delay = Lab.irand(m.sizeY);
            }
            void move(){
                if (delay-- > 0) return;
                x += dx;
                if (x < 0 || m.sizeX < x) dx = -dx;
                y += dy;
                if (y < 0 || m.sizeY < y) dy = -dy;
            }
            void draw(Graphics g){
                g.fillRect(x, y, m.objR, m.objR);
            }
            boolean check(int ox, int oy){
                return ox - m.objR < x
                    && x < ox + m.objR
                    && oy - m.objR < y
                    && y < oy + m.objR;
            }
        }
    } // end of XMouseTest
public static class M1 extends Lab.MainCode {
    { System.out.println("panel="+ panel);}
    { params(); }
    PaintCodeTest1 v = panel.getCode("Painter", PaintCodeTest1.class);
    //int period = panel.getInt("paint period", 100, 0, 1000);
    public void main(){ 
        System.out.println("hello. main 1.");
        for (;;){
            System.out.println("1.1: "+ panel.getFloat("s1", 0.1f, -1, 1));
            System.out.println("1.2: "+ panel.getFloat("s2", 1f/3, -1.5f, 2.3f));
            env.checkStop();
            Lab.sleep(50);
            //env.viewPanel.paint("canvas test", v, period);
            env.viewPanel.paint("canvas test", v);
            //if (((PaintCodeTest1)v).counter == 100) throw new Error("error test!");
        }
    }
    public void params(){
        panel.getFloat("1 MainCode1", 0, 0, 1);
        panel.setFloat("1 MainCode1", 0.1f);
        panel.getFloat("f1", 0.3f, -2, 10);
        panel.getCode("Test1", Dummy.class);
        panel.getCode("Test2", Dummy.class);

        lab.Lab.WPanel[] panels = panel.getMultiPanel("panels", 4);
        panels[0].getFloat("a", 0, 0, 1);
        panels[1].getFloat("a", 0, 0, 1);
        panels[2].getFloat("a", 0, 0, 1);
        panels[2].getInt("int1", 10, 0, 20);
        panels[2].getInt("int2", -1, 0, 20);
        panels[2].getInt("int3", 0, -100, 100);
        panels[2].getInt("int4", 100, -10000, 10000);
   }
    public void codeSelected(){
        System.out.println("MainCode1 selected.");
    }
}
public static class M2 extends Lab.MainCode {
    public void main(){ 
        System.out.println("hello. main 2.");
        for (;;){
            updateParams();
            System.out.println("2: "+ panel.getFloat("MainCode2", 0, -0.001f, 0.001f));
            env.checkStop();
            Lab.sleep(50);
            if (panel.button("Button Test")){
                System.out.println("Button pressed!");
            }
            panel.button("Button2");
            System.out.println("flag="+ panel.flag("Flag Test"));
        }
    }
    public void updateParams(){
        panel.getFloat("2 MainCode2", 0, 0, 1);
        panel.setFloat("2 MainCode2", 0.2f);
        //System.out.println("2.1:"+ panel.getFloat("2 MainCode2", 0.2f, 0, 1));
        //
        //int inputNodeSize = panel.getInt("inputNodeSize", 1, 30, 10);
        //int hiddenNodeSize = panel.getInt("hiddenNodeSize", 1, 30, 10);
        //int nodeSize = panel.getInt("nodeSize", 1, 30, 4);
    }
    { updateParams(); }
    public void codeSelected(){
        System.out.println("MainCode2 selected.");
    }
}
public static class Dummy extends Lab.Code {
    { params(); }
    public void params() {
        panel.getFloat("fff", -1, 1, 2);
        panel.getFloat("fff2", 1, -2, 3);
    }
    
}
public static class PaintCodeTest1 extends Lab.Code implements Lab.Painter {
    public int counter = 0;
    int sizeX = 400;
    int sizeY = 200;
    int x;
    int y;
    String[] strs = {"aaa", "bbb", "ccc"};
    String str;
    public void updateParams() {
        x = (int)panel.getFloat("x", 0, 0, sizeX);
        y = (int)panel.getFloat("y", 0, 0, sizeY);
        str = (String)panel.getSelectedValue("str", strs);
    }
    { updateParams(); } // Start Oɂfthi悤ɁB
    public Dimension getSize() {
        return new Dimension(sizeX, sizeY);
    }
    public void paintComponent(Graphics g, MouseEvent lastEvent) {
        Lab.checkNotEDT();
        if (Lab.paintDebug){
            System.out.println("paintComponent called : this="+ this);
        }
        
        g.drawString("counter="+ counter, 10, 10);
        g.drawString("str="+ str, 10, 20);
        //if (counter == 100) throw new Error("error test!");
        counter++;
        updateParams(); // Update parmas.
        g.drawRect(x, y, 4, 4);
    }
    
}
public static class M0GridBagTest1 extends Lab.MainCode {
    public void main() {
        SwingUtilities.invokeLater(new Runnable(){
           public void run(){
               GridBagLayout gridbag = new GridBagLayout();
               GridBagConstraints con = new GridBagConstraints();
               con.insets = new Insets(1,1,1,1);
               con.weightx = 0;
               JPanel jpanel = new JPanel(gridbag); 
               jpanel.setBorder(new LineBorder(Color.GRAY));
               
               JLabel label = new JLabel("Test");
               label.setBorder(new LineBorder(Color.GRAY));
               gridbag.setConstraints(label, con);
               //label.setMaximumSize(label.getPreferredSize());
               jpanel.add(label);
               
               JLabel label2 = new JLabel("test");
               label2.setBorder(new LineBorder(Color.GRAY));
               gridbag.setConstraints(label2, con);
               jpanel.add(label2);
               
               JSlider slider = new JSlider();
               slider.setMinimumSize(slider.getPreferredSize());
               slider.setBorder(new LineBorder(Color.GRAY));
               gridbag.setConstraints(slider, con);
               jpanel.add(slider);
               
               JTextField text = new JTextField();
               text.setMinimumSize(new Dimension(40,30));
               text.setPreferredSize(text.getMinimumSize());
               gridbag.setConstraints(text, con);
               jpanel.add(text);
               
               con.weightx = 1; // glue
               JPanel last = new JPanel();
               last.setBorder(new LineBorder(Color.GRAY));
               gridbag.setConstraints(last, con);
               jpanel.add(last);
               
               
               JFrame f = new JFrame("GridBagTeset");
               f.setSize(300,100);
               f.setContentPane(jpanel);
               f.setVisible(true);
           }
        });
    }
    
}
/**
 * ׂĂ̋@\eXgvOB
 */
public static class M9Test extends Lab.MainCode {
    float a = panel.getFloat("a", 0.1f, -1, 2);
    float b = panel.getFloat("b", 0, -0.001f, 0.001f);
    int n = panel.getInt("n", 2, -1, 3);
    int vecSize = panel.getInt("vecSize", 3, 0, 20);
    boolean flag = panel.flag("flag");
    TestPainter painter = panel.getCode("Painter", TestPainter.class);
    TestCode testCodeA = panel.getCode("TestCodeA", TestCode.class);
    TestCode testCodeB = panel.getCode("TestCodeB", TestCode.class, TestCode2.class);
    public void main(){
        env.viewPanel.print1("a", ""+ a);
        env.viewPanel.print1("b", ""+ b);
        env.viewPanel.print1("n", ""+ n);
        env.viewPanel.print1("flag", ""+ flag);
        Lab.WTextArea text = new Lab.WTextArea(env, "Text");
        float[] vec = new float[vecSize];
        int c = 0;
        Lab.WGraph graph = new Lab.WGraph(env, "Graph of x");
        for (;;){
            updateParams();
            env.checkStop();
            //Lab.sleep(50);
            panel.speedControl("Test Loop", 200);
            env.viewPanel.print1("c", ""+ c);
            if (panel.button("Button Test")){
                text.println("Button pressed!");
            }
            if (panel.button("Set slider values")){
                panel.setFlag("flag", true);
                panel.setFloat("x", 0.123f);
                panel.setInt("n", 2);
            }
            float x = panel.getFloat("x", 0, 0, 1);
            env.viewPanel.print1("x", ""+ x);
            graph.plot(c++, x);
            env.viewPanel.print1("str", str);
            for (int i = 0; i < vec.length; i++) {
                vec[i] = panel.getFloat("v"+ i, 0, 0, 1);
            }
            env.viewPanel.paint("vec(paint)", vec);
            env.viewPanel.print1("Lab.toCompactString(vec)", Lab.toCompactString(vec));
            env.viewPanel.print1("Lab.toString(vec)", Lab.toString(vec));
            env.viewPanel.paint("TestPainter", painter);
            
            // New features implemented on 2018-12
            int maxDataSize = panel.getInt("Graph maxDataSize", 10, 0, 100);
            if (panel.button("Set graph maxDataSize")){
                graph.setMaxDataSize(maxDataSize);
            }
            if (panel.button("Reset c and New graph")){
                graph.newGraph();
                c = 0;
            }
        }
    }
    String[] strs = {"aaa", "bbb", "ccc"};
    String str;
    public void updateParams() {
        str = (String)panel.getSelectedValue("str", strs);
    }
}
public static class TestPainter extends Lab.Code implements Lab.Painter {
    public Dimension getSize(){
        return new Dimension(400, 200);
    }
    int counter = 0;
    public void paintComponent(Graphics g, MouseEvent lastEvent) {
        counter++;
        g.drawString("couter="+ counter, 10, 10);
        if (lastEvent != null){
            //System.out.println(""+ lastEvent);
            switch (lastEvent.getID()){
            case MouseEvent.MOUSE_CLICKED:
                g.drawRect(lastEvent.getX(), lastEvent.getY(), 8, 8);
                break;
            case MouseEvent.MOUSE_DRAGGED:
                g.drawRect(lastEvent.getX(), lastEvent.getY(), 4, 4);
                break;
            case MouseEvent.MOUSE_MOVED:
                g.drawRect(lastEvent.getX(), lastEvent.getY(), 2, 2);
                break;
            default:
                throw new Error();
            }
        }
    }
    
}
public static abstract class TestCode extends Lab.Code {
    float x = panel.getFloat("x", 0, 0, 1);
}
public static class TestCode1 extends TestCode {}
public static class TestCode2 extends TestCode {}
public static class TestCode3 extends TestCode {}
}
