//Copyright (c) 2022 National Institute of Advanced Industrial Science and Technology (AIST), All Rights Reserved.
//Author: Yuuji Ichisugi
/*

sle[ukASỸeXgB

ꐙTu,cG,l,|,쐒,
vOΏی Pro5Lang ̂߂̍sl֐kASY,
22 lHm\w ėplHm\(SIG-AGI), 2022.

*/

package compress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import lab.Lab;
import lab.Lab.LabCode;


public class Compress {
    public static void main(String[] args) {
        Lab.addSelectableClass(Compress.class);
        System.out.println(Lab.selectableClasses + "");

        LabCode labCode = new LabCode();
        labCode.main(MainCode.class);
    }

    //For debug.
    public static void printlnArray(String s, Object[] a) {
        System.out.println(s+ ": ");
        for (int i = 0; i < a.length; i++) {
            System.out.println("  "+ a[i]);
        }
        System.out.println();
    }
    
    //-------------------------------------------------------------------
    // Definitions of inner static classes.
    
    public static class ValuedVec {
        public float value;
        public Object[] vec;
        public static final Object WildCard = "*".intern();
        public ValuedVec(float value, Object[] vec) { 
            this.value = value;
            this.vec = vec;
        }
        public String toString() {
            StringBuffer buf = new StringBuffer();
            Lab.assertTrue(vec.length >= 1);
            buf.append("(");
            buf.append(vec[0]);
            for (int i = 1; i < vec.length; i++) {
                buf.append(","+ vec[i]);
            }
            buf.append(") : "+ value);
            return buf.toString();
        }
        
        /** ̃xNgkp^[xNgPԂB */
        public static ValuedVec vecCompress(ValuedVec[] vecs) {
            // ׂẴxNg̒`FbNB
            if (true) {
                for (int i = 0; i < vecs.length; i++) {
                    Lab.assertTrue(vecs[0].vec.length == vecs[i].vec.length);
                }
            }
            
            // ׂẴxNgƃ}b`p^[xNgB
            // ϐg킸AChJ[ĥ݁B
            Object[] v = new Object[vecs[0].vec.length];
            for (int i = 0; i < v.length; i++) {
                diff: {
                    Object e0i = vecs[0].vec[i]; 
                    for (int j = 0; j < vecs.length; j++) {
                       if (! vecs[j].vec[i].equals(e0i)) {
                           v[i] = WildCard;
                           break diff;
                       }
                    }
                    v[i] = e0i;
                }
            }

            // l̕ςvZB
            float total = 0;
            for (int i = 0; i < vecs.length; i++) {
                total += vecs[i].value;
            }
            float meanValue = (float)((total + 0d) / vecs.length); 
            
            return new ValuedVec(meanValue, v);
        }
        
        /** p^[xNg炻Ƀ}b`xNgPB */
        public ValuedVec makeSample(int maxVecElem) {
            Object[] retvec = new Object[vec.length];
            for (int i = 0; i < retvec.length; i++) {
                if (vec[i] == WildCard) {
                    retvec[i] = Lab.irand(maxVecElem);
                } else {
                    retvec[i] = vec[i];
                }
            }
            return new ValuedVec(value, retvec);
        }
        
        public static ValuedVec[] sort(ValuedVec[] a) {
            ValuedVec[] ret = a.clone();
            Arrays.sort(ret, new Comparator<ValuedVec>() {
                @Override
                public int compare(ValuedVec o1, ValuedVec o2) {
                    for (int i = 0; i < a[0].vec.length; i++) {
                        Object e1 = o1.vec[i];
                        Object e2 = o2.vec[i];
                        if (! e1.equals(e2)) {
                            if (e1 == WildCard) {
                                return -1; // WildCard is less than anything.
                            } else if (e2 == WildCard) {
                                return 1; 
                            } else if (e1 instanceof Integer && e2 instanceof Integer) {
                                return Integer.compare((Integer)e1, (Integer)e2);
                            } else {
                                return 0;
                            }
                        }
                    }
                    return 0;
                }
            });
            return ret;
        }
        
        public static ValuedVec[] toArray(List<ValuedVec> list) {
            return list.toArray(new ValuedVec[list.size()]);
        }
        /** p^[xNg̃p^[ꂩǂԂB */
        public boolean vecEquals(ValuedVec v) {
            for (int i = 0; i < vec.length; i++) {
                if (! vec[i].equals(v.vec[i])) return false;
            }
            return true;
        }
    }

    public static abstract class CompressCode extends Lab.Code {
        /** QƃxNgW̏l𐶐B */
        public abstract ValuedVec[] initialVec(int size, ValuedVec[] input);
        /**
         *  K-means gNX^OPXebvsB
         *  QƃxNgWƓ̓xNgWɎAXVꂽQƃxNgWԂB 
         * */
        public abstract ValuedVec[] kmeans1(ValuedVec[] rvec, ValuedVec[] input);
        public boolean logVecCompressFlag = panel.flag("logVecCompressFlag", true);
        public boolean logCompress1Flag = panel.flag("logCompress1Flag", true);
        public boolean valueDistanceFlag = panel.flag("valueDistanceFlag", true);
        public boolean initPlusPlusFlag = panel.flag("initPlusPlusFlag", true);
        public abstract float eval(ValuedVec[] rvec, ValuedVec[] data);
    }
    public static class Compress1 extends CompressCode {
        public class Distance  {
            public int elemDiff;     // }b`vf̐
            public int genericity;    // ChJ[hg킸Ƀ}b`vf̐
            public float valueDiff;  // l̍̐Βl
            public int noiseDiff;  // mCY
            public boolean lessThan(Distance d2) {
                Distance d1 = this; 
                if (valueDistanceFlag) {
                    if (d1.valueDiff != d2.valueDiff) {
                        return d1.valueDiff < d2.valueDiff;
                    } else {
                        if (d1.elemDiff != d2.elemDiff) {
                            return d1.elemDiff < d2.elemDiff;
                        } else {
                            return d1.genericity < d2.genericity;
//                            if (d1.genericity != d2.genericity) {
//                                return d1.genericity < d2.genericity;
//                            } else {
//                                return d1.noiseDiff < d2.noiseDiff;
//                            }
                        }
                    }
                } else {
                    if (d1.elemDiff != d2.elemDiff) {
                        return d1.elemDiff < d2.elemDiff;
                    } else {
                        if (d1.genericity != d2.genericity) {
                            return d1.genericity < d2.genericity;
                        } else {
                            return d1.valueDiff < d2.valueDiff;
//                            if (d1.valueDiff != d2.valueDiff) {
//                                return d1.valueDiff < d2.valueDiff;
//                            } else {
//                                return d1.noiseDiff < d2.noiseDiff;
//                            }
                        }
                    }
                }
            }
            /** ]p */
            public boolean evalLessThan(Distance d2) {
                Distance d1 = this; 
                if (d1.elemDiff != d2.elemDiff) {
                    return d1.elemDiff < d2.elemDiff;
                } else {
                    if (d1.genericity != d2.genericity) {
                        return d1.genericity < d2.genericity;
                    } else {
                        return d1.valueDiff < d2.valueDiff;
                    }
                }
            }
        }
        /** xNg̓p^[xNg p ƃxNg v Ƃ̊Ԃ̋ԂB  */
        public Distance d(ValuedVec p, ValuedVec v) {
            Distance d = new Distance();
            d.elemDiff = 0;
            d.genericity = 0;
            for (int i = 0; i < p.vec.length; i++) {
                if (p.vec[i] == ValuedVec.WildCard) {
                    d.genericity++;
                } else {
                    if (p.vec[i].equals(v.vec[i])) {
                        // Do nothing.
                    } else {
                        d.elemDiff++;
                    }
                }
            }
            float diff = (float)Math.pow(p.value - v.value, 2);
            d.valueDiff = diff;
            //d.valueDiff = diff < 0 ? -diff : diff;
            d.noiseDiff = Lab.irand(100);
            return d;
        }
        
        public ValuedVec[] kmeans1(ValuedVec[] rvec, ValuedVec[] input) {
            List<List<ValuedVec>> clusters = new ArrayList<List<ValuedVec>>();
            for (int i = 0; i < rvec.length; i++) {
                clusters.add(new ArrayList<ValuedVec>());
            }
            // ł߂NX^Ɋ蓖ĂB
            for (int i = 0; i < input.length; i++) {
                int nearest = 0;
                Distance nearestD = d(rvec[0], input[i]); 
                for (int j = 1; j < rvec.length; j++) {
                    Distance d = d(rvec[j], input[i]);
                    if (d.lessThan(nearestD)) {
                        nearest = j;
                        nearestD = d;
                    }
                }
                clusters.get(nearest).add(input[i]);
            }
            // eNX^kB
            ValuedVec[] ret = new ValuedVec[rvec.length];
            for (int i = 0; i < ret.length; i++) {
                List<ValuedVec> list = clusters.get(i);
                if (list.size() == 0) {
                    list.add(sampleForEmptyCluster(rvec, input));
                }
                ValuedVec[] array = ValuedVec.toArray(list);
                
                if (logVecCompressFlag) printlnArray("vecCompress: vecs", array);
                ValuedVec cvec = ValuedVec.vecCompress(array);
                if (logVecCompressFlag) System.out.println("vecCompress: cvec="+ cvec);
                if (logVecCompressFlag) System.out.println();
                
                ret[i] = cvec; 
            }
            return ret;
        }
        public ValuedVec sampleForEmptyCluster(ValuedVec[] rvec, ValuedVec[] input) {
            return input[Lab.irand(input.length)];
        }
        
        public ValuedVec[] initialVec(int size, ValuedVec[] input) {
            if (initPlusPlusFlag) {
                // ꂼ̋ł邾Ȃ悤ɃxNgIԁB
                ValuedVec[] ret = new ValuedVec[size];
                ret[0] = input[Lab.irand(input.length)];
                for (int r = 1; r < ret.length; r++) {
                    int farthest = -1;
                    Distance farthestD = d(ret[0], ret[0]);
                    for (int i = 0; i < input.length; i++) {
                        // ł߂QƃxNgƂ̋vZB
                        //int nearest = 0;
                        Distance nearestD = d(ret[0], input[i]); 
                        for (int j = 1; j < r; j++) {
                            Distance d = d(ret[j], input[i]);
                            if (d.lessThan(nearestD)) {
                                //nearest = i;
                                nearestD = d;
                            }
                        }
                        if (farthestD.lessThan(nearestD)) {
                            farthest = i;
                            farthestD = nearestD; 
                        }
                    }
                    ret[r] = input[farthest];
                }
                return ret;
            } else {
                // d̂Ȃ悤Ƀ_ size ̃xNgIԁB
                ValuedVec[] ret = new ValuedVec[size];
                for (int i = 0; i < ret.length; i++) {
                    found:
                    {
                        check:
                        for (int c = 0; c < 100; c++) {
                            ValuedVec v = input[Lab.irand(input.length)];
                            for (int j = 0; j < i; j++) {
                                //System.out.println("initialVec: i="+ i+ ", j="+ j);
                                if (v.vec.equals(ret[j].vec)) {
                                    //System.out.println("initialVec: continue: v="+ v+ ", ret[j]="+ ret[j]);
                                    continue check;
                                }
                            }
                            ret[i] = v;
                            break found;
                        }
                        throw new Error("initialVec: unique vector not found");
                    }
                }
                return ret;
            }
        }
        
        // ]B
        public float eval(ValuedVec[] rvec, ValuedVec[] data) {
            float total = 0;
            for (int i = 0; i < data.length; i++) {
                total += eval1(rvec, data[i]);
            }
            return total / data.length;
        }
        public float eval1(ValuedVec[] rvec, ValuedVec v) {
            // QƃxNgPIB
            int nearest = 0;
            Distance nearestD = d(rvec[0], v); 
            for (int j = 1; j < rvec.length; j++) {
                Distance d = d(rvec[j], v);
                if (d.evalLessThan(nearestD)) {
                    nearest = j;
                    nearestD = d;
                }
            }
            // 덷ԂB
            return (float)Math.pow(rvec[nearest].value - v.value, 2);
        }

    }
    
    /** QƃxNg̏d菜o[WB */
    public static class Compress2 extends Compress1 {
        public boolean prioritizedInputFlag = panel.flag("prioritizedInputFlag", false); // ʂȂ
        public boolean removeRvecDupFlag = panel.flag("removeRvecDupFlag", false);
        public boolean prioritizedAsignFlag = panel.flag("prioritizedAsignFlag", false); // ʂȂH
        public int inputDupRate = panel.getInt("inputDupRate", 2, 1, 10);
        
        public ValuedVec[] kmeans1(ValuedVec[] rvec, ValuedVec[] input) {
            if (prioritizedInputFlag) {
                List<ValuedVec> pinput = new ArrayList<>();
                for (int i = 0; i < input.length; i++) {
                    if (largePredictionError(rvec, input[i])) {
                        for (int j = 0; j < inputDupRate; j++) {
                            pinput.add(input[i]);
                        }
                    } else {
                        pinput.add(input[i]);
                    }
                }
                input = ValuedVec.toArray(pinput);
            }

            ValuedVec[] ret = super.kmeans1(rvec, input);

            if (removeRvecDupFlag) {
                nexti:
                    for (int i = 0; i < ret.length; i++) {
                        for (int j = 0; j < i; j++) {
                            //System.out.println("initialVec: i="+ i+ ", j="+ j);
                            if (ret[i].vecEquals(ret[j])) {
                                System.out.println("Compress2: equals: "+ ret[i]+ ", "+ ret[j]);
                                //ret[i] = input[Lab.irand(input.length)]; // ͂d`FbN͂ȂB
                                ret[i] = sampleForEmptyCluster(rvec, input);  // ͂d`FbN͂ȂB
                                continue nexti;
                            }
                        }
                    }
            }
            return ret;
        }
        public ValuedVec sampleForEmptyCluster(ValuedVec[] rvec, ValuedVec[] input) {
            if (prioritizedAsignFlag) {
                for (int i = 0; i < 1000; i++) {
                    ValuedVec v = input[Lab.irand(input.length)];
//                    if (predictionError(rvec, v) * 1 > Lab.rand()) {
//                        return v;
//                    }
                    if (predictionError(rvec, v) > predictionErrorThreshold) {
                        return v;
                    }
                }
                return input[Lab.irand(input.length)];
            } else {
                return input[Lab.irand(input.length)];
            }
        }

        public float predictionErrorThreshold = panel.getFloat("predictionErrorThreshold", 0.1f, 0.0001f, 10f);

        public boolean largePredictionError(ValuedVec[] rvec, ValuedVec v) {
            return predictionError(rvec, v) > predictionErrorThreshold;
        }
        public float predictionError(ValuedVec[] rvec, ValuedVec v) {
            int nearest = 0;
            Distance nearestD = d(rvec[0], v); 
            for (int i = 1; i < rvec.length; i++) {
                Distance d = d(rvec[i], v);
                if (d.lessThan(nearestD)) {
                    nearest = i;
                    nearestD = d;
                }
            }
            float val = (float)Math.pow(rvec[nearest].value - v.value, 2);
            panel.env.viewPanel.println("val", ""+ val);
            return val;
        }
    }

    public static abstract class MainCode extends Lab.MainCode {
        public int maxVecValue = panel.getInt("maxVecValue", 10, 1, 9); 
        public int maxVecElem = panel.getInt("maxVecElem", 100, 1, 100);
        public CompressCode compressCode = panel.getCode("compressCode", CompressCode.class);
        public GeneratorCode generatorCode = panel.getCode("generatorCode", GeneratorCode.class);
        public MainLoopCode mainLoopCode = panel.getCode("mainLoopCode", MainLoopCode.class);
        public int compressIteratoin = panel.getInt("compressIteratoin", 10, 1, 100);
        public void init() {
            generatorCode.init(this);
            mainLoopCode.init(this, generatorCode, compressCode);
        }
    }

    public static abstract class GeneratorCode extends Lab.Code {
        public MainCode mainCode;
        public void init(MainCode mainCode) {
            this.mainCode = mainCode;
        }
        Object __ = ValuedVec.WildCard;
        ValuedVec[] generator;
        public int size() {
            return generator.length;
        }
        public  ValuedVec[] sample(int sampleSize) {
            List<ValuedVec> sampleList = new ArrayList<>();
            for (int i = 0; i < sampleSize; i++) {
                sampleList.add(generator[Lab.irand(generator.length)].makeSample(mainCode.maxVecElem));
            }
            ValuedVec[] sample = ValuedVec.toArray(sampleList);
            return sample;
        }
    }
    public static class Generator2 extends GeneratorCode {
        // anonymous initializer
        {
            this.generator = new ValuedVec[] {
                    new ValuedVec(-3, new Object[] {100, __, __, __, __, __, __}),
                    new ValuedVec(-2, new Object[] {100, 1, __, __, __, __, __}),
                    new ValuedVec(-1, new Object[] {100, 1, 2, __, __, __, __}),
                    new ValuedVec(0, new Object[] {100, 1, 2, 3, __, __, __}),
                    new ValuedVec(-3, new Object[] {101, __, __, __, __, __, __}),
                    new ValuedVec(-2, new Object[] {101, __, __, __, 4, __, __}),
                    new ValuedVec(-1, new Object[] {101, __, __, __, 4, 5, __}),
                    new ValuedVec(0, new Object[] {101, __, __, __, 4, 5, 6}),
            };
            printlnArray(this.getClass().getName()+ ".generator: ", generator);
        }
    }
    public static class Generator1 extends GeneratorCode {
        // anonymous initializer
        {
            this.generator = new ValuedVec[] {
                    new ValuedVec(-3, new Object[] {__, __, __}),
                    new ValuedVec(-2, new Object[] {1, __, __}),
                    new ValuedVec(-1, new Object[] {1, 2, __}),
                    new ValuedVec(0, new Object[] {1, 2, 3}),
            };
            printlnArray(this.getClass().getName()+ ".generator: ", generator);
        }
    }

    public static abstract class MainLoopCode extends Lab.Code {
        public MainCode mainCode;
        public GeneratorCode generatorCode;
        public CompressCode compressCode;
        public void init(MainCode mainCode, GeneratorCode generatorCode, CompressCode compressCode) {
            this.mainCode = mainCode;
            this.generatorCode = generatorCode;
            this.compressCode = compressCode;
        }
        public abstract void mainLoop();
        public int rvecSizeScale = panel.getInt("rvecSizeScale",  2, 1, 100);
        public int sampleSizeScale = panel.getInt("sampleSizeScale",  5, 1, 100);
    }
    public static class MainLoop1 extends MainLoopCode {
        public void mainLoop() {
            int rvecSize = generatorCode.size() * rvecSizeScale;
            int sampleSize = rvecSize * sampleSizeScale;
            ValuedVec[] sample = generatorCode.sample(sampleSize);
            ValuedVec[] rvec = compressCode.initialVec(rvecSize, sample);
            for (int i = 0; i < mainCode.compressIteratoin; i++) {
                if (compressCode.logCompress1Flag) printlnArray("main loop: i="+ i+ ": rvec", ValuedVec.sort(rvec));
                sample = generatorCode.sample(sampleSize);
                if (compressCode.logCompress1Flag) printlnArray("sample", sample);
                rvec = compressCode.kmeans1(rvec, sample);
            }
            printlnArray("main loop: result: rvec", ValuedVec.sort(rvec));
        }
    }
    // ĉ덷Otɂo[WBwK͍ŏɍTv݂̂gB
    public static class MainLoop2 extends MainLoopCode {
        public void mainLoop() {
            int rvecSize = generatorCode.size() * rvecSizeScale;
            int sampleSize = rvecSize * sampleSizeScale;
            ValuedVec[] trainingData = generatorCode.sample(sampleSize);
            ValuedVec[] testData = generatorCode.sample(sampleSize * 10);
            ValuedVec[] rvec = compressCode.initialVec(rvecSize, trainingData);
            for (int i = 0; i < mainCode.compressIteratoin; i++) {
                if (compressCode.logCompress1Flag) printlnArray("main loop: i="+ i+ ": rvec", ValuedVec.sort(rvec));
                //trainingData = generatorCode.sample(sampleSize);
                if (compressCode.logCompress1Flag) printlnArray("sample", trainingData);
                rvec = compressCode.kmeans1(rvec, trainingData);
                // Pf[^ŌvZ\덷B𒼐ڍœKĂ킯ł͂Ȃ_ɒӁB
                env.viewPanel.linePlotFixedY("training error", i, compressCode.eval(rvec, trainingData), 0, 1);
                env.viewPanel.linePlotFixedY("test error", i, compressCode.eval(rvec, testData), 0, 1);
                //env.viewPanel.linePlotFixedY("test error", i, compressCode.eval(rvec, testData), 0, 0.5f);
            }
            printlnArray("main loop: result: rvec", ValuedVec.sort(rvec));
        }
    }
    // k numTrial sl̔ĉ덷̕ςvZB
    public static class MainLoop3 extends MainLoopCode {
        public int numTrial = panel.getInt("numTrial", 3, 1, 100);
        public String resultLabel = "Result";
        public void mainLoop() {
            float totalTrainingError = 0;
            float totalTestError = 0;
            float trainingError = 0;
            float testError = 0;
            
            int rvecSize = generatorCode.size() * rvecSizeScale;
            int sampleSize = rvecSize * sampleSizeScale;
            for (int trial = 0; trial < numTrial; trial++) {
                ValuedVec[] trainingData = generatorCode.sample(sampleSize);
                ValuedVec[] testData = generatorCode.sample(sampleSize * 10);
                ValuedVec[] rvec = compressCode.initialVec(rvecSize, trainingData);

                trainingError = compressCode.eval(rvec, trainingData);
                testError = compressCode.eval(rvec, testData);
                env.viewPanel.linePlotFixedY(trial+ ": training error", 0, trainingError, 0, 1);
                env.viewPanel.linePlotFixedY(trial+ ": test error", 0, testError, 0, 1);

                for (int i = 0; i < mainCode.compressIteratoin; i++) {
                    if (compressCode.logCompress1Flag) printlnArray("main loop: i="+ i+ ": rvec", ValuedVec.sort(rvec));
                    if (compressCode.logCompress1Flag) printlnArray("sample", trainingData);

                    rvec = compressCode.kmeans1(rvec, trainingData);

                    trainingError = compressCode.eval(rvec, trainingData);
                    testError = compressCode.eval(rvec, testData);
                    env.viewPanel.linePlotFixedY(trial+ ": training error", i+1, trainingError, 0, 1);
                    env.viewPanel.linePlotFixedY(trial+ ": test error", i+1, testError, 0, 1);
                }
                totalTrainingError += trainingError;
                totalTestError += testError;
                System.out.println("trial = "+ trial);
                printlnArray("main loop: result: rvec", ValuedVec.sort(rvec));
            }
            env.viewPanel.println(resultLabel, "rvecSize = "+ rvecSize);
            env.viewPanel.println(resultLabel, "initPlusPlusFlag = "+ compressCode.initPlusPlusFlag);
            env.viewPanel.println(resultLabel, "valueDistanceFlag = "+ compressCode.valueDistanceFlag);
            env.viewPanel.println(resultLabel, "Mean training error = "+ totalTrainingError / numTrial);
            env.viewPanel.println(resultLabel, "Mean test error = "+ totalTestError / numTrial);
            env.viewPanel.println(resultLabel, "");
        }
    }
    
    public static class TestMain1 extends MainCode {
        public void main() {
            init();
            mainLoopCode.mainLoop();
        }
    }   

    // gW[ĂȂꖇ̎B
//    public static class TestMain0 extends MainCode {
//        public void main() {
//            Object __ = ValuedVec.WildCard;
//            ValuedVec[] generator = {
//                    new ValuedVec(3, new Object[] {__, __, __}),
//                    new ValuedVec(2, new Object[] {__, __, 3}),
//                    new ValuedVec(1, new Object[] {__, 2, 3}),
//                    new ValuedVec(0, new Object[] {1, 2, 3}),
//            };
//            printlnArray("generator", generator);
//            
//            int sampleSize = generator.length * panel.getInt("sampleSize",  10, 1, 100);
//            
//            ValuedVec[] sample = sample(sampleSize, generator);
//            ValuedVec[] rvec = compressCode.initialVec(generator.length * 2, sample);
//            //ValuedVec[] rvec = compressCode.initialVec(generator.length, sample);
//            for (int i = 0; i < compressIteratoin; i++) {
//                if (compressCode.logCompress1Flag) printlnArray("main loop: i="+ i+ ": rvec", ValuedVec.sort(rvec));
//                sample = sample(sampleSize, generator);
//                if (compressCode.logCompress1Flag) printlnArray("sample", sample);
//                rvec = compressCode.kmeans1(rvec, sample);
//            }
//            printlnArray("main loop: result: rvec", ValuedVec.sort(rvec));
//        }
//        
//        public  ValuedVec[] sample(int sampleSize, ValuedVec[] generator) {
//            List<ValuedVec> sampleList = new ArrayList<>();
//            for (int i = 0; i < sampleSize; i++) {
//                sampleList.add(generator[Lab.irand(generator.length)].makeSample(maxVecElem));
//            }
//            ValuedVec[] sample = ValuedVec.toArray(sampleList);
//            return sample;
//        }
//    }

    
}
