Require Import Bool.
Require Import EqNat.
Require Import List.

Require Import Rbase.
Require Import Rbasic_fun.
Require Import Fourier.

Lemma beq_nat_dec : forall b b', beq_nat b b' = true \/ beq_nat b b' = false.
  intros; destruct (beq_nat b b'); auto.
Qed.

Lemma beq_nat_false : forall x y, x <> y -> beq_nat x y = false.
intros.
assert (beq_nat x y <> true).
red; intro; apply H.
apply beq_nat_eq; auto.
apply not_true_is_false;
auto.
Qed.

Lemma beq_nat_false' : forall x y, beq_nat x y = false -> x <> y.
intros.
intro.
subst x.
rewrite <- beq_nat_refl in H; discriminate.
Qed.

Lemma beq_nat_com : forall a b, beq_nat a b = beq_nat b a.
induction a; destruct b; simpl; auto.
Qed.

Lemma negb_eq_true : forall b,
  negb b = true -> b = false.
  intros.
  destruct b; auto||discriminate.
Qed.

Open Local Scope R_scope.

Definition Rdifference_lemma_helper : forall a b c c',
  0 <= a <= c -> 0 <= b <= c' ->
  Rabs (a - b) <= Rmax c c'.
intros.
inversion_clear H.
inversion_clear H0.
generalize (Rtotal_order a b); intro.
inversion_clear H0.
rewrite Rabs_minus_sym.
rewrite Rabs_right.
apply (Rle_trans (b-a) b).
fourier.
eapply Rle_trans; eauto.
apply RmaxLess2.
fourier.
inversion_clear H4.
subst b.
rewrite Rminus_diag_eq; auto.
rewrite Rabs_R0.
eapply Rle_trans; eauto.
eapply Rle_trans; eauto.
apply RmaxLess2.
rewrite Rabs_right.
apply (Rle_trans (a-b) a).
fourier.
eapply Rle_trans; eauto.
apply RmaxLess1.
fourier.
Qed.


Lemma Rmax_refl : forall r, r = Rmax r r.
   intro.
   unfold Rmax.
   destruct (Rle_dec r r).
   auto.
   elim n; apply Rle_refl.
Qed.


Lemma Rabs_def1_eq : forall x a:R, x <= a -> - a <= x -> Rabs x <= a.
Proof.
  unfold Rabs in |- *; intros; case (Rcase_abs x); intro.
  inversion H0.
  red.
  left.
  generalize (Ropp_lt_gt_contravar (- a) x H1); unfold Rgt in |- *;
    rewrite Ropp_involutive; intro; assumption.
  right; subst.
  field.
  assumption.
Qed.


(***********************)
(*  inb, Sum, nth_tail *)
(***********************)

Section BPred.

  Variable A : Set.
  Variable eq_A : A -> A -> bool.
  
  Fixpoint inb (a:A) (lst:list A) : bool :=
    match lst with
      | nil => false
      | hd :: tl => orb (eq_A a hd) (inb a tl)
    end.

End BPred.

Definition inb_ := inb nat beq_nat.

Lemma In_inb_true: forall l e,
  inb_ e l = true <-> In e l.
  induction l; simpl; split; intros.

  discriminate.
  contradiction.
  generalize (IHl e); clear IHl; intros.
  generalize (beq_nat_eq e a); intro.
  destruct (beq_nat e a).
  left.
  intuition.
  destruct (inb_ e l); simpl in H; try discriminate.

  intuition.
  inversion_clear H.
  subst a; rewrite <- beq_nat_refl; auto.
  generalize ((proj2 (IHl e)) H0); intros.
  intuition.
Qed.

Lemma not_In_inb_true: forall l e,
  inb_ e l = false <-> ~ In e l.

  induction l; simpl; split; intros.
  tauto.
  auto.
  generalize (IHl e); clear IHl; intros.
  generalize (beq_nat_false' e a); intros.
  destruct (beq_nat e a); simpl in H; try discriminate.
  destruct (inb_ e l); simpl in H; try discriminate.

  intuition.
  assert (e <> a /\ ~ In e l) by (tauto || intuition).
  clear H; inversion_clear H0.
  rewrite (beq_nat_false _ _ H).
  rewrite ((proj2 (IHl e)) H1); auto.
Qed.

Lemma inb_nth : forall l n,
  inb_ n l = true ->
  exists i, (i < length l)%nat /\ nth i l O = n.
  induction l; intros.
  discriminate.
  simpl in H.
  destruct (beq_nat_dec n a).
  symmetry in H0.
  apply beq_nat_eq in H0.
  subst n.
  exists O.
  simpl; split; [omega | auto].
  apply beq_nat_false' in H0.
  rewrite beq_nat_false in H; auto.
  simpl in H.
  generalize (IHl _ H); intro X; inversion_clear X.
  exists (S x).
  simpl; split; [omega | tauto].
Qed.

Fixpoint Sum (min span:nat) (f:nat -> R) {struct span} : R :=
  match span with
    | O => 0
    | S n' => f min + Sum (S min) n' f
  end.

Lemma Sum_cst : forall span min k f,
  (forall n, (n<min+span)%nat -> f n = k) ->
  Sum min span f = INR span * k.
  induction span; intros.
  simpl.
  field.
  simpl Sum.
  rewrite S_INR.
  assert (forall n : nat, (n < (S min) + span)%nat -> f n = k).
  intros.
  rewrite H.
  auto.
  omega.
  rewrite (IHspan (S min) k f H0).
  rewrite H.
  field.
  omega.
Qed.

Lemma Sum_gt0: forall span min f,
  (forall x, (x >= min /\ x < min + span)%nat -> f x >= 0) ->
  Sum min span f >= 0.
  induction span; simpl; intros.
  intuition.
  assert (forall x : nat, (x >= S min)%nat /\ (x < S min + span)%nat -> f x >= 0).
  intros.
  inversion_clear H0.
  eapply H.
  omega.
  generalize (IHspan _ _ H0); intros.
  assert (f min >= 0).
  eapply H.
  omega.
  fourier.
Qed.  

Lemma Sum_ext: forall span min f1 f2,
  (forall x, (x >= min /\ x < min + span)%nat -> f1 x = f2 x) ->
  Sum min span f1 = Sum min span f2.
  induction span; simpl.
  intuition.
  intros.
  assert (f1 min = f2 min).
  eapply H; intros; omega.
  rewrite H0; clear H0.
  assert (forall x : nat,
            (x >= S min)%nat /\ (x < S min + span)%nat -> f1 x = f2 x).
  intros; eapply H; omega.
  rewrite (IHspan _ _ _ H0); auto.
Qed.

Lemma Sum_ext2: forall span min min' f1 f2,
  (forall x, O <= x < span -> f1 (min + x) = f2 (min' + x))%nat ->
  Sum min span f1 = Sum min' span f2.
  induction span; intros; simpl; auto.
  assert (f1 min = f2 min').      
  lapply (H O); try omega.
  repeat rewrite <- plus_n_O.
  auto.
  rewrite <- H0.
  apply Rplus_eq_compat_l.
  apply IHspan.
  intros.
  lapply (H (S x)); try omega.
  repeat rewrite plus_Snm_nSm.
  auto.
Qed.

Lemma Sum_add: forall span min f1 f2,
  Sum min span f1 + Sum min span f2 = Sum min span (fun x => f1 x + f2 x).
  induction span; simpl; intros.
  field.
  rewrite <- IHspan.
  field.
Qed.  

Lemma Sum_max : forall span min f,
  span <> O ->
  exists m, (min <= m < min + span)%nat /\ Sum min span f <= (INR span) * f m.
induction span; intros; try tauto.
destruct span; clear H.
clear IHspan.
exists min.
split; try omega.
rewrite S_INR.
simpl.
fourier.
lapply (IHspan (S min) f); [intro | omega].
inversion_clear H as [m].
inversion_clear H0.
generalize (Rle_or_lt (f m) (f min)); intro X; inversion_clear X.
exists min.
split.
omega.
simpl Sum.
rewrite S_INR.
assert ( (f (S min) + Sum (S (S min)) span f) <= INR (S span) * f min).
apply Rle_trans with (INR (S span) * f m).
simpl Sum in H1.
auto.
apply Rmult_le_compat_l.
apply pos_INR.
auto.
rewrite Rmult_plus_distr_r.
fourier.
exists m.
split.
omega.
rewrite S_INR.
simpl Sum.
simpl Sum in H1.
rewrite Rmult_plus_distr_r.
fourier.
Qed.

Fixpoint nth_tail (A: Set) (l: list A) (n: nat) {struct n} : list A :=
  match n with
    | 0 => l
    | S n' => nth_tail A (tail l) n'
  end.
Implicit Arguments nth_tail [A].

Lemma nth_tail_length: forall (A: Set) (l: list A) n,
  (length (nth_tail l n) = length l - n)%nat.
  induction l.
  induction n; simpl; auto.
  destruct n; simpl; auto.
Qed.
Implicit Arguments nth_tail_length [A].

Lemma nth_tail_S_n: forall (A: Set) (l: list A) n default,
  (length l > n)%nat ->
  nth_tail l n = (nth n l default) :: nth_tail l (S n).
  induction l; simpl; intros.
  assert (False) by omega; contradiction.
  destruct n; auto.
  simpl; simpl in IHl; intuition.
Qed.
Implicit Arguments nth_tail_S_n [A].

Lemma nth_tail_nth: forall (A: Set)  (l: list A) n default,
  length l = S n ->
  nth_tail l n =  nth n l default :: nil.
  intros.
  assert (length l > n)%nat by omega.
  rewrite (nth_tail_S_n _ _ default H0).
  generalize (nth_tail_length l (S n)); intros.
  rewrite H in H1.
  assert (S n - S n = 0)%nat by omega.
  rewrite H2 in H1.
  destruct (nth_tail l (S n)); auto; simpl in H1; try discriminate.
Qed.
Implicit Arguments nth_tail_nth [A].

Lemma In_nth : forall l n,
  In n l  ->
  exists i, (i < length l)%nat /\ nth i l O = n.
  induction l; intros.
  simpl in H.
  tauto.
  simpl in H.
  inversion_clear H.
  subst a.
  exists O.      
  split.
  simpl.
  omega.
  auto.
  apply IHl in H0.
  inversion_clear H0 as [i]; exists (S i).
  split.
  simpl; omega.
  simpl; tauto.
Qed.

(* lemmas about FSetList *)

Require OrderedTypeEx.

Require FSetList.  
Module NatSet := FSetList.Make (OrderedTypeEx.Nat_as_OT).

Require FSetProperties.
Module NatSetProp := FSetProperties.Properties (NatSet).

(*Require FSetFacts.
Module NatSetFacts := FSetFacts.Facts (NatSet).*)

Notation "s [=] t" := (NatSet.Equal s t) (at level 70, no associativity).

Lemma union_empty : forall l1 l2,
  NatSet.union l1 l2 [=] NatSet.empty ->
  NatSet.Empty l1 /\ NatSet.Empty l2.
  intros.
  assert ( NatSet.Subset l1 (NatSet.empty) /\ NatSet.Subset l2 (NatSet.empty) ).
  rewrite <-H.
  split; [apply NatSetProp.union_subset_1 | apply NatSetProp.union_subset_2].
  inversion_clear H0.
  apply NatSetProp.subset_cardinal in H1.
  apply NatSetProp.subset_cardinal in H2.
  rewrite NatSetProp.empty_cardinal in H1.
  rewrite NatSetProp.empty_cardinal in H2.
  assert ( NatSet.cardinal l1 = O /\ NatSet.cardinal l2 = O).
  omega.
  inversion_clear H0.
  apply NatSetProp.cardinal_inv_1 in H3.
  apply NatSetProp.cardinal_inv_1 in H4.
  auto.
Qed.

Lemma Empty_empty : forall l,
  NatSet.Empty l -> l [=] NatSet.empty.
  intros.
  apply NatSetProp.empty_is_empty_1; auto.
Qed.

Ltac inj1 H me := injection H; clear H; let X := fresh in intro X; subst me.

