Require Import EqNat.
Require Import Peano_dec.
Require Import Bool.
Require Import List.
Require Import Rbase.
Require Import Rbasic_fun.

Require Import distrib.
Require Import util.
Require Import game.
Require Import random.
Require Import preserv.

Open Local Scope game_scope.
Open Local Scope R_scope.
Open Local Scope distrib_scope.

Lemma bad_is_set : forall g st st' bad,
 g ||- st -- bad <- int_e 1 --> st' ->
   Pr (sets bad 1) st' = sum st'.
 intros.
 unfold sets.
 eapply exec_assign_Pr.
 apply H.
Qed.

(***************** identical_until_bad ********************)

Lemma identical_until_bad_step : forall g b c1 c2 c2' st st' st0 st'0 bad,
  no_assign_cmd bad c1 ->
  no_assign_cmd bad c2 ->
  no_assign_cmd bad c2' ->
  no_assign bad g ->
  coeff_pos st ->
  coeff_pos st' ->
  Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
  g ||- st -- ifte b c1 (bad <- int_e 1; c2) --> st0 ->
    g ||- st' -- ifte b c1 (bad <- int_e 1; c2') --> st'0 ->
      Permutation (filter (cplt (sets bad 1)) st0) (filter (cplt (sets bad 1)) st'0).
  intros.
  inversion_clear H6.
  inversion_clear H7.
  do 2 rewrite filter_app.
  apply Permutation_app.

  eapply no_assign_permute; eauto.
  rewrite H8; rewrite H6.
  rewrite filter_conj.
  apply Permutation_sym.
  rewrite filter_conj.
  rewrite filter_inter_com.
  apply Permutation_sym.
  rewrite filter_inter_com.
  rewrite <- filter_conj.
  apply Permutation_sym.
  rewrite <- filter_conj.
  apply filter_permute.
  apply Permutation_sym.
  auto.

  inversion_clear H11.
  assert (Pr (sets bad 1) st'' = sum st'').
  unfold sets.
  eapply exec_assign_Pr.
  apply H7.
  assert (Pr (cplt (sets bad 1)) st'' = 0).
  rewrite Pr_cplt.
  rewrite H11; auto with real.

  inversion_clear H14.
  assert (Pr (sets bad 1) st''0 = sum st''0).
  unfold sets.
  eapply exec_assign_Pr.
  apply H17.
  assert (Pr (cplt (sets bad 1)) st''0 = 0).
  rewrite Pr_cplt.
  rewrite H14; auto with real.
  
  rewrite Pr_0_filter.
  rewrite Pr_0_filter.
  apply Permutation_refl.
  eapply exec_conserv_coeff_pos; eauto.
  eapply exec_conserv_coeff_pos; eauto.
  rewrite H12.
  apply coeff_pos_filter; auto.
  rewrite <- H19.
  symmetry.
  eapply preserves_cplt_sets_event; eauto.
  eapply exec_conserv_coeff_pos; eauto.
  eapply exec_conserv_coeff_pos; eauto.
  rewrite H9.
  apply coeff_pos_filter; auto.
  rewrite <- H16.
  symmetry.
  eapply preserves_cplt_sets_event; eauto.
Qed.  

Lemma identical_until_bad : forall g (c0:nat -> cmd) b bad c1 c2 c2' c3 q st st' st0 st0'
  (H_c1: no_assign_cmd bad c1)
  (H_c2: no_assign_cmd bad c2)
  (H_c2': no_assign_cmd bad c2')
  (H_g: no_assign bad g) (Hc0:forall i, no_assign_cmd bad (c0 i))
  (H_c3: no_assign_cmd bad c3),
  coeff_pos st ->
  coeff_pos st' ->
  Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
  g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2) ; c3) --> st0 ->
    g ||- st' -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2'); c3) --> st0' ->
      Permutation (filter (cplt (sets bad 1)) st0) (filter (cplt (sets bad 1)) st0').
  
  induction q; intros.
  inversion H2.
  inversion H3.
  subst st0 st0'; auto.
  
  (* induction step *)
  inversion_clear H2 as [ | | | | | | ? st1 ? ? ? ? ? | | ].
  inversion_clear H3 as [ | | | | | | ? st1' ? ? ? ? ? | | ].
  
  assert (
    Permutation (filter (cplt (sets bad 1)) st1) (filter (cplt (sets bad 1)) st1')).
  apply (IHq st st'); auto.
  clear IHq.
  
  inversion_clear H5 as [ | | | | | | ? st3 ? ? ? ? ? | | ].
  inversion_clear H7 as [ | | | | | | ? st2 ? ? ? ? ? | | ].
  inversion_clear H6 as [ | | | | | | ? st3' ? ? ? ? ? | | ].
  inversion_clear H7 as [ | | | | | | ? st2' ? ? ? ? ? | | ].
  
  assert (Hc0q: Permutation (filter (cplt (sets bad 1)) st2)
    (filter (cplt (sets bad 1)) st2')).
  apply (no_assign_permute g (c0 q) st1 st2 H5 bad H_g (Hc0 q) st1' st2'); try tauto; auto.
  
  assert (Hpos_st2: coeff_pos st2).
  eapply exec_conserv_coeff_pos.
  apply H5.
  eapply exec_conserv_coeff_pos.
  apply H4.
  auto.
  
  assert (Hpos_st2': coeff_pos st2').
  eapply exec_conserv_coeff_pos.
  apply H6.
  eapply exec_conserv_coeff_pos.
  apply H2.
  auto.
  
  apply (no_assign_permute g c3 _ _ H8 _ H_g H_c3 _ _ H10); auto.
  apply (identical_until_bad_step g b c1 c2 c2' st2 st2' st3 st3' bad); auto.
Qed.

(***************** after_bad_is_set ********************)

Lemma after_bad_is_set_step : forall g b c1 c2 c2' st st' st0 st'0 bad
  (H_c1: no_assign_cmd bad c1)
  (H_c2: no_assign_cmd bad c2)
  (H_c2': no_assign_cmd bad c2')
  (H_g: no_assign bad g),
  coeff_pos st ->
  coeff_pos st' ->
  sum st = sum st' ->
  Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
  g ||- st  -- ifte b c1 (bad <- int_e 1 ; c2 ) --> st0  ->
    g ||- st' -- ifte b c1 (bad <- int_e 1 ; c2') --> st'0 ->
      Pr (sets bad 1) st0 = Pr (sets bad 1) st'0.
  
  intros.
  apply Pr_eq_permute.
  rewrite <- (exec_conserv g _ st st0 H3).
  rewrite <- (exec_conserv _ _ st' st'0 H4).
  auto.
  eapply (identical_until_bad_step g b c1 c2 c2' st st' st0 st'0); eauto.
Qed.

Lemma after_bad_is_set : forall g (c0:nat -> cmd) b bad c1 c2 c2' c3 q st st' st0 st0'
  (H_c1: no_assign_cmd bad c1)
  (H_c2: no_assign_cmd bad c2)
  (H_c2': no_assign_cmd bad c2')
  (H_g: no_assign bad g) (Hc0:forall i, no_assign_cmd bad (c0 i))
  (H_c3: no_assign_cmd bad c3),
  coeff_pos st ->
  coeff_pos st' ->
  sum st = sum st' ->
  Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
  g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2) ; c3) --> st0 ->
    g ||- st' -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2'); c3) --> st0' ->
      Pr (sets bad 1) st0 = Pr (sets bad 1) st0'.

 induction q; intros.
 inversion H3.
 inversion H4.
 subst st0 st0'.
 apply Pr_eq_permute; auto.

 (* induction step *)
 inversion_clear H3 as [ | | | | | | ? st1 ? ? ? ? ? | | ].
 inversion_clear H4 as [ | | | | | | ? st1' ? ? ? ? ? | | ].

 assert ( Pr (sets bad 1) st1 = Pr (sets bad 1) st1').
 apply (IHq st st'); auto.
 clear IHq.

 inversion_clear H6 as [ | | | | | | ? st3 ? ? ? ? ? | | ].
 inversion_clear H8 as [ | | | | | | ? st2 ? ? ? ? ? | | ].
 inversion_clear H7 as [ | | | | | | ? st3' ? ? ? ? ? | | ].
 inversion_clear H8 as [ | | | | | | ? st2' ? ? ? ? ? | | ].

 assert (Hpos_st2: coeff_pos st2).
 eapply exec_conserv_coeff_pos.
 apply H6.
 eapply exec_conserv_coeff_pos.
 apply H5.
 auto.

 assert (Hpos_st2': coeff_pos st2').
 eapply exec_conserv_coeff_pos.
 apply H7.
 eapply exec_conserv_coeff_pos.
 apply H3.
 auto.

 rewrite <- (preserves_sets_event _ _ _ _ H9); auto.
 rewrite <- (preserves_sets_event _ _ _ _ H11); auto.

 eapply (after_bad_is_set_step g b c1 c2 c2' st2 st2'); eauto.
 rewrite <- (exec_conserv _ _ _ _ H6).
 rewrite <- (exec_conserv _ _ _ _ H7).
 rewrite <- (exec_conserv _ _ _ _ H5).
 rewrite <- (exec_conserv _ _ _ _ H3).
 auto.

 apply (no_assign_permute g (c0 q) st1 st2 H6 bad H_g (Hc0 q) st1' st2'); auto.
 eapply (identical_until_bad g c0 b bad c1 c2 c2' c3 q st st' st1 st1'); eauto.
Qed.


(* should be proved using the above lemma *)
Lemma simplified_after_bad_is_set : forall g b c1 c2 c2' st st' st'' bad
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g),
 coeff_pos st ->
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st' ->
   g ||- st -- ifte b c1 (bad <- int_e 1 ; c2') --> st'' ->
     Pr (sets bad 1) st' = Pr (sets bad 1) st''.
  
 intros.
 eapply (after_bad_is_set_step g b c1 c2 c2'); eauto.
 apply Permutation_refl.
Qed.

(*********************************************************************)

Lemma fundamental_lemma_step : forall g b c1 c2 c2' st st' st0 st0' f bad
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g)
 (st_pos: coeff_pos st)
 (st'_pos: coeff_pos st'),
 sum st = sum st' ->
 Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st0 ->
   g ||- st' -- ifte b c1 (bad <- int_e 1 ; c2') --> st0' ->
     Rabs (Pr f st0 - Pr f st0') <= Pr (sets bad 1) st0.

 intros.
 assert (st0_pos: coeff_pos st0).
 eapply exec_conserv_coeff_pos; eauto.
 assert (st0'_pos: coeff_pos st0').
 eapply exec_conserv_coeff_pos; eauto.

 rewrite Rmax_refl.
 eapply (abstract_fundamental_lemma st0 st0' f f (sets bad 1) (sets bad 1)); eauto.

 eapply Pr_pos; eauto.
 eapply Pr_pos; eauto.
 rewrite <- (exec_conserv g _ _ st0  H1).
 rewrite <- (exec_conserv g _ _ st0' H2); auto.
 apply sym_eq.

 eapply (after_bad_is_set_step g b c1 c2 c2' st st' st0 st0'); eauto.
 apply Pr_inter_cplt.

 eapply (identical_until_bad_step g b c1 c2 c2' st st' st0 st0'); eauto.
Qed.

Lemma fundamental_lemma : forall g (c0:nat -> cmd) b bad c1 c2 c2' c3 f q st st' st0 st0'
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g) (Hc0:forall i, no_assign_cmd bad (c0 i))
 (H_c3: no_assign_cmd bad c3)
 (st_pos: coeff_pos st)
 (st'_pos: coeff_pos st'),
 sum st = sum st' ->
 Permutation (filter (cplt (sets bad 1)) st) (filter (cplt (sets bad 1)) st') ->
 g ||- st  -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2) ; c3) --> st0  ->
   g ||- st' -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2'); c3) --> st0' ->
     Rabs (Pr f st0 - Pr f st0') <= Pr (sets bad 1) st0.
  
 intros.
 assert (Hident:
   Permutation (filter (cplt (sets bad 1)) st0) (filter (cplt (sets bad 1)) st0')).
 eapply (identical_until_bad g c0 b bad c1 c2 c2' c3 q st st' st0 st0'); eauto.
 assert (Hafter: Pr (sets bad 1) st0 = Pr (sets bad 1) st0').
 eapply (after_bad_is_set g c0 b bad c1 c2 c2' c3 q st st' st0 st0'); eauto.

 rewrite (Pr_cases f (sets bad 1)).
 rewrite (Pr_cases f (sets bad 1)).

 assert (X: Pr (f //\\ (cplt (sets bad 1))) st0 = Pr (f //\\ (cplt (sets bad 1))) st0').
 apply Pr_inter_cplt; tauto.

 rewrite X.
 unfold Rminus.
 rewrite Rplus_assoc.
 rewrite (Rplus_comm (Pr (f //\\ (sets bad 1)) st0')).
 rewrite Ropp_plus_distr.
 rewrite <- (Rplus_assoc (Pr (f //\\ (cplt (sets bad 1))) st0')).
 rewrite (Rplus_comm (Pr (f //\\ (cplt (sets bad 1))) st0')).
 rewrite Rplus_opp_l.
 rewrite Rplus_0_l.

 change (Pr (f //\\ (sets bad 1)) st0 + - Pr (f //\\ (sets bad 1)) st0')
   with (Pr (f //\\ (sets bad 1)) st0 - Pr (f //\\ (sets bad 1)) st0').
 rewrite Rmax_refl.
 apply Rdifference_lemma_helper.

 split.
 apply Pr_pos.
 eapply exec_conserv_coeff_pos.
 apply H1.
 auto.
 apply Pr_inter_le.
 eapply exec_conserv_coeff_pos.
 apply H1.
 auto.

 split.
 apply Pr_pos.
 eapply exec_conserv_coeff_pos.
 apply H2.
 auto.
 rewrite Hafter.
 apply Pr_inter_le.
 eapply exec_conserv_coeff_pos.
 apply H2.
 auto.
Qed.

Lemma fundamental_lemma_helper : forall g (c0:nat -> cmd) b bad c1 c2 c2' c3 q st st' st''
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g) (Hc0:forall i, no_assign_cmd bad (c0 i))
 (H_c3: no_assign_cmd bad c3),

 coeff_pos st ->

 g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2) ; c3) --> st' ->
 g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2'); c3) --> st'' ->

  Permutation (filter (cplt (sets bad 1)) st') (filter (cplt (sets bad 1)) st'')
  /\
  Pr (sets bad 1) st' = Pr (sets bad 1) st''.

 intros.
 split;
 [eapply (identical_until_bad g c0 b bad c1 c2 c2' c3 q st st st' st'')
 | eapply (after_bad_is_set g c0 b bad c1 c2 c2' c3 q st st st' st'')];
 eauto; apply Permutation_refl.
Qed.

Lemma fundamental_lemma0 : forall g (c0:nat -> cmd) b bad c1 c2 c2' c3 f q st st' st''
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g) (Hc0:forall i, no_assign_cmd bad (c0 i))
 (H_c3: no_assign_cmd bad c3),

 coeff_pos st ->

 g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2) ; c3) --> st' ->
 g ||- st -- loop q (fun i => c0 i ; ifte b c1 (bad <- int_e 1 ; c2'); c3) --> st'' ->

 Rabs (Pr f st' - Pr f st'') <= Pr (sets bad 1) st'.

 intros.
 assert (Hlemma:
   Permutation (filter (cplt (sets bad 1)) st') (filter (cplt (sets bad 1)) st'') /\
      Pr (sets bad 1) st' = Pr (sets bad 1) st'').
 eapply (fundamental_lemma_helper g c0 b bad c1 c2 c2' c3 q st st' st''); eauto.

 rewrite (Pr_cases f (sets bad 1)).
 rewrite (Pr_cases f (sets bad 1)).

 assert (X: Pr (f //\\ (cplt (sets bad 1))) st' = Pr (f //\\ (cplt (sets bad 1))) st'').
 apply Pr_inter_cplt; tauto.

 rewrite X.
 unfold Rminus.
 rewrite Rplus_assoc.
 rewrite (Rplus_comm (Pr (f //\\ (sets bad 1)) st'')).
 rewrite Ropp_plus_distr.
 rewrite <- (Rplus_assoc (Pr (f //\\ (cplt (sets bad 1))) st'')).
 rewrite (Rplus_comm (Pr (f //\\ (cplt (sets bad 1))) st'')).
 rewrite Rplus_opp_l.
 rewrite Rplus_0_l.

 change (Pr (f //\\ (sets bad 1)) st' + - Pr (f //\\ (sets bad 1)) st'')
   with (Pr (f //\\ (sets bad 1)) st' - Pr (f //\\ (sets bad 1)) st'').
 rewrite Rmax_refl.
 apply Rdifference_lemma_helper.

 split.
 apply Pr_pos.
 eapply exec_conserv_coeff_pos.
 apply H0.
 auto.
 apply Pr_inter_le.
 eapply exec_conserv_coeff_pos.
 apply H0.
 auto.

 split.
 apply Pr_pos.
 eapply exec_conserv_coeff_pos.
 apply H1.
 auto.
 inversion_clear Hlemma as [Hlemma0 Hlemma1].
 rewrite Hlemma1.
 apply Pr_inter_le.
 eapply exec_conserv_coeff_pos.
 apply H1.
 auto.
Qed.


(*******************************************************************)

(* specialized version of the fundamental_lemma of game playing *)

(* proved with the new abstract_fundamental_lemma, together with after_bad_is_set and
  identical_until_bad *)
Lemma simplified_fundamental_lemma4 : forall g b c1 c2 c2' st st' st'' f bad
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g)
 (st_pos: coeff_pos st),
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st' ->
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2') --> st'' ->

 Rabs (Pr f st' - Pr f st'') <= Pr (sets bad 1) st'.

 intros.
 assert (coeff_pos st').
 eapply exec_conserv_coeff_pos; eauto.
 assert (coeff_pos st'').
 eapply exec_conserv_coeff_pos; eauto.

 rewrite Rmax_refl.
 eapply (abstract_fundamental_lemma st' st'' f f (sets bad 1) (sets bad 1)); eauto.

 eapply Pr_pos; eauto.
 eapply Pr_pos; eauto.
 rewrite <- (exec_conserv g _ _ st' H).
 rewrite <- (exec_conserv g _ _ st'' H0); auto.
 apply sym_eq.

 eapply (after_bad_is_set_step g b c1 c2 c2' st st st' st''); eauto.
 apply Permutation_refl.
 apply Pr_inter_cplt.
 eapply (identical_until_bad_step g b c1 c2 c2' st st st' st''); eauto.
 apply Permutation_refl.
Qed.

(* proved using identical_until_bad *)
Lemma simplified_fundamental_lemma3 : forall g b c1 c2 c2' st st' st'' f bad
  (H_c1: no_assign_cmd bad c1)
  (H_c2: no_assign_cmd bad c2)
  (H_c2': no_assign_cmd bad c2')
  (H_g: no_assign bad g)
  (st_pos: coeff_pos st),
  g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st' ->
    g ||- st -- ifte b c1 (bad <- int_e 1 ; c2') --> st'' ->
      Rabs ( Pr f st' - Pr f st'' ) <= Pr (sets bad 1) st'.
  intros.
  do 2 rewrite (Pr_cases f (sets bad 1)).
  
  assert (Pr (f //\\ (cplt (sets bad 1))) st' = Pr (f //\\ (cplt (sets bad 1))) st'').
  apply Pr_inter_cplt.
  eapply (identical_until_bad_step g b c1 c2 c2'); eauto.
  apply Permutation_refl.
  rewrite H1.
  
  replace 
  (Pr (f //\\ (sets bad 1)) st' + Pr (f //\\ (cplt (sets bad 1))) st'' -
    (Pr (f //\\ (sets bad 1)) st'' + Pr (f //\\ (cplt (sets bad 1))) st'')) 
    with
      (Pr (f //\\ (sets bad 1)) st' - (Pr (f //\\ (sets bad 1)) st'')).
  
  rewrite Rmax_refl.
  apply Rdifference_lemma_helper.
  split.
  apply Pr_pos.
  eapply exec_conserv_coeff_pos; eauto.
  apply Pr_inter_le.
  eapply exec_conserv_coeff_pos; eauto.
  
  split.
  apply Pr_pos.
  eapply exec_conserv_coeff_pos; eauto.
  
  assert (Pr (sets bad 1) st' = Pr (sets bad 1) st'').
  eapply (after_bad_is_set_step g b c1 c2 c2' st st st' st''); eauto.
  apply Permutation_refl.
  
  rewrite H2.
  apply Pr_inter_le.
  eapply exec_conserv_coeff_pos; eauto.
  
  field.
Qed.

Lemma simplified_fundamental_lemma : forall g b c1 c2 c2' st st' st'' f bad
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g),
 coeff_pos st ->
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st' ->
   g ||- st -- ifte b c1 (bad <- int_e 1 ; c2') --> st'' -> 
     Rabs (Pr f st' - Pr f st'') <= Pr (sets bad 1) st'.

 intros.

 inversion_clear H0.
 inversion_clear H1.
 rewrite <- H2 in H0.
 subst st_true0.
 rewrite <- H3 in H6.
 subst st_false0.

 assert (Pr (sets bad 1) std0 = Pr (sets bad 1) std).
(* proof using after_bad_is_set *)
 apply sym_eq.
 eapply (after_bad_is_set_step g (int_e 0) skip c2 c2' st_false st_false std std0 bad); eauto.
 simpl; auto.
 rewrite H3; apply coeff_pos_filter; exact H.
 rewrite H3; apply coeff_pos_filter; exact H.
 apply Permutation_refl.
 change std with (nil ++ std).
 eapply exec_ifte.
 simpl.
 rewrite (filter_false st_false).
 reflexivity.
 simpl.
 rewrite (filter_true st_false).
 reflexivity.
 apply exec_skip.
 exact H5.
 change std0 with (nil ++ std0).
 eapply exec_ifte.
 simpl.
 rewrite (filter_false st_false).
 reflexivity.
 simpl.
 rewrite (filter_true st_false).
 reflexivity.
 apply exec_skip.
 exact H8.

 rewrite H2 in H7; rewrite H2 in H4.
 rewrite H3 in H8; rewrite H3 in H5.
 do 2 rewrite Pr_app.

 assert (pos: forall st st' g c e
 (Hpos:coeff_pos st)
 (Hexec:g ||- filter e st --c--> st'),
 coeff_pos st'). (* will be needed several times below *)
 intros.
 eapply exec_conserv_coeff_pos.
 apply Hexec.
 apply coeff_pos_filter; auto.

 cutrewrite ( Pr f stc = Pr f stc0 ).
 cutrewrite (
 Pr f stc0 +
 Pr f std -
 (Pr f stc0 +
  Pr f std0) =
 (Pr f std -
  (Pr f std0))); try field.

(* *)
 rewrite Rmax_refl.
 apply Rdifference_lemma_helper.

 split.
 apply Pr_pos.
 eapply pos; eauto.

 rewrite Pr_app.
 eapply Rle_trans with (Pr (sets bad 1) std).

 assert (Pr (sets bad 1) std = sum std).
 inversion H5.
 generalize sets_preserved; intro HH.
 eapply (HH c2 bad 1%nat g st''0); eauto; clear HH.
 rewrite <- (exec_assign_Pr bad 1 st_false st''0 g); auto.
 rewrite H3; apply H10.
 rewrite H1.
 apply Pr_max.
 apply (pos _ _ _ _ _ H H5).

 pattern (Pr (sets bad 1) std) at 1.
 rewrite <- (Rplus_0_l (Pr (sets bad 1) std)).
 apply Rplus_le_compat_r.
 apply Pr_pos.
 eapply pos; eauto.

 split.
 apply Pr_pos.
 eapply pos; eauto.
 inversion H8.
 rewrite Pr_app.
 eapply Rle_trans with (Pr (sets bad 1) std0).

 assert (Pr (sets bad 1) std0 = sum std0). (* repeat of the above *)
 generalize sets_preserved; intro HH.
 eapply (HH c2' bad 1%nat g st''0); eauto; clear HH.
 rewrite <- (exec_assign_Pr bad 1 st_false st''0 g); auto.
 rewrite H3; apply H10.
 rewrite H13.
 apply Pr_max.
 eapply pos; eauto.

 rewrite <- (Rplus_0_l (Pr (sets bad 1) std0)).
 rewrite H0.
 apply Rplus_le_compat_r.
 apply Pr_pos.
 eapply pos; eauto.

 assert (stc = stc0).
 eapply exec_deter_eq; eauto.
 subst stc0; auto.
Qed.

(* the same lemma as above, but proved using abstract_fundamental_lemma1 in distribution.v *)
Lemma simplified_fundamental_lemma2 : forall g b c1 c2 c2' st st' st'' f bad
 (H_c1: no_assign_cmd bad c1)
 (H_c2: no_assign_cmd bad c2)
 (H_c2': no_assign_cmd bad c2')
 (H_g: no_assign bad g)
 (st_pos: coeff_pos st),
 g ||- st -- ifte b c1 (bad <- int_e 1 ; c2) --> st' ->
   g ||- st -- ifte b c1 (bad <- int_e 1 ; c2') --> st'' ->
     Rabs (Pr f st' - Pr f st'') <= Pr (sets bad 1) st'.
  
intros.
(* some properties shared by all cases *)
assert (Pr (sets bad 1) st' = Pr (sets bad 1) st'').
eapply (after_bad_is_set_step g b c1 c2 c2' st st); eauto.
apply Permutation_refl.

assert (st'_pos: coeff_pos st').
eapply exec_conserv_coeff_pos; eauto.

assert (st''_pos: coeff_pos st'').
eapply exec_conserv_coeff_pos; eauto.

assert( sum st' = sum st'').
rewrite <- (exec_conserv _ _ _ _ H).
rewrite <- (exec_conserv _ _ _ _ H0).
auto.

assert (Pr (cplt (sets bad 1)) st' = Pr (cplt (sets bad 1)) st'').
do 2 rewrite Pr_cplt.
rewrite H1.
rewrite H2.
auto.

(* cases *)
destruct (Rle_lt_or_eq_dec _ _ (Pr_pos st' st'_pos (sets bad 1))).
destruct (Rle_lt_or_eq_dec _ _ (Pr_pos st' st'_pos (cplt (sets bad 1)))); auto.

(* the case when the both divisors are nonzero *)
assert( Pr_cond f (cplt (sets bad 1)) st' = Pr_cond f (cplt (sets bad 1)) st'').
unfold Pr_cond.
do 2 rewrite Pr_cplt.
rewrite H1.
rewrite H2.
assert (Pr (f //\\ (cplt (sets bad 1))) st' = Pr (f //\\(cplt (sets bad 1))) st'').
generalize st'_pos st''_pos.
inversion_clear H.
inversion_clear H0.
intros.
subst st_true st_true0.
rewrite <- (exec_deter_eq _ _ _ _ H6 _ H9).
do 2 rewrite Pr_app.

assert(Pr (inter f (cplt (sets bad 1))) std =
  Pr (inter f (cplt (sets bad 1))) std0).
(*
inversion_clear H7.
inversion_clear H10.
*)


(* analysis for the case bad is set *)
assert (false_eq: st_false = st_false0).
rewrite H5; auto.
intros.

assert (std_pos:coeff_pos std).
apply (coeff_pos_R _ _ st'_pos0).
assert (std0_pos:coeff_pos std0).
apply (coeff_pos_R _ _ st''_pos0).

assert (st_false_pos:coeff_pos st_false).
rewrite H5.
apply coeff_pos_filter; auto.
assert (st_false0_pos:coeff_pos st_false0).
rewrite <- false_eq; auto.

assert (forall a pr, In (pr,a) std -> (sets bad 1) a = true).
intros.
eapply (sum_filter_In std std_pos (sets bad 1)); eauto.
inversion_clear H7.
change (sum (filter (sets bad 1) std)) with (Pr (sets bad 1) std).
rewrite <- (preserves_sets_event _ _ _ _ H4); auto.
rewrite (bad_is_set g st_false st''0 bad H0).
apply (exec_conserv _ _ _ _ H4).
assert (Pr (f //\\ (cplt (sets bad 1))) std = 0).
apply Pr_false.
intros.
unfold inter.
apply andb_false_intro2.
unfold cplt.
apply sym_eq.
apply negb_sym.
eapply H; eauto.

assert (forall a pr, In (pr,a) std0 -> (sets bad 1) a = true).
intros.
eapply (sum_filter_In std0 std0_pos (sets bad 1)); eauto.
inversion_clear H10.
change (sum (filter (sets bad 1) std0)) with (Pr (sets bad 1) std0).
rewrite <- (preserves_sets_event _ _ _ _ H12); auto.
rewrite (bad_is_set g st_false0 st''0 bad H11).
apply (exec_conserv _ _ _ _ H12).
assert (Pr (f //\\ (cplt (sets bad 1))) std0 = 0).
apply Pr_false.
intros.
unfold inter.
apply andb_false_intro2.
unfold cplt.
apply sym_eq.
apply negb_sym.
eapply H4; eauto.
rewrite H0.
rewrite H11; auto.

rewrite H.
auto.

rewrite H4.
auto.

assert (Pr (cplt (sets bad 1)) st' <> 0).
apply Rgt_not_eq; auto.
assert( Pr (cplt (sets bad 1)) st'' <> 0).
rewrite <- H3; auto.

eapply abstract_fundamental_lemma1; eauto.

(* the rest of the cases *)
(* the case Pr (negb _) st' = 0 *)
rewrite Pr_cplt in e.
rewrite <- (Rminus_diag_uniq _ _ (sym_eq e)).
rewrite Rmax_refl.
apply Rdifference_lemma_helper; split; try (  apply Pr_pos || apply Pr_max); auto.
rewrite H2.
apply Pr_max.
auto.

(* the case Pr (_) st' = 0 *)
rewrite <- e in H1.
assert (Pr (cplt (sets bad 1)) st' = sum st').
rewrite Pr_cplt.
rewrite <- e; auto with real.
assert (Pr (cplt (sets bad 1)) st'' = sum st'').
rewrite Pr_cplt.
rewrite <- H1; auto with real.

(* st' = st'' should hold *)
generalize H1 st'_pos st''_pos H2 H3 e H4 H5.
clear H1 H2 H3 e H4 H5.
inversion_clear H.
inversion_clear H0.
intros.
(**)
assert (false_eq: st_false = st_false0).
rewrite H2; auto.

assert (std_pos:coeff_pos std).
apply (coeff_pos_R _ _ st'_pos0).
assert (std0_pos:coeff_pos std0).
apply (coeff_pos_R _ _ st''_pos0).

assert (st_false_pos:coeff_pos st_false).
rewrite H2.
apply coeff_pos_filter; auto.
assert (st_false0_pos:coeff_pos st_false0).
rewrite <- false_eq; auto.
(**)

assert (Pr (sets bad 1) stc = 0 /\ Pr (sets bad 1) std = 0).
rewrite Pr_app in e.
apply Rplus_eq_R0; auto.
apply Pr_pos.
apply (coeff_pos_L _ _ st'_pos0).
apply Pr_pos; auto.
inversion_clear H12.

assert (Pr (sets bad 1) stc0 = 0 /\ Pr (sets bad 1) std0 = 0).
rewrite Pr_app in H0.
apply Rplus_eq_R0; auto.
apply Pr_pos.
apply (coeff_pos_L _ _ st''_pos0).
apply Pr_pos; auto.
inversion_clear H12.

assert (sum std = 0).
inversion H4.
rewrite <- (exec_conserv _ _ _ _ H21).
rewrite <- (preserves_sets_event _ _ _ _ H21) in H14; auto.
rewrite (bad_is_set _ _ _ _ H19) in H14; auto.

assert (sum std0 = 0).
inversion H7.
rewrite <- (exec_conserv _ _ _ _ H22).
rewrite <- (preserves_sets_event _ _ _ _ H22) in H16; auto.
rewrite (bad_is_set _ _ _ _ H20) in H16; auto.

assert (std = nil).
apply (sum_nil _ std_pos H12).
assert (std0 = nil).
apply (sum_nil _ std0_pos H17).

subst std std0.
subst st_true st_true0.
rewrite <- (exec_deter_eq _ _ _ _ H3 _ H6 ).
rewrite <- e.
rewrite Rminus_diag_eq; auto.
rewrite Rabs_R0; auto.
auto with real.
Qed.

(* the first version we wrote down *)
Lemma simplified_fundamental_lemma0 : forall b c1 c2 c2' st st' st'' f,
 coeff_pos st ->
 NatMap.empty cmd ||- st -- ifte b c1 c2 --> st' ->
   NatMap.empty cmd ||- st -- ifte b c1 c2' --> st'' ->
     Rabs (Pr f st' - Pr f st'') <= Pr (fun s => beq_nat (eval b s) 0) st.
intros.
intros.
inversion_clear H0.
inversion_clear H1.
assert (st_true = st_true0).
rewrite H2; auto.
subst st_true0; clear H1.
assert (st_false = st_false0).
rewrite H6; auto.
subst st_false0; clear H0.
rewrite <-H2 in H7.
rewrite <-H3 in H8.
do 2 rewrite Pr_app.
assert (Pr f stc = Pr f stc0).
assert (stc = stc0).
eapply exec_deter_eq; eauto.
subst stc0; auto.
rewrite H0.
cutrewrite (
 Pr f stc0 + Pr f std -
 (Pr f stc0 + Pr f std0) =
 (Pr f std - (Pr f std0))); try field.

rewrite Rmax_refl.
apply Rdifference_lemma_helper.
split.
apply Pr_pos.
eapply exec_conserv_coeff_pos.
apply H5.
rewrite H3.
eapply coeff_pos_filter.
auto.
eapply Rle_trans with (sum std).
apply Pr_max.
eapply exec_conserv_coeff_pos.
apply H5.
rewrite H3.
eapply coeff_pos_filter.
auto.
apply Req_le.
symmetry.
unfold Pr.
eapply exec_conserv.
rewrite <-H3.
apply H5.
split.
apply Pr_pos.
eapply exec_conserv_coeff_pos.
apply H8.
rewrite H3.
eapply coeff_pos_filter.
auto.
eapply Rle_trans with (sum std0).
apply Pr_max.
eapply exec_conserv_coeff_pos.
apply H8.
rewrite H3.
eapply coeff_pos_filter.
auto.
apply Req_le.
symmetry.
unfold Pr.
rewrite <-H3.
eapply exec_conserv.
apply H8.
Qed.

